/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp.dao;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;

@XmlRootElement(name="userMetrics")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class UserMetricsInfo {
    protected int appsSubmitted;
    protected int appsCompleted;
    protected int appsPending;
    protected int appsRunning;
    protected int appsFailed;
    protected int appsKilled;
    protected int runningContainers;
    protected int pendingContainers;
    protected int reservedContainers;
    protected long reservedMB;
    protected long pendingMB;
    protected long allocatedMB;
    protected long reservedVirtualCores;
    protected long pendingVirtualCores;
    protected long allocatedVirtualCores;
    protected long reservedGPUs;
    protected long pendingGPUs;
    protected long allocatedGPUs;
    @XmlTransient
    protected boolean userMetricsAvailable;

    public UserMetricsInfo() {
    }

    public UserMetricsInfo(ResourceManager rm, String user) {
        ResourceScheduler rs = rm.getResourceScheduler();
        QueueMetrics metrics = rs.getRootQueueMetrics();
        QueueMetrics userMetrics = metrics.getUserMetrics(user);
        this.userMetricsAvailable = false;
        if (userMetrics != null) {
            this.userMetricsAvailable = true;
            this.appsSubmitted = userMetrics.getAppsSubmitted();
            this.appsCompleted = userMetrics.getAppsCompleted();
            this.appsPending = userMetrics.getAppsPending();
            this.appsRunning = userMetrics.getAppsRunning();
            this.appsFailed = userMetrics.getAppsFailed();
            this.appsKilled = userMetrics.getAppsKilled();
            this.runningContainers = userMetrics.getAllocatedContainers();
            this.pendingContainers = userMetrics.getPendingContainers();
            this.reservedContainers = userMetrics.getReservedContainers();
            this.reservedMB = userMetrics.getReservedMB();
            this.pendingMB = userMetrics.getPendingMB();
            this.allocatedMB = userMetrics.getAllocatedMB();
            this.reservedVirtualCores = userMetrics.getReservedVirtualCores();
            this.pendingVirtualCores = userMetrics.getPendingVirtualCores();
            this.allocatedVirtualCores = userMetrics.getAllocatedVirtualCores();
            this.reservedGPUs = userMetrics.getReservedGPUs();
            this.pendingGPUs = userMetrics.getPendingGPUs();
            this.allocatedGPUs = userMetrics.getAllocatedGPUs();
        }
    }

    public boolean metricsAvailable() {
        return this.userMetricsAvailable;
    }

    public int getAppsSubmitted() {
        return this.appsSubmitted;
    }

    public int getAppsCompleted() {
        return this.appsCompleted;
    }

    public int getAppsPending() {
        return this.appsPending;
    }

    public int getAppsRunning() {
        return this.appsRunning;
    }

    public int getAppsFailed() {
        return this.appsFailed;
    }

    public int getAppsKilled() {
        return this.appsKilled;
    }

    public long getReservedMB() {
        return this.reservedMB;
    }

    public long getAllocatedMB() {
        return this.allocatedMB;
    }

    public long getPendingMB() {
        return this.pendingMB;
    }

    public long getReservedVirtualCores() {
        return this.reservedVirtualCores;
    }

    public long getAllocatedVirtualCores() {
        return this.allocatedVirtualCores;
    }

    public long getPendingVirtualCores() {
        return this.pendingVirtualCores;
    }

    public long getReservedGPUs() {
        return this.reservedGPUs;
    }

    public long getAllocatedGPUs() {
        return this.allocatedGPUs;
    }

    public long getPendingGPUs() {
        return this.pendingGPUs;
    }

    public int getReservedContainers() {
        return this.reservedContainers;
    }

    public int getRunningContainers() {
        return this.runningContainers;
    }

    public int getPendingContainers() {
        return this.pendingContainers;
    }
}

