/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.api.protocolrecords.NMContainerStatus;
import org.apache.hadoop.yarn.server.api.protocolrecords.NodeHeartbeatRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.NodeHeartbeatResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RegisterNodeManagerRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RegisterNodeManagerResponse;
import org.apache.hadoop.yarn.server.api.records.MasterKey;
import org.apache.hadoop.yarn.server.api.records.NodeHealthStatus;
import org.apache.hadoop.yarn.server.api.records.NodeStatus;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceTrackerService;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.Records;
import org.apache.hadoop.yarn.util.YarnVersionInfo;
import org.mortbay.log.Log;

public class MockNM {
    private int responseId;
    private NodeId nodeId;
    private long memory;
    private int vCores;
    private final int gpus;
    private ResourceTrackerService resourceTracker;
    private int httpPort = 2;
    private MasterKey currentContainerTokenMasterKey;
    private MasterKey currentNMTokenMasterKey;
    private String version;
    private Map<ContainerId, ContainerStatus> containerStats = new HashMap<ContainerId, ContainerStatus>();

    public MockNM(String nodeIdStr, int memory, ResourceTrackerService resourceTracker) {
        this(nodeIdStr, memory, Math.max(1, memory * 8 / 8192), resourceTracker);
    }

    public MockNM(String nodeIdStr, int memory, int vcores, ResourceTrackerService resourceTracker) {
        this(nodeIdStr, memory, vcores, 0, resourceTracker, YarnVersionInfo.getVersion());
    }

    public MockNM(String nodeIdStr, int memory, int vcores, int gpus, ResourceTrackerService resourceTracker) {
        this(nodeIdStr, memory, vcores, gpus, resourceTracker, YarnVersionInfo.getVersion());
    }

    public MockNM(String nodeIdStr, int memory, int vcores, int gpus, ResourceTrackerService resourceTracker, String version) {
        this.memory = memory;
        this.vCores = vcores;
        this.gpus = gpus;
        this.resourceTracker = resourceTracker;
        this.version = version;
        String[] splits = nodeIdStr.split(":");
        this.nodeId = BuilderUtils.newNodeId((String)splits[0], (int)Integer.parseInt(splits[1]));
    }

    public NodeId getNodeId() {
        return this.nodeId;
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public void setHttpPort(int port) {
        this.httpPort = port;
    }

    public void setResourceTrackerService(ResourceTrackerService resourceTracker) {
        this.resourceTracker = resourceTracker;
    }

    public void containerStatus(ContainerStatus containerStatus) throws Exception {
        HashMap<ApplicationId, List<ContainerStatus>> conts = new HashMap<ApplicationId, List<ContainerStatus>>();
        conts.put(containerStatus.getContainerId().getApplicationAttemptId().getApplicationId(), Arrays.asList(containerStatus));
        this.nodeHeartbeat(conts, true);
    }

    public void containerIncreaseStatus(Container container) throws Exception {
        ContainerStatus containerStatus = BuilderUtils.newContainerStatus((ContainerId)container.getId(), (ContainerState)ContainerState.RUNNING, (String)"Success", (int)0, (Resource)container.getResource());
        List<Container> increasedConts = Collections.singletonList(container);
        this.nodeHeartbeat(Collections.singletonList(containerStatus), increasedConts, true, ++this.responseId);
    }

    public RegisterNodeManagerResponse registerNode() throws Exception {
        return this.registerNode(null, null);
    }

    public RegisterNodeManagerResponse registerNode(Map<ApplicationId, Integer> runningApplications) throws Exception {
        return this.registerNode(null, runningApplications);
    }

    public RegisterNodeManagerResponse registerNode(List<NMContainerStatus> containerReports, Map<ApplicationId, Integer> runningApplications) throws Exception {
        Resource newResource;
        RegisterNodeManagerRequest req = (RegisterNodeManagerRequest)Records.newRecord(RegisterNodeManagerRequest.class);
        req.setNodeId(this.nodeId);
        req.setHttpPort(this.httpPort);
        Resource resource = BuilderUtils.newResource((long)this.memory, (int)this.vCores, (int)this.gpus);
        req.setResource(resource);
        req.setContainerStatuses(containerReports);
        req.setNMVersion(this.version);
        req.setRunningApplications(runningApplications);
        RegisterNodeManagerResponse registrationResponse = this.resourceTracker.registerNodeManager(req);
        this.currentContainerTokenMasterKey = registrationResponse.getContainerTokenMasterKey();
        this.currentNMTokenMasterKey = registrationResponse.getNMTokenMasterKey();
        this.containerStats.clear();
        if (containerReports != null) {
            for (NMContainerStatus report : containerReports) {
                if (report.getContainerState() == ContainerState.COMPLETE) continue;
                this.containerStats.put(report.getContainerId(), ContainerStatus.newInstance((ContainerId)report.getContainerId(), (ContainerState)report.getContainerState(), (String)report.getDiagnostics(), (int)report.getContainerExitStatus()));
            }
        }
        if ((newResource = registrationResponse.getResource()) != null) {
            this.memory = newResource.getMemory();
            this.vCores = newResource.getVirtualCores();
        }
        return registrationResponse;
    }

    public NodeHeartbeatResponse nodeHeartbeat(boolean isHealthy) throws Exception {
        return this.nodeHeartbeat(Collections.emptyList(), Collections.emptyList(), isHealthy, ++this.responseId);
    }

    public NodeHeartbeatResponse nodeHeartbeat(ApplicationAttemptId attemptId, long containerId, ContainerState containerState) throws Exception {
        ContainerStatus containerStatus = BuilderUtils.newContainerStatus((ContainerId)BuilderUtils.newContainerId((ApplicationAttemptId)attemptId, (long)containerId), (ContainerState)containerState, (String)"Success", (int)0, (Resource)BuilderUtils.newResource((long)this.memory, (int)this.vCores));
        ArrayList<ContainerStatus> containerStatusList = new ArrayList<ContainerStatus>(1);
        containerStatusList.add(containerStatus);
        Log.info((String)("ContainerStatus: " + containerStatus));
        return this.nodeHeartbeat(containerStatusList, Collections.emptyList(), true, ++this.responseId);
    }

    public NodeHeartbeatResponse nodeHeartbeat(Map<ApplicationId, List<ContainerStatus>> conts, boolean isHealthy) throws Exception {
        return this.nodeHeartbeat(conts, isHealthy, ++this.responseId);
    }

    public NodeHeartbeatResponse nodeHeartbeat(Map<ApplicationId, List<ContainerStatus>> conts, boolean isHealthy, int resId) throws Exception {
        ArrayList<ContainerStatus> updatedStats = new ArrayList<ContainerStatus>();
        for (List<ContainerStatus> stats : conts.values()) {
            updatedStats.addAll(stats);
        }
        return this.nodeHeartbeat(updatedStats, Collections.emptyList(), isHealthy, resId);
    }

    public NodeHeartbeatResponse nodeHeartbeat(List<ContainerStatus> updatedStats, List<Container> increasedConts, boolean isHealthy, int resId) throws Exception {
        return this.nodeHeartbeat(updatedStats, increasedConts, isHealthy, resId, new HashSet<ApplicationId>());
    }

    public NodeHeartbeatResponse nodeHeartbeat(List<ContainerStatus> updatedStats, List<Container> increasedConts, boolean isHealthy, int resId, Set<ApplicationId> updatedCryptoApps) throws Exception {
        Resource newResource;
        NodeHeartbeatResponse heartbeatResponse;
        MasterKey masterKeyFromRM;
        NodeHeartbeatRequest req = (NodeHeartbeatRequest)Records.newRecord(NodeHeartbeatRequest.class);
        NodeStatus status = (NodeStatus)Records.newRecord(NodeStatus.class);
        status.setResponseId(resId);
        status.setNodeId(this.nodeId);
        ArrayList<ContainerId> completedContainers = new ArrayList<ContainerId>();
        for (ContainerStatus stat : updatedStats) {
            if (stat.getState() == ContainerState.COMPLETE) {
                completedContainers.add(stat.getContainerId());
            }
            this.containerStats.put(stat.getContainerId(), stat);
        }
        status.setContainersStatuses(new ArrayList<ContainerStatus>(this.containerStats.values()));
        for (ContainerId cid : completedContainers) {
            this.containerStats.remove(cid);
        }
        status.setIncreasedContainers(increasedConts);
        NodeHealthStatus healthStatus = (NodeHealthStatus)Records.newRecord(NodeHealthStatus.class);
        healthStatus.setHealthReport("");
        healthStatus.setIsNodeHealthy(isHealthy);
        healthStatus.setLastHealthReportTime(1L);
        status.setNodeHealthStatus(healthStatus);
        req.setNodeStatus(status);
        req.setLastKnownContainerTokenMasterKey(this.currentContainerTokenMasterKey);
        req.setLastKnownNMTokenMasterKey(this.currentNMTokenMasterKey);
        if (updatedCryptoApps != null) {
            req.setUpdatedApplicationsWithNewCryptoMaterial(updatedCryptoApps);
        }
        if ((masterKeyFromRM = (heartbeatResponse = this.resourceTracker.nodeHeartbeat(req)).getContainerTokenMasterKey()) != null && masterKeyFromRM.getKeyId() != this.currentContainerTokenMasterKey.getKeyId()) {
            this.currentContainerTokenMasterKey = masterKeyFromRM;
        }
        if ((masterKeyFromRM = heartbeatResponse.getNMTokenMasterKey()) != null && masterKeyFromRM.getKeyId() != this.currentNMTokenMasterKey.getKeyId()) {
            this.currentNMTokenMasterKey = masterKeyFromRM;
        }
        if ((newResource = heartbeatResponse.getResource()) != null) {
            this.memory = newResource.getMemory();
            this.vCores = newResource.getVirtualCores();
        }
        return heartbeatResponse;
    }

    public long getMemory() {
        return this.memory;
    }

    public int getvCores() {
        return this.vCores;
    }

    public int getGpus() {
        return this.gpus;
    }

    public String getVersion() {
        return this.version;
    }

    public int getNextResponseId() {
        return ++this.responseId;
    }
}

