/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import com.google.protobuf.BlockingService;
import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.CallerContext;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.ipc.TestRpcBase;
import org.apache.hadoop.ipc.protobuf.TestProtos;
import org.apache.hadoop.ipc.protobuf.TestRpcServiceProtos;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.server.resourcemanager.RMAuditLogger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestRMAuditLogger {
    private static final String USER = "test";
    private static final String OPERATION = "oper";
    private static final String TARGET = "tgt";
    private static final String PERM = "admin group";
    private static final String DESC = "description of an audit log";
    private static final ApplicationId APPID = (ApplicationId)Mockito.mock(ApplicationId.class);
    private static final ApplicationAttemptId ATTEMPTID = (ApplicationAttemptId)Mockito.mock(ApplicationAttemptId.class);
    private static final ContainerId CONTAINERID = (ContainerId)Mockito.mock(ContainerId.class);
    private static final String CALLER_CONTEXT = "context";
    private static final byte[] CALLER_SIGNATURE = "signature".getBytes();

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)APPID.toString()).thenReturn((Object)"app_1");
        Mockito.when((Object)ATTEMPTID.toString()).thenReturn((Object)"app_attempt_1");
        Mockito.when((Object)CONTAINERID.toString()).thenReturn((Object)"container_1");
    }

    @Test
    public void testKeyValLogFormat() throws Exception {
        StringBuilder actLog = new StringBuilder();
        StringBuilder expLog = new StringBuilder();
        RMAuditLogger.start((RMAuditLogger.Keys)RMAuditLogger.Keys.USER, (String)USER, (StringBuilder)actLog);
        expLog.append("USER=test");
        Assert.assertEquals((Object)expLog.toString(), (Object)actLog.toString());
        RMAuditLogger.add((RMAuditLogger.Keys)RMAuditLogger.Keys.OPERATION, (String)OPERATION, (StringBuilder)actLog);
        expLog.append("\tOPERATION=oper");
        Assert.assertEquals((Object)expLog.toString(), (Object)actLog.toString());
        RMAuditLogger.add((RMAuditLogger.Keys)RMAuditLogger.Keys.APPID, (String)null, (StringBuilder)actLog);
        expLog.append("\tAPPID=null");
        Assert.assertEquals((Object)expLog.toString(), (Object)actLog.toString());
        RMAuditLogger.add((RMAuditLogger.Keys)RMAuditLogger.Keys.TARGET, (String)TARGET, (StringBuilder)actLog);
        expLog.append("\tTARGET=tgt");
        Assert.assertEquals((Object)expLog.toString(), (Object)actLog.toString());
    }

    private void testSuccessLogFormatHelper(boolean checkIP, ApplicationId appId, ApplicationAttemptId attemptId, ContainerId containerId) {
        this.testSuccessLogFormatHelper(checkIP, appId, attemptId, containerId, null);
    }

    private void testSuccessLogFormatHelper(boolean checkIP, ApplicationId appId, ApplicationAttemptId attemptId, ContainerId containerId, CallerContext callerContext) {
        this.testSuccessLogFormatHelper(checkIP, appId, attemptId, containerId, callerContext, Server.getRemoteIp());
    }

    private void testSuccessLogFormatHelper(boolean checkIP, ApplicationId appId, ApplicationAttemptId attemptId, ContainerId containerId, CallerContext callerContext, InetAddress remoteIp) {
        String sLog = checkIP ? RMAuditLogger.createSuccessLog((String)USER, (String)OPERATION, (String)TARGET, (ApplicationId)appId, (ApplicationAttemptId)attemptId, (ContainerId)containerId, (CallerContext)callerContext, (InetAddress)remoteIp) : RMAuditLogger.createSuccessLog((String)USER, (String)OPERATION, (String)TARGET, (ApplicationId)appId, (ApplicationAttemptId)attemptId, (ContainerId)containerId, (CallerContext)callerContext, null);
        StringBuilder expLog = new StringBuilder();
        expLog.append("USER=test\t");
        if (checkIP) {
            InetAddress ip = remoteIp != null ? remoteIp : Server.getRemoteIp();
            expLog.append(RMAuditLogger.Keys.IP.name() + "=" + ip.getHostAddress() + "\t");
        }
        expLog.append("OPERATION=oper\tTARGET=tgt\tRESULT=SUCCESS");
        if (appId != null) {
            expLog.append("\tAPPID=app_1");
        }
        if (attemptId != null) {
            expLog.append("\tAPPATTEMPTID=app_attempt_1");
        }
        if (containerId != null) {
            expLog.append("\tCONTAINERID=container_1");
        }
        if (callerContext != null) {
            if (callerContext.getContext() != null) {
                expLog.append("\tCALLERCONTEXT=context");
            }
            if (callerContext.getSignature() != null) {
                expLog.append("\tCALLERSIGNATURE=signature");
            }
        }
        Assert.assertEquals((Object)expLog.toString(), (Object)sLog);
    }

    private void testSuccessLogFormatHelperWithIP(boolean checkIP, ApplicationId appId, ApplicationAttemptId attemptId, ContainerId containerId, InetAddress ip) {
        this.testSuccessLogFormatHelper(checkIP, appId, attemptId, containerId, null, ip);
    }

    private void testSuccessLogNulls(boolean checkIP) {
        String sLog = RMAuditLogger.createSuccessLog(null, null, null, null, null, null);
        StringBuilder expLog = new StringBuilder();
        expLog.append("USER=null\t");
        if (checkIP) {
            InetAddress ip = Server.getRemoteIp();
            expLog.append(RMAuditLogger.Keys.IP.name() + "=" + ip.getHostAddress() + "\t");
        }
        expLog.append("OPERATION=null\tTARGET=null\tRESULT=SUCCESS");
        Assert.assertEquals((Object)expLog.toString(), (Object)sLog);
    }

    private void testSuccessLogFormatHelperWithIP(boolean checkIP, ApplicationId appId, ApplicationAttemptId attemptId, ContainerId containerId) {
        this.testSuccessLogFormatHelperWithIP(checkIP, appId, attemptId, containerId, InetAddress.getLoopbackAddress());
        byte[] ipAddr = new byte[]{100, 10, 10, 1};
        InetAddress addr = null;
        try {
            addr = InetAddress.getByAddress(ipAddr);
        }
        catch (UnknownHostException uhe) {
            Assert.fail((String)"Check ip address being constructed");
        }
        this.testSuccessLogFormatHelperWithIP(checkIP, appId, attemptId, containerId, addr);
    }

    private void testSuccessLogFormat(boolean checkIP) {
        this.testSuccessLogFormatHelper(checkIP, null, null, null);
        this.testSuccessLogFormatHelper(checkIP, APPID, null, null);
        this.testSuccessLogFormatHelper(checkIP, null, null, CONTAINERID);
        this.testSuccessLogFormatHelper(checkIP, null, ATTEMPTID, null);
        this.testSuccessLogFormatHelper(checkIP, APPID, ATTEMPTID, null);
        this.testSuccessLogFormatHelper(checkIP, APPID, null, CONTAINERID);
        this.testSuccessLogFormatHelper(checkIP, null, ATTEMPTID, CONTAINERID);
        this.testSuccessLogFormatHelper(checkIP, APPID, ATTEMPTID, CONTAINERID);
        this.testSuccessLogFormatHelper(checkIP, APPID, ATTEMPTID, CONTAINERID, null);
        this.testSuccessLogFormatHelper(checkIP, APPID, ATTEMPTID, CONTAINERID, new CallerContext.Builder(null).setSignature(null).build());
        this.testSuccessLogFormatHelper(checkIP, APPID, ATTEMPTID, CONTAINERID, new CallerContext.Builder(CALLER_CONTEXT).setSignature(null).build());
        this.testSuccessLogFormatHelper(checkIP, APPID, ATTEMPTID, CONTAINERID, new CallerContext.Builder(null).setSignature(CALLER_SIGNATURE).build());
        this.testSuccessLogFormatHelper(checkIP, APPID, ATTEMPTID, CONTAINERID, new CallerContext.Builder(CALLER_CONTEXT).setSignature(CALLER_SIGNATURE).build());
        this.testSuccessLogFormatHelperWithIP(checkIP, APPID, ATTEMPTID, CONTAINERID);
        this.testSuccessLogNulls(checkIP);
    }

    private void testFailureLogFormatHelper(boolean checkIP, ApplicationId appId, ApplicationAttemptId attemptId, ContainerId containerId) {
        this.testFailureLogFormatHelper(checkIP, appId, attemptId, containerId, null);
    }

    private void testFailureLogFormatHelper(boolean checkIP, ApplicationId appId, ApplicationAttemptId attemptId, ContainerId containerId, CallerContext callerContext) {
        String fLog = RMAuditLogger.createFailureLog((String)USER, (String)OPERATION, (String)PERM, (String)TARGET, (String)DESC, (ApplicationId)appId, (ApplicationAttemptId)attemptId, (ContainerId)containerId, (CallerContext)callerContext);
        StringBuilder expLog = new StringBuilder();
        expLog.append("USER=test\t");
        if (checkIP) {
            InetAddress ip = Server.getRemoteIp();
            expLog.append(RMAuditLogger.Keys.IP.name() + "=" + ip.getHostAddress() + "\t");
        }
        expLog.append("OPERATION=oper\tTARGET=tgt\tRESULT=FAILURE\t");
        expLog.append("DESCRIPTION=description of an audit log");
        expLog.append("\tPERMISSIONS=admin group");
        if (appId != null) {
            expLog.append("\tAPPID=app_1");
        }
        if (attemptId != null) {
            expLog.append("\tAPPATTEMPTID=app_attempt_1");
        }
        if (containerId != null) {
            expLog.append("\tCONTAINERID=container_1");
        }
        if (callerContext != null) {
            if (callerContext.getContext() != null) {
                expLog.append("\tCALLERCONTEXT=context");
            }
            if (callerContext.getSignature() != null) {
                expLog.append("\tCALLERSIGNATURE=signature");
            }
        }
        Assert.assertEquals((Object)expLog.toString(), (Object)fLog);
    }

    private void testFailureLogFormat(boolean checkIP) {
        this.testFailureLogFormatHelper(checkIP, null, null, null);
        this.testFailureLogFormatHelper(checkIP, APPID, null, null);
        this.testFailureLogFormatHelper(checkIP, null, null, CONTAINERID);
        this.testFailureLogFormatHelper(checkIP, null, ATTEMPTID, null);
        this.testFailureLogFormatHelper(checkIP, APPID, ATTEMPTID, null);
        this.testFailureLogFormatHelper(checkIP, APPID, null, CONTAINERID);
        this.testFailureLogFormatHelper(checkIP, null, ATTEMPTID, CONTAINERID);
        this.testFailureLogFormatHelper(checkIP, APPID, ATTEMPTID, CONTAINERID);
        this.testFailureLogFormatHelper(checkIP, APPID, ATTEMPTID, CONTAINERID, new CallerContext.Builder(null).setSignature(null).build());
        this.testFailureLogFormatHelper(checkIP, APPID, ATTEMPTID, CONTAINERID, new CallerContext.Builder(CALLER_CONTEXT).setSignature(null).build());
        this.testFailureLogFormatHelper(checkIP, APPID, ATTEMPTID, CONTAINERID, new CallerContext.Builder(null).setSignature(CALLER_SIGNATURE).build());
        this.testFailureLogFormatHelper(checkIP, APPID, ATTEMPTID, CONTAINERID, new CallerContext.Builder(CALLER_CONTEXT).setSignature(CALLER_SIGNATURE).build());
    }

    @Test
    public void testRMAuditLoggerWithoutIP() throws Exception {
        this.testSuccessLogFormat(false);
        this.testFailureLogFormat(false);
    }

    @Test
    public void testRMAuditLoggerWithIP() throws Exception {
        Configuration conf = new Configuration();
        RPC.setProtocolEngine((Configuration)conf, TestRpcBase.TestRpcService.class, ProtobufRpcEngine.class);
        MyTestRPCServer serverImpl = new MyTestRPCServer();
        BlockingService service = TestRpcServiceProtos.TestProtobufRpcProto.newReflectiveBlockingService((TestRpcServiceProtos.TestProtobufRpcProto.BlockingInterface)serverImpl);
        RPC.Server server = new RPC.Builder(conf).setProtocol(TestRpcBase.TestRpcService.class).setInstance((Object)service).setBindAddress("0.0.0.0").setPort(0).setNumHandlers(5).setVerbose(true).build();
        server.start();
        InetSocketAddress addr = NetUtils.getConnectAddress((Server)server);
        TestRpcBase.TestRpcService proxy = (TestRpcBase.TestRpcService)RPC.getProxy(TestRpcBase.TestRpcService.class, (long)1L, (InetSocketAddress)addr, (Configuration)conf);
        TestProtos.EmptyRequestProto pingRequest = TestProtos.EmptyRequestProto.newBuilder().build();
        proxy.ping(null, pingRequest);
        server.stop();
        RPC.stopProxy((Object)proxy);
    }

    private class MyTestRPCServer
    extends TestRpcBase.PBServerImpl {
        private MyTestRPCServer() {
        }

        public TestProtos.EmptyResponseProto ping(RpcController unused, TestProtos.EmptyRequestProto request) throws ServiceException {
            byte[] clientId = Server.getClientId();
            Assert.assertNotNull((Object)clientId);
            Assert.assertEquals((long)16L, (long)clientId.length);
            TestRMAuditLogger.this.testSuccessLogFormat(true);
            TestRMAuditLogger.this.testFailureLogFormat(true);
            return TestProtos.EmptyResponseProto.newBuilder().build();
        }
    }
}

