/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fifo;

import io.hops.util.DBUtility;
import io.hops.util.RMStorageFactory;
import io.hops.util.YarnAPIStorageFactory;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceOption;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.AsyncDispatcher;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.event.InlineDispatcher;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.server.api.protocolrecords.UpdateNodeResourceRequest;
import org.apache.hadoop.yarn.server.resourcemanager.Application;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNodes;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.NodeManager;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.RMContextImpl;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.Task;
import org.apache.hadoop.yarn.server.resourcemanager.ahs.RMApplicationHistoryWriter;
import org.apache.hadoop.yarn.server.resourcemanager.metrics.SystemMetricsPublisher;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.NullRMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.resource.Priority;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeResourceUpdateEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AbstractYarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Allocation;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerAppReport;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNodeReport;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.TestSchedulerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAttemptAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeResourceUpdateSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeUpdateSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fifo.FifoScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.security.NMTokenSecretManagerInRM;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMContainerTokenSecretManager;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestFifoScheduler {
    private static final Log LOG = LogFactory.getLog(TestFifoScheduler.class);
    private final int GB = 1024;
    private ResourceManager resourceManager = null;
    private static Configuration conf;
    private static final RecordFactory recordFactory;

    @Before
    public void setUp() throws Exception {
        conf = new Configuration();
        conf.setClass("yarn.resourcemanager.scheduler.class", FifoScheduler.class, ResourceScheduler.class);
        RMStorageFactory.setConfiguration((Configuration)conf);
        YarnAPIStorageFactory.setConfiguration((Configuration)conf);
        DBUtility.InitializeDB();
        this.resourceManager = new MockRM(conf);
    }

    @After
    public void tearDown() throws Exception {
        this.resourceManager.stop();
    }

    private NodeManager registerNode(String hostName, int containerManagerPort, int nmHttpPort, String rackName, Resource capability) throws IOException, YarnException {
        NodeManager nm = new NodeManager(hostName, containerManagerPort, nmHttpPort, rackName, capability, this.resourceManager);
        NodeAddedSchedulerEvent nodeAddEvent1 = new NodeAddedSchedulerEvent((RMNode)this.resourceManager.getRMContext().getRMNodes().get(nm.getNodeId()));
        this.resourceManager.getResourceScheduler().handle((Event)nodeAddEvent1);
        return nm;
    }

    private ApplicationAttemptId createAppAttemptId(int appId, int attemptId) {
        ApplicationId appIdImpl = ApplicationId.newInstance((long)0L, (int)appId);
        ApplicationAttemptId attId = ApplicationAttemptId.newInstance((ApplicationId)appIdImpl, (int)attemptId);
        return attId;
    }

    private ResourceRequest createResourceRequest(int memory, String host, int priority2, int numContainers) {
        ResourceRequest request = (ResourceRequest)recordFactory.newRecordInstance(ResourceRequest.class);
        request.setCapability(Resources.createResource((int)memory));
        request.setResourceName(host);
        request.setNumContainers(numContainers);
        org.apache.hadoop.yarn.api.records.Priority prio = (org.apache.hadoop.yarn.api.records.Priority)recordFactory.newRecordInstance(org.apache.hadoop.yarn.api.records.Priority.class);
        prio.setPriority(priority2);
        request.setPriority(prio);
        return request;
    }

    @Test(timeout=5000L)
    public void testFifoSchedulerCapacityWhenNoNMs() {
        FifoScheduler scheduler = new FifoScheduler();
        QueueInfo queueInfo = scheduler.getQueueInfo(null, false, false);
        Assert.assertEquals((float)0.0f, (float)queueInfo.getCurrentCapacity(), (float)0.0f);
    }

    @Test(timeout=5000L)
    public void testAppAttemptMetrics() throws Exception {
        InlineDispatcher dispatcher = new InlineDispatcher();
        FifoScheduler scheduler = new FifoScheduler();
        RMApplicationHistoryWriter writer = (RMApplicationHistoryWriter)Mockito.mock(RMApplicationHistoryWriter.class);
        RMContextImpl rmContext = new RMContextImpl((Dispatcher)dispatcher, null, null, null, null, null, null, null, null, (ResourceScheduler)scheduler);
        rmContext.setSystemMetricsPublisher((SystemMetricsPublisher)Mockito.mock(SystemMetricsPublisher.class));
        Configuration conf = new Configuration();
        rmContext.setScheduler((ResourceScheduler)scheduler);
        scheduler.setRMContext((RMContext)rmContext);
        scheduler.init(conf);
        scheduler.start();
        scheduler.reinitialize(conf, (RMContext)rmContext);
        QueueMetrics metrics = scheduler.getRootQueueMetrics();
        int beforeAppsSubmitted = metrics.getAppsSubmitted();
        ApplicationId appId = BuilderUtils.newApplicationId((long)200L, (int)1);
        ApplicationAttemptId appAttemptId = BuilderUtils.newApplicationAttemptId((ApplicationId)appId, (int)1);
        AppAddedSchedulerEvent appEvent = new AppAddedSchedulerEvent(appId, "queue", "user");
        scheduler.handle((SchedulerEvent)appEvent);
        AppAttemptAddedSchedulerEvent attemptEvent = new AppAttemptAddedSchedulerEvent(appAttemptId, false);
        scheduler.handle((SchedulerEvent)attemptEvent);
        appAttemptId = BuilderUtils.newApplicationAttemptId((ApplicationId)appId, (int)2);
        AppAttemptAddedSchedulerEvent attemptEvent2 = new AppAttemptAddedSchedulerEvent(appAttemptId, false);
        scheduler.handle((SchedulerEvent)attemptEvent2);
        int afterAppsSubmitted = metrics.getAppsSubmitted();
        Assert.assertEquals((long)1L, (long)(afterAppsSubmitted - beforeAppsSubmitted));
        scheduler.stop();
    }

    @Test(timeout=2000L)
    public void testNodeLocalAssignment() throws Exception {
        InlineDispatcher dispatcher = new InlineDispatcher();
        Configuration conf = new Configuration();
        RMContainerTokenSecretManager containerTokenSecretManager = new RMContainerTokenSecretManager(conf);
        containerTokenSecretManager.rollMasterKey();
        NMTokenSecretManagerInRM nmTokenSecretManager = new NMTokenSecretManagerInRM(conf);
        nmTokenSecretManager.rollMasterKey();
        RMApplicationHistoryWriter writer = (RMApplicationHistoryWriter)Mockito.mock(RMApplicationHistoryWriter.class);
        FifoScheduler scheduler = new FifoScheduler();
        RMContextImpl rmContext = new RMContextImpl((Dispatcher)dispatcher, null, null, null, null, null, containerTokenSecretManager, nmTokenSecretManager, null, (ResourceScheduler)scheduler);
        rmContext.setSystemMetricsPublisher((SystemMetricsPublisher)Mockito.mock(SystemMetricsPublisher.class));
        rmContext.setRMApplicationHistoryWriter((RMApplicationHistoryWriter)Mockito.mock(RMApplicationHistoryWriter.class));
        rmContext.setYarnConfiguration((Configuration)new YarnConfiguration());
        scheduler.setRMContext((RMContext)rmContext);
        scheduler.init(conf);
        scheduler.start();
        scheduler.reinitialize(new Configuration(), (RMContext)rmContext);
        RMNode node0 = MockNodes.newNodeInfo(1, Resources.createResource((int)65536), 1, "127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node0);
        scheduler.handle((SchedulerEvent)nodeEvent1);
        int _appId = 1;
        int _appAttemptId = 1;
        ApplicationAttemptId appAttemptId = this.createAppAttemptId(_appId, _appAttemptId);
        this.createMockRMApp(appAttemptId, (RMContext)rmContext);
        AppAddedSchedulerEvent appEvent = new AppAddedSchedulerEvent(appAttemptId.getApplicationId(), "queue1", "user1");
        scheduler.handle((SchedulerEvent)appEvent);
        AppAttemptAddedSchedulerEvent attemptEvent = new AppAttemptAddedSchedulerEvent(appAttemptId, false);
        scheduler.handle((SchedulerEvent)attemptEvent);
        int memory = 64;
        int nConts = 3;
        int priority2 = 20;
        ArrayList<ResourceRequest> ask = new ArrayList<ResourceRequest>();
        ResourceRequest nodeLocal = this.createResourceRequest(memory, node0.getHostName(), priority2, nConts);
        ResourceRequest rackLocal = this.createResourceRequest(memory, node0.getRackName(), priority2, nConts);
        ResourceRequest any = this.createResourceRequest(memory, "*", priority2, nConts);
        ask.add(nodeLocal);
        ask.add(rackLocal);
        ask.add(any);
        scheduler.allocate(appAttemptId, ask, new ArrayList(), null, null, null, null);
        NodeUpdateSchedulerEvent node0Update = new NodeUpdateSchedulerEvent(node0);
        Assert.assertEquals((long)3L, (long)nodeLocal.getNumContainers());
        scheduler.handle((SchedulerEvent)node0Update);
        Assert.assertEquals((long)0L, (long)nodeLocal.getNumContainers());
        SchedulerAppReport info = scheduler.getSchedulerAppInfo(appAttemptId);
        Assert.assertEquals((long)3L, (long)info.getLiveContainers().size());
        scheduler.stop();
    }

    @Test(timeout=2000L)
    public void testUpdateResourceOnNode() throws Exception {
        InlineDispatcher dispatcher = new InlineDispatcher();
        Configuration conf = new Configuration();
        RMContainerTokenSecretManager containerTokenSecretManager = new RMContainerTokenSecretManager(conf);
        containerTokenSecretManager.rollMasterKey();
        NMTokenSecretManagerInRM nmTokenSecretManager = new NMTokenSecretManagerInRM(conf);
        nmTokenSecretManager.rollMasterKey();
        RMApplicationHistoryWriter writer = (RMApplicationHistoryWriter)Mockito.mock(RMApplicationHistoryWriter.class);
        FifoScheduler scheduler = new FifoScheduler(){

            public Map<NodeId, FiCaSchedulerNode> getNodes() {
                return this.nodes;
            }
        };
        RMContextImpl rmContext = new RMContextImpl((Dispatcher)dispatcher, null, null, null, null, null, containerTokenSecretManager, nmTokenSecretManager, null, (ResourceScheduler)scheduler);
        rmContext.setSystemMetricsPublisher((SystemMetricsPublisher)Mockito.mock(SystemMetricsPublisher.class));
        rmContext.setRMApplicationHistoryWriter((RMApplicationHistoryWriter)Mockito.mock(RMApplicationHistoryWriter.class));
        rmContext.setYarnConfiguration((Configuration)new YarnConfiguration());
        NullRMNodeLabelsManager nlm = new NullRMNodeLabelsManager();
        nlm.init(new Configuration());
        rmContext.setNodeLabelManager((RMNodeLabelsManager)nlm);
        scheduler.setRMContext((RMContext)rmContext);
        rmContext.setScheduler((ResourceScheduler)scheduler);
        scheduler.init(conf);
        scheduler.start();
        scheduler.reinitialize(new Configuration(), (RMContext)rmContext);
        RMNode node0 = MockNodes.newNodeInfo(1, Resources.createResource((int)2048, (int)4), 1, "127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node0);
        scheduler.handle((SchedulerEvent)nodeEvent1);
        Method method = scheduler.getClass().getDeclaredMethod("getNodes", new Class[0]);
        Map schedulerNodes = (Map)method.invoke((Object)scheduler, new Object[0]);
        Assert.assertEquals((long)schedulerNodes.values().size(), (long)1L);
        Resource newResource = Resources.createResource((int)1024, (int)4);
        NodeResourceUpdateSchedulerEvent node0ResourceUpdate = new NodeResourceUpdateSchedulerEvent(node0, ResourceOption.newInstance((Resource)newResource, (int)-1));
        scheduler.handle((SchedulerEvent)node0ResourceUpdate);
        Assert.assertEquals((long)((FiCaSchedulerNode)schedulerNodes.get(node0.getNodeID())).getTotalResource().getMemorySize(), (long)1024L);
        Assert.assertEquals((long)((FiCaSchedulerNode)schedulerNodes.get(node0.getNodeID())).getAvailableResource().getMemorySize(), (long)1024L);
        QueueInfo queueInfo = scheduler.getQueueInfo(null, false, false);
        Assert.assertEquals((float)0.0f, (float)queueInfo.getCurrentCapacity(), (float)0.0f);
        int _appId = 1;
        int _appAttemptId = 1;
        ApplicationAttemptId appAttemptId = this.createAppAttemptId(_appId, _appAttemptId);
        this.createMockRMApp(appAttemptId, (RMContext)rmContext);
        AppAddedSchedulerEvent appEvent = new AppAddedSchedulerEvent(appAttemptId.getApplicationId(), "queue1", "user1");
        scheduler.handle((SchedulerEvent)appEvent);
        AppAttemptAddedSchedulerEvent attemptEvent = new AppAttemptAddedSchedulerEvent(appAttemptId, false);
        scheduler.handle((SchedulerEvent)attemptEvent);
        int memory = 1024;
        int priority2 = 1;
        ArrayList<ResourceRequest> ask = new ArrayList<ResourceRequest>();
        ResourceRequest nodeLocal = this.createResourceRequest(memory, node0.getHostName(), priority2, 1);
        ResourceRequest rackLocal = this.createResourceRequest(memory, node0.getRackName(), priority2, 1);
        ResourceRequest any = this.createResourceRequest(memory, "*", priority2, 1);
        ask.add(nodeLocal);
        ask.add(rackLocal);
        ask.add(any);
        scheduler.allocate(appAttemptId, ask, new ArrayList(), null, null, null, null);
        Assert.assertEquals((long)1L, (long)nodeLocal.getNumContainers());
        NodeUpdateSchedulerEvent node0Update = new NodeUpdateSchedulerEvent(node0);
        scheduler.handle((SchedulerEvent)node0Update);
        Assert.assertEquals((long)0L, (long)nodeLocal.getNumContainers());
        SchedulerAppReport info = scheduler.getSchedulerAppInfo(appAttemptId);
        Assert.assertEquals((long)1L, (long)info.getLiveContainers().size());
        queueInfo = scheduler.getQueueInfo(null, false, false);
        Assert.assertEquals((float)1.0f, (float)queueInfo.getCurrentCapacity(), (float)0.0f);
    }

    public void testFifoScheduler() throws Exception {
        LOG.info((Object)"--- START: testFifoScheduler ---");
        int GB = 1024;
        String host_0 = "host_0";
        NodeManager nm_0 = this.registerNode(host_0, 1234, 2345, "/default-rack", Resources.createResource((int)4096, (int)1));
        nm_0.heartbeat();
        String host_1 = "host_1";
        NodeManager nm_1 = this.registerNode(host_1, 1234, 2345, "/default-rack", Resources.createResource((int)2048, (int)1));
        nm_1.heartbeat();
        org.apache.hadoop.yarn.api.records.Priority priority_0 = Priority.create((int)0);
        org.apache.hadoop.yarn.api.records.Priority priority_1 = Priority.create((int)1);
        Application application_0 = new Application("user_0", this.resourceManager);
        application_0.submit();
        application_0.addNodeManager(host_0, 1234, nm_0);
        application_0.addNodeManager(host_1, 1234, nm_1);
        Resource capability_0_0 = Resources.createResource((int)1024);
        application_0.addResourceRequestSpec(priority_1, capability_0_0);
        Resource capability_0_1 = Resources.createResource((int)2048);
        application_0.addResourceRequestSpec(priority_0, capability_0_1);
        Task task_0_0 = new Task(application_0, priority_1, new String[]{host_0, host_1});
        application_0.addTask(task_0_0);
        Application application_1 = new Application("user_1", this.resourceManager);
        application_1.submit();
        application_1.addNodeManager(host_0, 1234, nm_0);
        application_1.addNodeManager(host_1, 1234, nm_1);
        Resource capability_1_0 = Resources.createResource((int)3072);
        application_1.addResourceRequestSpec(priority_1, capability_1_0);
        Resource capability_1_1 = Resources.createResource((int)4096);
        application_1.addResourceRequestSpec(priority_0, capability_1_1);
        Task task_1_0 = new Task(application_1, priority_1, new String[]{host_0, host_1});
        application_1.addTask(task_1_0);
        LOG.info((Object)"Send resource requests to the scheduler");
        application_0.schedule();
        application_1.schedule();
        LOG.info((Object)"Send a heartbeat to kick the tires on the Scheduler... nm0 -> task_0_0 and task_1_0 allocated, used=4G nm1 -> nothing allocated");
        nm_0.heartbeat();
        nm_1.heartbeat();
        application_0.schedule();
        this.checkApplicationResourceUsage(1024, application_0);
        application_1.schedule();
        this.checkApplicationResourceUsage(3072, application_1);
        nm_0.heartbeat();
        nm_1.heartbeat();
        this.checkNodeResourceUsage(4096, nm_0);
        this.checkNodeResourceUsage(0, nm_1);
        LOG.info((Object)"Adding new tasks...");
        Task task_1_1 = new Task(application_1, priority_1, new String[]{"*"});
        application_1.addTask(task_1_1);
        Task task_1_2 = new Task(application_1, priority_1, new String[]{"*"});
        application_1.addTask(task_1_2);
        Task task_1_3 = new Task(application_1, priority_0, new String[]{"*"});
        application_1.addTask(task_1_3);
        application_1.schedule();
        Task task_0_1 = new Task(application_0, priority_1, new String[]{host_0, host_1});
        application_0.addTask(task_0_1);
        Task task_0_2 = new Task(application_0, priority_1, new String[]{host_0, host_1});
        application_0.addTask(task_0_2);
        Task task_0_3 = new Task(application_0, priority_0, new String[]{"*"});
        application_0.addTask(task_0_3);
        application_0.schedule();
        LOG.info((Object)("Sending hb from " + nm_0.getHostName()));
        nm_0.heartbeat();
        LOG.info((Object)("Sending hb from " + nm_1.getHostName()));
        nm_1.heartbeat();
        LOG.info((Object)"Trying to allocate...");
        application_0.schedule();
        this.checkApplicationResourceUsage(3072, application_0);
        application_1.schedule();
        this.checkApplicationResourceUsage(3072, application_1);
        nm_0.heartbeat();
        nm_1.heartbeat();
        this.checkNodeResourceUsage(4096, nm_0);
        this.checkNodeResourceUsage(2048, nm_1);
        LOG.info((Object)"Finishing up task_0_0");
        application_0.finishTask(task_0_0);
        application_0.schedule();
        application_1.schedule();
        nm_0.heartbeat();
        nm_1.heartbeat();
        this.checkApplicationResourceUsage(3072, application_0);
        this.checkApplicationResourceUsage(3072, application_1);
        this.checkNodeResourceUsage(4096, nm_0);
        this.checkNodeResourceUsage(2048, nm_1);
        LOG.info((Object)"Finishing up task_1_0");
        application_1.finishTask(task_1_0);
        application_0.schedule();
        application_1.schedule();
        nm_0.heartbeat();
        nm_1.heartbeat();
        this.checkApplicationResourceUsage(4096, application_0);
        this.checkApplicationResourceUsage(0, application_1);
        this.checkNodeResourceUsage(2048, nm_1);
        LOG.info((Object)"Finishing up task_0_3");
        application_0.finishTask(task_0_3);
        application_0.schedule();
        application_1.schedule();
        nm_0.heartbeat();
        nm_1.heartbeat();
        this.checkApplicationResourceUsage(2048, application_0);
        this.checkApplicationResourceUsage(0, application_1);
        this.checkNodeResourceUsage(0, nm_1);
        LOG.info((Object)"Finishing up task_0_1");
        application_0.finishTask(task_0_1);
        application_0.schedule();
        application_1.schedule();
        nm_0.heartbeat();
        nm_1.heartbeat();
        this.checkApplicationResourceUsage(1024, application_0);
        this.checkApplicationResourceUsage(0, application_1);
        LOG.info((Object)"Finishing up task_0_2");
        application_0.finishTask(task_0_2);
        application_0.schedule();
        application_1.schedule();
        nm_0.heartbeat();
        nm_1.heartbeat();
        this.checkApplicationResourceUsage(0, application_0);
        this.checkApplicationResourceUsage(4096, application_1);
        LOG.info((Object)"Finishing up task_1_3");
        application_1.finishTask(task_1_3);
        application_0.schedule();
        application_1.schedule();
        nm_0.heartbeat();
        nm_1.heartbeat();
        this.checkApplicationResourceUsage(0, application_0);
        this.checkApplicationResourceUsage(3072, application_1);
        LOG.info((Object)"Finishing up task_1_1");
        application_1.finishTask(task_1_1);
        application_0.schedule();
        application_1.schedule();
        nm_0.heartbeat();
        nm_1.heartbeat();
        this.checkApplicationResourceUsage(0, application_0);
        this.checkApplicationResourceUsage(3072, application_1);
        LOG.info((Object)"--- END: testFifoScheduler ---");
    }

    @Test
    public void testGetAppsInQueue() throws Exception {
        Application application_0 = new Application("user_0", this.resourceManager);
        application_0.submit();
        Application application_1 = new Application("user_0", this.resourceManager);
        application_1.submit();
        ResourceScheduler scheduler = this.resourceManager.getResourceScheduler();
        List appsInDefault = scheduler.getAppsInQueue("default");
        Assert.assertTrue((boolean)appsInDefault.contains(application_0.getApplicationAttemptId()));
        Assert.assertTrue((boolean)appsInDefault.contains(application_1.getApplicationAttemptId()));
        Assert.assertEquals((long)2L, (long)appsInDefault.size());
        Assert.assertNull((Object)scheduler.getAppsInQueue("someotherqueue"));
    }

    @Test
    public void testAddAndRemoveAppFromFiFoScheduler() throws Exception {
        Configuration conf = new Configuration();
        conf.setClass("yarn.resourcemanager.scheduler.class", FifoScheduler.class, ResourceScheduler.class);
        MockRM rm = new MockRM(conf);
        AbstractYarnScheduler fs = (AbstractYarnScheduler)rm.getResourceScheduler();
        TestSchedulerUtils.verifyAppAddedAndRemovedFromScheduler(fs.getSchedulerApplications(), (EventHandler<SchedulerEvent>)fs, "queue");
    }

    @Test(timeout=30000L)
    public void testConfValidation() throws Exception {
        FifoScheduler scheduler = new FifoScheduler();
        YarnConfiguration conf = new YarnConfiguration();
        conf.setInt("yarn.scheduler.minimum-allocation-mb", 2048);
        conf.setInt("yarn.scheduler.maximum-allocation-mb", 1024);
        try {
            scheduler.serviceInit((Configuration)conf);
            Assert.fail((String)"Exception is expected because the min memory allocation is larger than the max memory allocation.");
        }
        catch (YarnRuntimeException e) {
            Assert.assertTrue((String)"The thrown exception is not the expected one.", (boolean)e.getMessage().startsWith("Invalid resource scheduler memory"));
        }
    }

    @Test(timeout=60000L)
    public void testAllocateContainerOnNodeWithoutOffSwitchSpecified() throws Exception {
        Logger rootLogger = LogManager.getRootLogger();
        rootLogger.setLevel(Level.DEBUG);
        MockRM rm = new MockRM(conf);
        rm.start();
        MockNM nm1 = rm.registerNode("127.0.0.1:1234", 6144);
        RMApp app1 = rm.submitApp(2048);
        nm1.nodeHeartbeat(true);
        RMAppAttempt attempt1 = app1.getCurrentAppAttempt();
        MockAM am1 = rm.sendAMLaunched(attempt1.getAppAttemptId());
        am1.registerAppAttempt();
        ArrayList<ResourceRequest> requests = new ArrayList<ResourceRequest>();
        requests.add(am1.createResourceReq("127.0.0.1", 1024, 1, 1));
        requests.add(am1.createResourceReq("/default-rack", 1024, 1, 1));
        am1.allocate(requests, null);
        try {
            nm1.nodeHeartbeat(true);
        }
        catch (NullPointerException e) {
            Assert.fail((String)"NPE when allocating container on node but forget to set off-switch request should be handled");
        }
        rm.stop();
    }

    @Test(timeout=60000L)
    public void testFifoScheduling() throws Exception {
        Logger rootLogger = LogManager.getRootLogger();
        rootLogger.setLevel(Level.DEBUG);
        MockRM rm = new MockRM(conf);
        rm.start();
        MockNM nm1 = rm.registerNode("127.0.0.1:1234", 6144);
        MockNM nm2 = rm.registerNode("127.0.0.2:5678", 4096);
        RMApp app1 = rm.submitApp(2048);
        nm1.nodeHeartbeat(true);
        RMAppAttempt attempt1 = app1.getCurrentAppAttempt();
        MockAM am1 = rm.sendAMLaunched(attempt1.getAppAttemptId());
        am1.registerAppAttempt();
        SchedulerNodeReport report_nm1 = rm.getResourceScheduler().getNodeReport(nm1.getNodeId());
        Assert.assertEquals((long)2048L, (long)report_nm1.getUsedResource().getMemorySize());
        RMApp app2 = rm.submitApp(2048);
        nm2.nodeHeartbeat(true);
        RMAppAttempt attempt2 = app2.getCurrentAppAttempt();
        MockAM am2 = rm.sendAMLaunched(attempt2.getAppAttemptId());
        am2.registerAppAttempt();
        SchedulerNodeReport report_nm2 = rm.getResourceScheduler().getNodeReport(nm2.getNodeId());
        Assert.assertEquals((long)2048L, (long)report_nm2.getUsedResource().getMemorySize());
        am1.addRequests(new String[]{"127.0.0.1", "127.0.0.2"}, 1024, 1, 1);
        AllocateResponse alloc1Response = am1.schedule();
        am2.addRequests(new String[]{"127.0.0.1", "127.0.0.2"}, 3072, 0, 1);
        AllocateResponse alloc2Response = am2.schedule();
        nm1.nodeHeartbeat(true);
        while (alloc1Response.getAllocatedContainers().size() < 1) {
            LOG.info((Object)"Waiting for containers to be created for app 1...");
            Thread.sleep(1000L);
            alloc1Response = am1.schedule();
        }
        while (alloc2Response.getAllocatedContainers().size() < 1) {
            LOG.info((Object)"Waiting for containers to be created for app 2...");
            Thread.sleep(1000L);
            alloc2Response = am2.schedule();
        }
        nm2.nodeHeartbeat(true);
        List allocated1 = alloc1Response.getAllocatedContainers();
        Assert.assertEquals((long)1L, (long)allocated1.size());
        Assert.assertEquals((long)1024L, (long)((Container)allocated1.get(0)).getResource().getMemorySize());
        Assert.assertEquals((Object)nm1.getNodeId(), (Object)((Container)allocated1.get(0)).getNodeId());
        List allocated2 = alloc2Response.getAllocatedContainers();
        Assert.assertEquals((long)1L, (long)allocated2.size());
        Assert.assertEquals((long)3072L, (long)((Container)allocated2.get(0)).getResource().getMemorySize());
        Assert.assertEquals((Object)nm1.getNodeId(), (Object)((Container)allocated2.get(0)).getNodeId());
        report_nm1 = rm.getResourceScheduler().getNodeReport(nm1.getNodeId());
        report_nm2 = rm.getResourceScheduler().getNodeReport(nm2.getNodeId());
        Assert.assertEquals((long)0L, (long)report_nm1.getAvailableResource().getMemorySize());
        Assert.assertEquals((long)2048L, (long)report_nm2.getAvailableResource().getMemorySize());
        Assert.assertEquals((long)6144L, (long)report_nm1.getUsedResource().getMemorySize());
        Assert.assertEquals((long)2048L, (long)report_nm2.getUsedResource().getMemorySize());
        Container c1 = (Container)allocated1.get(0);
        Assert.assertEquals((long)1024L, (long)c1.getResource().getMemorySize());
        ContainerStatus containerStatus = BuilderUtils.newContainerStatus((ContainerId)c1.getId(), (ContainerState)ContainerState.COMPLETE, (String)"", (int)0, (Resource)c1.getResource());
        nm1.containerStatus(containerStatus);
        int waitCount = 0;
        while (attempt1.getJustFinishedContainers().size() < 1 && waitCount++ != 20) {
            LOG.info((Object)("Waiting for containers to be finished for app 1... Tried " + waitCount + " times already.."));
            Thread.sleep(1000L);
        }
        Assert.assertEquals((long)1L, (long)attempt1.getJustFinishedContainers().size());
        Assert.assertEquals((long)1L, (long)am1.schedule().getCompletedContainersStatuses().size());
        report_nm1 = rm.getResourceScheduler().getNodeReport(nm1.getNodeId());
        Assert.assertEquals((long)5120L, (long)report_nm1.getUsedResource().getMemorySize());
        rm.stop();
    }

    @Test(timeout=60000L)
    public void testNodeUpdateBeforeAppAttemptInit() throws Exception {
        FifoScheduler scheduler = new FifoScheduler();
        MockRM rm = new MockRM(conf);
        scheduler.setRMContext(rm.getRMContext());
        scheduler.init(conf);
        scheduler.start();
        scheduler.reinitialize(conf, rm.getRMContext());
        RMNode node = MockNodes.newNodeInfo(1, Resources.createResource((int)1024, (int)4), 1, "127.0.0.1");
        scheduler.handle((SchedulerEvent)new NodeAddedSchedulerEvent(node));
        ApplicationId appId = ApplicationId.newInstance((long)0L, (int)1);
        scheduler.addApplication(appId, "queue1", "user1", false);
        NodeUpdateSchedulerEvent updateEvent = new NodeUpdateSchedulerEvent(node);
        try {
            scheduler.handle((SchedulerEvent)updateEvent);
        }
        catch (NullPointerException e) {
            Assert.fail();
        }
        ApplicationAttemptId attId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
        scheduler.addApplicationAttempt(attId, false, false);
        rm.stop();
    }

    private void testMinimumAllocation(YarnConfiguration conf, int testAlloc) throws Exception {
        MockRM rm = new MockRM((Configuration)conf);
        rm.start();
        MockNM nm1 = rm.registerNode("127.0.0.1:1234", 6144);
        RMApp app1 = rm.submitApp(testAlloc);
        nm1.nodeHeartbeat(true);
        RMAppAttempt attempt1 = app1.getCurrentAppAttempt();
        MockAM am1 = rm.sendAMLaunched(attempt1.getAppAttemptId());
        am1.registerAppAttempt();
        SchedulerNodeReport report_nm1 = rm.getResourceScheduler().getNodeReport(nm1.getNodeId());
        int checkAlloc = conf.getInt("yarn.scheduler.minimum-allocation-mb", 1024);
        Assert.assertEquals((long)checkAlloc, (long)report_nm1.getUsedResource().getMemorySize());
        rm.stop();
    }

    @Test(timeout=60000L)
    public void testDefaultMinimumAllocation() throws Exception {
        this.testMinimumAllocation(new YarnConfiguration(conf), 512);
    }

    @Test(timeout=60000L)
    public void testNonDefaultMinimumAllocation() throws Exception {
        int allocMB = 1536;
        YarnConfiguration conf = new YarnConfiguration(TestFifoScheduler.conf);
        conf.setInt("yarn.scheduler.minimum-allocation-mb", allocMB);
        conf.setInt("yarn.scheduler.maximum-allocation-mb", allocMB * 10);
        this.testMinimumAllocation(conf, allocMB / 2);
    }

    @Test(timeout=50000L)
    public void testReconnectedNode() throws Exception {
        CapacitySchedulerConfiguration conf = new CapacitySchedulerConfiguration();
        conf.setQueues("default", new String[]{"default"});
        conf.setCapacity("default", 100.0f);
        FifoScheduler fs = new FifoScheduler();
        fs.init((Configuration)conf);
        fs.start();
        RMContext context = (RMContext)Mockito.mock(RMContext.class);
        fs.reinitialize((Configuration)conf, null);
        fs.setRMContext(context);
        RMNode n1 = MockNodes.newNodeInfo(0, MockNodes.newResource(4096), 1, "127.0.0.2");
        RMNode n2 = MockNodes.newNodeInfo(0, MockNodes.newResource(2048), 2, "127.0.0.3");
        fs.handle((SchedulerEvent)new NodeAddedSchedulerEvent(n1));
        fs.handle((SchedulerEvent)new NodeAddedSchedulerEvent(n2));
        fs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(n1));
        Assert.assertEquals((long)6144L, (long)fs.getRootQueueMetrics().getAvailableMB());
        n1 = MockNodes.newNodeInfo(0, MockNodes.newResource(2048), 1, "127.0.0.2");
        fs.handle((SchedulerEvent)new NodeRemovedSchedulerEvent(n1));
        fs.handle((SchedulerEvent)new NodeAddedSchedulerEvent(n1));
        fs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(n1));
        Assert.assertEquals((long)4096L, (long)fs.getRootQueueMetrics().getAvailableMB());
        fs.stop();
    }

    @Test(timeout=50000L)
    public void testBlackListNodes() throws Exception {
        Configuration conf = new Configuration();
        conf.setClass("yarn.resourcemanager.scheduler.class", FifoScheduler.class, ResourceScheduler.class);
        MockRM rm = new MockRM(conf);
        rm.start();
        FifoScheduler fs = (FifoScheduler)rm.getResourceScheduler();
        int rack_num_0 = 0;
        int rack_num_1 = 1;
        String host_0_0 = "127.0.0.1";
        RMNode n1 = MockNodes.newNodeInfo(rack_num_0, MockNodes.newResource(4096), 1, host_0_0);
        fs.handle((SchedulerEvent)new NodeAddedSchedulerEvent(n1));
        String host_0_1 = "127.0.0.2";
        RMNode n2 = MockNodes.newNodeInfo(rack_num_0, MockNodes.newResource(4096), 1, host_0_1);
        fs.handle((SchedulerEvent)new NodeAddedSchedulerEvent(n2));
        String host_1_0 = "127.0.0.3";
        RMNode n3 = MockNodes.newNodeInfo(rack_num_1, MockNodes.newResource(4096), 1, host_1_0);
        fs.handle((SchedulerEvent)new NodeAddedSchedulerEvent(n3));
        String host_1_1 = "127.0.0.4";
        RMNode n4 = MockNodes.newNodeInfo(rack_num_1, MockNodes.newResource(4096), 1, host_1_1);
        fs.handle((SchedulerEvent)new NodeAddedSchedulerEvent(n4));
        ApplicationId appId1 = BuilderUtils.newApplicationId((long)100L, (int)1);
        ApplicationAttemptId appAttemptId1 = BuilderUtils.newApplicationAttemptId((ApplicationId)appId1, (int)1);
        this.createMockRMApp(appAttemptId1, rm.getRMContext());
        AppAddedSchedulerEvent appEvent = new AppAddedSchedulerEvent(appId1, "queue", "user");
        fs.handle((SchedulerEvent)appEvent);
        AppAttemptAddedSchedulerEvent attemptEvent = new AppAttemptAddedSchedulerEvent(appAttemptId1, false);
        fs.handle((SchedulerEvent)attemptEvent);
        ArrayList emptyId = new ArrayList();
        ArrayList emptyAsk = new ArrayList();
        ArrayList<ResourceRequest> ask1 = new ArrayList<ResourceRequest>();
        ask1.add(BuilderUtils.newResourceRequest((org.apache.hadoop.yarn.api.records.Priority)BuilderUtils.newPriority((int)0), (String)"rack1", (Resource)BuilderUtils.newResource((long)1024L, (int)1), (int)1, (String)""));
        ask1.add(BuilderUtils.newResourceRequest((org.apache.hadoop.yarn.api.records.Priority)BuilderUtils.newPriority((int)0), (String)"*", (Resource)BuilderUtils.newResource((long)1024L, (int)1), (int)1, (String)""));
        fs.allocate(appAttemptId1, ask1, emptyId, Collections.singletonList(host_1_0), null, null, null);
        fs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(n3));
        Allocation allocation1 = fs.allocate(appAttemptId1, emptyAsk, emptyId, null, null, null, null);
        Assert.assertEquals((String)"allocation1", (long)0L, (long)allocation1.getContainers().size());
        fs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(n4));
        Allocation allocation2 = fs.allocate(appAttemptId1, emptyAsk, emptyId, null, null, null, null);
        Assert.assertEquals((String)"allocation2", (long)1L, (long)allocation2.getContainers().size());
        List containerList = allocation2.getContainers();
        for (Container container : containerList) {
            Assert.assertEquals((String)"Container is allocated on n4", (Object)container.getNodeId(), (Object)n4.getNodeID());
        }
        ArrayList<ResourceRequest> ask2 = new ArrayList<ResourceRequest>();
        ask2.add(BuilderUtils.newResourceRequest((org.apache.hadoop.yarn.api.records.Priority)BuilderUtils.newPriority((int)0), (String)"*", (Resource)BuilderUtils.newResource((long)1024L, (int)1), (int)1));
        fs.allocate(appAttemptId1, ask2, emptyId, Collections.singletonList("rack0"), null, null, null);
        fs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(n1));
        Allocation allocation3 = fs.allocate(appAttemptId1, emptyAsk, emptyId, null, null, null, null);
        Assert.assertEquals((String)"allocation3", (long)0L, (long)allocation3.getContainers().size());
        fs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(n2));
        Allocation allocation4 = fs.allocate(appAttemptId1, emptyAsk, emptyId, null, null, null, null);
        Assert.assertEquals((String)"allocation4", (long)0L, (long)allocation4.getContainers().size());
        fs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(n3));
        Allocation allocation5 = fs.allocate(appAttemptId1, emptyAsk, emptyId, null, null, null, null);
        Assert.assertEquals((String)"allocation5", (long)0L, (long)allocation5.getContainers().size());
        fs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(n4));
        Allocation allocation6 = fs.allocate(appAttemptId1, emptyAsk, emptyId, null, null, null, null);
        Assert.assertEquals((String)"allocation6", (long)1L, (long)allocation6.getContainers().size());
        containerList = allocation6.getContainers();
        for (Container container : containerList) {
            Assert.assertEquals((String)"Container is allocated on n4", (Object)container.getNodeId(), (Object)n4.getNodeID());
        }
        rm.stop();
    }

    @Test(timeout=50000L)
    public void testHeadroom() throws Exception {
        Configuration conf = new Configuration();
        conf.setClass("yarn.resourcemanager.scheduler.class", FifoScheduler.class, ResourceScheduler.class);
        MockRM rm = new MockRM(conf);
        rm.start();
        FifoScheduler fs = (FifoScheduler)rm.getResourceScheduler();
        RMNode n1 = MockNodes.newNodeInfo(0, MockNodes.newResource(4096), 1, "127.0.0.2");
        fs.handle((SchedulerEvent)new NodeAddedSchedulerEvent(n1));
        ApplicationId appId1 = BuilderUtils.newApplicationId((long)100L, (int)1);
        ApplicationAttemptId appAttemptId1 = BuilderUtils.newApplicationAttemptId((ApplicationId)appId1, (int)1);
        this.createMockRMApp(appAttemptId1, rm.getRMContext());
        AppAddedSchedulerEvent appEvent = new AppAddedSchedulerEvent(appId1, "queue", "user");
        fs.handle((SchedulerEvent)appEvent);
        AppAttemptAddedSchedulerEvent attemptEvent = new AppAttemptAddedSchedulerEvent(appAttemptId1, false);
        fs.handle((SchedulerEvent)attemptEvent);
        ApplicationId appId2 = BuilderUtils.newApplicationId((long)200L, (int)2);
        ApplicationAttemptId appAttemptId2 = BuilderUtils.newApplicationAttemptId((ApplicationId)appId2, (int)1);
        this.createMockRMApp(appAttemptId2, rm.getRMContext());
        AppAddedSchedulerEvent appEvent2 = new AppAddedSchedulerEvent(appId2, "queue", "user");
        fs.handle((SchedulerEvent)appEvent2);
        AppAttemptAddedSchedulerEvent attemptEvent2 = new AppAttemptAddedSchedulerEvent(appAttemptId2, false);
        fs.handle((SchedulerEvent)attemptEvent2);
        ArrayList emptyId = new ArrayList();
        ArrayList emptyAsk = new ArrayList();
        ArrayList<ResourceRequest> ask1 = new ArrayList<ResourceRequest>();
        ask1.add(BuilderUtils.newResourceRequest((org.apache.hadoop.yarn.api.records.Priority)BuilderUtils.newPriority((int)0), (String)"*", (Resource)BuilderUtils.newResource((long)1024L, (int)1), (int)1));
        fs.allocate(appAttemptId1, ask1, emptyId, null, null, null, null);
        ArrayList<ResourceRequest> ask2 = new ArrayList<ResourceRequest>();
        ask2.add(BuilderUtils.newResourceRequest((org.apache.hadoop.yarn.api.records.Priority)BuilderUtils.newPriority((int)0), (String)"*", (Resource)BuilderUtils.newResource((long)2048L, (int)1), (int)1));
        fs.allocate(appAttemptId2, ask2, emptyId, null, null, null, null);
        fs.handle((SchedulerEvent)new NodeUpdateSchedulerEvent(n1));
        Allocation allocation1 = fs.allocate(appAttemptId1, emptyAsk, emptyId, null, null, null, null);
        Assert.assertEquals((String)"Allocation headroom", (long)1024L, (long)allocation1.getResourceLimit().getMemorySize());
        Allocation allocation2 = fs.allocate(appAttemptId2, emptyAsk, emptyId, null, null, null, null);
        Assert.assertEquals((String)"Allocation headroom", (long)1024L, (long)allocation2.getResourceLimit().getMemorySize());
        rm.stop();
    }

    @Test(timeout=60000L)
    public void testResourceOverCommit() throws Exception {
        MockRM rm = new MockRM(conf);
        rm.start();
        MockNM nm1 = rm.registerNode("127.0.0.1:1234", 4096);
        RMApp app1 = rm.submitApp(2048);
        nm1.nodeHeartbeat(true);
        RMAppAttempt attempt1 = app1.getCurrentAppAttempt();
        MockAM am1 = rm.sendAMLaunched(attempt1.getAppAttemptId());
        am1.registerAppAttempt();
        SchedulerNodeReport report_nm1 = rm.getResourceScheduler().getNodeReport(nm1.getNodeId());
        Assert.assertEquals((long)2048L, (long)report_nm1.getUsedResource().getMemorySize());
        Assert.assertEquals((long)2048L, (long)report_nm1.getAvailableResource().getMemorySize());
        am1.addRequests(new String[]{"127.0.0.1", "127.0.0.2"}, 2048, 1, 1);
        AllocateResponse alloc1Response = am1.schedule();
        nm1.nodeHeartbeat(true);
        while (alloc1Response.getAllocatedContainers().size() < 1) {
            LOG.info((Object)"Waiting for containers to be created for app 1...");
            Thread.sleep(1000L);
            alloc1Response = am1.schedule();
        }
        List allocated1 = alloc1Response.getAllocatedContainers();
        Assert.assertEquals((long)1L, (long)allocated1.size());
        Assert.assertEquals((long)2048L, (long)((Container)allocated1.get(0)).getResource().getMemorySize());
        Assert.assertEquals((Object)nm1.getNodeId(), (Object)((Container)allocated1.get(0)).getNodeId());
        report_nm1 = rm.getResourceScheduler().getNodeReport(nm1.getNodeId());
        Assert.assertEquals((long)0L, (long)report_nm1.getAvailableResource().getMemorySize());
        Assert.assertEquals((long)4096L, (long)report_nm1.getUsedResource().getMemorySize());
        Container c1 = (Container)allocated1.get(0);
        Assert.assertEquals((long)2048L, (long)c1.getResource().getMemorySize());
        HashMap<NodeId, ResourceOption> nodeResourceMap = new HashMap<NodeId, ResourceOption>();
        nodeResourceMap.put(nm1.getNodeId(), ResourceOption.newInstance((Resource)Resource.newInstance((int)2048, (int)1), (int)-1));
        UpdateNodeResourceRequest request = UpdateNodeResourceRequest.newInstance(nodeResourceMap);
        rm.getAdminService().updateNodeResource(request);
        int waitCount = 0;
        while (waitCount++ != 20 && (null == (report_nm1 = rm.getResourceScheduler().getNodeReport(nm1.getNodeId())) || report_nm1.getAvailableResource().getMemorySize() == 0L)) {
            LOG.info((Object)("Waiting for RMNodeResourceUpdateEvent to be handled... Tried " + waitCount + " times already.."));
            Thread.sleep(1000L);
        }
        report_nm1 = rm.getResourceScheduler().getNodeReport(nm1.getNodeId());
        Assert.assertEquals((long)4096L, (long)report_nm1.getUsedResource().getMemorySize());
        Assert.assertEquals((long)-2048L, (long)report_nm1.getAvailableResource().getMemorySize());
        ContainerStatus containerStatus = BuilderUtils.newContainerStatus((ContainerId)c1.getId(), (ContainerState)ContainerState.COMPLETE, (String)"", (int)0, (Resource)c1.getResource());
        nm1.containerStatus(containerStatus);
        waitCount = 0;
        while (attempt1.getJustFinishedContainers().size() < 1 && waitCount++ != 20) {
            LOG.info((Object)("Waiting for containers to be finished for app 1... Tried " + waitCount + " times already.."));
            Thread.sleep(100L);
        }
        Assert.assertEquals((long)1L, (long)attempt1.getJustFinishedContainers().size());
        Assert.assertEquals((long)1L, (long)am1.schedule().getCompletedContainersStatuses().size());
        report_nm1 = rm.getResourceScheduler().getNodeReport(nm1.getNodeId());
        Assert.assertEquals((long)2048L, (long)report_nm1.getUsedResource().getMemorySize());
        Assert.assertEquals((long)0L, (long)report_nm1.getAvailableResource().getMemorySize());
        rm.stop();
    }

    @Test
    public void testResourceUpdateDecommissioningNode() throws Exception {
        RMContext spyContext = (RMContext)Mockito.spy((Object)this.resourceManager.getRMContext());
        Dispatcher mockDispatcher = (Dispatcher)Mockito.mock(AsyncDispatcher.class);
        Mockito.when((Object)mockDispatcher.getEventHandler()).thenReturn((Object)new EventHandler(){

            public void handle(Event event) {
                if (event instanceof RMNodeResourceUpdateEvent) {
                    RMNodeResourceUpdateEvent resourceEvent = (RMNodeResourceUpdateEvent)event;
                    TestFifoScheduler.this.resourceManager.getResourceScheduler().getSchedulerNode(resourceEvent.getNodeId()).updateTotalResource(resourceEvent.getResourceOption().getResource());
                }
            }
        });
        ((RMContext)Mockito.doReturn((Object)mockDispatcher).when((Object)spyContext)).getDispatcher();
        ((FifoScheduler)this.resourceManager.getResourceScheduler()).setRMContext(spyContext);
        ((AsyncDispatcher)mockDispatcher).start();
        String host_0 = "host_0";
        NodeManager nm_0 = this.registerNode(host_0, 1234, 2345, "/default-rack", Resources.createResource((int)8192, (int)4));
        org.apache.hadoop.yarn.api.records.Priority priority_0 = Priority.create((int)0);
        Application application_0 = new Application("user_0", "a1", this.resourceManager);
        application_0.submit();
        application_0.addNodeManager(host_0, 1234, nm_0);
        Resource capability_0_0 = Resources.createResource((int)1024, (int)1);
        application_0.addResourceRequestSpec(priority_0, capability_0_0);
        Task task_0_0 = new Task(application_0, priority_0, new String[]{host_0});
        application_0.addTask(task_0_0);
        application_0.schedule();
        RMNode node = (RMNode)this.resourceManager.getRMContext().getRMNodes().get(nm_0.getNodeId());
        NodeUpdateSchedulerEvent nodeUpdate = new NodeUpdateSchedulerEvent(node);
        this.resourceManager.getResourceScheduler().handle((Event)nodeUpdate);
        RMNode spyNode = (RMNode)Mockito.spy(this.resourceManager.getRMContext().getRMNodes().get(nm_0.getNodeId()));
        Mockito.when((Object)spyNode.getState()).thenReturn((Object)NodeState.DECOMMISSIONING);
        this.resourceManager.getResourceScheduler().handle((Event)new NodeUpdateSchedulerEvent(spyNode));
        application_0.schedule();
        Resource usedResource = this.resourceManager.getResourceScheduler().getSchedulerNode(nm_0.getNodeId()).getUsedResource();
        Assert.assertEquals((long)usedResource.getMemorySize(), (long)1024L);
        Assert.assertEquals((long)usedResource.getVirtualCores(), (long)1L);
        Resource totalResource = this.resourceManager.getResourceScheduler().getSchedulerNode(nm_0.getNodeId()).getTotalResource();
        Assert.assertEquals((long)totalResource.getMemorySize(), (long)1024L);
        Assert.assertEquals((long)totalResource.getVirtualCores(), (long)1L);
        Resource availableResource = this.resourceManager.getResourceScheduler().getSchedulerNode(nm_0.getNodeId()).getAvailableResource();
        Assert.assertEquals((long)availableResource.getMemorySize(), (long)0L);
        Assert.assertEquals((long)availableResource.getVirtualCores(), (long)0L);
    }

    private void checkApplicationResourceUsage(int expected, Application application) {
        Assert.assertEquals((long)expected, (long)application.getUsedResources().getMemorySize());
    }

    private void checkNodeResourceUsage(int expected, NodeManager node) {
        Assert.assertEquals((long)expected, (long)node.getUsed().getMemorySize());
        node.checkResourceUsage();
    }

    public static void main(String[] arg) throws Exception {
        TestFifoScheduler t = new TestFifoScheduler();
        t.setUp();
        t.testFifoScheduler();
        t.tearDown();
    }

    private RMAppImpl createMockRMApp(ApplicationAttemptId attemptId, RMContext context) {
        RMAppImpl app = (RMAppImpl)Mockito.mock(RMAppImpl.class);
        Mockito.when((Object)app.getApplicationId()).thenReturn((Object)attemptId.getApplicationId());
        RMAppAttemptImpl attempt = (RMAppAttemptImpl)Mockito.mock(RMAppAttemptImpl.class);
        Mockito.when((Object)attempt.getAppAttemptId()).thenReturn((Object)attemptId);
        RMAppAttemptMetrics attemptMetric = (RMAppAttemptMetrics)Mockito.mock(RMAppAttemptMetrics.class);
        Mockito.when((Object)attempt.getRMAppAttemptMetrics()).thenReturn((Object)attemptMetric);
        Mockito.when((Object)app.getCurrentAppAttempt()).thenReturn((Object)attempt);
        ApplicationSubmissionContext submissionContext = (ApplicationSubmissionContext)Mockito.mock(ApplicationSubmissionContext.class);
        Mockito.when((Object)submissionContext.getUnmanagedAM()).thenReturn((Object)false);
        Mockito.when((Object)attempt.getSubmissionContext()).thenReturn((Object)submissionContext);
        context.getRMApps().putIfAbsent(attemptId.getApplicationId(), app);
        return app;
    }

    static {
        recordFactory = RecordFactoryProvider.getRecordFactory(null);
    }
}

