/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.security;

import io.hops.util.DBUtility;
import io.hops.util.RMStorageFactory;
import io.hops.util.YarnAPIStorageFactory;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.delegation.DelegationKey;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.yarn.api.protocolrecords.GetDelegationTokenRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetDelegationTokenResponse;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.security.client.RMDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.RMSecretManagerService;
import org.apache.hadoop.yarn.server.resourcemanager.TestRMRestart;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.FileSystemRMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMDelegationTokenSecretManager;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestRMDelegationTokens {
    private YarnConfiguration conf;
    private FileSystem fs;
    private Path tmpDir;

    @Before
    public void setup() throws IOException {
        Logger rootLogger = LogManager.getRootLogger();
        rootLogger.setLevel(Level.DEBUG);
        ExitUtil.disableSystemExit();
        this.conf = new YarnConfiguration();
        YarnAPIStorageFactory.setConfiguration((Configuration)this.conf);
        RMStorageFactory.setConfiguration((Configuration)this.conf);
        DBUtility.InitializeDB();
        UserGroupInformation.setLoginUser(null);
        UserGroupInformation.setConfiguration((Configuration)this.conf);
        this.fs = FileSystem.get((Configuration)this.conf);
        this.tmpDir = new Path(new File("target", this.getClass().getSimpleName() + "-tmpDir").getAbsolutePath());
        this.fs.delete(this.tmpDir, true);
        this.fs.mkdirs(this.tmpDir);
        this.conf.setBoolean("yarn.resourcemanager.recovery.enabled", true);
        this.conf.set("yarn.resourcemanager.fs.state-store.uri", this.tmpDir.toString());
        this.conf.set("yarn.resourcemanager.store.class", FileSystemRMStateStore.class.getName());
    }

    @Test(timeout=1500000L)
    public void testRMDTMasterKeyStateOnRollingMasterKey() throws Exception {
        Configuration conf = new Configuration((Configuration)this.conf);
        conf.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setLoginUser(null);
        UserGroupInformation.setConfiguration((Configuration)conf);
        MyMockRM rm1 = new MyMockRM(conf);
        rm1.start();
        RMDelegationTokenSecretManager dtSecretManager = rm1.getRMContext().getRMDelegationTokenSecretManager();
        RMStateStore.RMState rmState = rm1.getRMContext().getStateStore().loadState();
        Set rmDTMasterKeyState = rmState.getRMDTSecretManagerState().getMasterKeyState();
        for (DelegationKey expectedKey : dtSecretManager.getAllMasterKeys()) {
            boolean foundIt = false;
            for (DelegationKey gotKey : rmDTMasterKeyState) {
                if (expectedKey.getKeyId() != gotKey.getKeyId() || !Arrays.equals(expectedKey.getEncodedKey(), gotKey.getEncodedKey())) continue;
                foundIt = true;
                break;
            }
            Assert.assertTrue((boolean)foundIt);
        }
        GetDelegationTokenRequest request = (GetDelegationTokenRequest)Mockito.mock(GetDelegationTokenRequest.class);
        Mockito.when((Object)request.getRenewer()).thenReturn((Object)"renewer1");
        GetDelegationTokenResponse response = rm1.getClientRMService().getDelegationToken(request);
        org.apache.hadoop.yarn.api.records.Token delegationToken = response.getRMDelegationToken();
        Token token1 = ConverterUtils.convertFromYarn((org.apache.hadoop.yarn.api.records.Token)delegationToken, (Text)null);
        RMDelegationTokenIdentifier dtId1 = (RMDelegationTokenIdentifier)token1.decodeIdentifier();
        while (((TestRMDelegationTokenSecretManager)dtSecretManager).numUpdatedKeys.get() < 3) {
            while ((rmDTMasterKeyState = (rmState = rm1.getRMContext().getStateStore().loadState()).getRMDTSecretManagerState().getMasterKeyState()) == null) {
            }
            ((TestRMDelegationTokenSecretManager)dtSecretManager).checkCurrentKeyInStateStore(rmDTMasterKeyState);
            Thread.sleep(100L);
        }
        rmState = rm1.getRMContext().getStateStore().loadState();
        Map rmDTState = rmState.getRMDTSecretManagerState().getTokenState();
        for (int count = 0; rmDTState.containsKey(dtId1) && count < 100; ++count) {
            Thread.sleep(100L);
        }
        rm1.stop();
    }

    @Test(timeout=15000L)
    public void testRemoveExpiredMasterKeyInRMStateStore() throws Exception {
        MyMockRM rm1 = new MyMockRM((Configuration)this.conf);
        rm1.start();
        RMDelegationTokenSecretManager dtSecretManager = rm1.getRMContext().getRMDelegationTokenSecretManager();
        RMStateStore.RMState rmState = rm1.getRMContext().getStateStore().loadState();
        Set rmDTMasterKeyState = rmState.getRMDTSecretManagerState().getMasterKeyState();
        for (DelegationKey expectedKey : dtSecretManager.getAllMasterKeys()) {
            boolean foundIt = false;
            for (DelegationKey gotKey : rmDTMasterKeyState) {
                if (expectedKey.getKeyId() != gotKey.getKeyId() || !Arrays.equals(expectedKey.getEncodedKey(), gotKey.getEncodedKey())) continue;
                foundIt = true;
                break;
            }
            Assert.assertTrue((boolean)foundIt);
        }
        HashSet expiringKeys = new HashSet();
        expiringKeys.addAll(dtSecretManager.getAllMasterKeys());
        while (true) {
            rm1.getRMContext().getStateStore().loadState();
            rmDTMasterKeyState = rmState.getRMDTSecretManagerState().getMasterKeyState();
            boolean allExpired = true;
            for (DelegationKey key : expiringKeys) {
                if (!rmDTMasterKeyState.contains(key)) continue;
                allExpired = false;
            }
            if (allExpired) break;
            Thread.sleep(500L);
        }
        rm1.stop();
    }

    public class TestRMDelegationTokenSecretManager
    extends RMDelegationTokenSecretManager {
        public AtomicInteger numUpdatedKeys;

        public TestRMDelegationTokenSecretManager(long delegationKeyUpdateInterval, long delegationTokenMaxLifetime, long delegationTokenRenewInterval, long delegationTokenRemoverScanInterval, RMContext rmContext) {
            super(delegationKeyUpdateInterval, delegationTokenMaxLifetime, delegationTokenRenewInterval, delegationTokenRemoverScanInterval, rmContext);
            this.numUpdatedKeys = new AtomicInteger(0);
        }

        protected void storeNewMasterKey(DelegationKey newKey) {
            super.storeNewMasterKey(newKey);
            this.numUpdatedKeys.incrementAndGet();
        }

        public synchronized DelegationKey checkCurrentKeyInStateStore(Set<DelegationKey> rmDTMasterKeyState) {
            Iterator iterator = this.allKeys.keySet().iterator();
            while (iterator.hasNext()) {
                int keyId = (Integer)iterator.next();
                if (keyId != this.currentId) continue;
                DelegationKey currentKey = (DelegationKey)this.allKeys.get(keyId);
                boolean found = false;
                for (DelegationKey k : rmDTMasterKeyState) {
                    if (k.getKeyId() != keyId) continue;
                    found = true;
                    break;
                }
                Assert.assertTrue((boolean)found);
                return currentKey;
            }
            return null;
        }
    }

    class MyMockRM
    extends TestRMRestart.TestSecurityMockRM {
        public MyMockRM(Configuration conf) {
            super(conf);
        }

        protected RMSecretManagerService createRMSecretManagerService() {
            return new RMSecretManagerService((Configuration)TestRMDelegationTokens.this.conf, this.rmContext){

                protected RMDelegationTokenSecretManager createRMDelegationTokenSecretManager(Configuration conf, RMContext rmContext) {
                    return new TestRMDelegationTokenSecretManager(1000L, 1000L, 2000L, 1000L, rmContext);
                }
            };
        }
    }
}

