/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.hops.util.DBUtility;
import io.hops.util.RMStorageFactory;
import io.hops.util.YarnAPIStorageFactory;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.GroupMappingServiceProvider;
import org.apache.hadoop.security.Groups;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.security.authorize.ProxyUsers;
import org.apache.hadoop.security.authorize.ServiceAuthorizationManager;
import org.apache.hadoop.yarn.api.ApplicationClientProtocolPB;
import org.apache.hadoop.yarn.api.records.DecommissionType;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.conf.HAUtil;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshAdminAclsRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshClusterMaxPriorityRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshNodesRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshNodesResourcesRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshQueuesRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshServiceAclsRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshSuperUserGroupsConfigurationRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RefreshUserToGroupsMappingsRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RemoveFromClusterNodeLabelsRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.ReplaceLabelsOnNodeRequest;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.RMContextImpl;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.resource.DynamicResourceConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeImplNotDist;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestRMAdminService {
    private Configuration configuration;
    private MockRM rm = null;
    private FileSystem fs;
    private Path workingPath;
    private Path tmpDir;

    @Before
    public void setup() throws IOException {
        this.configuration = new YarnConfiguration();
        this.configuration.set("yarn.resourcemanager.scheduler.class", CapacityScheduler.class.getCanonicalName());
        this.fs = FileSystem.get((Configuration)this.configuration);
        this.workingPath = new Path(new File("target", this.getClass().getSimpleName() + "-remoteDir").getAbsolutePath());
        this.configuration.set("yarn.resourcemanager.configuration.file-system-based-store", this.workingPath.toString());
        this.tmpDir = new Path(new File("target", this.getClass().getSimpleName() + "-tmpDir").getAbsolutePath());
        this.fs.delete(this.workingPath, true);
        this.fs.delete(this.tmpDir, true);
        this.fs.mkdirs(this.workingPath);
        this.fs.mkdirs(this.tmpDir);
        RMStorageFactory.setConfiguration((Configuration)this.configuration);
        YarnAPIStorageFactory.setConfiguration((Configuration)this.configuration);
        DBUtility.InitializeDB();
        MockUnixGroupsMapping.resetGroups();
    }

    @After
    public void tearDown() throws IOException {
        if (this.rm != null) {
            this.rm.stop();
        }
        this.fs.delete(this.workingPath, true);
        this.fs.delete(this.tmpDir, true);
    }

    @Test
    public void testAdminRefreshQueuesWithLocalConfigurationProvider() throws IOException, YarnException {
        this.rm = new MockRM(this.configuration);
        this.rm.init(this.configuration);
        this.rm.start();
        CapacityScheduler cs = (CapacityScheduler)this.rm.getRMContext().getScheduler();
        int maxAppsBefore = cs.getConfiguration().getMaximumSystemApplications();
        try {
            this.rm.adminService.refreshQueues(RefreshQueuesRequest.newInstance());
            Assert.assertEquals((long)maxAppsBefore, (long)cs.getConfiguration().getMaximumSystemApplications());
        }
        catch (Exception ex) {
            Assert.fail((String)"Using localConfigurationProvider. Should not get any exception.");
        }
    }

    @Test
    public void testAdminRefreshQueuesWithFileSystemBasedConfigurationProvider() throws IOException, YarnException {
        this.configuration.set("yarn.resourcemanager.configuration.provider-class", "org.apache.hadoop.yarn.FileSystemBasedConfigurationProvider");
        this.uploadDefaultConfiguration();
        try {
            this.rm = new MockRM(this.configuration);
            this.rm.init(this.configuration);
            this.rm.start();
        }
        catch (Exception ex) {
            Assert.fail((String)"Should not get any exceptions");
        }
        CapacityScheduler cs = (CapacityScheduler)this.rm.getRMContext().getScheduler();
        int maxAppsBefore = cs.getConfiguration().getMaximumSystemApplications();
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        csConf.set("yarn.scheduler.capacity.maximum-applications", "5000");
        this.uploadConfiguration((Configuration)csConf, "capacity-scheduler.xml");
        this.rm.adminService.refreshQueues(RefreshQueuesRequest.newInstance());
        int maxAppsAfter = cs.getConfiguration().getMaximumSystemApplications();
        Assert.assertEquals((long)maxAppsAfter, (long)5000L);
        Assert.assertTrue((maxAppsAfter != maxAppsBefore ? 1 : 0) != 0);
    }

    @Test
    public void testAdminRefreshNodesWithoutConfiguration() throws IOException, YarnException {
        this.configuration.set("yarn.resourcemanager.configuration.provider-class", "org.apache.hadoop.yarn.FileSystemBasedConfigurationProvider");
        this.uploadDefaultConfiguration();
        try {
            this.rm = new MockRM(this.configuration);
            this.rm.init(this.configuration);
            this.rm.start();
        }
        catch (Exception ex) {
            Assert.fail((String)"Should not get any exceptions");
        }
        try {
            this.rm.adminService.refreshNodesResources(RefreshNodesResourcesRequest.newInstance());
        }
        catch (Exception ex) {
            Assert.fail((String)"Should not get any exceptions even when no configurations are done for node resources refresh");
        }
    }

    @Test
    public void testRefreshNodesResourceWithFileSystemBasedConfigurationProvider() throws IOException, YarnException {
        this.configuration.set("yarn.resourcemanager.configuration.provider-class", "org.apache.hadoop.yarn.FileSystemBasedConfigurationProvider");
        this.uploadDefaultConfiguration();
        try {
            this.rm = new MockRM(this.configuration);
            this.rm.init(this.configuration);
            this.rm.start();
            this.rm.registerNode("h1:1234", 5120);
        }
        catch (Exception ex) {
            Assert.fail((String)"Should not get any exceptions");
        }
        NodeId nid = NodeId.fromString((String)"h1:1234");
        RMNode ni = (RMNode)this.rm.getRMContext().getRMNodes().get(nid);
        Resource resource = ni.getTotalCapability();
        Assert.assertEquals((Object)"<memory:5120, vCores:5, gpus:0>", (Object)resource.toString());
        DynamicResourceConfiguration drConf = new DynamicResourceConfiguration();
        drConf.set("yarn.resource.dynamic.nodes", "h1:1234");
        drConf.set("yarn.resource.dynamic.h1:1234.vcores", "4");
        drConf.set("yarn.resource.dynamic.h1:1234.memory", "4096");
        this.uploadConfiguration((Configuration)drConf, "dynamic-resources.xml");
        this.rm.adminService.refreshNodesResources(RefreshNodesResourcesRequest.newInstance());
        this.rm.drainEvents();
        RMNode niAfter = (RMNode)this.rm.getRMContext().getRMNodes().get(nid);
        Resource resourceAfter = niAfter.getTotalCapability();
        Assert.assertEquals((Object)"<memory:4096, vCores:4, gpus:0>", (Object)resourceAfter.toString());
    }

    @Test
    public void testRefreshNodesResourceWithResourceReturnInRegistration() throws IOException, YarnException {
        this.configuration.set("yarn.resourcemanager.configuration.provider-class", "org.apache.hadoop.yarn.FileSystemBasedConfigurationProvider");
        this.uploadDefaultConfiguration();
        MockNM nm = null;
        try {
            this.rm = new MockRM(this.configuration);
            this.rm.init(this.configuration);
            this.rm.start();
            nm = this.rm.registerNode("h1:1234", 2048, 2);
        }
        catch (Exception ex) {
            Assert.fail((String)"Should not get any exceptions");
        }
        NodeId nid = NodeId.fromString((String)"h1:1234");
        RMNode ni = (RMNode)this.rm.getRMContext().getRMNodes().get(nid);
        Resource resource = ni.getTotalCapability();
        Assert.assertEquals((Object)"<memory:2048, vCores:2, gpus:0>", (Object)resource.toString());
        DynamicResourceConfiguration drConf = new DynamicResourceConfiguration();
        drConf.set("yarn.resource.dynamic.nodes", "h1:1234");
        drConf.set("yarn.resource.dynamic.h1:1234.vcores", "4");
        drConf.set("yarn.resource.dynamic.h1:1234.memory", "4096");
        this.uploadConfiguration((Configuration)drConf, "dynamic-resources.xml");
        this.rm.adminService.refreshNodesResources(RefreshNodesResourcesRequest.newInstance());
        try {
            nm.registerNode();
        }
        catch (Exception ex) {
            Assert.fail((String)"Should not get any exceptions");
        }
        RMNode niAfter = (RMNode)this.rm.getRMContext().getRMNodes().get(nid);
        Resource resourceAfter = niAfter.getTotalCapability();
        Assert.assertEquals((Object)"<memory:4096, vCores:4, gpus:0>", (Object)resourceAfter.toString());
        Assert.assertEquals((long)4096L, (long)nm.getMemory());
        Assert.assertEquals((long)4L, (long)nm.getvCores());
    }

    @Test
    public void testRefreshNodesResourceWithResourceReturnInHeartbeat() throws IOException, YarnException {
        this.configuration.set("yarn.resourcemanager.configuration.provider-class", "org.apache.hadoop.yarn.FileSystemBasedConfigurationProvider");
        this.uploadDefaultConfiguration();
        MockNM nm = null;
        try {
            this.rm = new MockRM(this.configuration);
            this.rm.init(this.configuration);
            this.rm.start();
            nm = this.rm.registerNode("h1:1234", 2048, 2);
        }
        catch (Exception ex) {
            Assert.fail((String)"Should not get any exceptions");
        }
        NodeId nid = NodeId.fromString((String)"h1:1234");
        RMNode ni = (RMNode)this.rm.getRMContext().getRMNodes().get(nid);
        Resource resource = ni.getTotalCapability();
        Assert.assertEquals((Object)"<memory:2048, vCores:2, gpus:0>", (Object)resource.toString());
        DynamicResourceConfiguration drConf = new DynamicResourceConfiguration();
        drConf.set("yarn.resource.dynamic.nodes", "h1:1234");
        drConf.set("yarn.resource.dynamic.h1:1234.vcores", "4");
        drConf.set("yarn.resource.dynamic.h1:1234.memory", "4096");
        this.uploadConfiguration((Configuration)drConf, "dynamic-resources.xml");
        this.rm.adminService.refreshNodesResources(RefreshNodesResourcesRequest.newInstance());
        try {
            nm.nodeHeartbeat(true);
        }
        catch (Exception ex) {
            Assert.fail((String)"Should not get any exceptions");
        }
        RMNode niAfter = (RMNode)this.rm.getRMContext().getRMNodes().get(nid);
        Resource resourceAfter = niAfter.getTotalCapability();
        Assert.assertEquals((Object)"<memory:4096, vCores:4, gpus:0>", (Object)resourceAfter.toString());
        Assert.assertEquals((long)4096L, (long)nm.getMemory());
        Assert.assertEquals((long)4L, (long)nm.getvCores());
    }

    @Test
    public void testResourcePersistentForNMRegistrationWithNewResource() throws IOException, YarnException, InterruptedException {
        this.configuration.set("yarn.resourcemanager.configuration.provider-class", "org.apache.hadoop.yarn.FileSystemBasedConfigurationProvider");
        this.uploadDefaultConfiguration();
        try {
            this.rm = new MockRM(this.configuration);
            this.rm.init(this.configuration);
            this.rm.start();
            this.rm.registerNode("h1:1234", 5120);
        }
        catch (Exception ex) {
            Assert.fail((String)"Should not get any exceptions");
        }
        NodeId nid = NodeId.fromString((String)"h1:1234");
        RMNode ni = (RMNode)this.rm.getRMContext().getRMNodes().get(nid);
        Resource resource = ni.getTotalCapability();
        Assert.assertEquals((Object)"<memory:5120, vCores:5, gpus:0>", (Object)resource.toString());
        DynamicResourceConfiguration drConf = new DynamicResourceConfiguration();
        drConf.set("yarn.resource.dynamic.nodes", "h1:1234");
        drConf.set("yarn.resource.dynamic.h1:1234.vcores", "6");
        drConf.set("yarn.resource.dynamic.h1:1234.memory", "4096");
        this.uploadConfiguration((Configuration)drConf, "dynamic-resources.xml");
        this.rm.adminService.refreshNodesResources(RefreshNodesResourcesRequest.newInstance());
        try {
            this.rm.registerNode("h1:1234", 8192, 8);
        }
        catch (Exception ex) {
            Assert.fail((String)"Should not get any exceptions");
        }
        RMNode niAfter = (RMNode)this.rm.getRMContext().getRMNodes().get(nid);
        Resource resourceAfter = niAfter.getTotalCapability();
        Assert.assertEquals((Object)"<memory:4096, vCores:6, gpus:0>", (Object)resourceAfter.toString());
        this.deleteOnRemoteFileSystem("dynamic-resources.xml");
        DynamicResourceConfiguration emptyDRConf = new DynamicResourceConfiguration();
        this.uploadConfiguration((Configuration)emptyDRConf, "dynamic-resources.xml");
        this.rm.adminService.refreshNodesResources(RefreshNodesResourcesRequest.newInstance());
        try {
            this.rm.registerNode("h1:1234", 8192, 8);
        }
        catch (Exception ex) {
            Assert.fail((String)"Should not get any exceptions");
        }
        Thread.sleep(500L);
        niAfter = (RMNode)this.rm.getRMContext().getRMNodes().get(nid);
        resourceAfter = niAfter.getTotalCapability();
        Assert.assertEquals((Object)"<memory:8192, vCores:8, gpus:0>", (Object)resourceAfter.toString());
    }

    @Test
    public void testAdminAclsWithLocalConfigurationProvider() {
        this.rm = new MockRM(this.configuration);
        this.rm.init(this.configuration);
        this.rm.start();
        try {
            this.rm.adminService.refreshAdminAcls(RefreshAdminAclsRequest.newInstance());
        }
        catch (Exception ex) {
            Assert.fail((String)"Using localConfigurationProvider. Should not get any exception.");
        }
    }

    @Test
    public void testAdminAclsWithFileSystemBasedConfigurationProvider() throws IOException, YarnException {
        this.configuration.set("yarn.resourcemanager.configuration.provider-class", "org.apache.hadoop.yarn.FileSystemBasedConfigurationProvider");
        this.uploadDefaultConfiguration();
        try {
            this.rm = new MockRM(this.configuration);
            this.rm.init(this.configuration);
            this.rm.start();
        }
        catch (Exception ex) {
            Assert.fail((String)"Should not get any exceptions");
        }
        String aclStringBefore = this.rm.adminService.getAccessControlList().getAclString().trim();
        YarnConfiguration yarnConf = new YarnConfiguration();
        yarnConf.set("yarn.admin.acl", "world:anyone:rwcda");
        this.uploadConfiguration((Configuration)yarnConf, "yarn-site.xml");
        this.rm.adminService.refreshAdminAcls(RefreshAdminAclsRequest.newInstance());
        String aclStringAfter = this.rm.adminService.getAccessControlList().getAclString().trim();
        Assert.assertTrue((!aclStringAfter.equals(aclStringBefore) ? 1 : 0) != 0);
        Assert.assertEquals((Object)aclStringAfter, (Object)("world:anyone:rwcda," + UserGroupInformation.getCurrentUser().getShortUserName()));
    }

    @Test
    public void testServiceAclsRefreshWithLocalConfigurationProvider() {
        this.configuration.setBoolean("hadoop.security.authorization", true);
        ResourceManager resourceManager = null;
        try {
            resourceManager = new ResourceManager();
            resourceManager.init(this.configuration);
            resourceManager.start();
            resourceManager.adminService.refreshServiceAcls(RefreshServiceAclsRequest.newInstance());
        }
        catch (Exception ex) {
            Assert.fail((String)"Using localConfigurationProvider. Should not get any exception.");
        }
        finally {
            if (resourceManager != null) {
                resourceManager.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testServiceAclsRefreshWithFileSystemBasedConfigurationProvider() throws IOException, YarnException {
        this.configuration.setBoolean("hadoop.security.authorization", true);
        this.configuration.set("yarn.resourcemanager.configuration.provider-class", "org.apache.hadoop.yarn.FileSystemBasedConfigurationProvider");
        ResourceManager resourceManager = null;
        try {
            this.uploadDefaultConfiguration();
            Configuration conf = new Configuration();
            conf.setBoolean("hadoop.security.authorization", true);
            this.uploadConfiguration(conf, "core-site.xml");
            try {
                resourceManager = new ResourceManager();
                resourceManager.init(this.configuration);
                resourceManager.start();
            }
            catch (Exception ex) {
                Assert.fail((String)"Should not get any exceptions");
            }
            String aclsString = "alice,bob users,wheel";
            Configuration newConf = new Configuration();
            newConf.set("security.applicationclient.protocol.acl", aclsString);
            this.uploadConfiguration(newConf, "hadoop-policy.xml");
            resourceManager.adminService.refreshServiceAcls(RefreshServiceAclsRequest.newInstance());
            ServiceAuthorizationManager adminServiceServiceManager = resourceManager.adminService.getServer().getServiceAuthorizationManager();
            this.verifyServiceACLsRefresh(adminServiceServiceManager, ApplicationClientProtocolPB.class, aclsString);
            ServiceAuthorizationManager clientRMServiceServiceManager = resourceManager.getRMContext().getClientRMService().getServer().getServiceAuthorizationManager();
            this.verifyServiceACLsRefresh(clientRMServiceServiceManager, ApplicationClientProtocolPB.class, aclsString);
            ServiceAuthorizationManager appMasterService = resourceManager.getRMContext().getApplicationMasterService().getServer().getServiceAuthorizationManager();
            this.verifyServiceACLsRefresh(appMasterService, ApplicationClientProtocolPB.class, aclsString);
            ServiceAuthorizationManager RTService = resourceManager.getRMContext().getResourceTrackerService().getServer().getServiceAuthorizationManager();
            this.verifyServiceACLsRefresh(RTService, ApplicationClientProtocolPB.class, aclsString);
        }
        finally {
            if (resourceManager != null) {
                resourceManager.stop();
            }
        }
    }

    private void verifyServiceACLsRefresh(ServiceAuthorizationManager manager, Class<?> protocol, String aclString) {
        for (Class protocolClass : manager.getProtocolsWithAcls()) {
            AccessControlList accessList = manager.getProtocolsAcls(protocolClass);
            if (protocolClass == protocol) {
                Assert.assertEquals((Object)accessList.getAclString(), (Object)aclString);
                continue;
            }
            Assert.assertEquals((Object)accessList.getAclString(), (Object)"*");
        }
    }

    @Test
    public void testRefreshSuperUserGroupsWithLocalConfigurationProvider() {
        this.rm = new MockRM(this.configuration);
        this.rm.init(this.configuration);
        this.rm.start();
        try {
            this.rm.adminService.refreshSuperUserGroupsConfiguration(RefreshSuperUserGroupsConfigurationRequest.newInstance());
        }
        catch (Exception ex) {
            Assert.fail((String)"Using localConfigurationProvider. Should not get any exception.");
        }
    }

    @Test
    public void testRefreshSuperUserGroupsWithFileSystemBasedConfigurationProvider() throws IOException, YarnException {
        this.configuration.set("yarn.resourcemanager.configuration.provider-class", "org.apache.hadoop.yarn.FileSystemBasedConfigurationProvider");
        this.uploadDefaultConfiguration();
        try {
            this.rm = new MockRM(this.configuration);
            this.rm.init(this.configuration);
            this.rm.start();
        }
        catch (Exception ex) {
            Assert.fail((String)"Should not get any exceptions");
        }
        Configuration coreConf = new Configuration(false);
        coreConf.set("hadoop.proxyuser.test.groups", "test_groups");
        coreConf.set("hadoop.proxyuser.test.hosts", "test_hosts");
        this.uploadConfiguration(coreConf, "core-site.xml");
        this.rm.adminService.refreshSuperUserGroupsConfiguration(RefreshSuperUserGroupsConfigurationRequest.newInstance());
        Assert.assertTrue((((Collection)ProxyUsers.getDefaultImpersonationProvider().getProxyGroups().get("hadoop.proxyuser.test.groups")).size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((Collection)ProxyUsers.getDefaultImpersonationProvider().getProxyGroups().get("hadoop.proxyuser.test.groups")).contains("test_groups"));
        Assert.assertTrue((((Collection)ProxyUsers.getDefaultImpersonationProvider().getProxyHosts().get("hadoop.proxyuser.test.hosts")).size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((Collection)ProxyUsers.getDefaultImpersonationProvider().getProxyHosts().get("hadoop.proxyuser.test.hosts")).contains("test_hosts"));
        Configuration yarnConf = new Configuration(false);
        yarnConf.set("yarn.resourcemanager.proxyuser.test.groups", "test_groups_1");
        yarnConf.set("yarn.resourcemanager.proxyuser.test.hosts", "test_hosts_1");
        this.uploadConfiguration(yarnConf, "yarn-site.xml");
        this.rm.adminService.refreshSuperUserGroupsConfiguration(RefreshSuperUserGroupsConfigurationRequest.newInstance());
        Assert.assertTrue((((Collection)ProxyUsers.getDefaultImpersonationProvider().getProxyGroups().get("hadoop.proxyuser.test.groups")).size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((Collection)ProxyUsers.getDefaultImpersonationProvider().getProxyGroups().get("hadoop.proxyuser.test.groups")).contains("test_groups_1"));
        Assert.assertTrue((((Collection)ProxyUsers.getDefaultImpersonationProvider().getProxyHosts().get("hadoop.proxyuser.test.hosts")).size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((Collection)ProxyUsers.getDefaultImpersonationProvider().getProxyHosts().get("hadoop.proxyuser.test.hosts")).contains("test_hosts_1"));
    }

    @Test
    public void testRefreshUserToGroupsMappingsWithLocalConfigurationProvider() {
        this.rm = new MockRM(this.configuration);
        this.rm.init(this.configuration);
        this.rm.start();
        try {
            this.rm.adminService.refreshUserToGroupsMappings(RefreshUserToGroupsMappingsRequest.newInstance());
        }
        catch (Exception ex) {
            Assert.fail((String)"Using localConfigurationProvider. Should not get any exception.");
        }
    }

    @Test
    public void testRefreshUserToGroupsMappingsWithFileSystemBasedConfigurationProvider() throws IOException, YarnException {
        this.configuration.set("yarn.resourcemanager.configuration.provider-class", "org.apache.hadoop.yarn.FileSystemBasedConfigurationProvider");
        String[] defaultTestUserGroups = new String[]{"dummy_group1", "dummy_group2"};
        UserGroupInformation ugi = UserGroupInformation.createUserForTesting((String)"dummyUser", (String[])defaultTestUserGroups);
        String user = ugi.getUserName();
        ArrayList<String> groupWithInit = new ArrayList<String>(2);
        for (int i = 0; i < ugi.getGroupNames().length; ++i) {
            groupWithInit.add(ugi.getGroupNames()[i]);
        }
        this.uploadDefaultConfiguration();
        Configuration conf = new Configuration();
        conf.setClass("hadoop.security.group.mapping", MockUnixGroupsMapping.class, GroupMappingServiceProvider.class);
        this.uploadConfiguration(conf, "core-site.xml");
        try {
            this.rm = new MockRM(this.configuration);
            this.rm.init(this.configuration);
            this.rm.start();
        }
        catch (Exception ex) {
            Assert.fail((String)"Should not get any exceptions");
        }
        ArrayList groupBefore = new ArrayList(Groups.getUserToGroupsMappingService((Configuration)this.configuration).getGroups(user));
        Assert.assertTrue((groupBefore.contains("test_group_A") && groupBefore.contains("test_group_B") && groupBefore.contains("test_group_C") && groupBefore.size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((groupWithInit.size() != groupBefore.size() ? 1 : 0) != 0);
        Assert.assertFalse((groupWithInit.contains("test_group_A") || groupWithInit.contains("test_group_B") || groupWithInit.contains("test_group_C") ? 1 : 0) != 0);
        MockUnixGroupsMapping.updateGroups();
        this.rm.adminService.refreshUserToGroupsMappings(RefreshUserToGroupsMappingsRequest.newInstance());
        List groupAfter = Groups.getUserToGroupsMappingService((Configuration)this.configuration).getGroups(user);
        Assert.assertTrue((groupAfter.contains("test_group_D") && groupAfter.contains("test_group_E") && groupAfter.contains("test_group_F") && groupAfter.size() == 3 ? 1 : 0) != 0);
    }

    @Test
    public void testRefreshNodesWithLocalConfigurationProvider() {
        this.rm = new MockRM(this.configuration);
        this.rm.init(this.configuration);
        this.rm.start();
        try {
            this.rm.adminService.refreshNodes(RefreshNodesRequest.newInstance((DecommissionType)DecommissionType.NORMAL));
        }
        catch (Exception ex) {
            Assert.fail((String)"Using localConfigurationProvider. Should not get any exception.");
        }
    }

    @Test
    public void testRefreshNodesWithFileSystemBasedConfigurationProvider() throws IOException, YarnException {
        this.configuration.set("yarn.resourcemanager.configuration.provider-class", "org.apache.hadoop.yarn.FileSystemBasedConfigurationProvider");
        this.uploadDefaultConfiguration();
        try {
            this.rm = new MockRM(this.configuration);
            this.rm.init(this.configuration);
            this.rm.start();
        }
        catch (Exception ex) {
            Assert.fail((String)"Should not get any exceptions");
        }
        File excludeHostsFile = new File(this.tmpDir.toString(), "excludeHosts");
        if (excludeHostsFile.exists()) {
            excludeHostsFile.delete();
        }
        if (!excludeHostsFile.createNewFile()) {
            Assert.fail((String)"Can not create excludeHosts");
        }
        PrintWriter fileWriter = new PrintWriter(excludeHostsFile);
        fileWriter.write("0.0.0.0:123");
        fileWriter.close();
        this.uploadToRemoteFileSystem(new Path(excludeHostsFile.getAbsolutePath()));
        YarnConfiguration yarnConf = new YarnConfiguration();
        yarnConf.set("yarn.resourcemanager.nodes.exclude-path", this.workingPath + "/excludeHosts");
        this.uploadConfiguration((Configuration)yarnConf, "yarn-site.xml");
        this.rm.adminService.refreshNodes(RefreshNodesRequest.newInstance((DecommissionType)DecommissionType.NORMAL));
        Set excludeHosts = this.rm.getNodesListManager().getHostsReader().getExcludedHosts();
        Assert.assertTrue((excludeHosts.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)excludeHosts.contains("0.0.0.0:123"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRMHAWithFileSystemBasedConfiguration() throws IOException, YarnException {
        HAServiceProtocol.StateChangeRequestInfo requestInfo = new HAServiceProtocol.StateChangeRequestInfo(HAServiceProtocol.RequestSource.REQUEST_BY_USER);
        this.configuration.set("yarn.resourcemanager.configuration.provider-class", "org.apache.hadoop.yarn.FileSystemBasedConfigurationProvider");
        this.configuration.setBoolean("yarn.resourcemanager.ha.enabled", true);
        this.configuration.setBoolean("yarn.resourcemanager.ha.automatic-failover.enabled", false);
        this.configuration.set("yarn.resourcemanager.ha.rm-ids", "rm1,rm2");
        int base = 100;
        for (String confKey : YarnConfiguration.getServiceAddressConfKeys((Configuration)this.configuration)) {
            this.configuration.set(HAUtil.addSuffix((String)confKey, (String)"rm1"), "0.0.0.0:" + (base + 20));
            this.configuration.set(HAUtil.addSuffix((String)confKey, (String)"rm2"), "0.0.0.0:" + (base + 40));
            base *= 2;
        }
        Configuration conf1 = new Configuration(this.configuration);
        conf1.set("yarn.resourcemanager.ha.id", "rm1");
        conf1.set("yarn.resourcemanager.groupMembership.address", "localhost:8034");
        Configuration conf2 = new Configuration(this.configuration);
        conf2.set("yarn.resourcemanager.ha.id", "rm2");
        conf2.set("yarn.resourcemanager.groupMembership.address", "localhost:8035");
        this.uploadDefaultConfiguration();
        MockRM rm1 = null;
        MockRM rm2 = null;
        try {
            rm1 = new MockRM(conf1);
            rm1.init(conf1);
            rm1.start();
            Assert.assertTrue((rm1.getRMContext().getHAServiceState() == HAServiceProtocol.HAServiceState.STANDBY ? 1 : 0) != 0);
            rm2 = new MockRM(conf2);
            rm2.init(conf1);
            rm2.start();
            Assert.assertTrue((rm2.getRMContext().getHAServiceState() == HAServiceProtocol.HAServiceState.STANDBY ? 1 : 0) != 0);
            rm1.adminService.transitionToActive(requestInfo);
            Assert.assertTrue((rm1.getRMContext().getHAServiceState() == HAServiceProtocol.HAServiceState.ACTIVE ? 1 : 0) != 0);
            CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
            csConf.set("yarn.scheduler.capacity.maximum-applications", "5000");
            this.uploadConfiguration((Configuration)csConf, "capacity-scheduler.xml");
            rm1.adminService.refreshQueues(RefreshQueuesRequest.newInstance());
            int maxApps = ((CapacityScheduler)rm1.getRMContext().getScheduler()).getConfiguration().getMaximumSystemApplications();
            Assert.assertEquals((long)maxApps, (long)5000L);
            int maxAppsBeforeFailOver = ((CapacityScheduler)rm2.getRMContext().getScheduler()).getConfiguration().getMaximumSystemApplications();
            Assert.assertEquals((long)maxAppsBeforeFailOver, (long)10000L);
            rm1.adminService.transitionToStandby(requestInfo);
            rm2.adminService.transitionToActive(requestInfo);
            Assert.assertTrue((rm1.getRMContext().getHAServiceState() == HAServiceProtocol.HAServiceState.STANDBY ? 1 : 0) != 0);
            Assert.assertTrue((rm2.getRMContext().getHAServiceState() == HAServiceProtocol.HAServiceState.ACTIVE ? 1 : 0) != 0);
            int maxAppsAfter = ((CapacityScheduler)rm2.getRMContext().getScheduler()).getConfiguration().getMaximumSystemApplications();
            Assert.assertEquals((long)maxAppsAfter, (long)5000L);
        }
        finally {
            if (rm1 != null) {
                rm1.stop();
            }
            if (rm2 != null) {
                rm2.stop();
            }
        }
    }

    @Test
    public void testRMStartsWithoutConfigurationFilesProvided() {
        this.configuration.set("yarn.resourcemanager.configuration.provider-class", "org.apache.hadoop.yarn.FileSystemBasedConfigurationProvider");
        try {
            this.rm = new MockRM(this.configuration);
            this.rm.init(this.configuration);
            this.rm.start();
        }
        catch (Exception ex) {
            Assert.fail((String)"Should not get any exceptions");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRMInitialsWithFileSystemBasedConfigurationProvider() throws Exception {
        this.configuration.set("yarn.resourcemanager.configuration.provider-class", "org.apache.hadoop.yarn.FileSystemBasedConfigurationProvider");
        File excludeHostsFile = new File(this.tmpDir.toString(), "excludeHosts");
        if (excludeHostsFile.exists()) {
            excludeHostsFile.delete();
        }
        if (!excludeHostsFile.createNewFile()) {
            Assert.fail((String)"Can not create excludeHosts");
        }
        PrintWriter fileWriter = new PrintWriter(excludeHostsFile);
        fileWriter.write("0.0.0.0:123");
        fileWriter.close();
        this.uploadToRemoteFileSystem(new Path(excludeHostsFile.getAbsolutePath()));
        YarnConfiguration yarnConf = new YarnConfiguration();
        yarnConf.set("yarn.admin.acl", "world:anyone:rwcda");
        yarnConf.set("yarn.resourcemanager.nodes.exclude-path", this.workingPath + "/excludeHosts");
        this.uploadConfiguration((Configuration)yarnConf, "yarn-site.xml");
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        csConf.set("yarn.scheduler.capacity.maximum-applications", "5000");
        this.uploadConfiguration((Configuration)csConf, "capacity-scheduler.xml");
        String aclsString = "alice,bob users,wheel";
        Configuration newConf = new Configuration();
        newConf.set("security.applicationclient.protocol.acl", aclsString);
        this.uploadConfiguration(newConf, "hadoop-policy.xml");
        Configuration conf = new Configuration();
        conf.setBoolean("hadoop.security.authorization", true);
        conf.set("hadoop.proxyuser.test.groups", "test_groups");
        conf.set("hadoop.proxyuser.test.hosts", "test_hosts");
        conf.setClass("hadoop.security.group.mapping", MockUnixGroupsMapping.class, GroupMappingServiceProvider.class);
        this.uploadConfiguration(conf, "core-site.xml");
        MockUnixGroupsMapping.updateGroups();
        ResourceManager resourceManager = null;
        try {
            try {
                resourceManager = new ResourceManager();
                resourceManager.init(this.configuration);
                resourceManager.start();
            }
            catch (Exception ex) {
                Assert.fail((String)"Should not get any exceptions");
            }
            Set excludeHosts = resourceManager.getRMContext().getNodesListManager().getHostsReader().getExcludedHosts();
            Assert.assertTrue((excludeHosts.size() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)excludeHosts.contains("0.0.0.0:123"));
            String aclStringAfter = resourceManager.adminService.getAccessControlList().getAclString().trim();
            Assert.assertEquals((Object)aclStringAfter, (Object)("world:anyone:rwcda," + UserGroupInformation.getCurrentUser().getShortUserName()));
            CapacityScheduler cs = (CapacityScheduler)resourceManager.getRMContext().getScheduler();
            int maxAppsAfter = cs.getConfiguration().getMaximumSystemApplications();
            Assert.assertEquals((long)maxAppsAfter, (long)5000L);
            ServiceAuthorizationManager adminServiceServiceManager = resourceManager.adminService.getServer().getServiceAuthorizationManager();
            this.verifyServiceACLsRefresh(adminServiceServiceManager, ApplicationClientProtocolPB.class, aclsString);
            ServiceAuthorizationManager clientRMServiceServiceManager = resourceManager.getRMContext().getClientRMService().getServer().getServiceAuthorizationManager();
            this.verifyServiceACLsRefresh(clientRMServiceServiceManager, ApplicationClientProtocolPB.class, aclsString);
            ServiceAuthorizationManager appMasterService = resourceManager.getRMContext().getApplicationMasterService().getServer().getServiceAuthorizationManager();
            this.verifyServiceACLsRefresh(appMasterService, ApplicationClientProtocolPB.class, aclsString);
            ServiceAuthorizationManager RTService = resourceManager.getRMContext().getResourceTrackerService().getServer().getServiceAuthorizationManager();
            this.verifyServiceACLsRefresh(RTService, ApplicationClientProtocolPB.class, aclsString);
            ProxyUsers.refreshSuperUserGroupsConfiguration((Configuration)this.configuration);
            Assert.assertTrue((((Collection)ProxyUsers.getDefaultImpersonationProvider().getProxyGroups().get("hadoop.proxyuser.test.groups")).size() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)((Collection)ProxyUsers.getDefaultImpersonationProvider().getProxyGroups().get("hadoop.proxyuser.test.groups")).contains("test_groups"));
            Assert.assertTrue((((Collection)ProxyUsers.getDefaultImpersonationProvider().getProxyHosts().get("hadoop.proxyuser.test.hosts")).size() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)((Collection)ProxyUsers.getDefaultImpersonationProvider().getProxyHosts().get("hadoop.proxyuser.test.hosts")).contains("test_hosts"));
            List groupAfter = Groups.getUserToGroupsMappingService((Configuration)this.configuration).getGroups(UserGroupInformation.getCurrentUser().getUserName());
            Assert.assertTrue((groupAfter.contains("test_group_D") && groupAfter.contains("test_group_E") && groupAfter.contains("test_group_F") && groupAfter.size() == 3 ? 1 : 0) != 0);
        }
        finally {
            if (resourceManager != null) {
                resourceManager.stop();
            }
        }
    }

    @Test
    public void testRefreshAclWithDaemonUser() throws Exception {
        String daemonUser = UserGroupInformation.getCurrentUser().getShortUserName();
        this.configuration.set("yarn.resourcemanager.configuration.provider-class", "org.apache.hadoop.yarn.FileSystemBasedConfigurationProvider");
        this.uploadDefaultConfiguration();
        YarnConfiguration yarnConf = new YarnConfiguration();
        yarnConf.set("yarn.admin.acl", daemonUser + "xyz");
        this.uploadConfiguration((Configuration)yarnConf, "yarn-site.xml");
        try {
            this.rm = new MockRM(this.configuration);
            this.rm.init(this.configuration);
            this.rm.start();
        }
        catch (Exception ex) {
            Assert.fail((String)"Should not get any exceptions");
        }
        Assert.assertEquals((Object)(daemonUser + "xyz," + daemonUser), (Object)this.rm.adminService.getAccessControlList().getAclString().trim());
        yarnConf = new YarnConfiguration();
        yarnConf.set("yarn.admin.acl", daemonUser + "abc");
        this.uploadConfiguration((Configuration)yarnConf, "yarn-site.xml");
        try {
            this.rm.adminService.refreshAdminAcls(RefreshAdminAclsRequest.newInstance());
        }
        catch (YarnException e) {
            if (e.getCause() != null && e.getCause() instanceof AccessControlException) {
                Assert.fail((String)"Refresh should not have failed due to incorrect ACL");
            }
            throw e;
        }
        Assert.assertEquals((Object)(daemonUser + "abc," + daemonUser), (Object)this.rm.adminService.getAccessControlList().getAclString().trim());
    }

    @Test
    public void testModifyLabelsOnNodesWithDistributedConfigurationDisabled() throws IOException, YarnException {
        MockRM rm = new MockRM();
        ((RMContextImpl)rm.getRMContext()).setHAServiceState(HAServiceProtocol.HAServiceState.ACTIVE);
        RMNodeLabelsManager labelMgr = rm.rmContext.getNodeLabelManager();
        labelMgr.addToCluserNodeLabelsWithDefaultExclusivity((Set)ImmutableSet.of((Object)"x", (Object)"y"));
        rm.adminService.replaceLabelsOnNode(ReplaceLabelsOnNodeRequest.newInstance((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"host", (int)0), (Object)ImmutableSet.of((Object)"x"))));
        rm.close();
    }

    @Test(expected=YarnException.class)
    public void testModifyLabelsOnNodesWithCentralizedConfigurationDisabled() throws IOException, YarnException {
        MockRM rm = new MockRM();
        rm.adminService.isCentralizedNodeLabelConfiguration = false;
        ((RMContextImpl)rm.getRMContext()).setHAServiceState(HAServiceProtocol.HAServiceState.ACTIVE);
        RMNodeLabelsManager labelMgr = rm.rmContext.getNodeLabelManager();
        labelMgr.addToCluserNodeLabelsWithDefaultExclusivity((Set)ImmutableSet.of((Object)"x", (Object)"y"));
        rm.adminService.replaceLabelsOnNode(ReplaceLabelsOnNodeRequest.newInstance((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"host", (int)0), (Object)ImmutableSet.of((Object)"x"))));
        rm.close();
    }

    @Test
    public void testModifyLabelsOnUnknownNodes() throws IOException, YarnException {
        this.rm = new MockRM();
        ((RMContextImpl)this.rm.getRMContext()).setHAServiceState(HAServiceProtocol.HAServiceState.ACTIVE);
        ConcurrentMap rmNodes = this.rm.getRMContext().getRMNodes();
        rmNodes.put(NodeId.newInstance((String)"host1", (int)1111), new RMNodeImplNotDist(null, this.rm.getRMContext(), "host1", 0, 0, null, null, null));
        rmNodes.put(NodeId.newInstance((String)"host2", (int)2222), new RMNodeImplNotDist(null, this.rm.getRMContext(), "host2", 0, 0, null, null, null));
        rmNodes.put(NodeId.newInstance((String)"host3", (int)3333), new RMNodeImplNotDist(null, this.rm.getRMContext(), "host3", 0, 0, null, null, null));
        ConcurrentMap rmInactiveNodes = this.rm.getRMContext().getInactiveRMNodes();
        rmInactiveNodes.put(NodeId.newInstance((String)"host4", (int)4444), new RMNodeImplNotDist(null, this.rm.getRMContext(), "host4", 0, 0, null, null, null));
        RMNodeLabelsManager labelMgr = this.rm.rmContext.getNodeLabelManager();
        labelMgr.addToCluserNodeLabelsWithDefaultExclusivity((Set)ImmutableSet.of((Object)"x", (Object)"y"));
        ReplaceLabelsOnNodeRequest request1 = ReplaceLabelsOnNodeRequest.newInstance((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"host1", (int)1111), (Object)ImmutableSet.of((Object)"x")));
        request1.setFailOnUnknownNodes(true);
        try {
            this.rm.adminService.replaceLabelsOnNode(request1);
        }
        catch (Exception ex) {
            Assert.fail((String)"should not fail on known node");
        }
        ReplaceLabelsOnNodeRequest request2 = ReplaceLabelsOnNodeRequest.newInstance((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"host1", (int)0), (Object)ImmutableSet.of((Object)"x")));
        request2.setFailOnUnknownNodes(true);
        try {
            this.rm.adminService.replaceLabelsOnNode(request2);
        }
        catch (Exception ex) {
            Assert.fail((String)"should not fail on known node");
        }
        ReplaceLabelsOnNodeRequest request3 = ReplaceLabelsOnNodeRequest.newInstance((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"host5", (int)0), (Object)ImmutableSet.of((Object)"x")));
        request3.setFailOnUnknownNodes(true);
        try {
            this.rm.adminService.replaceLabelsOnNode(request3);
            Assert.fail((String)"Should fail on unknown node");
        }
        catch (Exception exception) {
            // empty catch block
        }
        ReplaceLabelsOnNodeRequest request4 = ReplaceLabelsOnNodeRequest.newInstance((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"host2", (int)1111), (Object)ImmutableSet.of((Object)"x")));
        request4.setFailOnUnknownNodes(true);
        try {
            this.rm.adminService.replaceLabelsOnNode(request4);
            Assert.fail((String)"Should fail on node with wrong port");
        }
        catch (Exception exception) {
            // empty catch block
        }
        ReplaceLabelsOnNodeRequest request5 = ReplaceLabelsOnNodeRequest.newInstance((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"host5", (int)0), (Object)ImmutableSet.of((Object)"x")));
        request5.setFailOnUnknownNodes(false);
        try {
            this.rm.adminService.replaceLabelsOnNode(request5);
        }
        catch (Exception ex) {
            Assert.fail((String)"Should not fail on unknown node when fail-on-unkown-nodes is set false");
        }
        ReplaceLabelsOnNodeRequest request6 = ReplaceLabelsOnNodeRequest.newInstance((Map)ImmutableMap.of((Object)NodeId.newInstance((String)"host4", (int)0), (Object)ImmutableSet.of((Object)"x")));
        request6.setFailOnUnknownNodes(true);
        try {
            this.rm.adminService.replaceLabelsOnNode(request6);
        }
        catch (Exception ex) {
            Assert.fail((String)"should not fail on inactive node");
        }
        this.rm.close();
    }

    @Test
    public void testRemoveClusterNodeLabelsWithCentralizedConfigurationDisabled() throws IOException, YarnException {
        MockRM rm = new MockRM();
        ((RMContextImpl)rm.getRMContext()).setHAServiceState(HAServiceProtocol.HAServiceState.ACTIVE);
        RMNodeLabelsManager labelMgr = rm.rmContext.getNodeLabelManager();
        rm.adminService.isCentralizedNodeLabelConfiguration = false;
        labelMgr.addToCluserNodeLabelsWithDefaultExclusivity((Set)ImmutableSet.of((Object)"x", (Object)"y"));
        rm.adminService.removeFromClusterNodeLabels(RemoveFromClusterNodeLabelsRequest.newInstance((Set)ImmutableSet.of((Object)"x")));
        Set clusterNodeLabels = labelMgr.getClusterNodeLabelNames();
        Assert.assertEquals((long)1L, (long)clusterNodeLabels.size());
        rm.close();
    }

    @Test(timeout=30000L)
    public void testAdminRefreshClusterMaxPriority() throws Exception, YarnException {
        this.configuration.set("yarn.resourcemanager.configuration.provider-class", "org.apache.hadoop.yarn.FileSystemBasedConfigurationProvider");
        this.uploadDefaultConfiguration();
        YarnConfiguration yarnConf = new YarnConfiguration();
        yarnConf.set("yarn.cluster.max-application-priority", "5");
        this.uploadConfiguration((Configuration)yarnConf, "yarn-site.xml");
        this.rm = new MockRM(this.configuration);
        this.rm.init(this.configuration);
        this.rm.start();
        CapacityScheduler cs = (CapacityScheduler)this.rm.getRMContext().getScheduler();
        Assert.assertEquals((long)5L, (long)cs.getMaxClusterLevelAppPriority().getPriority());
        yarnConf = new YarnConfiguration();
        yarnConf.set("yarn.cluster.max-application-priority", "10");
        this.uploadConfiguration((Configuration)yarnConf, "yarn-site.xml");
        try {
            this.rm.adminService.refreshClusterMaxPriority(RefreshClusterMaxPriorityRequest.newInstance());
            Assert.assertEquals((long)10L, (long)cs.getMaxClusterLevelAppPriority().getPriority());
        }
        catch (Exception ex) {
            Assert.fail((String)"Could not refresh cluster max priority.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String writeConfigurationXML(Configuration conf, String confXMLName) throws IOException {
        try (FilterOutputStream output = null;){
            File confFile = new File(this.tmpDir.toString(), confXMLName);
            if (confFile.exists()) {
                confFile.delete();
            }
            if (!confFile.createNewFile()) {
                Assert.fail((String)("Can not create " + confXMLName));
            }
            output = new DataOutputStream(new FileOutputStream(confFile));
            conf.writeXml((OutputStream)output);
            String string = confFile.getAbsolutePath();
            return string;
        }
    }

    private void uploadToRemoteFileSystem(Path filePath) throws IOException {
        this.fs.copyFromLocalFile(filePath, this.workingPath);
    }

    private void uploadConfiguration(Configuration conf, String confFileName) throws IOException {
        String csConfFile = this.writeConfigurationXML(conf, confFileName);
        this.uploadToRemoteFileSystem(new Path(csConfFile));
    }

    private void deleteOnRemoteFileSystem(String fileName) throws IOException {
        this.fs.delete(new Path(this.workingPath, fileName));
    }

    private void uploadDefaultConfiguration() throws IOException {
        Configuration conf = new Configuration();
        this.uploadConfiguration(conf, "core-site.xml");
        YarnConfiguration yarnConf = new YarnConfiguration();
        yarnConf.set("yarn.resourcemanager.configuration.provider-class", "org.apache.hadoop.yarn.FileSystemBasedConfigurationProvider");
        this.uploadConfiguration((Configuration)yarnConf, "yarn-site.xml");
        CapacitySchedulerConfiguration csConf = new CapacitySchedulerConfiguration();
        this.uploadConfiguration((Configuration)csConf, "capacity-scheduler.xml");
        Configuration hadoopPolicyConf = new Configuration(false);
        hadoopPolicyConf.addResource("hadoop-policy.xml");
        this.uploadConfiguration(hadoopPolicyConf, "hadoop-policy.xml");
    }

    static {
        YarnConfiguration.addDefaultResource((String)"capacity-scheduler.xml");
        YarnConfiguration.addDefaultResource((String)"dynamic-resources.xml");
    }

    private static class MockUnixGroupsMapping
    implements GroupMappingServiceProvider {
        private static List<String> group = new ArrayList<String>();

        private MockUnixGroupsMapping() {
        }

        public List<String> getGroups(String user) throws IOException {
            return group;
        }

        public void cacheGroupsRefresh() throws IOException {
        }

        public void cacheGroupsAdd(List<String> groups) throws IOException {
        }

        public static void updateGroups() {
            group.clear();
            group.add("test_group_D");
            group.add("test_group_E");
            group.add("test_group_F");
        }

        public static void resetGroups() {
            group.clear();
            group.add("test_group_A");
            group.add("test_group_B");
            group.add("test_group_C");
        }
    }
}

