/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import io.hops.metadata.yarn.entity.Load;
import io.hops.metadata.yarn.entity.PendingEvent;
import io.hops.metadata.yarn.entity.Resource;
import io.hops.metadata.yarn.entity.UpdatedContainerInfo;
import io.hops.util.DBUtility;
import io.hops.util.DBUtilityTests;
import io.hops.util.RMStorageFactory;
import io.hops.util.YarnAPIStorageFactory;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeLabel;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.DrainDispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.nodelabels.NodeLabelTestBase;
import org.apache.hadoop.yarn.server.api.protocolrecords.NMContainerStatus;
import org.apache.hadoop.yarn.server.api.protocolrecords.NodeHeartbeatRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.NodeHeartbeatResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.RegisterNodeManagerRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.RegisterNodeManagerResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.UnRegisterNodeManagerRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.UpdatedCryptoForApp;
import org.apache.hadoop.yarn.server.api.records.MasterKey;
import org.apache.hadoop.yarn.server.api.records.NodeAction;
import org.apache.hadoop.yarn.server.api.records.NodeHealthStatus;
import org.apache.hadoop.yarn.server.api.records.NodeStatus;
import org.apache.hadoop.yarn.server.api.records.impl.pb.MasterKeyPBImpl;
import org.apache.hadoop.yarn.server.resourcemanager.ClusterMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceTrackerService;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.NodeLabelsUtils;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.NullRMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeImplDist;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.Records;
import org.apache.hadoop.yarn.util.YarnVersionInfo;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestResourceTrackerService
extends NodeLabelTestBase {
    private static final File TEMP_DIR = new File(System.getProperty("test.build.data", "/tmp"), "decommision");
    private final File hostFile = new File(TEMP_DIR + File.separator + "hostFile.txt");
    private MockRM rm;

    @Before
    public void setup() throws IOException {
        YarnConfiguration conf = new YarnConfiguration();
        RMStorageFactory.setConfiguration((Configuration)conf);
        YarnAPIStorageFactory.setConfiguration((Configuration)conf);
        DBUtility.InitializeDB();
    }

    @Test(timeout=50000L)
    public void testGetNextHeartBeatInterval() throws Exception {
        Configuration conf = new Configuration();
        conf.set("yarn.resourcemanager.nodemanagers.heartbeat-interval-ms", "4000");
        DBUtility.InitializeDB();
        this.rm = new MockRM(conf);
        this.rm.start();
        MockNM nm1 = this.rm.registerNode("host1:1234", 5120);
        MockNM nm2 = this.rm.registerNode("host2:5678", 10240);
        NodeHeartbeatResponse nodeHeartbeat = nm1.nodeHeartbeat(true);
        Assert.assertEquals((long)4000L, (long)nodeHeartbeat.getNextHeartBeatInterval());
        NodeHeartbeatResponse nodeHeartbeat2 = nm2.nodeHeartbeat(true);
        Assert.assertEquals((long)4000L, (long)nodeHeartbeat2.getNextHeartBeatInterval());
    }

    @Test
    public void testDecommissionWithIncludeHosts() throws Exception {
        this.writeToHostsFile("localhost", "host1", "host2");
        Configuration conf = new Configuration();
        conf.set("yarn.resourcemanager.nodes.include-path", this.hostFile.getAbsolutePath());
        this.rm = new MockRM(conf);
        this.rm.start();
        MockNM nm1 = this.rm.registerNode("host1:1234", 5120);
        MockNM nm2 = this.rm.registerNode("host2:5678", 10240);
        MockNM nm3 = this.rm.registerNode("localhost:4433", 1024);
        ClusterMetrics metrics = ClusterMetrics.getMetrics();
        assert (metrics != null);
        int metricCount = metrics.getNumDecommisionedNMs();
        NodeHeartbeatResponse nodeHeartbeat = nm1.nodeHeartbeat(true);
        Assert.assertTrue((boolean)NodeAction.NORMAL.equals((Object)nodeHeartbeat.getNodeAction()));
        nodeHeartbeat = nm2.nodeHeartbeat(true);
        Assert.assertTrue((boolean)NodeAction.NORMAL.equals((Object)nodeHeartbeat.getNodeAction()));
        nodeHeartbeat = nm3.nodeHeartbeat(true);
        Assert.assertTrue((boolean)NodeAction.NORMAL.equals((Object)nodeHeartbeat.getNodeAction()));
        String ip = NetUtils.normalizeHostName((String)"localhost");
        this.writeToHostsFile("host1", ip);
        this.rm.getNodesListManager().refreshNodes(conf);
        this.checkShutdownNMCount(this.rm, ++metricCount);
        nodeHeartbeat = nm1.nodeHeartbeat(true);
        Assert.assertTrue((boolean)NodeAction.NORMAL.equals((Object)nodeHeartbeat.getNodeAction()));
        Assert.assertEquals((long)1L, (long)ClusterMetrics.getMetrics().getNumShutdownNMs());
        nodeHeartbeat = nm2.nodeHeartbeat(true);
        Assert.assertTrue((String)"Node is not decommisioned.", (boolean)NodeAction.SHUTDOWN.equals((Object)nodeHeartbeat.getNodeAction()));
        nodeHeartbeat = nm3.nodeHeartbeat(true);
        Assert.assertTrue((boolean)NodeAction.NORMAL.equals((Object)nodeHeartbeat.getNodeAction()));
        Assert.assertEquals((long)metricCount, (long)ClusterMetrics.getMetrics().getNumShutdownNMs());
        this.rm.stop();
    }

    @Test
    public void testDecommissionWithExcludeHosts() throws Exception {
        Configuration conf = new Configuration();
        conf.set("yarn.resourcemanager.nodes.exclude-path", this.hostFile.getAbsolutePath());
        this.writeToHostsFile("");
        this.rm = new MockRM(conf);
        this.rm.start();
        DrainDispatcher dispatcher = (DrainDispatcher)this.rm.getRMContext().getDispatcher();
        MockNM nm1 = this.rm.registerNode("host1:1234", 5120);
        MockNM nm2 = this.rm.registerNode("host2:5678", 10240);
        MockNM nm3 = this.rm.registerNode("localhost:4433", 1024);
        this.rm.drainEvents();
        int metricCount = ClusterMetrics.getMetrics().getNumDecommisionedNMs();
        NodeHeartbeatResponse nodeHeartbeat = nm1.nodeHeartbeat(true);
        Assert.assertTrue((boolean)NodeAction.NORMAL.equals((Object)nodeHeartbeat.getNodeAction()));
        nodeHeartbeat = nm2.nodeHeartbeat(true);
        Assert.assertTrue((boolean)NodeAction.NORMAL.equals((Object)nodeHeartbeat.getNodeAction()));
        this.rm.drainEvents();
        String ip = NetUtils.normalizeHostName((String)"localhost");
        this.writeToHostsFile("host2", ip);
        this.rm.getNodesListManager().refreshNodes(conf);
        this.checkDecommissionedNMCount(this.rm, metricCount + 2);
        nodeHeartbeat = nm1.nodeHeartbeat(true);
        Assert.assertTrue((boolean)NodeAction.NORMAL.equals((Object)nodeHeartbeat.getNodeAction()));
        nodeHeartbeat = nm2.nodeHeartbeat(true);
        Assert.assertTrue((String)"The decommisioned metrics are not updated", (boolean)NodeAction.SHUTDOWN.equals((Object)nodeHeartbeat.getNodeAction()));
        nodeHeartbeat = nm3.nodeHeartbeat(true);
        Assert.assertTrue((String)"The decommisioned metrics are not updated", (boolean)NodeAction.SHUTDOWN.equals((Object)nodeHeartbeat.getNodeAction()));
        this.rm.drainEvents();
        this.writeToHostsFile("");
        this.rm.getNodesListManager().refreshNodes(conf);
        nm3 = this.rm.registerNode("localhost:4433", 1024);
        this.rm.drainEvents();
        nodeHeartbeat = nm3.nodeHeartbeat(true);
        this.rm.drainEvents();
        Assert.assertTrue((boolean)NodeAction.NORMAL.equals((Object)nodeHeartbeat.getNodeAction()));
        this.checkDecommissionedNMCount(this.rm, metricCount + 1);
    }

    @Test
    public void testGracefulDecommissionNoApp() throws Exception {
        Configuration conf = new Configuration();
        conf.set("yarn.resourcemanager.nodes.exclude-path", this.hostFile.getAbsolutePath());
        this.writeToHostsFile("");
        this.rm = new MockRM(conf);
        this.rm.start();
        MockNM nm1 = this.rm.registerNode("host1:1234", 5120);
        MockNM nm2 = this.rm.registerNode("host2:5678", 10240);
        MockNM nm3 = this.rm.registerNode("host3:4433", 5120);
        int metricCount = ClusterMetrics.getMetrics().getNumDecommisionedNMs();
        NodeHeartbeatResponse nodeHeartbeat1 = nm1.nodeHeartbeat(true);
        NodeHeartbeatResponse nodeHeartbeat2 = nm2.nodeHeartbeat(true);
        NodeHeartbeatResponse nodeHeartbeat3 = nm3.nodeHeartbeat(true);
        Assert.assertTrue((boolean)NodeAction.NORMAL.equals((Object)nodeHeartbeat1.getNodeAction()));
        Assert.assertTrue((boolean)NodeAction.NORMAL.equals((Object)nodeHeartbeat2.getNodeAction()));
        Assert.assertTrue((boolean)NodeAction.NORMAL.equals((Object)nodeHeartbeat3.getNodeAction()));
        this.rm.waitForState(nm2.getNodeId(), NodeState.RUNNING);
        this.rm.waitForState(nm3.getNodeId(), NodeState.RUNNING);
        this.writeToHostsFile("host2", "host3");
        this.rm.getNodesListManager().refreshNodesGracefully(conf);
        this.rm.waitForState(nm2.getNodeId(), NodeState.DECOMMISSIONING);
        this.rm.waitForState(nm3.getNodeId(), NodeState.DECOMMISSIONING);
        nodeHeartbeat1 = nm1.nodeHeartbeat(true);
        nodeHeartbeat2 = nm2.nodeHeartbeat(true);
        nodeHeartbeat3 = nm3.nodeHeartbeat(true);
        this.checkDecommissionedNMCount(this.rm, metricCount + 2);
        this.rm.waitForState(nm2.getNodeId(), NodeState.DECOMMISSIONED);
        this.rm.waitForState(nm3.getNodeId(), NodeState.DECOMMISSIONED);
        Assert.assertTrue((boolean)NodeAction.NORMAL.equals((Object)nodeHeartbeat1.getNodeAction()));
        nodeHeartbeat2 = nm2.nodeHeartbeat(true);
        nodeHeartbeat3 = nm3.nodeHeartbeat(true);
        Assert.assertEquals((Object)NodeAction.SHUTDOWN, (Object)nodeHeartbeat2.getNodeAction());
        Assert.assertEquals((Object)NodeAction.SHUTDOWN, (Object)nodeHeartbeat3.getNodeAction());
    }

    @Test(timeout=75000L)
    public void testNodeHeartbeatWithUpdatedCryptoMaterialForApp() throws Exception {
        Configuration conf = new Configuration();
        conf.set("yarn.resourcemanager.certificate.expiration-safety-period", "30s");
        conf.setBoolean("ipc.server.ssl.enabled", true);
        this.rm = new MockRM(conf);
        this.rm.start();
        MockNM nm1 = this.rm.registerNode("localhost:1234", 5120);
        NodeHeartbeatResponse response = nm1.nodeHeartbeat(true);
        this.rm.waitForState(nm1.getNodeId(), NodeState.RUNNING);
        Assert.assertNotNull((Object)response.getUpdatedCryptoForApps());
        Assert.assertTrue((boolean)response.getUpdatedCryptoForApps().isEmpty());
        RMApp app = this.rm.submitApp(2048);
        MockAM am = MockRM.launchAndRegisterAM(app, this.rm, nm1);
        ApplicationAttemptId appAttemptId = app.getCurrentAppAttempt().getAppAttemptId();
        nm1.nodeHeartbeat(appAttemptId, 2L, ContainerState.RUNNING);
        this.rm.waitForState(appAttemptId, RMAppAttemptState.RUNNING);
        response = nm1.nodeHeartbeat(true);
        Assert.assertNotNull((Object)response.getUpdatedCryptoForApps());
        Assert.assertTrue((boolean)response.getUpdatedCryptoForApps().isEmpty());
        TimeUnit.SECONDS.sleep(25L);
        response = nm1.nodeHeartbeat(true);
        Assert.assertNotNull((Object)response.getUpdatedCryptoForApps());
        Assert.assertEquals((long)1L, (long)response.getUpdatedCryptoForApps().size());
        Assert.assertTrue((boolean)response.getUpdatedCryptoForApps().containsKey(app.getApplicationId()));
        UpdatedCryptoForApp updatedCryptoForApp = (UpdatedCryptoForApp)response.getUpdatedCryptoForApps().get(app.getApplicationId());
        Assert.assertTrue((boolean)updatedCryptoForApp.getKeyStore().equals(ByteBuffer.wrap(app.getKeyStore())));
        Assert.assertTrue((boolean)updatedCryptoForApp.getTrustStore().equals(ByteBuffer.wrap(app.getTrustStore())));
        Assert.assertArrayEquals((char[])app.getKeyStorePassword(), (char[])updatedCryptoForApp.getKeyStorePassword());
        Assert.assertArrayEquals((char[])app.getTrustStorePassword(), (char[])updatedCryptoForApp.getTrustStorePassword());
        TimeUnit.SECONDS.sleep(25L);
        response = nm1.nodeHeartbeat(true);
        Assert.assertNotNull((Object)response.getUpdatedCryptoForApps());
        Assert.assertEquals((long)1L, (long)response.getUpdatedCryptoForApps().size());
        Assert.assertTrue((boolean)response.getUpdatedCryptoForApps().containsKey(app.getApplicationId()));
        UpdatedCryptoForApp newUpdatedCryptoForApp = (UpdatedCryptoForApp)response.getUpdatedCryptoForApps().get(app.getApplicationId());
        Assert.assertTrue((boolean)newUpdatedCryptoForApp.getKeyStore().equals(ByteBuffer.wrap(app.getKeyStore())));
        Assert.assertTrue((boolean)newUpdatedCryptoForApp.getTrustStore().equals(ByteBuffer.wrap(app.getTrustStore())));
        Assert.assertArrayEquals((char[])app.getKeyStorePassword(), (char[])newUpdatedCryptoForApp.getKeyStorePassword());
        Assert.assertArrayEquals((char[])app.getTrustStorePassword(), (char[])newUpdatedCryptoForApp.getTrustStorePassword());
        Assert.assertFalse((boolean)newUpdatedCryptoForApp.getKeyStore().equals(updatedCryptoForApp.getKeyStore()));
        this.rm.killApp(app.getApplicationId());
        this.rm.waitForState(app.getApplicationId(), RMAppState.KILLED);
        response = nm1.nodeHeartbeat(true);
        Assert.assertNotNull((Object)response.getUpdatedCryptoForApps());
        Assert.assertTrue((boolean)response.getUpdatedCryptoForApps().isEmpty());
        RMNode rmNode = (RMNode)this.rm.getRMContext().getRMNodes().get(nm1.getNodeId());
        Assert.assertTrue((boolean)rmNode.getAppCryptoMaterialToUpdate().isEmpty());
        this.rm.stop();
    }

    @Test
    public void testGracefulDecommissionWithApp() throws Exception {
        Configuration conf = new Configuration();
        conf.set("yarn.resourcemanager.nodes.exclude-path", this.hostFile.getAbsolutePath());
        this.writeToHostsFile("");
        this.rm = new MockRM(conf);
        this.rm.start();
        MockNM nm1 = this.rm.registerNode("host1:1234", 10240);
        MockNM nm2 = this.rm.registerNode("host2:5678", 20480);
        MockNM nm3 = this.rm.registerNode("host3:4433", 10240);
        NodeId id1 = nm1.getNodeId();
        NodeId id3 = nm3.getNodeId();
        this.rm.waitForState(id1, NodeState.RUNNING);
        this.rm.waitForState(id3, NodeState.RUNNING);
        RMApp app = this.rm.submitApp(2000);
        MockAM am = MockRM.launchAndRegisterAM(app, this.rm, nm1);
        ApplicationAttemptId aaid = app.getCurrentAppAttempt().getAppAttemptId();
        nm1.nodeHeartbeat(aaid, 2L, ContainerState.RUNNING);
        nm3.nodeHeartbeat(true);
        this.writeToHostsFile("host1", "host3");
        this.rm.getNodesListManager().refreshNodesGracefully(conf);
        this.rm.waitForState(id1, NodeState.DECOMMISSIONING);
        this.rm.waitForState(id3, NodeState.DECOMMISSIONING);
        nm1.nodeHeartbeat(true);
        nm3.nodeHeartbeat(true);
        this.rm.waitForState(id1, NodeState.DECOMMISSIONING);
        this.rm.waitForState(id3, NodeState.DECOMMISSIONED);
        nm1.nodeHeartbeat(aaid, 2L, ContainerState.RUNNING);
        NodeHeartbeatResponse nodeHeartbeat1 = nm1.nodeHeartbeat(aaid, 2L, ContainerState.COMPLETE);
        Assert.assertEquals((Object)NodeAction.NORMAL, (Object)nodeHeartbeat1.getNodeAction());
        MockRM.finishAMAndVerifyAppState(app, this.rm, nm1, am);
        this.rm.waitForState(app.getApplicationId(), RMAppState.FINISHED);
        nodeHeartbeat1 = nm1.nodeHeartbeat(aaid, 2L, ContainerState.COMPLETE);
        Assert.assertEquals((Object)NodeAction.NORMAL, (Object)nodeHeartbeat1.getNodeAction());
        this.rm.waitForState(id1, NodeState.DECOMMISSIONED);
        nodeHeartbeat1 = nm1.nodeHeartbeat(true);
        Assert.assertEquals((Object)NodeAction.SHUTDOWN, (Object)nodeHeartbeat1.getNodeAction());
    }

    @Test
    public void testAddNewIncludePathToConfiguration() throws Exception {
        Configuration conf = new Configuration();
        this.rm = new MockRM(conf);
        this.rm.start();
        MockNM nm1 = this.rm.registerNode("host1:1234", 5120);
        MockNM nm2 = this.rm.registerNode("host2:5678", 10240);
        ClusterMetrics metrics = ClusterMetrics.getMetrics();
        assert (metrics != null);
        int initialMetricCount = metrics.getNumShutdownNMs();
        NodeHeartbeatResponse nodeHeartbeat = nm1.nodeHeartbeat(true);
        Assert.assertEquals((Object)NodeAction.NORMAL, (Object)nodeHeartbeat.getNodeAction());
        nodeHeartbeat = nm2.nodeHeartbeat(true);
        Assert.assertEquals((Object)NodeAction.NORMAL, (Object)nodeHeartbeat.getNodeAction());
        this.writeToHostsFile("host1");
        conf.set("yarn.resourcemanager.nodes.include-path", this.hostFile.getAbsolutePath());
        this.rm.getNodesListManager().refreshNodes(conf);
        this.checkShutdownNMCount(this.rm, ++initialMetricCount);
        nodeHeartbeat = nm1.nodeHeartbeat(true);
        Assert.assertEquals((String)"Node should not have been shutdown.", (Object)NodeAction.NORMAL, (Object)nodeHeartbeat.getNodeAction());
        NodeState nodeState = ((RMNode)this.rm.getRMContext().getInactiveRMNodes().get(nm2.getNodeId())).getState();
        Assert.assertEquals((String)("Node should have been shutdown but is in state" + nodeState), (Object)NodeState.SHUTDOWN, (Object)nodeState);
    }

    @Test
    public void testAddNewExcludePathToConfiguration() throws Exception {
        Configuration conf = new Configuration();
        this.rm = new MockRM(conf);
        this.rm.start();
        MockNM nm1 = this.rm.registerNode("host1:1234", 5120);
        MockNM nm2 = this.rm.registerNode("host2:5678", 10240);
        ClusterMetrics metrics = ClusterMetrics.getMetrics();
        assert (metrics != null);
        int initialMetricCount = metrics.getNumDecommisionedNMs();
        NodeHeartbeatResponse nodeHeartbeat = nm1.nodeHeartbeat(true);
        Assert.assertEquals((Object)NodeAction.NORMAL, (Object)nodeHeartbeat.getNodeAction());
        nodeHeartbeat = nm2.nodeHeartbeat(true);
        Assert.assertEquals((Object)NodeAction.NORMAL, (Object)nodeHeartbeat.getNodeAction());
        this.writeToHostsFile("host2");
        conf.set("yarn.resourcemanager.nodes.exclude-path", this.hostFile.getAbsolutePath());
        this.rm.getNodesListManager().refreshNodes(conf);
        this.checkDecommissionedNMCount(this.rm, ++initialMetricCount);
        nodeHeartbeat = nm1.nodeHeartbeat(true);
        Assert.assertEquals((String)"Node should not have been decomissioned.", (Object)NodeAction.NORMAL, (Object)nodeHeartbeat.getNodeAction());
        nodeHeartbeat = nm2.nodeHeartbeat(true);
        Assert.assertEquals((String)("Node should have been decomissioned but is in state" + nodeHeartbeat.getNodeAction()), (Object)NodeAction.SHUTDOWN, (Object)nodeHeartbeat.getNodeAction());
    }

    @Test
    public void testNodeRegistrationSuccess() throws Exception {
        this.writeToHostsFile("host2");
        Configuration conf = new Configuration();
        conf.set("yarn.resourcemanager.nodes.include-path", this.hostFile.getAbsolutePath());
        this.rm = new MockRM(conf);
        this.rm.start();
        ResourceTrackerService resourceTrackerService = this.rm.getResourceTrackerService();
        RegisterNodeManagerRequest req = (RegisterNodeManagerRequest)Records.newRecord(RegisterNodeManagerRequest.class);
        NodeId nodeId = NodeId.newInstance((String)"host2", (int)1234);
        org.apache.hadoop.yarn.api.records.Resource capability = BuilderUtils.newResource((long)1024L, (int)1);
        req.setResource(capability);
        req.setNodeId(nodeId);
        req.setHttpPort(1234);
        req.setNMVersion(YarnVersionInfo.getVersion());
        RegisterNodeManagerResponse response = resourceTrackerService.registerNodeManager(req);
        Assert.assertEquals((Object)NodeAction.NORMAL, (Object)response.getNodeAction());
    }

    @Test
    public void testNodeRegistrationWithLabels() throws Exception {
        this.writeToHostsFile("host2");
        Configuration conf = new Configuration();
        conf.set("yarn.resourcemanager.nodes.include-path", this.hostFile.getAbsolutePath());
        conf.set("yarn.node-labels.configuration-type", "distributed");
        final NullRMNodeLabelsManager nodeLabelsMgr = new NullRMNodeLabelsManager();
        this.rm = new MockRM(conf){

            @Override
            protected RMNodeLabelsManager createNodeLabelManager() {
                return nodeLabelsMgr;
            }
        };
        this.rm.start();
        try {
            nodeLabelsMgr.addToCluserNodeLabelsWithDefaultExclusivity(TestResourceTrackerService.toSet((Object[])new String[]{"A", "B", "C"}));
        }
        catch (IOException e) {
            Assert.fail((String)"Caught Exception while intializing");
            e.printStackTrace();
        }
        ResourceTrackerService resourceTrackerService = this.rm.getResourceTrackerService();
        RegisterNodeManagerRequest registerReq = (RegisterNodeManagerRequest)Records.newRecord(RegisterNodeManagerRequest.class);
        NodeId nodeId = NodeId.newInstance((String)"host2", (int)1234);
        org.apache.hadoop.yarn.api.records.Resource capability = BuilderUtils.newResource((long)1024L, (int)1);
        registerReq.setResource(capability);
        registerReq.setNodeId(nodeId);
        registerReq.setHttpPort(1234);
        registerReq.setNMVersion(YarnVersionInfo.getVersion());
        registerReq.setNodeLabels(TestResourceTrackerService.toSet((Object[])new NodeLabel[]{NodeLabel.newInstance((String)"A")}));
        RegisterNodeManagerResponse response = resourceTrackerService.registerNodeManager(registerReq);
        Assert.assertEquals((String)"Action should be normal on valid Node Labels", (Object)NodeAction.NORMAL, (Object)response.getNodeAction());
        TestResourceTrackerService.assertCollectionEquals((Collection)((Collection)nodeLabelsMgr.getNodeLabels().get(nodeId)), (Collection)NodeLabelsUtils.convertToStringSet((Set)registerReq.getNodeLabels()));
        Assert.assertTrue((String)"Valid Node Labels were not accepted by RM", (boolean)response.getAreNodeLabelsAcceptedByRM());
        this.rm.stop();
    }

    @Test
    public void testNodeRegistrationWithInvalidLabels() throws Exception {
        this.writeToHostsFile("host2");
        Configuration conf = new Configuration();
        conf.set("yarn.resourcemanager.nodes.include-path", this.hostFile.getAbsolutePath());
        conf.set("yarn.node-labels.configuration-type", "distributed");
        final NullRMNodeLabelsManager nodeLabelsMgr = new NullRMNodeLabelsManager();
        this.rm = new MockRM(conf){

            @Override
            protected RMNodeLabelsManager createNodeLabelManager() {
                return nodeLabelsMgr;
            }
        };
        this.rm.start();
        try {
            nodeLabelsMgr.addToCluserNodeLabelsWithDefaultExclusivity(TestResourceTrackerService.toSet((Object[])new String[]{"X", "Y", "Z"}));
        }
        catch (IOException e) {
            Assert.fail((String)"Caught Exception while intializing");
            e.printStackTrace();
        }
        ResourceTrackerService resourceTrackerService = this.rm.getResourceTrackerService();
        RegisterNodeManagerRequest registerReq = (RegisterNodeManagerRequest)Records.newRecord(RegisterNodeManagerRequest.class);
        NodeId nodeId = NodeId.newInstance((String)"host2", (int)1234);
        org.apache.hadoop.yarn.api.records.Resource capability = BuilderUtils.newResource((long)1024L, (int)1);
        registerReq.setResource(capability);
        registerReq.setNodeId(nodeId);
        registerReq.setHttpPort(1234);
        registerReq.setNMVersion(YarnVersionInfo.getVersion());
        registerReq.setNodeLabels(TestResourceTrackerService.toNodeLabelSet((String[])new String[]{"A", "B", "C"}));
        RegisterNodeManagerResponse response = resourceTrackerService.registerNodeManager(registerReq);
        Assert.assertEquals((String)"On Invalid Node Labels action is expected to be normal", (Object)NodeAction.NORMAL, (Object)response.getNodeAction());
        Assert.assertNull(nodeLabelsMgr.getNodeLabels().get(nodeId));
        Assert.assertNotNull((Object)response.getDiagnosticsMessage());
        Assert.assertFalse((String)"Node Labels should not accepted by RM If Invalid", (boolean)response.getAreNodeLabelsAcceptedByRM());
        if (this.rm != null) {
            this.rm.stop();
        }
    }

    @Test
    public void testNodeRegistrationWithInvalidLabelsSyntax() throws Exception {
        this.writeToHostsFile("host2");
        Configuration conf = new Configuration();
        conf.set("yarn.resourcemanager.nodes.include-path", this.hostFile.getAbsolutePath());
        conf.set("yarn.node-labels.configuration-type", "distributed");
        final NullRMNodeLabelsManager nodeLabelsMgr = new NullRMNodeLabelsManager();
        this.rm = new MockRM(conf){

            @Override
            protected RMNodeLabelsManager createNodeLabelManager() {
                return nodeLabelsMgr;
            }
        };
        this.rm.start();
        try {
            nodeLabelsMgr.addToCluserNodeLabelsWithDefaultExclusivity(TestResourceTrackerService.toSet((Object[])new String[]{"X", "Y", "Z"}));
        }
        catch (IOException e) {
            Assert.fail((String)"Caught Exception while intializing");
            e.printStackTrace();
        }
        ResourceTrackerService resourceTrackerService = this.rm.getResourceTrackerService();
        RegisterNodeManagerRequest req = (RegisterNodeManagerRequest)Records.newRecord(RegisterNodeManagerRequest.class);
        NodeId nodeId = NodeId.newInstance((String)"host2", (int)1234);
        org.apache.hadoop.yarn.api.records.Resource capability = BuilderUtils.newResource((long)1024L, (int)1);
        req.setResource(capability);
        req.setNodeId(nodeId);
        req.setHttpPort(1234);
        req.setNMVersion(YarnVersionInfo.getVersion());
        req.setNodeLabels(TestResourceTrackerService.toNodeLabelSet((String[])new String[]{"#Y"}));
        RegisterNodeManagerResponse response = resourceTrackerService.registerNodeManager(req);
        Assert.assertEquals((String)"On Invalid Node Labels action is expected to be normal", (Object)NodeAction.NORMAL, (Object)response.getNodeAction());
        Assert.assertNull(nodeLabelsMgr.getNodeLabels().get(nodeId));
        Assert.assertNotNull((Object)response.getDiagnosticsMessage());
        Assert.assertFalse((String)"Node Labels should not accepted by RM If Invalid", (boolean)response.getAreNodeLabelsAcceptedByRM());
        if (this.rm != null) {
            this.rm.stop();
        }
    }

    @Test
    public void testNodeRegistrationWithCentralLabelConfig() throws Exception {
        this.writeToHostsFile("host2");
        Configuration conf = new Configuration();
        conf.set("yarn.resourcemanager.nodes.include-path", this.hostFile.getAbsolutePath());
        conf.set("yarn.node-labels.configuration-type", "centralized");
        final NullRMNodeLabelsManager nodeLabelsMgr = new NullRMNodeLabelsManager();
        this.rm = new MockRM(conf){

            @Override
            protected RMNodeLabelsManager createNodeLabelManager() {
                return nodeLabelsMgr;
            }
        };
        this.rm.start();
        try {
            nodeLabelsMgr.addToCluserNodeLabelsWithDefaultExclusivity(TestResourceTrackerService.toSet((Object[])new String[]{"A", "B", "C"}));
        }
        catch (IOException e) {
            Assert.fail((String)"Caught Exception while intializing");
            e.printStackTrace();
        }
        ResourceTrackerService resourceTrackerService = this.rm.getResourceTrackerService();
        RegisterNodeManagerRequest req = (RegisterNodeManagerRequest)Records.newRecord(RegisterNodeManagerRequest.class);
        NodeId nodeId = NodeId.newInstance((String)"host2", (int)1234);
        org.apache.hadoop.yarn.api.records.Resource capability = BuilderUtils.newResource((long)1024L, (int)1);
        req.setResource(capability);
        req.setNodeId(nodeId);
        req.setHttpPort(1234);
        req.setNMVersion(YarnVersionInfo.getVersion());
        req.setNodeLabels(TestResourceTrackerService.toNodeLabelSet((String[])new String[]{"A"}));
        RegisterNodeManagerResponse response = resourceTrackerService.registerNodeManager(req);
        Assert.assertEquals((Object)NodeAction.NORMAL, (Object)response.getNodeAction());
        Assert.assertNull(nodeLabelsMgr.getNodeLabels().get(nodeId));
        Assert.assertFalse((String)"Node Labels should not accepted by RM If its configured with Central configuration", (boolean)response.getAreNodeLabelsAcceptedByRM());
        if (this.rm != null) {
            this.rm.stop();
        }
    }

    private NodeStatus getNodeStatusObject(NodeId nodeId) {
        NodeStatus status = (NodeStatus)Records.newRecord(NodeStatus.class);
        status.setNodeId(nodeId);
        status.setResponseId(0);
        status.setContainersStatuses(Collections.EMPTY_LIST);
        status.setKeepAliveApplications(Collections.EMPTY_LIST);
        return status;
    }

    @Test
    public void testNodeHeartBeatWithLabels() throws Exception {
        this.writeToHostsFile("host2");
        Configuration conf = new Configuration();
        conf.set("yarn.resourcemanager.nodes.include-path", this.hostFile.getAbsolutePath());
        conf.set("yarn.node-labels.configuration-type", "distributed");
        final NullRMNodeLabelsManager nodeLabelsMgr = new NullRMNodeLabelsManager();
        this.rm = new MockRM(conf){

            @Override
            protected RMNodeLabelsManager createNodeLabelManager() {
                return nodeLabelsMgr;
            }
        };
        this.rm.start();
        try {
            nodeLabelsMgr.addToCluserNodeLabelsWithDefaultExclusivity(TestResourceTrackerService.toSet((Object[])new String[]{"A", "B", "C"}));
        }
        catch (IOException e) {
            Assert.fail((String)"Caught Exception while intializing");
            e.printStackTrace();
        }
        ResourceTrackerService resourceTrackerService = this.rm.getResourceTrackerService();
        RegisterNodeManagerRequest registerReq = (RegisterNodeManagerRequest)Records.newRecord(RegisterNodeManagerRequest.class);
        NodeId nodeId = NodeId.newInstance((String)"host2", (int)1234);
        org.apache.hadoop.yarn.api.records.Resource capability = BuilderUtils.newResource((long)1024L, (int)1);
        registerReq.setResource(capability);
        registerReq.setNodeId(nodeId);
        registerReq.setHttpPort(1234);
        registerReq.setNMVersion(YarnVersionInfo.getVersion());
        registerReq.setNodeLabels(TestResourceTrackerService.toNodeLabelSet((String[])new String[]{"A"}));
        RegisterNodeManagerResponse registerResponse = resourceTrackerService.registerNodeManager(registerReq);
        NodeHeartbeatRequest heartbeatReq = (NodeHeartbeatRequest)Records.newRecord(NodeHeartbeatRequest.class);
        heartbeatReq.setNodeLabels(TestResourceTrackerService.toNodeLabelSet((String[])new String[]{"B"}));
        NodeStatus nodeStatusObject = this.getNodeStatusObject(nodeId);
        heartbeatReq.setNodeStatus(nodeStatusObject);
        heartbeatReq.setLastKnownNMTokenMasterKey(registerResponse.getNMTokenMasterKey());
        heartbeatReq.setLastKnownContainerTokenMasterKey(registerResponse.getContainerTokenMasterKey());
        NodeHeartbeatResponse nodeHeartbeatResponse = resourceTrackerService.nodeHeartbeat(heartbeatReq);
        Assert.assertEquals((String)"InValid Node Labels were not accepted by RM", (Object)NodeAction.NORMAL, (Object)nodeHeartbeatResponse.getNodeAction());
        TestResourceTrackerService.assertCollectionEquals((Collection)((Collection)nodeLabelsMgr.getNodeLabels().get(nodeId)), (Collection)NodeLabelsUtils.convertToStringSet((Set)heartbeatReq.getNodeLabels()));
        Assert.assertTrue((String)"Valid Node Labels were not accepted by RM", (boolean)nodeHeartbeatResponse.getAreNodeLabelsAcceptedByRM());
        Set oldLabels = (Set)nodeLabelsMgr.getNodeLabels().get(nodeId);
        int responseId = nodeStatusObject.getResponseId();
        heartbeatReq = (NodeHeartbeatRequest)Records.newRecord(NodeHeartbeatRequest.class);
        heartbeatReq.setNodeLabels(null);
        nodeStatusObject = this.getNodeStatusObject(nodeId);
        nodeStatusObject.setResponseId(responseId + 2);
        heartbeatReq.setNodeStatus(nodeStatusObject);
        heartbeatReq.setLastKnownNMTokenMasterKey(registerResponse.getNMTokenMasterKey());
        heartbeatReq.setLastKnownContainerTokenMasterKey(registerResponse.getContainerTokenMasterKey());
        nodeHeartbeatResponse = resourceTrackerService.nodeHeartbeat(heartbeatReq);
        Assert.assertEquals((String)"InValid Node Labels were not accepted by RM", (Object)NodeAction.NORMAL, (Object)nodeHeartbeatResponse.getNodeAction());
        TestResourceTrackerService.assertCollectionEquals((Collection)((Collection)nodeLabelsMgr.getNodeLabels().get(nodeId)), (Collection)oldLabels);
        Assert.assertFalse((String)"Node Labels should not accepted by RM", (boolean)nodeHeartbeatResponse.getAreNodeLabelsAcceptedByRM());
        this.rm.stop();
    }

    @Test
    public void testNodeHeartBeatWithInvalidLabels() throws Exception {
        this.writeToHostsFile("host2");
        Configuration conf = new Configuration();
        conf.set("yarn.resourcemanager.nodes.include-path", this.hostFile.getAbsolutePath());
        conf.set("yarn.node-labels.configuration-type", "distributed");
        final NullRMNodeLabelsManager nodeLabelsMgr = new NullRMNodeLabelsManager();
        this.rm = new MockRM(conf){

            @Override
            protected RMNodeLabelsManager createNodeLabelManager() {
                return nodeLabelsMgr;
            }
        };
        this.rm.start();
        try {
            nodeLabelsMgr.addToCluserNodeLabelsWithDefaultExclusivity(TestResourceTrackerService.toSet((Object[])new String[]{"A", "B", "C"}));
        }
        catch (IOException e) {
            Assert.fail((String)"Caught Exception while intializing");
            e.printStackTrace();
        }
        ResourceTrackerService resourceTrackerService = this.rm.getResourceTrackerService();
        RegisterNodeManagerRequest registerReq = (RegisterNodeManagerRequest)Records.newRecord(RegisterNodeManagerRequest.class);
        NodeId nodeId = NodeId.newInstance((String)"host2", (int)1234);
        org.apache.hadoop.yarn.api.records.Resource capability = BuilderUtils.newResource((long)1024L, (int)1);
        registerReq.setResource(capability);
        registerReq.setNodeId(nodeId);
        registerReq.setHttpPort(1234);
        registerReq.setNMVersion(YarnVersionInfo.getVersion());
        registerReq.setNodeLabels(TestResourceTrackerService.toNodeLabelSet((String[])new String[]{"A"}));
        RegisterNodeManagerResponse registerResponse = resourceTrackerService.registerNodeManager(registerReq);
        NodeHeartbeatRequest heartbeatReq = (NodeHeartbeatRequest)Records.newRecord(NodeHeartbeatRequest.class);
        heartbeatReq.setNodeLabels(TestResourceTrackerService.toNodeLabelSet((String[])new String[]{"B", "#C"}));
        heartbeatReq.setNodeStatus(this.getNodeStatusObject(nodeId));
        heartbeatReq.setLastKnownNMTokenMasterKey(registerResponse.getNMTokenMasterKey());
        heartbeatReq.setLastKnownContainerTokenMasterKey(registerResponse.getContainerTokenMasterKey());
        NodeHeartbeatResponse nodeHeartbeatResponse = resourceTrackerService.nodeHeartbeat(heartbeatReq);
        Assert.assertEquals((String)"Response should be NORMAL when RM heartbeat labels are rejected", (Object)NodeAction.NORMAL, (Object)nodeHeartbeatResponse.getNodeAction());
        Assert.assertFalse((boolean)nodeHeartbeatResponse.getAreNodeLabelsAcceptedByRM());
        Assert.assertNotNull((Object)nodeHeartbeatResponse.getDiagnosticsMessage());
        this.rm.stop();
    }

    @Test
    public void testNodeHeartbeatWithCentralLabelConfig() throws Exception {
        this.writeToHostsFile("host2");
        Configuration conf = new Configuration();
        conf.set("yarn.resourcemanager.nodes.include-path", this.hostFile.getAbsolutePath());
        conf.set("yarn.node-labels.configuration-type", "centralized");
        final NullRMNodeLabelsManager nodeLabelsMgr = new NullRMNodeLabelsManager();
        this.rm = new MockRM(conf){

            @Override
            protected RMNodeLabelsManager createNodeLabelManager() {
                return nodeLabelsMgr;
            }
        };
        this.rm.start();
        ResourceTrackerService resourceTrackerService = this.rm.getResourceTrackerService();
        RegisterNodeManagerRequest req = (RegisterNodeManagerRequest)Records.newRecord(RegisterNodeManagerRequest.class);
        NodeId nodeId = NodeId.newInstance((String)"host2", (int)1234);
        org.apache.hadoop.yarn.api.records.Resource capability = BuilderUtils.newResource((long)1024L, (int)1);
        req.setResource(capability);
        req.setNodeId(nodeId);
        req.setHttpPort(1234);
        req.setNMVersion(YarnVersionInfo.getVersion());
        req.setNodeLabels(TestResourceTrackerService.toNodeLabelSet((String[])new String[]{"A", "B", "C"}));
        RegisterNodeManagerResponse registerResponse = resourceTrackerService.registerNodeManager(req);
        NodeHeartbeatRequest heartbeatReq = (NodeHeartbeatRequest)Records.newRecord(NodeHeartbeatRequest.class);
        heartbeatReq.setNodeLabels(TestResourceTrackerService.toNodeLabelSet((String[])new String[]{"B"}));
        heartbeatReq.setNodeStatus(this.getNodeStatusObject(nodeId));
        heartbeatReq.setLastKnownNMTokenMasterKey(registerResponse.getNMTokenMasterKey());
        heartbeatReq.setLastKnownContainerTokenMasterKey(registerResponse.getContainerTokenMasterKey());
        NodeHeartbeatResponse nodeHeartbeatResponse = resourceTrackerService.nodeHeartbeat(heartbeatReq);
        Assert.assertEquals((Object)NodeAction.NORMAL, (Object)nodeHeartbeatResponse.getNodeAction());
        Assert.assertNull(nodeLabelsMgr.getNodeLabels().get(nodeId));
        Assert.assertFalse((String)"Invalid Node Labels should not accepted by RM", (boolean)nodeHeartbeatResponse.getAreNodeLabelsAcceptedByRM());
        if (this.rm != null) {
            this.rm.stop();
        }
    }

    @Test
    public void testDistributedNodeRegistrationSuccess() throws Exception {
        this.writeToHostsFile("host2");
        Configuration conf = new Configuration();
        conf.set("yarn.resourcemanager.nodes.include-path", this.hostFile.getAbsolutePath());
        conf.setBoolean("yarn.client.failover-distributed", true);
        this.rm = new MockRM(conf);
        this.rm.start();
        ResourceTrackerService resourceTrackerService = this.rm.getResourceTrackerService();
        RegisterNodeManagerRequest req = (RegisterNodeManagerRequest)Records.newRecord(RegisterNodeManagerRequest.class);
        NodeId nodeId = NodeId.newInstance((String)"host2", (int)1234);
        org.apache.hadoop.yarn.api.records.Resource capability = BuilderUtils.newResource((long)1024L, (int)1, (int)1);
        req.setResource(capability);
        req.setNodeId(nodeId);
        req.setHttpPort(1234);
        req.setNMVersion(YarnVersionInfo.getVersion());
        RegisterNodeManagerResponse response = resourceTrackerService.registerNodeManager(req);
        Thread.sleep(100L);
        Assert.assertEquals((Object)NodeAction.NORMAL, (Object)response.getNodeAction());
        Assert.assertTrue((boolean)(this.rm.getRMContext().getRMNodes().get(nodeId) instanceof RMNodeImplDist));
        Assert.assertEquals((long)1L, (long)((Load)DBUtility.getAllLoads().get(this.rm.getRMContext().getGroupMembershipService().getRMId())).getLoad());
        Map<String, io.hops.metadata.yarn.entity.RMNode> rmNodesInDb = DBUtilityTests.getAllRMNodess();
        Assert.assertEquals((long)1L, (long)rmNodesInDb.size());
        io.hops.metadata.yarn.entity.RMNode rmNode = rmNodesInDb.get(nodeId.toString());
        Assert.assertEquals((Object)"RUNNING", (Object)rmNode.getCurrentState());
        Map<String, Resource> resourcesInDb = DBUtilityTests.getAllResources();
        Assert.assertEquals((long)1L, (long)resourcesInDb.size());
        Resource resource = resourcesInDb.get(nodeId.toString());
        Assert.assertEquals((long)1024L, (long)resource.getMemory());
        Assert.assertEquals((long)1L, (long)resource.getVirtualCores());
        Assert.assertEquals((long)1L, (long)resource.getGPUs());
        List<PendingEvent> pendingEventsInDb = DBUtilityTests.getAllPendingEvents();
        Assert.assertEquals((long)1L, (long)pendingEventsInDb.size());
        PendingEvent pendingEvent = pendingEventsInDb.get(0);
        Assert.assertEquals((Object)PendingEvent.Type.NODE_ADDED, (Object)pendingEvent.getType());
        Assert.assertEquals((Object)PendingEvent.Status.NEW, (Object)pendingEvent.getStatus());
    }

    @Test
    public void testDistributedNodeHeartBeat() throws Exception {
        this.testDistributedNodeRegistrationSuccess();
        ResourceTrackerService resourceTrackerService = this.rm.getResourceTrackerService();
        NodeHeartbeatRequest request = (NodeHeartbeatRequest)Records.newRecord(NodeHeartbeatRequest.class);
        NodeId nodeId = NodeId.newInstance((String)"host2", (int)1234);
        NodeStatus status = NodeStatus.newInstance((NodeId)nodeId, (int)0, new ArrayList(), new ArrayList(), (NodeHealthStatus)NodeHealthStatus.newInstance((boolean)true, (String)"healthreport", (long)0L), null, null, null);
        request.setNodeStatus(status);
        request.setLastKnownContainerTokenMasterKey((MasterKey)new MasterKeyPBImpl());
        request.setLastKnownNMTokenMasterKey((MasterKey)new MasterKeyPBImpl());
        resourceTrackerService.nodeHeartbeat(request);
        request = (NodeHeartbeatRequest)Records.newRecord(NodeHeartbeatRequest.class);
        ArrayList<ContainerStatus> containerStatuses = new ArrayList<ContainerStatus>();
        ContainerStatus containerStatus = ContainerStatus.newInstance((ContainerId)ContainerId.newContainerId((ApplicationAttemptId)ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)0L, (int)0), (int)1), (long)1L), (ContainerState)ContainerState.RUNNING, (String)"ras", (int)0);
        containerStatuses.add(containerStatus);
        status = NodeStatus.newInstance((NodeId)nodeId, (int)1, containerStatuses, new ArrayList(), (NodeHealthStatus)NodeHealthStatus.newInstance((boolean)true, (String)"healthreport", (long)0L), null, null, null);
        request.setNodeStatus(status);
        request.setLastKnownContainerTokenMasterKey((MasterKey)new MasterKeyPBImpl());
        request.setLastKnownNMTokenMasterKey((MasterKey)new MasterKeyPBImpl());
        resourceTrackerService.nodeHeartbeat(request);
        Thread.sleep(100L);
        List<PendingEvent> pendingEventsInDB = DBUtilityTests.getAllPendingEvents();
        Assert.assertEquals((long)3L, (long)pendingEventsInDB.size());
        for (PendingEvent pendingEvent : pendingEventsInDB) {
            if (pendingEvent.getId().getEventId() == 2) {
                Assert.assertEquals((Object)PendingEvent.Status.SCHEDULER_FINISHED_PROCESSING, (Object)pendingEvent.getStatus());
                Assert.assertEquals((Object)PendingEvent.Type.NODE_UPDATED, (Object)pendingEvent.getType());
            }
            if (pendingEvent.getId().getEventId() != 3) continue;
            Assert.assertEquals((Object)PendingEvent.Status.SCHEDULER_NOT_FINISHED_PROCESSING, (Object)pendingEvent.getStatus());
            Assert.assertEquals((Object)PendingEvent.Type.NODE_UPDATED, (Object)pendingEvent.getType());
        }
        Map<String, Map<Integer, List<UpdatedContainerInfo>>> uciInDB = DBUtilityTests.getAllUCIs();
        Assert.assertEquals((long)1L, (long)uciInDB.size());
        Map<Integer, List<UpdatedContainerInfo>> subMap = uciInDB.get(nodeId.toString());
        Assert.assertEquals((long)1L, (long)subMap.size());
        List<UpdatedContainerInfo> subList = subMap.get(1);
        Assert.assertEquals((long)1L, (long)subList.size());
        UpdatedContainerInfo uci = subList.get(0);
        Assert.assertEquals((long)3L, (long)uci.getPendingEventId());
        Assert.assertEquals((Object)containerStatus.getContainerId().toString(), (Object)uci.getContainerId());
        Map<String, io.hops.metadata.yarn.entity.ContainerStatus> containersStatusInDB = DBUtilityTests.getAllContainerStatus();
        Assert.assertEquals((long)1L, (long)containersStatusInDB.size());
        io.hops.metadata.yarn.entity.ContainerStatus cs = containersStatusInDB.get(containerStatus.getContainerId().toString());
        Assert.assertEquals((Object)containerStatus.getState().toString(), (Object)cs.getState());
        Assert.assertEquals((long)3L, (long)cs.getPendingEventId());
    }

    @Test
    public void testNodeRegistrationVersionLessThanRM() throws Exception {
        this.writeToHostsFile("host2");
        Configuration conf = new Configuration();
        conf.set("yarn.resourcemanager.nodes.include-path", this.hostFile.getAbsolutePath());
        conf.set("yarn.resourcemanager.nodemanager.minimum.version", "EqualToRM");
        this.rm = new MockRM(conf);
        this.rm.start();
        String nmVersion = "1.9.9";
        ResourceTrackerService resourceTrackerService = this.rm.getResourceTrackerService();
        RegisterNodeManagerRequest req = (RegisterNodeManagerRequest)Records.newRecord(RegisterNodeManagerRequest.class);
        NodeId nodeId = NodeId.newInstance((String)"host2", (int)1234);
        org.apache.hadoop.yarn.api.records.Resource capability = BuilderUtils.newResource((long)1024L, (int)1);
        req.setResource(capability);
        req.setNodeId(nodeId);
        req.setHttpPort(1234);
        req.setNMVersion(nmVersion);
        RegisterNodeManagerResponse response = resourceTrackerService.registerNodeManager(req);
        Assert.assertEquals((Object)NodeAction.SHUTDOWN, (Object)response.getNodeAction());
        Assert.assertTrue((String)("Diagnostic message did not contain: 'Disallowed NodeManager Version " + nmVersion + ", is less than the minimum version'"), (boolean)response.getDiagnosticsMessage().contains("Disallowed NodeManager Version " + nmVersion + ", is less than the minimum version "));
    }

    @Test
    public void testNodeRegistrationFailure() throws Exception {
        this.writeToHostsFile("host1");
        Configuration conf = new Configuration();
        conf.set("yarn.resourcemanager.nodes.include-path", this.hostFile.getAbsolutePath());
        this.rm = new MockRM(conf);
        this.rm.start();
        ResourceTrackerService resourceTrackerService = this.rm.getResourceTrackerService();
        RegisterNodeManagerRequest req = (RegisterNodeManagerRequest)Records.newRecord(RegisterNodeManagerRequest.class);
        NodeId nodeId = NodeId.newInstance((String)"host2", (int)1234);
        req.setNodeId(nodeId);
        req.setHttpPort(1234);
        RegisterNodeManagerResponse response = resourceTrackerService.registerNodeManager(req);
        Assert.assertEquals((Object)NodeAction.SHUTDOWN, (Object)response.getNodeAction());
        Assert.assertEquals((Object)"Disallowed NodeManager from  host2, Sending SHUTDOWN signal to the NodeManager.", (Object)response.getDiagnosticsMessage());
    }

    @Test
    public void testSetRMIdentifierInRegistration() throws Exception {
        Configuration conf = new Configuration();
        this.rm = new MockRM(conf);
        this.rm.start();
        MockNM nm = new MockNM("host1:1234", 5120, this.rm.getResourceTrackerService());
        RegisterNodeManagerResponse response = nm.registerNode();
        Assert.assertEquals((long)ResourceManager.getClusterTimeStamp(), (long)response.getRMIdentifier());
    }

    @Test
    public void testNodeRegistrationWithMinimumAllocations() throws Exception {
        Configuration conf = new Configuration();
        conf.set("yarn.scheduler.minimum-allocation-mb", "2048");
        conf.set("yarn.scheduler.minimum-allocation-vcores", "4");
        this.rm = new MockRM(conf);
        this.rm.start();
        ResourceTrackerService resourceTrackerService = this.rm.getResourceTrackerService();
        RegisterNodeManagerRequest req = (RegisterNodeManagerRequest)Records.newRecord(RegisterNodeManagerRequest.class);
        NodeId nodeId = BuilderUtils.newNodeId((String)"host", (int)1234);
        req.setNodeId(nodeId);
        org.apache.hadoop.yarn.api.records.Resource capability = BuilderUtils.newResource((long)1024L, (int)1);
        req.setResource(capability);
        RegisterNodeManagerResponse response1 = resourceTrackerService.registerNodeManager(req);
        Assert.assertEquals((Object)NodeAction.SHUTDOWN, (Object)response1.getNodeAction());
        capability.setMemorySize(2048L);
        capability.setVirtualCores(1);
        req.setResource(capability);
        RegisterNodeManagerResponse response2 = resourceTrackerService.registerNodeManager(req);
        Assert.assertEquals((Object)NodeAction.SHUTDOWN, (Object)response2.getNodeAction());
        capability.setMemorySize(1024L);
        capability.setVirtualCores(4);
        req.setResource(capability);
        RegisterNodeManagerResponse response3 = resourceTrackerService.registerNodeManager(req);
        Assert.assertEquals((Object)NodeAction.SHUTDOWN, (Object)response3.getNodeAction());
        capability.setMemorySize(2048L);
        capability.setVirtualCores(4);
        req.setResource(capability);
        RegisterNodeManagerResponse response4 = resourceTrackerService.registerNodeManager(req);
        Assert.assertEquals((Object)NodeAction.NORMAL, (Object)response4.getNodeAction());
    }

    @Test
    public void testReboot() throws Exception {
        Configuration conf = new Configuration();
        this.rm = new MockRM(conf);
        this.rm.start();
        MockNM nm1 = this.rm.registerNode("host1:1234", 5120);
        MockNM nm2 = this.rm.registerNode("host2:1234", 2048);
        int initialMetricCount = ClusterMetrics.getMetrics().getNumRebootedNMs();
        NodeHeartbeatResponse nodeHeartbeat = nm1.nodeHeartbeat(true);
        Assert.assertTrue((boolean)NodeAction.NORMAL.equals((Object)nodeHeartbeat.getNodeAction()));
        nodeHeartbeat = nm2.nodeHeartbeat(new HashMap<ApplicationId, List<ContainerStatus>>(), true, -100);
        Assert.assertTrue((boolean)NodeAction.RESYNC.equals((Object)nodeHeartbeat.getNodeAction()));
        Assert.assertEquals((Object)"Too far behind rm response id:0 nm response id:-100", (Object)nodeHeartbeat.getDiagnosticsMessage());
        this.checkRebootedNMCount(this.rm, ++initialMetricCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkRebootedNMCount(MockRM rm2, int count) throws InterruptedException {
        int waitCount = 0;
        while (ClusterMetrics.getMetrics().getNumRebootedNMs() != count && waitCount++ < 20) {
            TestResourceTrackerService testResourceTrackerService = this;
            synchronized (testResourceTrackerService) {
                ((Object)((Object)this)).wait(100L);
            }
        }
        Assert.assertEquals((String)"The rebooted metrics are not updated", (long)count, (long)ClusterMetrics.getMetrics().getNumRebootedNMs());
    }

    @Test
    public void testUnhealthyNodeStatus() throws Exception {
        Configuration conf = new Configuration();
        conf.set("yarn.resourcemanager.nodes.exclude-path", this.hostFile.getAbsolutePath());
        this.rm = new MockRM(conf);
        this.rm.start();
        MockNM nm1 = this.rm.registerNode("host1:1234", 5120);
        Assert.assertEquals((long)0L, (long)ClusterMetrics.getMetrics().getUnhealthyNMs());
        nm1.nodeHeartbeat(true);
        nm1.nodeHeartbeat(false);
        this.checkUnhealthyNMCount(this.rm, nm1, true, 1);
        nm1.nodeHeartbeat(true);
        this.checkUnhealthyNMCount(this.rm, nm1, false, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkUnhealthyNMCount(MockRM rm, MockNM nm1, boolean health, int count) throws Exception {
        int waitCount = 0;
        while (((RMNode)rm.getRMContext().getRMNodes().get(nm1.getNodeId())).getState() != NodeState.UNHEALTHY == health && waitCount++ < 20) {
            TestResourceTrackerService testResourceTrackerService = this;
            synchronized (testResourceTrackerService) {
                ((Object)((Object)this)).wait(100L);
            }
        }
        Assert.assertFalse((((RMNode)rm.getRMContext().getRMNodes().get(nm1.getNodeId())).getState() != NodeState.UNHEALTHY == health ? 1 : 0) != 0);
        Assert.assertEquals((String)"Unhealthy metrics not incremented", (long)count, (long)ClusterMetrics.getMetrics().getUnhealthyNMs());
    }

    @Test
    public void testHandleContainerStatusInvalidCompletions() throws Exception {
        this.rm = new MockRM((Configuration)new YarnConfiguration());
        this.rm.start();
        EventHandler handler = (EventHandler)Mockito.spy((Object)this.rm.getRMContext().getDispatcher().getEventHandler());
        RMApp app = this.rm.submitApp(1024, true);
        NMContainerStatus report = NMContainerStatus.newInstance((ContainerId)ContainerId.newContainerId((ApplicationAttemptId)ApplicationAttemptId.newInstance((ApplicationId)app.getApplicationId(), (int)2), (long)1L), (int)0, (ContainerState)ContainerState.COMPLETE, (org.apache.hadoop.yarn.api.records.Resource)org.apache.hadoop.yarn.api.records.Resource.newInstance((int)1024, (int)1), (String)"Dummy Completed", (int)0, (Priority)Priority.newInstance((int)10), (long)1234L);
        this.rm.getResourceTrackerService().handleNMContainerStatus(report, null);
        ((EventHandler)Mockito.verify((Object)handler, (VerificationMode)Mockito.never())).handle((Event)Matchers.any());
        RMAppAttemptImpl currentAttempt = (RMAppAttemptImpl)app.getCurrentAppAttempt();
        currentAttempt.setMasterContainer(null);
        report = NMContainerStatus.newInstance((ContainerId)ContainerId.newContainerId((ApplicationAttemptId)currentAttempt.getAppAttemptId(), (long)0L), (int)0, (ContainerState)ContainerState.COMPLETE, (org.apache.hadoop.yarn.api.records.Resource)org.apache.hadoop.yarn.api.records.Resource.newInstance((int)1024, (int)1), (String)"Dummy Completed", (int)0, (Priority)Priority.newInstance((int)10), (long)1234L);
        this.rm.getResourceTrackerService().handleNMContainerStatus(report, null);
        ((EventHandler)Mockito.verify((Object)handler, (VerificationMode)Mockito.never())).handle((Event)Matchers.any());
        app = this.rm.submitApp(1024);
        report = NMContainerStatus.newInstance((ContainerId)ContainerId.newContainerId((ApplicationAttemptId)ApplicationAttemptId.newInstance((ApplicationId)app.getApplicationId(), (int)2), (long)1L), (int)0, (ContainerState)ContainerState.COMPLETE, (org.apache.hadoop.yarn.api.records.Resource)org.apache.hadoop.yarn.api.records.Resource.newInstance((int)1024, (int)1), (String)"Dummy Completed", (int)0, (Priority)Priority.newInstance((int)10), (long)1234L);
        try {
            this.rm.getResourceTrackerService().handleNMContainerStatus(report, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ((EventHandler)Mockito.verify((Object)handler, (VerificationMode)Mockito.never())).handle((Event)Matchers.any());
        currentAttempt = (RMAppAttemptImpl)app.getCurrentAppAttempt();
        currentAttempt.setMasterContainer(null);
        report = NMContainerStatus.newInstance((ContainerId)ContainerId.newContainerId((ApplicationAttemptId)currentAttempt.getAppAttemptId(), (long)0L), (int)0, (ContainerState)ContainerState.COMPLETE, (org.apache.hadoop.yarn.api.records.Resource)org.apache.hadoop.yarn.api.records.Resource.newInstance((int)1024, (int)1), (String)"Dummy Completed", (int)0, (Priority)Priority.newInstance((int)10), (long)1234L);
        try {
            this.rm.getResourceTrackerService().handleNMContainerStatus(report, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ((EventHandler)Mockito.verify((Object)handler, (VerificationMode)Mockito.never())).handle((Event)Matchers.any());
    }

    @Test
    public void testReconnectNode() throws Exception {
        this.rm = new MockRM(){

            protected EventHandler<SchedulerEvent> createSchedulerEventDispatcher() {
                return new ResourceManager.SchedulerEventDispatcher(this.scheduler){

                    public void handle(SchedulerEvent event) {
                        scheduler.handle((Event)event);
                    }
                };
            }
        };
        this.rm.start();
        DrainDispatcher dispatcher = (DrainDispatcher)this.rm.getRMContext().getDispatcher();
        MockNM nm1 = this.rm.registerNode("host1:1234", 5120);
        MockNM nm2 = this.rm.registerNode("host2:5678", 5120);
        nm1.nodeHeartbeat(true);
        nm2.nodeHeartbeat(false);
        this.rm.drainEvents();
        this.checkUnhealthyNMCount(this.rm, nm2, true, 1);
        int expectedNMs = ClusterMetrics.getMetrics().getNumActiveNMs();
        QueueMetrics metrics = this.rm.getResourceScheduler().getRootQueueMetrics();
        Assert.assertEquals((long)5120L, (long)metrics.getAvailableMB());
        nm1 = this.rm.registerNode("host1:1234", 5120);
        NodeHeartbeatResponse response = nm1.nodeHeartbeat(true);
        Assert.assertTrue((boolean)NodeAction.NORMAL.equals((Object)response.getNodeAction()));
        this.rm.drainEvents();
        Assert.assertEquals((long)expectedNMs, (long)ClusterMetrics.getMetrics().getNumActiveNMs());
        this.checkUnhealthyNMCount(this.rm, nm2, true, 1);
        nm2 = this.rm.registerNode("host2:5678", 5120);
        response = nm2.nodeHeartbeat(false);
        Assert.assertTrue((boolean)NodeAction.NORMAL.equals((Object)response.getNodeAction()));
        this.rm.drainEvents();
        Assert.assertEquals((long)expectedNMs, (long)ClusterMetrics.getMetrics().getNumActiveNMs());
        this.checkUnhealthyNMCount(this.rm, nm2, true, 1);
        nm2 = this.rm.registerNode("host2:5678", 5120);
        this.rm.drainEvents();
        response = nm2.nodeHeartbeat(true);
        response = nm2.nodeHeartbeat(true);
        this.rm.drainEvents();
        Assert.assertEquals((long)10240L, (long)metrics.getAvailableMB());
        nm1 = this.rm.registerNode("host2:5678", 10240);
        this.rm.drainEvents();
        response = nm1.nodeHeartbeat(true);
        this.rm.drainEvents();
        Assert.assertTrue((boolean)NodeAction.NORMAL.equals((Object)response.getNodeAction()));
        Assert.assertEquals((long)15360L, (long)metrics.getAvailableMB());
        HashMap<ApplicationId, Integer> runningApps = new HashMap<ApplicationId, Integer>(1);
        runningApps.put(ApplicationId.newInstance((long)1L, (int)0), 0);
        nm1 = this.rm.registerNode("host2:5678", 15360, 2, runningApps);
        this.rm.drainEvents();
        response = nm1.nodeHeartbeat(true);
        this.rm.drainEvents();
        Assert.assertTrue((boolean)NodeAction.NORMAL.equals((Object)response.getNodeAction()));
        Assert.assertEquals((long)20480L, (long)metrics.getAvailableMB());
        nm1 = new MockNM("host1:1234", 5120, this.rm.getResourceTrackerService());
        nm1.setHttpPort(3);
        nm1.registerNode();
        this.rm.drainEvents();
        response = nm1.nodeHeartbeat(true);
        response = nm1.nodeHeartbeat(true);
        this.rm.drainEvents();
        RMNode rmNode = (RMNode)this.rm.getRMContext().getRMNodes().get(nm1.getNodeId());
        Assert.assertEquals((long)3L, (long)rmNode.getHttpPort());
        Assert.assertEquals((long)5120L, (long)rmNode.getTotalCapability().getMemorySize());
        Assert.assertEquals((long)20480L, (long)metrics.getAvailableMB());
    }

    @Test
    public void testNMUnregistration() throws Exception {
        Configuration conf = new Configuration();
        this.rm = new MockRM(conf);
        this.rm.start();
        ResourceTrackerService resourceTrackerService = this.rm.getResourceTrackerService();
        MockNM nm1 = this.rm.registerNode("host1:1234", 5120);
        int shutdownNMsCount = ClusterMetrics.getMetrics().getNumShutdownNMs();
        NodeHeartbeatResponse nodeHeartbeat = nm1.nodeHeartbeat(true);
        Assert.assertTrue((boolean)NodeAction.NORMAL.equals((Object)nodeHeartbeat.getNodeAction()));
        UnRegisterNodeManagerRequest request = (UnRegisterNodeManagerRequest)Records.newRecord(UnRegisterNodeManagerRequest.class);
        request.setNodeId(nm1.getNodeId());
        resourceTrackerService.unRegisterNodeManager(request);
        this.checkShutdownNMCount(this.rm, ++shutdownNMsCount);
        nodeHeartbeat = nm1.nodeHeartbeat(true);
        Assert.assertTrue((boolean)NodeAction.RESYNC.equals((Object)nodeHeartbeat.getNodeAction()));
    }

    @Test
    public void testUnhealthyNMUnregistration() throws Exception {
        Configuration conf = new Configuration();
        this.rm = new MockRM(conf);
        this.rm.start();
        ResourceTrackerService resourceTrackerService = this.rm.getResourceTrackerService();
        MockNM nm1 = this.rm.registerNode("host1:1234", 5120);
        Assert.assertEquals((long)0L, (long)ClusterMetrics.getMetrics().getUnhealthyNMs());
        nm1.nodeHeartbeat(true);
        int shutdownNMsCount = ClusterMetrics.getMetrics().getNumShutdownNMs();
        nm1.nodeHeartbeat(false);
        this.checkUnhealthyNMCount(this.rm, nm1, true, 1);
        UnRegisterNodeManagerRequest request = (UnRegisterNodeManagerRequest)Records.newRecord(UnRegisterNodeManagerRequest.class);
        request.setNodeId(nm1.getNodeId());
        resourceTrackerService.unRegisterNodeManager(request);
        this.checkShutdownNMCount(this.rm, ++shutdownNMsCount);
    }

    @Test
    public void testInvalidNMUnregistration() throws Exception {
        Configuration conf = new Configuration();
        this.rm = new MockRM(conf);
        this.rm.start();
        ResourceTrackerService resourceTrackerService = this.rm.getResourceTrackerService();
        int decommisionedNMsCount = ClusterMetrics.getMetrics().getNumDecommisionedNMs();
        UnRegisterNodeManagerRequest request = (UnRegisterNodeManagerRequest)Records.newRecord(UnRegisterNodeManagerRequest.class);
        request.setNodeId(BuilderUtils.newNodeId((String)"host", (int)1234));
        resourceTrackerService.unRegisterNodeManager(request);
        this.checkShutdownNMCount(this.rm, 0);
        this.checkDecommissionedNMCount(this.rm, 0);
        MockNM nm1 = new MockNM("host1:1234", 5120, resourceTrackerService);
        RegisterNodeManagerResponse response = nm1.registerNode();
        Assert.assertEquals((Object)NodeAction.NORMAL, (Object)response.getNodeAction());
        this.writeToHostsFile("host2");
        conf.set("yarn.resourcemanager.nodes.include-path", this.hostFile.getAbsolutePath());
        this.rm.getNodesListManager().refreshNodes(conf);
        NodeHeartbeatResponse heartbeatResponse = nm1.nodeHeartbeat(true);
        Assert.assertEquals((Object)NodeAction.SHUTDOWN, (Object)heartbeatResponse.getNodeAction());
        int shutdownNMsCount = ClusterMetrics.getMetrics().getNumShutdownNMs();
        this.checkShutdownNMCount(this.rm, shutdownNMsCount);
        this.checkDecommissionedNMCount(this.rm, decommisionedNMsCount);
        request.setNodeId(nm1.getNodeId());
        resourceTrackerService.unRegisterNodeManager(request);
        shutdownNMsCount = ClusterMetrics.getMetrics().getNumShutdownNMs();
        this.checkShutdownNMCount(this.rm, shutdownNMsCount);
        this.checkDecommissionedNMCount(this.rm, decommisionedNMsCount);
        MockNM nm2 = new MockNM("host2:1234", 5120, resourceTrackerService);
        RegisterNodeManagerResponse response2 = nm2.registerNode();
        Assert.assertEquals((Object)NodeAction.NORMAL, (Object)response2.getNodeAction());
        this.writeToHostsFile("host1");
        conf.set("yarn.resourcemanager.nodes.include-path", this.hostFile.getAbsolutePath());
        this.rm.getNodesListManager().refreshNodes(conf);
        request.setNodeId(nm2.getNodeId());
        resourceTrackerService.unRegisterNodeManager(request);
        this.checkShutdownNMCount(this.rm, ++shutdownNMsCount);
        this.checkDecommissionedNMCount(this.rm, decommisionedNMsCount);
        this.rm.stop();
    }

    @Test(timeout=30000L)
    public void testInitDecommMetric() throws Exception {
        this.testInitDecommMetricHelper(true);
        this.testInitDecommMetricHelper(false);
    }

    public void testInitDecommMetricHelper(boolean hasIncludeList) throws Exception {
        Configuration conf = new Configuration();
        this.rm = new MockRM(conf);
        this.rm.start();
        MockNM nm1 = this.rm.registerNode("host1:1234", 5120);
        MockNM nm2 = this.rm.registerNode("host2:5678", 10240);
        nm1.nodeHeartbeat(true);
        nm2.nodeHeartbeat(true);
        File excludeHostFile = new File(TEMP_DIR + File.separator + "excludeHostFile.txt");
        this.writeToHostsFile(excludeHostFile, "host1");
        conf.set("yarn.resourcemanager.nodes.exclude-path", excludeHostFile.getAbsolutePath());
        if (hasIncludeList) {
            this.writeToHostsFile(this.hostFile, "host1", "host2");
            conf.set("yarn.resourcemanager.nodes.include-path", this.hostFile.getAbsolutePath());
        }
        this.rm.getNodesListManager().refreshNodes(conf);
        this.rm.drainEvents();
        this.rm.stop();
        MockRM rm1 = new MockRM(conf);
        rm1.start();
        nm1 = rm1.registerNode("host1:1234", 5120);
        nm2 = rm1.registerNode("host2:5678", 10240);
        nm1.nodeHeartbeat(true);
        nm2.nodeHeartbeat(true);
        rm1.drainEvents();
        Assert.assertEquals((String)"Number of Decommissioned nodes should be 1", (long)1L, (long)ClusterMetrics.getMetrics().getNumDecommisionedNMs());
        Assert.assertEquals((String)"The inactiveRMNodes should contain an entry for thedecommissioned node", (long)1L, (long)rm1.getRMContext().getInactiveRMNodes().size());
        excludeHostFile = new File(TEMP_DIR + File.separator + "excludeHostFile.txt");
        this.writeToHostsFile(excludeHostFile, "");
        conf.set("yarn.resourcemanager.nodes.exclude-path", excludeHostFile.getAbsolutePath());
        rm1.getNodesListManager().refreshNodes(conf);
        nm1 = rm1.registerNode("host1:1234", 5120);
        nm1.nodeHeartbeat(true);
        nm2.nodeHeartbeat(true);
        rm1.drainEvents();
        Assert.assertEquals((String)"The decommissioned nodes metric should have decremented to 0", (long)0L, (long)ClusterMetrics.getMetrics().getNumDecommisionedNMs());
        Assert.assertEquals((String)"The active nodes metric should be 2", (long)2L, (long)ClusterMetrics.getMetrics().getNumActiveNMs());
        Assert.assertEquals((String)"The inactive RMNodes entry should have been removed", (long)0L, (long)rm1.getRMContext().getInactiveRMNodes().size());
        rm1.drainEvents();
        rm1.stop();
    }

    @Test(timeout=30000L)
    public void testInitDecommMetricNoRegistration() throws Exception {
        Configuration conf = new Configuration();
        this.rm = new MockRM(conf);
        this.rm.start();
        MockNM nm1 = this.rm.registerNode("host1:1234", 5120);
        MockNM nm2 = this.rm.registerNode("host2:5678", 10240);
        nm1.nodeHeartbeat(true);
        nm2.nodeHeartbeat(true);
        File excludeHostFile = new File(TEMP_DIR + File.separator + "excludeHostFile.txt");
        this.writeToHostsFile(excludeHostFile, "host3", "host2");
        conf.set("yarn.resourcemanager.nodes.exclude-path", excludeHostFile.getAbsolutePath());
        this.writeToHostsFile(this.hostFile, "host1", "host2");
        conf.set("yarn.resourcemanager.nodes.include-path", this.hostFile.getAbsolutePath());
        this.rm.getNodesListManager().refreshNodes(conf);
        this.rm.drainEvents();
        Assert.assertEquals((String)"The decommissioned nodes metric should be 1 ", (long)1L, (long)ClusterMetrics.getMetrics().getNumDecommisionedNMs());
        this.rm.stop();
        MockRM rm1 = new MockRM(conf);
        rm1.start();
        rm1.getNodesListManager().refreshNodes(conf);
        rm1.drainEvents();
        Assert.assertEquals((String)"The decommissioned nodes metric should be 2 ", (long)2L, (long)ClusterMetrics.getMetrics().getNumDecommisionedNMs());
        rm1.stop();
    }

    @Test
    public void testIncorrectRecommission() throws Exception {
        Configuration conf = new Configuration();
        this.rm = new MockRM(conf);
        this.rm.start();
        MockNM nm1 = this.rm.registerNode("host1:1234", 5120);
        MockNM nm2 = this.rm.registerNode("host2:5678", 10240);
        nm1.nodeHeartbeat(true);
        nm2.nodeHeartbeat(true);
        File excludeHostFile = new File(TEMP_DIR + File.separator + "excludeHostFile.txt");
        this.writeToHostsFile(excludeHostFile, "host3", "host2");
        conf.set("yarn.resourcemanager.nodes.exclude-path", excludeHostFile.getAbsolutePath());
        this.writeToHostsFile(this.hostFile, "host1", "host2");
        this.writeToHostsFile(excludeHostFile, "host1");
        this.rm.getNodesListManager().refreshNodesGracefully(conf);
        this.rm.drainEvents();
        nm1.nodeHeartbeat(true);
        this.rm.drainEvents();
        Assert.assertTrue((String)("Node " + nm1.getNodeId().getHost() + " should be Decommissioned"), (((RMNode)this.rm.getRMContext().getInactiveRMNodes().get(nm1.getNodeId())).getState() == NodeState.DECOMMISSIONED ? 1 : 0) != 0);
        this.writeToHostsFile(excludeHostFile, "");
        this.rm.getNodesListManager().refreshNodesGracefully(conf);
        this.rm.drainEvents();
        Assert.assertTrue((String)("Node " + nm1.getNodeId().getHost() + " should be Decommissioned"), (((RMNode)this.rm.getRMContext().getInactiveRMNodes().get(nm1.getNodeId())).getState() == NodeState.DECOMMISSIONED ? 1 : 0) != 0);
        this.rm.stop();
    }

    @Test
    public void testNodeRemovalNormally() throws Exception {
        this.testNodeRemovalUtil(false);
        this.testNodeRemovalUtilLost(false);
        this.testNodeRemovalUtilRebooted(false);
        this.testNodeRemovalUtilUnhealthy(false);
    }

    @Test
    public void testNodeRemovalGracefully() throws Exception {
        this.testNodeRemovalUtil(true);
        this.testNodeRemovalUtilLost(true);
        this.testNodeRemovalUtilRebooted(true);
        this.testNodeRemovalUtilUnhealthy(true);
    }

    public void refreshNodesOption(boolean doGraceful, Configuration conf) throws Exception {
        if (doGraceful) {
            this.rm.getNodesListManager().refreshNodesGracefully(conf);
        } else {
            this.rm.getNodesListManager().refreshNodes(conf);
        }
    }

    public void testNodeRemovalUtil(boolean doGraceful) throws Exception {
        Configuration conf = new Configuration();
        int timeoutValue = 500;
        File excludeHostFile = new File(TEMP_DIR + File.separator + "excludeHostFile.txt");
        conf.set("yarn.resourcemanager.nodes.include-path", "");
        conf.set("yarn.resourcemanager.nodes.exclude-path", "");
        conf.setInt("yarn.resourcemanager.node-removal-untracked.timeout-ms", timeoutValue);
        CountDownLatch latch = new CountDownLatch(1);
        this.rm = new MockRM(conf);
        this.rm.init(conf);
        this.rm.start();
        RMContext rmContext = this.rm.getRMContext();
        this.refreshNodesOption(doGraceful, conf);
        MockNM nm1 = this.rm.registerNode("host1:1234", 5120);
        MockNM nm2 = this.rm.registerNode("host2:5678", 10240);
        MockNM nm3 = this.rm.registerNode("localhost:4433", 1024);
        ClusterMetrics metrics = ClusterMetrics.getMetrics();
        assert (metrics != null);
        NodeHeartbeatResponse nodeHeartbeat = nm1.nodeHeartbeat(true);
        Assert.assertTrue((boolean)NodeAction.NORMAL.equals((Object)nodeHeartbeat.getNodeAction()));
        nodeHeartbeat = nm2.nodeHeartbeat(true);
        Assert.assertTrue((boolean)NodeAction.NORMAL.equals((Object)nodeHeartbeat.getNodeAction()));
        nodeHeartbeat = nm3.nodeHeartbeat(true);
        Assert.assertTrue((boolean)NodeAction.NORMAL.equals((Object)nodeHeartbeat.getNodeAction()));
        this.rm.drainEvents();
        Assert.assertEquals((String)"All 3 nodes should be active", (long)metrics.getNumActiveNMs(), (long)3L);
        String ip = NetUtils.normalizeHostName((String)"localhost");
        this.writeToHostsFile("host1", ip);
        conf.set("yarn.resourcemanager.nodes.include-path", this.hostFile.getAbsolutePath());
        this.refreshNodesOption(doGraceful, conf);
        nm1.nodeHeartbeat(true);
        this.rm.drainEvents();
        Assert.assertTrue((String)"Node should not be in active node list", (!rmContext.getRMNodes().containsKey(nm2.getNodeId()) ? 1 : 0) != 0);
        RMNode rmNode = (RMNode)rmContext.getInactiveRMNodes().get(nm2.getNodeId());
        Assert.assertEquals((String)"Node should be in inactive node list", (Object)rmNode.getState(), (Object)NodeState.SHUTDOWN);
        Assert.assertEquals((String)"Active nodes should be 2", (long)metrics.getNumActiveNMs(), (long)2L);
        Assert.assertEquals((String)"Shutdown nodes should be 1", (long)metrics.getNumShutdownNMs(), (long)1L);
        int nodeRemovalTimeout = conf.getInt("yarn.resourcemanager.node-removal-untracked.timeout-ms", 60000);
        int nodeRemovalInterval = rmContext.getNodesListManager().getNodeRemovalCheckInterval();
        long maxThreadSleeptime = nodeRemovalInterval + nodeRemovalTimeout;
        latch.await(maxThreadSleeptime, TimeUnit.MILLISECONDS);
        rmNode = (RMNode)rmContext.getInactiveRMNodes().get(nm2.getNodeId());
        Assert.assertEquals((String)"Node should have been forgotten!", (Object)rmNode, null);
        Assert.assertEquals((String)"Shutdown nodes should be 0 now", (long)metrics.getNumShutdownNMs(), (long)0L);
        this.writeToHostsFile("host1", ip, "host2");
        this.refreshNodesOption(doGraceful, conf);
        nm2 = this.rm.registerNode("host2:5678", 10240);
        this.rm.drainEvents();
        this.writeToHostsFile("host1", ip);
        this.refreshNodesOption(doGraceful, conf);
        this.rm.drainEvents();
        rmNode = (RMNode)rmContext.getInactiveRMNodes().get(nm2.getNodeId());
        Assert.assertEquals((String)"Node should be shutdown", (Object)rmNode.getState(), (Object)NodeState.SHUTDOWN);
        Assert.assertEquals((String)"Active nodes should be 2", (long)metrics.getNumActiveNMs(), (long)2L);
        Assert.assertEquals((String)"Shutdown nodes should be 1", (long)metrics.getNumShutdownNMs(), (long)1L);
        latch.await(maxThreadSleeptime - 2000L, TimeUnit.MILLISECONDS);
        this.writeToHostsFile("host1", ip, "host2");
        this.refreshNodesOption(doGraceful, conf);
        nm2 = this.rm.registerNode("host2:5678", 10240);
        nodeHeartbeat = nm2.nodeHeartbeat(true);
        this.rm.drainEvents();
        Assert.assertTrue((boolean)NodeAction.NORMAL.equals((Object)nodeHeartbeat.getNodeAction()));
        Assert.assertEquals((String)"Shutdown nodes should be 0 now", (long)metrics.getNumShutdownNMs(), (long)0L);
        Assert.assertEquals((String)"All 3 nodes should be active", (long)metrics.getNumActiveNMs(), (long)3L);
        this.writeToHostsFile("host1", "host2", ip);
        this.writeToHostsFile(excludeHostFile, "host2");
        conf.set("yarn.resourcemanager.nodes.exclude-path", excludeHostFile.getAbsolutePath());
        this.refreshNodesOption(doGraceful, conf);
        this.rm.drainEvents();
        rmNode = doGraceful ? (RMNode)rmContext.getRMNodes().get(nm2.getNodeId()) : (RMNode)rmContext.getInactiveRMNodes().get(nm2.getNodeId());
        Assert.assertTrue((String)"Node should be DECOMMISSIONED or DECOMMISSIONING", (rmNode.getState() == NodeState.DECOMMISSIONED || rmNode.getState() == NodeState.DECOMMISSIONING ? 1 : 0) != 0);
        if (rmNode.getState() == NodeState.DECOMMISSIONED) {
            Assert.assertEquals((String)"Decommissioned/ing nodes should be 1 now", (long)metrics.getNumDecommisionedNMs(), (long)1L);
        }
        latch.await(maxThreadSleeptime, TimeUnit.MILLISECONDS);
        rmNode = doGraceful ? (RMNode)rmContext.getRMNodes().get(nm2.getNodeId()) : (RMNode)rmContext.getInactiveRMNodes().get(nm2.getNodeId());
        Assert.assertTrue((String)"Node should be DECOMMISSIONED or DECOMMISSIONING", (rmNode.getState() == NodeState.DECOMMISSIONED || rmNode.getState() == NodeState.DECOMMISSIONING ? 1 : 0) != 0);
        if (rmNode.getState() == NodeState.DECOMMISSIONED) {
            Assert.assertEquals((String)"Decommissioned/ing nodes should be 1 now", (long)metrics.getNumDecommisionedNMs(), (long)1L);
        }
        this.writeToHostsFile("host1", ip, "host2");
        this.writeToHostsFile(excludeHostFile, "host2");
        this.refreshNodesOption(doGraceful, conf);
        nm1.nodeHeartbeat(true);
        nm3.nodeHeartbeat(true);
        latch.await(maxThreadSleeptime, TimeUnit.MILLISECONDS);
        rmNode = doGraceful ? (RMNode)rmContext.getRMNodes().get(nm2.getNodeId()) : (RMNode)rmContext.getInactiveRMNodes().get(nm2.getNodeId());
        Assert.assertNotEquals((String)"Timer for this node was not canceled!", (Object)rmNode, null);
        Assert.assertTrue((String)"Node should be DECOMMISSIONED or DECOMMISSIONING", (rmNode.getState() == NodeState.DECOMMISSIONED || rmNode.getState() == NodeState.DECOMMISSIONING ? 1 : 0) != 0);
        this.writeToHostsFile("host1", ip);
        this.writeToHostsFile(excludeHostFile, "");
        this.refreshNodesOption(doGraceful, conf);
        latch.await(maxThreadSleeptime, TimeUnit.MILLISECONDS);
        rmNode = doGraceful ? (RMNode)rmContext.getRMNodes().get(nm2.getNodeId()) : (RMNode)rmContext.getInactiveRMNodes().get(nm2.getNodeId());
        Assert.assertEquals((String)"Node should have been forgotten!", (Object)rmNode, null);
        Assert.assertEquals((String)"Shutdown nodes should be 0 now", (long)metrics.getNumDecommisionedNMs(), (long)0L);
        Assert.assertEquals((String)"Shutdown nodes should be 0 now", (long)metrics.getNumShutdownNMs(), (long)0L);
        Assert.assertEquals((String)"Active nodes should be 2", (long)metrics.getNumActiveNMs(), (long)2L);
        this.rm.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testNodeRemovalUtilLost(boolean doGraceful) throws Exception {
        ClusterMetrics clusterMetrics;
        Configuration conf = new Configuration();
        conf.setLong("yarn.nm.liveness-monitor.expiry-interval-ms", 2000L);
        int timeoutValue = 500;
        File excludeHostFile = new File(TEMP_DIR + File.separator + "excludeHostFile.txt");
        conf.set("yarn.resourcemanager.nodes.include-path", this.hostFile.getAbsolutePath());
        conf.set("yarn.resourcemanager.nodes.exclude-path", excludeHostFile.getAbsolutePath());
        this.writeToHostsFile(this.hostFile, "host1", "localhost", "host2");
        this.writeToHostsFile(excludeHostFile, "");
        conf.setInt("yarn.resourcemanager.node-removal-untracked.timeout-ms", timeoutValue);
        this.rm = new MockRM(conf);
        this.rm.init(conf);
        this.rm.start();
        RMContext rmContext = this.rm.getRMContext();
        this.refreshNodesOption(doGraceful, conf);
        MockNM nm1 = this.rm.registerNode("host1:1234", 5120);
        MockNM nm2 = this.rm.registerNode("host2:5678", 10240);
        MockNM nm3 = this.rm.registerNode("localhost:4433", 1024);
        ClusterMetrics metrics = clusterMetrics = ClusterMetrics.getMetrics();
        assert (metrics != null);
        this.rm.drainEvents();
        NodeHeartbeatResponse nodeHeartbeat = nm1.nodeHeartbeat(true);
        Assert.assertTrue((boolean)NodeAction.NORMAL.equals((Object)nodeHeartbeat.getNodeAction()));
        nodeHeartbeat = nm2.nodeHeartbeat(true);
        Assert.assertTrue((boolean)NodeAction.NORMAL.equals((Object)nodeHeartbeat.getNodeAction()));
        nodeHeartbeat = nm3.nodeHeartbeat(true);
        Assert.assertTrue((boolean)NodeAction.NORMAL.equals((Object)nodeHeartbeat.getNodeAction()));
        this.rm.drainEvents();
        Assert.assertEquals((String)"All 3 nodes should be active", (long)metrics.getNumActiveNMs(), (long)3L);
        int waitCount = 0;
        while (waitCount++ < 20) {
            TestResourceTrackerService testResourceTrackerService = this;
            synchronized (testResourceTrackerService) {
                ((Object)((Object)this)).wait(200L);
            }
            nm3.nodeHeartbeat(true);
            nm1.nodeHeartbeat(true);
        }
        Assert.assertNotEquals((String)"host2 should be a lost NM!", rmContext.getInactiveRMNodes().get(nm2.getNodeId()), null);
        Assert.assertEquals((String)"host2 should be a lost NM!", (Object)((RMNode)rmContext.getInactiveRMNodes().get(nm2.getNodeId())).getState(), (Object)NodeState.LOST);
        Assert.assertEquals((String)"There should be 1 Lost NM!", (long)clusterMetrics.getNumLostNMs(), (long)1L);
        Assert.assertEquals((String)"There should be 2 Active NM!", (long)clusterMetrics.getNumActiveNMs(), (long)2L);
        int nodeRemovalTimeout = conf.getInt("yarn.resourcemanager.node-removal-untracked.timeout-ms", 60000);
        int nodeRemovalInterval = rmContext.getNodesListManager().getNodeRemovalCheckInterval();
        long maxThreadSleeptime = nodeRemovalInterval + nodeRemovalTimeout;
        this.writeToHostsFile(this.hostFile, "host1", "localhost");
        this.writeToHostsFile(excludeHostFile, "");
        this.refreshNodesOption(doGraceful, conf);
        nm1.nodeHeartbeat(true);
        nm3.nodeHeartbeat(true);
        this.rm.drainEvents();
        waitCount = 0;
        while (rmContext.getInactiveRMNodes().get(nm2.getNodeId()) != null && waitCount++ < 2) {
            TestResourceTrackerService testResourceTrackerService = this;
            synchronized (testResourceTrackerService) {
                ((Object)((Object)this)).wait(maxThreadSleeptime);
                nm1.nodeHeartbeat(true);
                nm2.nodeHeartbeat(true);
            }
        }
        Assert.assertEquals((String)"host2 should have been forgotten!", rmContext.getInactiveRMNodes().get(nm2.getNodeId()), null);
        Assert.assertEquals((String)"There should be no Lost NMs!", (long)clusterMetrics.getNumLostNMs(), (long)0L);
        Assert.assertEquals((String)"There should be 2 Active NM!", (long)clusterMetrics.getNumActiveNMs(), (long)2L);
        this.rm.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testNodeRemovalUtilRebooted(boolean doGraceful) throws Exception {
        ClusterMetrics clusterMetrics;
        Configuration conf = new Configuration();
        int timeoutValue = 500;
        File excludeHostFile = new File(TEMP_DIR + File.separator + "excludeHostFile.txt");
        conf.set("yarn.resourcemanager.nodes.include-path", this.hostFile.getAbsolutePath());
        conf.set("yarn.resourcemanager.nodes.exclude-path", excludeHostFile.getAbsolutePath());
        this.writeToHostsFile(this.hostFile, "host1", "localhost", "host2");
        this.writeToHostsFile(excludeHostFile, "");
        conf.setInt("yarn.resourcemanager.node-removal-untracked.timeout-ms", timeoutValue);
        this.rm = new MockRM(conf);
        this.rm.init(conf);
        this.rm.start();
        RMContext rmContext = this.rm.getRMContext();
        this.refreshNodesOption(doGraceful, conf);
        MockNM nm1 = this.rm.registerNode("host1:1234", 5120);
        MockNM nm2 = this.rm.registerNode("host2:5678", 10240);
        MockNM nm3 = this.rm.registerNode("localhost:4433", 1024);
        ClusterMetrics metrics = clusterMetrics = ClusterMetrics.getMetrics();
        assert (metrics != null);
        NodeHeartbeatResponse nodeHeartbeat = nm2.nodeHeartbeat(new HashMap<ApplicationId, List<ContainerStatus>>(), true, -100);
        this.rm.drainEvents();
        this.rm.drainEvents();
        Assert.assertNotEquals((String)"host2 should be a rebooted NM!", rmContext.getInactiveRMNodes().get(nm2.getNodeId()), null);
        Assert.assertEquals((String)"host2 should be a rebooted NM!", (Object)((RMNode)rmContext.getInactiveRMNodes().get(nm2.getNodeId())).getState(), (Object)NodeState.REBOOTED);
        Assert.assertEquals((String)"There should be 1 Rebooted NM!", (long)clusterMetrics.getNumRebootedNMs(), (long)1L);
        Assert.assertEquals((String)"There should be 2 Active NM!", (long)clusterMetrics.getNumActiveNMs(), (long)2L);
        int nodeRemovalTimeout = conf.getInt("yarn.resourcemanager.node-removal-untracked.timeout-ms", 60000);
        int nodeRemovalInterval = rmContext.getNodesListManager().getNodeRemovalCheckInterval();
        long maxThreadSleeptime = nodeRemovalInterval + nodeRemovalTimeout;
        this.writeToHostsFile(this.hostFile, "host1", "localhost");
        this.writeToHostsFile(excludeHostFile, "");
        this.refreshNodesOption(doGraceful, conf);
        nm1.nodeHeartbeat(true);
        nm2.nodeHeartbeat(true);
        nm3.nodeHeartbeat(true);
        this.rm.drainEvents();
        int waitCount = 0;
        while (rmContext.getInactiveRMNodes().get(nm2.getNodeId()) != null && waitCount++ < 2) {
            TestResourceTrackerService testResourceTrackerService = this;
            synchronized (testResourceTrackerService) {
                ((Object)((Object)this)).wait(maxThreadSleeptime);
            }
        }
        Assert.assertEquals((String)"host2 should have been forgotten!", rmContext.getInactiveRMNodes().get(nm2.getNodeId()), null);
        Assert.assertEquals((String)"There should be no Rebooted NMs!", (long)clusterMetrics.getNumRebootedNMs(), (long)0L);
        Assert.assertEquals((String)"There should be 2 Active NM!", (long)clusterMetrics.getNumActiveNMs(), (long)2L);
        this.rm.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testNodeRemovalUtilUnhealthy(boolean doGraceful) throws Exception {
        ClusterMetrics clusterMetrics;
        Configuration conf = new Configuration();
        int timeoutValue = 500;
        File excludeHostFile = new File(TEMP_DIR + File.separator + "excludeHostFile.txt");
        conf.set("yarn.resourcemanager.nodes.include-path", this.hostFile.getAbsolutePath());
        conf.set("yarn.resourcemanager.nodes.exclude-path", excludeHostFile.getAbsolutePath());
        this.writeToHostsFile(this.hostFile, "host1", "localhost", "host2");
        this.writeToHostsFile(excludeHostFile, "");
        conf.setInt("yarn.resourcemanager.node-removal-untracked.timeout-ms", timeoutValue);
        this.rm = new MockRM(conf);
        this.rm.init(conf);
        this.rm.start();
        RMContext rmContext = this.rm.getRMContext();
        this.refreshNodesOption(doGraceful, conf);
        MockNM nm1 = this.rm.registerNode("host1:1234", 5120);
        MockNM nm2 = this.rm.registerNode("host2:5678", 10240);
        MockNM nm3 = this.rm.registerNode("localhost:4433", 1024);
        ClusterMetrics metrics = clusterMetrics = ClusterMetrics.getMetrics();
        assert (metrics != null);
        this.rm.drainEvents();
        NodeHeartbeatResponse nodeHeartbeat = nm1.nodeHeartbeat(true);
        Assert.assertTrue((boolean)NodeAction.NORMAL.equals((Object)nodeHeartbeat.getNodeAction()));
        nodeHeartbeat = nm2.nodeHeartbeat(true);
        Assert.assertTrue((boolean)NodeAction.NORMAL.equals((Object)nodeHeartbeat.getNodeAction()));
        nodeHeartbeat = nm3.nodeHeartbeat(true);
        Assert.assertTrue((boolean)NodeAction.NORMAL.equals((Object)nodeHeartbeat.getNodeAction()));
        this.rm.drainEvents();
        Assert.assertEquals((String)"All 3 nodes should be active", (long)metrics.getNumActiveNMs(), (long)3L);
        nm1.nodeHeartbeat(true);
        nm2.nodeHeartbeat(false);
        nm3.nodeHeartbeat(true);
        this.checkUnhealthyNMCount(this.rm, nm2, true, 1);
        this.writeToHostsFile(this.hostFile, "host1", "localhost");
        this.writeToHostsFile(excludeHostFile, "");
        this.refreshNodesOption(doGraceful, conf);
        nm1.nodeHeartbeat(true);
        nm2.nodeHeartbeat(false);
        nm3.nodeHeartbeat(true);
        this.rm.drainEvents();
        Assert.assertNotEquals((String)"host2 should be a shutdown NM!", rmContext.getInactiveRMNodes().get(nm2.getNodeId()), null);
        Assert.assertEquals((String)"host2 should be a shutdown NM!", (Object)((RMNode)rmContext.getInactiveRMNodes().get(nm2.getNodeId())).getState(), (Object)NodeState.SHUTDOWN);
        Assert.assertEquals((String)"There should be 2 Active NM!", (long)clusterMetrics.getNumActiveNMs(), (long)2L);
        Assert.assertEquals((String)"There should be 1 Shutdown NM!", (long)clusterMetrics.getNumShutdownNMs(), (long)1L);
        Assert.assertEquals((String)"There should be 0 Unhealthy NM!", (long)clusterMetrics.getUnhealthyNMs(), (long)0L);
        int nodeRemovalTimeout = conf.getInt("yarn.resourcemanager.node-removal-untracked.timeout-ms", 60000);
        int nodeRemovalInterval = rmContext.getNodesListManager().getNodeRemovalCheckInterval();
        long maxThreadSleeptime = nodeRemovalInterval + nodeRemovalTimeout;
        int waitCount = 0;
        while (rmContext.getInactiveRMNodes().get(nm2.getNodeId()) != null && waitCount++ < 2) {
            TestResourceTrackerService testResourceTrackerService = this;
            synchronized (testResourceTrackerService) {
                ((Object)((Object)this)).wait(maxThreadSleeptime);
            }
        }
        Assert.assertEquals((String)"host2 should have been forgotten!", rmContext.getInactiveRMNodes().get(nm2.getNodeId()), null);
        Assert.assertEquals((String)"There should be no Shutdown NMs!", (long)clusterMetrics.getNumRebootedNMs(), (long)0L);
        Assert.assertEquals((String)"There should be 2 Active NM!", (long)clusterMetrics.getNumActiveNMs(), (long)2L);
        this.rm.stop();
    }

    private void writeToHostsFile(String ... hosts) throws IOException {
        this.writeToHostsFile(this.hostFile, hosts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToHostsFile(File file, String ... hosts) throws IOException {
        if (!file.exists()) {
            TEMP_DIR.mkdirs();
            file.createNewFile();
        }
        FileOutputStream fStream = null;
        try {
            fStream = new FileOutputStream(file);
            for (int i = 0; i < hosts.length; ++i) {
                fStream.write(hosts[i].getBytes());
                fStream.write("\n".getBytes());
            }
        }
        finally {
            if (fStream != null) {
                IOUtils.closeStream((Closeable)fStream);
                fStream = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkDecommissionedNMCount(MockRM rm, int count) throws InterruptedException {
        int waitCount = 0;
        while (ClusterMetrics.getMetrics().getNumDecommisionedNMs() != count && waitCount++ < 20) {
            TestResourceTrackerService testResourceTrackerService = this;
            synchronized (testResourceTrackerService) {
                ((Object)((Object)this)).wait(100L);
            }
        }
        Assert.assertEquals((long)count, (long)ClusterMetrics.getMetrics().getNumDecommisionedNMs());
        Assert.assertEquals((String)"The decommisioned metrics are not updated", (long)count, (long)ClusterMetrics.getMetrics().getNumDecommisionedNMs());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkShutdownNMCount(MockRM rm, int count) throws InterruptedException {
        int waitCount = 0;
        while (ClusterMetrics.getMetrics().getNumShutdownNMs() != count && waitCount++ < 20) {
            TestResourceTrackerService testResourceTrackerService = this;
            synchronized (testResourceTrackerService) {
                ((Object)((Object)this)).wait(100L);
            }
        }
        Assert.assertEquals((String)"The shutdown metrics are not updated", (long)count, (long)ClusterMetrics.getMetrics().getNumShutdownNMs());
    }

    @After
    public void tearDown() {
        MetricsSystem ms;
        if (this.hostFile != null && this.hostFile.exists()) {
            this.hostFile.delete();
        }
        ClusterMetrics.destroy();
        if (this.rm != null) {
            this.rm.stop();
        }
        if ((ms = DefaultMetricsSystem.instance()).getSource("ClusterMetrics") != null) {
            DefaultMetricsSystem.shutdown();
        }
    }
}

