/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.exceptions.ApplicationNotFoundException;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.RMHATestBase;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.junit.Assert;
import org.junit.Test;

public class TestSubmitApplicationWithRMHA
extends RMHATestBase {
    public static final Log LOG = LogFactory.getLog(TestSubmitApplicationWithRMHA.class);

    @Test
    public void testHandleRMHABeforeSubmitApplicationCallWithSavedApplicationState() throws Exception {
        this.startRMs();
        ApplicationId appId = rm1.getNewAppId().getApplicationId();
        this.explicitFailover();
        RMApp app1 = rm2.submitApp(200, "", UserGroupInformation.getCurrentUser().getShortUserName(), null, false, null, this.configuration.getInt("yarn.resourcemanager.am.max-attempts", 2), null, null, false, false, true, appId);
        this.verifySubmitApp(rm2, app1, appId);
    }

    private void verifySubmitApp(MockRM rm, RMApp app, ApplicationId expectedAppId) throws Exception {
        YarnApplicationState state;
        int maxWaittingTimes = 20;
        for (int count = 0; ((state = rm.getApplicationReport(app.getApplicationId()).getYarnApplicationState()).equals((Object)YarnApplicationState.NEW) || state.equals((Object)YarnApplicationState.GENERATING_CERTS) || state.equals((Object)YarnApplicationState.NEW_SAVING)) && count <= maxWaittingTimes; ++count) {
            Thread.sleep(200L);
        }
        state = rm.getApplicationReport(app.getApplicationId()).getYarnApplicationState();
        Assert.assertTrue((state == YarnApplicationState.ACCEPTED || state == YarnApplicationState.SUBMITTED ? 1 : 0) != 0);
        Assert.assertEquals((Object)expectedAppId, (Object)app.getApplicationId());
    }

    @Test
    public void testHandleRMHAafterSubmitApplicationCallWithSavedApplicationState() throws Exception {
        this.startRMs();
        RMApp app0 = rm1.submitApp(200);
        this.explicitFailover();
        ApplicationReport appReport = rm2.getApplicationReport(app0.getApplicationId());
        Assert.assertTrue((appReport.getYarnApplicationState() == YarnApplicationState.ACCEPTED || appReport.getYarnApplicationState() == YarnApplicationState.SUBMITTED ? 1 : 0) != 0);
    }

    @Test
    public void testHandleRMHAafterSubmitApplicationCallWithoutSavedApplicationState() throws Exception {
        this.startRMsWithCustomizedRMAppManager();
        RMApp app0 = rm1.submitApp(200, "", UserGroupInformation.getCurrentUser().getShortUserName(), null, false, null, this.configuration.getInt("yarn.resourcemanager.am.max-attempts", 2), null, null, false, false);
        this.explicitFailover();
        try {
            rm2.getApplicationReport(app0.getApplicationId());
            Assert.fail((String)"Should get ApplicationNotFoundException here");
        }
        catch (ApplicationNotFoundException applicationNotFoundException) {
            // empty catch block
        }
        RMApp app1 = rm2.submitApp(200, "", UserGroupInformation.getCurrentUser().getShortUserName(), null, false, null, this.configuration.getInt("yarn.resourcemanager.am.max-attempts", 2), null, null, false, false, true, app0.getApplicationId());
        this.verifySubmitApp(rm2, app1, app0.getApplicationId());
    }

    @Test
    public void testGetApplicationReportIdempotent() throws Exception {
        this.startRMs();
        RMApp app = rm1.submitApp(200);
        ApplicationReport appReport1 = rm1.getApplicationReport(app.getApplicationId());
        Assert.assertTrue((appReport1.getYarnApplicationState() == YarnApplicationState.ACCEPTED || appReport1.getYarnApplicationState() == YarnApplicationState.SUBMITTED ? 1 : 0) != 0);
        ApplicationReport appReport2 = rm1.getApplicationReport(app.getApplicationId());
        Assert.assertEquals((Object)appReport1.getApplicationId(), (Object)appReport2.getApplicationId());
        Assert.assertEquals((Object)appReport1.getYarnApplicationState(), (Object)appReport2.getYarnApplicationState());
        this.explicitFailover();
        ApplicationReport appReport3 = rm2.getApplicationReport(app.getApplicationId());
        Assert.assertEquals((Object)appReport1.getApplicationId(), (Object)appReport3.getApplicationId());
        Assert.assertEquals((Object)appReport1.getYarnApplicationState(), (Object)appReport3.getYarnApplicationState());
        ApplicationReport appReport4 = rm2.getApplicationReport(app.getApplicationId());
        Assert.assertEquals((Object)appReport3.getApplicationId(), (Object)appReport4.getApplicationId());
        Assert.assertEquals((Object)appReport3.getYarnApplicationState(), (Object)appReport4.getYarnApplicationState());
    }

    @Test(timeout=50000L)
    public void testHandleRMHADuringSubmitApplicationCallWithSavedApplicationState() throws Exception {
        this.startRMs();
        RMApp app0 = rm1.submitApp(200);
        this.explicitFailover();
        Assert.assertTrue((boolean)rm2.getRMContext().getRMApps().containsKey(app0.getApplicationId()));
        RMApp app1 = rm2.submitApp(200, "", UserGroupInformation.getCurrentUser().getShortUserName(), null, false, null, this.configuration.getInt("yarn.resourcemanager.am.max-attempts", 2), null, null, false, false, true, app0.getApplicationId());
        Assert.assertEquals((Object)app1.getApplicationId(), (Object)app0.getApplicationId());
    }

    @Test(timeout=50000L)
    public void testHandleRMHADuringSubmitApplicationCallWithoutSavedApplicationState() throws Exception {
        this.startRMsWithCustomizedRMAppManager();
        RMApp app0 = rm1.submitApp(200, "", UserGroupInformation.getCurrentUser().getShortUserName(), null, false, null, this.configuration.getInt("yarn.resourcemanager.am.max-attempts", 2), null, null, false, false);
        this.explicitFailover();
        Assert.assertFalse((boolean)rm2.getRMContext().getRMApps().containsKey(app0.getApplicationId()));
        RMApp app1 = rm2.submitApp(200, "", UserGroupInformation.getCurrentUser().getShortUserName(), null, false, null, this.configuration.getInt("yarn.resourcemanager.am.max-attempts", 2), null, null, false, false, true, app0.getApplicationId());
        this.verifySubmitApp(rm2, app1, app0.getApplicationId());
        Assert.assertTrue((boolean)rm2.getRMContext().getRMApps().containsKey(app0.getApplicationId()));
    }
}

