/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt;

import io.hops.util.DBUtility;
import io.hops.util.RMStorageFactory;
import io.hops.util.YarnAPIStorageFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.MemoryRMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.AMLivelinessMonitor;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.ControlledClock;
import org.apache.hadoop.yarn.util.SystemClock;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestAMLivelinessMonitor {
    @Test(timeout=10000L)
    public void testResetTimer() throws Exception {
        YarnConfiguration conf = new YarnConfiguration();
        UserGroupInformation.setConfiguration((Configuration)conf);
        conf.set("yarn.resourcemanager.recovery.enabled", "true");
        conf.set("yarn.resourcemanager.store.class", MemoryRMStateStore.class.getName());
        conf.setBoolean("yarn.resourcemanager.work-preserving-recovery.enabled", true);
        conf.setInt("yarn.am.liveness-monitor.expiry-interval-ms", 6000);
        RMStorageFactory.setConfiguration((Configuration)conf);
        YarnAPIStorageFactory.setConfiguration((Configuration)conf);
        DBUtility.InitializeDB();
        final ControlledClock clock = new ControlledClock((Clock)new SystemClock());
        clock.setTime(0L);
        MemoryRMStateStore memStore = new MemoryRMStateStore(){

            public synchronized RMStateStore.RMState loadState() throws Exception {
                clock.setTime(8000L);
                return super.loadState();
            }
        };
        memStore.init((Configuration)conf);
        final ApplicationAttemptId attemptId = (ApplicationAttemptId)Mockito.mock(ApplicationAttemptId.class);
        Dispatcher dispatcher = (Dispatcher)Mockito.mock(Dispatcher.class);
        final boolean[] expired = new boolean[]{false};
        final AMLivelinessMonitor monitor = new AMLivelinessMonitor(dispatcher, (Clock)clock){

            protected void expire(ApplicationAttemptId id) {
                Assert.assertEquals((Object)id, (Object)attemptId);
                expired[0] = true;
            }
        };
        monitor.register((Object)attemptId);
        MockRM rm = new MockRM((Configuration)conf, (RMStateStore)memStore){

            protected AMLivelinessMonitor createAMLivelinessMonitor() {
                return monitor;
            }
        };
        rm.start();
        while (monitor.getServiceState() != Service.STATE.STARTED) {
            Thread.sleep(100L);
        }
        Assert.assertFalse((boolean)expired[0]);
        rm.stop();
    }
}

