/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Singleton;
import com.google.inject.servlet.GuiceFilter;
import com.google.inject.servlet.GuiceServletContextListener;
import com.google.inject.servlet.ServletModule;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.LoggingFilter;
import com.sun.jersey.api.json.JSONJAXBContext;
import com.sun.jersey.api.json.JSONMarshaller;
import com.sun.jersey.guice.spi.container.servlet.GuiceContainer;
import com.sun.jersey.test.framework.WebAppDescriptor;
import io.hops.util.DBUtility;
import io.hops.util.RMStorageFactory;
import io.hops.util.YarnAPIStorageFactory;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.ws.rs.core.MediaType;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.authentication.server.AuthenticationFilter;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.URL;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.JAXBContextResolver;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RMWebServices;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppPriority;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppQueue;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.AppState;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ApplicationSubmissionContextInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.CredentialsInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.LocalResourceInfo;
import org.apache.hadoop.yarn.webapp.GenericExceptionHandler;
import org.apache.hadoop.yarn.webapp.JerseyTestBase;
import org.apache.hadoop.yarn.webapp.WebServicesTestUtils;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@RunWith(value=Parameterized.class)
public class TestRMWebServicesAppsModification
extends JerseyTestBase {
    private static MockRM rm;
    private static final int CONTAINER_MB = 1024;
    private static Injector injector;
    private String webserviceUserName = "testuser";
    private boolean setAuthFilter = false;
    private static final String TEST_DIR;
    private static final String FS_ALLOC_FILE;

    private Injector getNoAuthInjectorCap() {
        return Guice.createInjector((Module[])new Module[]{new CapTestServletModule(){

            @Override
            protected void configureServlets() {
                TestRMWebServicesAppsModification.this.setAuthFilter = false;
                super.configureServlets();
            }
        }});
    }

    private Injector getSimpleAuthInjectorCap() {
        return Guice.createInjector((Module[])new Module[]{new CapTestServletModule(){

            @Override
            protected void configureServlets() {
                TestRMWebServicesAppsModification.this.setAuthFilter = true;
                this.conf.setBoolean("yarn.acl.enable", true);
                this.conf.setStrings("yarn.admin.acl", new String[]{"testuser1"});
                super.configureServlets();
            }
        }});
    }

    private Injector getNoAuthInjectorFair() {
        return Guice.createInjector((Module[])new Module[]{new FairTestServletModule(){

            @Override
            protected void configureServlets() {
                TestRMWebServicesAppsModification.this.setAuthFilter = false;
                super.configureServlets();
            }
        }});
    }

    private Injector getSimpleAuthInjectorFair() {
        return Guice.createInjector((Module[])new Module[]{new FairTestServletModule(){

            @Override
            protected void configureServlets() {
                TestRMWebServicesAppsModification.this.setAuthFilter = true;
                this.conf.setBoolean("yarn.acl.enable", true);
                this.conf.setStrings("yarn.admin.acl", new String[]{"testuser1"});
                super.configureServlets();
            }
        }});
    }

    @Parameterized.Parameters
    public static Collection<Object[]> guiceConfigs() {
        return Arrays.asList({0}, {1}, {2}, {3});
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
    }

    public TestRMWebServicesAppsModification(int run) {
        super(((WebAppDescriptor.Builder)new WebAppDescriptor.Builder(new String[]{"org.apache.hadoop.yarn.server.resourcemanager.webapp"}).contextListenerClass(GuiceServletConfig.class).filterClass(GuiceFilter.class).clientConfig((ClientConfig)new DefaultClientConfig(new Class[]{JAXBContextResolver.class}))).contextPath("jersey-guice-filter").servletPath("/").build());
        switch (run) {
            default: {
                injector = this.getNoAuthInjectorCap();
                break;
            }
            case 1: {
                injector = this.getSimpleAuthInjectorCap();
                break;
            }
            case 2: {
                injector = this.getNoAuthInjectorFair();
                break;
            }
            case 3: {
                injector = this.getSimpleAuthInjectorFair();
            }
        }
    }

    private boolean isAuthenticationEnabled() {
        return this.setAuthFilter;
    }

    private WebResource constructWebResource(WebResource r, String ... paths) {
        WebResource rt = r;
        for (String path : paths) {
            rt = rt.path(path);
        }
        if (this.isAuthenticationEnabled()) {
            rt = rt.queryParam("user.name", this.webserviceUserName);
        }
        return rt;
    }

    private WebResource constructWebResource(String ... paths) {
        WebResource r = this.resource();
        WebResource ws = r.path("ws").path("v1").path("cluster");
        return this.constructWebResource(ws, paths);
    }

    @Test
    public void testSingleAppState() throws Exception {
        String[] mediaTypes;
        rm.start();
        MockNM amNodeManager = rm.registerNode("127.0.0.1:1234", 2048);
        for (String mediaType : mediaTypes = new String[]{"application/json", "application/xml"}) {
            RMApp app = rm.submitApp(1024, "", this.webserviceUserName);
            amNodeManager.nodeHeartbeat(true);
            ClientResponse response = (ClientResponse)this.constructWebResource("apps", app.getApplicationId().toString(), "state").accept(new String[]{mediaType}).get(ClientResponse.class);
            Assert.assertEquals((Object)ClientResponse.Status.OK, (Object)response.getClientResponseStatus());
            if (mediaType.equals("application/json")) {
                TestRMWebServicesAppsModification.verifyAppStateJson(response, RMAppState.ACCEPTED);
                continue;
            }
            if (!mediaType.equals("application/xml")) continue;
            TestRMWebServicesAppsModification.verifyAppStateXML(response, RMAppState.ACCEPTED);
        }
        rm.stop();
    }

    @Test(timeout=120000L)
    public void testSingleAppKill() throws Exception {
        rm.start();
        MockNM amNodeManager = rm.registerNode("127.0.0.1:1234", 2048);
        String[] mediaTypes = new String[]{"application/json", "application/xml"};
        MediaType[] contentTypes = new MediaType[]{MediaType.APPLICATION_JSON_TYPE, MediaType.APPLICATION_XML_TYPE};
        String diagnostic = "message1";
        for (String mediaType : mediaTypes) {
            for (MediaType contentType : contentTypes) {
                RMApp app = rm.submitApp(1024, "", this.webserviceUserName);
                amNodeManager.nodeHeartbeat(true);
                AppState targetState = new AppState(YarnApplicationState.KILLED.toString());
                targetState.setDiagnostics(diagnostic);
                Object entity = contentType.equals((Object)MediaType.APPLICATION_JSON_TYPE) ? TestRMWebServicesAppsModification.appStateToJSON(targetState) : targetState;
                ClientResponse response = (ClientResponse)((WebResource.Builder)this.constructWebResource("apps", app.getApplicationId().toString(), "state").entity(entity, contentType).accept(new String[]{mediaType})).put(ClientResponse.class);
                if (!this.isAuthenticationEnabled()) {
                    Assert.assertEquals((Object)ClientResponse.Status.UNAUTHORIZED, (Object)response.getClientResponseStatus());
                    continue;
                }
                Assert.assertEquals((Object)ClientResponse.Status.ACCEPTED, (Object)response.getClientResponseStatus());
                if (mediaType.equals("application/json")) {
                    TestRMWebServicesAppsModification.verifyAppStateJson(response, RMAppState.FINAL_SAVING, RMAppState.KILLED, RMAppState.KILLING, RMAppState.ACCEPTED);
                } else {
                    TestRMWebServicesAppsModification.verifyAppStateXML(response, RMAppState.FINAL_SAVING, RMAppState.KILLED, RMAppState.KILLING, RMAppState.ACCEPTED);
                }
                String locationHeaderValue = (String)response.getHeaders().getFirst((Object)"Location");
                Client c = Client.create();
                WebResource tmp = c.resource(locationHeaderValue);
                if (this.isAuthenticationEnabled()) {
                    tmp = tmp.queryParam("user.name", this.webserviceUserName);
                }
                response = (ClientResponse)tmp.get(ClientResponse.class);
                Assert.assertEquals((Object)ClientResponse.Status.OK, (Object)response.getClientResponseStatus());
                Assert.assertTrue((boolean)locationHeaderValue.endsWith("/ws/v1/cluster/apps/" + app.getApplicationId().toString() + "/state"));
                do {
                    Thread.sleep(100L);
                    response = (ClientResponse)((WebResource.Builder)this.constructWebResource("apps", app.getApplicationId().toString(), "state").accept(new String[]{mediaType}).entity(entity, contentType)).put(ClientResponse.class);
                    Assert.assertTrue((response.getClientResponseStatus() == ClientResponse.Status.ACCEPTED || response.getClientResponseStatus() == ClientResponse.Status.OK ? 1 : 0) != 0);
                } while (response.getClientResponseStatus() != ClientResponse.Status.OK);
                Assert.assertEquals((Object)RMAppState.KILLED, (Object)app.getState());
                if (mediaType.equals("application/json")) {
                    TestRMWebServicesAppsModification.verifyAppStateJson(response, RMAppState.KILLED);
                } else {
                    TestRMWebServicesAppsModification.verifyAppStateXML(response, RMAppState.KILLED);
                }
                Assert.assertTrue((String)"Diagnostic message is incorrect", (boolean)app.getDiagnostics().toString().contains(diagnostic));
            }
        }
        rm.stop();
    }

    @Test
    public void testSingleAppKillInvalidState() throws Exception {
        rm.start();
        MockNM amNodeManager = rm.registerNode("127.0.0.1:1234", 2048);
        String[] mediaTypes = new String[]{"application/json", "application/xml"};
        MediaType[] contentTypes = new MediaType[]{MediaType.APPLICATION_JSON_TYPE, MediaType.APPLICATION_XML_TYPE};
        String[] targetStates = new String[]{YarnApplicationState.FINISHED.toString(), "blah"};
        for (String mediaType : mediaTypes) {
            for (MediaType contentType : contentTypes) {
                for (String targetStateString : targetStates) {
                    RMApp app = rm.submitApp(1024, "", this.webserviceUserName);
                    amNodeManager.nodeHeartbeat(true);
                    AppState targetState = new AppState(targetStateString);
                    Object entity = contentType.equals((Object)MediaType.APPLICATION_JSON_TYPE) ? TestRMWebServicesAppsModification.appStateToJSON(targetState) : targetState;
                    ClientResponse response = (ClientResponse)((WebResource.Builder)this.constructWebResource("apps", app.getApplicationId().toString(), "state").entity(entity, contentType).accept(new String[]{mediaType})).put(ClientResponse.class);
                    if (!this.isAuthenticationEnabled()) {
                        Assert.assertEquals((Object)ClientResponse.Status.UNAUTHORIZED, (Object)response.getClientResponseStatus());
                        continue;
                    }
                    Assert.assertEquals((Object)ClientResponse.Status.BAD_REQUEST, (Object)response.getClientResponseStatus());
                }
            }
        }
        rm.stop();
    }

    private static String appStateToJSON(AppState state) throws Exception {
        StringWriter sw = new StringWriter();
        JSONJAXBContext ctx = new JSONJAXBContext(new Class[]{AppState.class});
        JSONMarshaller jm = ctx.createJSONMarshaller();
        jm.marshallToJSON((Object)state, (Writer)sw);
        return sw.toString();
    }

    protected static void verifyAppStateJson(ClientResponse response, RMAppState ... states) throws JSONException {
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        String responseState = json.getString("state");
        boolean valid = false;
        for (RMAppState state : states) {
            if (!state.toString().equals(responseState)) continue;
            valid = true;
        }
        String msg = "app state incorrect, got " + responseState;
        Assert.assertTrue((String)msg, (boolean)valid);
    }

    protected static void verifyAppStateXML(ClientResponse response, RMAppState ... appStates) throws ParserConfigurationException, IOException, SAXException {
        Assert.assertEquals((Object)MediaType.APPLICATION_XML_TYPE, (Object)response.getType());
        String xml = (String)response.getEntity(String.class);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        InputSource is = new InputSource();
        is.setCharacterStream(new StringReader(xml));
        Document dom = db.parse(is);
        NodeList nodes = dom.getElementsByTagName("appstate");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)nodes.getLength());
        Element element = (Element)nodes.item(0);
        String state = WebServicesTestUtils.getXmlString((Element)element, (String)"state");
        boolean valid = false;
        for (RMAppState appState : appStates) {
            if (!appState.toString().equals(state)) continue;
            valid = true;
        }
        String msg = "app state incorrect, got " + state;
        Assert.assertTrue((String)msg, (boolean)valid);
    }

    @Test(timeout=60000L)
    public void testSingleAppKillUnauthorized() throws Exception {
        String[] mediaTypes;
        boolean isCapacityScheduler = rm.getResourceScheduler() instanceof CapacityScheduler;
        boolean isFairScheduler = rm.getResourceScheduler() instanceof FairScheduler;
        Assume.assumeTrue((String)"This test is only supported on Capacity and Fair Scheduler", (isCapacityScheduler || isFairScheduler ? 1 : 0) != 0);
        rm.start();
        if (isCapacityScheduler) {
            CapacitySchedulerConfiguration csconf = new CapacitySchedulerConfiguration();
            csconf.setAcl("root", QueueACL.ADMINISTER_QUEUE, "someuser");
            csconf.setAcl("root.default", QueueACL.ADMINISTER_QUEUE, "someuser");
            rm.getResourceScheduler().reinitialize((Configuration)csconf, rm.getRMContext());
        }
        MockNM amNodeManager = rm.registerNode("127.0.0.1:1234", 2048);
        for (String mediaType : mediaTypes = new String[]{"application/json", "application/xml"}) {
            RMApp app = rm.submitApp(1024, "test", "someuser");
            amNodeManager.nodeHeartbeat(true);
            ClientResponse response = (ClientResponse)this.constructWebResource("apps", app.getApplicationId().toString(), "state").accept(new String[]{mediaType}).get(ClientResponse.class);
            AppState info = (AppState)response.getEntity(AppState.class);
            info.setState(YarnApplicationState.KILLED.toString());
            response = (ClientResponse)((WebResource.Builder)this.constructWebResource("apps", app.getApplicationId().toString(), "state").accept(new String[]{mediaType}).entity((Object)info, "application/xml")).put(ClientResponse.class);
            this.validateResponseStatus(response, ClientResponse.Status.FORBIDDEN);
        }
        rm.stop();
    }

    @Test
    public void testSingleAppKillInvalidId() throws Exception {
        rm.start();
        MockNM amNodeManager = rm.registerNode("127.0.0.1:1234", 2048);
        amNodeManager.nodeHeartbeat(true);
        String[] testAppIds = new String[]{"application_1391705042196_0001", "random_string"};
        for (int i = 0; i < testAppIds.length; ++i) {
            AppState info = new AppState("KILLED");
            ClientResponse response = (ClientResponse)((WebResource.Builder)this.constructWebResource("apps", testAppIds[i], "state").accept(new String[]{"application/xml"}).entity((Object)info, "application/xml")).put(ClientResponse.class);
            if (!this.isAuthenticationEnabled()) {
                Assert.assertEquals((Object)ClientResponse.Status.UNAUTHORIZED, (Object)response.getClientResponseStatus());
                continue;
            }
            if (i == 0) {
                Assert.assertEquals((Object)ClientResponse.Status.NOT_FOUND, (Object)response.getClientResponseStatus());
                continue;
            }
            Assert.assertEquals((Object)ClientResponse.Status.BAD_REQUEST, (Object)response.getClientResponseStatus());
        }
        rm.stop();
    }

    @After
    public void tearDown() throws Exception {
        if (rm != null) {
            rm.stop();
        }
        super.tearDown();
    }

    public void validateResponseStatus(ClientResponse response, ClientResponse.Status expectedAuthorizedMode) {
        this.validateResponseStatus(response, ClientResponse.Status.UNAUTHORIZED, expectedAuthorizedMode);
    }

    public void validateResponseStatus(ClientResponse response, ClientResponse.Status expectedUnauthorizedMode, ClientResponse.Status expectedAuthorizedMode) {
        if (!this.isAuthenticationEnabled()) {
            Assert.assertEquals((Object)expectedUnauthorizedMode, (Object)response.getClientResponseStatus());
        } else {
            Assert.assertEquals((Object)expectedAuthorizedMode, (Object)response.getClientResponseStatus());
        }
    }

    @Test
    public void testGetNewApplication() throws Exception {
        String[] mediaTypes;
        this.client().addFilter((ClientFilter)new LoggingFilter(System.out));
        rm.start();
        for (String acceptMedia : mediaTypes = new String[]{"application/json", "application/xml"}) {
            this.testGetNewApplication(acceptMedia);
        }
        rm.stop();
    }

    protected String testGetNewApplication(String mediaType) throws JSONException, ParserConfigurationException, IOException, SAXException {
        ClientResponse response = (ClientResponse)this.constructWebResource("apps", "new-application").accept(new String[]{mediaType}).post(ClientResponse.class);
        this.validateResponseStatus(response, ClientResponse.Status.OK);
        if (!this.isAuthenticationEnabled()) {
            return "";
        }
        return this.validateGetNewApplicationResponse(response);
    }

    protected String validateGetNewApplicationResponse(ClientResponse resp) throws JSONException, ParserConfigurationException, IOException, SAXException {
        String ret = "";
        if (resp.getType().equals((Object)MediaType.APPLICATION_JSON_TYPE)) {
            JSONObject json = (JSONObject)resp.getEntity(JSONObject.class);
            ret = this.validateGetNewApplicationJsonResponse(json);
        } else if (resp.getType().equals((Object)MediaType.APPLICATION_XML_TYPE)) {
            String xml = (String)resp.getEntity(String.class);
            ret = this.validateGetNewApplicationXMLResponse(xml);
        } else {
            Assert.assertTrue((boolean)false);
        }
        return ret;
    }

    protected String validateGetNewApplicationJsonResponse(JSONObject json) throws JSONException {
        String appId = json.getString("application-id");
        Assert.assertTrue((!appId.isEmpty() ? 1 : 0) != 0);
        JSONObject maxResources = json.getJSONObject("maximum-resource-capability");
        long memory = maxResources.getLong("memory");
        long vCores = maxResources.getLong("vCores");
        Assert.assertTrue((memory != 0L ? 1 : 0) != 0);
        Assert.assertTrue((vCores != 0L ? 1 : 0) != 0);
        return appId;
    }

    protected String validateGetNewApplicationXMLResponse(String response) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        InputSource is = new InputSource();
        is.setCharacterStream(new StringReader(response));
        Document dom = db.parse(is);
        NodeList nodes = dom.getElementsByTagName("NewApplication");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)nodes.getLength());
        Element element = (Element)nodes.item(0);
        String appId = WebServicesTestUtils.getXmlString((Element)element, (String)"application-id");
        Assert.assertTrue((!appId.isEmpty() ? 1 : 0) != 0);
        NodeList maxResourceNodes = element.getElementsByTagName("maximum-resource-capability");
        Assert.assertEquals((long)1L, (long)maxResourceNodes.getLength());
        Element maxResourceCapability = (Element)maxResourceNodes.item(0);
        long memory = WebServicesTestUtils.getXmlLong((Element)maxResourceCapability, (String)"memory");
        long vCores = WebServicesTestUtils.getXmlLong((Element)maxResourceCapability, (String)"vCores");
        Assert.assertTrue((memory != 0L ? 1 : 0) != 0);
        Assert.assertTrue((vCores != 0L ? 1 : 0) != 0);
        return appId;
    }

    @Test
    public void testGetNewApplicationAndSubmit() throws Exception {
        String[] mediaTypes;
        rm.start();
        MockNM amNodeManager = rm.registerNode("127.0.0.1:1234", 2048);
        amNodeManager.nodeHeartbeat(true);
        for (String acceptMedia : mediaTypes = new String[]{"application/json", "application/xml"}) {
            for (String contentMedia : mediaTypes) {
                this.testAppSubmit(acceptMedia, contentMedia);
                this.testAppSubmitErrors(acceptMedia, contentMedia);
            }
        }
        rm.stop();
    }

    public void testAppSubmit(String acceptMedia, String contentMedia) throws Exception {
        this.client().addFilter((ClientFilter)new LoggingFilter(System.out));
        String lrKey = "example";
        String queueName = "testqueue";
        String appName = "test";
        String appType = "test-type";
        String urlPath = "apps";
        String appId = this.testGetNewApplication(acceptMedia);
        ArrayList<String> commands = new ArrayList<String>();
        commands.add("/bin/sleep 5");
        HashMap<String, String> environment = new HashMap<String, String>();
        environment.put("APP_VAR", "ENV_SETTING");
        HashMap<ApplicationAccessType, String> acls = new HashMap<ApplicationAccessType, String>();
        acls.put(ApplicationAccessType.MODIFY_APP, "testuser1, testuser2");
        acls.put(ApplicationAccessType.VIEW_APP, "testuser3, testuser4");
        HashSet<String> tags = new HashSet<String>();
        tags.add("tag1");
        tags.add("tag 2");
        CredentialsInfo credentials = new CredentialsInfo();
        HashMap tokens = new HashMap();
        HashMap<String, String> secrets = new HashMap<String, String>();
        secrets.put("secret1", Base64.encodeBase64String((byte[])"mysecret".getBytes("UTF8")));
        credentials.setSecrets(secrets);
        credentials.setTokens(tokens);
        ApplicationSubmissionContextInfo appInfo = new ApplicationSubmissionContextInfo();
        appInfo.setApplicationId(appId);
        appInfo.setApplicationName(appName);
        appInfo.setMaxAppAttempts(2);
        appInfo.setQueue(queueName);
        appInfo.setApplicationType(appType);
        appInfo.setPriority(0);
        HashMap<String, LocalResourceInfo> lr = new HashMap<String, LocalResourceInfo>();
        LocalResourceInfo y = new LocalResourceInfo();
        y.setUrl(new URI("http://www.test.com/file.txt"));
        y.setSize(100L);
        y.setTimestamp(System.currentTimeMillis());
        y.setType(LocalResourceType.FILE);
        y.setVisibility(LocalResourceVisibility.APPLICATION);
        lr.put(lrKey, y);
        appInfo.getContainerLaunchContextInfo().setResources(lr);
        appInfo.getContainerLaunchContextInfo().setCommands(commands);
        appInfo.getContainerLaunchContextInfo().setEnvironment(environment);
        appInfo.getContainerLaunchContextInfo().setAcls(acls);
        appInfo.getContainerLaunchContextInfo().getAuxillaryServiceData().put("test", Base64.encodeBase64URLSafeString((byte[])"value12".getBytes("UTF8")));
        appInfo.getContainerLaunchContextInfo().setCredentials(credentials);
        appInfo.getResource().setMemory(1024);
        appInfo.getResource().setvCores(1);
        appInfo.setApplicationTags(tags);
        ClientResponse response = (ClientResponse)((WebResource.Builder)this.constructWebResource(urlPath).accept(new String[]{acceptMedia}).entity((Object)appInfo, contentMedia)).post(ClientResponse.class);
        if (!this.isAuthenticationEnabled()) {
            Assert.assertEquals((Object)ClientResponse.Status.UNAUTHORIZED, (Object)response.getClientResponseStatus());
            return;
        }
        Assert.assertEquals((Object)ClientResponse.Status.ACCEPTED, (Object)response.getClientResponseStatus());
        Assert.assertTrue((!((String)response.getHeaders().getFirst((Object)"Location")).isEmpty() ? 1 : 0) != 0);
        String locURL = (String)response.getHeaders().getFirst((Object)"Location");
        Assert.assertTrue((boolean)locURL.contains("/apps/application"));
        appId = locURL.substring(locURL.indexOf("/apps/") + "/apps/".length());
        WebResource res = this.resource().uri(new URI(locURL));
        res = res.queryParam("user.name", this.webserviceUserName);
        response = (ClientResponse)res.get(ClientResponse.class);
        Assert.assertEquals((Object)ClientResponse.Status.OK, (Object)response.getClientResponseStatus());
        RMApp app = (RMApp)rm.getRMContext().getRMApps().get(ApplicationId.fromString((String)appId));
        Assert.assertEquals((Object)appName, (Object)app.getName());
        Assert.assertEquals((Object)this.webserviceUserName, (Object)app.getUser());
        Assert.assertEquals((long)2L, (long)app.getMaxAppAttempts());
        if (app.getQueue().contains("root.")) {
            queueName = "root." + queueName;
        }
        Assert.assertEquals((Object)queueName, (Object)app.getQueue());
        Assert.assertEquals((Object)appType, (Object)app.getApplicationType());
        Assert.assertEquals(tags, (Object)app.getApplicationTags());
        ContainerLaunchContext ctx = app.getApplicationSubmissionContext().getAMContainerSpec();
        Assert.assertEquals(commands, (Object)ctx.getCommands());
        Assert.assertEquals(environment, (Object)ctx.getEnvironment());
        Assert.assertEquals(acls, (Object)ctx.getApplicationACLs());
        Map appLRs = ctx.getLocalResources();
        Assert.assertTrue((boolean)appLRs.containsKey(lrKey));
        LocalResource exampleLR = (LocalResource)appLRs.get(lrKey);
        Assert.assertEquals((Object)URL.fromURI((URI)y.getUrl()), (Object)exampleLR.getResource());
        Assert.assertEquals((long)y.getSize(), (long)exampleLR.getSize());
        Assert.assertEquals((long)y.getTimestamp(), (long)exampleLR.getTimestamp());
        Assert.assertEquals((Object)y.getType(), (Object)exampleLR.getType());
        Assert.assertEquals((Object)y.getPattern(), (Object)exampleLR.getPattern());
        Assert.assertEquals((Object)y.getVisibility(), (Object)exampleLR.getVisibility());
        Credentials cs = new Credentials();
        ByteArrayInputStream str = new ByteArrayInputStream(app.getApplicationSubmissionContext().getAMContainerSpec().getTokens().array());
        DataInputStream di = new DataInputStream(str);
        cs.readTokenStorageStream(di);
        Text key = new Text("secret1");
        Assert.assertTrue((String)"Secrets missing from credentials object", (boolean)cs.getAllSecretKeys().contains(key));
        Assert.assertEquals((Object)"mysecret", (Object)new String(cs.getSecretKey(key), "UTF-8"));
        response = (ClientResponse)this.constructWebResource("apps", appId).accept(new String[]{acceptMedia}).get(ClientResponse.class);
        Assert.assertEquals((Object)ClientResponse.Status.OK, (Object)response.getClientResponseStatus());
    }

    public void testAppSubmitErrors(String acceptMedia, String contentMedia) throws Exception {
        String urlPath = "apps";
        ApplicationSubmissionContextInfo appInfo = new ApplicationSubmissionContextInfo();
        ClientResponse response = (ClientResponse)((WebResource.Builder)this.constructWebResource(urlPath).accept(new String[]{acceptMedia}).entity((Object)appInfo, contentMedia)).post(ClientResponse.class);
        this.validateResponseStatus(response, ClientResponse.Status.BAD_REQUEST);
        String appId = "random";
        appInfo.setApplicationId(appId);
        response = (ClientResponse)((WebResource.Builder)this.constructWebResource(urlPath).accept(new String[]{acceptMedia}).entity((Object)appInfo, contentMedia)).post(ClientResponse.class);
        this.validateResponseStatus(response, ClientResponse.Status.BAD_REQUEST);
        appId = "random_junk";
        appInfo.setApplicationId(appId);
        response = (ClientResponse)((WebResource.Builder)this.constructWebResource(urlPath).accept(new String[]{acceptMedia}).entity((Object)appInfo, contentMedia)).post(ClientResponse.class);
        this.validateResponseStatus(response, ClientResponse.Status.BAD_REQUEST);
        appInfo.getResource().setMemory(rm.getConfig().getInt("yarn.scheduler.maximum-allocation-mb", 8192) + 1);
        appInfo.getResource().setvCores(1);
        response = (ClientResponse)((WebResource.Builder)this.constructWebResource(urlPath).accept(new String[]{acceptMedia}).entity((Object)appInfo, contentMedia)).post(ClientResponse.class);
        this.validateResponseStatus(response, ClientResponse.Status.BAD_REQUEST);
        appInfo.getResource().setvCores(rm.getConfig().getInt("yarn.scheduler.maximum-allocation-vcores", 4) + 1);
        appInfo.getResource().setMemory(1024);
        response = (ClientResponse)((WebResource.Builder)this.constructWebResource(urlPath).accept(new String[]{acceptMedia}).entity((Object)appInfo, contentMedia)).post(ClientResponse.class);
        this.validateResponseStatus(response, ClientResponse.Status.BAD_REQUEST);
    }

    @Test
    public void testAppSubmitBadJsonAndXML() throws Exception {
        String urlPath = "apps";
        rm.start();
        MockNM amNodeManager = rm.registerNode("127.0.0.1:1234", 2048);
        amNodeManager.nodeHeartbeat(true);
        ApplicationSubmissionContextInfo appInfo = new ApplicationSubmissionContextInfo();
        appInfo.setApplicationName("test");
        appInfo.setPriority(3);
        appInfo.setMaxAppAttempts(2);
        appInfo.setQueue("testqueue");
        appInfo.setApplicationType("test-type");
        HashMap<String, LocalResourceInfo> lr = new HashMap<String, LocalResourceInfo>();
        LocalResourceInfo y = new LocalResourceInfo();
        y.setUrl(new URI("http://www.test.com/file.txt"));
        y.setSize(100L);
        y.setTimestamp(System.currentTimeMillis());
        y.setType(LocalResourceType.FILE);
        y.setVisibility(LocalResourceVisibility.APPLICATION);
        lr.put("example", y);
        appInfo.getContainerLaunchContextInfo().setResources(lr);
        appInfo.getResource().setMemory(1024);
        appInfo.getResource().setvCores(1);
        String body = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><blah/>";
        ClientResponse response = (ClientResponse)((WebResource.Builder)this.constructWebResource(urlPath).accept(new String[]{"application/xml"}).entity((Object)body, "application/xml")).post(ClientResponse.class);
        Assert.assertEquals((Object)ClientResponse.Status.BAD_REQUEST, (Object)response.getClientResponseStatus());
        body = "{\"a\" : \"b\"}";
        response = (ClientResponse)((WebResource.Builder)this.constructWebResource(urlPath).accept(new String[]{"application/xml"}).entity((Object)body, "application/json")).post(ClientResponse.class);
        this.validateResponseStatus(response, ClientResponse.Status.BAD_REQUEST);
        rm.stop();
    }

    @Test
    public void testGetAppQueue() throws Exception {
        String[] contentTypes;
        this.client().addFilter((ClientFilter)new LoggingFilter(System.out));
        boolean isCapacityScheduler = rm.getResourceScheduler() instanceof CapacityScheduler;
        rm.start();
        MockNM amNodeManager = rm.registerNode("127.0.0.1:1234", 2048);
        for (String contentType : contentTypes = new String[]{"application/json", "application/xml"}) {
            RMApp app = rm.submitApp(1024, "", this.webserviceUserName);
            amNodeManager.nodeHeartbeat(true);
            ClientResponse response = (ClientResponse)this.constructWebResource("apps", app.getApplicationId().toString(), "queue").accept(new String[]{contentType}).get(ClientResponse.class);
            Assert.assertEquals((Object)ClientResponse.Status.OK, (Object)response.getClientResponseStatus());
            String expectedQueue = "default";
            if (!isCapacityScheduler) {
                expectedQueue = "root." + this.webserviceUserName;
            }
            if (contentType.equals("application/json")) {
                TestRMWebServicesAppsModification.verifyAppQueueJson(response, expectedQueue);
                continue;
            }
            TestRMWebServicesAppsModification.verifyAppQueueXML(response, expectedQueue);
        }
        rm.stop();
    }

    @Test(timeout=90000L)
    public void testUpdateAppPriority() throws Exception {
        this.client().addFilter((ClientFilter)new LoggingFilter(System.out));
        if (!(rm.getResourceScheduler() instanceof CapacityScheduler)) {
            return;
        }
        CapacitySchedulerConfiguration csconf = new CapacitySchedulerConfiguration();
        String[] queues = new String[]{"default", "test"};
        csconf.setQueues("root", queues);
        csconf.setCapacity("root.default", 50.0f);
        csconf.setCapacity("root.test", 50.0f);
        csconf.setAcl("root", QueueACL.ADMINISTER_QUEUE, "someuser");
        csconf.setAcl("root.default", QueueACL.ADMINISTER_QUEUE, "someuser");
        csconf.setAcl("root.test", QueueACL.ADMINISTER_QUEUE, "someuser");
        rm.start();
        rm.getResourceScheduler().reinitialize((Configuration)csconf, rm.getRMContext());
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        Configuration conf = new Configuration();
        conf.setInt("yarn.cluster.max-application-priority", 10);
        cs.setClusterMaxPriority(conf);
        MockNM amNodeManager = rm.registerNode("127.0.0.1:1234", 2048);
        String[] mediaTypes = new String[]{"application/json", "application/xml"};
        MediaType[] contentTypes = new MediaType[]{MediaType.APPLICATION_JSON_TYPE, MediaType.APPLICATION_XML_TYPE};
        for (String mediaType : mediaTypes) {
            for (MediaType contentType : contentTypes) {
                RMApp app = rm.submitApp(1024, "", this.webserviceUserName);
                amNodeManager.nodeHeartbeat(true);
                int modifiedPriority = 8;
                AppPriority priority2 = new AppPriority(modifiedPriority);
                Object entity = contentType.equals((Object)MediaType.APPLICATION_JSON_TYPE) ? TestRMWebServicesAppsModification.appPriorityToJSON(priority2) : priority2;
                ClientResponse response = (ClientResponse)((WebResource.Builder)this.constructWebResource("apps", app.getApplicationId().toString(), "priority").entity(entity, contentType).accept(new String[]{mediaType})).put(ClientResponse.class);
                if (!this.isAuthenticationEnabled()) {
                    Assert.assertEquals((Object)ClientResponse.Status.UNAUTHORIZED, (Object)response.getClientResponseStatus());
                    continue;
                }
                Assert.assertEquals((Object)ClientResponse.Status.OK, (Object)response.getClientResponseStatus());
                if (mediaType.equals("application/json")) {
                    TestRMWebServicesAppsModification.verifyAppPriorityJson(response, modifiedPriority);
                } else {
                    TestRMWebServicesAppsModification.verifyAppPriorityXML(response, modifiedPriority);
                }
                response = (ClientResponse)this.constructWebResource("apps", app.getApplicationId().toString(), "priority").accept(new String[]{mediaType}).get(ClientResponse.class);
                Assert.assertEquals((Object)ClientResponse.Status.OK, (Object)response.getClientResponseStatus());
                if (mediaType.equals("application/json")) {
                    TestRMWebServicesAppsModification.verifyAppPriorityJson(response, modifiedPriority);
                } else {
                    TestRMWebServicesAppsModification.verifyAppPriorityXML(response, modifiedPriority);
                }
                app = rm.submitApp(1024, "", "someuser");
                amNodeManager.nodeHeartbeat(true);
                response = (ClientResponse)((WebResource.Builder)this.constructWebResource("apps", app.getApplicationId().toString(), "priority").entity(entity, contentType).accept(new String[]{mediaType})).put(ClientResponse.class);
                Assert.assertEquals((Object)ClientResponse.Status.FORBIDDEN, (Object)response.getClientResponseStatus());
            }
        }
        rm.stop();
    }

    public void testAppMove() throws Exception {
        this.client().addFilter((ClientFilter)new LoggingFilter(System.out));
        boolean isCapacityScheduler = rm.getResourceScheduler() instanceof CapacityScheduler;
        CapacitySchedulerConfiguration csconf = new CapacitySchedulerConfiguration();
        String[] queues = new String[]{"default", "test"};
        csconf.setQueues("root", queues);
        csconf.setCapacity("root.default", 50.0f);
        csconf.setCapacity("root.test", 50.0f);
        csconf.setAcl("root", QueueACL.ADMINISTER_QUEUE, "someuser");
        csconf.setAcl("root.default", QueueACL.ADMINISTER_QUEUE, "someuser");
        csconf.setAcl("root.test", QueueACL.ADMINISTER_QUEUE, "someuser");
        rm.start();
        rm.getResourceScheduler().reinitialize((Configuration)csconf, rm.getRMContext());
        MockNM amNodeManager = rm.registerNode("127.0.0.1:1234", 2048);
        String[] mediaTypes = new String[]{"application/json", "application/xml"};
        MediaType[] contentTypes = new MediaType[]{MediaType.APPLICATION_JSON_TYPE, MediaType.APPLICATION_XML_TYPE};
        for (String mediaType : mediaTypes) {
            for (MediaType contentType : contentTypes) {
                RMApp app = rm.submitApp(1024, "", this.webserviceUserName);
                amNodeManager.nodeHeartbeat(true);
                AppQueue targetQueue = new AppQueue("test");
                Object entity = contentType.equals((Object)MediaType.APPLICATION_JSON_TYPE) ? TestRMWebServicesAppsModification.appQueueToJSON(targetQueue) : targetQueue;
                ClientResponse response = (ClientResponse)((WebResource.Builder)this.constructWebResource("apps", app.getApplicationId().toString(), "queue").entity(entity, contentType).accept(new String[]{mediaType})).put(ClientResponse.class);
                if (!this.isAuthenticationEnabled()) {
                    Assert.assertEquals((Object)ClientResponse.Status.UNAUTHORIZED, (Object)response.getClientResponseStatus());
                    continue;
                }
                Assert.assertEquals((Object)ClientResponse.Status.OK, (Object)response.getClientResponseStatus());
                String expectedQueue = "test";
                if (!isCapacityScheduler) {
                    expectedQueue = "root.test";
                }
                if (mediaType.equals("application/json")) {
                    TestRMWebServicesAppsModification.verifyAppQueueJson(response, expectedQueue);
                } else {
                    TestRMWebServicesAppsModification.verifyAppQueueXML(response, expectedQueue);
                }
                Assert.assertEquals((Object)expectedQueue, (Object)app.getQueue());
                app = rm.submitApp(1024, "", "someuser");
                amNodeManager.nodeHeartbeat(true);
                response = (ClientResponse)((WebResource.Builder)this.constructWebResource("apps", app.getApplicationId().toString(), "queue").entity(entity, contentType).accept(new String[]{mediaType})).put(ClientResponse.class);
                Assert.assertEquals((Object)ClientResponse.Status.FORBIDDEN, (Object)response.getClientResponseStatus());
                if (isCapacityScheduler) {
                    Assert.assertEquals((Object)"default", (Object)app.getQueue());
                    continue;
                }
                Assert.assertEquals((Object)"root.someuser", (Object)app.getQueue());
            }
        }
        rm.stop();
    }

    protected static String appPriorityToJSON(AppPriority targetPriority) throws Exception {
        StringWriter sw = new StringWriter();
        JSONJAXBContext ctx = new JSONJAXBContext(new Class[]{AppPriority.class});
        JSONMarshaller jm = ctx.createJSONMarshaller();
        jm.marshallToJSON((Object)targetPriority, (Writer)sw);
        return sw.toString();
    }

    protected static String appQueueToJSON(AppQueue targetQueue) throws Exception {
        StringWriter sw = new StringWriter();
        JSONJAXBContext ctx = new JSONJAXBContext(new Class[]{AppQueue.class});
        JSONMarshaller jm = ctx.createJSONMarshaller();
        jm.marshallToJSON((Object)targetQueue, (Writer)sw);
        return sw.toString();
    }

    protected static void verifyAppPriorityJson(ClientResponse response, int expectedPriority) throws JSONException {
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        int responsePriority = json.getInt("priority");
        Assert.assertEquals((long)expectedPriority, (long)responsePriority);
    }

    protected static void verifyAppPriorityXML(ClientResponse response, int expectedPriority) throws ParserConfigurationException, IOException, SAXException {
        Assert.assertEquals((Object)MediaType.APPLICATION_XML_TYPE, (Object)response.getType());
        String xml = (String)response.getEntity(String.class);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        InputSource is = new InputSource();
        is.setCharacterStream(new StringReader(xml));
        Document dom = db.parse(is);
        NodeList nodes = dom.getElementsByTagName("applicationpriority");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)nodes.getLength());
        Element element = (Element)nodes.item(0);
        int responsePriority = WebServicesTestUtils.getXmlInt((Element)element, (String)"priority");
        Assert.assertEquals((long)expectedPriority, (long)responsePriority);
    }

    protected static void verifyAppQueueJson(ClientResponse response, String queue) throws JSONException {
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        String responseQueue = json.getString("queue");
        Assert.assertEquals((Object)queue, (Object)responseQueue);
    }

    protected static void verifyAppQueueXML(ClientResponse response, String queue) throws ParserConfigurationException, IOException, SAXException {
        Assert.assertEquals((Object)MediaType.APPLICATION_XML_TYPE, (Object)response.getType());
        String xml = (String)response.getEntity(String.class);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        InputSource is = new InputSource();
        is.setCharacterStream(new StringReader(xml));
        Document dom = db.parse(is);
        NodeList nodes = dom.getElementsByTagName("appqueue");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)nodes.getLength());
        Element element = (Element)nodes.item(0);
        String responseQueue = WebServicesTestUtils.getXmlString((Element)element, (String)"queue");
        Assert.assertEquals((Object)queue, (Object)responseQueue);
    }

    static {
        TEST_DIR = new File(System.getProperty("test.build.data", "/tmp")).getAbsolutePath();
        FS_ALLOC_FILE = new File(TEST_DIR, "test-fs-queues.xml").getAbsolutePath();
    }

    private class FairTestServletModule
    extends TestServletModule {
        private FairTestServletModule() {
        }

        @Override
        public void configureScheduler() {
            try {
                PrintWriter out = new PrintWriter(new FileWriter(FS_ALLOC_FILE));
                out.println("<?xml version=\"1.0\"?>");
                out.println("<allocations>");
                out.println("<queue name=\"root\">");
                out.println("  <aclAdministerApps>someuser </aclAdministerApps>");
                out.println("  <queue name=\"default\">");
                out.println("    <aclAdministerApps>someuser </aclAdministerApps>");
                out.println("  </queue>");
                out.println("  <queue name=\"test\">");
                out.println("    <aclAdministerApps>someuser </aclAdministerApps>");
                out.println("  </queue>");
                out.println("</queue>");
                out.println("</allocations>");
                out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.conf.set("yarn.scheduler.fair.allocation.file", FS_ALLOC_FILE);
            this.conf.set("yarn.resourcemanager.scheduler.class", FairScheduler.class.getName());
        }
    }

    private class CapTestServletModule
    extends TestServletModule {
        private CapTestServletModule() {
        }

        @Override
        public void configureScheduler() {
            this.conf.set("yarn.resourcemanager.scheduler.class", CapacityScheduler.class.getName());
        }
    }

    private abstract class TestServletModule
    extends ServletModule {
        public Configuration conf = new Configuration();

        private TestServletModule() {
        }

        public abstract void configureScheduler();

        protected void configureServlets() {
            try {
                this.configureScheduler();
                this.bind(JAXBContextResolver.class);
                this.bind(RMWebServices.class);
                this.bind(GenericExceptionHandler.class);
                this.conf.setInt("yarn.resourcemanager.am.max-attempts", 2);
                RMStorageFactory.setConfiguration((Configuration)this.conf);
                YarnAPIStorageFactory.setConfiguration((Configuration)this.conf);
                DBUtility.InitializeDB();
                rm = new MockRM(this.conf);
                this.bind(ResourceManager.class).toInstance((Object)rm);
                if (TestRMWebServicesAppsModification.this.setAuthFilter) {
                    this.filter("/*", new String[0]).through(TestRMCustomAuthFilter.class);
                }
                this.serve("/*", new String[0]).with(GuiceContainer.class);
            }
            catch (IOException ex) {
                Logger.getLogger(TestRMWebServicesAppsModification.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    @Singleton
    public static class TestRMCustomAuthFilter
    extends AuthenticationFilter {
        protected Properties getConfiguration(String configPrefix, FilterConfig filterConfig) throws ServletException {
            Properties props = new Properties();
            Enumeration names = filterConfig.getInitParameterNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                if (!name.startsWith(configPrefix)) continue;
                String value = filterConfig.getInitParameter(name);
                props.put(name.substring(configPrefix.length()), value);
            }
            props.put("type", "simple");
            props.put("simple.anonymous.allowed", "false");
            return props;
        }
    }

    public static class GuiceServletConfig
    extends GuiceServletContextListener {
        protected Injector getInjector() {
            return injector;
        }
    }
}

