/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.ApplicationClientProtocol;
import org.apache.hadoop.yarn.api.ApplicationMasterProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.FailApplicationAttemptRequest;
import org.apache.hadoop.yarn.api.protocolrecords.FailApplicationAttemptResponse;
import org.apache.hadoop.yarn.api.protocolrecords.FinishApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationResponse;
import org.apache.hadoop.yarn.api.protocolrecords.KillApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.KillApplicationResponse;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationUpdateRequest;
import org.apache.hadoop.yarn.api.protocolrecords.SignalContainerRequest;
import org.apache.hadoop.yarn.api.protocolrecords.SubmitApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.SubmitApplicationResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.LogAggregationContext;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.api.records.SignalContainerCommand;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.DrainDispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.api.protocolrecords.NMContainerStatus;
import org.apache.hadoop.yarn.server.resourcemanager.AdminService;
import org.apache.hadoop.yarn.server.resourcemanager.ApplicationMasterService;
import org.apache.hadoop.yarn.server.resourcemanager.ClientRMService;
import org.apache.hadoop.yarn.server.resourcemanager.EmbeddedElector;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.NodesListManager;
import org.apache.hadoop.yarn.server.resourcemanager.RMAppManager;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceTrackerService;
import org.apache.hadoop.yarn.server.resourcemanager.amlauncher.AMLauncherEvent;
import org.apache.hadoop.yarn.server.resourcemanager.amlauncher.ApplicationMasterLauncher;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.NullRMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerState;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeStartedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AbstractYarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplication;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.YarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.security.ClientToAMTokenSecretManagerInRM;
import org.apache.hadoop.yarn.server.resourcemanager.security.NMTokenSecretManagerInRM;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMAppCertificateActionsFactory;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMAppCertificateManager;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMContainerTokenSecretManager;
import org.apache.hadoop.yarn.util.Records;
import org.apache.hadoop.yarn.util.YarnVersionInfo;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.junit.Assert;

public class MockRM
extends ResourceManager {
    static final Logger LOG = Logger.getLogger(MockRM.class);
    static final String ENABLE_WEBAPP = "mockrm.webapp.enabled";
    private static final int SECOND = 1000;
    private static final int TIMEOUT_MS_FOR_APP_REMOVED = 40000;
    private static final int TIMEOUT_MS_FOR_CONTAINER_AND_NODE = 10000;
    private static final int WAIT_MS_PER_LOOP = 10;
    private final boolean useNullRMNodeLabelsManager;
    private boolean useRealElector = false;

    public MockRM() {
        this((Configuration)new YarnConfiguration());
    }

    public MockRM(Configuration conf) {
        this(conf, null);
    }

    public MockRM(Configuration conf, RMStateStore store) {
        this(conf, store, true, false);
    }

    public MockRM(Configuration conf, boolean useRealElector) {
        this(conf, null, true, useRealElector);
    }

    public MockRM(Configuration conf, RMStateStore store, boolean useRealElector) {
        this(conf, store, true, useRealElector);
    }

    public MockRM(Configuration conf, RMStateStore store, boolean useNullRMNodeLabelsManager, boolean useRealElector) {
        this.useNullRMNodeLabelsManager = useNullRMNodeLabelsManager;
        this.useRealElector = useRealElector;
        this.init((Configuration)(conf instanceof YarnConfiguration ? conf : new YarnConfiguration(conf)));
        if (store != null) {
            this.setRMStateStore(store);
        }
        Logger rootLogger = LogManager.getRootLogger();
        rootLogger.setLevel(Level.DEBUG);
    }

    protected RMNodeLabelsManager createNodeLabelManager() throws InstantiationException, IllegalAccessException {
        if (this.useNullRMNodeLabelsManager) {
            NullRMNodeLabelsManager mgr = new NullRMNodeLabelsManager();
            mgr.init(this.getConfig());
            return mgr;
        }
        return super.createNodeLabelManager();
    }

    protected RMAppCertificateManager createRMAppCertificateManager() throws Exception {
        this.getConfig().set("hops.rm.certificate.actor.class", "org.apache.hadoop.yarn.server.resourcemanager.security.TestingRMAppCertificateActions");
        RMAppCertificateActionsFactory.getInstance().clear();
        return new TestingRMAppCertificateManager();
    }

    protected Dispatcher createDispatcher() {
        return new DrainDispatcher();
    }

    protected EmbeddedElector createEmbeddedElector() throws Exception {
        if (this.useRealElector) {
            return super.createEmbeddedElector();
        }
        return null;
    }

    public void drainEvents() {
        Dispatcher rmDispatcher = this.getRmDispatcher();
        if (!(rmDispatcher instanceof DrainDispatcher)) {
            throw new UnsupportedOperationException("Not a Drain Dispatcher!");
        }
        ((DrainDispatcher)rmDispatcher).await();
    }

    public void waitForState(ApplicationId appId, RMAppState finalState) throws Exception {
        RMApp app = (RMApp)this.getRMContext().getRMApps().get(appId);
        Assert.assertNotNull((String)"app shouldn't be null", (Object)app);
        int timeoutMsecs = 80000;
        int waitMsPerLoop = 500;
        int loop = 0;
        while (!finalState.equals((Object)app.getState()) && 500 * loop < 80000) {
            LOG.info((Object)("App : " + appId + " State is : " + app.getState() + " Waiting for state : " + finalState));
            Thread.yield();
            Thread.sleep(500L);
            ++loop;
        }
        int waitedMsecs = 500 * loop;
        LOG.info((Object)("App State is : " + app.getState()));
        if (waitedMsecs >= 80000) {
            Assert.fail((String)("App state is not correct (timedout): expected: " + finalState + " actual: " + app.getState() + " for the application " + appId));
        }
    }

    public void waitForState(ApplicationAttemptId attemptId, RMAppAttemptState finalState) throws Exception {
        this.waitForState(attemptId, finalState, 40000);
    }

    public void waitForState(ApplicationAttemptId attemptId, RMAppAttemptState finalState, int timeoutMsecs) throws Exception {
        RMApp app = (RMApp)this.getRMContext().getRMApps().get(attemptId.getApplicationId());
        Assert.assertNotNull((String)"app shouldn't be null", (Object)app);
        RMAppAttempt attempt = app.getRMAppAttempt(attemptId);
        int minWaitMsecs = 1000;
        int waitMsPerLoop = 10;
        int loop = 0;
        while (!finalState.equals((Object)attempt.getAppAttemptState()) && 10 * loop < timeoutMsecs) {
            LOG.info((Object)("AppAttempt : " + attemptId + " State is : " + attempt.getAppAttemptState() + " Waiting for state : " + finalState));
            Thread.yield();
            Thread.sleep(10L);
            ++loop;
        }
        int waitedMsecs = 10 * loop;
        if (1000 > waitedMsecs) {
            Thread.sleep(1000 - waitedMsecs);
        }
        LOG.info((Object)("Attempt State is : " + attempt.getAppAttemptState()));
        if (waitedMsecs >= timeoutMsecs) {
            Assert.fail((String)("Attempt state is not correct (timedout): expected: " + finalState + " actual: " + attempt.getAppAttemptState() + " for the application attempt " + attemptId));
        }
    }

    public void waitForContainerState(ContainerId containerId, RMContainerState state) throws Exception {
        int timeoutSecs = 0;
        RMContainer container = this.getResourceScheduler().getRMContainer(containerId);
        while ((container == null || container.getState() != state) && timeoutSecs++ < 40) {
            System.out.println("Waiting for" + containerId + " state to be:" + state.name());
            Thread.sleep(200L);
        }
        Assert.assertTrue((container.getState() == state ? 1 : 0) != 0);
    }

    public void waitForContainerAllocated(MockNM nm, ContainerId containerId) throws Exception {
        int timeoutSecs = 0;
        while (this.getResourceScheduler().getRMContainer(containerId) == null && timeoutSecs++ < 40) {
            System.out.println("Waiting for" + containerId + " to be allocated.");
            nm.nodeHeartbeat(true);
            Thread.sleep(200L);
        }
        Assert.assertNotNull((String)("Failed in waiting for " + containerId + " allocation."), (Object)this.getResourceScheduler().getRMContainer(containerId));
    }

    public void waitForContainerToComplete(RMAppAttempt attempt, NMContainerStatus completedContainer) throws InterruptedException {
        while (true) {
            List containers = attempt.getJustFinishedContainers();
            System.out.println("Received completed containers " + containers);
            for (ContainerStatus container : containers) {
                if (!container.getContainerId().equals((Object)completedContainer.getContainerId())) continue;
                return;
            }
            Thread.sleep(200L);
        }
    }

    public MockAM waitForNewAMToLaunchAndRegister(ApplicationId appId, int attemptSize, MockNM nm) throws Exception {
        RMApp app = (RMApp)this.getRMContext().getRMApps().get(appId);
        Assert.assertNotNull((Object)app);
        while (app.getAppAttempts().size() != attemptSize) {
            System.out.println("Application " + appId + " is waiting for AM to restart. Current has " + app.getAppAttempts().size() + " attempts.");
            Thread.sleep(200L);
        }
        return MockRM.launchAndRegisterAM(app, this, nm);
    }

    public boolean waitForState(MockNM nm, ContainerId containerId, RMContainerState containerState) throws Exception {
        return this.waitForState(nm, containerId, containerState, 30000);
    }

    public boolean waitForState(MockNM nm, ContainerId containerId, RMContainerState containerState, int timeoutMillisecs) throws Exception {
        return this.waitForState(Arrays.asList(nm), containerId, containerState, timeoutMillisecs);
    }

    public boolean waitForState(Collection<MockNM> nms, ContainerId containerId, RMContainerState containerState, int timeoutMillisecs) throws Exception {
        RMContainer container = this.getResourceScheduler().getRMContainer(containerId);
        int timeoutSecs = 0;
        while (container == null && timeoutSecs++ < timeoutMillisecs / 100) {
            for (MockNM nm : nms) {
                nm.nodeHeartbeat(true);
            }
            container = this.getResourceScheduler().getRMContainer(containerId);
            System.out.println("Waiting for container " + containerId + " to be " + containerState + ", container is null right now.");
            Thread.sleep(100L);
            if (timeoutMillisecs > timeoutSecs * 100) continue;
            return false;
        }
        Assert.assertNotNull((String)"Container shouldn't be null", (Object)container);
        while (!containerState.equals((Object)container.getState()) && timeoutSecs++ < timeoutMillisecs / 100) {
            System.out.println("Container : " + containerId + " State is : " + container.getState() + " Waiting for state : " + containerState);
            for (MockNM nm : nms) {
                nm.nodeHeartbeat(true);
            }
            Thread.sleep(100L);
            if (timeoutMillisecs > timeoutSecs * 100) continue;
            return false;
        }
        System.out.println("Container State is : " + container.getState());
        Assert.assertEquals((String)"Container state is not correct (timedout)", (Object)containerState, (Object)container.getState());
        return true;
    }

    public GetNewApplicationResponse getNewAppId() throws Exception {
        ClientRMService client = this.getClientRMService();
        return client.getNewApplication((GetNewApplicationRequest)Records.newRecord(GetNewApplicationRequest.class));
    }

    public RMApp submitApp(int masterMemory) throws Exception {
        return this.submitApp(masterMemory, false);
    }

    public RMApp submitApp(int masterMemory, Priority priority2) throws Exception {
        Resource resource = Resource.newInstance((int)masterMemory, (int)0);
        return this.submitApp(resource, "", UserGroupInformation.getCurrentUser().getShortUserName(), null, false, null, super.getConfig().getInt("yarn.resourcemanager.am.max-attempts", 2), null, null, true, false, false, null, 0L, null, true, priority2);
    }

    public RMApp submitApp(int masterMemory, boolean unmanaged) throws Exception {
        return this.submitApp(masterMemory, "", UserGroupInformation.getCurrentUser().getShortUserName(), unmanaged);
    }

    public RMApp submitApp(int masterMemory, String name, String user) throws Exception {
        return this.submitApp(masterMemory, name, user, false);
    }

    public RMApp submitApp(int masterMemory, String name, String user, boolean unmanaged) throws Exception {
        return this.submitApp(masterMemory, name, user, null, unmanaged, null, super.getConfig().getInt("yarn.resourcemanager.am.max-attempts", 2), null);
    }

    public RMApp submitApp(int masterMemory, String name, String user, Map<ApplicationAccessType, String> acls) throws Exception {
        return this.submitApp(masterMemory, name, user, acls, false, null, super.getConfig().getInt("yarn.resourcemanager.am.max-attempts", 2), null);
    }

    public RMApp submitApp(int masterMemory, String name, String user, Map<ApplicationAccessType, String> acls, String queue) throws Exception {
        return this.submitApp(masterMemory, name, user, acls, false, queue, super.getConfig().getInt("yarn.resourcemanager.am.max-attempts", 2), null);
    }

    public RMApp submitApp(int masterMemory, String name, String user, Map<ApplicationAccessType, String> acls, String queue, String amLabel) throws Exception {
        Resource resource = (Resource)Records.newRecord(Resource.class);
        resource.setMemorySize((long)masterMemory);
        Priority priority2 = Priority.newInstance((int)0);
        return this.submitApp(resource, name, user, acls, false, queue, super.getConfig().getInt("yarn.resourcemanager.am.max-attempts", 2), null, null, true, false, false, null, 0L, null, true, priority2, amLabel);
    }

    public RMApp submitApp(Resource resource, String name, String user, Map<ApplicationAccessType, String> acls, String queue) throws Exception {
        return this.submitApp(resource, name, user, acls, false, queue, super.getConfig().getInt("yarn.resourcemanager.am.max-attempts", 2), null, null, true, false, false, null, 0L, null, true, null);
    }

    public RMApp submitApp(int masterMemory, String name, String user, Map<ApplicationAccessType, String> acls, String queue, boolean waitForAccepted) throws Exception {
        return this.submitApp(masterMemory, name, user, acls, false, queue, super.getConfig().getInt("yarn.resourcemanager.am.max-attempts", 2), null, null, waitForAccepted);
    }

    public RMApp submitApp(int masterMemory, String name, String user, Map<ApplicationAccessType, String> acls, boolean unmanaged, String queue, int maxAppAttempts, Credentials ts) throws Exception {
        return this.submitApp(masterMemory, name, user, acls, unmanaged, queue, maxAppAttempts, ts, null);
    }

    public RMApp submitApp(int masterMemory, String name, String user, Map<ApplicationAccessType, String> acls, boolean unmanaged, String queue, int maxAppAttempts, Credentials ts, String appType) throws Exception {
        return this.submitApp(masterMemory, name, user, acls, unmanaged, queue, maxAppAttempts, ts, appType, true);
    }

    public RMApp submitApp(int masterMemory, String name, String user, Map<ApplicationAccessType, String> acls, boolean unmanaged, String queue, int maxAppAttempts, Credentials ts, String appType, boolean waitForAccepted) throws Exception {
        return this.submitApp(masterMemory, name, user, acls, unmanaged, queue, maxAppAttempts, ts, appType, waitForAccepted, false);
    }

    public RMApp submitApp(int masterMemory, String name, String user, Map<ApplicationAccessType, String> acls, boolean unmanaged, String queue, int maxAppAttempts, Credentials ts, String appType, boolean waitForAccepted, boolean keepContainers) throws Exception {
        Resource resource = (Resource)Records.newRecord(Resource.class);
        resource.setMemorySize((long)masterMemory);
        return this.submitApp(resource, name, user, acls, unmanaged, queue, maxAppAttempts, ts, appType, waitForAccepted, keepContainers, false, null, 0L, null, true, Priority.newInstance((int)0));
    }

    public RMApp submitApp(int masterMemory, long attemptFailuresValidityInterval) throws Exception {
        Resource resource = (Resource)Records.newRecord(Resource.class);
        resource.setMemorySize((long)masterMemory);
        Priority priority2 = Priority.newInstance((int)0);
        return this.submitApp(resource, "", UserGroupInformation.getCurrentUser().getShortUserName(), null, false, null, super.getConfig().getInt("yarn.resourcemanager.am.max-attempts", 2), null, null, true, false, false, null, attemptFailuresValidityInterval, null, true, priority2);
    }

    public RMApp submitApp(int masterMemory, String name, String user, Map<ApplicationAccessType, String> acls, boolean unmanaged, String queue, int maxAppAttempts, Credentials ts, String appType, boolean waitForAccepted, boolean keepContainers, boolean isAppIdProvided, ApplicationId applicationId) throws Exception {
        Resource resource = (Resource)Records.newRecord(Resource.class);
        resource.setMemorySize((long)masterMemory);
        Priority priority2 = Priority.newInstance((int)0);
        return this.submitApp(resource, name, user, acls, unmanaged, queue, maxAppAttempts, ts, appType, waitForAccepted, keepContainers, isAppIdProvided, applicationId, 0L, null, true, priority2);
    }

    public RMApp submitApp(int masterMemory, LogAggregationContext logAggregationContext) throws Exception {
        Resource resource = (Resource)Records.newRecord(Resource.class);
        resource.setMemorySize((long)masterMemory);
        Priority priority2 = Priority.newInstance((int)0);
        return this.submitApp(resource, "", UserGroupInformation.getCurrentUser().getShortUserName(), null, false, null, super.getConfig().getInt("yarn.resourcemanager.am.max-attempts", 2), null, null, true, false, false, null, 0L, logAggregationContext, true, priority2);
    }

    public RMApp submitApp(Resource capability, String name, String user, Map<ApplicationAccessType, String> acls, boolean unmanaged, String queue, int maxAppAttempts, Credentials ts, String appType, boolean waitForAccepted, boolean keepContainers, boolean isAppIdProvided, ApplicationId applicationId, long attemptFailuresValidityInterval, LogAggregationContext logAggregationContext, boolean cancelTokensWhenComplete, Priority priority2) throws Exception {
        return this.submitApp(capability, name, user, acls, unmanaged, queue, maxAppAttempts, ts, appType, waitForAccepted, keepContainers, isAppIdProvided, applicationId, attemptFailuresValidityInterval, logAggregationContext, cancelTokensWhenComplete, priority2, "");
    }

    public RMApp submitApp(Resource capability, String name, String user, Map<ApplicationAccessType, String> acls, boolean unmanaged, String queue, int maxAppAttempts, Credentials ts, String appType, boolean waitForAccepted, boolean keepContainers, boolean isAppIdProvided, ApplicationId applicationId, long attemptFailuresValidityInterval, LogAggregationContext logAggregationContext, boolean cancelTokensWhenComplete, Priority priority2, String amLabel) throws Exception {
        ApplicationId appId = isAppIdProvided ? applicationId : null;
        ClientRMService client = this.getClientRMService();
        if (!isAppIdProvided) {
            GetNewApplicationResponse resp = client.getNewApplication((GetNewApplicationRequest)Records.newRecord(GetNewApplicationRequest.class));
            appId = resp.getApplicationId();
        }
        SubmitApplicationRequest req = (SubmitApplicationRequest)Records.newRecord(SubmitApplicationRequest.class);
        ApplicationSubmissionContext sub = (ApplicationSubmissionContext)Records.newRecord(ApplicationSubmissionContext.class);
        sub.setKeepContainersAcrossApplicationAttempts(keepContainers);
        sub.setApplicationId(appId);
        sub.setApplicationName(name);
        sub.setMaxAppAttempts(maxAppAttempts);
        if (unmanaged) {
            sub.setUnmanagedAM(true);
        }
        if (queue != null) {
            sub.setQueue(queue);
        }
        if (priority2 != null) {
            sub.setPriority(priority2);
        }
        sub.setApplicationType(appType);
        ContainerLaunchContext clc = (ContainerLaunchContext)Records.newRecord(ContainerLaunchContext.class);
        sub.setResource(capability);
        clc.setApplicationACLs(acls);
        if (ts != null && UserGroupInformation.isSecurityEnabled()) {
            DataOutputBuffer dob = new DataOutputBuffer();
            ts.writeTokenStorageToStream((DataOutputStream)dob);
            ByteBuffer securityTokens = ByteBuffer.wrap(dob.getData(), 0, dob.getLength());
            clc.setTokens(securityTokens);
        }
        sub.setAMContainerSpec(clc);
        sub.setAttemptFailuresValidityInterval(attemptFailuresValidityInterval);
        if (logAggregationContext != null) {
            sub.setLogAggregationContext(logAggregationContext);
        }
        sub.setCancelTokensWhenComplete(cancelTokensWhenComplete);
        if (amLabel != null && !amLabel.isEmpty()) {
            ResourceRequest amResourceRequest = ResourceRequest.newInstance((Priority)Priority.newInstance((int)0), (String)"*", (Resource)capability, (int)1);
            amResourceRequest.setNodeLabelExpression(amLabel.trim());
            sub.setAMContainerResourceRequest(amResourceRequest);
        }
        req.setApplicationSubmissionContext(sub);
        UserGroupInformation fakeUser = UserGroupInformation.createUserForTesting((String)user, (String[])new String[]{"someGroup"});
        PrivilegedAction<SubmitApplicationResponse> action = new PrivilegedAction<SubmitApplicationResponse>(){
            ApplicationClientProtocol client;
            SubmitApplicationRequest req;

            @Override
            public SubmitApplicationResponse run() {
                try {
                    return this.client.submitApplication(this.req);
                }
                catch (YarnException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return null;
            }

            PrivilegedAction<SubmitApplicationResponse> setClientReq(ApplicationClientProtocol client, SubmitApplicationRequest req) {
                this.client = client;
                this.req = req;
                return this;
            }
        }.setClientReq((ApplicationClientProtocol)client, req);
        fakeUser.doAs(action);
        if (waitForAccepted) {
            this.waitForState(appId, RMAppState.ACCEPTED);
        }
        RMApp rmApp = (RMApp)this.getRMContext().getRMApps().get(appId);
        if (waitForAccepted && !unmanaged) {
            this.waitForState(rmApp.getCurrentAppAttempt().getAppAttemptId(), RMAppAttemptState.SCHEDULED);
        }
        return rmApp;
    }

    public MockNM registerNode(String nodeIdStr, int memory) throws Exception {
        MockNM nm = new MockNM(nodeIdStr, memory, this.getResourceTrackerService());
        nm.registerNode();
        this.drainEvents();
        return nm;
    }

    public MockNM registerNode(String nodeIdStr, int memory, int vCores) throws Exception {
        MockNM nm = new MockNM(nodeIdStr, memory, vCores, this.getResourceTrackerService());
        nm.registerNode();
        return nm;
    }

    public MockNM registerNode(String nodeIdStr, int memory, int vCores, int gpus) throws Exception {
        MockNM nm = new MockNM(nodeIdStr, memory, vCores, gpus, this.getResourceTrackerService());
        nm.registerNode();
        this.drainEvents();
        return nm;
    }

    public MockNM registerNode(String nodeIdStr, int memory, int vCores, int gpus, Map<ApplicationId, Integer> runningApplications) throws Exception {
        MockNM nm = new MockNM(nodeIdStr, memory, vCores, gpus, this.getResourceTrackerService(), YarnVersionInfo.getVersion());
        nm.registerNode(runningApplications);
        return nm;
    }

    public MockNM registerNode(String nodeIdStr, int memory, int vCores, Map<ApplicationId, Integer> runningApplications) throws Exception {
        MockNM nm = new MockNM(nodeIdStr, memory, vCores, 0, this.getResourceTrackerService(), YarnVersionInfo.getVersion());
        nm.registerNode(runningApplications);
        this.drainEvents();
        return nm;
    }

    public void sendNodeStarted(MockNM nm) throws Exception {
        RMNodeImpl node = (RMNodeImpl)this.getRMContext().getRMNodes().get(nm.getNodeId());
        node.handle((Event)new RMNodeStartedEvent(nm.getNodeId(), null, null));
    }

    public void sendNodeLost(MockNM nm) throws Exception {
        RMNodeImpl node = (RMNodeImpl)this.getRMContext().getRMNodes().get(nm.getNodeId());
        node.handle((Event)new RMNodeEvent(nm.getNodeId(), RMNodeEventType.EXPIRE));
    }

    public void waitForState(NodeId nodeId, NodeState finalState) throws InterruptedException {
        RMNode node = (RMNode)this.getRMContext().getRMNodes().get(nodeId);
        if (node == null) {
            node = (RMNode)this.getRMContext().getInactiveRMNodes().get(nodeId);
        }
        Assert.assertNotNull((String)"node shouldn't be null", (Object)node);
        for (int timeWaiting = 0; !finalState.equals((Object)node.getState()) && timeWaiting < 10000; timeWaiting += 10) {
            System.out.println("Node State is : " + node.getState() + " Waiting for state : " + finalState);
            Thread.sleep(10L);
        }
        System.out.println("Node State is : " + node.getState());
        Assert.assertEquals((String)"Node state is not correct (timedout)", (Object)finalState, (Object)node.getState());
    }

    public void NMwaitForState(NodeId nodeid, NodeState finalState) throws Exception {
        RMNode node = (RMNode)this.getRMContext().getRMNodes().get(nodeid);
        Assert.assertNotNull((String)"node shouldn't be null", (Object)node);
        int timeoutSecs = 0;
        while (!finalState.equals((Object)node.getState()) && timeoutSecs++ < 20) {
            System.out.println("Node State is : " + node.getState() + " Waiting for state : " + finalState);
            Thread.sleep(500L);
        }
        System.out.println("Node State is : " + node.getState());
        Assert.assertEquals((String)"Node state is not correct (timedout)", (Object)finalState, (Object)node.getState());
    }

    public KillApplicationResponse killApp(ApplicationId appId) throws Exception {
        ClientRMService client = this.getClientRMService();
        KillApplicationRequest req = KillApplicationRequest.newInstance((ApplicationId)appId);
        return client.forceKillApplication(req);
    }

    public FailApplicationAttemptResponse failApplicationAttempt(ApplicationAttemptId attemptId) throws Exception {
        ClientRMService client = this.getClientRMService();
        FailApplicationAttemptRequest req = FailApplicationAttemptRequest.newInstance((ApplicationAttemptId)attemptId);
        return client.failApplicationAttempt(req);
    }

    public MockAM sendAMLaunched(ApplicationAttemptId appAttemptId) throws Exception {
        MockAM am = new MockAM(this.getRMContext(), (ApplicationMasterProtocol)this.masterService, appAttemptId);
        am.waitForState(RMAppAttemptState.ALLOCATED);
        Token amrmToken = this.rmContext.getAMRMTokenSecretManager().createAndGetAMRMToken(appAttemptId);
        ((RMAppAttemptImpl)((RMApp)this.rmContext.getRMApps().get(appAttemptId.getApplicationId())).getRMAppAttempt(appAttemptId)).setAMRMToken(amrmToken);
        this.getRMContext().getDispatcher().getEventHandler().handle((Event)new RMAppAttemptEvent(appAttemptId, RMAppAttemptEventType.LAUNCHED));
        return am;
    }

    public void sendAMLaunchFailed(ApplicationAttemptId appAttemptId) throws Exception {
        MockAM am = new MockAM(this.getRMContext(), (ApplicationMasterProtocol)this.masterService, appAttemptId);
        am.waitForState(RMAppAttemptState.ALLOCATED);
        this.getRMContext().getDispatcher().getEventHandler().handle((Event)new RMAppAttemptEvent(appAttemptId, RMAppAttemptEventType.LAUNCH_FAILED, "Failed"));
    }

    protected ClientRMService createClientRMService() {
        return new ClientRMService(this.getRMContext(), (YarnScheduler)this.getResourceScheduler(), this.rmAppManager, this.applicationACLsManager, this.queueACLsManager, this.getRMContext().getRMDelegationTokenSecretManager()){

            protected void serviceStart() {
            }

            protected void serviceStop() {
            }
        };
    }

    protected ResourceTrackerService createResourceTrackerService() {
        RMContainerTokenSecretManager containerTokenSecretManager = this.getRMContext().getContainerTokenSecretManager();
        containerTokenSecretManager.rollMasterKey();
        NMTokenSecretManagerInRM nmTokenSecretManager = this.getRMContext().getNMTokenSecretManager();
        nmTokenSecretManager.rollMasterKey();
        return new ResourceTrackerService(this.getRMContext(), this.nodesListManager, this.nmLivelinessMonitor, containerTokenSecretManager, nmTokenSecretManager){

            protected void serviceStart() {
            }

            protected void serviceStop() {
            }
        };
    }

    protected ApplicationMasterService createApplicationMasterService() {
        return new ApplicationMasterService(this.getRMContext(), (YarnScheduler)this.scheduler){

            protected void serviceStart() {
            }

            protected void serviceStop() {
            }
        };
    }

    protected ApplicationMasterLauncher createAMLauncher() {
        return new ApplicationMasterLauncher(this.getRMContext()){

            protected void serviceStart() {
            }

            public void handle(AMLauncherEvent appEvent) {
            }

            protected void serviceStop() {
            }
        };
    }

    protected AdminService createAdminService() {
        return new AdminService(this, this.getRMContext()){

            protected void startServer() {
            }

            protected void stopServer() {
            }
        };
    }

    public NodesListManager getNodesListManager() {
        return this.nodesListManager;
    }

    public ClientToAMTokenSecretManagerInRM getClientToAMTokenSecretManager() {
        return this.getRMContext().getClientToAMTokenSecretManager();
    }

    public RMAppManager getRMAppManager() {
        return this.rmAppManager;
    }

    public AdminService getAdminService() {
        return this.adminService;
    }

    protected void startWepApp() {
        if (this.getConfig().getBoolean(ENABLE_WEBAPP, false)) {
            super.startWepApp();
            return;
        }
    }

    public static void finishAMAndVerifyAppState(RMApp rmApp, MockRM rm, MockNM nm, MockAM am) throws Exception {
        FinishApplicationMasterRequest req = FinishApplicationMasterRequest.newInstance((FinalApplicationStatus)FinalApplicationStatus.SUCCEEDED, (String)"", (String)"");
        am.unregisterAppAttempt(req, true);
        am.waitForState(RMAppAttemptState.FINISHING);
        nm.nodeHeartbeat(am.getApplicationAttemptId(), 1L, ContainerState.COMPLETE);
        am.waitForState(RMAppAttemptState.FINISHED);
        rm.waitForState(rmApp.getApplicationId(), RMAppState.FINISHED);
    }

    private static void waitForSchedulerAppAttemptAdded(ApplicationAttemptId attemptId, MockRM rm) throws InterruptedException {
        for (int tick = 0; null == ((AbstractYarnScheduler)rm.getResourceScheduler()).getApplicationAttempt(attemptId) && tick < 50; ++tick) {
            Thread.sleep(100L);
            if (tick % 10 != 0) continue;
            System.out.println("waiting for SchedulerApplicationAttempt=" + attemptId + " added.");
        }
        Assert.assertNotNull((String)("Timed out waiting for SchedulerApplicationAttempt=" + attemptId + " to be added."), (Object)((AbstractYarnScheduler)rm.getResourceScheduler()).getApplicationAttempt(attemptId));
    }

    public static MockAM launchAM(RMApp app, MockRM rm, MockNM nm) throws Exception {
        RMAppAttempt attempt = MockRM.waitForAttemptScheduled(app, rm);
        System.out.println("Launch AM " + attempt.getAppAttemptId());
        nm.nodeHeartbeat(true);
        MockAM am = rm.sendAMLaunched(attempt.getAppAttemptId());
        rm.waitForState(attempt.getAppAttemptId(), RMAppAttemptState.LAUNCHED);
        return am;
    }

    public static MockAM launchUAM(RMApp app, MockRM rm, MockNM nm) throws Exception {
        rm.waitForState(app.getApplicationId(), RMAppState.ACCEPTED);
        RMAppAttempt attempt = app.getCurrentAppAttempt();
        MockRM.waitForSchedulerAppAttemptAdded(attempt.getAppAttemptId(), rm);
        System.out.println("Launch AM " + attempt.getAppAttemptId());
        nm.nodeHeartbeat(true);
        MockAM am = new MockAM(rm.getRMContext(), (ApplicationMasterProtocol)rm.masterService, attempt.getAppAttemptId());
        rm.waitForState(attempt.getAppAttemptId(), RMAppAttemptState.LAUNCHED);
        return am;
    }

    public static RMAppAttempt waitForAttemptScheduled(RMApp app, MockRM rm) throws Exception {
        rm.waitForState(app.getApplicationId(), RMAppState.ACCEPTED);
        RMAppAttempt attempt = app.getCurrentAppAttempt();
        MockRM.waitForSchedulerAppAttemptAdded(attempt.getAppAttemptId(), rm);
        rm.waitForState(attempt.getAppAttemptId(), RMAppAttemptState.SCHEDULED);
        return attempt;
    }

    public static MockAM launchAndRegisterAM(RMApp app, MockRM rm, MockNM nm) throws Exception {
        MockAM am = MockRM.launchAM(app, rm, nm);
        am.registerAppAttempt();
        rm.waitForState(app.getApplicationId(), RMAppState.RUNNING);
        return am;
    }

    public ApplicationReport getApplicationReport(ApplicationId appId) throws YarnException, IOException {
        ClientRMService client = this.getClientRMService();
        GetApplicationReportResponse response = client.getApplicationReport(GetApplicationReportRequest.newInstance((ApplicationId)appId));
        return response.getApplicationReport();
    }

    public void updateReservationState(ReservationUpdateRequest request) throws IOException, YarnException {
        ClientRMService client = this.getClientRMService();
        client.updateReservation(request);
    }

    public void clearQueueMetrics(RMApp app) {
        ((SchedulerApplication)((AbstractYarnScheduler)this.getResourceScheduler()).getSchedulerApplications().get(app.getApplicationId())).getQueue().getMetrics();
        QueueMetrics.clearQueueMetrics();
    }

    public ResourceManager.RMSchedulerServices getRMActiveService() {
        return this.schedulerServices;
    }

    public void signalToContainer(ContainerId containerId, SignalContainerCommand command) throws Exception {
        ClientRMService client = this.getClientRMService();
        SignalContainerRequest req = SignalContainerRequest.newInstance((ContainerId)containerId, (SignalContainerCommand)command);
        client.signalToContainer(req);
    }

    public void waitForAppRemovedFromScheduler(ApplicationId appId) throws InterruptedException {
        this.waitForAppRemovedFromScheduler(appId, 40000L);
    }

    public void waitForAppRemovedFromScheduler(ApplicationId appId, long timeoutMsecs) throws InterruptedException {
        int timeWaiting = 0;
        Map apps = ((AbstractYarnScheduler)this.getResourceScheduler()).getSchedulerApplications();
        while (apps.containsKey(appId) && (long)timeWaiting < timeoutMsecs) {
            LOG.info((Object)("wait for app removed, " + appId));
            Thread.sleep(10L);
            timeWaiting += 10;
        }
        Assert.assertTrue((String)"app is not removed from scheduler (timeout).", (!apps.containsKey(appId) ? 1 : 0) != 0);
        LOG.info((Object)("app is removed from scheduler, " + appId));
    }

    public void expireNM(NodeId nodeId) {
        this.getRMContext().getDispatcher().getEventHandler().handle((Event)new RMNodeEvent(nodeId, RMNodeEventType.EXPIRE));
    }

    private class TestingRMAppCertificateManager
    extends RMAppCertificateManager {
        private TestingRMAppCertificateManager() {
            super((RMContext)MockRM.this.rmContext);
        }

        public KeyStore loadSystemTrustStore(Configuration conf) throws GeneralSecurityException, IOException {
            KeyStore trustStore = KeyStore.getInstance("JKS");
            trustStore.load(null, null);
            return trustStore;
        }
    }
}

