/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.SaslRpcServer;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.util.KerberosName;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.yarn.api.protocolrecords.CancelDelegationTokenRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RenewDelegationTokenRequest;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.security.client.RMDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.resourcemanager.ClientRMService;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.NullRMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMDelegationTokenSecretManager;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.Records;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;

public class TestTokenClientRMService {
    private static final String kerberosRule = "RULE:[1:$1@$0](.*@EXAMPLE.COM)s/@.*//\nDEFAULT";
    private static RMDelegationTokenSecretManager dtsm;
    private static final UserGroupInformation owner;
    private static final UserGroupInformation other;
    private static final UserGroupInformation tester;
    private static final String testerPrincipal = "tester@EXAMPLE.COM";
    private static final String ownerPrincipal = "owner@EXAMPLE.COM";
    private static final String otherPrincipal = "other@EXAMPLE.COM";
    private static final UserGroupInformation testerKerb;
    private static final UserGroupInformation ownerKerb;
    private static final UserGroupInformation otherKerb;

    @BeforeClass
    public static void setupSecretManager() throws IOException {
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        Mockito.when((Object)rmContext.getStateStore()).thenReturn((Object)new NullRMStateStore());
        dtsm = new RMDelegationTokenSecretManager(60000L, 60000L, 60000L, 60000L, rmContext);
        dtsm.startThreads();
        Configuration conf = new Configuration();
        conf.set("hadoop.security.authentication", "kerberos");
        conf.set("hadoop.security.auth_to_local", kerberosRule);
        UserGroupInformation.setConfiguration((Configuration)conf);
    }

    @AfterClass
    public static void teardownSecretManager() {
        if (dtsm != null) {
            dtsm.stopThreads();
        }
    }

    @Test
    public void testTokenCancellationByOwner() throws Exception {
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        final ClientRMService rmService = new ClientRMService(rmContext, null, null, null, null, dtsm);
        testerKerb.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                TestTokenClientRMService.this.checkTokenCancellation(rmService, testerKerb, other);
                return null;
            }
        });
        owner.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                TestTokenClientRMService.this.checkTokenCancellation(owner, other);
                return null;
            }
        });
    }

    @Test
    public void testTokenRenewalWrongUser() throws Exception {
        try {
            owner.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try {
                        TestTokenClientRMService.this.checkTokenRenewal(owner, other);
                        return null;
                    }
                    catch (YarnException ex) {
                        Assert.assertTrue((boolean)ex.getMessage().contains(owner.getUserName() + " tries to renew a token"));
                        Assert.assertTrue((boolean)ex.getMessage().contains("with non-matching renewer " + other.getUserName()));
                        throw ex;
                    }
                }
            });
        }
        catch (Exception e) {
            return;
        }
        Assert.fail((String)"renew should have failed");
    }

    @Test
    public void testTokenRenewalByLoginUser() throws Exception {
        UserGroupInformation.getLoginUser().doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                TestTokenClientRMService.this.checkTokenRenewal(owner, owner);
                TestTokenClientRMService.this.checkTokenRenewal(owner, other);
                return null;
            }
        });
    }

    private void checkTokenRenewal(UserGroupInformation owner, UserGroupInformation renewer) throws IOException, YarnException {
        RMDelegationTokenIdentifier tokenIdentifier = new RMDelegationTokenIdentifier(new Text(owner.getUserName()), new Text(renewer.getUserName()), null);
        Token token = new Token((TokenIdentifier)tokenIdentifier, (SecretManager)dtsm);
        org.apache.hadoop.yarn.api.records.Token dToken = BuilderUtils.newDelegationToken((byte[])token.getIdentifier(), (String)token.getKind().toString(), (byte[])token.getPassword(), (String)token.getService().toString());
        RenewDelegationTokenRequest request = (RenewDelegationTokenRequest)Records.newRecord(RenewDelegationTokenRequest.class);
        request.setDelegationToken(dToken);
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        ClientRMService rmService = new ClientRMService(rmContext, null, null, null, null, dtsm);
        rmService.renewDelegationToken(request);
    }

    @Test
    public void testTokenCancellationByRenewer() throws Exception {
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        final ClientRMService rmService = new ClientRMService(rmContext, null, null, null, null, dtsm);
        testerKerb.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                TestTokenClientRMService.this.checkTokenCancellation(rmService, owner, testerKerb);
                return null;
            }
        });
        other.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                TestTokenClientRMService.this.checkTokenCancellation(owner, other);
                return null;
            }
        });
    }

    @Test
    public void testTokenCancellationByWrongUser() {
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        final ClientRMService rmService = new ClientRMService(rmContext, null, null, null, null, dtsm);
        UserGroupInformation[] kerbTestOwners = new UserGroupInformation[]{owner, other, tester, ownerKerb, otherKerb};
        UserGroupInformation[] kerbTestRenewers = new UserGroupInformation[]{owner, other, ownerKerb, otherKerb};
        for (final UserGroupInformation tokOwner : kerbTestOwners) {
            for (final UserGroupInformation tokRenewer : kerbTestRenewers) {
                try {
                    testerKerb.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                        @Override
                        public Void run() throws Exception {
                            try {
                                TestTokenClientRMService.this.checkTokenCancellation(rmService, tokOwner, tokRenewer);
                                Assert.fail((String)("We should not reach here; token owner = " + tokOwner.getUserName() + ", renewer = " + tokRenewer.getUserName()));
                                return null;
                            }
                            catch (YarnException e) {
                                Assert.assertTrue((boolean)e.getMessage().contains(testerKerb.getUserName() + " is not authorized to cancel the token"));
                                return null;
                            }
                        }
                    });
                }
                catch (Exception e) {
                    Assert.fail((String)("Unexpected exception; " + e.getMessage()));
                }
            }
        }
        UserGroupInformation[] simpleTestOwners = new UserGroupInformation[]{owner, other, ownerKerb, otherKerb, testerKerb};
        UserGroupInformation[] simpleTestRenewers = new UserGroupInformation[]{owner, other, ownerKerb, otherKerb};
        for (final UserGroupInformation tokOwner : simpleTestOwners) {
            for (final UserGroupInformation tokRenewer : simpleTestRenewers) {
                try {
                    tester.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                        @Override
                        public Void run() throws Exception {
                            try {
                                TestTokenClientRMService.this.checkTokenCancellation(tokOwner, tokRenewer);
                                Assert.fail((String)("We should not reach here; token owner = " + tokOwner.getUserName() + ", renewer = " + tokRenewer.getUserName()));
                                return null;
                            }
                            catch (YarnException ex) {
                                Assert.assertTrue((boolean)ex.getMessage().contains(tester.getUserName() + " is not authorized to cancel the token"));
                                return null;
                            }
                        }
                    });
                }
                catch (Exception e) {
                    Assert.fail((String)("Unexpected exception; " + e.getMessage()));
                }
            }
        }
    }

    private void checkTokenCancellation(UserGroupInformation owner, UserGroupInformation renewer) throws IOException, YarnException {
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        ClientRMService rmService = new ClientRMService(rmContext, null, null, null, null, dtsm);
        this.checkTokenCancellation(rmService, owner, renewer);
    }

    private void checkTokenCancellation(ClientRMService rmService, UserGroupInformation owner, UserGroupInformation renewer) throws IOException, YarnException {
        RMDelegationTokenIdentifier tokenIdentifier = new RMDelegationTokenIdentifier(new Text(owner.getUserName()), new Text(renewer.getUserName()), null);
        Token token = new Token((TokenIdentifier)tokenIdentifier, (SecretManager)dtsm);
        org.apache.hadoop.yarn.api.records.Token dToken = BuilderUtils.newDelegationToken((byte[])token.getIdentifier(), (String)token.getKind().toString(), (byte[])token.getPassword(), (String)token.getService().toString());
        CancelDelegationTokenRequest request = (CancelDelegationTokenRequest)Records.newRecord(CancelDelegationTokenRequest.class);
        request.setDelegationToken(dToken);
        rmService.cancelDelegationToken(request);
    }

    @Test
    public void testTokenRenewalByOwner() throws Exception {
        owner.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                TestTokenClientRMService.this.checkTokenRenewal(owner, owner);
                return null;
            }
        });
    }

    static {
        KerberosName.setRules((String)kerberosRule);
        owner = UserGroupInformation.createRemoteUser((String)"owner", (SaslRpcServer.AuthMethod)SaslRpcServer.AuthMethod.KERBEROS);
        other = UserGroupInformation.createRemoteUser((String)"other", (SaslRpcServer.AuthMethod)SaslRpcServer.AuthMethod.KERBEROS);
        tester = UserGroupInformation.createRemoteUser((String)"tester", (SaslRpcServer.AuthMethod)SaslRpcServer.AuthMethod.KERBEROS);
        testerKerb = UserGroupInformation.createRemoteUser((String)testerPrincipal, (SaslRpcServer.AuthMethod)SaslRpcServer.AuthMethod.KERBEROS);
        ownerKerb = UserGroupInformation.createRemoteUser((String)ownerPrincipal, (SaslRpcServer.AuthMethod)SaslRpcServer.AuthMethod.KERBEROS);
        otherKerb = UserGroupInformation.createRemoteUser((String)otherPrincipal, (SaslRpcServer.AuthMethod)SaslRpcServer.AuthMethod.KERBEROS);
    }
}

