/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.security;

import io.hops.security.HopsUtil;
import io.hops.util.DBUtility;
import io.hops.util.RMStorageFactory;
import io.hops.util.YarnAPIStorageFactory;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.ssl.FileBasedKeyStoresFactory;
import org.apache.hadoop.security.ssl.KeyStoreTestUtil;
import org.apache.hadoop.security.ssl.SSLFactory;
import org.apache.hadoop.util.ExponentialBackOff;
import org.apache.hadoop.yarn.MockApps;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.api.records.impl.pb.ApplicationSubmissionContextPBImpl;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.DrainDispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.server.api.protocolrecords.NodeHeartbeatResponse;
import org.apache.hadoop.yarn.server.resourcemanager.ApplicationMasterService;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.RMAppManager;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.RMContextImpl;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.DBRMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.ApplicationStateData;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppCertificateGeneratedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeImpl;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.YarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.security.DevHopsworksRMAppCertificateActions;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMAppCertificateActions;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMAppCertificateActionsFactory;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMAppCertificateManager;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMAppCertificateManagerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMAppCertificateManagerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.security.TestingRMAppCertificateActions;
import org.apache.hadoop.yarn.server.security.ApplicationACLsManager;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestRMAppCertificateManager {
    private static final Log LOG = LogFactory.getLog(TestRMAppCertificateManager.class);
    private static final String BASE_DIR = Paths.get(System.getProperty("test.build.dir", Paths.get("target", "test-dir").toString()), TestRMAppCertificateManager.class.getSimpleName()).toString();
    private static final File BASE_DIR_FILE = new File(BASE_DIR);
    private static String classPath;
    private Configuration conf;
    private DrainDispatcher dispatcher;
    private RMContext rmContext;
    private File sslServerFile;

    @BeforeClass
    public static void beforeClass() throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        BASE_DIR_FILE.mkdirs();
        classPath = KeyStoreTestUtil.getClasspathDir(TestRMAppCertificateManager.class);
    }

    @Before
    public void beforeTest() throws Exception {
        this.conf = new Configuration();
        this.conf.set(YarnConfiguration.HOPS_HOPSWORKS_HOST_KEY, "https://bbc3.sics.se:33478");
        this.conf.set("yarn.resourcemanager.certificate.expiration-safety-period", "5s");
        RMAppCertificateActionsFactory.getInstance().clear();
        RMStorageFactory.setConfiguration((Configuration)this.conf);
        YarnAPIStorageFactory.setConfiguration((Configuration)this.conf);
        DBUtility.InitializeDB();
        this.dispatcher = new DrainDispatcher();
        this.rmContext = new RMContextImpl((Dispatcher)this.dispatcher, null, null, null, null, null, null, null, null);
        this.dispatcher.init(this.conf);
        this.dispatcher.start();
        String sslConfFileName = TestRMAppCertificateManager.class.getSimpleName() + ".ssl-server.xml";
        this.sslServerFile = Paths.get(classPath, sslConfFileName).toFile();
        Configuration sslServer = new Configuration(false);
        sslServer.set("hops.hopsworks.user", "agent-user");
        sslServer.set("hops.hopsworks.password", "agent-password");
        KeyStoreTestUtil.saveConfig((File)this.sslServerFile, (Configuration)sslServer);
        this.conf.set("hadoop.ssl.server.conf", sslConfFileName);
    }

    @After
    public void afterTest() throws Exception {
        if (this.dispatcher != null) {
            this.dispatcher.stop();
        }
        if (this.sslServerFile != null) {
            this.sslServerFile.delete();
        }
    }

    @AfterClass
    public static void afterClass() throws Exception {
        if (BASE_DIR_FILE.exists()) {
            FileUtils.deleteDirectory((File)BASE_DIR_FILE);
        }
        RMAppCertificateActionsFactory.getInstance().clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSuccessfulCertificateCreationTesting() throws Exception {
        File testSpecificSSLServerFile = null;
        try {
            this.conf.set("hops.rm.certificate.actor.class", "org.apache.hadoop.yarn.server.resourcemanager.security.TestingRMAppCertificateActions");
            RMAppCertificateActions testActor = RMAppCertificateActionsFactory.getInstance().getActor(this.conf);
            String trustStore = Paths.get(BASE_DIR, "trustStore.jks").toString();
            X509Certificate caCert = ((TestingRMAppCertificateActions)testActor).getCaCert();
            String principal = caCert.getIssuerX500Principal().getName();
            String alias = principal.split("=")[1];
            String password = "password";
            String sslServer = TestRMAppCertificateManager.class.getSimpleName() + "-testSuccessfulCertificateCreationTesting.ssl-server.xml";
            testSpecificSSLServerFile = Paths.get(classPath, sslServer).toFile();
            this.conf.set("hadoop.ssl.server.conf", sslServer);
            this.createTrustStore(trustStore, password, alias, caCert);
            Configuration sslServerConf = this.createSSLConfig("", "", "", trustStore, password, "");
            this.saveConfig(testSpecificSSLServerFile.getAbsoluteFile(), sslServerConf);
            MockRMAppEventHandler eventHandler = new MockRMAppEventHandler(RMAppEventType.CERTS_GENERATED);
            this.rmContext.getDispatcher().register(RMAppEventType.class, (EventHandler)eventHandler);
            MockRMAppCertificateManager manager = new MockRMAppCertificateManager(true, this.rmContext);
            manager.init(this.conf);
            manager.start();
            manager.handle(new RMAppCertificateManagerEvent(ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1), "userA", Integer.valueOf(1), RMAppCertificateManagerEventType.GENERATE_CERTIFICATE));
            this.dispatcher.await();
            eventHandler.verifyEvent();
            manager.stop();
        }
        finally {
            if (testSpecificSSLServerFile != null) {
                testSpecificSSLServerFile.delete();
            }
        }
    }

    @Test
    public void testCertificateRenewal() throws Exception {
        this.conf.set("hops.rm.certificate.actor.class", "org.apache.hadoop.yarn.server.resourcemanager.security.TestingRMAppCertificateActions");
        MockRMAppCertificateManager certificateManager = new MockRMAppCertificateManager(false, this.rmContext);
        certificateManager.init(this.conf);
        certificateManager.start();
        Instant now = Instant.now();
        Instant expiration = now.plus(10L, ChronoUnit.SECONDS);
        ApplicationId appId = ApplicationId.newInstance((long)now.toEpochMilli(), (int)1);
        certificateManager.setOldCertificateExpiration(expiration.toEpochMilli());
        certificateManager.registerWithCertificateRenewer(appId, "Dolores", 1, expiration.toEpochMilli());
        Map tasks = certificateManager.getRenewalTasks();
        ScheduledFuture renewalTask = (ScheduledFuture)tasks.get(appId);
        Assert.assertFalse((boolean)renewalTask.isCancelled());
        Assert.assertFalse((boolean)renewalTask.isDone());
        TimeUnit.SECONDS.sleep(10L);
        Assert.assertTrue((boolean)renewalTask.isDone());
        Assert.assertFalse((boolean)certificateManager.getRenewalException());
        Assert.assertTrue((boolean)tasks.isEmpty());
        certificateManager.stop();
    }

    @Test(timeout=12000L)
    public void testFailedCertificateRenewal() throws Exception {
        this.conf.set("hops.rm.certificate.actor.class", "org.apache.hadoop.yarn.server.resourcemanager.security.TestingRMAppCertificateActions");
        MockFailingRMAppCertificateManager certificateManager = new MockFailingRMAppCertificateManager(Integer.MAX_VALUE);
        certificateManager.init(this.conf);
        certificateManager.start();
        Instant now = Instant.now();
        Instant expiration = now.plus(10L, ChronoUnit.SECONDS);
        ApplicationId appId = ApplicationId.newInstance((long)now.toEpochMilli(), (int)1);
        certificateManager.registerWithCertificateRenewer(appId, "Dolores", 1, expiration.toEpochMilli());
        Map tasks = certificateManager.getRenewalTasks();
        ScheduledFuture task = (ScheduledFuture)tasks.get(appId);
        Assert.assertFalse((boolean)task.isCancelled());
        Assert.assertFalse((boolean)task.isDone());
        Assert.assertFalse((boolean)certificateManager.hasRenewalFailed());
        Assert.assertEquals((long)0L, (long)certificateManager.getNumberOfRenewalFailures());
        TimeUnit.SECONDS.sleep(10L);
        Assert.assertTrue((boolean)tasks.isEmpty());
        Assert.assertEquals((long)4L, (long)certificateManager.getNumberOfRenewalFailures());
        Assert.assertTrue((boolean)certificateManager.hasRenewalFailed());
        certificateManager.stop();
    }

    @Test(timeout=12000L)
    public void testRetryCertificateRenewal() throws Exception {
        this.conf.set("hops.rm.certificate.actor.class", "org.apache.hadoop.yarn.server.resourcemanager.security.TestingRMAppCertificateActions");
        MockFailingRMAppCertificateManager certificateManager = new MockFailingRMAppCertificateManager(2);
        certificateManager.init(this.conf);
        certificateManager.start();
        Instant now = Instant.now();
        Instant expiration = now.plus(10L, ChronoUnit.SECONDS);
        ApplicationId appId = ApplicationId.newInstance((long)now.toEpochMilli(), (int)1);
        certificateManager.registerWithCertificateRenewer(appId, "Dolores", 1, expiration.toEpochMilli());
        TimeUnit.SECONDS.sleep(10L);
        Assert.assertEquals((long)2L, (long)certificateManager.getNumberOfRenewalFailures());
        Assert.assertFalse((boolean)certificateManager.hasRenewalFailed());
        Assert.assertTrue((boolean)certificateManager.getRenewalTasks().isEmpty());
        certificateManager.stop();
    }

    @Test
    @Ignore
    public void testSuccessfulCertificateCreationRemote() throws Exception {
        DevHopsworksRMAppCertificateActions mockRemoteActions = (DevHopsworksRMAppCertificateActions)Mockito.spy((Object)new DevHopsworksRMAppCertificateActions());
        mockRemoteActions.setConf(this.conf);
        mockRemoteActions.init();
        RMAppCertificateActionsFactory.getInstance().register((RMAppCertificateActions)mockRemoteActions);
        MockRMAppCertificateManager manager = new MockRMAppCertificateManager(false, this.rmContext);
        manager.init(this.conf);
        manager.start();
        manager.handle(new RMAppCertificateManagerEvent(ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1), "userA", Integer.valueOf(1), RMAppCertificateManagerEventType.GENERATE_CERTIFICATE));
        this.dispatcher.await();
        manager.stop();
    }

    @Test
    @Ignore
    public void testCertificateRevocationRemote() throws Exception {
        this.conf.setBoolean("ipc.server.ssl.enabled", true);
        DevHopsworksRMAppCertificateActions mockRemoteActions = (DevHopsworksRMAppCertificateActions)Mockito.spy((Object)new DevHopsworksRMAppCertificateActions());
        mockRemoteActions.setConf(this.conf);
        mockRemoteActions.init();
        RMAppCertificateActionsFactory.getInstance().register((RMAppCertificateActions)mockRemoteActions);
        MockRMAppCertificateManager manager = (MockRMAppCertificateManager)((Object)Mockito.spy((Object)((Object)new MockRMAppCertificateManager(false, this.rmContext))));
        manager.init(this.conf);
        manager.start();
        String username = "Alice";
        Integer cryptoMaterialVersion = 1;
        ApplicationId appId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1);
        manager.handle(new RMAppCertificateManagerEvent(appId, username, cryptoMaterialVersion, RMAppCertificateManagerEventType.GENERATE_CERTIFICATE));
        this.dispatcher.await();
        ((DevHopsworksRMAppCertificateActions)Mockito.verify((Object)mockRemoteActions)).sign((PKCS10CertificationRequest)Mockito.any(PKCS10CertificationRequest.class));
        manager.handle(new RMAppCertificateManagerEvent(appId, username, cryptoMaterialVersion, RMAppCertificateManagerEventType.REVOKE_CERTIFICATE));
        this.dispatcher.await();
        ((MockRMAppCertificateManager)((Object)Mockito.verify((Object)((Object)manager)))).revokeCertificate(appId, username, cryptoMaterialVersion);
        ((MockRMAppCertificateManager)((Object)Mockito.verify((Object)((Object)manager)))).deregisterFromCertificateRenewer(appId);
        TimeUnit.SECONDS.sleep(3L);
        String certificateIdentifier = username + "__" + appId.toString() + "__" + cryptoMaterialVersion;
        ((DevHopsworksRMAppCertificateActions)Mockito.verify((Object)mockRemoteActions)).revoke((String)Mockito.eq((Object)certificateIdentifier));
        manager.stop();
    }

    @Test
    public void testFailingCertificateCreationLocal() throws Exception {
        this.conf.set("hops.rm.certificate.actor.class", "org.apache.hadoop.yarn.server.resourcemanager.security.TestingRMAppCertificateActions");
        MockRMAppEventHandler eventHandler = new MockRMAppEventHandler(RMAppEventType.KILL);
        this.rmContext.getDispatcher().register(RMAppEventType.class, (EventHandler)eventHandler);
        MockFailingRMAppCertificateManager manager = new MockFailingRMAppCertificateManager(Integer.MAX_VALUE);
        manager.init(this.conf);
        manager.start();
        manager.handle(new RMAppCertificateManagerEvent(ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1), "userA", Integer.valueOf(1), RMAppCertificateManagerEventType.GENERATE_CERTIFICATE));
        this.dispatcher.await();
        eventHandler.verifyEvent();
        manager.stop();
    }

    @Test(timeout=20000L)
    public void testCertificateRevocationMonitor() throws Exception {
        RMAppCertificateActions actor = (RMAppCertificateActions)Mockito.spy((Object)new TestingRMAppCertificateActions());
        actor.init();
        RMAppCertificateActionsFactory.getInstance().register(actor);
        this.conf.set("yarn.resourcemanager.certificate.expiration-safety-period", "40s");
        this.conf.set("yarn.resourcemanager.certificate.revocation-monitor-interval", "3s");
        this.conf.setBoolean("ipc.server.ssl.enabled", true);
        MyMockRM rm = new MyMockRM(this.conf);
        rm.start();
        MockNM nm = new MockNM("127.0.0.1:8032", 15360, rm.getResourceTrackerService());
        nm.registerNode();
        RMApp application = rm.submitApp(1024, "application1", "Phil", new HashMap<ApplicationAccessType, String>(), false, "default", 2, null, "MAPREDUCE", true, false);
        nm.nodeHeartbeat(true);
        while (!application.isAppRotatingCryptoMaterial()) {
            TimeUnit.MILLISECONDS.sleep(500L);
        }
        Assert.assertTrue((boolean)application.isAppRotatingCryptoMaterial());
        Assert.assertNotEquals((long)-1L, (long)application.getMaterialRotationStartTime());
        TimeUnit.SECONDS.sleep(6L);
        Assert.assertFalse((boolean)application.isAppRotatingCryptoMaterial());
        Assert.assertEquals((long)-1L, (long)application.getMaterialRotationStartTime());
        String certId = RMAppCertificateManager.getCertificateIdentifier((ApplicationId)application.getApplicationId(), (String)application.getUser(), (Integer)(application.getCryptoMaterialVersion() - 1));
        ((RMAppCertificateActions)Mockito.verify((Object)actor)).revoke((String)Mockito.eq((Object)certId));
        ((RMAppCertificateManager)Mockito.verify((Object)rm.getRMContext().getRMAppCertificateManager(), (VerificationMode)Mockito.never())).revokeCertificate((ApplicationId)Mockito.any(ApplicationId.class), Mockito.anyString(), Integer.valueOf(Mockito.anyInt()), Mockito.anyBoolean());
        rm.stop();
    }

    @Test
    public void testApplicationSubmission() throws Exception {
        this.conf.set("hops.rm.certificate.actor.class", "org.apache.hadoop.yarn.server.resourcemanager.security.TestingRMAppCertificateActions");
        this.conf.setBoolean("yarn.resourcemanager.recovery.enabled", true);
        this.conf.set("yarn.resourcemanager.store.class", DBRMStateStore.class.getName());
        this.conf.set("yarn.resourcemanager.certificate.expiration-safety-period", "45s");
        this.conf.setBoolean("ipc.server.ssl.enabled", true);
        MyMockRM rm = new MyMockRM(this.conf);
        rm.start();
        MockNM nm = new MockNM("127.0.0.1:8032", 15360, rm.getResourceTrackerService());
        nm.registerNode();
        RMApp application = rm.submitApp(1024, "application1", "Phil", new HashMap<ApplicationAccessType, String>(), false, "default", 2, null, "MAPREDUCE", true, false);
        nm.nodeHeartbeat(true);
        Assert.assertNotNull((Object)application);
        byte[] keyStore = application.getKeyStore();
        Assert.assertNotNull((Object)keyStore);
        Assert.assertNotEquals((long)0L, (long)keyStore.length);
        char[] keyStorePassword = application.getKeyStorePassword();
        Assert.assertNotNull((Object)keyStorePassword);
        Assert.assertNotEquals((long)0L, (long)keyStorePassword.length);
        byte[] trustStore = application.getTrustStore();
        Assert.assertNotNull((Object)trustStore);
        Assert.assertNotEquals((long)0L, (long)trustStore.length);
        char[] trustStorePassword = application.getTrustStorePassword();
        Integer cryptoMaterialVersion = application.getCryptoMaterialVersion();
        Assert.assertNotNull((Object)trustStorePassword);
        Assert.assertNotEquals((long)0L, (long)trustStorePassword.length);
        TimeUnit.SECONDS.sleep(5L);
        byte[] newKeyStore = application.getKeyStore();
        Assert.assertFalse((boolean)Arrays.equals(keyStore, newKeyStore));
        Assert.assertNotEquals((long)0L, (long)newKeyStore.length);
        byte[] newTrustStore = application.getTrustStore();
        Assert.assertFalse((boolean)Arrays.equals(trustStore, newTrustStore));
        Assert.assertNotEquals((long)0L, (long)newTrustStore.length);
        char[] newKeyStorePass = application.getKeyStorePassword();
        Assert.assertFalse((boolean)Arrays.equals(keyStorePassword, newKeyStorePass));
        Assert.assertNotEquals((long)0L, (long)newKeyStorePass.length);
        char[] newTrustStorePass = application.getTrustStorePassword();
        Assert.assertFalse((boolean)Arrays.equals(trustStorePassword, newTrustStorePass));
        Assert.assertNotEquals((long)0L, (long)newTrustStorePass.length);
        Integer currentCryptoMaterialVersion = application.getCryptoMaterialVersion();
        cryptoMaterialVersion = cryptoMaterialVersion + 1;
        Assert.assertEquals((Object)cryptoMaterialVersion, (Object)currentCryptoMaterialVersion);
        ApplicationStateData appState = (ApplicationStateData)rm.getRMContext().getStateStore().loadState().getApplicationState().get(application.getApplicationId());
        Assert.assertTrue((boolean)Arrays.equals(newKeyStore, appState.getKeyStore()));
        Assert.assertTrue((boolean)Arrays.equals(newTrustStore, appState.getTrustStore()));
        Assert.assertTrue((boolean)Arrays.equals(newKeyStorePass, appState.getKeyStorePassword()));
        Assert.assertTrue((boolean)Arrays.equals(newTrustStorePass, appState.getTrustStorePassword()));
        Assert.assertEquals((Object)currentCryptoMaterialVersion, (Object)appState.getCryptoMaterialVersion());
        Assert.assertTrue((boolean)appState.isDuringMaterialRotation());
        Assert.assertNotEquals((long)-1L, (long)appState.getMaterialRotationStartTime());
        HashSet<ApplicationId> updatedAppCrypto = new HashSet<ApplicationId>(1);
        updatedAppCrypto.add(application.getApplicationId());
        nm.nodeHeartbeat(Collections.emptyList(), Collections.emptyList(), true, nm.getNextResponseId(), updatedAppCrypto);
        TimeUnit.MILLISECONDS.sleep(100L);
        RMAppImpl appImpl = (RMAppImpl)application;
        Assert.assertNull((Object)appImpl.getRMNodesUpdatedCryptoMaterial());
        Assert.assertFalse((boolean)application.isAppRotatingCryptoMaterial());
        appState = (ApplicationStateData)rm.getRMContext().getStateStore().loadState().getApplicationState().get(application.getApplicationId());
        Assert.assertFalse((boolean)appState.isDuringMaterialRotation());
        Assert.assertEquals((long)-1L, (long)appState.getMaterialRotationStartTime());
        Assert.assertTrue((boolean)rm.getRMContext().getRMAppCertificateManager().getRenewalTasks().containsKey(application.getApplicationId()));
        TimeUnit.MILLISECONDS.sleep(100L);
        ((RMAppCertificateManager)Mockito.verify((Object)rm.getRMContext().getRMAppCertificateManager())).revokeCertificate((ApplicationId)Mockito.eq((Object)application.getApplicationId()), (String)Mockito.eq((Object)application.getUser()), Integer.valueOf(Mockito.eq((int)(application.getCryptoMaterialVersion() - 1))), Mockito.eq((boolean)true));
        rm.stop();
        this.conf.set("yarn.resourcemanager.certificate.expiration-safety-period", "2d");
        MyMockRM rm2 = new MyMockRM(this.conf);
        rm2.start();
        nm.setResourceTrackerService(rm2.getResourceTrackerService());
        nm.nodeHeartbeat(true);
        RMApp recoveredApp = (RMApp)rm2.getRMContext().getRMApps().get(application.getApplicationId());
        Assert.assertNotNull((Object)recoveredApp);
        Assert.assertTrue((boolean)Arrays.equals(newKeyStore, recoveredApp.getKeyStore()));
        appState = (ApplicationStateData)rm2.getRMContext().getStateStore().loadState().getApplicationState().get(application.getApplicationId());
        Assert.assertFalse((boolean)appState.isDuringMaterialRotation());
        Assert.assertEquals((long)-1L, (long)appState.getMaterialRotationStartTime());
        Assert.assertTrue((boolean)rm2.getRMContext().getRMAppCertificateManager().getRenewalTasks().containsKey(application.getApplicationId()));
        rm2.killApp(application.getApplicationId());
        rm2.waitForState(application.getApplicationId(), RMAppState.KILLED);
        Assert.assertTrue((boolean)rm2.getRMContext().getRMAppCertificateManager().getRenewalTasks().isEmpty());
        rm2.stop();
    }

    @Test
    public void testContainerAllocationDuringMaterialRotation() throws Exception {
        this.conf.set("hops.rm.certificate.actor.class", "org.apache.hadoop.yarn.server.resourcemanager.security.TestingRMAppCertificateActions");
        this.conf.setBoolean("yarn.resourcemanager.recovery.enabled", true);
        this.conf.set("yarn.resourcemanager.store.class", DBRMStateStore.class.getName());
        this.conf.set("yarn.resourcemanager.certificate.expiration-safety-period", "40s");
        this.conf.setBoolean("ipc.server.ssl.enabled", true);
        MyMockRM2 rm = new MyMockRM2(this.conf);
        rm.start();
        MockNM nm1 = new MockNM("127.0.0.1:1234", 2048, rm.getResourceTrackerService());
        nm1.registerNode();
        RMApp app = rm.submitApp(1024);
        nm1.nodeHeartbeat(true);
        RMAppAttempt appAttempt = app.getCurrentAppAttempt();
        MockAM am = rm.sendAMLaunched(appAttempt.getAppAttemptId());
        am.registerAppAttempt(true);
        am.allocate("127.0.0.1", 512, 1, Collections.emptyList());
        nm1.nodeHeartbeat(true);
        List allocatedContainers = am.allocate(Collections.emptyList(), Collections.emptyList()).getAllocatedContainers();
        while (allocatedContainers.size() < 1) {
            nm1.nodeHeartbeat(true);
            TimeUnit.MILLISECONDS.sleep(200L);
            allocatedContainers = am.allocate(Collections.emptyList(), Collections.emptyList()).getAllocatedContainers();
        }
        while (!app.isAppRotatingCryptoMaterial()) {
            TimeUnit.MILLISECONDS.sleep(500L);
        }
        MockNM nm2 = new MockNM("127.0.0.2:1234", 2048, rm.getResourceTrackerService());
        nm2.registerNode();
        Assert.assertTrue((boolean)app.isAppRotatingCryptoMaterial());
        am.allocate("127.0.0.2", 512, 1, Collections.emptyList());
        NodeHeartbeatResponse nmResponse = nm2.nodeHeartbeat(true);
        Assert.assertTrue((boolean)nmResponse.getUpdatedCryptoForApps().isEmpty());
        allocatedContainers = am.allocate(Collections.emptyList(), Collections.emptyList()).getAllocatedContainers();
        while (allocatedContainers.size() < 1) {
            nmResponse = nm2.nodeHeartbeat(true);
            Assert.assertTrue((boolean)nmResponse.getUpdatedCryptoForApps().isEmpty());
            TimeUnit.MILLISECONDS.sleep(200L);
            allocatedContainers = am.allocate(Collections.emptyList(), Collections.emptyList()).getAllocatedContainers();
        }
        Assert.assertEquals((long)1L, (long)allocatedContainers.size());
        Assert.assertEquals((Object)nm2.getNodeId(), (Object)((Container)allocatedContainers.get(0)).getNodeId());
        TimeUnit.MILLISECONDS.sleep(500L);
        RMNodeImpl rmNode2 = (RMNodeImpl)rm.getRMContext().getRMNodes().get(nm2.getNodeId());
        Assert.assertNotNull((Object)rmNode2);
        for (int wait = 0; rmNode2.getAppCryptoMaterialToUpdate().isEmpty() && wait < 10; ++wait) {
            TimeUnit.MILLISECONDS.sleep(300L);
        }
        Assert.assertFalse((boolean)rmNode2.getAppCryptoMaterialToUpdate().isEmpty());
        nmResponse = nm2.nodeHeartbeat(true);
        Assert.assertTrue((boolean)nmResponse.getUpdatedCryptoForApps().containsKey(app.getApplicationId()));
        rm.stop();
    }

    private RMApp createNewTestApplication(int appId) throws IOException {
        ApplicationId applicationID = MockApps.newAppID((int)appId);
        String user = MockApps.newUserName();
        String name = MockApps.newAppName();
        String queue = MockApps.newQueue();
        YarnScheduler scheduler = (YarnScheduler)Mockito.mock(YarnScheduler.class);
        ApplicationMasterService appMasterService = new ApplicationMasterService(this.rmContext, scheduler);
        ApplicationSubmissionContextPBImpl applicationSubmissionContext = new ApplicationSubmissionContextPBImpl();
        applicationSubmissionContext.setApplicationId(applicationID);
        RMAppImpl app = new RMAppImpl(applicationID, this.rmContext, this.conf, name, user, queue, (ApplicationSubmissionContext)applicationSubmissionContext, scheduler, appMasterService, System.currentTimeMillis(), "YARN", null, (ResourceRequest)Mockito.mock(ResourceRequest.class));
        this.rmContext.getRMApps().put(applicationID, app);
        return app;
    }

    private String getClasspathDir(Class klass) throws Exception {
        String file = klass.getName();
        file = file.replace('.', '/') + ".class";
        URL url = Thread.currentThread().getContextClassLoader().getResource(file);
        String baseDir = url.toURI().getPath();
        baseDir = baseDir.substring(0, baseDir.length() - file.length() - 1);
        return baseDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTrustStore(String filename, String password, String alias, Certificate cert) throws GeneralSecurityException, IOException {
        KeyStore ks = KeyStore.getInstance("JKS");
        ks.load(null, null);
        ks.setCertificateEntry(alias, cert);
        try (FileOutputStream out = new FileOutputStream(filename);){
            ks.store(out, password.toCharArray());
        }
    }

    private Configuration createSSLConfig(String keystore, String password, String keyPassword, String trustKS, String trustPass, String excludeCiphers) {
        SSLFactory.Mode mode = SSLFactory.Mode.SERVER;
        String trustPassword = trustPass;
        Configuration sslConf = new Configuration(false);
        if (keystore != null) {
            sslConf.set(FileBasedKeyStoresFactory.resolvePropertyName((SSLFactory.Mode)mode, (String)"ssl.{0}.keystore.location"), keystore);
        }
        if (password != null) {
            sslConf.set(FileBasedKeyStoresFactory.resolvePropertyName((SSLFactory.Mode)mode, (String)"ssl.{0}.keystore.password"), password);
        }
        if (keyPassword != null) {
            sslConf.set(FileBasedKeyStoresFactory.resolvePropertyName((SSLFactory.Mode)mode, (String)"ssl.{0}.keystore.keypassword"), keyPassword);
        }
        sslConf.set(FileBasedKeyStoresFactory.resolvePropertyName((SSLFactory.Mode)mode, (String)"ssl.{0}.keystore.reload.interval"), "1000");
        sslConf.set(FileBasedKeyStoresFactory.resolvePropertyName((SSLFactory.Mode)mode, (String)"ssl.{0}.keystore.reload.timeunit"), "MILLISECONDS");
        if (trustKS != null) {
            sslConf.set(FileBasedKeyStoresFactory.resolvePropertyName((SSLFactory.Mode)mode, (String)"ssl.{0}.truststore.location"), trustKS);
        }
        if (trustPassword != null) {
            sslConf.set(FileBasedKeyStoresFactory.resolvePropertyName((SSLFactory.Mode)mode, (String)"ssl.{0}.truststore.password"), trustPassword);
        }
        if (null != excludeCiphers && !excludeCiphers.isEmpty()) {
            sslConf.set(FileBasedKeyStoresFactory.resolvePropertyName((SSLFactory.Mode)mode, (String)"ssl.{0}.exclude.cipher.list"), excludeCiphers);
        }
        sslConf.set(FileBasedKeyStoresFactory.resolvePropertyName((SSLFactory.Mode)mode, (String)"ssl.{0}.truststore.reload.interval"), "1000");
        return sslConf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveConfig(File file, Configuration conf) throws IOException {
        try (FileWriter writer = new FileWriter(file);){
            conf.writeXml((Writer)writer);
        }
    }

    private class MockFailingRMAppCertificateManager
    extends RMAppCertificateManager {
        private int numberOfRenewalFailures;
        private boolean renewalFailed;
        private final Integer succeedAfterRetries;

        public MockFailingRMAppCertificateManager(Integer succeedAfterRetries) {
            super(TestRMAppCertificateManager.this.rmContext);
            this.numberOfRenewalFailures = 0;
            this.renewalFailed = false;
            this.succeedAfterRetries = succeedAfterRetries;
        }

        public int getNumberOfRenewalFailures() {
            return this.numberOfRenewalFailures;
        }

        public boolean hasRenewalFailed() {
            return this.renewalFailed;
        }

        public boolean isRPCTLSEnabled() {
            return true;
        }

        public void generateCertificate(ApplicationId appId, String appUser, Integer cryptoMaterialVersion) {
            this.getRmContext().getDispatcher().getEventHandler().handle((Event)new RMAppEvent(appId, RMAppEventType.KILL));
        }

        public Runnable createCertificateRenewerTask(ApplicationId appId, String appUser, Integer currentCryptoVersion) {
            return new MockFailingCertificateRenewer(appId, appUser, currentCryptoVersion, this.succeedAfterRetries);
        }

        public class MockFailingCertificateRenewer
        extends RMAppCertificateManager.CertificateRenewer {
            private final Integer succeedAfterRetries;

            public MockFailingCertificateRenewer(ApplicationId appId, String appUser, Integer currentCryptoVersion, Integer succeedAfterRetries) {
                super((RMAppCertificateManager)MockFailingRMAppCertificateManager.this, appId, appUser, currentCryptoVersion);
                this.succeedAfterRetries = succeedAfterRetries;
            }

            public void run() {
                try {
                    if (((ExponentialBackOff)this.backOff).getNumberOfRetries() < this.succeedAfterRetries) {
                        throw new Exception("Ooops something went wrong");
                    }
                    MockFailingRMAppCertificateManager.this.getRenewalTasks().remove(this.appId);
                    LOG.info((Object)("Renewed certificate for application " + this.appId));
                }
                catch (Exception ex) {
                    MockFailingRMAppCertificateManager.this.getRenewalTasks().remove(this.appId);
                    this.backOffTime = this.backOff.getBackOffInMillis();
                    if (this.backOffTime != -1L) {
                        MockFailingRMAppCertificateManager.this.numberOfRenewalFailures++;
                        LOG.warn((Object)("Failed to renew certificate for application " + this.appId + ". Retrying in " + this.backOffTime + " ms"));
                        ScheduledFuture<?> task = MockFailingRMAppCertificateManager.this.getScheduler().schedule((Runnable)((Object)this), this.backOffTime, TimeUnit.MILLISECONDS);
                        MockFailingRMAppCertificateManager.this.getRenewalTasks().put(this.appId, task);
                    }
                    LOG.error((Object)("Failed to renew certificate for application " + this.appId + " Failed more than 4 times, giving up"));
                    MockFailingRMAppCertificateManager.this.renewalFailed = true;
                }
            }
        }
    }

    private class MockRMAppCertificateManager
    extends RMAppCertificateManager {
        private final boolean loadTrustStore;
        private final String systemTMP;
        private long oldCertificateExpiration;
        private boolean renewalException;

        public MockRMAppCertificateManager(boolean loadTrustStore, RMContext rmContext) throws Exception {
            super(rmContext);
            this.renewalException = false;
            this.loadTrustStore = loadTrustStore;
            this.systemTMP = System.getProperty("java.io.tmpdir");
        }

        public KeyStore loadSystemTrustStore(Configuration conf) throws GeneralSecurityException, IOException {
            if (this.loadTrustStore) {
                return super.loadSystemTrustStore(conf);
            }
            KeyStore emptyTrustStore = KeyStore.getInstance("JKS");
            emptyTrustStore.load(null, null);
            return emptyTrustStore;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void generateCertificate(ApplicationId applicationId, String appUser, Integer cryptoMaterialVersion) {
            boolean exceptionThrown = false;
            ByteArrayInputStream bio = null;
            try {
                KeyPair keyPair = this.generateKeyPair();
                PKCS10CertificationRequest csr = this.generateCSR(applicationId, appUser, keyPair, cryptoMaterialVersion);
                Assert.assertEquals((Object)appUser, (Object)HopsUtil.extractCNFromSubject((String)csr.getSubject().toString()));
                Assert.assertEquals((Object)applicationId.toString(), (Object)HopsUtil.extractOFromSubject((String)csr.getSubject().toString()));
                Assert.assertEquals((Object)String.valueOf(cryptoMaterialVersion), (Object)HopsUtil.extractOUFromSubject((String)csr.getSubject().toString()));
                RMAppCertificateManager.CertificateBundle certificateBundle = this.sendCSRAndGetSigned(csr);
                certificateBundle.getCertificate().checkValidity();
                long expiration = certificateBundle.getCertificate().getNotAfter().getTime();
                long epochNow = Instant.now().toEpochMilli();
                Assert.assertTrue((expiration >= epochNow ? 1 : 0) != 0);
                Assert.assertNotNull((Object)certificateBundle.getIssuer());
                RMAppCertificateActions actor = this.getRmAppCertificateActions();
                if (actor instanceof TestingRMAppCertificateActions) {
                    X509Certificate caCert = ((TestingRMAppCertificateActions)actor).getCaCert();
                    certificateBundle.getCertificate().verify(caCert.getPublicKey(), "BC");
                }
                certificateBundle.getCertificate().verify(certificateBundle.getIssuer().getPublicKey(), "BC");
                RMAppCertificateManager.KeyStoresWrapper appKeystoreWrapper = this.createApplicationStores(certificateBundle, keyPair.getPrivate(), appUser, applicationId);
                X509Certificate extractedCert = (X509Certificate)appKeystoreWrapper.getKeystore().getCertificate(appUser);
                byte[] rawKeystore = appKeystoreWrapper.getRawKeyStore(RMAppCertificateManager.TYPE.KEYSTORE);
                Assert.assertNotNull((Object)rawKeystore);
                Assert.assertNotEquals((long)0L, (long)rawKeystore.length);
                File keystoreFile = Paths.get(this.systemTMP, appUser + "-" + applicationId.toString() + "_kstore.jks").toFile();
                Assert.assertFalse((boolean)keystoreFile.exists());
                char[] keyStorePassword = appKeystoreWrapper.getKeyStorePassword();
                Assert.assertNotNull((Object)keyStorePassword);
                Assert.assertNotEquals((long)0L, (long)keyStorePassword.length);
                byte[] rawTrustStore = appKeystoreWrapper.getRawKeyStore(RMAppCertificateManager.TYPE.TRUSTSTORE);
                File trustStoreFile = Paths.get(this.systemTMP, appUser + "-" + applicationId.toString() + "_tstore.jks").toFile();
                Assert.assertFalse((boolean)trustStoreFile.exists());
                char[] trustStorePassword = appKeystoreWrapper.getTrustStorePassword();
                Assert.assertNotNull((Object)trustStorePassword);
                Assert.assertNotEquals((long)0L, (long)trustStorePassword.length);
                this.verifyContentOfAppTrustStore(rawTrustStore, trustStorePassword, appUser, applicationId);
                if (actor instanceof TestingRMAppCertificateActions) {
                    X509Certificate caCert = ((TestingRMAppCertificateActions)actor).getCaCert();
                    extractedCert.verify(caCert.getPublicKey(), "BC");
                }
                Assert.assertEquals((Object)appUser, (Object)HopsUtil.extractCNFromSubject((String)extractedCert.getSubjectX500Principal().getName()));
                Assert.assertEquals((Object)applicationId.toString(), (Object)HopsUtil.extractOFromSubject((String)extractedCert.getSubjectX500Principal().getName()));
                Assert.assertEquals((Object)String.valueOf(cryptoMaterialVersion), (Object)HopsUtil.extractOUFromSubject((String)extractedCert.getSubjectX500Principal().getName()));
                RMAppCertificateGeneratedEvent startEvent = new RMAppCertificateGeneratedEvent(applicationId, rawKeystore, keyStorePassword, rawTrustStore, trustStorePassword, expiration, RMAppEventType.CERTS_GENERATED);
                this.getRmContext().getDispatcher().getEventHandler().handle((Event)startEvent);
            }
            catch (Exception ex) {
                LOG.error((Object)ex, (Throwable)ex);
                exceptionThrown = true;
            }
            finally {
                if (bio != null) {
                    try {
                        bio.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            Assert.assertFalse((boolean)exceptionThrown);
        }

        public void revokeCertificate(ApplicationId appId, String applicationUser, Integer cryptoMaterialVersion) {
            try {
                this.deregisterFromCertificateRenewer(appId);
                this.putToQueue(appId, applicationUser, cryptoMaterialVersion);
                this.waitForQueueToDrain();
            }
            catch (InterruptedException ex) {
                LOG.error((Object)ex, (Throwable)ex);
                Assert.fail((String)"Exception should not be thrown here");
            }
        }

        public boolean isRPCTLSEnabled() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void verifyContentOfAppTrustStore(byte[] appTrustStore, char[] password, String appUser, ApplicationId appId) throws GeneralSecurityException, IOException {
            File trustStoreFile = Paths.get(this.systemTMP, appUser + "-" + appId.toString() + "_tstore.jks").toFile();
            boolean certificateMissing = false;
            try {
                KeyStore systemTrustStore = this.loadSystemTrustStore(TestRMAppCertificateManager.this.conf);
                FileUtils.writeByteArrayToFile((File)trustStoreFile, (byte[])appTrustStore, (boolean)false);
                KeyStore ts = KeyStore.getInstance("JKS");
                try (FileInputStream fis = new FileInputStream(trustStoreFile);){
                    ts.load(fis, password);
                }
                Enumeration<String> sysAliases = systemTrustStore.aliases();
                while (sysAliases.hasMoreElements()) {
                    String alias = sysAliases.nextElement();
                    X509Certificate appCert = (X509Certificate)ts.getCertificate(alias);
                    if (appCert == null) {
                        certificateMissing = true;
                    } else {
                        X509Certificate sysCert = (X509Certificate)systemTrustStore.getCertificate(alias);
                        if (Arrays.equals(sysCert.getSignature(), appCert.getSignature())) continue;
                        certificateMissing = true;
                    }
                    break;
                }
            }
            finally {
                FileUtils.deleteQuietly((File)trustStoreFile);
                Assert.assertFalse((boolean)certificateMissing);
            }
        }

        public void setOldCertificateExpiration(long oldCertificateExpiration) {
            this.oldCertificateExpiration = oldCertificateExpiration;
        }

        public Runnable createCertificateRenewerTask(ApplicationId appId, String appuser, Integer currentCryptoVersion) {
            return new MockCertificateRenewer(appId, appuser, currentCryptoVersion, 1L);
        }

        public boolean getRenewalException() {
            return this.renewalException;
        }

        public class MockCertificateRenewer
        extends RMAppCertificateManager.CertificateRenewer {
            private final long oldCertificateExpiration;

            public MockCertificateRenewer(ApplicationId appId, String appUser, Integer currentCryptoVersion, long oldCertificateExpiration) {
                super((RMAppCertificateManager)MockRMAppCertificateManager.this, appId, appUser, currentCryptoVersion);
                this.oldCertificateExpiration = oldCertificateExpiration;
            }

            public void run() {
                try {
                    RMAppCertificateManager.CertificateBundle certificateBundle;
                    long newCertificateExpiration;
                    LOG.info((Object)("Renewing certificate for application " + this.appId));
                    KeyPair keyPair = MockRMAppCertificateManager.this.generateKeyPair();
                    int oldCryptoVersion = this.currentCryptoVersion;
                    this.currentCryptoVersion = this.currentCryptoVersion + 1;
                    PKCS10CertificationRequest csr = MockRMAppCertificateManager.this.generateCSR(this.appId, this.appUser, keyPair, this.currentCryptoVersion);
                    int newCryptoVersion = Integer.parseInt(HopsUtil.extractOUFromSubject((String)csr.getSubject().toString()));
                    if (++oldCryptoVersion != newCryptoVersion) {
                        LOG.error((Object)("Crypto version of new certificate is wrong: " + newCryptoVersion));
                        MockRMAppCertificateManager.this.renewalException = true;
                    }
                    if ((newCertificateExpiration = (certificateBundle = MockRMAppCertificateManager.this.sendCSRAndGetSigned(csr)).getCertificate().getNotAfter().getTime()) <= this.oldCertificateExpiration) {
                        LOG.error((Object)"New certificate expiration time is older than old certificate");
                        MockRMAppCertificateManager.this.renewalException = true;
                    }
                    RMAppCertificateManager.KeyStoresWrapper keyStoresWrapper = MockRMAppCertificateManager.this.createApplicationStores(certificateBundle, keyPair.getPrivate(), this.appUser, this.appId);
                    byte[] rawProtectedKeyStore = keyStoresWrapper.getRawKeyStore(RMAppCertificateManager.TYPE.KEYSTORE);
                    byte[] rawTrustStore = keyStoresWrapper.getRawKeyStore(RMAppCertificateManager.TYPE.TRUSTSTORE);
                    MockRMAppCertificateManager.this.getRenewalTasks().remove(this.appId);
                    MockRMAppCertificateManager.this.getRmContext().getDispatcher().getEventHandler().handle((Event)new RMAppCertificateGeneratedEvent(this.appId, rawProtectedKeyStore, keyStoresWrapper.getKeyStorePassword(), rawTrustStore, keyStoresWrapper.getTrustStorePassword(), newCertificateExpiration, RMAppEventType.CERTS_RENEWED));
                    LOG.info((Object)("Renewed certificate for application " + this.appId));
                }
                catch (Exception ex) {
                    LOG.error((Object)"Exception while renewing certificate. This should not have happened here", (Throwable)ex);
                    MockRMAppCertificateManager.this.renewalException = true;
                }
            }
        }
    }

    private class MyMockRM
    extends MockRM {
        public MyMockRM(Configuration conf) {
            super(conf);
        }

        @Override
        protected RMAppCertificateManager createRMAppCertificateManager() throws Exception {
            MockRMAppCertificateManager spyCertManager = (MockRMAppCertificateManager)((Object)Mockito.spy((Object)((Object)new MockRMAppCertificateManager(false, (RMContext)this.rmContext))));
            return spyCertManager;
        }
    }

    private class MyMockRM2
    extends MockRM {
        public MyMockRM2(Configuration conf) {
            super(conf);
        }

        protected RMAppManager createRMAppManager() {
            return new MyRMAppManager((RMContext)this.rmContext, (YarnScheduler)this.scheduler, this.masterService, this.applicationACLsManager, this.getConfig());
        }

        private class MyRMApp
        extends RMAppImpl {
            public MyRMApp(ApplicationId applicationId, RMContext rmContext, Configuration config, String name, String user, String queue, ApplicationSubmissionContext submissionContext, YarnScheduler scheduler, ApplicationMasterService masterService, long submitTime, String applicationType, Set<String> applicationTags, ResourceRequest amReq) throws IOException {
                super(applicationId, rmContext, config, name, user, queue, submissionContext, scheduler, masterService, submitTime, applicationType, applicationTags, amReq);
            }

            public void rmNodeHasUpdatedCryptoMaterial(NodeId nodeId) {
            }
        }

        private class MyRMAppManager
        extends RMAppManager {
            public MyRMAppManager(RMContext context, YarnScheduler scheduler, ApplicationMasterService masterService, ApplicationACLsManager applicationACLsManager, Configuration conf) {
                super(context, scheduler, masterService, applicationACLsManager, conf);
            }

            protected RMApp createRMApp(ApplicationId applicationId, String user, ApplicationSubmissionContext submissionContext, long submitTime, ResourceRequest amReq) throws IOException {
                return new MyRMApp(applicationId, (RMContext)MyMockRM2.this.rmContext, MyMockRM2.this.getConfig(), submissionContext.getApplicationName(), user, submissionContext.getQueue(), submissionContext, (YarnScheduler)MyMockRM2.this.scheduler, MyMockRM2.this.masterService, submitTime, submissionContext.getApplicationType(), submissionContext.getApplicationTags(), amReq);
            }
        }
    }

    private class MockRMAppEventHandler
    implements EventHandler<RMAppEvent> {
        private final RMAppEventType expectedEventType;
        private boolean assertionFailure;

        private MockRMAppEventHandler(RMAppEventType expectedEventType) {
            this.expectedEventType = expectedEventType;
            this.assertionFailure = false;
        }

        public void handle(RMAppEvent event) {
            if (event == null) {
                this.assertionFailure = true;
            } else if (!this.expectedEventType.equals((Object)event.getType())) {
                this.assertionFailure = true;
            } else if (((RMAppEventType)event.getType()).equals((Object)RMAppEventType.CERTS_GENERATED) && !(event instanceof RMAppCertificateGeneratedEvent)) {
                this.assertionFailure = true;
            }
        }

        private void verifyEvent() {
            Assert.assertFalse((boolean)this.assertionFailure);
        }
    }
}

