/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.security;

import com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMAppCertificateActions;

public final class RMAppCertificateActionsFactory {
    private static volatile RMAppCertificateActionsFactory _INSTANCE;
    private RMAppCertificateActions actor = null;

    private RMAppCertificateActionsFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RMAppCertificateActionsFactory getInstance() {
        if (_INSTANCE != null) return _INSTANCE;
        Class<RMAppCertificateActionsFactory> clazz = RMAppCertificateActionsFactory.class;
        synchronized (RMAppCertificateActionsFactory.class) {
            if (_INSTANCE != null) return _INSTANCE;
            _INSTANCE = new RMAppCertificateActionsFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _INSTANCE;
        }
    }

    public synchronized RMAppCertificateActions getActor(Configuration conf) throws Exception {
        if (this.actor != null) {
            return this.actor;
        }
        String actorClass = conf.get("hops.rm.certificate.actor.class", YarnConfiguration.HOPS_RM_CERTIFICATE_ACTOR_DEFAULT);
        Class clazz = conf.getClassByName(actorClass);
        this.actor = (RMAppCertificateActions)ReflectionUtils.newInstance((Class)clazz, (Configuration)conf);
        this.actor.init();
        return this.actor;
    }

    @VisibleForTesting
    public void clear() {
        this.actor = null;
    }

    @VisibleForTesting
    public void register(RMAppCertificateActions actor) {
        this.actor = actor;
    }
}

