/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.security;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.math3.util.Pair;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.ssl.FileBasedKeyStoresFactory;
import org.apache.hadoop.security.ssl.SSLFactory;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.util.BackOff;
import org.apache.hadoop.util.ExponentialBackOff;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppCertificateGeneratedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppImpl;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMAppCertificateActions;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMAppCertificateActionsFactory;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMAppCertificateManagerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMAppCertificateManagerEventType;
import org.apache.hadoop.yarn.server.security.CertificateLocalizationService;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequestBuilder;

public class RMAppCertificateManager
extends AbstractService
implements EventHandler<RMAppCertificateManagerEvent> {
    private static final Log LOG = LogFactory.getLog(RMAppCertificateManager.class);
    private static final String SECURITY_PROVIDER = "BC";
    private static final String KEY_ALGORITHM = "RSA";
    private static final String SIGNATURE_ALGORITHM = "SHA256withRSA";
    private static final int KEY_SIZE = 1024;
    private static final int REVOCATION_QUEUE_SIZE = 100;
    private static final Map<String, ChronoUnit> CHRONOUNITS = new HashMap<String, ChronoUnit>();
    private static final Pattern CONF_TIME_PATTERN;
    private final SecureRandom rng;
    private final String TMP = System.getProperty("java.io.tmpdir");
    private final BlockingQueue<CertificateRevocationEvent> revocationEvents;
    private RMContext rmContext;
    private Configuration conf;
    private EventHandler handler;
    private CertificateLocalizationService certificateLocalizationService;
    private KeyPairGenerator keyPairGenerator;
    private RMAppCertificateActions rmAppCertificateActions;
    private Thread revocationEventsHandler;
    private boolean isRPCTLSEnabled = false;
    private final int RENEWER_THREAD_POOL = 5;
    private final ScheduledExecutorService scheduler;
    private final Map<ApplicationId, ScheduledFuture> renewalTasks;
    private Long amountOfTimeToSubtractFromExpiration = 2L;
    private TemporalUnit renewalUnitOfTime = ChronoUnit.DAYS;
    private Long revocationMonitorInterval = 10L;
    private TemporalUnit revocationUnitOfInterval = ChronoUnit.HOURS;
    private Thread revocationMonitor;

    public RMAppCertificateManager(RMContext rmContext) {
        super(RMAppCertificateManager.class.getName());
        Security.addProvider((Provider)new BouncyCastleProvider());
        this.rmContext = rmContext;
        this.rng = new SecureRandom();
        this.revocationEvents = new ArrayBlockingQueue<CertificateRevocationEvent>(100);
        this.renewalTasks = new ConcurrentHashMap<ApplicationId, ScheduledFuture>();
        this.scheduler = Executors.newScheduledThreadPool(5, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("X509 app certificate renewal thread #%d").build());
    }

    protected void serviceInit(Configuration conf) throws Exception {
        LOG.debug((Object)"Initializing RMAppCertificateManager");
        this.conf = conf;
        this.handler = this.rmContext.getDispatcher().getEventHandler();
        this.certificateLocalizationService = this.rmContext.getCertificateLocalizationService();
        String delayConfiguration = conf.get("yarn.resourcemanager.certificate.expiration-safety-period", YarnConfiguration.DEFAULT_RM_APP_CERTIFICATE_RENEWER_DELAY);
        Pair<Long, TemporalUnit> delayIntervalUnit = this.parseInterval(delayConfiguration, "yarn.resourcemanager.certificate.expiration-safety-period");
        this.amountOfTimeToSubtractFromExpiration = (Long)delayIntervalUnit.getFirst();
        this.renewalUnitOfTime = (TemporalUnit)delayIntervalUnit.getSecond();
        String confMonitorInterval = conf.get("yarn.resourcemanager.certificate.revocation-monitor-interval", YarnConfiguration.DEFAULT_RM_APP_CERTIFICATE_REVOCATION_MONITOR_INTERVAL);
        Pair<Long, TemporalUnit> monitorIntervalUnit = this.parseInterval(confMonitorInterval, "yarn.resourcemanager.certificate.revocation-monitor-interval");
        this.revocationMonitorInterval = (Long)monitorIntervalUnit.getFirst();
        this.revocationUnitOfInterval = (TemporalUnit)monitorIntervalUnit.getSecond();
        this.rmAppCertificateActions = RMAppCertificateActionsFactory.getInstance().getActor(conf);
        this.keyPairGenerator = KeyPairGenerator.getInstance(KEY_ALGORITHM, SECURITY_PROVIDER);
        this.keyPairGenerator.initialize(1024);
        this.isRPCTLSEnabled = conf.getBoolean("ipc.server.ssl.enabled", false);
        super.serviceInit(conf);
    }

    private Pair<Long, TemporalUnit> parseInterval(String intervalFromConf, String confKey) {
        Matcher matcher = CONF_TIME_PATTERN.matcher(intervalFromConf);
        if (matcher.matches()) {
            Long interval = Long.parseLong(matcher.group(1));
            String unitStr = matcher.group(2);
            TemporalUnit unit = CHRONOUNITS.get(unitStr.toUpperCase());
            if (unit == null) {
                StringBuilder validUnits = new StringBuilder();
                for (String key : CHRONOUNITS.keySet()) {
                    validUnits.append(key).append(", ");
                }
                validUnits.append("\b\b");
                throw new IllegalArgumentException("Could not parse ChronoUnit: " + unitStr + ". Valid values are " + validUnits.toString());
            }
            return new Pair((Object)interval, (Object)unit);
        }
        throw new IllegalArgumentException("Could not parse value " + intervalFromConf + " of " + confKey);
    }

    protected void serviceStart() throws Exception {
        LOG.info((Object)"Starting RMAppCertificateManager");
        if (this.isRPCTLSEnabled()) {
            this.revocationEventsHandler = new RevocationEventsHandler();
            this.revocationEventsHandler.setDaemon(false);
            this.revocationEventsHandler.setName("RevocationEventsHandler");
            this.revocationEventsHandler.start();
            this.revocationMonitor = new CertificateRevocationMonitor();
            this.revocationMonitor.setDaemon(true);
            this.revocationMonitor.setName("CertificateRevocationMonitor");
            this.revocationMonitor.start();
        }
        super.serviceStart();
    }

    protected void serviceStop() throws Exception {
        LOG.info((Object)"Stopping RMAppCertificateManager");
        if (this.revocationMonitor != null) {
            this.revocationMonitor.interrupt();
        }
        if (this.revocationEventsHandler != null) {
            this.revocationEventsHandler.interrupt();
        }
        if (this.scheduler != null) {
            this.scheduler.shutdownNow();
        }
    }

    public void handle(RMAppCertificateManagerEvent event) {
        ApplicationId applicationId = event.getApplicationId();
        LOG.info((Object)("Processing event type: " + event.getType() + " for application: " + applicationId));
        if (((RMAppCertificateManagerEventType)event.getType()).equals((Object)RMAppCertificateManagerEventType.GENERATE_CERTIFICATE)) {
            this.generateCertificate(applicationId, event.getApplicationUser(), event.getCryptoMaterialVersion());
        } else if (((RMAppCertificateManagerEventType)event.getType()).equals((Object)RMAppCertificateManagerEventType.REVOKE_CERTIFICATE)) {
            this.revokeCertificate(applicationId, event.getApplicationUser(), event.getCryptoMaterialVersion());
        } else if (((RMAppCertificateManagerEventType)event.getType()).equals((Object)RMAppCertificateManagerEventType.REVOKE_CERTIFICATE_AFTER_ROTATION)) {
            this.revokeCertificate(applicationId, event.getApplicationUser(), event.getCryptoMaterialVersion(), true);
        } else if (((RMAppCertificateManagerEventType)event.getType()).equals((Object)RMAppCertificateManagerEventType.REVOKE_GENERATE_CERTIFICATE)) {
            this.revokeAndGenerateCertificates(applicationId, event.getApplicationUser(), event.getCryptoMaterialVersion());
        } else {
            LOG.warn((Object)("Unknown event type " + event.getType()));
        }
    }

    @VisibleForTesting
    public RMAppCertificateActions getRmAppCertificateActions() {
        return this.rmAppCertificateActions;
    }

    @VisibleForTesting
    protected RMContext getRmContext() {
        return this.rmContext;
    }

    @VisibleForTesting
    public Map<ApplicationId, ScheduledFuture> getRenewalTasks() {
        return this.renewalTasks;
    }

    public void registerWithCertificateRenewer(ApplicationId appId, String appUser, Integer currentCryptoVersion, Long expiration) {
        if (!this.isRPCTLSEnabled()) {
            return;
        }
        if (!this.renewalTasks.containsKey(appId)) {
            Instant now = Instant.now();
            Instant expirationInstant = Instant.ofEpochMilli(expiration);
            Instant delay = expirationInstant.minus(now.toEpochMilli(), ChronoUnit.MILLIS).minus(this.amountOfTimeToSubtractFromExpiration, this.renewalUnitOfTime);
            ScheduledFuture<?> renewTask = this.scheduler.schedule(this.createCertificateRenewerTask(appId, appUser, currentCryptoVersion), delay.toEpochMilli(), TimeUnit.MILLISECONDS);
            this.renewalTasks.put(appId, renewTask);
        }
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    protected Runnable createCertificateRenewerTask(ApplicationId appId, String appuser, Integer currentCryptoVersion) {
        return new CertificateRenewer(appId, appuser, currentCryptoVersion);
    }

    public void deregisterFromCertificateRenewer(ApplicationId appId) {
        if (!this.isRPCTLSEnabled()) {
            return;
        }
        ScheduledFuture task = this.renewalTasks.remove(appId);
        if (task != null) {
            task.cancel(true);
        }
    }

    @VisibleForTesting
    protected ScheduledExecutorService getScheduler() {
        return this.scheduler;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public void revokeAndGenerateCertificates(ApplicationId appId, String appUser, Integer cryptoMaterialVersion) {
        if (this.revokeInternal(RMAppCertificateManager.getCertificateIdentifier(appId, appUser, cryptoMaterialVersion))) {
            this.generateCertificate(appId, appUser, cryptoMaterialVersion);
        } else {
            this.handler.handle((Event)new RMAppEvent(appId, RMAppEventType.KILL, "Could not revoke previously generated certificate"));
        }
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public boolean isRPCTLSEnabled() {
        return this.isRPCTLSEnabled;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public void generateCertificate(ApplicationId appId, String appUser, Integer cryptoMaterialVersion) {
        try {
            if (this.isRPCTLSEnabled()) {
                KeyPair keyPair = this.generateKeyPair();
                PKCS10CertificationRequest csr = this.generateCSR(appId, appUser, keyPair, cryptoMaterialVersion);
                CertificateBundle certificateBundle = this.sendCSRAndGetSigned(csr);
                long expirationEpoch = certificateBundle.certificate.getNotAfter().getTime();
                KeyStoresWrapper keyStoresWrapper = this.createApplicationStores(certificateBundle, keyPair.getPrivate(), appUser, appId);
                byte[] rawProtectedKeyStore = keyStoresWrapper.getRawKeyStore(TYPE.KEYSTORE);
                byte[] rawTrustStore = keyStoresWrapper.getRawKeyStore(TYPE.TRUSTSTORE);
                this.rmContext.getCertificateLocalizationService().materializeCertificates(appUser, appId.toString(), appUser, ByteBuffer.wrap(rawProtectedKeyStore), String.valueOf(keyStoresWrapper.keyStorePassword), ByteBuffer.wrap(rawTrustStore), String.valueOf(keyStoresWrapper.trustStorePassword));
                this.handler.handle((Event)new RMAppCertificateGeneratedEvent(appId, rawProtectedKeyStore, keyStoresWrapper.keyStorePassword, rawTrustStore, keyStoresWrapper.trustStorePassword, expirationEpoch, RMAppEventType.CERTS_GENERATED));
            } else {
                this.handler.handle((Event)new RMAppEvent(appId, RMAppEventType.CERTS_GENERATED));
            }
        }
        catch (Exception ex) {
            LOG.error((Object)("Error while generating certificate for application " + appId), (Throwable)ex);
            this.handler.handle((Event)new RMAppEvent(appId, RMAppEventType.KILL, "Error while generating application certificate"));
        }
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    protected CertificateBundle sendCSRAndGetSigned(PKCS10CertificationRequest csr) throws URISyntaxException, IOException, GeneralSecurityException {
        return this.rmAppCertificateActions.sign(csr);
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    protected PKCS10CertificationRequest generateCSR(ApplicationId appId, String applicationUser, KeyPair keyPair, Integer cryptoMaterialVersion) throws OperatorCreationException {
        LOG.info((Object)("Generating certificate for application: " + appId));
        X500Name subject = this.createX500Subject(appId, applicationUser, cryptoMaterialVersion);
        return this.createCSR(subject, keyPair);
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public KeyStore loadSystemTrustStore(Configuration conf) throws GeneralSecurityException, IOException {
        String sslConfName = conf.get("hadoop.ssl.server.conf", "ssl-server.xml");
        Configuration sslConf = new Configuration();
        sslConf.addResource(sslConfName);
        String trustStoreLocation = sslConf.get(FileBasedKeyStoresFactory.resolvePropertyName((SSLFactory.Mode)SSLFactory.Mode.SERVER, (String)"ssl.{0}.truststore.location"));
        String trustStorePassword = sslConf.get(FileBasedKeyStoresFactory.resolvePropertyName((SSLFactory.Mode)SSLFactory.Mode.SERVER, (String)"ssl.{0}.truststore.password"));
        String trustStoreType = sslConf.get(FileBasedKeyStoresFactory.resolvePropertyName((SSLFactory.Mode)SSLFactory.Mode.SERVER, (String)"ssl.{0}.truststore.type"), "jks");
        KeyStore trustStore = KeyStore.getInstance(trustStoreType);
        try (FileInputStream fis = new FileInputStream(trustStoreLocation);){
            trustStore.load(fis, trustStorePassword.toCharArray());
        }
        return trustStore;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    protected KeyStoresWrapper createApplicationStores(CertificateBundle certificateBundle, PrivateKey privateKey, String appUser, ApplicationId appId) throws GeneralSecurityException, IOException {
        char[] password = this.generateRandomPassword();
        KeyStore keyStore = KeyStore.getInstance("JKS");
        keyStore.load(null, null);
        Certificate[] chain = new X509Certificate[]{certificateBundle.certificate, certificateBundle.issuer};
        keyStore.setKeyEntry(appUser, privateKey, password, chain);
        KeyStore systemTrustStore = this.loadSystemTrustStore(this.conf);
        KeyStore appTrustStore = KeyStore.getInstance("JKS");
        appTrustStore.load(null, null);
        Enumeration<String> aliases = systemTrustStore.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            X509Certificate cert = (X509Certificate)systemTrustStore.getCertificate(alias);
            appTrustStore.setCertificateEntry(alias, cert);
        }
        return new KeyStoresWrapper(keyStore, password, appTrustStore, password, appUser, appId);
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    protected KeyPair generateKeyPair() {
        return this.keyPairGenerator.genKeyPair();
    }

    public char[] generateRandomPassword() {
        return RandomStringUtils.random((int)20, (int)0, (int)0, (boolean)true, (boolean)true, null, (Random)this.rng).toCharArray();
    }

    private X500Name createX500Subject(ApplicationId appId, String applicationUser, Integer cryptoMaterialVersion) {
        if (appId == null || applicationUser == null) {
            throw new IllegalArgumentException("ApplicationID and application user cannot be null");
        }
        X500NameBuilder x500NameBuilder = new X500NameBuilder(BCStyle.INSTANCE);
        x500NameBuilder.addRDN(BCStyle.CN, applicationUser);
        x500NameBuilder.addRDN(BCStyle.O, appId.toString());
        x500NameBuilder.addRDN(BCStyle.OU, cryptoMaterialVersion.toString());
        return x500NameBuilder.build();
    }

    private PKCS10CertificationRequest createCSR(X500Name subject, KeyPair keyPair) throws OperatorCreationException {
        JcaPKCS10CertificationRequestBuilder csrBuilder = new JcaPKCS10CertificationRequestBuilder(subject, keyPair.getPublic());
        return csrBuilder.build(new JcaContentSignerBuilder(SIGNATURE_ALGORITHM).setProvider(SECURITY_PROVIDER).build(keyPair.getPrivate()));
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public void revokeCertificate(ApplicationId appId, String applicationUser, Integer cryptoMaterialVersion) {
        this.revokeCertificate(appId, applicationUser, cryptoMaterialVersion, false);
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public void revokeCertificate(ApplicationId appId, String applicationUser, Integer cryptoMaterialVersion, boolean isFromRenewal) {
        if (this.isRPCTLSEnabled()) {
            LOG.info((Object)("Revoking certificate for application: " + appId + " with version " + cryptoMaterialVersion));
            try {
                if (!isFromRenewal) {
                    this.deregisterFromCertificateRenewer(appId);
                    if (this.certificateLocalizationService != null) {
                        this.certificateLocalizationService.removeMaterial(applicationUser, appId.toString());
                    }
                }
                this.putToQueue(appId, applicationUser, cryptoMaterialVersion);
            }
            catch (InterruptedException ex) {
                LOG.warn((Object)("Could not remove material for user " + applicationUser + " and application " + appId), (Throwable)ex);
            }
        }
    }

    public void revokeCertificateSynchronously(ApplicationId appId, String applicationUser, Integer cryptoMaterialVersion) {
        if (this.isRPCTLSEnabled()) {
            LOG.info((Object)("Revoking certificate for application: " + appId + " with version " + cryptoMaterialVersion));
            this.revokeInternal(RMAppCertificateManager.getCertificateIdentifier(appId, applicationUser, cryptoMaterialVersion));
        }
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    protected void putToQueue(ApplicationId appId, String applicationUser, Integer cryptoMaterialVersion) throws InterruptedException {
        this.revocationEvents.put(new CertificateRevocationEvent(RMAppCertificateManager.getCertificateIdentifier(appId, applicationUser, cryptoMaterialVersion)));
    }

    @VisibleForTesting
    protected void waitForQueueToDrain() throws InterruptedException {
        while (this.revocationEvents.peek() != null) {
            TimeUnit.MILLISECONDS.sleep(10L);
        }
    }

    private boolean revokeInternal(String certificateIdentifier) {
        if (this.isRPCTLSEnabled()) {
            try {
                this.rmAppCertificateActions.revoke(certificateIdentifier);
                return true;
            }
            catch (IOException | URISyntaxException | GeneralSecurityException ex) {
                LOG.error((Object)("Could not revoke certificate " + certificateIdentifier), (Throwable)ex);
                return false;
            }
        }
        return true;
    }

    public static String getCertificateIdentifier(ApplicationId appId, String user, Integer cryptoMaterialVersion) {
        return user + "__" + appId.toString() + "__" + cryptoMaterialVersion;
    }

    static {
        CHRONOUNITS.put("MS", ChronoUnit.MILLIS);
        CHRONOUNITS.put("S", ChronoUnit.SECONDS);
        CHRONOUNITS.put("M", ChronoUnit.MINUTES);
        CHRONOUNITS.put("H", ChronoUnit.HOURS);
        CHRONOUNITS.put("D", ChronoUnit.DAYS);
        CONF_TIME_PATTERN = Pattern.compile("(^[0-9]+)(\\p{Alpha}+)");
    }

    private class CertificateRevocationMonitor
    extends Thread {
        private final Map<ChronoUnit, TimeUnit> CHRONO_MAPPING = new HashMap<ChronoUnit, TimeUnit>();
        private final TimeUnit intervalForSleep;

        private CertificateRevocationMonitor() {
            this.CHRONO_MAPPING.put(ChronoUnit.MILLIS, TimeUnit.MILLISECONDS);
            this.CHRONO_MAPPING.put(ChronoUnit.SECONDS, TimeUnit.SECONDS);
            this.CHRONO_MAPPING.put(ChronoUnit.MINUTES, TimeUnit.MINUTES);
            this.CHRONO_MAPPING.put(ChronoUnit.HOURS, TimeUnit.HOURS);
            this.CHRONO_MAPPING.put(ChronoUnit.DAYS, TimeUnit.DAYS);
            this.intervalForSleep = this.CHRONO_MAPPING.get(RMAppCertificateManager.this.revocationUnitOfInterval);
        }

        @Override
        public void run() {
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    Instant now = Instant.now();
                    for (Map.Entry entry : RMAppCertificateManager.this.rmContext.getRMApps().entrySet()) {
                        RMApp app = (RMApp)entry.getValue();
                        if (!app.isAppRotatingCryptoMaterial() || !Instant.ofEpochMilli(app.getMaterialRotationStartTime()).minus(RMAppCertificateManager.this.revocationMonitorInterval, RMAppCertificateManager.this.revocationUnitOfInterval).isBefore(now)) continue;
                        Integer versionToRevoke = app.getCryptoMaterialVersion() - 1;
                        LOG.debug((Object)("Revoking certificate for app " + entry.getKey() + " with version " + versionToRevoke));
                        RMAppCertificateManager.this.putToQueue(app.getApplicationId(), app.getUser(), versionToRevoke);
                        ((RMAppImpl)app).resetCryptoRotationMetrics();
                    }
                    this.intervalForSleep.sleep(RMAppCertificateManager.this.revocationMonitorInterval);
                }
                catch (InterruptedException ex) {
                    LOG.info((Object)"Certificate revocation monitor stopping");
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    private class RevocationEventsHandler
    extends Thread {
        private RevocationEventsHandler() {
        }

        private void drain() {
            ArrayList events = new ArrayList(RMAppCertificateManager.this.revocationEvents.size());
            RMAppCertificateManager.this.revocationEvents.drainTo(events);
            for (CertificateRevocationEvent event : events) {
                RMAppCertificateManager.this.revokeInternal(event.identifier);
            }
        }

        @Override
        public void run() {
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    CertificateRevocationEvent event = (CertificateRevocationEvent)RMAppCertificateManager.this.revocationEvents.take();
                    RMAppCertificateManager.this.revokeInternal(event.identifier);
                }
                catch (InterruptedException ex) {
                    LOG.info((Object)"RevocationEventsHandler interrupted. Exiting...");
                    this.drain();
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    private class CertificateRevocationEvent {
        private final String identifier;

        private CertificateRevocationEvent(String identifier) {
            this.identifier = identifier;
        }
    }

    protected static enum TYPE {
        KEYSTORE,
        TRUSTSTORE;

    }

    protected class KeyStoresWrapper {
        private final KeyStore keystore;
        private final char[] keyStorePassword;
        private final KeyStore trustStore;
        private final char[] trustStorePassword;
        private final String appUser;
        private final ApplicationId appId;

        private KeyStoresWrapper(KeyStore keyStore, char[] keyStorePassword, KeyStore trustStore, char[] trustStorePassword, String appUser, ApplicationId appId) {
            this.keystore = keyStore;
            this.keyStorePassword = keyStorePassword;
            this.trustStore = trustStore;
            this.trustStorePassword = trustStorePassword;
            this.appUser = appUser;
            this.appId = appId;
        }

        protected KeyStore getKeystore() {
            return this.keystore;
        }

        protected char[] getKeyStorePassword() {
            return this.keyStorePassword;
        }

        protected KeyStore getTrustStore() {
            return this.trustStore;
        }

        protected char[] getTrustStorePassword() {
            return this.trustStorePassword;
        }

        protected byte[] getRawKeyStore(TYPE type) throws GeneralSecurityException, IOException {
            KeyStore keyStore;
            char[] password;
            File target;
            if (type.equals((Object)TYPE.KEYSTORE)) {
                target = Paths.get(RMAppCertificateManager.this.TMP, this.appUser + "-" + this.appId.toString() + "_kstore.jks").toFile();
                password = this.keyStorePassword;
                keyStore = this.keystore;
            } else {
                target = Paths.get(RMAppCertificateManager.this.TMP, this.appUser + "-" + this.appId.toString() + "_tstore.jks").toFile();
                password = this.trustStorePassword;
                keyStore = this.trustStore;
            }
            try (FileOutputStream fos = new FileOutputStream(target, false);){
                keyStore.store(fos, password);
            }
            byte[] rawKeyStore = Files.readAllBytes(target.toPath());
            FileUtils.deleteQuietly((File)target);
            return rawKeyStore;
        }
    }

    protected static class CertificateBundle {
        private final X509Certificate certificate;
        private final X509Certificate issuer;

        protected CertificateBundle(X509Certificate certificate, X509Certificate issuer) {
            this.certificate = certificate;
            this.issuer = issuer;
        }

        public X509Certificate getCertificate() {
            return this.certificate;
        }

        public X509Certificate getIssuer() {
            return this.issuer;
        }
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public class CertificateRenewer
    implements Runnable {
        protected final ApplicationId appId;
        protected final String appUser;
        protected final BackOff backOff;
        protected Integer currentCryptoVersion;
        protected long backOffTime = 0L;

        public CertificateRenewer(ApplicationId appId, String appUser, Integer currentCryptoVersion) {
            this.appId = appId;
            this.appUser = appUser;
            this.currentCryptoVersion = currentCryptoVersion;
            this.backOff = this.createBackOffPolicy();
        }

        private BackOff createBackOffPolicy() {
            return new ExponentialBackOff.Builder().setInitialIntervalMillis(200L).setMaximumIntervalMillis(5000L).setMultiplier(1.5).setMaximumRetries(4).build();
        }

        @Override
        public void run() {
            try {
                LOG.debug((Object)("Renewing certificate for application " + this.appId));
                KeyPair keyPair = RMAppCertificateManager.this.generateKeyPair();
                this.currentCryptoVersion = this.currentCryptoVersion + 1;
                PKCS10CertificationRequest csr = RMAppCertificateManager.this.generateCSR(this.appId, this.appUser, keyPair, this.currentCryptoVersion);
                CertificateBundle certificateBundle = RMAppCertificateManager.this.sendCSRAndGetSigned(csr);
                long expiration = certificateBundle.certificate.getNotAfter().getTime();
                KeyStoresWrapper keyStoresWrapper = RMAppCertificateManager.this.createApplicationStores(certificateBundle, keyPair.getPrivate(), this.appUser, this.appId);
                byte[] rawProtectedKeyStore = keyStoresWrapper.getRawKeyStore(TYPE.KEYSTORE);
                byte[] rawTrustStore = keyStoresWrapper.getRawKeyStore(TYPE.TRUSTSTORE);
                RMAppCertificateManager.this.rmContext.getCertificateLocalizationService().updateCryptoMaterial(this.appUser, this.appId.toString(), ByteBuffer.wrap(rawProtectedKeyStore), String.valueOf(keyStoresWrapper.keyStorePassword), ByteBuffer.wrap(rawTrustStore), String.valueOf(keyStoresWrapper.trustStorePassword));
                RMAppCertificateManager.this.renewalTasks.remove(this.appId);
                RMAppCertificateManager.this.handler.handle((Event)new RMAppCertificateGeneratedEvent(this.appId, rawProtectedKeyStore, keyStoresWrapper.keyStorePassword, rawTrustStore, keyStoresWrapper.trustStorePassword, expiration, RMAppEventType.CERTS_RENEWED));
                LOG.debug((Object)("Renewed certificate for application " + this.appId));
            }
            catch (Exception ex) {
                LOG.error((Object)ex, (Throwable)ex);
                RMAppCertificateManager.this.renewalTasks.remove(this.appId);
                this.backOffTime = this.backOff.getBackOffInMillis();
                if (this.backOffTime != -1L) {
                    LOG.warn((Object)("Failed to renew certificate for application " + this.appId + ". Retrying in " + this.backOffTime + " ms"));
                    ScheduledFuture<?> task = RMAppCertificateManager.this.scheduler.schedule(this, this.backOffTime, TimeUnit.MILLISECONDS);
                    RMAppCertificateManager.this.renewalTasks.put(this.appId, task);
                }
                LOG.error((Object)("Failed to renew certificate for application " + this.appId + ". Failed more than 4 times, giving up"));
            }
        }
    }
}

