/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import com.google.common.annotations.VisibleForTesting;
import io.hops.util.GroupMembershipService;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.yarn.LocalConfigurationProvider;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.conf.ConfigurationProvider;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.server.resourcemanager.AdminService;
import org.apache.hadoop.yarn.server.resourcemanager.ApplicationMasterService;
import org.apache.hadoop.yarn.server.resourcemanager.ClientRMService;
import org.apache.hadoop.yarn.server.resourcemanager.EmbeddedElector;
import org.apache.hadoop.yarn.server.resourcemanager.NodesListManager;
import org.apache.hadoop.yarn.server.resourcemanager.RMActiveServiceContext;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceTrackerService;
import org.apache.hadoop.yarn.server.resourcemanager.ahs.RMApplicationHistoryWriter;
import org.apache.hadoop.yarn.server.resourcemanager.metrics.SystemMetricsPublisher;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMDelegatedNodeLabelsUpdater;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.placement.PlacementManager;
import org.apache.hadoop.yarn.server.resourcemanager.quota.ContainersLogsService;
import org.apache.hadoop.yarn.server.resourcemanager.quota.QuotaService;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationSystem;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.AMLivelinessMonitor;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.ContainerAllocationExpirer;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.security.AMRMTokenSecretManager;
import org.apache.hadoop.yarn.server.resourcemanager.security.ClientToAMTokenSecretManagerInRM;
import org.apache.hadoop.yarn.server.resourcemanager.security.DelegationTokenRenewer;
import org.apache.hadoop.yarn.server.resourcemanager.security.NMTokenSecretManagerInRM;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMAppCertificateManager;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMContainerTokenSecretManager;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMDelegationTokenSecretManager;
import org.apache.hadoop.yarn.server.security.CertificateLocalizationService;
import org.apache.hadoop.yarn.util.Clock;

public class RMContextImpl
implements RMContext {
    private Dispatcher rmDispatcher;
    private boolean isHAEnabled;
    private HAServiceProtocol.HAServiceState haServiceState = HAServiceProtocol.HAServiceState.INITIALIZING;
    private AdminService adminService;
    private ConfigurationProvider configurationProvider;
    private RMActiveServiceContext activeServiceContext;
    private Configuration yarnConfiguration;
    private RMApplicationHistoryWriter rmApplicationHistoryWriter;
    private SystemMetricsPublisher systemMetricsPublisher;
    private EmbeddedElector elector;
    private final Object haServiceStateLock = new Object();
    private boolean isDistributed;
    private GroupMembershipService groupMembershipService;
    private CertificateLocalizationService certificateLocalizationService;
    private byte[] seed;
    private String userFolderHashAlgo = YarnConfiguration.DEFAULT_USER_FOLDER_ALGO;
    private RMAppCertificateManager rmAppCertificateManager;

    public RMContextImpl() {
    }

    @VisibleForTesting
    public RMContextImpl(Dispatcher rmDispatcher, ContainerAllocationExpirer containerAllocationExpirer, AMLivelinessMonitor amLivelinessMonitor, AMLivelinessMonitor amFinishingMonitor, DelegationTokenRenewer delegationTokenRenewer, AMRMTokenSecretManager appTokenSecretManager, RMContainerTokenSecretManager containerTokenSecretManager, NMTokenSecretManagerInRM nmTokenSecretManager, ClientToAMTokenSecretManagerInRM clientToAMTokenSecretManager, ResourceScheduler scheduler) {
        this();
        this.setDispatcher(rmDispatcher);
        this.setActiveServiceContext(new RMActiveServiceContext(rmDispatcher, containerAllocationExpirer, amLivelinessMonitor, amFinishingMonitor, delegationTokenRenewer, appTokenSecretManager, containerTokenSecretManager, nmTokenSecretManager, clientToAMTokenSecretManager, scheduler));
        LocalConfigurationProvider provider = new LocalConfigurationProvider();
        this.setConfigurationProvider((ConfigurationProvider)provider);
    }

    @VisibleForTesting
    public RMContextImpl(Dispatcher rmDispatcher, ContainerAllocationExpirer containerAllocationExpirer, AMLivelinessMonitor amLivelinessMonitor, AMLivelinessMonitor amFinishingMonitor, DelegationTokenRenewer delegationTokenRenewer, AMRMTokenSecretManager appTokenSecretManager, RMContainerTokenSecretManager containerTokenSecretManager, NMTokenSecretManagerInRM nmTokenSecretManager, ClientToAMTokenSecretManagerInRM clientToAMTokenSecretManager) {
        this(rmDispatcher, containerAllocationExpirer, amLivelinessMonitor, amFinishingMonitor, delegationTokenRenewer, appTokenSecretManager, containerTokenSecretManager, nmTokenSecretManager, clientToAMTokenSecretManager, null);
    }

    @Override
    public Dispatcher getDispatcher() {
        return this.rmDispatcher;
    }

    @Override
    public void setLeaderElectorService(EmbeddedElector elector) {
        this.elector = elector;
    }

    @Override
    public EmbeddedElector getLeaderElectorService() {
        return this.elector;
    }

    @Override
    public RMStateStore getStateStore() {
        return this.activeServiceContext.getStateStore();
    }

    @Override
    public ConcurrentMap<ApplicationId, RMApp> getRMApps() {
        return this.activeServiceContext.getRMApps();
    }

    @Override
    public ConcurrentMap<NodeId, RMNode> getRMNodes() {
        return this.activeServiceContext.getRMNodes();
    }

    @Override
    public ConcurrentMap<NodeId, RMNode> getInactiveRMNodes() {
        return this.activeServiceContext.getInactiveRMNodes();
    }

    @Override
    public ContainerAllocationExpirer getContainerAllocationExpirer() {
        return this.activeServiceContext.getContainerAllocationExpirer();
    }

    @Override
    public AMLivelinessMonitor getAMLivelinessMonitor() {
        return this.activeServiceContext.getAMLivelinessMonitor();
    }

    @Override
    public AMLivelinessMonitor getAMFinishingMonitor() {
        return this.activeServiceContext.getAMFinishingMonitor();
    }

    @Override
    public DelegationTokenRenewer getDelegationTokenRenewer() {
        return this.activeServiceContext.getDelegationTokenRenewer();
    }

    @Override
    public AMRMTokenSecretManager getAMRMTokenSecretManager() {
        return this.activeServiceContext.getAMRMTokenSecretManager();
    }

    @Override
    public RMContainerTokenSecretManager getContainerTokenSecretManager() {
        return this.activeServiceContext.getContainerTokenSecretManager();
    }

    @Override
    public NMTokenSecretManagerInRM getNMTokenSecretManager() {
        return this.activeServiceContext.getNMTokenSecretManager();
    }

    @Override
    public ResourceScheduler getScheduler() {
        return this.activeServiceContext.getScheduler();
    }

    @Override
    public ContainersLogsService getContainersLogsService() {
        return this.activeServiceContext.getContainersLogsService();
    }

    @Override
    public QuotaService getQuotaService() {
        return this.activeServiceContext.getQuotaService();
    }

    @Override
    public ReservationSystem getReservationSystem() {
        return this.activeServiceContext.getReservationSystem();
    }

    @Override
    public NodesListManager getNodesListManager() {
        return this.activeServiceContext.getNodesListManager();
    }

    @Override
    public ClientToAMTokenSecretManagerInRM getClientToAMTokenSecretManager() {
        return this.activeServiceContext.getClientToAMTokenSecretManager();
    }

    @Override
    public AdminService getRMAdminService() {
        return this.adminService;
    }

    @VisibleForTesting
    public void setStateStore(RMStateStore store) {
        this.activeServiceContext.setStateStore(store);
    }

    @Override
    public ClientRMService getClientRMService() {
        return this.activeServiceContext.getClientRMService();
    }

    @Override
    public ApplicationMasterService getApplicationMasterService() {
        return this.activeServiceContext.getApplicationMasterService();
    }

    @Override
    public ResourceTrackerService getResourceTrackerService() {
        return this.activeServiceContext.getResourceTrackerService();
    }

    void setHAEnabled(boolean isHAEnabled) {
        this.isHAEnabled = isHAEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setHAServiceState(HAServiceProtocol.HAServiceState serviceState) {
        Object object = this.haServiceStateLock;
        synchronized (object) {
            this.haServiceState = serviceState;
        }
    }

    void setDispatcher(Dispatcher dispatcher) {
        this.rmDispatcher = dispatcher;
    }

    void setRMAdminService(AdminService adminService) {
        this.adminService = adminService;
    }

    @Override
    public void setClientRMService(ClientRMService clientRMService) {
        this.activeServiceContext.setClientRMService(clientRMService);
    }

    @Override
    public RMDelegationTokenSecretManager getRMDelegationTokenSecretManager() {
        return this.activeServiceContext.getRMDelegationTokenSecretManager();
    }

    @Override
    public void setRMDelegationTokenSecretManager(RMDelegationTokenSecretManager delegationTokenSecretManager) {
        this.activeServiceContext.setRMDelegationTokenSecretManager(delegationTokenSecretManager);
    }

    void setContainerAllocationExpirer(ContainerAllocationExpirer containerAllocationExpirer) {
        this.activeServiceContext.setContainerAllocationExpirer(containerAllocationExpirer);
    }

    void setAMLivelinessMonitor(AMLivelinessMonitor amLivelinessMonitor) {
        this.activeServiceContext.setAMLivelinessMonitor(amLivelinessMonitor);
    }

    void setAMFinishingMonitor(AMLivelinessMonitor amFinishingMonitor) {
        this.activeServiceContext.setAMFinishingMonitor(amFinishingMonitor);
    }

    void setContainerTokenSecretManager(RMContainerTokenSecretManager containerTokenSecretManager) {
        this.activeServiceContext.setContainerTokenSecretManager(containerTokenSecretManager);
    }

    void setNMTokenSecretManager(NMTokenSecretManagerInRM nmTokenSecretManager) {
        this.activeServiceContext.setNMTokenSecretManager(nmTokenSecretManager);
    }

    @VisibleForTesting
    public void setScheduler(ResourceScheduler scheduler) {
        this.activeServiceContext.setScheduler(scheduler);
    }

    void setContainersLogsService(ContainersLogsService containersLogsService) {
        this.activeServiceContext.setContainersLogsService(containersLogsService);
    }

    void setQuotaService(QuotaService quotaService) {
        this.activeServiceContext.setQuotaService(quotaService);
    }

    void setReservationSystem(ReservationSystem reservationSystem) {
        this.activeServiceContext.setReservationSystem(reservationSystem);
    }

    void setDelegationTokenRenewer(DelegationTokenRenewer delegationTokenRenewer) {
        this.activeServiceContext.setDelegationTokenRenewer(delegationTokenRenewer);
    }

    void setClientToAMTokenSecretManager(ClientToAMTokenSecretManagerInRM clientToAMTokenSecretManager) {
        this.activeServiceContext.setClientToAMTokenSecretManager(clientToAMTokenSecretManager);
    }

    void setAMRMTokenSecretManager(AMRMTokenSecretManager amRMTokenSecretManager) {
        this.activeServiceContext.setAMRMTokenSecretManager(amRMTokenSecretManager);
    }

    void setNodesListManager(NodesListManager nodesListManager) {
        this.activeServiceContext.setNodesListManager(nodesListManager);
    }

    void setApplicationMasterService(ApplicationMasterService applicationMasterService) {
        this.activeServiceContext.setApplicationMasterService(applicationMasterService);
    }

    void setResourceTrackerService(ResourceTrackerService resourceTrackerService) {
        this.activeServiceContext.setResourceTrackerService(resourceTrackerService);
    }

    @Override
    public boolean isHAEnabled() {
        return this.isHAEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HAServiceProtocol.HAServiceState getHAServiceState() {
        Object object = this.haServiceStateLock;
        synchronized (object) {
            return this.haServiceState;
        }
    }

    public void setWorkPreservingRecoveryEnabled(boolean enabled) {
        this.activeServiceContext.setWorkPreservingRecoveryEnabled(enabled);
    }

    @Override
    public boolean isWorkPreservingRecoveryEnabled() {
        return this.activeServiceContext.isWorkPreservingRecoveryEnabled();
    }

    @Override
    public RMApplicationHistoryWriter getRMApplicationHistoryWriter() {
        return this.rmApplicationHistoryWriter;
    }

    @Override
    public void setSystemMetricsPublisher(SystemMetricsPublisher systemMetricsPublisher) {
        this.systemMetricsPublisher = systemMetricsPublisher;
    }

    @Override
    public SystemMetricsPublisher getSystemMetricsPublisher() {
        return this.systemMetricsPublisher;
    }

    @Override
    public void setRMApplicationHistoryWriter(RMApplicationHistoryWriter rmApplicationHistoryWriter) {
        this.rmApplicationHistoryWriter = rmApplicationHistoryWriter;
    }

    @Override
    public ConfigurationProvider getConfigurationProvider() {
        return this.configurationProvider;
    }

    public void setConfigurationProvider(ConfigurationProvider configurationProvider) {
        this.configurationProvider = configurationProvider;
    }

    @Override
    public long getEpoch() {
        return this.activeServiceContext.getEpoch();
    }

    void setEpoch(long epoch) {
        this.activeServiceContext.setEpoch(epoch);
    }

    @Override
    public RMNodeLabelsManager getNodeLabelManager() {
        return this.activeServiceContext.getNodeLabelManager();
    }

    @Override
    public void setNodeLabelManager(RMNodeLabelsManager mgr) {
        this.activeServiceContext.setNodeLabelManager(mgr);
    }

    @Override
    public RMDelegatedNodeLabelsUpdater getRMDelegatedNodeLabelsUpdater() {
        return this.activeServiceContext.getRMDelegatedNodeLabelsUpdater();
    }

    @Override
    public void setRMDelegatedNodeLabelsUpdater(RMDelegatedNodeLabelsUpdater delegatedNodeLabelsUpdater) {
        this.activeServiceContext.setRMDelegatedNodeLabelsUpdater(delegatedNodeLabelsUpdater);
    }

    public void setSchedulerRecoveryStartAndWaitTime(long waitTime) {
        this.activeServiceContext.setSchedulerRecoveryStartAndWaitTime(waitTime);
    }

    @Override
    public boolean isSchedulerReadyForAllocatingContainers() {
        return this.activeServiceContext.isSchedulerReadyForAllocatingContainers();
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public void setSystemClock(Clock clock) {
        this.activeServiceContext.setSystemClock(clock);
    }

    @Override
    public ConcurrentMap<ApplicationId, ByteBuffer> getSystemCredentialsForApps() {
        return this.activeServiceContext.getSystemCredentialsForApps();
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public RMActiveServiceContext getActiveServiceContext() {
        return this.activeServiceContext;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    void setActiveServiceContext(RMActiveServiceContext activeServiceContext) {
        this.activeServiceContext = activeServiceContext;
    }

    @Override
    public Configuration getYarnConfiguration() {
        return this.yarnConfiguration;
    }

    public void setYarnConfiguration(Configuration yarnConfiguration) {
        this.yarnConfiguration = yarnConfiguration;
    }

    @Override
    public PlacementManager getQueuePlacementManager() {
        return this.activeServiceContext.getQueuePlacementManager();
    }

    @Override
    public void setQueuePlacementManager(PlacementManager placementMgr) {
        this.activeServiceContext.setQueuePlacementManager(placementMgr);
    }

    @Override
    public String getHAZookeeperConnectionState() {
        if (this.elector == null) {
            return "Could not find leader elector. Verify both HA and automatic failover are enabled.";
        }
        return this.elector.getZookeeperConnectionState();
    }

    public void setIsDistributed(boolean isDistributed) {
        this.isDistributed = isDistributed;
    }

    @Override
    public boolean isDistributed() {
        return this.isDistributed;
    }

    @Override
    public boolean isLeader() {
        if (this.groupMembershipService == null) {
            return true;
        }
        return this.groupMembershipService.isLeader();
    }

    public void setRMGroupMembershipService(GroupMembershipService groupMembershipService) {
        this.groupMembershipService = groupMembershipService;
    }

    @Override
    public GroupMembershipService getGroupMembershipService() {
        return this.groupMembershipService;
    }

    public void setCertificateLocalizationService(CertificateLocalizationService certificateLocalizationService) {
        this.certificateLocalizationService = certificateLocalizationService;
    }

    @Override
    public CertificateLocalizationService getCertificateLocalizationService() {
        return this.certificateLocalizationService;
    }

    @Override
    public byte[] getSeed() {
        return this.seed;
    }

    public void setSeed(byte[] seed) {
        this.seed = seed;
    }

    @Override
    public String getUserFolderHashAlgo() {
        return this.userFolderHashAlgo;
    }

    public void setUserFolderHashAlgo(String userFolderHashAlgo) {
        this.userFolderHashAlgo = userFolderHashAlgo;
    }

    @Override
    public RMAppCertificateManager getRMAppCertificateManager() {
        return this.rmAppCertificateManager;
    }

    @Override
    public void setRMAppCertificateManager(RMAppCertificateManager rmAppCertificateManager) {
        this.rmAppCertificateManager = rmAppCertificateManager;
    }
}

