/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import com.google.common.annotations.VisibleForTesting;
import io.hops.util.DBUtility;
import io.hops.util.GroupMembershipService;
import io.hops.util.RMStorageFactory;
import io.hops.util.RmStreamingProcessor;
import io.hops.util.RtStreamingProcessor;
import io.hops.util.StreamingReceiver;
import io.hops.util.YarnAPIStorageFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.security.PrivilegedExceptionAction;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.AuthInfo;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.RetryNTimes;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.http.lib.StaticUserWebFilter;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.source.JvmMetrics;
import org.apache.hadoop.security.AuthenticationFilterInitializer;
import org.apache.hadoop.security.Groups;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.ProxyUsers;
import org.apache.hadoop.security.ssl.CertificateLocalization;
import org.apache.hadoop.security.ssl.CertificateLocalizationCtx;
import org.apache.hadoop.security.ssl.RevocationListFetcherService;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenSecretManager;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.service.CompositeService;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.hadoop.util.JvmPauseMonitor;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.ShutdownHookManager;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.ZKUtil;
import org.apache.hadoop.yarn.YarnUncaughtExceptionHandler;
import org.apache.hadoop.yarn.api.ApplicationClientProtocol;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.conf.ConfigurationProvider;
import org.apache.hadoop.yarn.conf.ConfigurationProviderFactory;
import org.apache.hadoop.yarn.conf.HAUtil;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.AsyncDispatcher;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.resourcemanager.ActiveStandbyElectorBasedElectorService;
import org.apache.hadoop.yarn.server.resourcemanager.AdminService;
import org.apache.hadoop.yarn.server.resourcemanager.ApplicationMasterService;
import org.apache.hadoop.yarn.server.resourcemanager.ClientRMService;
import org.apache.hadoop.yarn.server.resourcemanager.ClusterMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.CuratorBasedElectorService;
import org.apache.hadoop.yarn.server.resourcemanager.EmbeddedElector;
import org.apache.hadoop.yarn.server.resourcemanager.NMLivelinessMonitor;
import org.apache.hadoop.yarn.server.resourcemanager.NodesListManager;
import org.apache.hadoop.yarn.server.resourcemanager.NodesListManagerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.RMActiveServiceContext;
import org.apache.hadoop.yarn.server.resourcemanager.RMAppManager;
import org.apache.hadoop.yarn.server.resourcemanager.RMAppManagerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.RMContextImpl;
import org.apache.hadoop.yarn.server.resourcemanager.RMFatalEvent;
import org.apache.hadoop.yarn.server.resourcemanager.RMFatalEventType;
import org.apache.hadoop.yarn.server.resourcemanager.RMNMInfo;
import org.apache.hadoop.yarn.server.resourcemanager.RMSecretManagerService;
import org.apache.hadoop.yarn.server.resourcemanager.RMServerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.RMZKUtils;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceTrackerService;
import org.apache.hadoop.yarn.server.resourcemanager.ahs.RMApplicationHistoryWriter;
import org.apache.hadoop.yarn.server.resourcemanager.amlauncher.AMLauncherEventType;
import org.apache.hadoop.yarn.server.resourcemanager.amlauncher.ApplicationMasterLauncher;
import org.apache.hadoop.yarn.server.resourcemanager.metrics.SystemMetricsPublisher;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.SchedulingEditPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.SchedulingMonitor;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMDelegatedNodeLabelsUpdater;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.quota.ContainersLogsService;
import org.apache.hadoop.yarn.server.resourcemanager.quota.PriceMultiplicatiorService;
import org.apache.hadoop.yarn.server.resourcemanager.quota.QuotaService;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.NullRMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStoreFactory;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.Recoverable;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.AbstractReservationSystem;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationSystem;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.AMLivelinessMonitor;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.ContainerAllocationExpirer;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeEventType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.PreemptableResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.security.DelegationTokenRenewer;
import org.apache.hadoop.yarn.server.resourcemanager.security.QueueACLsManager;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMAppCertificateManager;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMAppCertificateManagerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RMWebApp;
import org.apache.hadoop.yarn.server.security.ApplicationACLsManager;
import org.apache.hadoop.yarn.server.security.CertificateLocalizationService;
import org.apache.hadoop.yarn.server.security.http.RMAuthenticationFilter;
import org.apache.hadoop.yarn.server.security.http.RMAuthenticationFilterInitializer;
import org.apache.hadoop.yarn.server.webproxy.AppReportFetcher;
import org.apache.hadoop.yarn.server.webproxy.WebAppProxyServlet;
import org.apache.hadoop.yarn.webapp.WebApp;
import org.apache.hadoop.yarn.webapp.WebApps;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;
import org.apache.zookeeper.server.auth.DigestAuthenticationProvider;

public class ResourceManager
extends CompositeService
implements Recoverable {
    public static final int SHUTDOWN_HOOK_PRIORITY = 30;
    private static final Log LOG = LogFactory.getLog(ResourceManager.class);
    private static long clusterTimeStamp = System.currentTimeMillis();
    private Lock resourceTrackingServiceStartStopLock = new ReentrantLock(true);
    @VisibleForTesting
    protected RMContextImpl rmContext;
    private Dispatcher rmDispatcher;
    @VisibleForTesting
    protected AdminService adminService;
    protected RMSchedulerServices schedulerServices;
    protected RMSecretManagerService rmSecretManagerService;
    protected ResourceScheduler scheduler;
    protected QuotaService quotaService;
    protected ContainersLogsService containersLogsService;
    protected PriceMultiplicatiorService priceMultiplicatiorService;
    protected CertificateLocalizationService certificateLocalizationService;
    protected RevocationListFetcherService revocationListFetcherService;
    protected ReservationSystem reservationSystem;
    private ClientRMService clientRM;
    protected ApplicationMasterService masterService;
    protected NMLivelinessMonitor nmLivelinessMonitor;
    protected NodesListManager nodesListManager;
    protected RMAppManager rmAppManager;
    protected RMAppCertificateManager rmAppCertificateManager;
    protected ApplicationACLsManager applicationACLsManager;
    protected QueueACLsManager queueACLsManager;
    private WebApp webApp;
    private AppReportFetcher fetcher = null;
    protected ResourceTrackerService resourceTracker;
    private JvmPauseMonitor pauseMonitor;
    private boolean curatorEnabled = false;
    private CuratorFramework curator;
    private final String zkRootNodePassword = Long.toString(new SecureRandom().nextLong());
    private boolean recoveryEnabled;
    @VisibleForTesting
    protected String webAppAddress;
    private ConfigurationProvider configurationProvider = null;
    private Configuration conf;
    private UserGroupInformation rmLoginUGI;
    private ResourceTrackingServices resourceTrackingService;
    protected GroupMembershipService groupMembershipService;

    public ResourceManager() {
        super("ResourceManager");
    }

    public RMContext getRMContext() {
        return this.rmContext;
    }

    public static long getClusterTimeStamp() {
        return clusterTimeStamp;
    }

    @VisibleForTesting
    protected static void setClusterTimeStamp(long timestamp) {
        clusterTimeStamp = timestamp;
    }

    @VisibleForTesting
    Dispatcher getRmDispatcher() {
        return this.rmDispatcher;
    }

    protected void serviceInit(Configuration conf) throws Exception {
        this.conf = conf;
        this.rmContext = new RMContextImpl();
        this.rmContext.setIsDistributed(conf.getBoolean("yarn.client.failover-distributed", YarnConfiguration.DEFAULT_DISTRIBUTED_RM.booleanValue()));
        this.configurationProvider = ConfigurationProviderFactory.getConfigurationProvider((Configuration)conf);
        this.configurationProvider.init(this.conf);
        this.rmContext.setConfigurationProvider(this.configurationProvider);
        InputStream coreSiteXMLInputStream = this.configurationProvider.getConfigurationInputStream(this.conf, "core-site.xml");
        if (coreSiteXMLInputStream != null) {
            this.conf.addResource(coreSiteXMLInputStream, "core-site.xml");
        }
        Groups.getUserToGroupsMappingServiceWithLoadedConfiguration((Configuration)this.conf).refresh();
        RMServerUtils.processRMProxyUsersConf(conf);
        ProxyUsers.refreshSuperUserGroupsConfiguration((Configuration)this.conf);
        InputStream yarnSiteXMLInputStream = this.configurationProvider.getConfigurationInputStream(this.conf, "yarn-site.xml");
        if (yarnSiteXMLInputStream != null) {
            this.conf.addResource(yarnSiteXMLInputStream, "yarn-site.xml");
        }
        ResourceManager.validateConfigs(this.conf);
        this.createAndInitCRLFetcherService();
        this.rmContext.setHAEnabled(HAUtil.isHAEnabled((Configuration)this.conf));
        if (this.rmContext.isHAEnabled()) {
            HAUtil.verifyAndSetConfiguration((Configuration)this.conf);
            if (this.rmContext.isDistributed() || HAUtil.isAutomaticFailoverEnabled((Configuration)conf) && HAUtil.isHopsRMFailoverProxy((Configuration)conf)) {
                this.groupMembershipService = this.createGroupMembershipService();
                this.addService((Service)this.groupMembershipService);
                this.rmContext.setRMGroupMembershipService(this.groupMembershipService);
            }
        } else if (this.rmContext.isDistributed()) {
            this.groupMembershipService = this.createGroupMembershipService();
            this.addService((Service)this.groupMembershipService);
            this.rmContext.setRMGroupMembershipService(this.groupMembershipService);
        }
        this.rmLoginUGI = UserGroupInformation.getCurrentUser();
        try {
            this.doSecureLogin();
        }
        catch (IOException ie) {
            throw new YarnRuntimeException("Failed to login", (Throwable)ie);
        }
        this.rmDispatcher = this.setupDispatcher();
        this.addIfService(this.rmDispatcher);
        this.rmContext.setDispatcher(this.rmDispatcher);
        this.adminService = this.createAdminService();
        this.addService((Service)this.adminService);
        this.rmContext.setRMAdminService(this.adminService);
        if (this.rmContext.isHAEnabled() && HAUtil.isAutomaticFailoverEnabled((Configuration)conf) && HAUtil.isAutomaticFailoverEmbedded((Configuration)conf)) {
            EmbeddedElector elector = this.createEmbeddedElector();
            this.addIfService(elector);
            this.rmContext.setLeaderElectorService(elector);
        }
        this.rmContext.setYarnConfiguration(conf);
        byte[] seed = new byte[16];
        new Random().nextBytes(seed);
        this.rmContext.setSeed(seed);
        this.rmContext.setUserFolderHashAlgo(conf.get(YarnConfiguration.USER_FOLDER_ALGO, YarnConfiguration.DEFAULT_USER_FOLDER_ALGO));
        this.createAndInitSchedulerServices();
        this.webAppAddress = WebAppUtils.getWebAppBindURL((Configuration)this.conf, (String)"yarn.resourcemanager.bind-host", (String)WebAppUtils.getRMWebAppURLWithoutScheme((Configuration)this.conf));
        RMApplicationHistoryWriter rmApplicationHistoryWriter = this.createRMApplicationHistoryWriter();
        this.addService((Service)rmApplicationHistoryWriter);
        this.rmContext.setRMApplicationHistoryWriter(rmApplicationHistoryWriter);
        SystemMetricsPublisher systemMetricsPublisher = this.createSystemMetricsPublisher();
        this.addService((Service)systemMetricsPublisher);
        this.rmContext.setSystemMetricsPublisher(systemMetricsPublisher);
        this.createCertificateLocalizationService();
        super.serviceInit(this.conf);
    }

    protected EmbeddedElector createEmbeddedElector() throws Exception {
        AbstractService elector;
        this.curatorEnabled = this.conf.getBoolean("yarn.resourcemanager.ha.curator-leader-elector.enabled", false);
        if (this.curatorEnabled) {
            this.curator = this.createAndStartCurator(this.conf);
            elector = new CuratorBasedElectorService(this.rmContext, this);
        } else {
            elector = new ActiveStandbyElectorBasedElectorService(this.rmContext);
        }
        return elector;
    }

    public CuratorFramework createAndStartCurator(Configuration conf) throws Exception {
        String zkHostPort = conf.get("yarn.resourcemanager.zk-address");
        if (zkHostPort == null) {
            throw new YarnRuntimeException("yarn.resourcemanager.zk-address is not configured.");
        }
        int numRetries = conf.getInt("yarn.resourcemanager.zk-num-retries", 1000);
        int zkSessionTimeout = conf.getInt("yarn.resourcemanager.zk-timeout-ms", 10000);
        int zkRetryInterval = conf.getInt("yarn.resourcemanager.zk-retry-interval-ms", 1000);
        List<ZKUtil.ZKAuthInfo> zkAuths = RMZKUtils.getZKAuths(conf);
        ArrayList<AuthInfo> authInfos = new ArrayList<AuthInfo>();
        for (ZKUtil.ZKAuthInfo zkAuth : zkAuths) {
            authInfos.add(new AuthInfo(zkAuth.getScheme(), zkAuth.getAuth()));
        }
        if (HAUtil.isHAEnabled((Configuration)conf) && HAUtil.getConfValueForRMInstance((String)"yarn.resourcemanager.zk-state-store.root-node.acl", (Configuration)conf) == null) {
            String zkRootNodeUsername = HAUtil.getConfValueForRMInstance((String)"yarn.resourcemanager.address", (String)"0.0.0.0:8032", (Configuration)conf);
            byte[] defaultFencingAuth = (zkRootNodeUsername + ":" + this.zkRootNodePassword).getBytes(Charset.forName("UTF-8"));
            authInfos.add(new AuthInfo(new DigestAuthenticationProvider().getScheme(), defaultFencingAuth));
        }
        CuratorFramework client = CuratorFrameworkFactory.builder().connectString(zkHostPort).sessionTimeoutMs(zkSessionTimeout).retryPolicy((RetryPolicy)new RetryNTimes(numRetries, zkRetryInterval)).authorization(authInfos).build();
        client.start();
        return client;
    }

    public CuratorFramework getCurator() {
        return this.curator;
    }

    public String getZkRootNodePassword() {
        return this.zkRootNodePassword;
    }

    protected QueueACLsManager createQueueACLsManager(ResourceScheduler scheduler, Configuration conf) {
        return new QueueACLsManager(scheduler, conf);
    }

    @VisibleForTesting
    protected void setRMStateStore(RMStateStore rmStore) {
        rmStore.setRMDispatcher(this.rmDispatcher);
        rmStore.setResourceManager(this);
        this.rmContext.setStateStore(rmStore);
    }

    protected EventHandler<SchedulerEvent> createSchedulerEventDispatcher() {
        return new SchedulerEventDispatcher(this.scheduler);
    }

    protected Dispatcher createDispatcher() {
        return new AsyncDispatcher();
    }

    protected ResourceScheduler createScheduler() {
        String schedulerClassName = this.conf.get("yarn.resourcemanager.scheduler.class", "org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler");
        LOG.info((Object)("Using Scheduler: " + schedulerClassName));
        try {
            Class<?> schedulerClazz = Class.forName(schedulerClassName);
            if (ResourceScheduler.class.isAssignableFrom(schedulerClazz)) {
                return (ResourceScheduler)ReflectionUtils.newInstance(schedulerClazz, (Configuration)this.conf);
            }
            throw new YarnRuntimeException("Class: " + schedulerClassName + " not instance of " + ResourceScheduler.class.getCanonicalName());
        }
        catch (ClassNotFoundException e) {
            throw new YarnRuntimeException("Could not instantiate Scheduler: " + schedulerClassName, (Throwable)e);
        }
    }

    protected ReservationSystem createReservationSystem() {
        String reservationClassName = this.conf.get("yarn.resourcemanager.reservation-system.class", AbstractReservationSystem.getDefaultReservationSystem(this.scheduler));
        if (reservationClassName == null) {
            return null;
        }
        LOG.info((Object)("Using ReservationSystem: " + reservationClassName));
        try {
            Class<?> reservationClazz = Class.forName(reservationClassName);
            if (ReservationSystem.class.isAssignableFrom(reservationClazz)) {
                return (ReservationSystem)ReflectionUtils.newInstance(reservationClazz, (Configuration)this.conf);
            }
            throw new YarnRuntimeException("Class: " + reservationClassName + " not instance of " + ReservationSystem.class.getCanonicalName());
        }
        catch (ClassNotFoundException e) {
            throw new YarnRuntimeException("Could not instantiate ReservationSystem: " + reservationClassName, (Throwable)e);
        }
    }

    protected ApplicationMasterLauncher createAMLauncher() {
        return new ApplicationMasterLauncher(this.rmContext);
    }

    private NMLivelinessMonitor createNMLivelinessMonitor() {
        return new NMLivelinessMonitor(this.rmContext.getDispatcher());
    }

    protected AMLivelinessMonitor createAMLivelinessMonitor() {
        return new AMLivelinessMonitor(this.rmDispatcher);
    }

    protected RMNodeLabelsManager createNodeLabelManager() throws InstantiationException, IllegalAccessException {
        return new RMNodeLabelsManager();
    }

    protected DelegationTokenRenewer createDelegationTokenRenewer() {
        return new DelegationTokenRenewer();
    }

    protected RMAppManager createRMAppManager() {
        return new RMAppManager(this.rmContext, this.scheduler, this.masterService, this.applicationACLsManager, this.conf);
    }

    protected RMAppCertificateManager createRMAppCertificateManager() throws Exception {
        return new RMAppCertificateManager(this.rmContext);
    }

    protected RMApplicationHistoryWriter createRMApplicationHistoryWriter() {
        return new RMApplicationHistoryWriter();
    }

    protected SystemMetricsPublisher createSystemMetricsPublisher() {
        return new SystemMetricsPublisher();
    }

    protected static void validateConfigs(Configuration conf) {
        long heartbeatIntvl;
        int globalMaxAppAttempts = conf.getInt("yarn.resourcemanager.am.max-attempts", 2);
        if (globalMaxAppAttempts <= 0) {
            throw new YarnRuntimeException("Invalid global max attempts configuration, yarn.resourcemanager.am.max-attempts=" + globalMaxAppAttempts + ", it should be a positive integer.");
        }
        long expireIntvl = conf.getLong("yarn.nm.liveness-monitor.expiry-interval-ms", 600000L);
        if (expireIntvl < (heartbeatIntvl = conf.getLong("yarn.resourcemanager.nodemanagers.heartbeat-interval-ms", 1000L))) {
            throw new YarnRuntimeException("Nodemanager expiry interval should be no less than heartbeat interval, yarn.nm.liveness-monitor.expiry-interval-ms=" + expireIntvl + ", " + "yarn.resourcemanager.nodemanagers.heartbeat-interval-ms" + "=" + heartbeatIntvl);
        }
    }

    public void handleTransitionToStandBy() {
        if (this.rmContext.isHAEnabled() || this.rmContext.isDistributed()) {
            try {
                LOG.info((Object)"Transitioning RM to Standby mode");
                this.transitionToStandby(true);
                EmbeddedElector elector = this.rmContext.getLeaderElectorService();
                if (elector != null) {
                    elector.rejoinElection();
                }
            }
            catch (Exception e) {
                LOG.fatal((Object)"Failed to transition RM to Standby mode.", (Throwable)e);
                ExitUtil.terminate((int)1, (Throwable)e);
            }
        }
    }

    protected void startWepApp() {
        LOG.info((Object)"+");
        Configuration conf = this.getConfig();
        LOG.info((Object)"+");
        boolean enableCorsFilter = conf.getBoolean("yarn.resourcemanager.webapp.cross-origin.enabled", false);
        LOG.info((Object)"+");
        boolean useYarnAuthenticationFilter = conf.getBoolean("yarn.resourcemanager.webapp.delegation-token-auth-filter.enabled", true);
        LOG.info((Object)"+");
        String authPrefix = "hadoop.http.authentication.";
        String authTypeKey = authPrefix + "type";
        String filterInitializerConfKey = "hadoop.http.filter.initializers";
        String actualInitializers = "";
        LOG.info((Object)"+");
        Class[] initializersClasses = conf.getClasses(filterInitializerConfKey, new Class[0]);
        LOG.info((Object)"+");
        if (enableCorsFilter) {
            conf.setBoolean("hadoop.http.cross-origin.enabled", true);
        }
        LOG.info((Object)"+");
        boolean hasHadoopAuthFilterInitializer = false;
        boolean hasRMAuthFilterInitializer = false;
        if (initializersClasses != null) {
            for (Class initializer : initializersClasses) {
                if (initializer.getName().equals(AuthenticationFilterInitializer.class.getName())) {
                    hasHadoopAuthFilterInitializer = true;
                }
                if (!initializer.getName().equals(RMAuthenticationFilterInitializer.class.getName())) continue;
                hasRMAuthFilterInitializer = true;
            }
            if (UserGroupInformation.isSecurityEnabled() && useYarnAuthenticationFilter && hasHadoopAuthFilterInitializer && conf.get(authTypeKey, "").equals("kerberos")) {
                ArrayList<String> target = new ArrayList<String>();
                for (Class filterInitializer : initializersClasses) {
                    if (filterInitializer.getName().equals(AuthenticationFilterInitializer.class.getName())) {
                        if (hasRMAuthFilterInitializer) continue;
                        target.add(RMAuthenticationFilterInitializer.class.getName());
                        continue;
                    }
                    target.add(filterInitializer.getName());
                }
                actualInitializers = StringUtils.join((CharSequence)",", target);
                LOG.info((Object)"Using RM authentication filter(kerberos/delegation-token) for RM webapp authentication");
                RMAuthenticationFilter.setDelegationTokenSecretManager((AbstractDelegationTokenSecretManager)this.getClientRMService().rmDTSecretManager);
                conf.set(filterInitializerConfKey, actualInitializers);
            }
        }
        LOG.info((Object)"+");
        String initializers = conf.get(filterInitializerConfKey);
        if (!UserGroupInformation.isSecurityEnabled()) {
            if (initializersClasses == null || initializersClasses.length == 0) {
                conf.set(filterInitializerConfKey, RMAuthenticationFilterInitializer.class.getName());
                conf.set(authTypeKey, "simple");
            } else if (initializers.equals(StaticUserWebFilter.class.getName())) {
                conf.set(filterInitializerConfKey, RMAuthenticationFilterInitializer.class.getName() + "," + initializers);
                conf.set(authTypeKey, "simple");
            }
        }
        LOG.info((Object)"+");
        WebApps.Builder builder = WebApps.$for((String)"cluster", ApplicationMasterService.class, (Object)((Object)this.masterService), (String)"ws").with(conf).withHttpSpnegoPrincipalKey("yarn.resourcemanager.webapp.spnego-principal").withHttpSpnegoKeytabKey("yarn.resourcemanager.webapp.spnego-keytab-file").at(this.webAppAddress);
        String proxyHostAndPort = WebAppUtils.getProxyHostAndPort((Configuration)conf);
        if (WebAppUtils.getResolvedRMWebAppURLWithoutScheme((Configuration)conf).equals(proxyHostAndPort)) {
            this.fetcher = HAUtil.isHAEnabled((Configuration)conf) ? new AppReportFetcher(conf) : new AppReportFetcher(conf, (ApplicationClientProtocol)this.getClientRMService());
            builder.withServlet("proxy", "/proxy/*", WebAppProxyServlet.class);
            builder.withAttribute("AppUrlFetcher", (Object)this.fetcher);
            String[] proxyParts = proxyHostAndPort.split(":");
            builder.withAttribute("proxyHost", (Object)proxyParts[0]);
        }
        LOG.info((Object)"+");
        this.webApp = builder.start((WebApp)new RMWebApp(this));
        LOG.info((Object)"+");
    }

    protected void createAndInitSchedulerServices() throws Exception {
        this.schedulerServices = new RMSchedulerServices();
        this.schedulerServices.init(this.conf);
    }

    void createAndInitResourceTrackingServices() {
        this.resourceTrackingService = new ResourceTrackingServices(this);
        this.resourceTrackingService.init(this.conf);
    }

    void startSchedulerServices() throws Exception {
        if (this.schedulerServices != null) {
            clusterTimeStamp = System.currentTimeMillis();
            this.schedulerServices.start();
        }
    }

    void stopSchedulerServices() throws Exception {
        if (this.schedulerServices != null) {
            this.schedulerServices.stop();
            this.schedulerServices = null;
        }
    }

    void reinitialize(boolean initialize) throws Exception {
        ClusterMetrics.destroy();
        QueueMetrics.clearQueueMetrics();
        if (initialize) {
            this.resetDispatcher();
            this.createAndInitSchedulerServices();
            if (this.rmContext.isDistributed()) {
                this.resourceTrackingService.start();
            }
        }
    }

    @VisibleForTesting
    public boolean areSchedulerServicesRunning() {
        return this.schedulerServices != null && this.schedulerServices.isInState(Service.STATE.STARTED);
    }

    public synchronized void transitionToActive() throws Exception {
        this.resourceTrackingServiceStartStopLock.lock();
        LOG.info((Object)"locked resourceTrackingServiceStart");
        try {
            if (this.rmContext.getHAServiceState() == HAServiceProtocol.HAServiceState.ACTIVE) {
                LOG.info((Object)("Already in active state <" + ResourceManager.getBindAddress(this.conf).getPort() + ">"));
                return;
            }
            LOG.info((Object)("Transitioning to active state " + HAUtil.getRMHAId((Configuration)this.conf)));
            this.stopSchedulerServices();
            if (this.resourceTrackingService.isInState(Service.STATE.STARTED)) {
                this.resourceTrackingService.stop();
            }
            this.reinitialize(false);
            this.resetDispatcher();
            this.createAndInitSchedulerServices();
            this.rmLoginUGI.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    try {
                        ResourceManager.this.startSchedulerServices();
                        return null;
                    }
                    catch (Exception e) {
                        ResourceManager.this.reinitialize(true);
                        throw e;
                    }
                }
            });
            this.rmContext.setHAServiceState(HAServiceProtocol.HAServiceState.ACTIVE);
            LOG.info((Object)("Transitioned to active state " + HAUtil.getRMHAId((Configuration)this.conf)));
        }
        finally {
            LOG.info((Object)"unlocked resourceTrackingServiceStart");
            this.resourceTrackingServiceStartStopLock.unlock();
        }
    }

    public synchronized void transitionToStandby(boolean initialize) throws Exception {
        this.resourceTrackingServiceStartStopLock.lock();
        LOG.info((Object)"locked resourceTrackingServiceStart");
        try {
            if (this.rmContext.getHAServiceState() == HAServiceProtocol.HAServiceState.STANDBY) {
                LOG.info((Object)("Already in standby state <" + ResourceManager.getBindAddress(this.conf).getPort() + ">"));
                return;
            }
            LOG.info((Object)("Transitioning to standby state " + HAUtil.getRMHAId((Configuration)this.conf)));
            HAServiceProtocol.HAServiceState state = this.rmContext.getHAServiceState();
            LOG.info((Object)("Transitioning to standby state <" + ResourceManager.getBindAddress(this.conf).getPort() + "> " + state.toString()));
            this.rmContext.setHAServiceState(HAServiceProtocol.HAServiceState.STANDBY);
            if (state == HAServiceProtocol.HAServiceState.ACTIVE) {
                this.stopSchedulerServices();
                this.resourceTrackingService.stop();
                if ((this.rmContext.isHAEnabled() && HAUtil.isAutomaticFailoverEnabled((Configuration)this.conf) && HAUtil.isHopsRMFailoverProxy((Configuration)this.conf) || this.rmContext.isDistributed()) && this.rmContext.isLeader() && this.groupMembershipService != null) {
                    this.groupMembershipService.relinquishId();
                }
                this.reinitialize(initialize);
            }
            LOG.info((Object)("Transitioned to standby state " + HAUtil.getRMHAId((Configuration)this.conf)));
        }
        finally {
            LOG.info((Object)"unlocked resourceTrackingServiceStart");
            this.resourceTrackingServiceStartStopLock.unlock();
        }
    }

    protected void serviceStart() throws Exception {
        this.resourceTrackingServiceStartStopLock.lock();
        LOG.info((Object)"locked resourceTrackingServiceStart");
        try {
            this.startCRLFetcherService();
            if (this.rmContext.isHAEnabled() || this.rmContext.isDistributed()) {
                this.transitionToStandby(true);
                if (HAUtil.isAutomaticFailoverEnabled((Configuration)this.conf) && HAUtil.isHopsRMFailoverProxy((Configuration)this.conf) || this.rmContext.isDistributed()) {
                    LOG.info((Object)"start gms");
                    this.groupMembershipService.start();
                }
            } else {
                this.transitionToActive();
            }
            LOG.info((Object)"start webapp");
            this.startWepApp();
            if (this.getConfig().getBoolean("yarn.is.minicluster", false)) {
                int port = this.webApp.port();
                WebAppUtils.setRMWebAppPort((Configuration)this.conf, (int)port);
            }
            if (this.rmContext.isDistributed()) {
                this.resourceTrackingService.start();
            }
            LOG.info((Object)"start super");
            super.serviceStart();
        }
        finally {
            LOG.info((Object)"unlocked resourceTrackingServiceStart");
            this.resourceTrackingServiceStartStopLock.unlock();
        }
    }

    protected void doSecureLogin() throws IOException {
        InetSocketAddress socAddr = ResourceManager.getBindAddress(this.conf);
        SecurityUtil.login((Configuration)this.conf, (String)"yarn.resourcemanager.keytab", (String)"yarn.resourcemanager.principal", (String)socAddr.getHostName());
        if (UserGroupInformation.isSecurityEnabled()) {
            this.rmLoginUGI = UserGroupInformation.getLoginUser();
        }
    }

    protected void serviceStop() throws Exception {
        this.resourceTrackingServiceStartStopLock.lock();
        LOG.info((Object)"locked resourceTrackingServiceStart");
        try {
            if (this.webApp != null) {
                this.webApp.stop();
            }
            if (this.fetcher != null) {
                this.fetcher.stop();
            }
            if (this.configurationProvider != null) {
                this.configurationProvider.close();
            }
            if (this.resourceTrackingService != null) {
                this.resourceTrackingService.stop();
            }
            super.serviceStop();
            if (this.curator != null) {
                this.curator.close();
            }
            this.transitionToStandby(false);
            this.stopCRLFetcherService();
            this.rmContext.setHAServiceState(HAServiceProtocol.HAServiceState.STOPPING);
        }
        finally {
            LOG.info((Object)"unlocked resourceTrackingServiceStart");
            this.resourceTrackingServiceStartStopLock.unlock();
        }
    }

    protected ResourceTrackerService createResourceTrackerService() {
        return new ResourceTrackerService(this.rmContext, this.nodesListManager, this.nmLivelinessMonitor, this.rmContext.getContainerTokenSecretManager(), this.rmContext.getNMTokenSecretManager());
    }

    protected ClientRMService createClientRMService() {
        return new ClientRMService(this.rmContext, this.scheduler, this.rmAppManager, this.applicationACLsManager, this.queueACLsManager, this.rmContext.getRMDelegationTokenSecretManager());
    }

    protected ApplicationMasterService createApplicationMasterService() {
        return new ApplicationMasterService(this.rmContext, this.scheduler);
    }

    protected AdminService createAdminService() {
        return new AdminService(this, this.rmContext);
    }

    protected RMSecretManagerService createRMSecretManagerService() {
        return new RMSecretManagerService(this.conf, this.rmContext);
    }

    protected RMDelegatedNodeLabelsUpdater createRMDelegatedNodeLabelsUpdater() {
        if (this.conf.getBoolean("yarn.node-labels.enabled", false) && YarnConfiguration.isDelegatedCentralizedNodeLabelConfiguration((Configuration)this.conf)) {
            return new RMDelegatedNodeLabelsUpdater(this.rmContext);
        }
        return null;
    }

    protected GroupMembershipService createGroupMembershipService() {
        return new GroupMembershipService(this, this.rmContext);
    }

    private void createAndInitCRLFetcherService() {
        if (this.conf.getBoolean("ipc.server.ssl.enabled", false)) {
            if (this.conf.getBoolean("hops.crl.validation.enabled", false)) {
                LOG.info((Object)"Creating CertificateRevocationList Fetcher service");
                this.revocationListFetcherService = new RevocationListFetcherService();
                this.revocationListFetcherService.init(this.conf);
            } else {
                LOG.warn((Object)"RPC TLS is enabled but CRL validation is disabled");
            }
        }
    }

    private void startCRLFetcherService() {
        if (this.revocationListFetcherService != null) {
            this.revocationListFetcherService.start();
        }
    }

    private void stopCRLFetcherService() {
        if (this.revocationListFetcherService != null) {
            this.revocationListFetcherService.stop();
        }
    }

    private void createCertificateLocalizationService() {
        if (this.conf.getBoolean("ipc.server.ssl.enabled", false)) {
            boolean isHAEnabled = this.rmContext.isHAEnabled();
            this.certificateLocalizationService = new CertificateLocalizationService(CertificateLocalizationService.ServiceType.RM);
            CertificateLocalizationCtx.getInstance().setCertificateLocalization((CertificateLocalization)this.certificateLocalizationService);
            this.addService((Service)this.certificateLocalizationService);
            this.rmContext.setCertificateLocalizationService(this.certificateLocalizationService);
        }
    }

    @InterfaceAudience.Private
    public ClientRMService getClientRMService() {
        return this.clientRM;
    }

    @InterfaceAudience.Private
    public ResourceScheduler getResourceScheduler() {
        return this.scheduler;
    }

    @InterfaceAudience.Private
    public ResourceTrackerService getResourceTrackerService() {
        return this.resourceTracker;
    }

    @InterfaceAudience.Private
    public ApplicationMasterService getApplicationMasterService() {
        return this.masterService;
    }

    @InterfaceAudience.Private
    public ApplicationACLsManager getApplicationACLsManager() {
        return this.applicationACLsManager;
    }

    @InterfaceAudience.Private
    public QueueACLsManager getQueueACLsManager() {
        return this.queueACLsManager;
    }

    @InterfaceAudience.Private
    WebApp getWebapp() {
        return this.webApp;
    }

    @Override
    public void recover(RMStateStore.RMState state) throws Exception {
        this.rmContext.getRMDelegationTokenSecretManager().recover(state);
        this.rmContext.getAMRMTokenSecretManager().recover(state);
        if (this.reservationSystem != null) {
            this.reservationSystem.recover(state);
        }
        this.rmAppManager.recover(state);
        this.recoverSalt();
        this.setSchedulerRecoveryStartAndWaitTime(state, this.conf);
    }

    private void recoverSalt() throws IOException {
        byte[] seed = DBUtility.verifySalt(this.rmContext.getSeed());
        this.rmContext.setSeed(seed);
    }

    public static void main(String[] argv) {
        Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new YarnUncaughtExceptionHandler());
        StringUtils.startupShutdownMessage(ResourceManager.class, (String[])argv, (Log)LOG);
        try {
            YarnConfiguration conf = new YarnConfiguration();
            YarnAPIStorageFactory.setConfiguration((Configuration)conf);
            RMStorageFactory.setConfiguration((Configuration)conf);
            GenericOptionsParser hParser = new GenericOptionsParser((Configuration)conf, argv);
            argv = hParser.getRemainingArgs();
            if (argv.length >= 1) {
                if (argv[0].equals("-format-state-store")) {
                    ResourceManager.deleteRMStateStore((Configuration)conf);
                } else if (argv[0].equals("-remove-application-from-state-store") && argv.length == 2) {
                    ResourceManager.removeApplication((Configuration)conf, argv[1]);
                } else {
                    ResourceManager.printUsage(System.err);
                }
            } else {
                ResourceManager resourceManager = new ResourceManager();
                ShutdownHookManager.get().addShutdownHook((Runnable)new CompositeService.CompositeServiceShutdownHook((CompositeService)resourceManager), 30);
                resourceManager.init((Configuration)conf);
                resourceManager.start();
            }
        }
        catch (Throwable t) {
            LOG.fatal((Object)"Error starting ResourceManager", t);
            System.exit(-1);
        }
    }

    private Dispatcher setupDispatcher() {
        Dispatcher dispatcher = this.createDispatcher();
        dispatcher.register(RMFatalEventType.class, (EventHandler)new RMFatalEventDispatcher());
        return dispatcher;
    }

    private void resetDispatcher() {
        this.removeService((Service)this.rmDispatcher);
        ((Service)this.rmDispatcher).stop();
        Dispatcher dispatcher = this.setupDispatcher();
        ((Service)dispatcher).init(this.conf);
        ((Service)dispatcher).start();
        this.rmDispatcher = dispatcher;
        this.addIfService(this.rmDispatcher);
        this.rmContext.setDispatcher(this.rmDispatcher);
    }

    private void setSchedulerRecoveryStartAndWaitTime(RMStateStore.RMState state, Configuration conf) {
        if (!state.getApplicationState().isEmpty()) {
            long waitTime = conf.getLong("yarn.resourcemanager.work-preserving-recovery.scheduling-wait-ms", 10000L);
            this.rmContext.setSchedulerRecoveryStartAndWaitTime(waitTime);
        }
    }

    public static InetSocketAddress getBindAddress(Configuration conf) {
        return conf.getSocketAddr("yarn.resourcemanager.address", "0.0.0.0:8032", 8032);
    }

    private static void deleteRMStateStore(Configuration conf) throws Exception {
        RMStateStore rmStore = RMStateStoreFactory.getStore(conf);
        rmStore.init(conf);
        rmStore.start();
        try {
            LOG.info((Object)"Deleting ResourceManager state store...");
            rmStore.deleteStore();
            LOG.info((Object)"State store deleted");
        }
        finally {
            rmStore.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeApplication(Configuration conf, String applicationId) throws Exception {
        RMStateStore rmStore = RMStateStoreFactory.getStore(conf);
        rmStore.init(conf);
        rmStore.start();
        try {
            ApplicationId removeAppId = ApplicationId.fromString((String)applicationId);
            LOG.info((Object)("Deleting application " + removeAppId + " from state store"));
            rmStore.removeApplication(removeAppId);
            LOG.info((Object)"Application is deleted from state store");
        }
        finally {
            rmStore.stop();
        }
    }

    private static void printUsage(PrintStream out) {
        out.println("Usage: yarn resourcemanager [-format-state-store]");
        out.println("                            [-remove-application-from-state-store <appId>]\n");
    }

    @InterfaceAudience.Private
    public static final class NodeEventDispatcher
    implements EventHandler<RMNodeEvent> {
        private final RMContext rmContext;

        public NodeEventDispatcher(RMContext rmContext) {
            this.rmContext = rmContext;
        }

        public void handle(RMNodeEvent event) {
            NodeId nodeId = event.getNodeId();
            RMNode node = (RMNode)this.rmContext.getRMNodes().get(nodeId);
            if (node != null) {
                try {
                    ((EventHandler)node).handle((Event)event);
                }
                catch (Throwable t) {
                    LOG.error((Object)("Error in handling event type " + event.getType() + " for node " + nodeId), t);
                }
            }
        }
    }

    @InterfaceAudience.Private
    public static final class ApplicationAttemptEventDispatcher
    implements EventHandler<RMAppAttemptEvent> {
        private final RMContext rmContext;

        public ApplicationAttemptEventDispatcher(RMContext rmContext) {
            this.rmContext = rmContext;
        }

        public void handle(RMAppAttemptEvent event) {
            RMAppAttempt rmAppAttempt;
            ApplicationAttemptId appAttemptID = event.getApplicationAttemptId();
            ApplicationId appAttemptId = appAttemptID.getApplicationId();
            RMApp rmApp = (RMApp)this.rmContext.getRMApps().get(appAttemptId);
            if (rmApp != null && (rmAppAttempt = rmApp.getRMAppAttempt(appAttemptID)) != null) {
                try {
                    rmAppAttempt.handle((Event)event);
                }
                catch (Throwable t) {
                    LOG.error((Object)("Error in handling event type " + event.getType() + " for applicationAttempt " + appAttemptId), t);
                }
            }
        }
    }

    @InterfaceAudience.Private
    public static final class ApplicationEventDispatcher
    implements EventHandler<RMAppEvent> {
        private final RMContext rmContext;

        public ApplicationEventDispatcher(RMContext rmContext) {
            this.rmContext = rmContext;
        }

        public void handle(RMAppEvent event) {
            ApplicationId appID = event.getApplicationId();
            RMApp rmApp = (RMApp)this.rmContext.getRMApps().get(appID);
            if (rmApp != null) {
                try {
                    rmApp.handle((Event)event);
                }
                catch (Throwable t) {
                    LOG.error((Object)("Error in handling event type " + event.getType() + " for application " + appID), t);
                }
            }
        }
    }

    @InterfaceAudience.Private
    public static class RMFatalEventDispatcher
    implements EventHandler<RMFatalEvent> {
        public void handle(RMFatalEvent event) {
            LOG.fatal((Object)("Received a " + RMFatalEvent.class.getName() + " of type " + ((RMFatalEventType)event.getType()).name() + ". Cause:\n" + event.getCause()));
            ExitUtil.terminate((int)1, (String)event.getCause());
        }
    }

    @InterfaceAudience.Private
    public static class SchedulerEventDispatcher
    extends AbstractService
    implements EventHandler<SchedulerEvent> {
        private final ResourceScheduler scheduler;
        private final BlockingQueue<SchedulerEvent> eventQueue = new LinkedBlockingQueue<SchedulerEvent>();
        private volatile int lastEventQueueSizeLogged = 0;
        private final Thread eventProcessor;
        private volatile boolean stopped = false;
        private boolean shouldExitOnError = false;

        public SchedulerEventDispatcher(ResourceScheduler scheduler) {
            super(SchedulerEventDispatcher.class.getName());
            this.scheduler = scheduler;
            this.eventProcessor = new Thread(new EventProcessor());
            this.eventProcessor.setName("ResourceManager Event Processor");
        }

        protected void serviceInit(Configuration conf) throws Exception {
            this.shouldExitOnError = conf.getBoolean("yarn.dispatcher.exit-on-error", false);
            super.serviceInit(conf);
        }

        protected void serviceStart() throws Exception {
            this.eventProcessor.start();
            super.serviceStart();
        }

        protected void serviceStop() throws Exception {
            this.stopped = true;
            this.eventProcessor.interrupt();
            try {
                this.eventProcessor.join();
            }
            catch (InterruptedException e) {
                throw new YarnRuntimeException((Throwable)e);
            }
            super.serviceStop();
        }

        public void handle(SchedulerEvent event) {
            try {
                int remCapacity;
                int qSize = this.eventQueue.size();
                if (qSize != 0 && qSize % 1000 == 0 && this.lastEventQueueSizeLogged != qSize) {
                    this.lastEventQueueSizeLogged = qSize;
                    LOG.info((Object)("Size of scheduler event-queue is " + qSize));
                }
                if ((remCapacity = this.eventQueue.remainingCapacity()) < 1000) {
                    LOG.info((Object)("Very low remaining capacity on scheduler event queue: " + remCapacity));
                }
                this.eventQueue.put(event);
            }
            catch (InterruptedException e) {
                LOG.info((Object)"Interrupted. Trying to exit gracefully.");
            }
        }

        private final class EventProcessor
        implements Runnable {
            private EventProcessor() {
            }

            @Override
            public void run() {
                while (!SchedulerEventDispatcher.this.stopped && !Thread.currentThread().isInterrupted()) {
                    SchedulerEvent event;
                    try {
                        event = (SchedulerEvent)((Object)SchedulerEventDispatcher.this.eventQueue.take());
                    }
                    catch (InterruptedException e) {
                        LOG.error((Object)("Returning, interrupted : " + e));
                        return;
                    }
                    try {
                        SchedulerEventDispatcher.this.scheduler.handle((Event)event);
                    }
                    catch (Throwable t) {
                        if (SchedulerEventDispatcher.this.stopped) {
                            LOG.warn((Object)"Exception during shutdown: ", t);
                            break;
                        }
                        LOG.fatal((Object)("Error in handling event type " + event.getType() + " to the scheduler"), t);
                        if (!SchedulerEventDispatcher.this.shouldExitOnError || ShutdownHookManager.get().isShutdownInProgress()) continue;
                        LOG.info((Object)"Exiting, bbye..");
                        System.exit(-1);
                    }
                }
            }
        }
    }

    @InterfaceAudience.Private
    public class RMSchedulerServices
    extends CompositeService {
        private DelegationTokenRenewer delegationTokenRenewer;
        private EventHandler<SchedulerEvent> schedulerDispatcher;
        private ApplicationMasterLauncher applicationMasterLauncher;

        RMSchedulerServices() {
            super("RMActiveServices");
        }

        protected void serviceInit(Configuration configuration) throws Exception {
            ResourceManager.this.createAndInitResourceTrackingServices();
            if (UserGroupInformation.isSecurityEnabled()) {
                this.delegationTokenRenewer = ResourceManager.this.createDelegationTokenRenewer();
                ResourceManager.this.rmContext.setDelegationTokenRenewer(this.delegationTokenRenewer);
            }
            ResourceManager.this.scheduler = ResourceManager.this.createScheduler();
            ResourceManager.this.scheduler.setRMContext(ResourceManager.this.rmContext);
            this.addIfService(ResourceManager.this.scheduler);
            ResourceManager.this.rmContext.setScheduler(ResourceManager.this.scheduler);
            this.schedulerDispatcher = ResourceManager.this.createSchedulerEventDispatcher();
            this.addIfService(this.schedulerDispatcher);
            ResourceManager.this.rmDispatcher.register(SchedulerEventType.class, this.schedulerDispatcher);
            ResourceManager.this.rmDispatcher.register(RMAppEventType.class, (EventHandler)new ApplicationEventDispatcher(ResourceManager.this.rmContext));
            ResourceManager.this.rmDispatcher.register(RMAppAttemptEventType.class, (EventHandler)new ApplicationAttemptEventDispatcher(ResourceManager.this.rmContext));
            if (ResourceManager.this.conf.getBoolean("yarn.resourcemanager.reservation-system.enable", false)) {
                ResourceManager.this.reservationSystem = ResourceManager.this.createReservationSystem();
                if (ResourceManager.this.reservationSystem != null) {
                    ResourceManager.this.reservationSystem.setRMContext(ResourceManager.this.rmContext);
                    this.addIfService(ResourceManager.this.reservationSystem);
                    ResourceManager.this.rmContext.setReservationSystem(ResourceManager.this.reservationSystem);
                    LOG.info((Object)"Initialized Reservation system");
                }
            }
            ResourceManager.this.containersLogsService = new ContainersLogsService(ResourceManager.this.rmContext);
            this.addIfService((Object)ResourceManager.this.containersLogsService);
            ResourceManager.this.rmContext.setContainersLogsService(ResourceManager.this.containersLogsService);
            ResourceManager.this.quotaService = new QuotaService();
            this.addIfService((Object)ResourceManager.this.quotaService);
            ResourceManager.this.rmContext.setQuotaService(ResourceManager.this.quotaService);
            if (ResourceManager.this.conf.getBoolean("yarn.resourcemanager.quota.variable.price.enabled", YarnConfiguration.DEFAULT_QUOTA_VARIABLE_PRICE_ENABLED)) {
                ResourceManager.this.priceMultiplicatiorService = new PriceMultiplicatiorService(ResourceManager.this.rmContext);
                this.addIfService((Object)ResourceManager.this.priceMultiplicatiorService);
            }
            this.createPolicyMonitors();
            ResourceManager.this.masterService = ResourceManager.this.createApplicationMasterService();
            this.addService((Service)ResourceManager.this.masterService);
            ResourceManager.this.rmContext.setApplicationMasterService(ResourceManager.this.masterService);
            ResourceManager.this.applicationACLsManager = new ApplicationACLsManager(ResourceManager.this.conf);
            ResourceManager.this.queueACLsManager = ResourceManager.this.createQueueACLsManager(ResourceManager.this.scheduler, ResourceManager.this.conf);
            ResourceManager.this.rmAppManager = ResourceManager.this.createRMAppManager();
            ResourceManager.this.rmDispatcher.register(RMAppManagerEventType.class, (EventHandler)ResourceManager.this.rmAppManager);
            ResourceManager.this.rmAppCertificateManager = ResourceManager.this.createRMAppCertificateManager();
            ResourceManager.this.rmDispatcher.register(RMAppCertificateManagerEventType.class, (EventHandler)ResourceManager.this.rmAppCertificateManager);
            this.addService((Service)ResourceManager.this.rmAppCertificateManager);
            ResourceManager.this.rmContext.setRMAppCertificateManager(ResourceManager.this.rmAppCertificateManager);
            ResourceManager.this.clientRM = ResourceManager.this.createClientRMService();
            this.addService((Service)ResourceManager.this.clientRM);
            ResourceManager.this.rmContext.setClientRMService(ResourceManager.this.clientRM);
            this.applicationMasterLauncher = ResourceManager.this.createAMLauncher();
            ResourceManager.this.rmDispatcher.register(AMLauncherEventType.class, (EventHandler)this.applicationMasterLauncher);
            this.addService((Service)this.applicationMasterLauncher);
            if (UserGroupInformation.isSecurityEnabled()) {
                this.addService((Service)this.delegationTokenRenewer);
                this.delegationTokenRenewer.setRMContext(ResourceManager.this.rmContext);
            }
            new RMNMInfo(ResourceManager.this.rmContext, ResourceManager.this.scheduler);
            super.serviceInit(ResourceManager.this.conf);
        }

        protected void serviceStart() throws Exception {
            ResourceManager.this.resourceTrackingServiceStartStopLock.lock();
            LOG.info((Object)"locked resourceTrackingServiceStart");
            try {
                LOG.info((Object)"starting SchedulerService");
                ResourceManager.this.resourceTrackingService.start();
                super.serviceStart();
            }
            finally {
                LOG.info((Object)"unlocked resourceTrackingServiceStart");
                ResourceManager.this.resourceTrackingServiceStartStopLock.unlock();
            }
        }

        protected void serviceStop() throws Exception {
            super.serviceStop();
            if (ResourceManager.this.pauseMonitor != null) {
                ResourceManager.this.pauseMonitor.stop();
            }
            DefaultMetricsSystem.shutdown();
            if (ResourceManager.this.rmContext != null) {
                RMStateStore store = ResourceManager.this.rmContext.getStateStore();
                try {
                    if (null != store) {
                        store.close();
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)"Error closing store.", (Throwable)e);
                }
            }
        }

        protected void createPolicyMonitors() {
            if (ResourceManager.this.scheduler instanceof PreemptableResourceScheduler && ResourceManager.this.conf.getBoolean("yarn.resourcemanager.scheduler.monitor.enable", false)) {
                LOG.info((Object)"Loading policy monitors");
                List policies = ResourceManager.this.conf.getInstances("yarn.resourcemanager.scheduler.monitor.policies", SchedulingEditPolicy.class);
                if (policies.size() > 0) {
                    for (SchedulingEditPolicy policy : policies) {
                        LOG.info((Object)("LOADING SchedulingEditPolicy:" + policy.getPolicyName()));
                        SchedulingMonitor mon = new SchedulingMonitor(ResourceManager.this.rmContext, policy);
                        this.addService((Service)mon);
                    }
                } else {
                    LOG.warn((Object)"Policy monitors configured (yarn.resourcemanager.scheduler.monitor.enable) but none specified (yarn.resourcemanager.scheduler.monitor.policies)");
                }
            }
        }
    }

    @InterfaceAudience.Private
    class ResourceTrackingServices
    extends CompositeService {
        private ContainerAllocationExpirer containerAllocationExpirer;
        private boolean recoveryEnabled;
        private RMActiveServiceContext activeServiceContext;
        private ResourceManager rm;
        private StreamingReceiver streamingReceiver;

        public ResourceTrackingServices(ResourceManager rm) {
            super("ResourceTrackingServices");
            LOG.info((Object)"create resourceTrackingService");
            this.rm = rm;
        }

        protected void serviceInit(Configuration configuration) throws Exception {
            LOG.info((Object)"init resourceTrackingService");
            ResourceManager.this.conf.setBoolean("yarn.dispatcher.exit-on-error", true);
            this.activeServiceContext = new RMActiveServiceContext();
            ResourceManager.this.rmContext.setActiveServiceContext(this.activeServiceContext);
            ResourceManager.this.rmSecretManagerService = ResourceManager.this.createRMSecretManagerService();
            this.addService((Service)ResourceManager.this.rmSecretManagerService);
            this.containerAllocationExpirer = new ContainerAllocationExpirer(ResourceManager.this.rmDispatcher);
            this.addService((Service)this.containerAllocationExpirer);
            ResourceManager.this.rmContext.setContainerAllocationExpirer(this.containerAllocationExpirer);
            AMLivelinessMonitor amLivelinessMonitor = ResourceManager.this.createAMLivelinessMonitor();
            this.addService((Service)amLivelinessMonitor);
            ResourceManager.this.rmContext.setAMLivelinessMonitor(amLivelinessMonitor);
            AMLivelinessMonitor amFinishingMonitor = ResourceManager.this.createAMLivelinessMonitor();
            this.addService((Service)amFinishingMonitor);
            ResourceManager.this.rmContext.setAMFinishingMonitor(amFinishingMonitor);
            RMNodeLabelsManager nlm = ResourceManager.this.createNodeLabelManager();
            nlm.setRMContext(ResourceManager.this.rmContext);
            this.addService((Service)nlm);
            ResourceManager.this.rmContext.setNodeLabelManager(nlm);
            RMDelegatedNodeLabelsUpdater delegatedNodeLabelsUpdater = ResourceManager.this.createRMDelegatedNodeLabelsUpdater();
            if (delegatedNodeLabelsUpdater != null) {
                this.addService((Service)delegatedNodeLabelsUpdater);
                ResourceManager.this.rmContext.setRMDelegatedNodeLabelsUpdater(delegatedNodeLabelsUpdater);
            }
            this.recoveryEnabled = ResourceManager.this.conf.getBoolean("yarn.resourcemanager.recovery.enabled", false);
            RMStateStore rmStore = null;
            if (this.recoveryEnabled) {
                rmStore = RMStateStoreFactory.getStore(ResourceManager.this.conf);
                boolean isWorkPreservingRecoveryEnabled = ResourceManager.this.conf.getBoolean("yarn.resourcemanager.work-preserving-recovery.enabled", true);
                ResourceManager.this.rmContext.setWorkPreservingRecoveryEnabled(isWorkPreservingRecoveryEnabled);
            } else {
                rmStore = new NullRMStateStore();
            }
            try {
                rmStore.setResourceManager(this.rm);
                rmStore.init(ResourceManager.this.conf);
                rmStore.setRMDispatcher(ResourceManager.this.rmDispatcher);
            }
            catch (Exception e) {
                LOG.error((Object)"Failed to init state store", (Throwable)e);
                throw e;
            }
            ResourceManager.this.rmContext.setStateStore(rmStore);
            ResourceManager.this.nodesListManager = new NodesListManager(ResourceManager.this.rmContext);
            ResourceManager.this.rmDispatcher.register(NodesListManagerEventType.class, (EventHandler)ResourceManager.this.nodesListManager);
            this.addService((Service)ResourceManager.this.nodesListManager);
            ResourceManager.this.rmContext.setNodesListManager(ResourceManager.this.nodesListManager);
            ResourceManager.this.rmDispatcher.register(RMNodeEventType.class, (EventHandler)new NodeEventDispatcher(ResourceManager.this.rmContext));
            ResourceManager.this.nmLivelinessMonitor = ResourceManager.this.createNMLivelinessMonitor();
            this.addService((Service)ResourceManager.this.nmLivelinessMonitor);
            ResourceManager.this.resourceTracker = ResourceManager.this.createResourceTrackerService();
            this.addService((Service)ResourceManager.this.resourceTracker);
            ResourceManager.this.rmContext.setResourceTrackerService(ResourceManager.this.resourceTracker);
            DefaultMetricsSystem.initialize((String)"ResourceManager");
            JvmMetrics jm = JvmMetrics.initSingleton((String)"ResourceManager", null);
            ResourceManager.this.pauseMonitor = new JvmPauseMonitor(ResourceManager.this.conf);
            jm.setPauseMonitor(ResourceManager.this.pauseMonitor);
            super.serviceInit(ResourceManager.this.conf);
        }

        protected void serviceStart() throws Exception {
            LOG.info((Object)"starting resourceTrackingService");
            RMStateStore rmStore = ResourceManager.this.rmContext.getStateStore();
            rmStore.start();
            ResourceManager.this.pauseMonitor.start();
            if (ResourceManager.this.rmContext.isDistributed()) {
                if (!ResourceManager.this.rmContext.isLeader()) {
                    LOG.info((Object)"streaming processor is starting for resource tracker");
                    RMStorageFactory.kickEventStreamingAPI(false, ResourceManager.this.conf);
                    this.streamingReceiver = new RtStreamingProcessor(ResourceManager.this.rmContext);
                    this.streamingReceiver.start();
                } else {
                    LOG.info((Object)"streaming processor is starting for scheduler");
                    RMStorageFactory.kickEventStreamingAPI(true, ResourceManager.this.conf);
                    this.streamingReceiver = new RmStreamingProcessor(ResourceManager.this.rmContext);
                    this.streamingReceiver.start();
                }
            }
            if (this.recoveryEnabled) {
                try {
                    LOG.info((Object)"Recovery started");
                    rmStore.checkVersion();
                    if (ResourceManager.this.rmContext.isWorkPreservingRecoveryEnabled()) {
                        ResourceManager.this.rmContext.setEpoch(rmStore.getAndIncrementEpoch());
                    }
                    RMStateStore.RMState state = rmStore.loadState();
                    ResourceManager.this.recover(state);
                    LOG.info((Object)"Recovery ended");
                }
                catch (Exception e) {
                    LOG.error((Object)"Failed to load/recover state", (Throwable)e);
                    throw e;
                }
            }
            super.serviceStart();
            LOG.info((Object)"started resourceTrackingService");
        }

        protected void serviceStop() throws Exception {
            if (this.streamingReceiver != null) {
                this.streamingReceiver.stop();
                RMStorageFactory.stopEventStreamingAPI();
            }
            super.serviceStop();
        }
    }
}

