/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.recovery.records;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import org.apache.hadoop.yarn.proto.YarnSecurityTokenProtos;
import org.apache.hadoop.yarn.proto.YarnServerResourceManagerRecoveryProtos;
import org.apache.hadoop.yarn.security.client.RMDelegationTokenIdentifier;
import org.apache.hadoop.yarn.security.client.YARNDelegationTokenIdentifier;

public class RMDelegationTokenIdentifierData {
    YarnServerResourceManagerRecoveryProtos.RMDelegationTokenIdentifierDataProto.Builder builder = YarnServerResourceManagerRecoveryProtos.RMDelegationTokenIdentifierDataProto.newBuilder();

    public RMDelegationTokenIdentifierData() {
    }

    public RMDelegationTokenIdentifierData(YARNDelegationTokenIdentifier identifier, long renewdate) {
        YarnSecurityTokenProtos.YARNDelegationTokenIdentifierProto proto = identifier.getProto();
        this.builder.setTokenIdentifier(proto);
        this.builder.setRenewDate(renewdate);
    }

    public void readFields(DataInput in) throws IOException {
        this.builder.mergeFrom((DataInputStream)in);
    }

    public byte[] toByteArray() throws IOException {
        return this.builder.build().toByteArray();
    }

    public RMDelegationTokenIdentifier getTokenIdentifier() throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(this.builder.getTokenIdentifier().toByteArray());
        RMDelegationTokenIdentifier identifer = new RMDelegationTokenIdentifier();
        identifer.readFields((DataInput)new DataInputStream(in));
        return identifer;
    }

    public long getRenewDate() {
        return this.builder.getRenewDate();
    }
}

