/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.reservation;

import java.util.Date;
import java.util.TreeMap;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.ReservationId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.Plan;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.RLESparseResourceAllocation;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationAllocation;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationSchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.SharingPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.exceptions.PlanningException;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.exceptions.PlanningQuotaException;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.exceptions.ResourceOverCommitException;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;

@InterfaceAudience.LimitedPrivate(value={"yarn"})
@InterfaceStability.Unstable
public class CapacityOverTimePolicy
implements SharingPolicy {
    private ReservationSchedulerConfiguration conf;
    private long validWindow;
    private float maxInst;
    private float maxAvg;

    @Override
    public void init(String reservationQueuePath, ReservationSchedulerConfiguration conf) {
        this.conf = conf;
        this.validWindow = this.conf.getReservationWindow(reservationQueuePath);
        this.maxInst = this.conf.getInstantaneousMaxCapacity(reservationQueuePath) / 100.0f;
        this.maxAvg = this.conf.getAverageCapacity(reservationQueuePath) / 100.0f;
    }

    @Override
    public void validate(Plan plan, ReservationAllocation reservation) throws PlanningException {
        ReservationAllocation oldReservation = plan.getReservationById(reservation.getReservationId());
        long startTime = reservation.getStartTime();
        long endTime = reservation.getEndTime();
        long step = plan.getStep();
        Resource planTotalCapacity = plan.getTotalCapacity();
        Resource maxAvgRes = Resources.multiply((Resource)planTotalCapacity, (double)this.maxAvg);
        Resource maxInsRes = Resources.multiply((Resource)planTotalCapacity, (double)this.maxInst);
        IntegralResource runningTot = new IntegralResource(0L, 0L, 0L);
        IntegralResource maxAllowed = new IntegralResource(maxAvgRes);
        maxAllowed.multiplyBy(this.validWindow / step);
        RLESparseResourceAllocation userCons = plan.getConsumptionForUserOverTime(reservation.getUser(), startTime - this.validWindow, endTime + this.validWindow);
        for (long t = startTime - this.validWindow; t < endTime + this.validWindow; t += step) {
            Resource currExistingAllocTot = plan.getTotalCommittedResources(t);
            Resource currExistingAllocForUser = userCons.getCapacityAtTime(t);
            Resource currNewAlloc = reservation.getResourcesAtTime(t);
            Resource currOldAlloc = Resources.none();
            if (oldReservation != null) {
                currOldAlloc = oldReservation.getResourcesAtTime(t);
            }
            Resource inst = Resources.subtract((Resource)Resources.add((Resource)currExistingAllocTot, (Resource)currNewAlloc), (Resource)currOldAlloc);
            if (Resources.greaterThan((ResourceCalculator)plan.getResourceCalculator(), (Resource)planTotalCapacity, (Resource)inst, (Resource)planTotalCapacity)) {
                throw new ResourceOverCommitException(" Resources at time " + t + " would be overcommitted (" + inst + " over " + plan.getTotalCapacity() + ") by accepting reservation: " + reservation.getReservationId());
            }
            if (Resources.greaterThan((ResourceCalculator)plan.getResourceCalculator(), (Resource)planTotalCapacity, (Resource)Resources.subtract((Resource)Resources.add((Resource)currExistingAllocForUser, (Resource)currNewAlloc), (Resource)currOldAlloc), (Resource)maxInsRes)) {
                throw new PlanningQuotaException("Instantaneous quota capacity " + this.maxInst + " would be passed at time " + t + " by accepting reservation: " + reservation.getReservationId());
            }
            runningTot.add(currExistingAllocForUser);
            runningTot.add(currNewAlloc);
            runningTot.subtract(currOldAlloc);
            if (t > startTime) {
                Resource pastOldAlloc = userCons.getCapacityAtTime(t - this.validWindow);
                Resource pastNewAlloc = reservation.getResourcesAtTime(t - this.validWindow);
                runningTot.subtract(pastOldAlloc);
                runningTot.subtract(pastNewAlloc);
            }
            if (maxAllowed.compareTo(runningTot) >= 0L) continue;
            throw new PlanningQuotaException("Integral (avg over time) quota capacity " + this.maxAvg + " over a window of " + this.validWindow / 1000L + " seconds,  would be passed at time " + t + "(" + new Date(t) + ") by accepting reservation: " + reservation.getReservationId());
        }
    }

    @Override
    public RLESparseResourceAllocation availableResources(RLESparseResourceAllocation available, Plan plan, String user, ReservationId oldId, long start, long end) throws PlanningException {
        Resource planTotalCapacity = plan.getTotalCapacity();
        Resource maxInsRes = Resources.multiply((Resource)planTotalCapacity, (double)this.maxInst);
        TreeMap<Long, Resource> instQuota = new TreeMap<Long, Resource>();
        instQuota.put(start, maxInsRes);
        RLESparseResourceAllocation instRLEQuota = new RLESparseResourceAllocation(instQuota, plan.getResourceCalculator());
        RLESparseResourceAllocation used = plan.getConsumptionForUserOverTime(user, start, end);
        ReservationAllocation old = plan.getReservationById(oldId);
        if (old != null) {
            used = RLESparseResourceAllocation.merge(plan.getResourceCalculator(), Resources.clone((Resource)plan.getTotalCapacity()), used, old.getResourcesOverTime(), RLESparseResourceAllocation.RLEOperator.subtract, start, end);
        }
        instRLEQuota = RLESparseResourceAllocation.merge(plan.getResourceCalculator(), planTotalCapacity, instRLEQuota, used, RLESparseResourceAllocation.RLEOperator.subtract, start, end);
        instRLEQuota = RLESparseResourceAllocation.merge(plan.getResourceCalculator(), planTotalCapacity, available, instRLEQuota, RLESparseResourceAllocation.RLEOperator.min, start, end);
        return instRLEQuota;
    }

    @Override
    public long getValidWindow() {
        return this.validWindow;
    }

    private static class IntegralResource {
        long memory;
        long vcores;
        long gpus;

        public IntegralResource(Resource resource) {
            this.memory = resource.getMemorySize();
            this.vcores = resource.getVirtualCores();
            this.gpus = resource.getGPUs();
        }

        public IntegralResource(long mem, long vcores, long gpus) {
            this.memory = mem;
            this.vcores = vcores;
            this.gpus = gpus;
        }

        public void add(Resource r) {
            this.memory += r.getMemorySize();
            this.vcores += (long)r.getVirtualCores();
            this.gpus += (long)r.getGPUs();
        }

        public void subtract(Resource r) {
            this.memory -= r.getMemorySize();
            this.vcores -= (long)r.getVirtualCores();
            this.gpus -= (long)r.getGPUs();
        }

        public void multiplyBy(long window) {
            this.memory *= window;
            this.vcores *= window;
            this.gpus *= window;
        }

        public long compareTo(IntegralResource other) {
            long diff = this.memory - other.memory;
            if (diff == 0L && (diff = this.vcores - other.vcores) == 0L) {
                diff = this.gpus - other.gpus;
            }
            return diff;
        }

        public String toString() {
            return "<memory:" + this.memory + ", vCores:" + this.vcores + ", gpus: " + this.gpus + ">";
        }
    }
}

