/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.rmnode;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceOption;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.server.api.protocolrecords.LogAggregationReport;
import org.apache.hadoop.yarn.server.api.protocolrecords.NMContainerStatus;
import org.apache.hadoop.yarn.server.api.protocolrecords.NodeHeartbeatResponse;
import org.apache.hadoop.yarn.server.api.records.NodeHealthStatus;
import org.apache.hadoop.yarn.server.resourcemanager.ClusterMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.NodesListManager;
import org.apache.hadoop.yarn.server.resourcemanager.NodesListManagerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.NodesListManagerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppRunningOnNodeEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.AllocationExpirationInfo;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeCleanAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeCleanContainerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeDecreaseContainerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeReconnectEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeSignalContainerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeStartedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeStatusEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.UpdatedContainerInfo;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeResourceUpdateSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeUpdateSchedulerEvent;
import org.apache.hadoop.yarn.state.InvalidStateTransitonException;

public class RMNodeImplNotDist
extends RMNodeImpl {
    private static final Log LOG = LogFactory.getLog(RMNodeImplNotDist.class);

    public RMNodeImplNotDist(NodeId nodeId, RMContext context, String hostName, int cmPort, int httpPort, Node node, Resource capability, String nodeManagerVersion) {
        super(nodeId, context, hostName, cmPort, httpPort, node, capability, nodeManagerVersion);
    }

    @Override
    protected NodeState statusUpdateWhenHealthyTransitionInternal(RMNodeImpl rmNode, RMNodeEvent event) {
        RMNodeStatusEvent statusEvent = (RMNodeStatusEvent)event;
        rmNode.latestNodeHeartBeatResponse = statusEvent.getLatestResponse();
        NodeHealthStatus remoteNodeHealthStatus = statusEvent.getNodeHealthStatus();
        rmNode.setHealthReport(remoteNodeHealthStatus.getHealthReport());
        rmNode.setLastHealthReportTime(remoteNodeHealthStatus.getLastHealthReportTime());
        rmNode.setAggregatedContainersUtilization(statusEvent.getAggregatedContainersUtilization());
        rmNode.setNodeUtilization(statusEvent.getNodeUtilization());
        NodeState initialState = rmNode.getState();
        boolean isNodeDecommissioning = initialState.equals((Object)NodeState.DECOMMISSIONING);
        if (isNodeDecommissioning) {
            List<ApplicationId> keepAliveApps = statusEvent.getKeepAliveAppIds();
            if (rmNode.runningApplications.isEmpty() && (keepAliveApps == null || keepAliveApps.isEmpty())) {
                this.deactivateNode(rmNode, NodeState.DECOMMISSIONED);
                return NodeState.DECOMMISSIONED;
            }
        }
        if (!remoteNodeHealthStatus.getIsNodeHealthy()) {
            LOG.info((Object)("Node " + rmNode.nodeId + " reported UNHEALTHY with details: " + remoteNodeHealthStatus.getHealthReport()));
            if (isNodeDecommissioning) {
                return NodeState.DECOMMISSIONING;
            }
            RMNodeImplNotDist.reportNodeUnusable(rmNode, NodeState.UNHEALTHY);
            return NodeState.UNHEALTHY;
        }
        ((RMNodeImplNotDist)rmNode).handleContainerStatus(statusEvent.getContainers());
        rmNode.handleReportedIncreasedContainers(statusEvent.getNMReportedIncreasedContainers());
        List<LogAggregationReport> logAggregationReportsForApps = statusEvent.getLogAggregationReportsForApps();
        if (logAggregationReportsForApps != null && !logAggregationReportsForApps.isEmpty()) {
            rmNode.handleLogAggregationStatus(logAggregationReportsForApps);
        }
        if (rmNode.nextHeartBeat) {
            rmNode.nextHeartBeat = false;
            rmNode.context.getDispatcher().getEventHandler().handle((Event)new NodeUpdateSchedulerEvent(rmNode));
        }
        if (UserGroupInformation.isSecurityEnabled()) {
            rmNode.context.getDelegationTokenRenewer().updateKeepAliveApplications(statusEvent.getKeepAliveAppIds());
        }
        return initialState;
    }

    @Override
    protected void handleContainerStatus(List<ContainerStatus> containerStatuses) {
        ArrayList<ContainerStatus> newlyLaunchedContainers = new ArrayList<ContainerStatus>();
        ArrayList<ContainerStatus> completedContainers = new ArrayList<ContainerStatus>();
        ArrayList<io.hops.metadata.yarn.entity.ContainerStatus> containerToLog = new ArrayList<io.hops.metadata.yarn.entity.ContainerStatus>();
        int numRemoteRunningContainers = 0;
        for (ContainerStatus remoteContainer : containerStatuses) {
            ContainerId containerId = remoteContainer.getContainerId();
            if (this.containersToClean.contains(containerId)) {
                LOG.info((Object)("Container " + containerId + " already scheduled for cleanup, no further processing"));
                continue;
            }
            ApplicationId containerAppId = containerId.getApplicationAttemptId().getApplicationId();
            if (this.finishedApplications.contains(containerAppId)) {
                LOG.info((Object)("Container " + containerId + " belongs to an application that is already killed, no further processing"));
                continue;
            }
            if (!this.runningApplications.contains(containerAppId)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Container " + containerId + " is the first container get launched for application " + containerAppId));
                }
                this.handleRunningAppOnNode(this, this.context, containerAppId, this.nodeId);
            }
            if (remoteContainer.getState() == ContainerState.RUNNING) {
                ++numRemoteRunningContainers;
                if (!this.launchedContainers.contains(containerId)) {
                    this.launchedContainers.add(containerId);
                    newlyLaunchedContainers.add(remoteContainer);
                    this.containerAllocationExpirer.unregister(new AllocationExpirationInfo(containerId));
                }
            } else {
                this.launchedContainers.remove(containerId);
                completedContainers.add(remoteContainer);
                this.containerAllocationExpirer.unregister(new AllocationExpirationInfo(containerId));
            }
            containerToLog.add(new io.hops.metadata.yarn.entity.ContainerStatus(remoteContainer.getContainerId().toString(), remoteContainer.getState().name(), remoteContainer.getDiagnostics(), remoteContainer.getExitStatus(), this.nodeId.toString()));
        }
        List<ContainerStatus> lostContainers = this.findLostContainers(numRemoteRunningContainers, containerStatuses);
        for (ContainerStatus lostContainer : lostContainers) {
            containerToLog.add(new io.hops.metadata.yarn.entity.ContainerStatus(lostContainer.getContainerId().toString(), lostContainer.getState().name(), lostContainer.getDiagnostics(), lostContainer.getExitStatus(), this.nodeId.toString()));
        }
        completedContainers.addAll(lostContainers);
        if (newlyLaunchedContainers.size() != 0 || completedContainers.size() != 0) {
            this.nodeUpdateQueue.add(new UpdatedContainerInfo(newlyLaunchedContainers, completedContainers));
        }
        if (!containerToLog.isEmpty() && this.context.getContainersLogsService() != null) {
            this.context.getContainersLogsService().insertEvent(containerToLog);
        }
    }

    @Override
    public void updateNodeHeartbeatResponseForCleanup(NodeHeartbeatResponse response) {
        this.writeLock.lock();
        try {
            response.addAllContainersToCleanup(new ArrayList(this.containersToClean));
            response.addAllApplicationsToCleanup(this.finishedApplications);
            response.addContainersToBeRemovedFromNM(new ArrayList(this.containersToBeRemovedFromNM));
            response.addAllContainersToSignal(this.containersToSignal);
            this.containersToClean.clear();
            this.finishedApplications.clear();
            this.containersToSignal.clear();
            this.containersToBeRemovedFromNM.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void updateNodeHeartbeatResponseForContainersDecreasing(NodeHeartbeatResponse response) {
        this.writeLock.lock();
        try {
            response.addAllContainersToDecrease(this.toBeDecreasedContainers.values());
            this.toBeDecreasedContainers.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    protected void handleRunningAppOnNode(RMNodeImpl rmNode, RMContext context, ApplicationId appId, NodeId nodeId) {
        RMApp app = (RMApp)context.getRMApps().get(appId);
        if (null == app) {
            LOG.warn((Object)("Cannot get RMApp by appId=" + appId + ", just added it to finishedApplications list for cleanup"));
            rmNode.finishedApplications.add(appId);
            rmNode.runningApplications.remove(appId);
            return;
        }
        rmNode.runningApplications.add(appId);
        context.getDispatcher().getEventHandler().handle((Event)new RMAppRunningOnNodeEvent(appId, nodeId));
    }

    @Override
    protected void cleanUpAppTransitionInternal(RMNodeImpl rmNode, RMNodeEvent event) {
        ApplicationId appId = ((RMNodeCleanAppEvent)event).getAppId();
        rmNode.finishedApplications.add(appId);
        rmNode.runningApplications.remove(appId);
        rmNode.getAppCryptoMaterialToUpdate().remove(appId);
    }

    @Override
    protected void cleanUpContainerTransitionInternal(RMNodeImpl rmNode, RMNodeEvent event) {
        ArrayList<io.hops.metadata.yarn.entity.ContainerStatus> containerToLog = new ArrayList<io.hops.metadata.yarn.entity.ContainerStatus>();
        RMNodeCleanContainerEvent containerEvent = (RMNodeCleanContainerEvent)event;
        containerToLog.add(new io.hops.metadata.yarn.entity.ContainerStatus(containerEvent.getContainerId().toString(), ContainerState.COMPLETE.name(), "killed", -100, containerEvent.getNodeId().toString()));
        this.context.getContainersLogsService().insertEvent(containerToLog);
        rmNode.containersToClean.add(((RMNodeCleanContainerEvent)event).getContainerId());
    }

    @Override
    protected List<UpdatedContainerInfo> pullContainerUpdatesInternal() {
        UpdatedContainerInfo containerInfo;
        ArrayList<UpdatedContainerInfo> latestContainerInfoList = new ArrayList<UpdatedContainerInfo>();
        while ((containerInfo = (UpdatedContainerInfo)this.nodeUpdateQueue.poll()) != null) {
            latestContainerInfoList.add(containerInfo);
        }
        this.nextHeartBeat = true;
        return latestContainerInfoList;
    }

    @Override
    protected void addNodeTransitionInternal(RMNodeImpl rmNode, RMNodeEvent event) {
        RMNodeStartedEvent startEvent = (RMNodeStartedEvent)event;
        List<NMContainerStatus> containers = null;
        NodeId nodeId = rmNode.nodeId;
        RMNode previousRMNode = (RMNode)rmNode.context.getInactiveRMNodes().remove(nodeId);
        if (previousRMNode != null) {
            rmNode.updateMetricsForRejoinedNode(previousRMNode.getState());
        } else {
            NodeId unknownNodeId = NodesListManager.createUnknownNodeId(nodeId.getHost());
            previousRMNode = (RMNode)rmNode.context.getInactiveRMNodes().remove(unknownNodeId);
            if (previousRMNode != null) {
                ClusterMetrics.getMetrics().decrDecommisionedNMs();
            }
            ClusterMetrics.getMetrics().incrNumActiveNodes();
            containers = startEvent.getNMContainerStatuses();
            if (containers != null && !containers.isEmpty()) {
                for (NMContainerStatus container : containers) {
                    if (container.getContainerState() != ContainerState.RUNNING) continue;
                    rmNode.launchedContainers.add(container.getContainerId());
                }
            }
        }
        if (null != startEvent.getRunningApplications()) {
            for (ApplicationId appId : startEvent.getRunningApplications()) {
                this.handleRunningAppOnNode(rmNode, rmNode.context, appId, rmNode.nodeId);
            }
        }
        rmNode.context.getDispatcher().getEventHandler().handle((Event)new NodeAddedSchedulerEvent(rmNode, containers));
        rmNode.context.getDispatcher().getEventHandler().handle((Event)new NodesListManagerEvent(NodesListManagerEventType.NODE_USABLE, rmNode));
    }

    @Override
    protected NodeState reconnectNodeTransitionInternal(RMNodeImpl rmNode, RMNodeEvent event) {
        boolean noRunningApps;
        RMNodeReconnectEvent reconnectEvent = (RMNodeReconnectEvent)event;
        RMNode newNode = reconnectEvent.getReconnectedNode();
        rmNode.nodeManagerVersion = newNode.getNodeManagerVersion();
        List<ApplicationId> runningApps = reconnectEvent.getRunningApplications();
        boolean bl = noRunningApps = runningApps == null || runningApps.size() == 0;
        if (noRunningApps) {
            if (rmNode.getState() == NodeState.DECOMMISSIONING) {
                this.deactivateNode(rmNode, NodeState.DECOMMISSIONED);
                return NodeState.DECOMMISSIONED;
            }
            rmNode.nodeUpdateQueue.clear();
            rmNode.context.getDispatcher().getEventHandler().handle((Event)new NodeRemovedSchedulerEvent(rmNode));
            if (rmNode.getHttpPort() == newNode.getHttpPort()) {
                if (!rmNode.getTotalCapability().equals((Object)newNode.getTotalCapability())) {
                    rmNode.totalCapability = newNode.getTotalCapability();
                }
                if (rmNode.getState().equals((Object)NodeState.RUNNING)) {
                    rmNode.context.getDispatcher().getEventHandler().handle((Event)new NodeAddedSchedulerEvent(rmNode));
                }
            } else {
                switch (rmNode.getState()) {
                    case RUNNING: {
                        ClusterMetrics.getMetrics().decrNumActiveNodes();
                        break;
                    }
                    case UNHEALTHY: {
                        ClusterMetrics.getMetrics().decrNumUnhealthyNMs();
                        break;
                    }
                    default: {
                        LOG.debug((Object)"Unexpected Rmnode state");
                    }
                }
                rmNode.context.getRMNodes().put(newNode.getNodeID(), newNode);
                rmNode.context.getDispatcher().getEventHandler().handle((Event)new RMNodeStartedEvent(newNode.getNodeID(), null, null));
            }
        } else {
            rmNode.httpPort = newNode.getHttpPort();
            rmNode.httpAddress = newNode.getHttpAddress();
            boolean isCapabilityChanged = false;
            if (!rmNode.getTotalCapability().equals((Object)newNode.getTotalCapability())) {
                rmNode.totalCapability = newNode.getTotalCapability();
                isCapabilityChanged = true;
            }
            this.handleNMContainerStatus(reconnectEvent.getNMContainerStatuses(), rmNode);
            for (ApplicationId appId : reconnectEvent.getRunningApplications()) {
                rmNode.handleRunningAppOnNode(rmNode, rmNode.context, appId, rmNode.nodeId);
            }
            if (isCapabilityChanged && rmNode.getState().equals((Object)NodeState.RUNNING)) {
                rmNode.context.getDispatcher().getEventHandler().handle((Event)new NodeResourceUpdateSchedulerEvent(rmNode, ResourceOption.newInstance((Resource)newNode.getTotalCapability(), (int)-1)));
            }
        }
        return rmNode.getState();
    }

    @Override
    protected void decreaseContainersInt(RMNodeImpl rmNode, RMNodeDecreaseContainerEvent de) {
        for (Container c : de.getToBeDecreasedContainers()) {
            rmNode.toBeDecreasedContainers.put(c.getId(), c);
        }
    }

    @Override
    protected void deactivateNode(RMNodeImpl rmNode, NodeState finalState) {
        if (rmNode.getNodeID().getPort() == -1) {
            rmNode.updateMetricsForDeactivatedNode(rmNode.getState(), finalState);
            return;
        }
        RMNodeImplNotDist.reportNodeUnusable(rmNode, finalState);
        rmNode.context.getRMNodes().remove(rmNode.nodeId);
        LOG.info((Object)("Deactivating Node " + rmNode.nodeId + " as it is now " + finalState));
        rmNode.context.getInactiveRMNodes().put(rmNode.nodeId, rmNode);
        if (rmNode.context.getNodesListManager().isUntrackedNode(rmNode.hostName)) {
            rmNode.setUntrackedTimeStamp(Time.monotonicNow());
        }
    }

    public static void reportNodeUnusable(RMNodeImpl rmNode, NodeState finalState) {
        rmNode.nodeUpdateQueue.clear();
        NodeState initialState = rmNode.getState();
        if (!initialState.equals((Object)NodeState.UNHEALTHY)) {
            rmNode.context.getDispatcher().getEventHandler().handle((Event)new NodeRemovedSchedulerEvent(rmNode));
        }
        rmNode.context.getDispatcher().getEventHandler().handle((Event)new NodesListManagerEvent(NodesListManagerEventType.NODE_UNUSABLE, rmNode));
        rmNode.updateMetricsForDeactivatedNode(initialState, finalState);
    }

    @Override
    protected NodeState statusUpdateWhenUnHealthyTransitionInternal(RMNodeImpl rmNode, RMNodeEvent event) {
        RMNodeStatusEvent statusEvent = (RMNodeStatusEvent)event;
        rmNode.latestNodeHeartBeatResponse = statusEvent.getLatestResponse();
        NodeHealthStatus remoteNodeHealthStatus = statusEvent.getNodeHealthStatus();
        rmNode.setHealthReport(remoteNodeHealthStatus.getHealthReport());
        rmNode.setLastHealthReportTime(remoteNodeHealthStatus.getLastHealthReportTime());
        rmNode.setAggregatedContainersUtilization(statusEvent.getAggregatedContainersUtilization());
        rmNode.setNodeUtilization(statusEvent.getNodeUtilization());
        if (remoteNodeHealthStatus.getIsNodeHealthy()) {
            rmNode.context.getDispatcher().getEventHandler().handle((Event)new NodeAddedSchedulerEvent(rmNode));
            rmNode.context.getDispatcher().getEventHandler().handle((Event)new NodesListManagerEvent(NodesListManagerEventType.NODE_USABLE, rmNode));
            rmNode.updateMetricsForRejoinedNode(NodeState.UNHEALTHY);
            return NodeState.RUNNING;
        }
        return NodeState.UNHEALTHY;
    }

    @Override
    protected void signalContainerInt(RMNodeImpl rmNode, RMNodeEvent event) {
        rmNode.containersToSignal.add(((RMNodeSignalContainerEvent)event).getSignalRequest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(RMNodeEvent event) {
        LOG.debug((Object)("Processing " + event.getNodeId() + " of type " + event.getType()));
        try {
            this.writeLock.lock();
            NodeState oldState = this.getState();
            try {
                this.stateMachine.doTransition(event.getType(), (Object)event);
            }
            catch (InvalidStateTransitonException e) {
                LOG.error((Object)"Can't handle this event at current state", (Throwable)e);
                LOG.error((Object)("Invalid event " + event.getType() + " on Node  " + this.nodeId));
            }
            if (oldState != this.getState()) {
                LOG.info((Object)(this.nodeId + " Node Transitioned from " + oldState + " to " + this.getState()));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }
}

