/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.api.records.QueueState;
import org.apache.hadoop.yarn.api.records.QueueUserACLInfo;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.exceptions.InvalidResourceRequestException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ActiveUsersManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.NodeType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceLimits;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedContainerChangeRequest;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplicationAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AbstractCSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSAssignment;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueueUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.PartitionedQueueComparator;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.SchedulingMode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerNode;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class ParentQueue
extends AbstractCSQueue {
    private static final Log LOG = LogFactory.getLog(ParentQueue.class);
    protected final Set<CSQueue> childQueues;
    private final boolean rootQueue;
    final Comparator<CSQueue> nonPartitionedQueueComparator;
    final PartitionedQueueComparator partitionQueueComparator;
    volatile int numApplications;
    private final CapacitySchedulerContext scheduler;
    private boolean needToResortQueuesAtNextAllocation = false;
    private int offswitchPerHeartbeatLimit;
    private final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    private static float PRECISION = 5.0E-4f;

    public ParentQueue(CapacitySchedulerContext cs, String queueName, CSQueue parent, CSQueue old) throws IOException {
        super(cs, queueName, parent, old);
        this.scheduler = cs;
        this.nonPartitionedQueueComparator = cs.getNonPartitionedQueueComparator();
        this.partitionQueueComparator = cs.getPartitionedQueueComparator();
        this.rootQueue = parent == null;
        float rawCapacity = cs.getConfiguration().getNonLabeledQueueCapacity(this.getQueuePath());
        if (this.rootQueue && rawCapacity != 100.0f) {
            throw new IllegalArgumentException("Illegal capacity of " + rawCapacity + " for queue " + queueName + ". Must be " + 100.0f);
        }
        this.childQueues = new TreeSet<CSQueue>(this.nonPartitionedQueueComparator);
        this.setupQueueConfigs(cs.getClusterResource());
        LOG.info((Object)("Initialized parent-queue " + queueName + " name=" + queueName + ", fullname=" + this.getQueuePath()));
    }

    @Override
    synchronized void setupQueueConfigs(Resource clusterResource) throws IOException {
        super.setupQueueConfigs(clusterResource);
        StringBuilder aclsString = new StringBuilder();
        for (Map.Entry e : this.acls.entrySet()) {
            aclsString.append(e.getKey() + ":" + ((AccessControlList)e.getValue()).getAclString());
        }
        StringBuilder labelStrBuilder = new StringBuilder();
        if (this.accessibleLabels != null) {
            for (String s : this.accessibleLabels) {
                labelStrBuilder.append(s);
                labelStrBuilder.append(",");
            }
        }
        this.offswitchPerHeartbeatLimit = this.csContext.getConfiguration().getOffSwitchPerHeartbeatLimit();
        LOG.info((Object)(this.queueName + ", capacity=" + this.queueCapacities.getCapacity() + ", asboluteCapacity=" + this.queueCapacities.getAbsoluteCapacity() + ", maxCapacity=" + this.queueCapacities.getMaximumCapacity() + ", asboluteMaxCapacity=" + this.queueCapacities.getAbsoluteMaximumCapacity() + ", state=" + this.state + ", acls=" + aclsString + ", labels=" + labelStrBuilder.toString() + ", offswitchPerHeartbeatLimit = " + this.getOffSwitchPerHeartbeatLimit() + ", reservationsContinueLooking=" + this.reservationsContinueLooking));
    }

    synchronized void setChildQueues(Collection<CSQueue> childQueues) {
        float childCapacities = 0.0f;
        for (CSQueue queue : childQueues) {
            childCapacities += queue.getCapacity();
        }
        float delta = Math.abs(1.0f - childCapacities);
        if (this.queueCapacities.getCapacity() > 0.0f && delta > PRECISION || this.queueCapacities.getCapacity() == 0.0f && childCapacities > 0.0f) {
            throw new IllegalArgumentException("Illegal capacity of " + childCapacities + " for children of queue " + this.queueName);
        }
        for (String nodeLabel : this.queueCapacities.getExistingNodeLabels()) {
            float capacityByLabel = this.queueCapacities.getCapacity(nodeLabel);
            float sum = 0.0f;
            for (CSQueue queue : childQueues) {
                sum += queue.getQueueCapacities().getCapacity(nodeLabel);
            }
            if (!(capacityByLabel > 0.0f && Math.abs(1.0f - sum) > PRECISION) && (capacityByLabel != 0.0f || !(sum > 0.0f))) continue;
            throw new IllegalArgumentException("Illegal capacity of " + sum + " for children of queue " + this.queueName + " for label=" + nodeLabel);
        }
        this.childQueues.clear();
        this.childQueues.addAll(childQueues);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("setChildQueues: " + this.getChildQueuesToPrint()));
        }
    }

    @Override
    public String getQueuePath() {
        String parentPath = this.parent == null ? "" : this.parent.getQueuePath() + ".";
        return parentPath + this.getQueueName();
    }

    @Override
    public synchronized QueueInfo getQueueInfo(boolean includeChildQueues, boolean recursive) {
        QueueInfo queueInfo = this.getQueueInfo();
        ArrayList<QueueInfo> childQueuesInfo = new ArrayList<QueueInfo>();
        if (includeChildQueues) {
            for (CSQueue child : this.childQueues) {
                childQueuesInfo.add(child.getQueueInfo(recursive, recursive));
            }
        }
        queueInfo.setChildQueues(childQueuesInfo);
        return queueInfo;
    }

    @InterfaceAudience.Private
    public int getOffSwitchPerHeartbeatLimit() {
        return this.offswitchPerHeartbeatLimit;
    }

    private synchronized QueueUserACLInfo getUserAclInfo(UserGroupInformation user) {
        QueueUserACLInfo userAclInfo = (QueueUserACLInfo)this.recordFactory.newRecordInstance(QueueUserACLInfo.class);
        ArrayList<QueueACL> operations = new ArrayList<QueueACL>();
        for (QueueACL operation : QueueACL.values()) {
            if (!this.hasAccess(operation, user)) continue;
            operations.add(operation);
        }
        userAclInfo.setQueueName(this.getQueueName());
        userAclInfo.setUserAcls(operations);
        return userAclInfo;
    }

    @Override
    public synchronized List<QueueUserACLInfo> getQueueUserAclInfo(UserGroupInformation user) {
        ArrayList<QueueUserACLInfo> userAcls = new ArrayList<QueueUserACLInfo>();
        userAcls.add(this.getUserAclInfo(user));
        for (CSQueue child : this.childQueues) {
            userAcls.addAll(child.getQueueUserAclInfo(user));
        }
        return userAcls;
    }

    public String toString() {
        return this.queueName + ": numChildQueue= " + this.childQueues.size() + ", capacity=" + this.queueCapacities.getCapacity() + ", absoluteCapacity=" + this.queueCapacities.getAbsoluteCapacity() + ", usedResources=" + this.queueUsage.getUsed() + "usedCapacity=" + this.getUsedCapacity() + ", numApps=" + this.getNumApplications() + ", numContainers=" + this.getNumContainers();
    }

    @Override
    public synchronized void reinitialize(CSQueue newlyParsedQueue, Resource clusterResource) throws IOException {
        if (!(newlyParsedQueue instanceof ParentQueue) || !newlyParsedQueue.getQueuePath().equals(this.getQueuePath())) {
            throw new IOException("Trying to reinitialize " + this.getQueuePath() + " from " + newlyParsedQueue.getQueuePath());
        }
        ParentQueue newlyParsedParentQueue = (ParentQueue)newlyParsedQueue;
        this.setupQueueConfigs(clusterResource);
        Map<String, CSQueue> currentChildQueues = this.getQueues(this.childQueues);
        Map<String, CSQueue> newChildQueues = this.getQueues(newlyParsedParentQueue.childQueues);
        for (Map.Entry<String, CSQueue> e : newChildQueues.entrySet()) {
            String newChildQueueName = e.getKey();
            CSQueue newChildQueue = e.getValue();
            CSQueue childQueue = currentChildQueues.get(newChildQueueName);
            if (childQueue != null) {
                childQueue.reinitialize(newChildQueue, clusterResource);
                LOG.info((Object)(this.getQueueName() + ": re-configured queue: " + childQueue));
                continue;
            }
            newChildQueue.setParent(this);
            currentChildQueues.put(newChildQueueName, newChildQueue);
            LOG.info((Object)(this.getQueueName() + ": added new child queue: " + newChildQueue));
        }
        this.childQueues.clear();
        this.childQueues.addAll(currentChildQueues.values());
    }

    Map<String, CSQueue> getQueues(Set<CSQueue> queues) {
        HashMap<String, CSQueue> queuesMap = new HashMap<String, CSQueue>();
        for (CSQueue queue : queues) {
            queuesMap.put(queue.getQueueName(), queue);
        }
        return queuesMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void submitApplication(ApplicationId applicationId, String user, String queue) throws AccessControlException {
        ParentQueue parentQueue = this;
        synchronized (parentQueue) {
            if (queue.equals(this.queueName)) {
                throw new AccessControlException("Cannot submit application to non-leaf queue: " + this.queueName);
            }
            if (this.state != QueueState.RUNNING) {
                throw new AccessControlException("Queue " + this.getQueuePath() + " is STOPPED. Cannot accept submission of application: " + applicationId);
            }
            this.addApplication(applicationId, user);
        }
        if (this.parent != null) {
            try {
                this.parent.submitApplication(applicationId, user, queue);
            }
            catch (AccessControlException ace) {
                LOG.info((Object)("Failed to submit application to parent-queue: " + this.parent.getQueuePath()), (Throwable)ace);
                this.removeApplication(applicationId, user);
                throw ace;
            }
        }
    }

    @Override
    public void submitApplicationAttempt(FiCaSchedulerApp application, String userName) {
    }

    @Override
    public void finishApplicationAttempt(FiCaSchedulerApp application, String queue) {
    }

    private synchronized void addApplication(ApplicationId applicationId, String user) {
        ++this.numApplications;
        LOG.info((Object)("Application added - appId: " + applicationId + " user: " + user + " leaf-queue of parent: " + this.getQueueName() + " #applications: " + this.getNumApplications()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finishApplication(ApplicationId application, String user) {
        ParentQueue parentQueue = this;
        synchronized (parentQueue) {
            this.removeApplication(application, user);
        }
        if (this.parent != null) {
            this.parent.finishApplication(application, user);
        }
    }

    private synchronized void removeApplication(ApplicationId applicationId, String user) {
        --this.numApplications;
        LOG.info((Object)("Application removed - appId: " + applicationId + " user: " + user + " leaf-queue of parent: " + this.getQueueName() + " #applications: " + this.getNumApplications()));
    }

    @Override
    public synchronized CSAssignment assignContainers(Resource clusterResource, FiCaSchedulerNode node, ResourceLimits resourceLimits, SchedulingMode schedulingMode) {
        int offswitchCount = 0;
        if (schedulingMode == SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY && !this.accessibleToPartition(node.getPartition())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Skip this queue=" + this.getQueuePath() + ", because it is not able to access partition=" + node.getPartition()));
            }
            return CSAssignment.NULL_ASSIGNMENT;
        }
        if (!super.hasPendingResourceRequest(node.getPartition(), clusterResource, schedulingMode)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Skip this queue=" + this.getQueuePath() + ", because it doesn't need more resource, schedulingMode=" + schedulingMode.name() + " node-partition=" + node.getPartition()));
            }
            return CSAssignment.NULL_ASSIGNMENT;
        }
        CSAssignment assignment = new CSAssignment(Resources.createResource((int)0, (int)0), NodeType.NODE_LOCAL);
        while (this.canAssign(clusterResource, node)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Trying to assign containers to child-queue of " + this.getQueueName()));
            }
            if (!super.canAssignToThisQueue(clusterResource, node.getPartition(), resourceLimits, Resources.createResource((long)this.getMetrics().getReservedMB(), (int)this.getMetrics().getReservedVirtualCores(), (int)this.getMetrics().getReservedGPUs()), schedulingMode)) break;
            CSAssignment assignedToChild = this.assignContainersToChildQueues(clusterResource, node, resourceLimits, schedulingMode);
            assignment.setType(assignedToChild.getType());
            if (!Resources.greaterThan((ResourceCalculator)this.resourceCalculator, (Resource)clusterResource, (Resource)assignedToChild.getResource(), (Resource)Resources.none())) {
                assignment.setSkippedType(assignedToChild.getSkippedType());
                break;
            }
            this.allocateResource(clusterResource, assignedToChild.getResource(), node.getPartition(), assignedToChild.isIncreasedAllocation());
            Resources.addTo((Resource)assignment.getResource(), (Resource)assignedToChild.getResource());
            Resources.addTo((Resource)assignment.getAssignmentInformation().getAllocated(), (Resource)assignedToChild.getAssignmentInformation().getAllocated());
            Resources.addTo((Resource)assignment.getAssignmentInformation().getReserved(), (Resource)assignedToChild.getAssignmentInformation().getReserved());
            assignment.getAssignmentInformation().incrAllocations(assignedToChild.getAssignmentInformation().getNumAllocations());
            assignment.getAssignmentInformation().incrReservations(assignedToChild.getAssignmentInformation().getNumReservations());
            assignment.getAssignmentInformation().getAllocationDetails().addAll(assignedToChild.getAssignmentInformation().getAllocationDetails());
            assignment.getAssignmentInformation().getReservationDetails().addAll(assignedToChild.getAssignmentInformation().getReservationDetails());
            assignment.setIncreasedAllocation(assignedToChild.isIncreasedAllocation());
            LOG.info((Object)("assignedContainer queue=" + this.getQueueName() + " usedCapacity=" + this.getUsedCapacity() + " absoluteUsedCapacity=" + this.getAbsoluteUsedCapacity() + " used=" + this.queueUsage.getUsed() + " cluster=" + clusterResource));
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("ParentQ=" + this.getQueueName() + " assignedSoFarInThisIteration=" + assignment.getResource() + " usedCapacity=" + this.getUsedCapacity() + " absoluteUsedCapacity=" + this.getAbsoluteUsedCapacity()));
            }
            if (assignment.getType() == NodeType.OFF_SWITCH) {
                ++offswitchCount;
            }
            if (this.rootQueue && offswitchCount < this.getOffSwitchPerHeartbeatLimit()) continue;
            if (!LOG.isDebugEnabled() || !this.rootQueue || offswitchCount < this.getOffSwitchPerHeartbeatLimit()) break;
            LOG.debug((Object)("Assigned maximum number of off-switch containers: " + offswitchCount + ", assignments so far: " + assignment));
            break;
        }
        return assignment;
    }

    private boolean canAssign(Resource clusterResource, FiCaSchedulerNode node) {
        return node.getReservedContainer() == null && Resources.greaterThanOrEqual((ResourceCalculator)this.resourceCalculator, (Resource)clusterResource, (Resource)Resources.add((Resource)node.getAvailableResource(), (Resource)node.getTotalKillableResources()), (Resource)this.minimumAllocation);
    }

    private ResourceLimits getResourceLimitsOfChild(CSQueue child, Resource clusterResource, Resource parentLimits, String nodePartition) {
        Resource parentMaxAvailableResource = Resources.subtract((Resource)parentLimits, (Resource)this.queueUsage.getUsed(nodePartition));
        Resources.addTo((Resource)parentMaxAvailableResource, (Resource)this.getTotalKillableResource(nodePartition));
        Resource childLimit = Resources.add((Resource)parentMaxAvailableResource, (Resource)child.getQueueResourceUsage().getUsed(nodePartition));
        Resource childConfiguredMaxResource = Resources.multiplyAndNormalizeDown((ResourceCalculator)this.resourceCalculator, (Resource)this.labelManager.getResourceByLabel(nodePartition, clusterResource), (double)child.getQueueCapacities().getAbsoluteMaximumCapacity(nodePartition), (Resource)this.minimumAllocation);
        childLimit = Resources.min((ResourceCalculator)this.resourceCalculator, (Resource)clusterResource, (Resource)childLimit, (Resource)childConfiguredMaxResource);
        childLimit = Resources.roundDown((ResourceCalculator)this.resourceCalculator, (Resource)childLimit, (Resource)this.minimumAllocation);
        return new ResourceLimits(childLimit);
    }

    private Iterator<CSQueue> sortAndGetChildrenAllocationIterator(FiCaSchedulerNode node) {
        if (node.getPartition().equals("")) {
            if (this.needToResortQueuesAtNextAllocation) {
                ArrayList<CSQueue> childrenList = new ArrayList<CSQueue>(this.childQueues);
                this.childQueues.clear();
                this.childQueues.addAll(childrenList);
                this.needToResortQueuesAtNextAllocation = false;
            }
            return this.childQueues.iterator();
        }
        this.partitionQueueComparator.setPartitionToLookAt(node.getPartition());
        ArrayList<CSQueue> childrenList = new ArrayList<CSQueue>(this.childQueues);
        Collections.sort(childrenList, this.partitionQueueComparator);
        return childrenList.iterator();
    }

    private synchronized CSAssignment assignContainersToChildQueues(Resource cluster, FiCaSchedulerNode node, ResourceLimits limits, SchedulingMode schedulingMode) {
        CSAssignment assignment = CSAssignment.NULL_ASSIGNMENT;
        Resource parentLimits = limits.getLimit();
        this.printChildQueues();
        Iterator<CSQueue> iter = this.sortAndGetChildrenAllocationIterator(node);
        while (iter.hasNext()) {
            CSQueue childQueue = iter.next();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Trying to assign to queue: " + childQueue.getQueuePath() + " stats: " + childQueue));
            }
            ResourceLimits childLimits = this.getResourceLimitsOfChild(childQueue, cluster, parentLimits, node.getPartition());
            CSAssignment childAssignment = childQueue.assignContainers(cluster, node, childLimits, schedulingMode);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Assigned to queue: " + childQueue.getQueuePath() + " stats: " + childQueue + " --> " + childAssignment.getResource() + ", " + (Object)((Object)childAssignment.getType())));
            }
            if (Resources.greaterThan((ResourceCalculator)this.resourceCalculator, (Resource)cluster, (Resource)childAssignment.getResource(), (Resource)Resources.none())) {
                if ("".equals(node.getPartition())) {
                    iter.remove();
                    LOG.info((Object)("Re-sorting assigned queue: " + childQueue.getQueuePath() + " stats: " + childQueue));
                    this.childQueues.add(childQueue);
                    if (LOG.isDebugEnabled()) {
                        this.printChildQueues();
                    }
                }
                assignment = childAssignment;
                break;
            }
            if (childAssignment.getSkippedType() != CSAssignment.SkippedType.QUEUE_LIMIT) continue;
            if (assignment.getSkippedType() != CSAssignment.SkippedType.QUEUE_LIMIT) {
                assignment = childAssignment;
            }
            Resource resourceToSubtract = Resources.max((ResourceCalculator)this.resourceCalculator, (Resource)cluster, (Resource)childLimits.getHeadroom(), (Resource)Resources.none());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Decrease parentLimits " + parentLimits + " for " + this.getQueueName() + " by " + resourceToSubtract + " as childQueue=" + childQueue.getQueueName() + " is blocked"));
            }
            parentLimits = Resources.subtract((Resource)parentLimits, (Resource)resourceToSubtract);
        }
        return assignment;
    }

    String getChildQueuesToPrint() {
        StringBuilder sb = new StringBuilder();
        for (CSQueue q : this.childQueues) {
            sb.append(q.getQueuePath() + "usedCapacity=(" + q.getUsedCapacity() + "),  label=(" + StringUtils.join(q.getAccessibleNodeLabels().iterator(), (String)",") + ")");
        }
        return sb.toString();
    }

    private void printChildQueues() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("printChildQueues - queue: " + this.getQueuePath() + " child-queues: " + this.getChildQueuesToPrint()));
        }
    }

    private synchronized void internalReleaseResource(Resource clusterResource, FiCaSchedulerNode node, Resource releasedResource, boolean changeResource, CSQueue completedChildQueue, boolean sortQueues) {
        super.releaseResource(clusterResource, releasedResource, node.getPartition(), changeResource);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("completedContainer " + this + ", cluster=" + clusterResource));
        }
        if (sortQueues) {
            Iterator<CSQueue> iter = this.childQueues.iterator();
            while (iter.hasNext()) {
                CSQueue csqueue = iter.next();
                if (!csqueue.equals(completedChildQueue)) continue;
                iter.remove();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Re-sorting completed queue: " + csqueue));
                }
                this.childQueues.add(csqueue);
                break;
            }
        }
        this.needToResortQueuesAtNextAllocation = !sortQueues;
    }

    @Override
    public void decreaseContainer(Resource clusterResource, SchedContainerChangeRequest decreaseRequest, FiCaSchedulerApp app) throws InvalidResourceRequestException {
        Resource absDeltaCapacity = Resources.negate((Resource)decreaseRequest.getDeltaCapacity());
        this.internalReleaseResource(clusterResource, this.csContext.getNode(decreaseRequest.getNodeId()), absDeltaCapacity, false, null, false);
        if (this.parent != null) {
            this.parent.decreaseContainer(clusterResource, decreaseRequest, app);
        }
    }

    @Override
    public void unreserveIncreasedContainer(Resource clusterResource, FiCaSchedulerApp app, FiCaSchedulerNode node, RMContainer rmContainer) {
        if (app != null) {
            this.internalReleaseResource(clusterResource, node, rmContainer.getReservedResource(), false, null, false);
            if (this.parent != null) {
                this.parent.unreserveIncreasedContainer(clusterResource, app, node, rmContainer);
            }
        }
    }

    @Override
    public void completedContainer(Resource clusterResource, FiCaSchedulerApp application, FiCaSchedulerNode node, RMContainer rmContainer, ContainerStatus containerStatus, RMContainerEventType event, CSQueue completedChildQueue, boolean sortQueues) {
        if (application != null) {
            this.internalReleaseResource(clusterResource, node, rmContainer.getContainer().getResource(), false, completedChildQueue, sortQueues);
            if (this.parent != null) {
                this.parent.completedContainer(clusterResource, application, node, rmContainer, null, event, this, sortQueues);
            }
        }
    }

    @Override
    public synchronized void updateClusterResource(Resource clusterResource, ResourceLimits resourceLimits) {
        for (CSQueue childQueue : this.childQueues) {
            ResourceLimits childLimits = this.getResourceLimitsOfChild(childQueue, clusterResource, resourceLimits.getLimit(), "");
            childQueue.updateClusterResource(clusterResource, childLimits);
        }
        CSQueueUtils.updateQueueStatistics(this.resourceCalculator, clusterResource, this.minimumAllocation, this, this.labelManager, null);
    }

    @Override
    public synchronized List<CSQueue> getChildQueues() {
        return new ArrayList<CSQueue>(this.childQueues);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recoverContainer(Resource clusterResource, SchedulerApplicationAttempt attempt, RMContainer rmContainer) {
        if (rmContainer.getState().equals((Object)RMContainerState.COMPLETED)) {
            return;
        }
        ParentQueue parentQueue = this;
        synchronized (parentQueue) {
            FiCaSchedulerNode node = this.scheduler.getNode(rmContainer.getContainer().getNodeId());
            this.allocateResource(clusterResource, rmContainer.getContainer().getResource(), node.getPartition(), false);
        }
        if (this.parent != null) {
            this.parent.recoverContainer(clusterResource, attempt, rmContainer);
        }
    }

    @Override
    public ActiveUsersManager getActiveUsersManager() {
        return null;
    }

    @Override
    public synchronized void collectSchedulerApplications(Collection<ApplicationAttemptId> apps) {
        for (CSQueue queue : this.childQueues) {
            queue.collectSchedulerApplications(apps);
        }
    }

    @Override
    public void attachContainer(Resource clusterResource, FiCaSchedulerApp application, RMContainer rmContainer) {
        if (application != null) {
            FiCaSchedulerNode node = this.scheduler.getNode(rmContainer.getContainer().getNodeId());
            this.allocateResource(clusterResource, rmContainer.getContainer().getResource(), node.getPartition(), false);
            LOG.info((Object)("movedContainer queueMoveIn=" + this.getQueueName() + " usedCapacity=" + this.getUsedCapacity() + " absoluteUsedCapacity=" + this.getAbsoluteUsedCapacity() + " used=" + this.queueUsage.getUsed() + " cluster=" + clusterResource));
            if (this.parent != null) {
                this.parent.attachContainer(clusterResource, application, rmContainer);
            }
        }
    }

    @Override
    public void detachContainer(Resource clusterResource, FiCaSchedulerApp application, RMContainer rmContainer) {
        if (application != null) {
            FiCaSchedulerNode node = this.scheduler.getNode(rmContainer.getContainer().getNodeId());
            super.releaseResource(clusterResource, rmContainer.getContainer().getResource(), node.getPartition(), false);
            LOG.info((Object)("movedContainer queueMoveOut=" + this.getQueueName() + " usedCapacity=" + this.getUsedCapacity() + " absoluteUsedCapacity=" + this.getAbsoluteUsedCapacity() + " used=" + this.queueUsage.getUsed() + " cluster=" + clusterResource));
            if (this.parent != null) {
                this.parent.detachContainer(clusterResource, application, rmContainer);
            }
        }
    }

    @Override
    public synchronized int getNumApplications() {
        return this.numApplications;
    }

    @Override
    synchronized void allocateResource(Resource clusterResource, Resource resource, String nodePartition, boolean changeContainerResource) {
        super.allocateResource(clusterResource, resource, nodePartition, changeContainerResource);
        if (this.getQueueCapacities().getAbsoluteMaximumCapacity(nodePartition) < this.getQueueCapacities().getAbsoluteUsedCapacity(nodePartition)) {
            this.killContainersToEnforceMaxQueueCapacity(nodePartition, clusterResource);
        }
    }

    private void killContainersToEnforceMaxQueueCapacity(String partition, Resource clusterResource) {
        Iterator<RMContainer> killableContainerIter = this.getKillableContainers(partition);
        if (!killableContainerIter.hasNext()) {
            return;
        }
        Resource partitionResource = this.labelManager.getResourceByLabel(partition, null);
        Resource maxResource = Resources.multiply((Resource)partitionResource, (double)this.getQueueCapacities().getAbsoluteMaximumCapacity(partition));
        while (Resources.greaterThan((ResourceCalculator)this.resourceCalculator, (Resource)partitionResource, (Resource)this.queueUsage.getUsed(partition), (Resource)maxResource)) {
            RMContainer toKillContainer = killableContainerIter.next();
            FiCaSchedulerApp attempt = this.csContext.getApplicationAttempt(toKillContainer.getContainerId().getApplicationAttemptId());
            FiCaSchedulerNode node = this.csContext.getNode(toKillContainer.getAllocatedNode());
            if (null != attempt && null != node) {
                LeafQueue lq = attempt.getCSLeafQueue();
                lq.completedContainer(clusterResource, attempt, node, toKillContainer, SchedulerUtils.createPreemptedContainerStatus(toKillContainer.getContainerId(), "Container preempted by scheduler"), RMContainerEventType.KILL, null, false);
                LOG.info((Object)("Killed container=" + toKillContainer.getContainerId() + " from queue=" + lq.getQueueName() + " to make queue=" + this.getQueueName() + "'s max-capacity enforced"));
            }
            if (killableContainerIter.hasNext()) continue;
            break;
        }
    }
}

