/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.Groups;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.api.records.QueueUserACLInfo;
import org.apache.hadoop.yarn.api.records.ReservationId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceOption;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.api.records.UpdateContainerRequest;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.exceptions.InvalidResourceRequestException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.proto.YarnServiceProtos;
import org.apache.hadoop.yarn.security.YarnAuthorizationProvider;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.placement.PlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.placement.UserGroupMappingPlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.ApplicationStateData;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerState;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeDecreaseContainerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeResourceUpdateEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.UpdatedContainerInfo;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AbstractYarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Allocation;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AppSchedulingInfo;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.NodeType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.PreemptableResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Queue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueInvalidException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceLimits;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceUsage;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedContainerChangeRequest;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplication;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplicationAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerDynamicEditException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerHealth;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AbstractCSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSAssignment;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.PartitionedQueueComparator;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.PlanQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ReservationQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.SchedulingMode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.preemption.KillableContainer;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.preemption.PreemptionManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.AssignmentInformation;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.QueueEntitlement;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAttemptAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAttemptRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.ContainerExpiredSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.ContainerPreemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeLabelsUpdateSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeResourceUpdateSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeUpdateSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMContainerTokenSecretManager;
import org.apache.hadoop.yarn.server.utils.Lock;
import org.apache.hadoop.yarn.util.resource.DefaultResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;

@InterfaceAudience.LimitedPrivate(value={"yarn"})
@InterfaceStability.Evolving
public class CapacityScheduler
extends AbstractYarnScheduler<FiCaSchedulerApp, FiCaSchedulerNode>
implements PreemptableResourceScheduler,
CapacitySchedulerContext,
Configurable {
    private static final Log LOG = LogFactory.getLog(CapacityScheduler.class);
    private YarnAuthorizationProvider authorizer;
    private CSQueue root;
    protected final long THREAD_JOIN_TIMEOUT_MS = 1000L;
    private PreemptionManager preemptionManager = new PreemptionManager();
    private volatile boolean isLazyPreemptionEnabled = false;
    static final Comparator<CSQueue> nonPartitionedQueueComparator = new Comparator<CSQueue>(){

        @Override
        public int compare(CSQueue q1, CSQueue q2) {
            if (q1.getUsedCapacity() < q2.getUsedCapacity()) {
                return -1;
            }
            if (q1.getUsedCapacity() > q2.getUsedCapacity()) {
                return 1;
            }
            return q1.getQueuePath().compareTo(q2.getQueuePath());
        }
    };
    static final PartitionedQueueComparator partitionedQueueComparator = new PartitionedQueueComparator();
    private CapacitySchedulerConfiguration conf;
    private Configuration yarnConf;
    private Map<String, CSQueue> queues = new ConcurrentHashMap<String, CSQueue>();
    private AtomicInteger numNodeManagers = new AtomicInteger(0);
    private ResourceCalculator calculator;
    private boolean usePortForNodeName;
    private boolean scheduleAsynchronously;
    private AsyncScheduleThread asyncSchedulerThread;
    private RMNodeLabelsManager labelManager;
    private SchedulerHealth schedulerHealth = new SchedulerHealth();
    volatile long lastNodeUpdateTime;
    private long asyncScheduleInterval;
    private static final String ASYNC_SCHEDULER_INTERVAL = "yarn.scheduler.capacity.schedule-asynchronously.scheduling-interval-ms";
    private static final long DEFAULT_ASYNC_SCHEDULER_INTERVAL = 5L;
    private static final Random random = new Random(System.currentTimeMillis());
    @InterfaceAudience.Private
    public static final String ROOT_QUEUE = "yarn.scheduler.capacity.root";
    private static final QueueHook noop = new QueueHook();

    public void setConf(Configuration conf) {
        this.yarnConf = conf;
    }

    private void validateConf(Configuration conf) {
        int minMem = conf.getInt("yarn.scheduler.minimum-allocation-mb", 1024);
        int maxMem = conf.getInt("yarn.scheduler.maximum-allocation-mb", 8192);
        if (minMem <= 0 || minMem > maxMem) {
            throw new YarnRuntimeException("Invalid resource scheduler memory allocation configuration, yarn.scheduler.minimum-allocation-mb=" + minMem + ", " + "yarn.scheduler.maximum-allocation-mb" + "=" + maxMem + ", min and max should be greater than 0, max should be no smaller than min.");
        }
        int minVcores = conf.getInt("yarn.scheduler.minimum-allocation-vcores", 1);
        int maxVcores = conf.getInt("yarn.scheduler.maximum-allocation-vcores", 4);
        if (minVcores <= 0 || minVcores > maxVcores) {
            throw new YarnRuntimeException("Invalid resource scheduler vcores allocation configuration, yarn.scheduler.minimum-allocation-vcores=" + minVcores + ", " + "yarn.scheduler.maximum-allocation-vcores" + "=" + maxVcores + ", min and max should be greater than 0, max should be no smaller than min.");
        }
        int minGPUs = conf.getInt("yarn.scheduler.minimum-allocation-gpus", 0);
        int maxGPUs = conf.getInt("yarn.scheduler.maximum-allocation-gpus", 8);
        if (minGPUs < 0 || minGPUs > maxGPUs) {
            throw new YarnRuntimeException("Invalid resource scheduler GPUs allocation configuration, yarn.scheduler.minimum-allocation-gpus=" + minGPUs + ", " + "yarn.scheduler.maximum-allocation-gpus" + "=" + maxGPUs + ", min and max should be greater than 0, max should be no smaller than min.");
        }
    }

    @Override
    public Configuration getConf() {
        return this.yarnConf;
    }

    public CapacityScheduler() {
        super(CapacityScheduler.class.getName());
    }

    @Override
    public QueueMetrics getRootQueueMetrics() {
        return this.root.getMetrics();
    }

    public CSQueue getRootQueue() {
        return this.root;
    }

    @Override
    public CapacitySchedulerConfiguration getConfiguration() {
        return this.conf;
    }

    @Override
    public synchronized RMContainerTokenSecretManager getContainerTokenSecretManager() {
        return this.rmContext.getContainerTokenSecretManager();
    }

    @Override
    public ResourceCalculator getResourceCalculator() {
        return this.calculator;
    }

    @Override
    public Comparator<CSQueue> getNonPartitionedQueueComparator() {
        return nonPartitionedQueueComparator;
    }

    @Override
    public PartitionedQueueComparator getPartitionedQueueComparator() {
        return partitionedQueueComparator;
    }

    @Override
    public int getNumClusterNodes() {
        return this.numNodeManagers.get();
    }

    @Override
    public synchronized RMContext getRMContext() {
        return this.rmContext;
    }

    @Override
    public synchronized void setRMContext(RMContext rmContext) {
        this.rmContext = rmContext;
    }

    private synchronized void initScheduler(Configuration configuration) throws IOException {
        this.conf = this.loadCapacitySchedulerConfiguration(configuration);
        this.validateConf(this.conf);
        this.minimumAllocation = this.conf.getMinimumAllocation();
        this.initMaximumResourceCapability(this.conf.getMaximumAllocation());
        this.calculator = this.conf.getResourceCalculator();
        this.usePortForNodeName = this.conf.getUsePortForNodeName();
        this.applications = new ConcurrentHashMap();
        this.labelManager = this.rmContext.getNodeLabelManager();
        this.authorizer = YarnAuthorizationProvider.getInstance((Configuration)this.yarnConf);
        this.initializeQueues(this.conf);
        this.isLazyPreemptionEnabled = this.conf.getLazyPreemptionEnabled();
        this.scheduleAsynchronously = this.conf.getScheduleAynschronously();
        this.asyncScheduleInterval = this.conf.getLong(ASYNC_SCHEDULER_INTERVAL, 5L);
        if (this.scheduleAsynchronously) {
            this.asyncSchedulerThread = new AsyncScheduleThread(this);
        }
        LOG.info((Object)("Initialized CapacityScheduler with calculator=" + this.getResourceCalculator().getClass() + ", minimumAllocation=<" + this.getMinimumResourceCapability() + ">, maximumAllocation=<" + this.getMaximumResourceCapability() + ">, asynchronousScheduling=" + this.scheduleAsynchronously + ", asyncScheduleInterval=" + this.asyncScheduleInterval + "ms"));
    }

    private synchronized void startSchedulerThreads() {
        if (this.scheduleAsynchronously) {
            Preconditions.checkNotNull((Object)this.asyncSchedulerThread, (Object)"asyncSchedulerThread is null");
            this.asyncSchedulerThread.start();
        }
    }

    @Override
    public void serviceInit(Configuration conf) throws Exception {
        Configuration configuration = new Configuration(conf);
        super.serviceInit(conf);
        this.initScheduler(configuration);
    }

    public void serviceStart() throws Exception {
        this.startSchedulerThreads();
        super.serviceStart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceStop() throws Exception {
        CapacityScheduler capacityScheduler = this;
        synchronized (capacityScheduler) {
            if (this.scheduleAsynchronously && this.asyncSchedulerThread != null) {
                this.asyncSchedulerThread.interrupt();
                this.asyncSchedulerThread.join(1000L);
            }
        }
        super.serviceStop();
    }

    @Override
    public synchronized void reinitialize(Configuration conf, RMContext rmContext) throws IOException {
        Configuration configuration = new Configuration(conf);
        CapacitySchedulerConfiguration oldConf = this.conf;
        this.conf = this.loadCapacitySchedulerConfiguration(configuration);
        this.validateConf(this.conf);
        try {
            LOG.info((Object)"Re-initializing queues...");
            this.refreshMaximumAllocation(this.conf.getMaximumAllocation());
            this.reinitializeQueues(this.conf);
        }
        catch (Throwable t) {
            this.conf = oldConf;
            this.refreshMaximumAllocation(this.conf.getMaximumAllocation());
            throw new IOException("Failed to re-init queues", t);
        }
        this.isLazyPreemptionEnabled = this.conf.getLazyPreemptionEnabled();
    }

    long getAsyncScheduleInterval() {
        return this.asyncScheduleInterval;
    }

    static void schedule(CapacityScheduler cs) {
        int current = 0;
        Collection<FiCaSchedulerNode> nodes = cs.getAllNodes().values();
        int start = random.nextInt(nodes.size());
        for (FiCaSchedulerNode node : nodes) {
            if (current++ < start) continue;
            cs.allocateContainersToNode(node);
        }
        for (FiCaSchedulerNode node : nodes) {
            cs.allocateContainersToNode(node);
        }
        try {
            Thread.sleep(cs.getAsyncScheduleInterval());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @VisibleForTesting
    public synchronized UserGroupMappingPlacementRule getUserGroupMappingPlacementRule() throws IOException {
        boolean overrideWithQueueMappings = this.conf.getOverrideWithQueueMappings();
        LOG.info((Object)("Initialized queue mappings, override: " + overrideWithQueueMappings));
        List<UserGroupMappingPlacementRule.QueueMapping> newMappings = this.conf.getQueueMappings();
        for (UserGroupMappingPlacementRule.QueueMapping mapping : newMappings) {
            CSQueue queue;
            String mappingQueue = mapping.getQueue();
            if (mappingQueue.equals("%user") || mappingQueue.equals("%primary_group") || (queue = this.queues.get(mappingQueue)) != null && queue instanceof LeafQueue) continue;
            throw new IOException("mapping contains invalid or non-leaf queue " + mappingQueue);
        }
        if (newMappings.size() > 0) {
            Groups groups = new Groups((Configuration)this.conf);
            return new UserGroupMappingPlacementRule(overrideWithQueueMappings, newMappings, groups);
        }
        return null;
    }

    private void updatePlacementRules() throws IOException {
        ArrayList<PlacementRule> placementRules = new ArrayList<PlacementRule>();
        UserGroupMappingPlacementRule ugRule = this.getUserGroupMappingPlacementRule();
        if (null != ugRule) {
            placementRules.add(ugRule);
        }
        this.rmContext.getQueuePlacementManager().updateRules(placementRules);
    }

    @Lock(value={CapacityScheduler.class})
    private void initializeQueues(CapacitySchedulerConfiguration conf) throws IOException {
        this.root = CapacityScheduler.parseQueue(this, conf, null, "root", this.queues, this.queues, noop);
        this.labelManager.reinitializeQueueLabels(this.getQueueToLabels());
        LOG.info((Object)("Initialized root queue " + this.root));
        this.updatePlacementRules();
        CapacityScheduler.setQueueAcls(this.authorizer, this.queues);
        this.preemptionManager.refreshQueues(null, this.root);
    }

    @Lock(value={CapacityScheduler.class})
    private void reinitializeQueues(CapacitySchedulerConfiguration conf) throws IOException {
        HashMap<String, CSQueue> newQueues = new HashMap<String, CSQueue>();
        CSQueue newRoot = CapacityScheduler.parseQueue(this, conf, null, "root", newQueues, this.queues, noop);
        this.validateExistingQueues(this.queues, newQueues);
        this.addNewQueues(this.queues, newQueues);
        this.root.reinitialize(newRoot, this.clusterResource);
        this.updatePlacementRules();
        this.root.updateClusterResource(this.clusterResource, new ResourceLimits(this.clusterResource));
        this.labelManager.reinitializeQueueLabels(this.getQueueToLabels());
        CapacityScheduler.setQueueAcls(this.authorizer, this.queues);
        this.preemptionManager.refreshQueues(null, this.root);
    }

    @VisibleForTesting
    public static void setQueueAcls(YarnAuthorizationProvider authorizer, Map<String, CSQueue> queues) throws IOException {
        for (CSQueue queue : queues.values()) {
            AbstractCSQueue csQueue = (AbstractCSQueue)queue;
            authorizer.setPermission(csQueue.getPrivilegedEntity(), csQueue.getACLs(), UserGroupInformation.getCurrentUser());
        }
    }

    private Map<String, Set<String>> getQueueToLabels() {
        HashMap<String, Set<String>> queueToLabels = new HashMap<String, Set<String>>();
        for (CSQueue queue : this.queues.values()) {
            queueToLabels.put(queue.getQueueName(), queue.getAccessibleNodeLabels());
        }
        return queueToLabels;
    }

    @Lock(value={CapacityScheduler.class})
    private void validateExistingQueues(Map<String, CSQueue> queues, Map<String, CSQueue> newQueues) throws IOException {
        for (Map.Entry<String, CSQueue> e : queues.entrySet()) {
            if (e.getValue() instanceof ReservationQueue) continue;
            String queueName = e.getKey();
            CSQueue oldQueue = e.getValue();
            CSQueue newQueue = newQueues.get(queueName);
            if (null == newQueue) {
                throw new IOException(queueName + " cannot be found during refresh!");
            }
            if (oldQueue.getQueuePath().equals(newQueue.getQueuePath())) continue;
            throw new IOException(queueName + " is moved from:" + oldQueue.getQueuePath() + " to:" + newQueue.getQueuePath() + " after refresh, which is not allowed.");
        }
    }

    @Lock(value={CapacityScheduler.class})
    private void addNewQueues(Map<String, CSQueue> queues, Map<String, CSQueue> newQueues) {
        for (Map.Entry<String, CSQueue> e : newQueues.entrySet()) {
            String queueName = e.getKey();
            CSQueue queue = e.getValue();
            if (queues.containsKey(queueName)) continue;
            queues.put(queueName, queue);
        }
    }

    @Lock(value={CapacityScheduler.class})
    static CSQueue parseQueue(CapacitySchedulerContext csContext, CapacitySchedulerConfiguration conf, CSQueue parent, String queueName, Map<String, CSQueue> queues, Map<String, CSQueue> oldQueues, QueueHook hook) throws IOException {
        CSQueue queue;
        String fullQueueName = parent == null ? queueName : parent.getQueuePath() + "." + queueName;
        String[] childQueueNames = conf.getQueues(fullQueueName);
        boolean isReservableQueue = conf.isReservable(fullQueueName);
        if (childQueueNames == null || childQueueNames.length == 0) {
            if (null == parent) {
                throw new IllegalStateException("Queue configuration missing child queue names for " + queueName);
            }
            if (isReservableQueue) {
                queue = new PlanQueue(csContext, queueName, parent, oldQueues.get(queueName));
            } else {
                queue = new LeafQueue(csContext, queueName, parent, oldQueues.get(queueName));
                queue = hook.hook(queue);
            }
        } else {
            if (isReservableQueue) {
                throw new IllegalStateException("Only Leaf Queues can be reservable for " + queueName);
            }
            ParentQueue parentQueue = new ParentQueue(csContext, queueName, parent, oldQueues.get(queueName));
            queue = hook.hook(parentQueue);
            ArrayList<CSQueue> childQueues = new ArrayList<CSQueue>();
            for (String childQueueName : childQueueNames) {
                CSQueue childQueue = CapacityScheduler.parseQueue(csContext, conf, queue, childQueueName, queues, oldQueues, hook);
                childQueues.add(childQueue);
            }
            parentQueue.setChildQueues(childQueues);
        }
        if (queue instanceof LeafQueue && queues.containsKey(queueName) && queues.get(queueName) instanceof LeafQueue) {
            throw new IOException("Two leaf queues were named " + queueName + ". Leaf queue names must be distinct");
        }
        queues.put(queueName, queue);
        LOG.info((Object)("Initialized queue: " + queue));
        return queue;
    }

    public CSQueue getQueue(String queueName) {
        if (queueName == null) {
            return null;
        }
        return this.queues.get(queueName);
    }

    private synchronized void addApplicationOnRecovery(ApplicationId applicationId, String queueName, String user, Priority priority) {
        CSQueue queue = this.getQueue(queueName);
        if (queue == null) {
            if (!YarnConfiguration.shouldRMFailFast((Configuration)this.getConfig())) {
                this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppEvent(applicationId, RMAppEventType.KILL, "Application killed on recovery as it was submitted to queue " + queueName + " which no longer exists after restart."));
                return;
            }
            String queueErrorMsg = "Queue named " + queueName + " missing during application recovery. Queue removal during recovery is not presently supported by the capacity scheduler, please restart with all queues configured which were present before shutdown/restart.";
            LOG.fatal((Object)queueErrorMsg);
            throw new QueueInvalidException(queueErrorMsg);
        }
        if (!(queue instanceof LeafQueue)) {
            if (!YarnConfiguration.shouldRMFailFast((Configuration)this.getConfig())) {
                this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppEvent(applicationId, RMAppEventType.KILL, "Application killed on recovery as it was submitted to queue " + queueName + " which is no longer a leaf queue after restart."));
                return;
            }
            String queueErrorMsg = "Queue named " + queueName + " is no longer a leaf queue during application recovery. Changing a leaf queue to a parent queue during recovery is not presently supported by the capacity scheduler. Please restart with leaf queues before shutdown/restart continuing as leaf queues.";
            LOG.fatal((Object)queueErrorMsg);
            throw new QueueInvalidException(queueErrorMsg);
        }
        try {
            queue.submitApplication(applicationId, user, queueName);
        }
        catch (AccessControlException queueErrorMsg) {
            // empty catch block
        }
        queue.getMetrics().submitApp(user);
        SchedulerApplication application = new SchedulerApplication(queue, user, priority);
        this.applications.put(applicationId, application);
        LOG.info((Object)("Accepted application " + applicationId + " from user: " + user + ", in queue: " + queueName));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(applicationId + " is recovering. Skip notifying APP_ACCEPTED"));
        }
    }

    private synchronized void addApplication(ApplicationId applicationId, String queueName, String user, Priority priority) {
        CSQueue queue = this.getQueue(queueName);
        if (queue == null) {
            String message = "Application " + applicationId + " submitted by user " + user + " to unknown queue: " + queueName;
            this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppEvent(applicationId, RMAppEventType.APP_REJECTED, message));
            return;
        }
        if (!(queue instanceof LeafQueue)) {
            String message = "Application " + applicationId + " submitted by user " + user + " to non-leaf queue: " + queueName;
            this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppEvent(applicationId, RMAppEventType.APP_REJECTED, message));
            return;
        }
        try {
            queue.submitApplication(applicationId, user, queueName);
        }
        catch (AccessControlException ace) {
            LOG.info((Object)("Failed to submit application " + applicationId + " to queue " + queueName + " from user " + user), (Throwable)ace);
            this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppEvent(applicationId, RMAppEventType.APP_REJECTED, ace.toString()));
            return;
        }
        queue.getMetrics().submitApp(user);
        SchedulerApplication application = new SchedulerApplication(queue, user, priority);
        this.applications.put(applicationId, application);
        LOG.info((Object)("Accepted application " + applicationId + " from user: " + user + ", in queue: " + queueName));
        this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppEvent(applicationId, RMAppEventType.APP_ACCEPTED));
    }

    private synchronized void addApplicationAttempt(ApplicationAttemptId applicationAttemptId, boolean transferStateFromPreviousAttempt, boolean isAttemptRecovering) {
        SchedulerApplication application = (SchedulerApplication)this.applications.get(applicationAttemptId.getApplicationId());
        if (application == null) {
            LOG.warn((Object)("Application " + applicationAttemptId.getApplicationId() + " cannot be found in scheduler."));
            return;
        }
        CSQueue queue = (CSQueue)application.getQueue();
        FiCaSchedulerApp attempt = new FiCaSchedulerApp(applicationAttemptId, application.getUser(), queue, queue.getActiveUsersManager(), this.rmContext, application.getPriority(), isAttemptRecovering);
        if (transferStateFromPreviousAttempt) {
            attempt.transferStateFromPreviousAttempt((SchedulerApplicationAttempt)application.getCurrentAppAttempt());
        }
        application.setCurrentAppAttempt(attempt);
        attempt.setPriority(application.getPriority());
        queue.submitApplicationAttempt(attempt, application.getUser());
        LOG.info((Object)("Added Application Attempt " + applicationAttemptId + " to scheduler from user " + application.getUser() + " in queue " + queue.getQueueName()));
        if (isAttemptRecovering) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(applicationAttemptId + " is recovering. Skipping notifying ATTEMPT_ADDED"));
            }
        } else {
            this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppAttemptEvent(applicationAttemptId, RMAppAttemptEventType.ATTEMPT_ADDED));
        }
    }

    private synchronized void doneApplication(ApplicationId applicationId, RMAppState finalState) {
        SchedulerApplication application = (SchedulerApplication)this.applications.get(applicationId);
        if (application == null) {
            LOG.warn((Object)("Couldn't find application " + applicationId));
            return;
        }
        CSQueue queue = (CSQueue)application.getQueue();
        if (!(queue instanceof LeafQueue)) {
            LOG.error((Object)("Cannot finish application from non-leaf queue: " + queue.getQueueName()));
        } else {
            queue.finishApplication(applicationId, application.getUser());
        }
        application.stop(finalState);
        this.applications.remove(applicationId);
    }

    private synchronized void doneApplicationAttempt(ApplicationAttemptId applicationAttemptId, RMAppAttemptState rmAppAttemptFinalState, boolean keepContainers) {
        LOG.info((Object)("Application Attempt " + applicationAttemptId + " is done. finalState=" + (Object)((Object)rmAppAttemptFinalState)));
        FiCaSchedulerApp attempt = this.getApplicationAttempt(applicationAttemptId);
        SchedulerApplication application = (SchedulerApplication)this.applications.get(applicationAttemptId.getApplicationId());
        if (application == null || attempt == null) {
            LOG.info((Object)("Unknown application " + applicationAttemptId + " has completed!"));
            return;
        }
        for (RMContainer rmContainer : attempt.getLiveContainers()) {
            if (keepContainers && rmContainer.getState().equals((Object)RMContainerState.RUNNING)) {
                LOG.info((Object)("Skip killing " + rmContainer.getContainerId()));
                continue;
            }
            super.completedContainer(rmContainer, SchedulerUtils.createAbnormalContainerStatus(rmContainer.getContainerId(), "Container of a completed application"), RMContainerEventType.KILL);
        }
        for (RMContainer rmContainer : attempt.getReservedContainers()) {
            super.completedContainer(rmContainer, SchedulerUtils.createAbnormalContainerStatus(rmContainer.getContainerId(), "Application Complete"), RMContainerEventType.KILL);
        }
        attempt.stop(rmAppAttemptFinalState);
        String queueName = attempt.getQueue().getQueueName();
        CSQueue queue = this.queues.get(queueName);
        if (!(queue instanceof LeafQueue)) {
            LOG.error((Object)("Cannot finish application from non-leaf queue: " + queueName));
        } else {
            queue.finishApplicationAttempt(attempt, queue.getQueueName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LeafQueue updateIncreaseRequests(List<UpdateContainerRequest> increaseRequests, FiCaSchedulerApp app) {
        LeafQueue leafQueue;
        if (null == increaseRequests || increaseRequests.isEmpty()) {
            return null;
        }
        List<SchedContainerChangeRequest> schedIncreaseRequests = this.createSchedContainerChangeRequests(increaseRequests, true);
        LeafQueue leafQueue2 = leafQueue = (LeafQueue)app.getQueue();
        synchronized (leafQueue2) {
            if (app.isStopped()) {
                return null;
            }
            if (app.updateIncreaseRequests(schedIncreaseRequests)) {
                return leafQueue;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Lock(value={Lock.NoLock.class})
    public Allocation allocate(ApplicationAttemptId applicationAttemptId, List<ResourceRequest> ask, List<ContainerId> release, List<String> blacklistAdditions, List<String> blacklistRemovals, List<UpdateContainerRequest> increaseRequests, List<UpdateContainerRequest> decreaseRequests) {
        Allocation allocation;
        FiCaSchedulerApp application = this.getApplicationAttempt(applicationAttemptId);
        if (application == null) {
            return EMPTY_ALLOCATION;
        }
        this.releaseContainers(release, application);
        LeafQueue updateDemandForQueue = this.updateIncreaseRequests(increaseRequests, application);
        this.decreaseContainers(decreaseRequests, application);
        SchedulerUtils.normalizeRequests(ask, this.getResourceCalculator(), this.getClusterResource(), this.getMinimumResourceCapability(), this.getMaximumResourceCapability());
        FiCaSchedulerApp fiCaSchedulerApp = application;
        synchronized (fiCaSchedulerApp) {
            if (application.isStopped()) {
                return EMPTY_ALLOCATION;
            }
            if (!ask.isEmpty()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("allocate: pre-update " + applicationAttemptId + " ask size =" + ask.size()));
                    application.showRequests();
                }
                if (application.updateResourceRequests(ask) && updateDemandForQueue == null) {
                    updateDemandForQueue = (LeafQueue)application.getQueue();
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"allocate: post-update");
                    application.showRequests();
                }
            }
            application.updateBlacklist(blacklistAdditions, blacklistRemovals);
            allocation = application.getAllocation(this.getResourceCalculator(), this.clusterResource, this.getMinimumResourceCapability());
        }
        if (updateDemandForQueue != null && !application.isWaitingForAMContainer()) {
            updateDemandForQueue.getOrderingPolicy().demandUpdated(application);
        }
        return allocation;
    }

    @Override
    @Lock(value={Lock.NoLock.class})
    public QueueInfo getQueueInfo(String queueName, boolean includeChildQueues, boolean recursive) throws IOException {
        CSQueue queue = null;
        queue = this.queues.get(queueName);
        if (queue == null) {
            throw new IOException("Unknown queue: " + queueName);
        }
        return queue.getQueueInfo(includeChildQueues, recursive);
    }

    @Override
    @Lock(value={Lock.NoLock.class})
    public List<QueueUserACLInfo> getQueueUserAclInfo() {
        UserGroupInformation user = null;
        try {
            user = UserGroupInformation.getCurrentUser();
        }
        catch (IOException ioe) {
            return new ArrayList<QueueUserACLInfo>();
        }
        return this.root.getQueueUserAclInfo(user);
    }

    /*
     * WARNING - void declaration
     */
    private synchronized void nodeUpdate(RMNode nm) {
        void var8_13;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("nodeUpdate: " + nm + " clusterResources: " + this.clusterResource));
        }
        Resource releaseResources = Resource.newInstance((int)0, (int)0);
        FiCaSchedulerNode node = this.getNode(nm.getNodeID());
        List<UpdatedContainerInfo> containerInfoList = nm.pullContainerUpdates();
        ArrayList<ContainerStatus> newlyLaunchedContainers = new ArrayList<ContainerStatus>();
        ArrayList<ContainerStatus> completedContainers = new ArrayList<ContainerStatus>();
        for (UpdatedContainerInfo updatedContainerInfo : containerInfoList) {
            newlyLaunchedContainers.addAll(updatedContainerInfo.getNewlyLaunchedContainers());
            completedContainers.addAll(updatedContainerInfo.getCompletedContainers());
        }
        for (ContainerStatus containerStatus : newlyLaunchedContainers) {
            this.containerLaunchedOnNode(containerStatus.getContainerId(), node);
        }
        List<Container> newlyIncreasedContainers = nm.pullNewlyIncreasedContainers();
        for (Container container : newlyIncreasedContainers) {
            this.containerIncreasedOnNode(container.getId(), node, container);
        }
        boolean bl = false;
        for (ContainerStatus completedContainer : completedContainers) {
            ContainerId containerId = completedContainer.getContainerId();
            RMContainer container = this.getRMContainer(containerId);
            super.completedContainer(container, completedContainer, RMContainerEventType.FINISHED);
            node.releaseContainer(containerId, true);
            if (container == null) continue;
            ++var8_13;
            Resource rs = container.getAllocatedResource();
            if (rs != null) {
                Resources.addTo((Resource)releaseResources, (Resource)rs);
            }
            if ((rs = container.getReservedResource()) == null) continue;
            Resources.addTo((Resource)releaseResources, (Resource)rs);
        }
        if (nm.getState() == NodeState.DECOMMISSIONING) {
            this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMNodeResourceUpdateEvent(nm.getNodeID(), ResourceOption.newInstance((Resource)this.getSchedulerNode(nm.getNodeID()).getUsedResource(), (int)0)));
        }
        this.schedulerHealth.updateSchedulerReleaseDetails(this.lastNodeUpdateTime, releaseResources);
        this.schedulerHealth.updateSchedulerReleaseCounts((long)var8_13);
        node.setAggregatedContainersUtilization(nm.getAggregatedContainersUtilization());
        node.setNodeUtilization(nm.getNodeUtilization());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Node being looked for scheduling " + nm + " availableResource: " + node.getAvailableResource()));
        }
    }

    private synchronized void updateNodeAndQueueResource(RMNode nm, ResourceOption resourceOption) {
        this.updateNodeResource(nm, resourceOption);
        this.root.updateClusterResource(this.clusterResource, new ResourceLimits(this.clusterResource));
    }

    private synchronized void updateLabelsOnNode(NodeId nodeId, Set<String> newLabels) {
        FiCaSchedulerNode node = (FiCaSchedulerNode)this.nodes.get(nodeId);
        if (null == node) {
            return;
        }
        String newPartition = newLabels.isEmpty() ? "" : newLabels.iterator().next();
        String oldPartition = node.getPartition();
        for (RMContainer rmContainer : node.getCopiedListOfRunningContainers()) {
            FiCaSchedulerApp application = this.getApplicationAttempt(rmContainer.getApplicationAttemptId());
            if (null != application) {
                application.nodePartitionUpdated(rmContainer, oldPartition, newPartition);
                continue;
            }
            LOG.warn((Object)("There's something wrong, some RMContainers running on a node, but we cannot find SchedulerApplicationAttempt for it. Node=" + node.getNodeID() + " applicationAttemptId=" + rmContainer.getApplicationAttemptId()));
        }
        RMContainer reservedContainer = node.getReservedContainer();
        if (null != reservedContainer) {
            this.killReservedContainer(reservedContainer);
        }
        node.updateLabels(newLabels);
    }

    private void updateSchedulerHealth(long now, FiCaSchedulerNode node, CSAssignment assignment) {
        NodeId nodeId = node.getNodeID();
        List<AssignmentInformation.AssignmentDetails> allocations = assignment.getAssignmentInformation().getAllocationDetails();
        List<AssignmentInformation.AssignmentDetails> reservations = assignment.getAssignmentInformation().getReservationDetails();
        if (!allocations.isEmpty()) {
            ContainerId allocatedContainerId = allocations.get((int)(allocations.size() - 1)).containerId;
            String allocatedQueue = allocations.get((int)(allocations.size() - 1)).queue;
            this.schedulerHealth.updateAllocation(now, nodeId, allocatedContainerId, allocatedQueue);
        }
        if (!reservations.isEmpty()) {
            ContainerId reservedContainerId = reservations.get((int)(reservations.size() - 1)).containerId;
            String reservedQueue = reservations.get((int)(reservations.size() - 1)).queue;
            this.schedulerHealth.updateReservation(now, nodeId, reservedContainerId, reservedQueue);
        }
        this.schedulerHealth.updateSchedulerReservationCounts(assignment.getAssignmentInformation().getNumReservations());
        this.schedulerHealth.updateSchedulerAllocationCounts(assignment.getAssignmentInformation().getNumAllocations());
        this.schedulerHealth.updateSchedulerRunDetails(now, assignment.getAssignmentInformation().getAllocated(), assignment.getAssignmentInformation().getReserved());
    }

    @VisibleForTesting
    protected synchronized void allocateContainersToNode(FiCaSchedulerNode node) {
        CSAssignment assignment;
        if (this.rmContext.isWorkPreservingRecoveryEnabled() && !this.rmContext.isSchedulerReadyForAllocatingContainers()) {
            return;
        }
        this.updateSchedulerHealth(this.lastNodeUpdateTime, node, new CSAssignment(Resources.none(), NodeType.NODE_LOCAL));
        RMContainer reservedContainer = node.getReservedContainer();
        if (reservedContainer != null) {
            FiCaSchedulerApp reservedApplication = (FiCaSchedulerApp)this.getCurrentAttemptForContainer(reservedContainer.getContainerId());
            LOG.info((Object)("Trying to fulfill reservation for application " + reservedApplication.getApplicationId() + " on node: " + node.getNodeID()));
            LeafQueue queue = (LeafQueue)reservedApplication.getQueue();
            assignment = queue.assignContainers(this.clusterResource, node, new ResourceLimits(this.labelManager.getResourceByLabel("", this.clusterResource)), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY);
            if (assignment.isFulfilledReservation()) {
                CSAssignment tmp = new CSAssignment(reservedContainer.getReservedResource(), assignment.getType());
                Resources.addTo((Resource)assignment.getAssignmentInformation().getAllocated(), (Resource)reservedContainer.getReservedResource());
                tmp.getAssignmentInformation().addAllocationDetails(reservedContainer.getContainerId(), queue.getQueuePath());
                tmp.getAssignmentInformation().incrAllocations();
                this.updateSchedulerHealth(this.lastNodeUpdateTime, node, tmp);
                this.schedulerHealth.updateSchedulerFulfilledReservationCounts(1L);
            }
        }
        if (node.getReservedContainer() == null) {
            if (this.calculator.computeAvailableContainers(Resources.add((Resource)node.getAvailableResource(), (Resource)node.getTotalKillableResources()), this.minimumAllocation) > 0L) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Trying to schedule on node: " + node.getNodeName() + ", available: " + node.getAvailableResource()));
                }
                if (Resources.greaterThan((ResourceCalculator)this.calculator, (Resource)this.clusterResource, (Resource)(assignment = this.root.assignContainers(this.clusterResource, node, new ResourceLimits(this.labelManager.getResourceByLabel(node.getPartition(), this.clusterResource)), SchedulingMode.RESPECT_PARTITION_EXCLUSIVITY)).getResource(), (Resource)Resources.none())) {
                    this.updateSchedulerHealth(this.lastNodeUpdateTime, node, assignment);
                    return;
                }
                if (StringUtils.equals((String)node.getPartition(), (String)"")) {
                    return;
                }
                try {
                    if (this.rmContext.getNodeLabelManager().isExclusiveNodeLabel(node.getPartition())) {
                        return;
                    }
                }
                catch (IOException e) {
                    LOG.warn((Object)("Exception when trying to get exclusivity of node label=" + node.getPartition()), (Throwable)e);
                    return;
                }
                assignment = this.root.assignContainers(this.clusterResource, node, new ResourceLimits(this.labelManager.getResourceByLabel("", this.clusterResource)), SchedulingMode.IGNORE_PARTITION_EXCLUSIVITY);
                this.updateSchedulerHealth(this.lastNodeUpdateTime, node, assignment);
            }
        } else {
            LOG.info((Object)("Skipping scheduling since node " + node.getNodeID() + " is reserved by application " + node.getReservedContainer().getContainerId().getApplicationAttemptId()));
        }
    }

    public void handle(SchedulerEvent event) {
        switch ((SchedulerEventType)event.getType()) {
            case NODE_ADDED: {
                NodeAddedSchedulerEvent nodeAddedEvent = (NodeAddedSchedulerEvent)event;
                this.addNode(nodeAddedEvent.getAddedRMNode());
                this.recoverContainersOnNode(nodeAddedEvent.getContainerReports(), nodeAddedEvent.getAddedRMNode());
                break;
            }
            case NODE_REMOVED: {
                NodeRemovedSchedulerEvent nodeRemovedEvent = (NodeRemovedSchedulerEvent)event;
                this.removeNode(nodeRemovedEvent.getRemovedRMNode());
                break;
            }
            case NODE_RESOURCE_UPDATE: {
                NodeResourceUpdateSchedulerEvent nodeResourceUpdatedEvent = (NodeResourceUpdateSchedulerEvent)event;
                this.updateNodeAndQueueResource(nodeResourceUpdatedEvent.getRMNode(), nodeResourceUpdatedEvent.getResourceOption());
                break;
            }
            case NODE_LABELS_UPDATE: {
                NodeLabelsUpdateSchedulerEvent labelUpdateEvent = (NodeLabelsUpdateSchedulerEvent)event;
                for (Map.Entry<NodeId, Set<String>> entry : labelUpdateEvent.getUpdatedNodeToLabels().entrySet()) {
                    NodeId id = entry.getKey();
                    Set<String> labels = entry.getValue();
                    this.updateLabelsOnNode(id, labels);
                }
                break;
            }
            case NODE_UPDATE: {
                NodeUpdateSchedulerEvent nodeUpdatedEvent = (NodeUpdateSchedulerEvent)event;
                RMNode node = nodeUpdatedEvent.getRMNode();
                this.setLastNodeUpdateTime(Time.now());
                this.nodeUpdate(node);
                if (this.scheduleAsynchronously) break;
                this.allocateContainersToNode(this.getNode(node.getNodeID()));
                break;
            }
            case APP_ADDED: {
                AppAddedSchedulerEvent appAddedEvent = (AppAddedSchedulerEvent)event;
                String queueName = this.resolveReservationQueueName(appAddedEvent.getQueue(), appAddedEvent.getApplicationId(), appAddedEvent.getReservationID(), appAddedEvent.getIsAppRecovering());
                if (queueName == null) break;
                if (!appAddedEvent.getIsAppRecovering()) {
                    this.addApplication(appAddedEvent.getApplicationId(), queueName, appAddedEvent.getUser(), appAddedEvent.getApplicatonPriority());
                    break;
                }
                this.addApplicationOnRecovery(appAddedEvent.getApplicationId(), queueName, appAddedEvent.getUser(), appAddedEvent.getApplicatonPriority());
                break;
            }
            case APP_REMOVED: {
                AppRemovedSchedulerEvent appRemovedEvent = (AppRemovedSchedulerEvent)event;
                this.doneApplication(appRemovedEvent.getApplicationID(), appRemovedEvent.getFinalState());
                break;
            }
            case APP_ATTEMPT_ADDED: {
                AppAttemptAddedSchedulerEvent appAttemptAddedEvent = (AppAttemptAddedSchedulerEvent)event;
                this.addApplicationAttempt(appAttemptAddedEvent.getApplicationAttemptId(), appAttemptAddedEvent.getTransferStateFromPreviousAttempt(), appAttemptAddedEvent.getIsAttemptRecovering());
                break;
            }
            case APP_ATTEMPT_REMOVED: {
                AppAttemptRemovedSchedulerEvent appAttemptRemovedEvent = (AppAttemptRemovedSchedulerEvent)event;
                this.doneApplicationAttempt(appAttemptRemovedEvent.getApplicationAttemptID(), appAttemptRemovedEvent.getFinalAttemptState(), appAttemptRemovedEvent.getKeepContainersAcrossAppAttempts());
                break;
            }
            case CONTAINER_EXPIRED: {
                ContainerExpiredSchedulerEvent containerExpiredEvent = (ContainerExpiredSchedulerEvent)event;
                ContainerId containerId = containerExpiredEvent.getContainerId();
                if (containerExpiredEvent.isIncrease()) {
                    this.rollbackContainerResource(containerId);
                    break;
                }
                this.completedContainer(this.getRMContainer(containerId), SchedulerUtils.createAbnormalContainerStatus(containerId, "Container expired since it was unused"), RMContainerEventType.EXPIRE);
                break;
            }
            case KILL_RESERVED_CONTAINER: {
                ContainerPreemptEvent killReservedContainerEvent = (ContainerPreemptEvent)event;
                RMContainer container = killReservedContainerEvent.getContainer();
                this.killReservedContainer(container);
                break;
            }
            case MARK_CONTAINER_FOR_PREEMPTION: {
                ContainerPreemptEvent preemptContainerEvent = (ContainerPreemptEvent)event;
                ApplicationAttemptId aid = preemptContainerEvent.getAppId();
                RMContainer containerToBePreempted = preemptContainerEvent.getContainer();
                this.markContainerForPreemption(aid, containerToBePreempted);
                break;
            }
            case MARK_CONTAINER_FOR_KILLABLE: {
                ContainerPreemptEvent containerKillableEvent = (ContainerPreemptEvent)event;
                RMContainer killableContainer = containerKillableEvent.getContainer();
                this.markContainerForKillable(killableContainer);
                break;
            }
            case MARK_CONTAINER_FOR_NONKILLABLE: {
                if (!this.isLazyPreemptionEnabled) break;
                ContainerPreemptEvent cancelKillContainerEvent = (ContainerPreemptEvent)event;
                this.markContainerForNonKillable(cancelKillContainerEvent.getContainer());
                break;
            }
            default: {
                LOG.error((Object)("Invalid eventtype " + event.getType() + ". Ignoring!"));
            }
        }
    }

    private synchronized void addNode(RMNode nodeManager) {
        FiCaSchedulerNode schedulerNode = new FiCaSchedulerNode(nodeManager, this.usePortForNodeName, nodeManager.getNodeLabels());
        this.nodes.put(nodeManager.getNodeID(), schedulerNode);
        Resources.addTo((Resource)this.clusterResource, (Resource)schedulerNode.getTotalResource());
        if (this.labelManager != null) {
            this.labelManager.activateNode(nodeManager.getNodeID(), schedulerNode.getTotalResource());
        }
        this.root.updateClusterResource(this.clusterResource, new ResourceLimits(this.clusterResource));
        int numNodes = this.numNodeManagers.incrementAndGet();
        this.updateMaximumAllocation(schedulerNode, true);
        LOG.info((Object)("Added node " + nodeManager.getNodeAddress() + " clusterResource: " + this.clusterResource));
        if (this.scheduleAsynchronously && numNodes == 1) {
            this.asyncSchedulerThread.beginSchedule();
        }
    }

    private synchronized void removeNode(RMNode nodeInfo) {
        FiCaSchedulerNode node;
        if (this.labelManager != null) {
            this.labelManager.deactivateNode(nodeInfo.getNodeID());
        }
        if ((node = (FiCaSchedulerNode)this.nodes.get(nodeInfo.getNodeID())) == null) {
            return;
        }
        Resources.subtractFrom((Resource)this.clusterResource, (Resource)node.getTotalResource());
        this.root.updateClusterResource(this.clusterResource, new ResourceLimits(this.clusterResource));
        int numNodes = this.numNodeManagers.decrementAndGet();
        if (this.scheduleAsynchronously && numNodes == 0) {
            this.asyncSchedulerThread.suspendSchedule();
        }
        List<RMContainer> runningContainers = node.getCopiedListOfRunningContainers();
        for (RMContainer container : runningContainers) {
            super.completedContainer(container, SchedulerUtils.createAbnormalContainerStatus(container.getContainerId(), "Container released on a *lost* node"), RMContainerEventType.KILL);
        }
        RMContainer reservedContainer = node.getReservedContainer();
        if (reservedContainer != null) {
            super.completedContainer(reservedContainer, SchedulerUtils.createAbnormalContainerStatus(reservedContainer.getContainerId(), "Container released on a *lost* node"), RMContainerEventType.KILL);
        }
        this.nodes.remove(nodeInfo.getNodeID());
        this.updateMaximumAllocation(node, false);
        LOG.info((Object)("Removed node " + nodeInfo.getNodeAddress() + " clusterResource: " + this.clusterResource));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rollbackContainerResource(ContainerId containerId) {
        LeafQueue leafQueue;
        RMContainer rmContainer = this.getRMContainer(containerId);
        if (rmContainer == null) {
            LOG.info((Object)("Cannot rollback resource for container " + containerId + ". The container does not exist."));
            return;
        }
        FiCaSchedulerApp application = (FiCaSchedulerApp)this.getCurrentAttemptForContainer(containerId);
        if (application == null) {
            LOG.info((Object)("Cannot rollback resource for container " + containerId + ". The application that the container belongs to does not exist."));
            return;
        }
        LOG.info((Object)("Roll back resource for container " + containerId));
        LeafQueue leafQueue2 = leafQueue = (LeafQueue)application.getQueue();
        synchronized (leafQueue2) {
            SchedulerNode schedulerNode = this.getSchedulerNode(rmContainer.getAllocatedNode());
            SchedContainerChangeRequest decreaseRequest = new SchedContainerChangeRequest(this.rmContext, schedulerNode, rmContainer, rmContainer.getLastConfirmedResource());
            this.decreaseContainer(decreaseRequest, application);
        }
    }

    @Override
    protected void completedContainerInternal(RMContainer rmContainer, ContainerStatus containerStatus, RMContainerEventType event) {
        Container container = rmContainer.getContainer();
        ContainerId containerId = container.getId();
        FiCaSchedulerApp application = (FiCaSchedulerApp)this.getCurrentAttemptForContainer(container.getId());
        ApplicationId appId = containerId.getApplicationAttemptId().getApplicationId();
        if (application == null) {
            LOG.info((Object)("Container " + container + " of finished application " + appId + " completed with event " + (Object)((Object)event)));
            return;
        }
        FiCaSchedulerNode node = this.getNode(container.getNodeId());
        LeafQueue queue = (LeafQueue)application.getQueue();
        queue.completedContainer(this.clusterResource, application, node, rmContainer, containerStatus, event, null, true);
    }

    @Override
    protected void decreaseContainer(SchedContainerChangeRequest decreaseRequest, SchedulerApplicationAttempt attempt) {
        RMContainer rmContainer = decreaseRequest.getRMContainer();
        if (rmContainer.getState() != RMContainerState.RUNNING) {
            LOG.info((Object)("Trying to decrease a container not in RUNNING state, container=" + rmContainer + " state=" + rmContainer.getState().name()));
            return;
        }
        FiCaSchedulerApp app = (FiCaSchedulerApp)attempt;
        LeafQueue queue = (LeafQueue)attempt.getQueue();
        try {
            queue.decreaseContainer(this.clusterResource, decreaseRequest, app);
            this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMNodeDecreaseContainerEvent(decreaseRequest.getNodeId(), Collections.singletonList(rmContainer.getContainer())));
        }
        catch (InvalidResourceRequestException e) {
            LOG.warn((Object)"Error happens when checking decrease request, Ignoring.. exception=", (Throwable)e);
        }
    }

    @Override
    @Lock(value={Lock.NoLock.class})
    @VisibleForTesting
    public FiCaSchedulerApp getApplicationAttempt(ApplicationAttemptId applicationAttemptId) {
        return (FiCaSchedulerApp)super.getApplicationAttempt(applicationAttemptId);
    }

    @Override
    @Lock(value={Lock.NoLock.class})
    public FiCaSchedulerNode getNode(NodeId nodeId) {
        return (FiCaSchedulerNode)this.nodes.get(nodeId);
    }

    @Lock(value={Lock.NoLock.class})
    public Map<NodeId, FiCaSchedulerNode> getAllNodes() {
        return this.nodes;
    }

    @Override
    @Lock(value={Lock.NoLock.class})
    public void recover(RMStateStore.RMState state) throws Exception {
    }

    @Override
    public void killReservedContainer(RMContainer container) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)((Object)((Object)SchedulerEventType.KILL_RESERVED_CONTAINER) + ":" + container.toString()));
        }
        super.completedContainer(container, SchedulerUtils.createAbnormalContainerStatus(container.getContainerId(), "Container reservation no longer required."), RMContainerEventType.KILL);
    }

    @Override
    public void markContainerForPreemption(ApplicationAttemptId aid, RMContainer cont) {
        FiCaSchedulerApp app;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)((Object)((Object)SchedulerEventType.MARK_CONTAINER_FOR_PREEMPTION) + ": appAttempt:" + aid.toString() + " container: " + cont.toString()));
        }
        if ((app = this.getApplicationAttempt(aid)) != null) {
            app.markContainerForPreemption(cont.getContainerId());
        }
    }

    @Override
    public synchronized void markContainerForKillable(RMContainer killableContainer) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)((Object)((Object)SchedulerEventType.MARK_CONTAINER_FOR_KILLABLE) + ": container" + killableContainer.toString()));
        }
        if (!this.isLazyPreemptionEnabled) {
            super.completedContainer(killableContainer, SchedulerUtils.createPreemptedContainerStatus(killableContainer.getContainerId(), "Container preempted by scheduler"), RMContainerEventType.KILL);
        } else {
            FiCaSchedulerNode node = (FiCaSchedulerNode)this.getSchedulerNode(killableContainer.getAllocatedNode());
            FiCaSchedulerApp application = (FiCaSchedulerApp)this.getCurrentAttemptForContainer(killableContainer.getContainerId());
            node.markContainerToKillable(killableContainer.getContainerId());
            if (null != application) {
                String leafQueueName = application.getCSLeafQueue().getQueueName();
                this.getPreemptionManager().addKillableContainer(new KillableContainer(killableContainer, node.getPartition(), leafQueueName));
            }
        }
    }

    private synchronized void markContainerForNonKillable(RMContainer nonKillableContainer) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)((Object)((Object)SchedulerEventType.MARK_CONTAINER_FOR_NONKILLABLE) + ": container" + nonKillableContainer.toString()));
        }
        FiCaSchedulerNode node = (FiCaSchedulerNode)this.getSchedulerNode(nonKillableContainer.getAllocatedNode());
        FiCaSchedulerApp application = (FiCaSchedulerApp)this.getCurrentAttemptForContainer(nonKillableContainer.getContainerId());
        node.markContainerToNonKillable(nonKillableContainer.getContainerId());
        if (null != application) {
            String leafQueueName = application.getCSLeafQueue().getQueueName();
            this.getPreemptionManager().removeKillableContainer(new KillableContainer(nonKillableContainer, node.getPartition(), leafQueueName));
        }
    }

    @Override
    public synchronized boolean checkAccess(UserGroupInformation callerUGI, QueueACL acl, String queueName) {
        CSQueue queue = this.getQueue(queueName);
        if (queue == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("ACL not found for queue access-type " + acl + " for queue " + queueName));
            }
            return false;
        }
        return queue.hasAccess(acl, callerUGI);
    }

    @Override
    public List<ApplicationAttemptId> getAppsInQueue(String queueName) {
        CSQueue queue = this.queues.get(queueName);
        if (queue == null) {
            return null;
        }
        ArrayList<ApplicationAttemptId> apps = new ArrayList<ApplicationAttemptId>();
        queue.collectSchedulerApplications(apps);
        return apps;
    }

    private CapacitySchedulerConfiguration loadCapacitySchedulerConfiguration(Configuration configuration) throws IOException {
        try {
            InputStream CSInputStream = this.rmContext.getConfigurationProvider().getConfigurationInputStream(configuration, "capacity-scheduler.xml");
            if (CSInputStream != null) {
                configuration.addResource(CSInputStream);
                return new CapacitySchedulerConfiguration(configuration, false);
            }
            return new CapacitySchedulerConfiguration(configuration, true);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private String getDefaultReservationQueueName(String planQueueName) {
        return planQueueName + "-default";
    }

    private synchronized String resolveReservationQueueName(String queueName, ApplicationId applicationId, ReservationId reservationID, boolean isRecovering) {
        CSQueue queue = this.getQueue(queueName);
        if (queue == null || !(queue instanceof PlanQueue)) {
            return queueName;
        }
        if (reservationID != null) {
            String resQName = reservationID.toString();
            queue = this.getQueue(resQName);
            if (queue == null) {
                if (isRecovering && this.conf.getMoveOnExpiry(this.getQueue(queueName).getQueuePath())) {
                    return this.getDefaultReservationQueueName(queueName);
                }
                String message = "Application " + applicationId + " submitted to a reservation which is not currently active: " + resQName;
                this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppEvent(applicationId, RMAppEventType.APP_REJECTED, message));
                return null;
            }
            if (!queue.getParent().getQueueName().equals(queueName)) {
                String message = "Application: " + applicationId + " submitted to a reservation " + resQName + " which does not belong to the specified queue: " + queueName;
                this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppEvent(applicationId, RMAppEventType.APP_REJECTED, message));
                return null;
            }
            queueName = resQName;
        } else {
            queueName = this.getDefaultReservationQueueName(queueName);
        }
        return queueName;
    }

    @Override
    public synchronized void removeQueue(String queueName) throws SchedulerDynamicEditException {
        LOG.info((Object)("Removing queue: " + queueName));
        CSQueue q = this.getQueue(queueName);
        if (!(q instanceof ReservationQueue)) {
            throw new SchedulerDynamicEditException("The queue that we are asked to remove (" + queueName + ") is not a ReservationQueue");
        }
        ReservationQueue disposableLeafQueue = (ReservationQueue)q;
        if (disposableLeafQueue.getNumApplications() > 0) {
            throw new SchedulerDynamicEditException("The queue " + queueName + " is not empty " + disposableLeafQueue.getApplications().size() + " active apps " + disposableLeafQueue.getPendingApplications().size() + " pending apps");
        }
        ((PlanQueue)disposableLeafQueue.getParent()).removeChildQueue(q);
        this.queues.remove(queueName);
        LOG.info((Object)("Removal of ReservationQueue " + queueName + " has succeeded"));
    }

    @Override
    public synchronized void addQueue(Queue queue) throws SchedulerDynamicEditException {
        if (!(queue instanceof ReservationQueue)) {
            throw new SchedulerDynamicEditException("Queue " + queue.getQueueName() + " is not a ReservationQueue");
        }
        ReservationQueue newQueue = (ReservationQueue)queue;
        if (newQueue.getParent() == null || !(newQueue.getParent() instanceof PlanQueue)) {
            throw new SchedulerDynamicEditException("ParentQueue for " + newQueue.getQueueName() + " is not properly set (should be set and be a PlanQueue)");
        }
        PlanQueue parentPlan = (PlanQueue)newQueue.getParent();
        String queuename = newQueue.getQueueName();
        parentPlan.addChildQueue(newQueue);
        this.queues.put(queuename, newQueue);
        LOG.info((Object)("Creation of ReservationQueue " + newQueue + " succeeded"));
    }

    @Override
    public synchronized void setEntitlement(String inQueue, QueueEntitlement entitlement) throws SchedulerDynamicEditException, YarnException {
        LeafQueue queue = this.getAndCheckLeafQueue(inQueue);
        ParentQueue parent = (ParentQueue)queue.getParent();
        if (!(queue instanceof ReservationQueue)) {
            throw new SchedulerDynamicEditException("Entitlement can not be modified dynamically since queue " + inQueue + " is not a ReservationQueue");
        }
        if (!(parent instanceof PlanQueue)) {
            throw new SchedulerDynamicEditException("The parent of ReservationQueue " + inQueue + " must be an PlanQueue");
        }
        ReservationQueue newQueue = (ReservationQueue)queue;
        float sumChilds = ((PlanQueue)parent).sumOfChildCapacities();
        float newChildCap = sumChilds - queue.getCapacity() + entitlement.getCapacity();
        if (newChildCap >= 0.0f && newChildCap < 1.0001f) {
            if (Math.abs(entitlement.getCapacity() - queue.getCapacity()) == 0.0f && Math.abs(entitlement.getMaxCapacity() - queue.getMaximumCapacity()) == 0.0f) {
                return;
            }
        } else {
            throw new SchedulerDynamicEditException("Sum of child queues would exceed 100% for PlanQueue: " + parent.getQueueName());
        }
        newQueue.setEntitlement(entitlement);
        LOG.info((Object)("Set entitlement for ReservationQueue " + inQueue + "  to " + queue.getCapacity() + " request was (" + entitlement.getCapacity() + ")"));
    }

    @Override
    public synchronized String moveApplication(ApplicationId appId, String targetQueueName) throws YarnException {
        FiCaSchedulerApp app = this.getApplicationAttempt(ApplicationAttemptId.newInstance((ApplicationId)appId, (int)0));
        String sourceQueueName = app.getQueue().getQueueName();
        LeafQueue source = this.getAndCheckLeafQueue(sourceQueueName);
        String destQueueName = this.handleMoveToPlanQueue(targetQueueName);
        LeafQueue dest = this.getAndCheckLeafQueue(destQueueName);
        String user = app.getUser();
        this.checkQueuePartition(app, dest);
        try {
            dest.submitApplication(appId, user, destQueueName);
        }
        catch (AccessControlException e) {
            throw new YarnException((Throwable)e);
        }
        for (RMContainer rmContainer : app.getLiveContainers()) {
            source.detachContainer(this.clusterResource, app, rmContainer);
            dest.attachContainer(this.clusterResource, app, rmContainer);
        }
        source.finishApplicationAttempt(app, sourceQueueName);
        source.getParent().finishApplication(appId, app.getUser());
        app.move(dest);
        dest.submitApplicationAttempt(app, user);
        ((SchedulerApplication)this.applications.get(appId)).setQueue(dest);
        LOG.info((Object)("App: " + app.getApplicationId() + " successfully moved from " + sourceQueueName + " to: " + destQueueName));
        return targetQueueName;
    }

    private void checkQueuePartition(FiCaSchedulerApp app, LeafQueue dest) throws YarnException {
        if (!YarnConfiguration.areNodeLabelsEnabled((Configuration)this.conf)) {
            return;
        }
        Set<String> targetqueuelabels = dest.getAccessibleNodeLabels();
        AppSchedulingInfo schedulingInfo = app.getAppSchedulingInfo();
        Set<String> appLabelexpressions = schedulingInfo.getRequestedPartitions();
        appLabelexpressions.remove("");
        HashSet<String> nonAccessiblelabels = new HashSet<String>();
        for (String label : appLabelexpressions) {
            if (SchedulerUtils.checkQueueLabelExpression(targetqueuelabels, label, null)) continue;
            nonAccessiblelabels.add(label);
        }
        if (nonAccessiblelabels.size() > 0) {
            throw new YarnException("Specified queue=" + dest.getQueueName() + " can't satisfy following apps label expressions =" + nonAccessiblelabels + " accessible node labels =" + targetqueuelabels);
        }
    }

    private LeafQueue getAndCheckLeafQueue(String queue) throws YarnException {
        CSQueue ret = this.getQueue(queue);
        if (ret == null) {
            throw new YarnException("The specified Queue: " + queue + " doesn't exist");
        }
        if (!(ret instanceof LeafQueue)) {
            throw new YarnException("The specified Queue: " + queue + " is not a Leaf Queue. Move is supported only for Leaf Queues.");
        }
        return (LeafQueue)ret;
    }

    @Override
    public EnumSet<YarnServiceProtos.SchedulerResourceTypes> getSchedulingResourceTypes() {
        if (this.calculator.getClass().getName().equals(DefaultResourceCalculator.class.getName())) {
            return EnumSet.of(YarnServiceProtos.SchedulerResourceTypes.MEMORY);
        }
        return EnumSet.of(YarnServiceProtos.SchedulerResourceTypes.MEMORY, YarnServiceProtos.SchedulerResourceTypes.CPU, YarnServiceProtos.SchedulerResourceTypes.GPU);
    }

    @Override
    public Resource getMaximumResourceCapability(String queueName) {
        CSQueue queue = this.getQueue(queueName);
        if (queue == null) {
            LOG.error((Object)("Unknown queue: " + queueName));
            return this.getMaximumResourceCapability();
        }
        if (!(queue instanceof LeafQueue)) {
            LOG.error((Object)("queue " + queueName + " is not an leaf queue"));
            return this.getMaximumResourceCapability();
        }
        return ((LeafQueue)queue).getMaximumAllocation();
    }

    private String handleMoveToPlanQueue(String targetQueueName) {
        CSQueue dest = this.getQueue(targetQueueName);
        if (dest != null && dest instanceof PlanQueue) {
            targetQueueName = targetQueueName + "-default";
        }
        return targetQueueName;
    }

    @Override
    public Set<String> getPlanQueues() {
        HashSet<String> ret = new HashSet<String>();
        for (Map.Entry<String, CSQueue> l : this.queues.entrySet()) {
            if (!(l.getValue() instanceof PlanQueue)) continue;
            ret.add(l.getKey());
        }
        return ret;
    }

    @Override
    public SchedulerHealth getSchedulerHealth() {
        return this.schedulerHealth;
    }

    private void setLastNodeUpdateTime(long time) {
        this.lastNodeUpdateTime = time;
    }

    @Override
    public long getLastNodeUpdateTime() {
        return this.lastNodeUpdateTime;
    }

    @Override
    public Priority checkAndGetApplicationPriority(Priority priorityFromContext, String user, String queueName, ApplicationId applicationId) throws YarnException {
        Priority appPriority = null;
        if (null == priorityFromContext) {
            priorityFromContext = this.getDefaultPriorityForQueue(queueName);
            LOG.info((Object)("Application '" + applicationId + "' is submitted without priority hence considering default queue/cluster priority: " + priorityFromContext.getPriority()));
        }
        if (priorityFromContext.compareTo(this.getMaxClusterLevelAppPriority()) < 0) {
            priorityFromContext = Priority.newInstance((int)this.getMaxClusterLevelAppPriority().getPriority());
        }
        appPriority = priorityFromContext;
        LOG.info((Object)("Priority '" + appPriority.getPriority() + "' is acceptable in queue : " + queueName + " for application: " + applicationId + " for the user: " + user));
        return appPriority;
    }

    private Priority getDefaultPriorityForQueue(String queueName) {
        CSQueue queue = this.getQueue(queueName);
        if (null == queue || null == queue.getDefaultApplicationPriority()) {
            return Priority.newInstance((int)CapacitySchedulerConfiguration.DEFAULT_CONFIGURATION_APPLICATION_PRIORITY);
        }
        return Priority.newInstance((int)queue.getDefaultApplicationPriority().getPriority());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateApplicationPriority(Priority newPriority, ApplicationId applicationId) throws YarnException {
        LeafQueue queue;
        Priority appPriority = null;
        SchedulerApplication application = (SchedulerApplication)this.applications.get(applicationId);
        if (application == null) {
            throw new YarnException("Application '" + applicationId + "' is not present, hence could not change priority.");
        }
        RMApp rmApp = (RMApp)this.rmContext.getRMApps().get(applicationId);
        appPriority = this.checkAndGetApplicationPriority(newPriority, rmApp.getUser(), rmApp.getQueue(), applicationId);
        if (application.getPriority().equals((Object)appPriority)) {
            return;
        }
        rmApp.getApplicationSubmissionContext().setPriority(appPriority);
        ApplicationStateData appState = ApplicationStateData.newInstance(rmApp.getSubmitTime(), rmApp.getStartTime(), rmApp.getApplicationSubmissionContext(), rmApp.getUser(), rmApp.getCallerContext());
        this.rmContext.getStateStore().updateApplicationStateSynchronously(appState, false);
        LeafQueue leafQueue = queue = (LeafQueue)this.getQueue(rmApp.getQueue());
        synchronized (leafQueue) {
            FiCaSchedulerApp attempt = (FiCaSchedulerApp)application.getCurrentAppAttempt();
            boolean isActive = queue.getOrderingPolicy().removeSchedulableEntity(attempt);
            if (!isActive) {
                queue.getPendingAppsOrderingPolicy().removeSchedulableEntity(attempt);
            }
            application.setPriority(appPriority);
            if (isActive) {
                queue.getOrderingPolicy().addSchedulableEntity(attempt);
            } else {
                queue.getPendingAppsOrderingPolicy().addSchedulableEntity(attempt);
            }
        }
        this.rmContext.getSystemMetricsPublisher().appUpdated(rmApp, System.currentTimeMillis());
        LOG.info((Object)("Priority '" + appPriority + "' is updated in queue :" + rmApp.getQueue() + " for application: " + applicationId + " for the user: " + rmApp.getUser()));
    }

    @Override
    public ResourceUsage getClusterResourceUsage() {
        return this.root.getQueueResourceUsage();
    }

    @Override
    public PreemptionManager getPreemptionManager() {
        return this.preemptionManager;
    }

    static class QueueHook {
        QueueHook() {
        }

        public CSQueue hook(CSQueue queue) {
            return queue;
        }
    }

    static class AsyncScheduleThread
    extends Thread {
        private final CapacityScheduler cs;
        private AtomicBoolean runSchedules = new AtomicBoolean(false);

        public AsyncScheduleThread(CapacityScheduler cs) {
            this.cs = cs;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            while (true) {
                if (!this.runSchedules.get()) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                CapacityScheduler.schedule(this.cs);
            }
        }

        public void beginSchedule() {
            this.runSchedules.set(true);
        }

        public void suspendSchedule() {
            this.runSchedules.set(false);
        }
    }
}

