/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.security;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTParser;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.BackOff;
import org.apache.hadoop.util.ExponentialBackOff;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.security.JWTSecurityHandler;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMAppSecurityActions;
import org.apache.hadoop.yarn.server.resourcemanager.security.X509SecurityHandler;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.bouncycastle.openssl.jcajce.JcaMiscPEMGenerator;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemWriter;

public class HopsworksRMAppSecurityActions
implements RMAppSecurityActions,
Configurable {
    public static final String REVOKE_CERT_ID_PARAM = "certId";
    public static final Pattern JWT_PATTERN = Pattern.compile("^Bearer\\s(.+)");
    protected static final int MAX_CONNECTIONS_PER_ROUTE = 50;
    private static final Log LOG = LogFactory.getLog(HopsworksRMAppSecurityActions.class);
    private static final Set<Integer> ACCEPTABLE_HTTP_RESPONSES = new HashSet<Integer>(2);
    private static final String AUTH_HEADER_CONTENT = "Bearer %s";
    private static final Pattern SUBJECT_USERNAME = Pattern.compile("^(.+)(?>_{2})(.+)$");
    private final AtomicReference<Header> authHeader;
    private final Gson jsonParser;
    private Configuration conf;
    private Configuration sslConf;
    private URL hopsworksHost;
    private URL signEndpoint;
    private String revokePath;
    private CertificateFactory certificateFactory;
    private boolean x509Configured = false;
    private URL jwtGeneratePath;
    private URL jwtInvalidatePath;
    private URL jwtRenewPath;
    private URL serviceJWTRenewPath;
    private URL serviceJWTInvalidatePath;
    private long serviceJWTValidityPeriodSeconds;
    private boolean jwtConfigured = false;
    private String masterToken;
    private LocalDateTime masterTokenExpiration;
    private String[] renewalTokens;
    private PoolingHttpClientConnectionManager httpConnectionManager = null;
    protected CloseableHttpClient httpClient = null;
    private final ExecutorService tokenRenewer;

    public HopsworksRMAppSecurityActions() throws MalformedURLException, GeneralSecurityException {
        ACCEPTABLE_HTTP_RESPONSES.add(200);
        ACCEPTABLE_HTTP_RESPONSES.add(204);
        this.authHeader = new AtomicReference();
        GsonBuilder parserBuilder = new GsonBuilder();
        parserBuilder.setFieldNamingPolicy(FieldNamingPolicy.IDENTITY);
        parserBuilder.setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        this.jsonParser = parserBuilder.create();
        this.tokenRenewer = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("JWT renewer thread").setDaemon(true).build());
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public void init() throws MalformedURLException, GeneralSecurityException, IOException {
        this.httpConnectionManager = this.createConnectionManager();
        this.httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)this.httpConnectionManager).build();
        this.hopsworksHost = new URL(this.conf.get(YarnConfiguration.HOPS_HOPSWORKS_HOST_KEY, "http://127.0.0.1"));
        if (!this.conf.getBoolean("ipc.server.ssl.enabled", false) && this.conf.getBoolean(YarnConfiguration.RM_JWT_ENABLED, YarnConfiguration.DEFAULT_RM_JWT_ENABLED)) {
            this.initJWT();
        } else if (this.conf.getBoolean("ipc.server.ssl.enabled", false)) {
            this.initJWT();
            this.initX509();
        }
    }

    @VisibleForTesting
    protected void setMasterToken(String masterToken) {
        this.masterToken = masterToken;
    }

    @VisibleForTesting
    protected void setMasterTokenExpiration(LocalDateTime masterTokenExpiration) {
        this.masterTokenExpiration = masterTokenExpiration;
    }

    @VisibleForTesting
    protected void setRenewalTokens(String[] renewalTokens) {
        this.renewalTokens = renewalTokens;
    }

    protected PoolingHttpClientConnectionManager createConnectionManager() throws GeneralSecurityException {
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
        connectionManager.setDefaultMaxPerRoute(50);
        return connectionManager;
    }

    private void initX509() throws MalformedURLException, GeneralSecurityException {
        this.signEndpoint = new URL(this.hopsworksHost, this.conf.get(YarnConfiguration.HOPS_HOPSWORKS_SIGN_ENDPOINT_KEY, YarnConfiguration.DEFAULT_HOPS_HOPSWORKS_SIGN_ENDPOINT));
        this.revokePath = this.conf.get(YarnConfiguration.HOPS_HOPSWORKS_REVOKE_ENDPOINT_KEY, YarnConfiguration.DEFAULT_HOPS_HOPSWORKS_REVOKE_ENDPOINT);
        this.revokePath = this.revokePath.startsWith("/") ? "%s" + this.revokePath : "%s/" + this.revokePath;
        this.certificateFactory = CertificateFactory.getInstance("X.509", "BC");
        this.x509Configured = true;
    }

    private void initJWT() throws MalformedURLException, GeneralSecurityException {
        this.jwtGeneratePath = new URL(this.hopsworksHost, this.conf.get(YarnConfiguration.RM_JWT_GENERATE_PATH, YarnConfiguration.DEFAULT_RM_JWT_GENERATE_PATH));
        String jwtInvalidatePathConf = this.conf.get(YarnConfiguration.RM_JWT_INVALIDATE_PATH, YarnConfiguration.DEFAULT_RM_JWT_INVALIDATE_PATH);
        if (!jwtInvalidatePathConf.endsWith("/")) {
            jwtInvalidatePathConf = jwtInvalidatePathConf + "/";
        }
        this.jwtInvalidatePath = new URL(this.hopsworksHost, jwtInvalidatePathConf);
        this.jwtRenewPath = new URL(this.hopsworksHost, this.conf.get(YarnConfiguration.RM_JWT_RENEW_PATH, YarnConfiguration.DEFAULT_RM_JWT_RENEW_PATH));
        this.sslConf = new Configuration(false);
        this.sslConf.addResource(this.conf.get("hadoop.ssl.server.conf", "ssl-server.xml"));
        this.loadMasterJWT();
        this.loadRenewalJWTs();
        this.serviceJWTValidityPeriodSeconds = this.conf.getTimeDuration(YarnConfiguration.RM_JWT_MASTER_VALIDITY_PERIOD, YarnConfiguration.DEFAULT_RM_JWT_MASTER_VALIDITY_PERIOD, TimeUnit.SECONDS);
        if (this.serviceJWTValidityPeriodSeconds == 0L) {
            this.serviceJWTValidityPeriodSeconds = 30L;
        }
        String serviceJWTRenewPathConf = this.conf.get(YarnConfiguration.RM_JWT_SERVICE_RENEW_PATH, YarnConfiguration.DEFAULT_RM_JWT_SERVICE_RENEW_PATH);
        this.serviceJWTRenewPath = new URL(this.hopsworksHost, serviceJWTRenewPathConf);
        String serviceJWTInvalidatePathConf = this.conf.get(YarnConfiguration.RM_JWT_SERVICE_INVALIDATE_PATH, YarnConfiguration.DEFAULT_RM_JWT_SERVICE_INVALIDATE_PATH);
        if (!serviceJWTInvalidatePathConf.endsWith("/")) {
            serviceJWTInvalidatePathConf = serviceJWTRenewPathConf + "/";
        }
        this.serviceJWTInvalidatePath = new URL(this.hopsworksHost, serviceJWTInvalidatePathConf);
        this.tokenRenewer.execute(new TokenRenewer());
        this.jwtConfigured = true;
    }

    protected void loadMasterJWT() throws GeneralSecurityException {
        this.masterToken = this.sslConf.get(YarnConfiguration.RM_JWT_MASTER_TOKEN);
        if (this.masterToken == null) {
            throw new GeneralSecurityException("Could not parse JWT from configuration");
        }
        this.authHeader.set(this.createAuthenticationHeader(this.masterToken));
        try {
            JWT jwt = JWTParser.parse((String)this.masterToken);
            this.masterTokenExpiration = this.date2LocalDateTime(jwt.getJWTClaimsSet().getExpirationTime());
        }
        catch (ParseException ex) {
            throw new GeneralSecurityException("Could not parse master JWT", ex);
        }
    }

    protected void loadRenewalJWTs() throws GeneralSecurityException {
        String renewTokenKey;
        String renewToken = null;
        ArrayList<String> renewalTokens = new ArrayList<String>();
        int idx = 0;
        while (!(renewToken = this.sslConf.get(renewTokenKey = String.format(YarnConfiguration.RM_JWT_RENEW_TOKEN_PATTERN, idx), "")).isEmpty()) {
            renewalTokens.add(renewToken);
            ++idx;
        }
        if (renewalTokens.isEmpty()) {
            throw new GeneralSecurityException("Could not load one-time renewal JWTs");
        }
        this.renewalTokens = renewalTokens.toArray(new String[renewalTokens.size()]);
    }

    @Override
    public void destroy() {
        try {
            this.tokenRenewer.shutdown();
            if (!this.tokenRenewer.awaitTermination(10L, TimeUnit.SECONDS)) {
                this.tokenRenewer.shutdownNow();
            }
        }
        catch (InterruptedException ex) {
            this.tokenRenewer.shutdownNow();
        }
        if (this.httpConnectionManager != null) {
            this.httpConnectionManager.shutdown();
        }
    }

    private void x509NotConfigured(String methodName) throws GeneralSecurityException {
        this.notConfigured(methodName, "X.509");
    }

    private void jwtNotConfigured(String methodName) throws GeneralSecurityException {
        this.notConfigured(methodName, "JWT");
    }

    private void notConfigured(String methodName, String mechanism) throws GeneralSecurityException {
        throw new GeneralSecurityException("Called method " + methodName + " of " + HopsworksRMAppSecurityActions.class.getSimpleName() + " but " + mechanism + " is not configured");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public X509SecurityHandler.CertificateBundle sign(PKCS10CertificationRequest csr) throws URISyntaxException, IOException, GeneralSecurityException {
        if (!this.x509Configured) {
            this.x509NotConfigured("sign");
        }
        try (CloseableHttpResponse signResponse = null;){
            String csrStr = this.stringifyCSR(csr);
            CSRDTO request = new CSRDTO();
            request.csr = csrStr;
            String jsonRequest = this.jsonParser.toJson((Object)request);
            signResponse = this.post((HttpEntity)new StringEntity(jsonRequest), this.signEndpoint.toURI(), "Hopsworks CA could not sign CSR");
            CSRDTO csrResponse = (CSRDTO)this.jsonParser.fromJson(EntityUtils.toString((HttpEntity)signResponse.getEntity()), CSRDTO.class);
            X509Certificate certificate = this.parseCertificate(csrResponse.signedCert);
            X509Certificate issuer = this.parseCertificate(csrResponse.intermediateCaCert);
            X509SecurityHandler.CertificateBundle certificateBundle = new X509SecurityHandler.CertificateBundle(certificate, issuer);
            return certificateBundle;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int revoke(String certificateIdentifier) throws URISyntaxException, IOException, GeneralSecurityException {
        if (!this.x509Configured) {
            this.x509NotConfigured("revoke");
        }
        try (CloseableHttpResponse response = null;){
            String queryParams = this.buildQueryParams(new NameValuePair[]{new BasicNameValuePair(REVOKE_CERT_ID_PARAM, certificateIdentifier)});
            URL revokeUrl = this.buildUrl(this.revokePath, queryParams);
            response = this.delete(revokeUrl.toURI(), "Hopsworks CA could not revoke certificate " + certificateIdentifier);
            int n = response.getStatusLine().getStatusCode();
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String generateJWT(JWTSecurityHandler.JWTMaterialParameter jwtParameter) throws URISyntaxException, IOException, GeneralSecurityException {
        if (!this.jwtConfigured) {
            this.jwtNotConfigured("generateJWT");
        }
        try (CloseableHttpResponse response = null;){
            Matcher matcher = SUBJECT_USERNAME.matcher(jwtParameter.getAppUser());
            String username = matcher.matches() ? matcher.group(2) : jwtParameter.getAppUser();
            JWTDTO request = new JWTDTO();
            request.subject = username;
            request.keyName = jwtParameter.getApplicationId().toString();
            request.audiences = String.join((CharSequence)",", jwtParameter.getAudiences());
            request.expiresAt = this.instant2Date(jwtParameter.getExpirationDate());
            request.nbf = this.instant2Date(jwtParameter.getValidNotBefore());
            request.renewable = jwtParameter.isRenewable();
            request.expLeeway = jwtParameter.getExpLeeway();
            String jsonRequest = this.jsonParser.toJson((Object)request);
            response = this.post((HttpEntity)new StringEntity(jsonRequest), this.jwtGeneratePath.toURI(), "Hopsworks could not generate JWT for " + jwtParameter.getAppUser() + "/" + jwtParameter.getApplicationId().toString());
            JWTDTO jwtResponse = (JWTDTO)this.jsonParser.fromJson(EntityUtils.toString((HttpEntity)response.getEntity()), JWTDTO.class);
            String string = jwtResponse.token;
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String renewJWT(JWTSecurityHandler.JWTMaterialParameter jwtParameter) throws URISyntaxException, IOException, GeneralSecurityException {
        if (!this.jwtConfigured) {
            this.jwtNotConfigured("renewJWT");
        }
        try (CloseableHttpResponse response = null;){
            JWTDTO request = new JWTDTO();
            request.token = jwtParameter.getToken();
            request.expiresAt = this.instant2Date(jwtParameter.getExpirationDate());
            request.nbf = this.instant2Date(jwtParameter.getValidNotBefore());
            String jsonRequest = this.jsonParser.toJson((Object)request);
            response = this.put(this.jwtRenewPath.toURI(), (HttpEntity)new StringEntity(jsonRequest), "Could not renew JWT for " + jwtParameter.getAppUser() + "/" + jwtParameter.getApplicationId());
            JWTDTO jwtResponse = (JWTDTO)this.jsonParser.fromJson(EntityUtils.toString((HttpEntity)response.getEntity()), JWTDTO.class);
            String string = jwtResponse.token;
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidateJWT(String signingKeyName) throws URISyntaxException, IOException, GeneralSecurityException {
        if (!this.jwtConfigured) {
            this.jwtNotConfigured("invalidateJWT");
        }
        try (CloseableHttpResponse response = null;){
            URL invalidateURL = new URL(this.jwtInvalidatePath, signingKeyName);
            response = this.delete(invalidateURL.toURI(), "Hopsworks could to invalidate JWT signing key " + signingKeyName);
        }
    }

    @VisibleForTesting
    LocalDateTime getMasterTokenExpiration() {
        return this.masterTokenExpiration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    @VisibleForTesting
    protected ServiceTokenDTO renewServiceJWT(String token, String oneTimeToken, LocalDateTime expiresAt, LocalDateTime notBefore) throws URISyntaxException, IOException, GeneralSecurityException {
        if (!this.jwtConfigured) {
            this.jwtNotConfigured("renewServiceJWT");
        }
        try (CloseableHttpResponse httpResponse = null;){
            ServiceTokenDTO renewedTokenResponse;
            JWTDTO request = new JWTDTO();
            request.token = token;
            request.expiresAt = this.localDateTime2Date(expiresAt);
            request.nbf = this.localDateTime2Date(notBefore);
            String jsonRequest = this.jsonParser.toJson((Object)request);
            HttpPut httpRequest = new HttpPut(this.serviceJWTRenewPath.toURI());
            Header authHeader = this.createAuthenticationHeader(oneTimeToken);
            httpRequest.addHeader(authHeader);
            httpRequest.setEntity((HttpEntity)new StringEntity(jsonRequest));
            httpRequest.addHeader("Content-Type", "application/json");
            httpResponse = this.httpClient.execute((HttpUriRequest)httpRequest);
            this.checkHTTPResponseCode((HttpResponse)httpResponse, "Could not make HTTP request to renew service JWT");
            ServiceTokenDTO serviceTokenDTO = renewedTokenResponse = (ServiceTokenDTO)this.jsonParser.fromJson(EntityUtils.toString((HttpEntity)httpResponse.getEntity()), ServiceTokenDTO.class);
            return serviceTokenDTO;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    @VisibleForTesting
    protected void invalidateServiceJWT(String token2invalidate) throws URISyntaxException, IOException, GeneralSecurityException {
        if (!this.jwtConfigured) {
            this.jwtNotConfigured("invalidateServiceToken");
        }
        try (CloseableHttpResponse httpResponse = null;){
            URL invalidateURL = new URL(this.serviceJWTInvalidatePath, token2invalidate);
            httpResponse = this.delete(invalidateURL.toURI(), "Could not invalidate token " + token2invalidate);
        }
    }

    private CloseableHttpResponse post(HttpEntity httpEntity, URI target, String errorMessage) throws IOException {
        HttpPost request = new HttpPost(target);
        this.addAuthenticationHeader((HttpRequest)request);
        request.setEntity(httpEntity);
        request.addHeader("Content-Type", "application/json");
        CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)request);
        this.checkHTTPResponseCode((HttpResponse)response, errorMessage);
        return response;
    }

    private CloseableHttpResponse get(URI target, String errorMessage) throws IOException {
        HttpGet request = new HttpGet(target);
        this.addAuthenticationHeader((HttpRequest)request);
        CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)request);
        this.checkHTTPResponseCode((HttpResponse)response, errorMessage);
        return response;
    }

    private CloseableHttpResponse delete(URI target, String errorMessage) throws IOException {
        HttpDelete request = new HttpDelete(target);
        this.addAuthenticationHeader((HttpRequest)request);
        request.addHeader("Content-Type", "application/json");
        CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)request);
        this.checkHTTPResponseCode((HttpResponse)response, errorMessage);
        return response;
    }

    private CloseableHttpResponse put(URI target, String errorMessage) throws IOException {
        return this.put(target, null, errorMessage);
    }

    private CloseableHttpResponse put(URI target, HttpEntity httpEntity, String errorMessage) throws IOException {
        HttpPut request = new HttpPut(target);
        this.addAuthenticationHeader((HttpRequest)request);
        if (httpEntity != null) {
            request.setEntity(httpEntity);
        }
        request.addHeader("Content-Type", "application/json");
        CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)request);
        this.checkHTTPResponseCode((HttpResponse)response, errorMessage);
        return response;
    }

    private URL buildUrl(String apiUrl, String queryParams) throws MalformedURLException {
        String url = String.format(apiUrl, this.hopsworksHost.toString()) + queryParams;
        return new URL(url);
    }

    private String buildQueryParams(NameValuePair ... params) {
        ArrayList<NameValuePair> qparams = new ArrayList<NameValuePair>();
        for (NameValuePair p : params) {
            if (p.getValue() == null) continue;
            qparams.add(p);
        }
        return URLEncodedUtils.format(qparams, (String)"UTF-8");
    }

    private X509Certificate parseCertificate(String certificateStr) throws IOException, GeneralSecurityException {
        try (ByteArrayInputStream bis = new ByteArrayInputStream(certificateStr.getBytes());){
            X509Certificate x509Certificate = (X509Certificate)this.certificateFactory.generateCertificate(bis);
            return x509Certificate;
        }
    }

    private void checkHTTPResponseCode(HttpResponse response, String msg) throws IOException {
        int statusCode = response.getStatusLine().getStatusCode();
        if (!ACCEPTABLE_HTTP_RESPONSES.contains(statusCode)) {
            throw new IOException("HTTP error, response code " + statusCode + " Reason: " + response.getStatusLine().getReasonPhrase() + " Message: " + msg);
        }
    }

    private String stringifyCSR(PKCS10CertificationRequest csr) throws IOException {
        try (StringWriter sw = new StringWriter();){
            PemWriter pw = new PemWriter((Writer)sw);
            JcaMiscPEMGenerator pog = new JcaMiscPEMGenerator((Object)csr);
            pw.writeObject((PemObjectGenerator)pog.generate());
            pw.flush();
            sw.flush();
            pw.close();
            String string = sw.toString();
            return string;
        }
    }

    private LocalDateTime date2LocalDateTime(Date date) {
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    private Date localDateTime2Date(LocalDateTime localDateTime) {
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    private Date instant2Date(Instant instant) {
        return Date.from(instant);
    }

    private LocalDateTime now() {
        return LocalDateTime.now();
    }

    @VisibleForTesting
    protected Header createAuthenticationHeader(String jwt) {
        String content = String.format(AUTH_HEADER_CONTENT, jwt);
        return new BasicHeader("Authorization", content);
    }

    private void addAuthenticationHeader(HttpRequest httpRequest) {
        httpRequest.addHeader(this.authHeader.get());
    }

    protected boolean isTime2Renew(LocalDateTime now, LocalDateTime tokenExpiration) {
        return now.isAfter(tokenExpiration) || now.isEqual(tokenExpiration);
    }

    static /* synthetic */ String[] access$1302(HopsworksRMAppSecurityActions x0, String[] x1) {
        x0.renewalTokens = x1;
        return x1;
    }

    protected class ServiceTokenDTO {
        private JWTDTO jwt;
        private String[] renewTokens;

        protected ServiceTokenDTO() {
        }

        public JWTDTO getJwt() {
            return this.jwt;
        }

        public void setJwt(JWTDTO jwt) {
            this.jwt = jwt;
        }

        public String[] getRenewTokens() {
            return this.renewTokens;
        }

        public void setRenewTokens(String[] renewTokens) {
            this.renewTokens = renewTokens;
        }
    }

    protected class JWTDTO {
        private String token;
        private String subject;
        private String keyName;
        private String audiences;
        private Boolean renewable;
        private Integer expLeeway;
        private Date expiresAt;
        private Date nbf;

        protected JWTDTO() {
        }

        public String getToken() {
            return this.token;
        }

        public void setToken(String token) {
            this.token = token;
        }

        public String getSubject() {
            return this.subject;
        }

        public void setSubject(String subject) {
            this.subject = subject;
        }

        public String getKeyName() {
            return this.keyName;
        }

        public void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        public String getAudiences() {
            return this.audiences;
        }

        public void setAudiences(String audiences) {
            this.audiences = audiences;
        }

        public Boolean getRenewable() {
            return this.renewable;
        }

        public void setRenewable(Boolean renewable) {
            this.renewable = renewable;
        }

        public Integer getExpLeeway() {
            return this.expLeeway;
        }

        public void setExpLeeway(Integer expLeeway) {
            this.expLeeway = expLeeway;
        }

        public Date getExpiresAt() {
            return this.expiresAt;
        }

        public void setExpiresAt(Date expiresAt) {
            this.expiresAt = expiresAt;
        }

        public Date getNbf() {
            return this.nbf;
        }

        public void setNbf(Date nbf) {
            this.nbf = nbf;
        }
    }

    private class CSRDTO {
        private String csr;
        private String signedCert;
        private String intermediateCaCert;
        private String rootCaCert;

        private CSRDTO() {
        }
    }

    private class TokenRenewer
    implements Runnable {
        private final BackOff backoff;
        private final long sleepPeriodSeconds;

        private TokenRenewer() {
            int maximumRetries = Math.max(1, HopsworksRMAppSecurityActions.this.renewalTokens.length);
            this.backoff = new ExponentialBackOff.Builder().setInitialIntervalMillis(1000L).setMaximumIntervalMillis(7000L).setMultiplier(2.0).setMaximumRetries(maximumRetries).build();
            this.sleepPeriodSeconds = HopsworksRMAppSecurityActions.this.serviceJWTValidityPeriodSeconds / 2L;
        }

        @Override
        public void run() {
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    LocalDateTime now = HopsworksRMAppSecurityActions.this.now();
                    if (HopsworksRMAppSecurityActions.this.isTime2Renew(now, HopsworksRMAppSecurityActions.this.masterTokenExpiration)) {
                        this.backoff.reset();
                        LocalDateTime expiresAt = HopsworksRMAppSecurityActions.this.now().plus(HopsworksRMAppSecurityActions.this.serviceJWTValidityPeriodSeconds, ChronoUnit.SECONDS);
                        for (int renewalTokenIdx = 0; renewalTokenIdx < HopsworksRMAppSecurityActions.this.renewalTokens.length; ++renewalTokenIdx) {
                            try {
                                ServiceTokenDTO renewedTokens = HopsworksRMAppSecurityActions.this.renewServiceJWT(HopsworksRMAppSecurityActions.this.masterToken, HopsworksRMAppSecurityActions.this.renewalTokens[renewalTokenIdx], expiresAt, now);
                                String oldMasterToken = HopsworksRMAppSecurityActions.this.masterToken;
                                HopsworksRMAppSecurityActions.this.masterToken = renewedTokens.jwt.token;
                                HopsworksRMAppSecurityActions.this.masterTokenExpiration = HopsworksRMAppSecurityActions.this.date2LocalDateTime(renewedTokens.jwt.expiresAt);
                                HopsworksRMAppSecurityActions.this.authHeader.set(HopsworksRMAppSecurityActions.this.createAuthenticationHeader(HopsworksRMAppSecurityActions.this.masterToken));
                                HopsworksRMAppSecurityActions.access$1302(HopsworksRMAppSecurityActions.this, renewedTokens.renewTokens);
                                try {
                                    HopsworksRMAppSecurityActions.this.invalidateServiceJWT(oldMasterToken);
                                }
                                catch (Exception ex) {
                                    LOG.warn((Object)"Failed to invalidate old service master JWT. Continue...");
                                }
                                HopsworksRMAppSecurityActions.this.sslConf.set(YarnConfiguration.RM_JWT_MASTER_TOKEN, HopsworksRMAppSecurityActions.this.masterToken);
                                for (int i = 0; i < HopsworksRMAppSecurityActions.this.renewalTokens.length; ++i) {
                                    String confKey = String.format(YarnConfiguration.RM_JWT_RENEW_TOKEN_PATTERN, i);
                                    HopsworksRMAppSecurityActions.this.sslConf.set(confKey, HopsworksRMAppSecurityActions.this.renewalTokens[i]);
                                }
                                URL sslServerURL = HopsworksRMAppSecurityActions.this.sslConf.getResource(HopsworksRMAppSecurityActions.this.conf.get("hadoop.ssl.server.conf", "ssl-server.xml"));
                                File sslServerFile = new File(sslServerURL.getFile());
                                try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(sslServerFile));){
                                    HopsworksRMAppSecurityActions.this.sslConf.writeXml((OutputStream)bos);
                                    bos.flush();
                                }
                                LOG.info((Object)"Updated service JWT");
                            }
                            catch (URISyntaxException ex) {
                                LOG.error((Object)("There is an error in service JWT renewal URI: " + HopsworksRMAppSecurityActions.this.serviceJWTRenewPath.toString()), (Throwable)ex);
                            }
                            catch (Exception ex) {
                                long backoffTimeout = this.backoff.getBackOffInMillis();
                                if (backoffTimeout != -1L) {
                                    LOG.warn((Object)("Error while trying to renew service JWT. Retrying in " + backoffTimeout + " ms"), (Throwable)ex);
                                    TimeUnit.MILLISECONDS.sleep(backoffTimeout);
                                    continue;
                                }
                                LOG.error((Object)"Could not renew service JWT. Manual update is necessary!", (Throwable)ex);
                            }
                            break;
                        }
                    }
                    TimeUnit.SECONDS.sleep(this.sleepPeriodSeconds);
                }
                catch (InterruptedException ex) {
                    LOG.warn((Object)"Service JWT renewer has been interrupted");
                    Thread.currentThread().interrupt();
                }
            }
        }
    }
}

