/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.security;

import java.io.IOException;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.Date;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.server.resourcemanager.security.JWTSecurityHandler;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMAppSecurityActions;
import org.apache.hadoop.yarn.server.resourcemanager.security.X509SecurityHandler;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequest;

public class TestingRMAppSecurityActions
implements RMAppSecurityActions,
Configurable {
    private static final Logger LOG = LogManager.getLogger(TestingRMAppSecurityActions.class);
    private static final String KEY_ALGORITHM = "RSA";
    private static final String SIGNATURE_ALGORITHM = "SHA256withRSA";
    private static final int KEY_SIZE = 1024;
    private KeyPair caKeyPair;
    private X509Certificate caCert;
    private ContentSigner sigGen;
    private Configuration conf;

    public X509Certificate getCaCert() {
        return this.caCert;
    }

    @Override
    public void init() throws MalformedURLException, GeneralSecurityException {
        Security.addProvider((Provider)new BouncyCastleProvider());
        KeyPairGenerator kpg = KeyPairGenerator.getInstance(KEY_ALGORITHM, "BC");
        kpg.initialize(1024);
        this.caKeyPair = kpg.genKeyPair();
        X500NameBuilder subjectBuilder = new X500NameBuilder(BCStyle.INSTANCE);
        subjectBuilder.addRDN(BCStyle.CN, "RootCA");
        try {
            this.sigGen = new JcaContentSignerBuilder(SIGNATURE_ALGORITHM).setProvider("BC").build(this.caKeyPair.getPrivate());
            JcaX509v3CertificateBuilder certGen = new JcaX509v3CertificateBuilder(subjectBuilder.build(), BigInteger.ONE, new Date(), new Date(System.currentTimeMillis() + 600000L), subjectBuilder.build(), this.caKeyPair.getPublic());
            this.caCert = new JcaX509CertificateConverter().setProvider("BC").getCertificate(certGen.build(this.sigGen));
            this.caCert.checkValidity();
            this.caCert.verify(this.caKeyPair.getPublic());
            this.caCert.verify(this.caCert.getPublicKey());
        }
        catch (OperatorCreationException ex) {
            throw new GeneralSecurityException(ex);
        }
    }

    @Override
    public void destroy() {
        LOG.debug((Object)"Nothing to do here");
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public X509SecurityHandler.CertificateBundle sign(PKCS10CertificationRequest csr) throws URISyntaxException, IOException, GeneralSecurityException {
        JcaPKCS10CertificationRequest jcaRequest = new JcaPKCS10CertificationRequest(csr);
        JcaX509v3CertificateBuilder certBuilder = new JcaX509v3CertificateBuilder(this.caCert, BigInteger.valueOf(System.currentTimeMillis()), new Date(), new Date(System.currentTimeMillis() + 50000L), csr.getSubject(), jcaRequest.getPublicKey());
        JcaX509ExtensionUtils extensionUtils = new JcaX509ExtensionUtils();
        certBuilder.addExtension(Extension.authorityKeyIdentifier, false, (ASN1Encodable)extensionUtils.createAuthorityKeyIdentifier(this.caCert)).addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)extensionUtils.createSubjectKeyIdentifier(jcaRequest.getPublicKey())).addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(false)).addExtension(Extension.keyUsage, true, (ASN1Encodable)new KeyUsage(160));
        X509Certificate certificate = new JcaX509CertificateConverter().setProvider("BC").getCertificate(certBuilder.build(this.sigGen));
        return new X509SecurityHandler.CertificateBundle(certificate, this.caCert);
    }

    @Override
    public int revoke(String certificateIdentifier) throws URISyntaxException, IOException {
        LOG.info((Object)("Revoking certificate " + certificateIdentifier));
        return 200;
    }

    @Override
    public String generateJWT(JWTSecurityHandler.JWTMaterialParameter jwtParameter) throws URISyntaxException, IOException {
        return RandomStringUtils.randomAlphanumeric((int)16);
    }

    @Override
    public void invalidateJWT(String signingKeyName) throws URISyntaxException, IOException {
        LOG.info((Object)("Invalidating JWT signing key " + signingKeyName));
    }

    @Override
    public String renewJWT(JWTSecurityHandler.JWTMaterialParameter jwtParameter) throws URISyntaxException, IOException {
        LOG.info((Object)("Renewing JWT " + jwtParameter.getAppUser() + "/" + jwtParameter.getApplicationId()));
        return RandomStringUtils.randomAlphanumeric((int)16);
    }
}

