/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp.dao;

import com.google.common.base.Joiner;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationResourceUsageReport;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.LogAggregationStatus;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerApp;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ResourcesInfo;
import org.apache.hadoop.yarn.util.Times;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;

@XmlRootElement(name="app")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class AppInfo {
    @XmlTransient
    protected String appIdNum;
    @XmlTransient
    protected boolean trackingUrlIsNotReady;
    @XmlTransient
    protected String trackingUrlPretty;
    @XmlTransient
    protected boolean amContainerLogsExist = false;
    @XmlTransient
    protected ApplicationId applicationId;
    @XmlTransient
    private String schemePrefix;
    protected String id;
    protected String user;
    protected String name;
    protected String queue;
    protected YarnApplicationState state;
    protected FinalApplicationStatus finalStatus;
    protected float progress;
    protected String trackingUI;
    protected String trackingUrl;
    protected String diagnostics;
    protected long clusterId;
    protected String applicationType;
    protected String applicationTags = "";
    protected int priority;
    protected long startedTime;
    protected long finishedTime;
    protected long elapsedTime;
    protected String amContainerLogs;
    protected String amHostHttpAddress;
    private String amRPCAddress;
    protected long allocatedMB;
    protected long allocatedVCores;
    protected int allocatedGPUs;
    protected int runningContainers;
    protected long memorySeconds;
    protected long vcoreSeconds;
    protected long gpuSeconds;
    protected float queueUsagePercentage;
    protected float clusterUsagePercentage;
    protected long preemptedResourceMB;
    protected long preemptedResourceVCores;
    protected int preemptedResourceGPUs;
    protected int numNonAMContainerPreempted;
    protected int numAMContainerPreempted;
    private long preemptedMemorySeconds;
    private long preemptedVcoreSeconds;
    private long preemptedGPUSeconds;
    protected List<ResourceRequest> resourceRequests;
    protected LogAggregationStatus logAggregationStatus;
    protected boolean unmanagedApplication;
    protected String appNodeLabelExpression;
    protected String amNodeLabelExpression;
    protected ResourcesInfo resourceInfo = null;

    public AppInfo() {
    }

    public AppInfo(ResourceManager rm, RMApp app, Boolean hasAccess, String schemePrefix) {
        this.schemePrefix = schemePrefix;
        if (app != null) {
            RMAppAttempt attempt;
            String trackingUrl = app.getTrackingUrl();
            this.state = app.createApplicationState();
            boolean bl = this.trackingUrlIsNotReady = trackingUrl == null || trackingUrl.isEmpty() || YarnApplicationState.NEW == this.state || YarnApplicationState.NEW_SAVING == this.state || YarnApplicationState.SUBMITTED == this.state || YarnApplicationState.ACCEPTED == this.state;
            this.trackingUI = this.trackingUrlIsNotReady ? "UNASSIGNED" : (app.getFinishTime() == 0L ? "ApplicationMaster" : "History");
            this.trackingUrlPretty = !this.trackingUrlIsNotReady ? (this.trackingUrl = WebAppUtils.getURLWithScheme((String)schemePrefix, (String)trackingUrl)) : "UNASSIGNED";
            this.applicationId = app.getApplicationId();
            this.applicationType = app.getApplicationType();
            this.appIdNum = String.valueOf(app.getApplicationId().getId());
            this.id = app.getApplicationId().toString();
            this.user = app.getUser().toString();
            this.name = app.getName().toString();
            this.queue = app.getQueue().toString();
            this.priority = 0;
            ApplicationSubmissionContext appSubmissionContext = app.getApplicationSubmissionContext();
            if (appSubmissionContext.getPriority() != null) {
                this.priority = appSubmissionContext.getPriority().getPriority();
            }
            this.progress = app.getProgress() * 100.0f;
            this.diagnostics = app.getDiagnostics().toString();
            if (this.diagnostics == null || this.diagnostics.isEmpty()) {
                this.diagnostics = "";
            }
            if (app.getApplicationTags() != null && !app.getApplicationTags().isEmpty()) {
                this.applicationTags = Joiner.on((char)',').join(app.getApplicationTags());
            }
            this.finalStatus = app.getFinalApplicationStatus();
            this.clusterId = ResourceManager.getClusterTimeStamp();
            if (hasAccess.booleanValue()) {
                this.startedTime = app.getStartTime();
                this.finishedTime = app.getFinishTime();
                this.elapsedTime = Times.elapsed((long)app.getStartTime(), (long)app.getFinishTime());
                this.logAggregationStatus = app.getLogAggregationStatusForAppReport();
                RMAppAttempt attempt2 = app.getCurrentAppAttempt();
                if (attempt2 != null) {
                    Container masterContainer = attempt2.getMasterContainer();
                    if (masterContainer != null) {
                        this.amContainerLogsExist = true;
                        this.amContainerLogs = WebAppUtils.getRunningLogURL((String)(schemePrefix + masterContainer.getNodeHttpAddress()), (String)masterContainer.getId().toString(), (String)app.getUser());
                        this.amHostHttpAddress = masterContainer.getNodeHttpAddress();
                    }
                    this.amRPCAddress = AppInfo.getAmRPCAddressFromRMAppAttempt(attempt2);
                    ApplicationResourceUsageReport resourceReport = attempt2.getApplicationResourceUsageReport();
                    if (resourceReport != null) {
                        Resource usedResources = resourceReport.getUsedResources();
                        this.allocatedMB = usedResources.getMemorySize();
                        this.allocatedVCores = usedResources.getVirtualCores();
                        this.allocatedGPUs = usedResources.getGPUs();
                        this.runningContainers = resourceReport.getNumUsedContainers();
                        this.queueUsagePercentage = resourceReport.getQueueUsagePercentage();
                        this.clusterUsagePercentage = resourceReport.getClusterUsagePercentage();
                    }
                    this.resourceRequests = rm.getRMContext().getScheduler().getPendingResourceRequestsForAttempt(attempt2.getAppAttemptId());
                }
            }
            RMAppMetrics appMetrics = app.getRMAppMetrics();
            this.numAMContainerPreempted = appMetrics.getNumAMContainersPreempted();
            this.preemptedResourceMB = appMetrics.getResourcePreempted().getMemorySize();
            this.numNonAMContainerPreempted = appMetrics.getNumNonAMContainersPreempted();
            this.preemptedResourceVCores = appMetrics.getResourcePreempted().getVirtualCores();
            this.preemptedResourceGPUs = appMetrics.getResourcePreempted().getGPUs();
            this.memorySeconds = appMetrics.getMemorySeconds();
            this.vcoreSeconds = appMetrics.getVcoreSeconds();
            this.gpuSeconds = appMetrics.getGPUSeconds();
            this.preemptedMemorySeconds = appMetrics.getPreemptedMemorySeconds();
            this.preemptedVcoreSeconds = appMetrics.getPreemptedVcoreSeconds();
            this.preemptedGPUSeconds = appMetrics.getPreemptedGPUSeconds();
            this.unmanagedApplication = appSubmissionContext.getUnmanagedAM();
            this.appNodeLabelExpression = app.getApplicationSubmissionContext().getNodeLabelExpression();
            this.amNodeLabelExpression = this.unmanagedApplication ? null : app.getAMResourceRequest().getNodeLabelExpression();
            ResourceScheduler scheduler = rm.getRMContext().getScheduler();
            if (scheduler instanceof CapacityScheduler && null != (attempt = app.getCurrentAppAttempt())) {
                FiCaSchedulerApp ficaAppAttempt = ((CapacityScheduler)scheduler).getApplicationAttempt(attempt.getAppAttemptId());
                this.resourceInfo = null != ficaAppAttempt ? new ResourcesInfo(ficaAppAttempt.getSchedulingResourceUsage()) : null;
            }
        }
    }

    public boolean isTrackingUrlReady() {
        return !this.trackingUrlIsNotReady;
    }

    public ApplicationId getApplicationId() {
        return this.applicationId;
    }

    public String getAppId() {
        return this.id;
    }

    public String getAppIdNum() {
        return this.appIdNum;
    }

    public String getUser() {
        return this.user;
    }

    public String getQueue() {
        return this.queue;
    }

    public String getName() {
        return this.name;
    }

    public YarnApplicationState getState() {
        return this.state;
    }

    public float getProgress() {
        return this.progress;
    }

    public String getTrackingUI() {
        return this.trackingUI;
    }

    public String getNote() {
        return this.diagnostics;
    }

    public FinalApplicationStatus getFinalStatus() {
        return this.finalStatus;
    }

    public String getTrackingUrl() {
        return this.trackingUrl;
    }

    public String getTrackingUrlPretty() {
        return this.trackingUrlPretty;
    }

    public long getStartTime() {
        return this.startedTime;
    }

    public long getFinishTime() {
        return this.finishedTime;
    }

    public long getElapsedTime() {
        return this.elapsedTime;
    }

    public String getAMContainerLogs() {
        return this.amContainerLogs;
    }

    public String getAMHostHttpAddress() {
        return this.amHostHttpAddress;
    }

    public String getAmRPCAddress() {
        return this.amRPCAddress;
    }

    public static String getAmRPCAddressFromRMAppAttempt(RMAppAttempt attempt) {
        String amRPCAddress = null;
        if (attempt != null) {
            String amHost = attempt.getHost();
            int amRpcPort = attempt.getRpcPort();
            if (!"N/A".equals(amHost) && amRpcPort != -1) {
                amRPCAddress = amHost + ":" + amRpcPort;
            }
        }
        return amRPCAddress;
    }

    public boolean amContainerLogsExist() {
        return this.amContainerLogsExist;
    }

    public long getClusterId() {
        return this.clusterId;
    }

    public String getApplicationType() {
        return this.applicationType;
    }

    public String getApplicationTags() {
        return this.applicationTags;
    }

    public int getRunningContainers() {
        return this.runningContainers;
    }

    public long getAllocatedMB() {
        return this.allocatedMB;
    }

    public long getAllocatedVCores() {
        return this.allocatedVCores;
    }

    public int getAllocatedGPUs() {
        return this.allocatedGPUs;
    }

    public long getPreemptedMB() {
        return this.preemptedResourceMB;
    }

    public long getPreemptedVCores() {
        return this.preemptedResourceVCores;
    }

    public int getPreemptedGPUs() {
        return this.preemptedResourceGPUs;
    }

    public int getNumNonAMContainersPreempted() {
        return this.numNonAMContainerPreempted;
    }

    public int getNumAMContainersPreempted() {
        return this.numAMContainerPreempted;
    }

    public long getMemorySeconds() {
        return this.memorySeconds;
    }

    public long getVcoreSeconds() {
        return this.vcoreSeconds;
    }

    public long getGPUSeconds() {
        return this.gpuSeconds;
    }

    public long getPreemptedMemorySeconds() {
        return this.preemptedMemorySeconds;
    }

    public long getPreemptedVcoreSeconds() {
        return this.preemptedVcoreSeconds;
    }

    public long getPreemptedGPUSeconds() {
        return this.preemptedGPUSeconds;
    }

    public List<ResourceRequest> getResourceRequests() {
        return this.resourceRequests;
    }

    public LogAggregationStatus getLogAggregationStatus() {
        return this.logAggregationStatus;
    }

    public boolean isUnmanagedApp() {
        return this.unmanagedApplication;
    }

    public int getPriority() {
        return this.priority;
    }

    public String getAppNodeLabelExpression() {
        return this.appNodeLabelExpression;
    }

    public String getAmNodeLabelExpression() {
        return this.amNodeLabelExpression;
    }

    public ResourcesInfo getResourceInfo() {
        return this.resourceInfo;
    }
}

