/*
 * Decompiled with CFR 0.152.
 */
package io.hops.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;

public abstract class StreamingReceiver {
    protected final Log LOG = LogFactory.getLog(StreamingReceiver.class);
    Thread retrievingThread = null;
    protected final RMContext rmContext;
    private Runnable retrievingRunnable;
    private final String threadName;
    protected boolean running = false;

    public StreamingReceiver(RMContext rmContext, String threadName) {
        this.rmContext = rmContext;
        this.threadName = threadName;
    }

    protected void setRetrievingRunnable(Runnable retrievingRunnable) {
        this.retrievingRunnable = retrievingRunnable;
    }

    public void start() {
        if (this.retrievingThread == null) {
            this.running = true;
            this.LOG.debug((Object)("HOP :: Creating " + this.threadName));
            this.retrievingThread = new Thread(this.retrievingRunnable);
            this.retrievingThread.setName(this.threadName);
            this.retrievingThread.start();
        } else {
            this.LOG.error((Object)("HOP :: " + this.threadName + " has already started"));
        }
    }

    public void stop() {
        this.running = false;
        if (this.retrievingThread != null) {
            this.retrievingThread.interrupt();
        }
    }
}

