/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.amlauncher;

import com.google.common.annotations.VisibleForTesting;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DataInputByteBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.ContainerManagementProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainerRequest;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainersRequest;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainersResponse;
import org.apache.hadoop.yarn.api.protocolrecords.StopContainersRequest;
import org.apache.hadoop.yarn.api.protocolrecords.StopContainersResponse;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.SerializedException;
import org.apache.hadoop.yarn.client.NMProxy;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.security.AMRMTokenIdentifier;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.amlauncher.AMLauncherEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptImpl;
import org.apache.hadoop.yarn.server.resourcemanager.security.JWTSecurityHandler;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMAppSecurityManager;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMAppSecurityManagerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMAppSecurityManagerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMAppSecurityMaterial;
import org.apache.hadoop.yarn.server.resourcemanager.security.X509SecurityHandler;
import org.apache.hadoop.yarn.util.ConverterUtils;

public class AMLauncher
implements Runnable {
    private static final Log LOG = LogFactory.getLog(AMLauncher.class);
    private ContainerManagementProtocol containerMgrProxy;
    private final RMAppAttempt application;
    private final Configuration conf;
    private final AMLauncherEventType eventType;
    private final RMContext rmContext;
    private final Container masterContainer;
    private final EnumSet<RMAppState> appFinalStates = EnumSet.of(RMAppState.FINISHED, RMAppState.KILLED);
    private final EventHandler handler;

    public AMLauncher(RMContext rmContext, RMAppAttempt application, AMLauncherEventType eventType, Configuration conf) {
        this.application = application;
        this.conf = conf;
        this.eventType = eventType;
        this.rmContext = rmContext;
        this.handler = rmContext.getDispatcher().getEventHandler();
        this.masterContainer = application.getMasterContainer();
    }

    private void connect() throws IOException {
        ContainerId masterContainerID = this.masterContainer.getId();
        this.containerMgrProxy = this.getContainerMgrProxy(masterContainerID);
    }

    private void launch() throws IOException, YarnException {
        StartContainersResponse response;
        this.connect();
        ContainerId masterContainerID = this.masterContainer.getId();
        ApplicationSubmissionContext applicationContext = this.application.getSubmissionContext();
        LOG.info((Object)("Setting up container " + this.masterContainer + " for AM " + this.application.getAppAttemptId()));
        ContainerLaunchContext launchContext = this.createAMContainerLaunchContext(applicationContext, masterContainerID);
        StartContainerRequest scRequest = StartContainerRequest.newInstance((ContainerLaunchContext)launchContext, (org.apache.hadoop.yarn.api.records.Token)this.masterContainer.getContainerToken());
        ArrayList<StartContainerRequest> list = new ArrayList<StartContainerRequest>();
        list.add(scRequest);
        StartContainersRequest allRequests = StartContainersRequest.newInstance(list);
        RMApp rmApp = (RMApp)this.rmContext.getRMApps().get(this.application.getAppAttemptId().getApplicationId());
        if (this.conf.getBoolean("ipc.server.ssl.enabled", false)) {
            this.setupX509Material(allRequests, rmApp);
        }
        if (this.conf.getBoolean(YarnConfiguration.RM_JWT_ENABLED, YarnConfiguration.DEFAULT_RM_JWT_ENABLED)) {
            this.setupJWTMaterial(allRequests, rmApp);
        }
        if ((response = this.containerMgrProxy.startContainers(allRequests)).getFailedRequests() != null && response.getFailedRequests().containsKey(masterContainerID)) {
            Throwable t = ((SerializedException)response.getFailedRequests().get(masterContainerID)).deSerialize();
            this.parseAndThrowException(t);
        } else {
            LOG.info((Object)("Done launching container " + this.masterContainer + " for AM " + this.application.getAppAttemptId()));
        }
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    protected void setupX509Material(StartContainersRequest request, RMApp application) {
        request.setKeyStore(ByteBuffer.wrap(application.getKeyStore()));
        request.setKeyStorePassword(String.valueOf(application.getKeyStorePassword()));
        request.setTrustStore(ByteBuffer.wrap(application.getTrustStore()));
        request.setTrustStorePassword(String.valueOf(application.getTrustStorePassword()));
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    protected void setupJWTMaterial(StartContainersRequest request, RMApp application) {
        request.setJWT(application.getJWT());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanup() throws IOException, YarnException {
        try {
            this.connect();
            ContainerId containerId = this.masterContainer.getId();
            ArrayList<ContainerId> containerIds = new ArrayList<ContainerId>();
            containerIds.add(containerId);
            StopContainersRequest stopRequest = StopContainersRequest.newInstance(containerIds);
            StopContainersResponse response = this.containerMgrProxy.stopContainers(stopRequest);
            if (response.getFailedRequests() != null && response.getFailedRequests().containsKey(containerId)) {
                Throwable t = ((SerializedException)response.getFailedRequests().get(containerId)).deSerialize();
                this.parseAndThrowException(t);
            }
        }
        finally {
            RMApp application = (RMApp)this.rmContext.getRMApps().get(this.application.getAppAttemptId().getApplicationId());
            X509SecurityHandler.X509MaterialParameter x509Param = new X509SecurityHandler.X509MaterialParameter(application.getApplicationId(), application.getUser(), application.getCryptoMaterialVersion());
            JWTSecurityHandler.JWTMaterialParameter jwtParam = new JWTSecurityHandler.JWTMaterialParameter(application.getApplicationId(), application.getUser());
            RMAppSecurityMaterial<RMAppSecurityManager.SecurityManagerMaterial> securityMaterial = new RMAppSecurityMaterial<RMAppSecurityManager.SecurityManagerMaterial>();
            securityMaterial.addMaterial(x509Param);
            securityMaterial.addMaterial(jwtParam);
            RMAppSecurityManagerEvent securityMaterialCleanup = new RMAppSecurityManagerEvent(application.getApplicationId(), securityMaterial, RMAppSecurityManagerEventType.REVOKE_SECURITY_MATERIAL);
            this.handler.handle((Event)securityMaterialCleanup);
        }
    }

    protected ContainerManagementProtocol getContainerMgrProxy(ContainerId containerId) {
        NodeId node = this.masterContainer.getNodeId();
        InetSocketAddress containerManagerConnectAddress = NetUtils.createSocketAddrForHost((String)node.getHost(), (int)node.getPort());
        YarnRPC rpc = this.getYarnRPC();
        String user = ((RMApp)this.rmContext.getRMApps().get(containerId.getApplicationAttemptId().getApplicationId())).getUser();
        UserGroupInformation realUser = UserGroupInformation.createRemoteUser((String)user);
        org.apache.hadoop.yarn.api.records.Token token = this.rmContext.getNMTokenSecretManager().createNMToken(containerId.getApplicationAttemptId(), node, user);
        realUser.addToken(ConverterUtils.convertFromYarn((org.apache.hadoop.yarn.api.records.Token)token, (InetSocketAddress)containerManagerConnectAddress));
        realUser.addApplicationId(containerId.getApplicationAttemptId().getApplicationId().toString());
        return (ContainerManagementProtocol)NMProxy.createNMProxy((Configuration)this.conf, ContainerManagementProtocol.class, (UserGroupInformation)realUser, (YarnRPC)rpc, (InetSocketAddress)containerManagerConnectAddress);
    }

    @VisibleForTesting
    protected YarnRPC getYarnRPC() {
        return YarnRPC.create((Configuration)this.conf);
    }

    private ContainerLaunchContext createAMContainerLaunchContext(ApplicationSubmissionContext applicationMasterContext, ContainerId containerID) throws IOException {
        ContainerLaunchContext container = applicationMasterContext.getAMContainerSpec();
        this.setupTokens(container, containerID);
        return container;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    protected void setupTokens(ContainerLaunchContext container, ContainerId containerID) throws IOException {
        Token<AMRMTokenIdentifier> amrmToken;
        Map environment = container.getEnvironment();
        environment.put("APPLICATION_WEB_PROXY_BASE", this.application.getWebProxyBase());
        ApplicationId applicationId = this.application.getAppAttemptId().getApplicationId();
        environment.put("APP_SUBMIT_TIME_ENV", String.valueOf(((RMApp)this.rmContext.getRMApps().get(applicationId)).getSubmitTime()));
        environment.put("MAX_APP_ATTEMPTS", String.valueOf(((RMApp)this.rmContext.getRMApps().get(applicationId)).getMaxAppAttempts()));
        Credentials credentials = new Credentials();
        DataInputByteBuffer dibb = new DataInputByteBuffer();
        ByteBuffer tokens = container.getTokens();
        if (tokens != null) {
            dibb.reset(new ByteBuffer[]{tokens});
            credentials.readTokenStorageStream((DataInputStream)dibb);
            tokens.rewind();
        }
        if ((amrmToken = this.createAndSetAMRMToken()) != null) {
            credentials.addToken(amrmToken.getService(), amrmToken);
        }
        DataOutputBuffer dob = new DataOutputBuffer();
        credentials.writeTokenStorageToStream((DataOutputStream)dob);
        container.setTokens(ByteBuffer.wrap(dob.getData(), 0, dob.getLength()));
    }

    @VisibleForTesting
    protected Token<AMRMTokenIdentifier> createAndSetAMRMToken() {
        Token<AMRMTokenIdentifier> amrmToken = this.rmContext.getAMRMTokenSecretManager().createAndGetAMRMToken(this.application.getAppAttemptId());
        ((RMAppAttemptImpl)this.application).setAMRMToken(amrmToken);
        return amrmToken;
    }

    @Override
    public void run() {
        switch (this.eventType) {
            case LAUNCH: {
                try {
                    LOG.info((Object)("Launching master" + this.application.getAppAttemptId()));
                    this.launch();
                    this.handler.handle((Event)new RMAppAttemptEvent(this.application.getAppAttemptId(), RMAppAttemptEventType.LAUNCHED));
                }
                catch (Exception ie) {
                    String message = "Error launching " + this.application.getAppAttemptId() + ". Got exception: " + StringUtils.stringifyException((Throwable)ie);
                    LOG.info((Object)message);
                    this.handler.handle((Event)new RMAppAttemptEvent(this.application.getAppAttemptId(), RMAppAttemptEventType.LAUNCH_FAILED, message));
                }
                break;
            }
            case CLEANUP: {
                try {
                    LOG.info((Object)("Cleaning master " + this.application.getAppAttemptId()));
                    this.cleanup();
                }
                catch (IOException ie) {
                    LOG.info((Object)"Error cleaning master ", (Throwable)ie);
                }
                catch (YarnException e) {
                    StringBuilder sb = new StringBuilder("Container ");
                    sb.append(this.masterContainer.getId().toString());
                    sb.append(" is not handled by this NodeManager");
                    if (e.getMessage().contains(sb.toString())) break;
                    LOG.info((Object)"Error cleaning master ", (Throwable)e);
                }
                break;
            }
            default: {
                LOG.warn((Object)("Received unknown event-type " + (Object)((Object)this.eventType) + ". Ignoring."));
            }
        }
    }

    private void parseAndThrowException(Throwable t) throws YarnException, IOException {
        if (t instanceof YarnException) {
            throw (YarnException)t;
        }
        if (t instanceof SecretManager.InvalidToken) {
            throw (SecretManager.InvalidToken)t;
        }
        throw (IOException)t;
    }
}

