/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.CapacitySchedulerPreemptionContext;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.CapacitySchedulerPreemptionUtils;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.FifoIntraQueuePreemptionPlugin;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.IntraQueuePreemptionComputePlugin;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.PreemptionCandidatesSelector;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.TempAppPerPartition;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.TempQueuePerPartition;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerApp;
import org.apache.hadoop.yarn.util.resource.Resources;

public class IntraQueueCandidatesSelector
extends PreemptionCandidatesSelector {
    IntraQueuePreemptionComputePlugin fifoPreemptionComputePlugin = null;
    final CapacitySchedulerPreemptionContext context;
    private static final Log LOG = LogFactory.getLog(IntraQueueCandidatesSelector.class);

    IntraQueueCandidatesSelector(CapacitySchedulerPreemptionContext preemptionContext) {
        super(preemptionContext);
        this.fifoPreemptionComputePlugin = new FifoIntraQueuePreemptionPlugin(this.rc, preemptionContext);
        this.context = preemptionContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<ApplicationAttemptId, Set<RMContainer>> selectCandidates(Map<ApplicationAttemptId, Set<RMContainer>> selectedCandidates, Resource clusterResource, Resource totalPreemptedResourceAllowed) {
        this.computeIntraQueuePreemptionDemand(clusterResource, totalPreemptedResourceAllowed, selectedCandidates);
        CapacitySchedulerPreemptionUtils.deductPreemptableResourcesBasedSelectedCandidates(this.preemptionContext, selectedCandidates);
        for (String partition : this.preemptionContext.getAllPartitions()) {
            LinkedHashSet<String> queueNames = this.preemptionContext.getUnderServedQueuesPerPartition(partition);
            if (null == queueNames) continue;
            for (String queueName : queueNames) {
                LeafQueue leafQueue = this.preemptionContext.getQueueByPartition((String)queueName, (String)"").leafQueue;
                if (null == leafQueue || leafQueue.getPreemptionDisabled()) continue;
                Map<String, Resource> resToObtainByPartition = this.fifoPreemptionComputePlugin.getResourceDemandFromAppsPerQueue(queueName, partition);
                LeafQueue leafQueue2 = leafQueue;
                synchronized (leafQueue2) {
                    Iterator<FiCaSchedulerApp> desc = leafQueue.getOrderingPolicy().getPreemptionIterator();
                    while (desc.hasNext()) {
                        FiCaSchedulerApp app = desc.next();
                        this.preemptFromLeastStarvedApp(selectedCandidates, clusterResource, totalPreemptedResourceAllowed, resToObtainByPartition, leafQueue, app);
                    }
                }
            }
        }
        return selectedCandidates;
    }

    private void preemptFromLeastStarvedApp(Map<ApplicationAttemptId, Set<RMContainer>> selectedCandidates, Resource clusterResource, Resource totalPreemptedResourceAllowed, Map<String, Resource> resToObtainByPartition, LeafQueue leafQueue, FiCaSchedulerApp app) {
        ArrayList<RMContainer> liveContainers = new ArrayList<RMContainer>(app.getLiveContainers());
        IntraQueueCandidatesSelector.sortContainers(liveContainers);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("totalPreemptedResourceAllowed for preemption at this round is :" + totalPreemptedResourceAllowed));
        }
        for (RMContainer c : liveContainers) {
            if (resToObtainByPartition.isEmpty()) {
                return;
            }
            if (CapacitySchedulerPreemptionUtils.isContainerAlreadySelected(c, selectedCandidates) || null != this.preemptionContext.getKillableContainers() && this.preemptionContext.getKillableContainers().contains(c.getContainerId()) || c.isAMContainer()) continue;
            CapacitySchedulerPreemptionUtils.tryPreemptContainerAndDeductResToObtain(this.rc, this.preemptionContext, resToObtainByPartition, c, clusterResource, selectedCandidates, totalPreemptedResourceAllowed);
        }
    }

    private void computeIntraQueuePreemptionDemand(Resource clusterResource, Resource totalPreemptedResourceAllowed, Map<ApplicationAttemptId, Set<RMContainer>> selectedCandidates) {
        for (String partition : this.context.getAllPartitions()) {
            LinkedHashSet<String> queueNames = this.context.getUnderServedQueuesPerPartition(partition);
            if (null == queueNames) continue;
            Resource partitionBasedResource = this.context.getPartitionResource(partition);
            for (String queueName : queueNames) {
                TempQueuePerPartition tq = this.context.getQueueByPartition(queueName, partition);
                LeafQueue leafQueue = tq.leafQueue;
                if (null == leafQueue) continue;
                Resource queueReassignableResource = Resources.subtract((Resource)tq.getUsed(), (Resource)tq.getActuallyToBePreempted());
                if (leafQueue.getQueueCapacities().getUsedCapacity(partition) < this.context.getMinimumThresholdForIntraQueuePreemption()) continue;
                this.fifoPreemptionComputePlugin.computeAppsIdealAllocation(clusterResource, partitionBasedResource, tq, selectedCandidates, totalPreemptedResourceAllowed, queueReassignableResource, this.context.getMaxAllowableLimitForIntraQueuePreemption());
            }
        }
    }

    static class TAPriorityComparator
    implements Serializable,
    Comparator<TempAppPerPartition> {
        TAPriorityComparator() {
        }

        @Override
        public int compare(TempAppPerPartition tq1, TempAppPerPartition tq2) {
            Priority p2;
            Priority p1 = Priority.newInstance((int)tq1.getPriority());
            if (!p1.equals((Object)(p2 = Priority.newInstance((int)tq2.getPriority())))) {
                return p1.compareTo(p2);
            }
            return tq1.getApplicationId().compareTo(tq2.getApplicationId());
        }
    }
}

