/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.rmapp;

import com.google.common.annotations.VisibleForTesting;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DataInputByteBuffer;
import org.apache.hadoop.ipc.CallerContext;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationResourceUsageReport;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.LogAggregationStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.ReservationId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.security.AMRMTokenIdentifier;
import org.apache.hadoop.yarn.security.client.ClientToAMTokenIdentifier;
import org.apache.hadoop.yarn.server.api.protocolrecords.LogAggregationReport;
import org.apache.hadoop.yarn.server.resourcemanager.ApplicationMasterService;
import org.apache.hadoop.yarn.server.resourcemanager.RMAppManagerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.RMAppManagerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.RMAuditLogger;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.RMServerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.blacklist.BlacklistManager;
import org.apache.hadoop.yarn.server.resourcemanager.blacklist.DisabledBlacklistManager;
import org.apache.hadoop.yarn.server.resourcemanager.blacklist.SimpleBlacklistManager;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.Recoverable;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.ApplicationStateData;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppFailedAttemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppKillByClientEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppMoveEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppNodeUpdateEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppRecoverEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppRunningOnNodeEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppSecurityMaterialGeneratedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppSecurityMaterialRenewedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.AggregateAppResourceUsage;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppStartAttemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeCleanAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeUpdateCryptoMaterialForAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.YarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.security.JWTSecurityHandler;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMAppSecurityManager;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMAppSecurityManagerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMAppSecurityManagerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMAppSecurityMaterial;
import org.apache.hadoop.yarn.server.resourcemanager.security.X509SecurityHandler;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.server.webproxy.ProxyUriUtils;
import org.apache.hadoop.yarn.state.InvalidStateTransitionException;
import org.apache.hadoop.yarn.state.MultipleArcTransition;
import org.apache.hadoop.yarn.state.SingleArcTransition;
import org.apache.hadoop.yarn.state.StateMachine;
import org.apache.hadoop.yarn.state.StateMachineFactory;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.SystemClock;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;

public class RMAppImpl
implements RMApp,
Recoverable {
    private static final Log LOG = LogFactory.getLog(RMAppImpl.class);
    private static final String UNAVAILABLE = "N/A";
    private final ApplicationId applicationId;
    private final RMContext rmContext;
    private final Configuration conf;
    private final String user;
    private final String name;
    private final ApplicationSubmissionContext submissionContext;
    private final Dispatcher dispatcher;
    private final YarnScheduler scheduler;
    private final ApplicationMasterService masterService;
    private final StringBuilder diagnostics = new StringBuilder();
    private final int maxAppAttempts;
    private final ReentrantReadWriteLock.ReadLock readLock;
    private final ReentrantReadWriteLock.WriteLock writeLock;
    private final Map<ApplicationAttemptId, RMAppAttempt> attempts = new LinkedHashMap<ApplicationAttemptId, RMAppAttempt>();
    private final long submitTime;
    private final Set<RMNode> updatedNodes = new HashSet<RMNode>();
    private final String applicationType;
    private final Set<String> applicationTags;
    private final long attemptFailuresValidityInterval;
    private boolean amBlacklistingEnabled = false;
    private float blacklistDisableThreshold;
    private Clock systemClock;
    private boolean isNumAttemptsBeyondThreshold = false;
    private long startTime;
    private long finishTime = 0L;
    private long storedFinishTime = 0L;
    private volatile RMAppAttempt currentAttempt;
    private String queue;
    private EventHandler handler;
    private static final AppFinishedTransition FINISHED_TRANSITION = new AppFinishedTransition();
    private Set<NodeId> ranNodes = new ConcurrentSkipListSet<NodeId>();
    private final boolean logAggregationEnabled;
    private long logAggregationStartTime = 0L;
    private final long logAggregationStatusTimeout;
    private final Map<NodeId, LogAggregationReport> logAggregationStatus = new ConcurrentHashMap<NodeId, LogAggregationReport>();
    private volatile LogAggregationStatus logAggregationStatusForAppReport;
    private int logAggregationSucceed = 0;
    private int logAggregationFailed = 0;
    private Map<NodeId, List<String>> logAggregationDiagnosticsForNMs = new HashMap<NodeId, List<String>>();
    private Map<NodeId, List<String>> logAggregationFailureMessagesForNMs = new HashMap<NodeId, List<String>>();
    private final int maxLogAggregationDiagnosticsInMemory;
    private byte[] keyStore = null;
    private char[] keyStorePassword = null;
    private byte[] trustStore = null;
    private char[] trustStorePassword = null;
    private long certificateExpiration = -1L;
    private Integer cryptoMaterialVersion = 0;
    private String jwt;
    private Instant jwtExpiration;
    private RMAppState stateBeforeKilling;
    private RMAppState stateBeforeFinalSaving;
    private RMAppEvent eventCausingFinalSaving;
    private RMAppState targetedFinalState;
    private RMAppState recoveredFinalState;
    private ResourceRequest amReq;
    private CallerContext callerContext;
    Object transitionTodo;
    private static final StateMachineFactory<RMAppImpl, RMAppState, RMAppEventType, RMAppEvent> stateMachineFactory = new StateMachineFactory((Enum)RMAppState.NEW).addTransition((Enum)RMAppState.NEW, (Enum)RMAppState.NEW, (Enum)RMAppEventType.NODE_UPDATE, (SingleArcTransition)new RMAppNodeUpdateTransition()).addTransition((Enum)RMAppState.NEW, (Enum)RMAppState.NEW_SAVING, (Enum)RMAppEventType.START, (SingleArcTransition)new RMAppNewlySavingTransition()).addTransition((Enum)RMAppState.NEW, EnumSet.of(RMAppState.GENERATING_SECURITY_MATERIAL, new RMAppState[]{RMAppState.SUBMITTED, RMAppState.ACCEPTED, RMAppState.FINISHED, RMAppState.FAILED, RMAppState.KILLED, RMAppState.FINAL_SAVING}), (Enum)RMAppEventType.RECOVER, (MultipleArcTransition)new RMAppRecoveredTransition()).addTransition((Enum)RMAppState.NEW, (Enum)RMAppState.KILLED, (Enum)RMAppEventType.KILL, (SingleArcTransition)new AppKilledTransition()).addTransition((Enum)RMAppState.NEW, (Enum)RMAppState.FINAL_SAVING, (Enum)RMAppEventType.APP_REJECTED, (SingleArcTransition)new FinalSavingTransition(new AppRejectedTransition(), RMAppState.FAILED)).addTransition((Enum)RMAppState.NEW_SAVING, (Enum)RMAppState.NEW_SAVING, (Enum)RMAppEventType.NODE_UPDATE, (SingleArcTransition)new RMAppNodeUpdateTransition()).addTransition((Enum)RMAppState.NEW_SAVING, (Enum)RMAppState.GENERATING_SECURITY_MATERIAL, (Enum)RMAppEventType.APP_NEW_SAVED, (SingleArcTransition)new RMAppGeneratingSecurityMaterialTransition()).addTransition((Enum)RMAppState.NEW_SAVING, (Enum)RMAppState.FINAL_SAVING, (Enum)RMAppEventType.KILL, (SingleArcTransition)new FinalSavingTransition(new AppKilledTransition(), RMAppState.KILLED)).addTransition((Enum)RMAppState.NEW_SAVING, (Enum)RMAppState.FINAL_SAVING, (Enum)RMAppEventType.APP_REJECTED, (SingleArcTransition)new FinalSavingTransition(new AppRejectedTransition(), RMAppState.FAILED)).addTransition((Enum)RMAppState.NEW_SAVING, (Enum)RMAppState.NEW_SAVING, (Enum)RMAppEventType.MOVE, (SingleArcTransition)new RMAppMoveTransition()).addTransition((Enum)RMAppState.GENERATING_SECURITY_MATERIAL, (Enum)RMAppState.GENERATING_SECURITY_MATERIAL, (Enum)RMAppEventType.NODE_UPDATE, (SingleArcTransition)new RMAppNodeUpdateTransition()).addTransition((Enum)RMAppState.GENERATING_SECURITY_MATERIAL, (Enum)RMAppState.SUBMITTED, (Enum)RMAppEventType.SECURITY_MATERIAL_GENERATED, (SingleArcTransition)new AddApplicationToSchedulerTransition()).addTransition((Enum)RMAppState.GENERATING_SECURITY_MATERIAL, (Enum)RMAppState.FINAL_SAVING, (Enum)RMAppEventType.KILL, (SingleArcTransition)new FinalSavingTransition(new AppKilledTransition(), RMAppState.KILLED)).addTransition((Enum)RMAppState.SUBMITTED, (Enum)RMAppState.SUBMITTED, (Enum)RMAppEventType.NODE_UPDATE, (SingleArcTransition)new RMAppNodeUpdateTransition()).addTransition((Enum)RMAppState.SUBMITTED, (Enum)RMAppState.SUBMITTED, (Enum)RMAppEventType.MOVE, (SingleArcTransition)new RMAppMoveTransition()).addTransition((Enum)RMAppState.SUBMITTED, (Enum)RMAppState.FINAL_SAVING, (Enum)RMAppEventType.APP_REJECTED, (SingleArcTransition)new FinalSavingTransition(new AppRejectedTransition(), RMAppState.FAILED)).addTransition((Enum)RMAppState.SUBMITTED, (Enum)RMAppState.ACCEPTED, (Enum)RMAppEventType.APP_ACCEPTED, (SingleArcTransition)new StartAppAttemptTransition()).addTransition((Enum)RMAppState.SUBMITTED, (Enum)RMAppState.FINAL_SAVING, (Enum)RMAppEventType.KILL, (SingleArcTransition)new FinalSavingTransition(new AppKilledTransition(), RMAppState.KILLED)).addTransition((Enum)RMAppState.SUBMITTED, (Enum)RMAppState.SUBMITTED, (Enum)RMAppEventType.CERTS_RENEWED, (SingleArcTransition)new RMAppSecurityMaterialRenewedTransition()).addTransition((Enum)RMAppState.ACCEPTED, (Enum)RMAppState.ACCEPTED, (Enum)RMAppEventType.NODE_UPDATE, (SingleArcTransition)new RMAppNodeUpdateTransition()).addTransition((Enum)RMAppState.ACCEPTED, (Enum)RMAppState.ACCEPTED, (Enum)RMAppEventType.MOVE, (SingleArcTransition)new RMAppMoveTransition()).addTransition((Enum)RMAppState.ACCEPTED, (Enum)RMAppState.RUNNING, (Enum)RMAppEventType.ATTEMPT_REGISTERED, (SingleArcTransition)new RMAppStateUpdateTransition(YarnApplicationState.RUNNING)).addTransition((Enum)RMAppState.ACCEPTED, EnumSet.of(RMAppState.ACCEPTED, RMAppState.FINAL_SAVING), (Enum)RMAppEventType.ATTEMPT_FAILED, (MultipleArcTransition)new AttemptFailedTransition(RMAppState.ACCEPTED)).addTransition((Enum)RMAppState.ACCEPTED, (Enum)RMAppState.FINAL_SAVING, (Enum)RMAppEventType.ATTEMPT_FINISHED, (SingleArcTransition)new FinalSavingTransition(FINISHED_TRANSITION, RMAppState.FINISHED)).addTransition((Enum)RMAppState.ACCEPTED, (Enum)RMAppState.KILLING, (Enum)RMAppEventType.KILL, (SingleArcTransition)new KillAttemptTransition()).addTransition((Enum)RMAppState.ACCEPTED, (Enum)RMAppState.FINAL_SAVING, (Enum)RMAppEventType.ATTEMPT_KILLED, (SingleArcTransition)new FinalSavingTransition(new AppKilledTransition(), RMAppState.KILLED)).addTransition((Enum)RMAppState.ACCEPTED, (Enum)RMAppState.ACCEPTED, (Enum)RMAppEventType.APP_RUNNING_ON_NODE, (SingleArcTransition)new AppRunningOnNodeTransition()).addTransition((Enum)RMAppState.ACCEPTED, (Enum)RMAppState.ACCEPTED, (Enum)RMAppEventType.CERTS_RENEWED, (SingleArcTransition)new RMAppSecurityMaterialRenewedTransition()).addTransition((Enum)RMAppState.RUNNING, (Enum)RMAppState.RUNNING, (Enum)RMAppEventType.NODE_UPDATE, (SingleArcTransition)new RMAppNodeUpdateTransition()).addTransition((Enum)RMAppState.RUNNING, (Enum)RMAppState.RUNNING, (Enum)RMAppEventType.MOVE, (SingleArcTransition)new RMAppMoveTransition()).addTransition((Enum)RMAppState.RUNNING, (Enum)RMAppState.FINAL_SAVING, (Enum)RMAppEventType.ATTEMPT_UNREGISTERED, (SingleArcTransition)new FinalSavingTransition(new AttemptUnregisteredTransition(), RMAppState.FINISHING, RMAppState.FINISHED)).addTransition((Enum)RMAppState.RUNNING, (Enum)RMAppState.FINISHED, (Enum)RMAppEventType.ATTEMPT_FINISHED, (SingleArcTransition)FINISHED_TRANSITION).addTransition((Enum)RMAppState.RUNNING, (Enum)RMAppState.RUNNING, (Enum)RMAppEventType.APP_RUNNING_ON_NODE, (SingleArcTransition)new AppRunningOnNodeTransition()).addTransition((Enum)RMAppState.RUNNING, EnumSet.of(RMAppState.ACCEPTED, RMAppState.FINAL_SAVING), (Enum)RMAppEventType.ATTEMPT_FAILED, (MultipleArcTransition)new AttemptFailedTransition(RMAppState.ACCEPTED)).addTransition((Enum)RMAppState.RUNNING, (Enum)RMAppState.KILLING, (Enum)RMAppEventType.KILL, (SingleArcTransition)new KillAttemptTransition()).addTransition((Enum)RMAppState.RUNNING, (Enum)RMAppState.RUNNING, (Enum)RMAppEventType.CERTS_RENEWED, (SingleArcTransition)new RMAppSecurityMaterialRenewedTransition()).addTransition((Enum)RMAppState.FINAL_SAVING, EnumSet.of(RMAppState.FINISHING, RMAppState.FAILED, RMAppState.KILLED, RMAppState.FINISHED), (Enum)RMAppEventType.APP_UPDATE_SAVED, (MultipleArcTransition)new FinalStateSavedTransition()).addTransition((Enum)RMAppState.FINAL_SAVING, (Enum)RMAppState.FINAL_SAVING, (Enum)RMAppEventType.ATTEMPT_FINISHED, (SingleArcTransition)new AttemptFinishedAtFinalSavingTransition()).addTransition((Enum)RMAppState.FINAL_SAVING, (Enum)RMAppState.FINAL_SAVING, (Enum)RMAppEventType.APP_RUNNING_ON_NODE, (SingleArcTransition)new AppRunningOnNodeTransition()).addTransition((Enum)RMAppState.FINAL_SAVING, (Enum)RMAppState.FINAL_SAVING, EnumSet.of(RMAppEventType.NODE_UPDATE, RMAppEventType.KILL, RMAppEventType.APP_NEW_SAVED, RMAppEventType.MOVE)).addTransition((Enum)RMAppState.FINISHING, (Enum)RMAppState.FINISHED, (Enum)RMAppEventType.ATTEMPT_FINISHED, (SingleArcTransition)FINISHED_TRANSITION).addTransition((Enum)RMAppState.FINISHING, (Enum)RMAppState.FINISHING, (Enum)RMAppEventType.APP_RUNNING_ON_NODE, (SingleArcTransition)new AppRunningOnNodeTransition()).addTransition((Enum)RMAppState.FINISHING, (Enum)RMAppState.FINISHING, EnumSet.of(RMAppEventType.NODE_UPDATE, RMAppEventType.KILL, RMAppEventType.MOVE)).addTransition((Enum)RMAppState.KILLING, (Enum)RMAppState.KILLING, (Enum)RMAppEventType.APP_RUNNING_ON_NODE, (SingleArcTransition)new AppRunningOnNodeTransition()).addTransition((Enum)RMAppState.KILLING, (Enum)RMAppState.FINAL_SAVING, (Enum)RMAppEventType.ATTEMPT_KILLED, (SingleArcTransition)new FinalSavingTransition(new AppKilledTransition(), RMAppState.KILLED)).addTransition((Enum)RMAppState.KILLING, (Enum)RMAppState.FINAL_SAVING, (Enum)RMAppEventType.ATTEMPT_UNREGISTERED, (SingleArcTransition)new FinalSavingTransition(new AttemptUnregisteredTransition(), RMAppState.FINISHING, RMAppState.FINISHED)).addTransition((Enum)RMAppState.KILLING, (Enum)RMAppState.FINISHED, (Enum)RMAppEventType.ATTEMPT_FINISHED, (SingleArcTransition)FINISHED_TRANSITION).addTransition((Enum)RMAppState.KILLING, EnumSet.of(RMAppState.FINAL_SAVING), (Enum)RMAppEventType.ATTEMPT_FAILED, (MultipleArcTransition)new AttemptFailedTransition(RMAppState.KILLING)).addTransition((Enum)RMAppState.KILLING, (Enum)RMAppState.KILLING, EnumSet.of(RMAppEventType.NODE_UPDATE, RMAppEventType.ATTEMPT_REGISTERED, RMAppEventType.APP_UPDATE_SAVED, RMAppEventType.KILL, RMAppEventType.MOVE)).addTransition((Enum)RMAppState.FINISHED, (Enum)RMAppState.FINISHED, (Enum)RMAppEventType.APP_RUNNING_ON_NODE, (SingleArcTransition)new AppRunningOnNodeTransition()).addTransition((Enum)RMAppState.FINISHED, (Enum)RMAppState.FINISHED, EnumSet.of(RMAppEventType.NODE_UPDATE, RMAppEventType.ATTEMPT_UNREGISTERED, RMAppEventType.ATTEMPT_FINISHED, RMAppEventType.KILL, RMAppEventType.MOVE)).addTransition((Enum)RMAppState.FAILED, (Enum)RMAppState.FAILED, (Enum)RMAppEventType.APP_RUNNING_ON_NODE, (SingleArcTransition)new AppRunningOnNodeTransition()).addTransition((Enum)RMAppState.FAILED, (Enum)RMAppState.FAILED, EnumSet.of(RMAppEventType.KILL, RMAppEventType.NODE_UPDATE, RMAppEventType.MOVE)).addTransition((Enum)RMAppState.KILLED, (Enum)RMAppState.KILLED, (Enum)RMAppEventType.APP_RUNNING_ON_NODE, (SingleArcTransition)new AppRunningOnNodeTransition()).addTransition((Enum)RMAppState.KILLED, (Enum)RMAppState.KILLED, EnumSet.of(RMAppEventType.APP_ACCEPTED, new RMAppEventType[]{RMAppEventType.APP_REJECTED, RMAppEventType.KILL, RMAppEventType.ATTEMPT_FINISHED, RMAppEventType.ATTEMPT_FAILED, RMAppEventType.NODE_UPDATE, RMAppEventType.MOVE})).installTopology();
    private final StateMachine<RMAppState, RMAppEventType, RMAppEvent> stateMachine;
    private static final int DUMMY_APPLICATION_ATTEMPT_NUMBER = -1;
    private static final float MINIMUM_AM_BLACKLIST_THRESHOLD_VALUE = 0.0f;
    private static final float MAXIMUM_AM_BLACKLIST_THRESHOLD_VALUE = 1.0f;
    private AtomicBoolean isAppRotatingCryptoMaterial;
    private Set<NodeId> rmNodesThatUpdatedCryptoMaterial;
    private AtomicLong materialRotationStartTime;

    public RMAppImpl(ApplicationId applicationId, RMContext rmContext, Configuration config, String name, String user, String queue, ApplicationSubmissionContext submissionContext, YarnScheduler scheduler, ApplicationMasterService masterService, long submitTime, String applicationType, Set<String> applicationTags, ResourceRequest amReq) throws IOException {
        this.systemClock = new SystemClock();
        this.applicationId = applicationId;
        this.name = name;
        this.rmContext = rmContext;
        this.dispatcher = rmContext.getDispatcher();
        this.handler = this.dispatcher.getEventHandler();
        this.conf = config;
        this.user = user;
        this.queue = queue;
        this.submissionContext = submissionContext;
        this.scheduler = scheduler;
        this.masterService = masterService;
        this.submitTime = submitTime;
        this.startTime = this.systemClock.getTime();
        this.applicationType = applicationType;
        this.applicationTags = applicationTags;
        this.amReq = amReq;
        int globalMaxAppAttempts = this.conf.getInt("yarn.resourcemanager.am.max-attempts", 2);
        int individualMaxAppAttempts = submissionContext.getMaxAppAttempts();
        if (individualMaxAppAttempts <= 0 || individualMaxAppAttempts > globalMaxAppAttempts) {
            this.maxAppAttempts = globalMaxAppAttempts;
            LOG.warn((Object)("The specific max attempts: " + individualMaxAppAttempts + " for application: " + applicationId.getId() + " is invalid, because it is out of the range [1, " + globalMaxAppAttempts + "]. Use the global max attempts instead."));
        } else {
            this.maxAppAttempts = individualMaxAppAttempts;
        }
        this.attemptFailuresValidityInterval = submissionContext.getAttemptFailuresValidityInterval();
        if (this.attemptFailuresValidityInterval > 0L) {
            LOG.info((Object)("The attemptFailuresValidityInterval for the application: " + this.applicationId + " is " + this.attemptFailuresValidityInterval + "."));
        }
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
        this.stateMachine = stateMachineFactory.make((Object)this);
        this.callerContext = CallerContext.getCurrent();
        long localLogAggregationStatusTimeout = this.conf.getLong("yarn.log-aggregation-status.time-out.ms", 600000L);
        this.logAggregationStatusTimeout = localLogAggregationStatusTimeout <= 0L ? 600000L : localLogAggregationStatusTimeout;
        this.logAggregationEnabled = this.conf.getBoolean("yarn.log-aggregation-enable", false);
        this.logAggregationStatusForAppReport = this.logAggregationEnabled ? LogAggregationStatus.NOT_START : LogAggregationStatus.DISABLED;
        this.maxLogAggregationDiagnosticsInMemory = this.conf.getInt("yarn.resourcemanager.max-log-aggregation-diagnostics-in-memory", 10);
        this.amBlacklistingEnabled = this.conf.getBoolean("yarn.resourcemanager.am-scheduling.node-blacklisting-enabled", false);
        if (this.amBlacklistingEnabled) {
            this.blacklistDisableThreshold = this.conf.getFloat("yarn.resourcemanager.am-scheduling.node-blacklisting-disable-threshold", 0.2f);
            if (this.blacklistDisableThreshold < 0.0f || this.blacklistDisableThreshold > 1.0f) {
                this.blacklistDisableThreshold = 0.2f;
            }
        }
        this.isAppRotatingCryptoMaterial = new AtomicBoolean(false);
        this.materialRotationStartTime = new AtomicLong(-1L);
    }

    @Override
    public ApplicationId getApplicationId() {
        return this.applicationId;
    }

    @Override
    public ApplicationSubmissionContext getApplicationSubmissionContext() {
        return this.submissionContext;
    }

    @Override
    public FinalApplicationStatus getFinalApplicationStatus() {
        if (this.currentAttempt != null && this.currentAttempt.getFinalApplicationStatus() != null) {
            return this.currentAttempt.getFinalApplicationStatus();
        }
        return this.createFinalApplicationStatus((RMAppState)this.stateMachine.getCurrentState());
    }

    @Override
    public RMAppState getState() {
        this.readLock.lock();
        try {
            RMAppState rMAppState = (RMAppState)this.stateMachine.getCurrentState();
            return rMAppState;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public float getProgress() {
        RMAppAttempt attempt = this.currentAttempt;
        if (attempt != null) {
            return attempt.getProgress();
        }
        return 0.0f;
    }

    @Override
    public RMAppAttempt getRMAppAttempt(ApplicationAttemptId appAttemptId) {
        this.readLock.lock();
        try {
            RMAppAttempt rMAppAttempt = this.attempts.get(appAttemptId);
            return rMAppAttempt;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public String getQueue() {
        return this.queue;
    }

    @Override
    public void setQueue(String queue) {
        this.queue = queue;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public RMAppAttempt getCurrentAppAttempt() {
        return this.currentAttempt;
    }

    @Override
    public Map<ApplicationAttemptId, RMAppAttempt> getAppAttempts() {
        this.readLock.lock();
        try {
            Map<ApplicationAttemptId, RMAppAttempt> map = Collections.unmodifiableMap(this.attempts);
            return map;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private FinalApplicationStatus createFinalApplicationStatus(RMAppState state) {
        switch (state) {
            case NEW: 
            case GENERATING_SECURITY_MATERIAL: 
            case NEW_SAVING: 
            case SUBMITTED: 
            case ACCEPTED: 
            case RUNNING: 
            case FINAL_SAVING: 
            case KILLING: {
                return FinalApplicationStatus.UNDEFINED;
            }
            case FINISHING: 
            case FINISHED: 
            case FAILED: {
                return FinalApplicationStatus.FAILED;
            }
            case KILLED: {
                return FinalApplicationStatus.KILLED;
            }
        }
        throw new YarnRuntimeException("Unknown state passed!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int pullRMNodeUpdates(Collection<RMNode> updatedNodes) {
        this.writeLock.lock();
        try {
            int updatedNodeCount = this.updatedNodes.size();
            updatedNodes.addAll(this.updatedNodes);
            this.updatedNodes.clear();
            int n = updatedNodeCount;
            return n;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApplicationReport createAndGetApplicationReport(String clientUserName, boolean allowAccess) {
        this.readLock.lock();
        try {
            ApplicationAttemptId currentApplicationAttemptId = null;
            org.apache.hadoop.yarn.api.records.Token clientToAMToken = null;
            String trackingUrl = UNAVAILABLE;
            String host = UNAVAILABLE;
            String origTrackingUrl = UNAVAILABLE;
            LogAggregationStatus logAggregationStatus = null;
            int rpcPort = -1;
            ApplicationResourceUsageReport appUsageReport = RMServerUtils.DUMMY_APPLICATION_RESOURCE_USAGE_REPORT;
            FinalApplicationStatus finishState = this.getFinalApplicationStatus();
            String diags = UNAVAILABLE;
            float progress = 0.0f;
            org.apache.hadoop.yarn.api.records.Token amrmToken = null;
            if (allowAccess) {
                Token<AMRMTokenIdentifier> token;
                trackingUrl = this.getDefaultProxyTrackingUrl();
                if (this.currentAttempt != null) {
                    Token<ClientToAMTokenIdentifier> attemptClientToAMToken;
                    currentApplicationAttemptId = this.currentAttempt.getAppAttemptId();
                    trackingUrl = this.currentAttempt.getTrackingUrl();
                    origTrackingUrl = this.currentAttempt.getOriginalTrackingUrl();
                    if (UserGroupInformation.isSecurityEnabled() && (attemptClientToAMToken = this.currentAttempt.createClientToken(clientUserName)) != null) {
                        clientToAMToken = BuilderUtils.newClientToAMToken((byte[])attemptClientToAMToken.getIdentifier(), (String)attemptClientToAMToken.getKind().toString(), (byte[])attemptClientToAMToken.getPassword(), (String)attemptClientToAMToken.getService().toString());
                    }
                    host = this.currentAttempt.getHost();
                    rpcPort = this.currentAttempt.getRpcPort();
                    appUsageReport = this.currentAttempt.getApplicationResourceUsageReport();
                    progress = this.currentAttempt.getProgress();
                    logAggregationStatus = this.getLogAggregationStatusForAppReport();
                }
                diags = this.getDiagnostics().toString();
                if (this.currentAttempt != null && this.currentAttempt.getAppAttemptState() == RMAppAttemptState.LAUNCHED && this.getApplicationSubmissionContext().getUnmanagedAM() && clientUserName != null && this.getUser().equals(clientUserName) && (token = this.currentAttempt.getAMRMToken()) != null) {
                    amrmToken = BuilderUtils.newAMRMToken((byte[])token.getIdentifier(), (String)token.getKind().toString(), (byte[])token.getPassword(), (String)token.getService().toString());
                }
                RMAppMetrics rmAppMetrics = this.getRMAppMetrics();
                appUsageReport.setMemorySeconds(rmAppMetrics.getMemorySeconds());
                appUsageReport.setVcoreSeconds(rmAppMetrics.getVcoreSeconds());
                appUsageReport.setGPUSeconds(rmAppMetrics.getGPUSeconds());
                appUsageReport.setPreemptedMemorySeconds(rmAppMetrics.getPreemptedMemorySeconds());
                appUsageReport.setPreemptedVcoreSeconds(rmAppMetrics.getPreemptedVcoreSeconds());
                appUsageReport.setPreemptedGPUSeconds(rmAppMetrics.getPreemptedGPUSeconds());
            }
            if (currentApplicationAttemptId == null) {
                currentApplicationAttemptId = BuilderUtils.newApplicationAttemptId((ApplicationId)this.applicationId, (int)-1);
            }
            ApplicationReport report = BuilderUtils.newApplicationReport((ApplicationId)this.applicationId, (ApplicationAttemptId)currentApplicationAttemptId, (String)this.user, (String)this.queue, (String)this.name, (String)host, (int)rpcPort, clientToAMToken, (YarnApplicationState)this.createApplicationState(), (String)diags, (String)trackingUrl, (long)this.startTime, (long)this.finishTime, (FinalApplicationStatus)finishState, (ApplicationResourceUsageReport)appUsageReport, (String)origTrackingUrl, (float)progress, (String)this.applicationType, amrmToken, this.applicationTags, (Priority)this.submissionContext.getPriority());
            report.setLogAggregationStatus(logAggregationStatus);
            report.setUnmanagedApp(this.submissionContext.getUnmanagedAM());
            report.setAppNodeLabelExpression(this.getAppNodeLabelExpression());
            report.setAmNodeLabelExpression(this.getAmNodeLabelExpression());
            ApplicationReport applicationReport = report;
            return applicationReport;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private String getDefaultProxyTrackingUrl() {
        try {
            String scheme = WebAppUtils.getHttpSchemePrefix((Configuration)this.conf);
            String proxy = WebAppUtils.getProxyHostAndPort((Configuration)this.conf);
            URI proxyUri = ProxyUriUtils.getUriFromAMUrl((String)scheme, (String)proxy);
            URI result = ProxyUriUtils.getProxyUri(null, (URI)proxyUri, (ApplicationId)this.applicationId);
            return result.toASCIIString();
        }
        catch (URISyntaxException e) {
            LOG.warn((Object)("Could not generate default proxy tracking URL for " + this.applicationId));
            return UNAVAILABLE;
        }
    }

    @Override
    public long getFinishTime() {
        this.readLock.lock();
        try {
            long l = this.finishTime;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public long getStartTime() {
        this.readLock.lock();
        try {
            long l = this.startTime;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public long getSubmitTime() {
        return this.submitTime;
    }

    @Override
    public String getTrackingUrl() {
        RMAppAttempt attempt = this.currentAttempt;
        if (attempt != null) {
            return attempt.getTrackingUrl();
        }
        return null;
    }

    @Override
    public String getOriginalTrackingUrl() {
        RMAppAttempt attempt = this.currentAttempt;
        if (attempt != null) {
            return attempt.getOriginalTrackingUrl();
        }
        return null;
    }

    @Override
    public StringBuilder getDiagnostics() {
        this.readLock.lock();
        try {
            String appAttemptDiagnostics;
            if (this.diagnostics.length() == 0 && this.getCurrentAppAttempt() != null && (appAttemptDiagnostics = this.getCurrentAppAttempt().getDiagnostics()) != null) {
                StringBuilder stringBuilder = new StringBuilder(appAttemptDiagnostics);
                return stringBuilder;
            }
            StringBuilder stringBuilder = this.diagnostics;
            return stringBuilder;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public int getMaxAppAttempts() {
        return this.maxAppAttempts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(RMAppEvent event) {
        this.writeLock.lock();
        try {
            ApplicationId appID = event.getApplicationId();
            LOG.debug((Object)("Processing event for " + appID + " of type " + event.getType()));
            RMAppState oldState = this.getState();
            try {
                this.stateMachine.doTransition(event.getType(), (Object)event);
            }
            catch (InvalidStateTransitionException e) {
                LOG.error((Object)"Can't handle this event at current state", (Throwable)e);
            }
            if (oldState != this.getState()) {
                LOG.info((Object)(appID + " State change from " + (Object)((Object)oldState) + " to " + (Object)((Object)this.getState()) + " on event=" + event.getType()));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void recover(RMStateStore.RMState state) {
        ApplicationStateData appState = state.getApplicationState().get(this.getApplicationId());
        this.recoveredFinalState = appState.getState();
        LOG.info((Object)("Recovering app: " + this.getApplicationId() + " with " + appState.getAttemptCount() + " attempts and final state = " + (Object)((Object)this.recoveredFinalState)));
        this.diagnostics.append(null == appState.getDiagnostics() ? "" : appState.getDiagnostics());
        this.storedFinishTime = appState.getFinishTime();
        this.startTime = appState.getStartTime();
        this.callerContext = appState.getCallerContext();
        this.keyStore = appState.getKeyStore();
        this.keyStorePassword = appState.getKeyStorePassword();
        this.trustStore = appState.getTrustStore();
        this.trustStorePassword = appState.getTrustStorePassword();
        this.cryptoMaterialVersion = appState.getCryptoMaterialVersion();
        this.certificateExpiration = appState.getCertificateExpiration();
        this.isAppRotatingCryptoMaterial.set(appState.isDuringMaterialRotation());
        this.materialRotationStartTime.set(appState.getMaterialRotationStartTime());
        this.jwt = appState.getJWT();
        this.jwtExpiration = appState.getJWTExpiration() != -1L ? Instant.ofEpochMilli(appState.getJWTExpiration()) : null;
        this.sendATSCreateEvent();
        for (int i = 0; i < appState.getAttemptCount(); ++i) {
            this.createNewAttempt();
            ((RMAppAttemptImpl)this.currentAttempt).recover(state);
        }
    }

    private void createNewAttempt() {
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)this.applicationId, (int)(this.attempts.size() + 1));
        BlacklistManager currentAMBlacklistManager = this.currentAttempt != null ? this.currentAttempt.getAMBlacklistManager() : (this.amBlacklistingEnabled ? new SimpleBlacklistManager(this.scheduler.getNumClusterNodes(), this.blacklistDisableThreshold) : new DisabledBlacklistManager());
        RMAppAttemptImpl attempt = new RMAppAttemptImpl(appAttemptId, this.rmContext, this.scheduler, this.masterService, this.submissionContext, this.conf, this.maxAppAttempts == this.getNumFailedAppAttempts() + 1, this.amReq, currentAMBlacklistManager);
        this.attempts.put(appAttemptId, attempt);
        this.currentAttempt = attempt;
    }

    private void createAndStartNewAttempt(boolean transferStateFromPreviousAttempt) {
        this.createNewAttempt();
        this.handler.handle((Event)new RMAppStartAttemptEvent(this.currentAttempt.getAppAttemptId(), transferStateFromPreviousAttempt));
    }

    private void processNodeUpdate(RMAppNodeUpdateEvent.RMAppNodeUpdateType type, RMNode node) {
        NodeState nodeState = node.getState();
        this.updatedNodes.add(node);
        LOG.debug((Object)("Received node update event:" + (Object)((Object)type) + " for node:" + node + " with state:" + nodeState));
    }

    private void recoverAppAttempts() {
        for (RMAppAttempt attempt : this.getAppAttempts().values()) {
            attempt.handle((Event)new RMAppAttemptEvent(attempt.getAppAttemptId(), RMAppAttemptEventType.RECOVER));
        }
    }

    private void materializeCertificates() throws InterruptedException {
        if (this.conf.getBoolean("ipc.server.ssl.enabled", false)) {
            this.rmContext.getCertificateLocalizationService().materializeCertificates(this.user, this.applicationId.toString(), this.user, this.createByteBufferFromByteArray(this.keyStore), String.valueOf(this.keyStorePassword), this.createByteBufferFromByteArray(this.trustStore), String.valueOf(this.trustStorePassword));
        }
    }

    private ByteBuffer createByteBufferFromByteArray(byte[] bytes) {
        ByteBuffer buffer = ByteBuffer.allocate(bytes.length);
        for (int i = 0; i < bytes.length; ++i) {
            buffer.put(bytes[i]);
        }
        buffer.flip();
        return buffer;
    }

    private boolean isX509MaterialPresent() {
        return this.keyStore != null && this.keyStorePassword != null && this.trustStore != null && this.trustStorePassword != null;
    }

    private boolean isJWTMaterialPresent() {
        return this.jwt != null && !this.jwt.isEmpty() && this.jwtExpiration != null;
    }

    private void updateApplicationWithX509(X509SecurityHandler.X509SecurityManagerMaterial x509Material) {
        if (x509Material == null) {
            return;
        }
        this.keyStore = x509Material.getKeyStore();
        this.keyStorePassword = x509Material.getKeyStorePassword();
        this.trustStore = x509Material.getTrustStore();
        this.trustStorePassword = x509Material.getTrustStorePassword();
        this.certificateExpiration = x509Material.getExpirationEpoch();
    }

    private void updateApplicationWithJWT(JWTSecurityHandler.JWTSecurityManagerMaterial jwtMaterial) {
        if (jwtMaterial == null) {
            return;
        }
        this.jwt = jwtMaterial.getToken();
        this.jwtExpiration = jwtMaterial.getExpirationDate();
    }

    private String getAppAttemptFailedDiagnostics(RMAppEvent event) {
        String msg = null;
        RMAppFailedAttemptEvent failedEvent = (RMAppFailedAttemptEvent)event;
        if (this.submissionContext.getUnmanagedAM()) {
            msg = "Unmanaged application " + this.getApplicationId() + " failed due to " + failedEvent.getDiagnosticMsg() + ". Failing the application.";
        } else if (this.isNumAttemptsBeyondThreshold) {
            int globalLimit = this.conf.getInt("yarn.resourcemanager.am.max-attempts", 2);
            msg = String.format("Application %s failed %d times%s%s due to %s. Failing the application.", this.getApplicationId(), this.maxAppAttempts, this.attemptFailuresValidityInterval <= 0L ? "" : " in previous " + this.attemptFailuresValidityInterval + " milliseconds", globalLimit == this.maxAppAttempts ? "" : " (global limit =" + globalLimit + "; local limit is =" + this.maxAppAttempts + ")", failedEvent.getDiagnosticMsg());
        }
        return msg;
    }

    private void rememberTargetTransitions(RMAppEvent event, Object transitionToDo, RMAppState targetFinalState) {
        this.transitionTodo = transitionToDo;
        this.targetedFinalState = targetFinalState;
        this.eventCausingFinalSaving = event;
    }

    private void rememberTargetTransitionsAndStoreState(RMAppEvent event, Object transitionToDo, RMAppState targetFinalState, RMAppState stateToBeStored) {
        this.rememberTargetTransitions(event, transitionToDo, targetFinalState);
        this.stateBeforeFinalSaving = this.getState();
        this.storedFinishTime = this.systemClock.getTime();
        LOG.info((Object)("Updating application " + this.applicationId + " with final state: " + (Object)((Object)this.targetedFinalState)));
        String diags = null;
        switch ((RMAppEventType)event.getType()) {
            case APP_REJECTED: 
            case ATTEMPT_FINISHED: 
            case ATTEMPT_KILLED: {
                diags = event.getDiagnosticMsg();
                break;
            }
            case ATTEMPT_FAILED: {
                RMAppFailedAttemptEvent failedEvent = (RMAppFailedAttemptEvent)event;
                diags = this.getAppAttemptFailedDiagnostics(failedEvent);
                break;
            }
        }
        ApplicationStateData appState = ApplicationStateData.newInstance(this.submitTime, this.startTime, this.user, this.submissionContext, stateToBeStored, diags, this.storedFinishTime, this.callerContext);
        this.rmContext.getStateStore().updateApplicationState(appState);
    }

    static void auditLogKillEvent(RMAppEvent event) {
        if (event instanceof RMAppKillByClientEvent) {
            RMAppKillByClientEvent killEvent = (RMAppKillByClientEvent)event;
            UserGroupInformation callerUGI = killEvent.getCallerUGI();
            String userName = null;
            if (callerUGI != null) {
                userName = callerUGI.getShortUserName();
            }
            InetAddress remoteIP = killEvent.getIp();
            RMAuditLogger.logSuccess(userName, "Kill Application Request", "RMAppImpl", event.getApplicationId(), remoteIP);
        }
    }

    private int getNumFailedAppAttempts() {
        int completedAttempts = 0;
        long endTime = this.systemClock.getTime();
        for (RMAppAttempt attempt : this.attempts.values()) {
            if (!attempt.shouldCountTowardsMaxAttemptRetry() || this.attemptFailuresValidityInterval > 0L && attempt.getFinishTime() <= endTime - this.attemptFailuresValidityInterval) continue;
            ++completedAttempts;
        }
        return completedAttempts;
    }

    private void sendSecurityMaterialRevocationEvent() {
        X509SecurityHandler.X509MaterialParameter x509params = new X509SecurityHandler.X509MaterialParameter(this.applicationId, this.user, this.cryptoMaterialVersion);
        JWTSecurityHandler.JWTMaterialParameter jwtParams = new JWTSecurityHandler.JWTMaterialParameter(this.applicationId, this.user);
        RMAppSecurityMaterial<RMAppSecurityManager.SecurityManagerMaterial> securityMaterial = new RMAppSecurityMaterial<RMAppSecurityManager.SecurityManagerMaterial>();
        securityMaterial.addMaterial(x509params);
        securityMaterial.addMaterial(jwtParams);
        this.handler.handle((Event)new RMAppSecurityManagerEvent(this.applicationId, securityMaterial, RMAppSecurityManagerEventType.REVOKE_SECURITY_MATERIAL));
    }

    @Override
    public String getApplicationType() {
        return this.applicationType;
    }

    @Override
    public Set<String> getApplicationTags() {
        return this.applicationTags;
    }

    @Override
    public boolean isAppFinalStateStored() {
        RMAppState state = this.getState();
        return state.equals((Object)RMAppState.FINISHING) || state.equals((Object)RMAppState.FINISHED) || state.equals((Object)RMAppState.FAILED) || state.equals((Object)RMAppState.KILLED);
    }

    @Override
    public YarnApplicationState createApplicationState() {
        RMAppState rmAppState = this.getState();
        if (rmAppState.equals((Object)RMAppState.FINAL_SAVING)) {
            rmAppState = this.stateBeforeFinalSaving;
        }
        if (rmAppState.equals((Object)RMAppState.KILLING)) {
            rmAppState = this.stateBeforeKilling;
        }
        return RMServerUtils.createApplicationState(rmAppState);
    }

    public static boolean isAppInFinalState(RMApp rmApp) {
        RMAppState appState = ((RMAppImpl)rmApp).getRecoveredFinalState();
        if (appState == null) {
            appState = rmApp.getState();
        }
        return appState == RMAppState.FAILED || appState == RMAppState.FINISHED || appState == RMAppState.KILLED;
    }

    public RMAppState getRecoveredFinalState() {
        return this.recoveredFinalState;
    }

    @Override
    public Set<NodeId> getRanNodes() {
        return this.ranNodes;
    }

    @Override
    public RMAppMetrics getRMAppMetrics() {
        Resource resourcePreempted = Resource.newInstance((int)0, (int)0);
        int numAMContainerPreempted = 0;
        int numNonAMContainerPreempted = 0;
        long memorySeconds = 0L;
        long vcoreSeconds = 0L;
        long gpuSeconds = 0L;
        long preemptedMemorySeconds = 0L;
        long preemptedVcoreSeconds = 0L;
        long preemptedGPUSeconds = 0L;
        for (RMAppAttempt attempt : this.attempts.values()) {
            if (null == attempt) continue;
            RMAppAttemptMetrics attemptMetrics = attempt.getRMAppAttemptMetrics();
            Resources.addTo((Resource)resourcePreempted, (Resource)attemptMetrics.getResourcePreempted());
            numAMContainerPreempted += attemptMetrics.getIsPreempted() ? 1 : 0;
            numNonAMContainerPreempted += attemptMetrics.getNumNonAMContainersPreempted();
            AggregateAppResourceUsage resUsage = attempt.getRMAppAttemptMetrics().getAggregateAppResourceUsage();
            memorySeconds += resUsage.getMemorySeconds();
            vcoreSeconds += resUsage.getVcoreSeconds();
            gpuSeconds += resUsage.getGPUSeconds();
            preemptedMemorySeconds += attemptMetrics.getPreemptedMemory();
            preemptedVcoreSeconds += attemptMetrics.getPreemptedVcore();
            preemptedGPUSeconds += attemptMetrics.getPreemptedGPU();
        }
        return new RMAppMetrics(resourcePreempted, numNonAMContainerPreempted, numAMContainerPreempted, memorySeconds, vcoreSeconds, gpuSeconds, preemptedMemorySeconds, preemptedVcoreSeconds, preemptedGPUSeconds);
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public void setSystemClock(Clock clock) {
        this.systemClock = clock;
    }

    @Override
    public ReservationId getReservationId() {
        return this.submissionContext.getReservationID();
    }

    @Override
    public ResourceRequest getAMResourceRequest() {
        return this.amReq;
    }

    protected Credentials parseCredentials() throws IOException {
        Credentials credentials = new Credentials();
        DataInputByteBuffer dibb = new DataInputByteBuffer();
        ByteBuffer tokens = this.submissionContext.getAMContainerSpec().getTokens();
        if (tokens != null) {
            dibb.reset(new ByteBuffer[]{tokens});
            credentials.readTokenStorageStream((DataInputStream)dibb);
            tokens.rewind();
        }
        return credentials;
    }

    @Override
    public Map<NodeId, LogAggregationReport> getLogAggregationReportsForApp() {
        try {
            this.readLock.lock();
            if (!this.isLogAggregationFinished() && RMAppImpl.isAppInFinalState(this) && System.currentTimeMillis() > this.logAggregationStartTime + this.logAggregationStatusTimeout) {
                for (Map.Entry entry : this.logAggregationStatus.entrySet()) {
                    if (((LogAggregationReport)entry.getValue()).getLogAggregationStatus().equals((Object)LogAggregationStatus.TIME_OUT) || ((LogAggregationReport)entry.getValue()).getLogAggregationStatus().equals((Object)LogAggregationStatus.SUCCEEDED) || ((LogAggregationReport)entry.getValue()).getLogAggregationStatus().equals((Object)LogAggregationStatus.FAILED)) continue;
                    ((LogAggregationReport)entry.getValue()).setLogAggregationStatus(LogAggregationStatus.TIME_OUT);
                }
            }
            Map<NodeId, LogAggregationReport> map = Collections.unmodifiableMap(this.logAggregationStatus);
            return map;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void aggregateLogReport(NodeId nodeId, LogAggregationReport report) {
        try {
            this.writeLock.lock();
            if (this.logAggregationEnabled && !this.isLogAggregationFinished()) {
                LogAggregationReport curReport = this.logAggregationStatus.get(nodeId);
                boolean stateChangedToFinal = false;
                if (curReport == null) {
                    this.logAggregationStatus.put(nodeId, report);
                    if (this.isLogAggregationFinishedForNM(report)) {
                        stateChangedToFinal = true;
                    }
                } else {
                    if (this.isLogAggregationFinishedForNM(report) && !this.isLogAggregationFinishedForNM(curReport)) {
                        stateChangedToFinal = true;
                    }
                    if (report.getLogAggregationStatus() != LogAggregationStatus.RUNNING || curReport.getLogAggregationStatus() != LogAggregationStatus.RUNNING_WITH_FAILURE) {
                        if (curReport.getLogAggregationStatus() == LogAggregationStatus.TIME_OUT && report.getLogAggregationStatus() == LogAggregationStatus.RUNNING && this.logAggregationFailureMessagesForNMs.get(nodeId) != null && !this.logAggregationFailureMessagesForNMs.get(nodeId).isEmpty()) {
                            report.setLogAggregationStatus(LogAggregationStatus.RUNNING_WITH_FAILURE);
                        }
                        curReport.setLogAggregationStatus(report.getLogAggregationStatus());
                    }
                }
                this.updateLogAggregationDiagnosticMessages(nodeId, report);
                if (RMAppImpl.isAppInFinalState(this) && stateChangedToFinal) {
                    this.updateLogAggregationStatus(nodeId);
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LogAggregationStatus getLogAggregationStatusForAppReport() {
        try {
            LogAggregationStatus logAggregationStatus;
            this.readLock.lock();
            if (!this.logAggregationEnabled) {
                LogAggregationStatus logAggregationStatus2 = LogAggregationStatus.DISABLED;
                return logAggregationStatus2;
            }
            if (this.isLogAggregationFinished()) {
                LogAggregationStatus logAggregationStatus3 = this.logAggregationStatusForAppReport;
                return logAggregationStatus3;
            }
            Map<NodeId, LogAggregationReport> reports = this.getLogAggregationReportsForApp();
            if (reports.size() == 0) {
                LogAggregationStatus logAggregationStatus4 = this.logAggregationStatusForAppReport;
                return logAggregationStatus4;
            }
            int logNotStartCount = 0;
            int logCompletedCount = 0;
            int logTimeOutCount = 0;
            int logFailedCount = 0;
            int logRunningWithFailure = 0;
            for (Map.Entry<NodeId, LogAggregationReport> report : reports.entrySet()) {
                switch (report.getValue().getLogAggregationStatus()) {
                    case NOT_START: {
                        ++logNotStartCount;
                        break;
                    }
                    case RUNNING_WITH_FAILURE: {
                        ++logRunningWithFailure;
                        break;
                    }
                    case SUCCEEDED: {
                        ++logCompletedCount;
                        break;
                    }
                    case FAILED: {
                        ++logFailedCount;
                        ++logCompletedCount;
                        break;
                    }
                    case TIME_OUT: {
                        ++logTimeOutCount;
                        ++logCompletedCount;
                        break;
                    }
                }
            }
            if (logNotStartCount == reports.size()) {
                logAggregationStatus = LogAggregationStatus.NOT_START;
                return logAggregationStatus;
            }
            if (logCompletedCount == reports.size()) {
                if (logFailedCount > 0 && RMAppImpl.isAppInFinalState(this)) {
                    this.logAggregationStatusForAppReport = LogAggregationStatus.FAILED;
                    logAggregationStatus = LogAggregationStatus.FAILED;
                    return logAggregationStatus;
                }
                if (logTimeOutCount > 0) {
                    this.logAggregationStatusForAppReport = LogAggregationStatus.TIME_OUT;
                    logAggregationStatus = LogAggregationStatus.TIME_OUT;
                    return logAggregationStatus;
                }
                if (RMAppImpl.isAppInFinalState(this)) {
                    this.logAggregationStatusForAppReport = LogAggregationStatus.SUCCEEDED;
                    logAggregationStatus = LogAggregationStatus.SUCCEEDED;
                    return logAggregationStatus;
                }
            } else if (logRunningWithFailure > 0) {
                logAggregationStatus = LogAggregationStatus.RUNNING_WITH_FAILURE;
                return logAggregationStatus;
            }
            logAggregationStatus = LogAggregationStatus.RUNNING;
            return logAggregationStatus;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private boolean isLogAggregationFinished() {
        return this.logAggregationStatusForAppReport.equals((Object)LogAggregationStatus.SUCCEEDED) || this.logAggregationStatusForAppReport.equals((Object)LogAggregationStatus.FAILED) || this.logAggregationStatusForAppReport.equals((Object)LogAggregationStatus.TIME_OUT);
    }

    private boolean isLogAggregationFinishedForNM(LogAggregationReport report) {
        return report.getLogAggregationStatus() == LogAggregationStatus.SUCCEEDED || report.getLogAggregationStatus() == LogAggregationStatus.FAILED;
    }

    private void updateLogAggregationDiagnosticMessages(NodeId nodeId, LogAggregationReport report) {
        if (report.getDiagnosticMessage() != null && !report.getDiagnosticMessage().isEmpty()) {
            if (report.getLogAggregationStatus() == LogAggregationStatus.RUNNING) {
                List<String> diagnostics = this.logAggregationDiagnosticsForNMs.get(nodeId);
                if (diagnostics == null) {
                    diagnostics = new ArrayList<String>();
                    this.logAggregationDiagnosticsForNMs.put(nodeId, diagnostics);
                } else if (diagnostics.size() == this.maxLogAggregationDiagnosticsInMemory) {
                    diagnostics.remove(0);
                }
                diagnostics.add(report.getDiagnosticMessage());
                this.logAggregationStatus.get(nodeId).setDiagnosticMessage(StringUtils.join(diagnostics, (String)"\n"));
            } else if (report.getLogAggregationStatus() == LogAggregationStatus.RUNNING_WITH_FAILURE) {
                List<String> failureMessages = this.logAggregationFailureMessagesForNMs.get(nodeId);
                if (failureMessages == null) {
                    failureMessages = new ArrayList<String>();
                    this.logAggregationFailureMessagesForNMs.put(nodeId, failureMessages);
                } else if (failureMessages.size() == this.maxLogAggregationDiagnosticsInMemory) {
                    failureMessages.remove(0);
                }
                failureMessages.add(report.getDiagnosticMessage());
            }
        }
    }

    private void updateLogAggregationStatus(NodeId nodeId) {
        LogAggregationStatus status = this.logAggregationStatus.get(nodeId).getLogAggregationStatus();
        if (status.equals((Object)LogAggregationStatus.SUCCEEDED)) {
            ++this.logAggregationSucceed;
        } else if (status.equals((Object)LogAggregationStatus.FAILED)) {
            ++this.logAggregationFailed;
        }
        if (this.logAggregationSucceed == this.logAggregationStatus.size()) {
            this.logAggregationStatusForAppReport = LogAggregationStatus.SUCCEEDED;
            this.logAggregationStatus.clear();
            this.logAggregationDiagnosticsForNMs.clear();
            this.logAggregationFailureMessagesForNMs.clear();
        } else if (this.logAggregationSucceed + this.logAggregationFailed == this.logAggregationStatus.size()) {
            this.logAggregationStatusForAppReport = LogAggregationStatus.FAILED;
            Iterator<Map.Entry<NodeId, LogAggregationReport>> it = this.logAggregationStatus.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<NodeId, LogAggregationReport> entry = it.next();
                if (!entry.getValue().getLogAggregationStatus().equals((Object)LogAggregationStatus.SUCCEEDED)) continue;
                it.remove();
            }
            this.logAggregationDiagnosticsForNMs.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLogAggregationFailureMessagesForNM(NodeId nodeId) {
        try {
            this.readLock.lock();
            List<String> failureMessages = this.logAggregationFailureMessagesForNMs.get(nodeId);
            if (failureMessages == null || failureMessages.isEmpty()) {
                String string = "";
                return string;
            }
            String string = StringUtils.join(failureMessages, (String)"\n");
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public String getAppNodeLabelExpression() {
        String appNodeLabelExpression = this.getApplicationSubmissionContext().getNodeLabelExpression();
        appNodeLabelExpression = appNodeLabelExpression == null ? "<Not set>" : appNodeLabelExpression;
        appNodeLabelExpression = appNodeLabelExpression.trim().isEmpty() ? "<DEFAULT_PARTITION>" : appNodeLabelExpression;
        return appNodeLabelExpression;
    }

    @Override
    public String getAmNodeLabelExpression() {
        String amNodeLabelExpression = null;
        if (!this.getApplicationSubmissionContext().getUnmanagedAM()) {
            amNodeLabelExpression = this.getAMResourceRequest().getNodeLabelExpression();
            amNodeLabelExpression = amNodeLabelExpression == null ? "<Not set>" : amNodeLabelExpression;
            amNodeLabelExpression = amNodeLabelExpression.trim().isEmpty() ? "<DEFAULT_PARTITION>" : amNodeLabelExpression;
        }
        return amNodeLabelExpression;
    }

    @Override
    public CallerContext getCallerContext() {
        return this.callerContext;
    }

    private void sendATSCreateEvent() {
        this.rmContext.getRMApplicationHistoryWriter().applicationStarted(this);
        this.rmContext.getSystemMetricsPublisher().appCreated(this, this.startTime);
    }

    @Override
    public byte[] getKeyStore() {
        return this.keyStore;
    }

    @Override
    public char[] getKeyStorePassword() {
        return this.keyStorePassword;
    }

    @Override
    public byte[] getTrustStore() {
        return this.trustStore;
    }

    @Override
    public char[] getTrustStorePassword() {
        return this.trustStorePassword;
    }

    @Override
    public long getCertificateExpiration() {
        return this.certificateExpiration;
    }

    @Override
    public Integer getCryptoMaterialVersion() {
        return this.cryptoMaterialVersion;
    }

    @Override
    public Instant getJWTExpiration() {
        return this.jwtExpiration;
    }

    @Override
    public String getJWT() {
        return this.jwt;
    }

    @VisibleForTesting
    public Set<NodeId> getRMNodesUpdatedCryptoMaterial() {
        return this.rmNodesThatUpdatedCryptoMaterial;
    }

    @Override
    @VisibleForTesting
    public boolean isAppRotatingCryptoMaterial() {
        return this.isAppRotatingCryptoMaterial.get();
    }

    @Override
    public long getMaterialRotationStartTime() {
        return this.materialRotationStartTime.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rmNodeHasUpdatedCryptoMaterial(NodeId nodeId) {
        this.writeLock.lock();
        try {
            if (this.rmNodesThatUpdatedCryptoMaterial == null) {
                LOG.warn((Object)"Received RMNode updated crypto material but Set is null!");
                return;
            }
            if (this.isAppRotatingCryptoMaterial.get()) {
                this.rmNodesThatUpdatedCryptoMaterial.add(nodeId);
                if (this.rmNodesThatUpdatedCryptoMaterial.containsAll(this.ranNodes)) {
                    int cryptoVersionToRevoke = this.cryptoMaterialVersion - 1;
                    X509SecurityHandler.X509MaterialParameter x509Param = new X509SecurityHandler.X509MaterialParameter(this.applicationId, this.user, cryptoVersionToRevoke, true);
                    RMAppSecurityMaterial<X509SecurityHandler.X509MaterialParameter> securityMaterial = new RMAppSecurityMaterial<X509SecurityHandler.X509MaterialParameter>();
                    securityMaterial.addMaterial(x509Param);
                    RMAppSecurityManagerEvent event = new RMAppSecurityManagerEvent(this.applicationId, securityMaterial, RMAppSecurityManagerEventType.REVOKE_CERTIFICATE_AFTER_ROTATION);
                    this.handler.handle((Event)event);
                    this.rmNodesThatUpdatedCryptoMaterial = null;
                    this.isAppRotatingCryptoMaterial.compareAndSet(true, false);
                    this.materialRotationStartTime.set(-1L);
                    ApplicationStateData appNewState = ApplicationStateData.newInstance(this.submitTime, this.startTime, this.submissionContext, this.user, this.callerContext, this.keyStore, this.keyStorePassword, this.trustStore, this.trustStorePassword, this.cryptoMaterialVersion, this.certificateExpiration, this.isAppRotatingCryptoMaterial.get(), -1L);
                    this.rmContext.getStateStore().updateApplicationStateNoNotify(appNewState);
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void resetCryptoRotationMetrics() {
        this.isAppRotatingCryptoMaterial.set(false);
        this.materialRotationStartTime.set(-1L);
        this.writeLock.lock();
        try {
            this.rmNodesThatUpdatedCryptoMaterial = null;
            ApplicationStateData appNewState = ApplicationStateData.newInstance(this.submitTime, this.startTime, this.submissionContext, this.user, this.callerContext, this.keyStore, this.keyStorePassword, this.trustStore, this.trustStorePassword, this.cryptoMaterialVersion, this.certificateExpiration, this.isAppRotatingCryptoMaterial.get(), -1L);
            this.rmContext.getStateStore().updateApplicationStateNoNotify(appNewState);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private static final class AttemptFailedTransition
    implements MultipleArcTransition<RMAppImpl, RMAppEvent, RMAppState> {
        private final RMAppState initialState;

        public AttemptFailedTransition(RMAppState initialState) {
            this.initialState = initialState;
        }

        public RMAppState transition(RMAppImpl app, RMAppEvent event) {
            int numberOfFailure = app.getNumFailedAppAttempts();
            LOG.info((Object)("The number of failed attempts" + (app.attemptFailuresValidityInterval > 0L ? " in previous " + app.attemptFailuresValidityInterval + " milliseconds " : " ") + "is " + numberOfFailure + ". The max attempts is " + app.maxAppAttempts));
            if (!app.submissionContext.getUnmanagedAM() && numberOfFailure < app.maxAppAttempts) {
                if (this.initialState.equals((Object)RMAppState.KILLING)) {
                    app.rememberTargetTransitionsAndStoreState(event, new AppKilledTransition(), RMAppState.KILLED, RMAppState.KILLED);
                    return RMAppState.FINAL_SAVING;
                }
                RMAppFailedAttemptEvent failedEvent = (RMAppFailedAttemptEvent)event;
                boolean transferStateFromPreviousAttempt = failedEvent.getTransferStateFromPreviousAttempt();
                RMAppAttempt oldAttempt = app.currentAttempt;
                app.createAndStartNewAttempt(transferStateFromPreviousAttempt);
                ((RMAppAttemptImpl)app.currentAttempt).transferStateFromAttempt(oldAttempt);
                return this.initialState;
            }
            if (numberOfFailure >= app.maxAppAttempts) {
                app.isNumAttemptsBeyondThreshold = true;
            }
            app.sendSecurityMaterialRevocationEvent();
            app.rememberTargetTransitionsAndStoreState(event, new AttemptFailedFinalStateSavedTransition(), RMAppState.FAILED, RMAppState.FAILED);
            return RMAppState.FINAL_SAVING;
        }
    }

    private static class FinalTransition
    extends RMAppTransition {
        private final RMAppState finalState;

        public FinalTransition(RMAppState finalState) {
            this.finalState = finalState;
        }

        @Override
        public void transition(RMAppImpl app, RMAppEvent event) {
            app.logAggregationStartTime = System.currentTimeMillis();
            for (NodeId nodeId : app.getRanNodes()) {
                app.handler.handle((Event)new RMNodeCleanAppEvent(nodeId, app.applicationId));
            }
            app.finishTime = app.storedFinishTime;
            if (app.finishTime == 0L) {
                app.finishTime = app.systemClock.getTime();
            }
            if (app.recoveredFinalState == null) {
                app.handler.handle((Event)new AppRemovedSchedulerEvent(app.applicationId, this.finalState));
            }
            app.handler.handle((Event)new RMAppManagerEvent(app.applicationId, RMAppManagerEventType.APP_COMPLETED));
            app.rmContext.getRMApplicationHistoryWriter().applicationFinished(app, this.finalState);
            app.rmContext.getSystemMetricsPublisher().appFinished(app, this.finalState, app.finishTime);
        }
    }

    private static final class AppRejectedTransition
    extends FinalTransition {
        public AppRejectedTransition() {
            super(RMAppState.FAILED);
        }

        @Override
        public void transition(RMAppImpl app, RMAppEvent event) {
            app.diagnostics.append(event.getDiagnosticMsg());
            super.transition(app, event);
        }
    }

    private static class KillAttemptTransition
    extends RMAppTransition {
        private KillAttemptTransition() {
        }

        @Override
        public void transition(RMAppImpl app, RMAppEvent event) {
            app.stateBeforeKilling = app.getState();
            app.handler.handle((Event)new RMAppAttemptEvent(app.currentAttempt.getAppAttemptId(), RMAppAttemptEventType.KILL, event.getDiagnosticMsg()));
            RMAppImpl.auditLogKillEvent(event);
        }
    }

    private static class AppKilledTransition
    extends FinalTransition {
        public AppKilledTransition() {
            super(RMAppState.KILLED);
        }

        @Override
        public void transition(RMAppImpl app, RMAppEvent event) {
            app.diagnostics.append(event.getDiagnosticMsg());
            super.transition(app, event);
            RMAppImpl.auditLogKillEvent(event);
        }
    }

    private static class AppFinishedFinalStateSavedTransition
    extends RMAppTransition {
        RMAppEvent attemptUnregistered;

        public AppFinishedFinalStateSavedTransition(RMAppEvent attemptUnregistered) {
            this.attemptUnregistered = attemptUnregistered;
        }

        @Override
        public void transition(RMAppImpl app, RMAppEvent event) {
            new AttemptUnregisteredTransition().transition(app, this.attemptUnregistered);
            FINISHED_TRANSITION.transition(app, event);
        }
    }

    private static class AttemptFinishedAtFinalSavingTransition
    extends RMAppTransition {
        private AttemptFinishedAtFinalSavingTransition() {
        }

        @Override
        public void transition(RMAppImpl app, RMAppEvent event) {
            if (app.targetedFinalState.equals((Object)RMAppState.FAILED) || app.targetedFinalState.equals((Object)RMAppState.KILLED)) {
                return;
            }
            app.rememberTargetTransitions(event, new AppFinishedFinalStateSavedTransition(app.eventCausingFinalSaving), RMAppState.FINISHED);
        }
    }

    private static class AppFinishedTransition
    extends FinalTransition {
        public AppFinishedTransition() {
            super(RMAppState.FINISHED);
        }

        @Override
        public void transition(RMAppImpl app, RMAppEvent event) {
            app.diagnostics.append(event.getDiagnosticMsg());
            super.transition(app, event);
        }
    }

    private static class AttemptUnregisteredTransition
    extends RMAppTransition {
        private AttemptUnregisteredTransition() {
        }

        @Override
        public void transition(RMAppImpl app, RMAppEvent event) {
            app.finishTime = app.storedFinishTime;
        }
    }

    private static final class FinalSavingTransition
    extends RMAppTransition {
        Object transitionToDo;
        RMAppState targetedFinalState;
        RMAppState stateToBeStored;

        public FinalSavingTransition(Object transitionToDo, RMAppState targetedFinalState) {
            this(transitionToDo, targetedFinalState, targetedFinalState);
        }

        public FinalSavingTransition(Object transitionToDo, RMAppState targetedFinalState, RMAppState stateToBeStored) {
            this.transitionToDo = transitionToDo;
            this.targetedFinalState = targetedFinalState;
            this.stateToBeStored = stateToBeStored;
        }

        @Override
        public void transition(RMAppImpl app, RMAppEvent event) {
            if (this.transitionToDo instanceof AppKilledTransition && (app.getState().equals((Object)RMAppState.GENERATING_SECURITY_MATERIAL) || app.getState().equals((Object)RMAppState.ACCEPTED))) {
                app.sendSecurityMaterialRevocationEvent();
            }
            if (app.getState().equals((Object)RMAppState.SUBMITTED)) {
                app.sendSecurityMaterialRevocationEvent();
            }
            app.rememberTargetTransitionsAndStoreState(event, this.transitionToDo, this.targetedFinalState, this.stateToBeStored);
        }
    }

    private static final class RMAppGeneratingSecurityMaterialTransition
    extends RMAppTransition {
        private RMAppGeneratingSecurityMaterialTransition() {
        }

        @Override
        public void transition(RMAppImpl app, RMAppEvent event) {
            LOG.info((Object)("Generating X.509 and JWT for application " + app.applicationId));
            X509SecurityHandler.X509MaterialParameter x509Param = new X509SecurityHandler.X509MaterialParameter(app.applicationId, app.user, app.cryptoMaterialVersion);
            JWTSecurityHandler.JWTMaterialParameter jwtParam = new JWTSecurityHandler.JWTMaterialParameter(app.applicationId, app.user);
            RMAppSecurityMaterial<RMAppSecurityManager.SecurityManagerMaterial> securityMaterial = new RMAppSecurityMaterial<RMAppSecurityManager.SecurityManagerMaterial>();
            securityMaterial.addMaterial(x509Param);
            securityMaterial.addMaterial(jwtParam);
            RMAppSecurityManagerEvent genSecurityMaterialEvent = new RMAppSecurityManagerEvent(app.applicationId, securityMaterial, RMAppSecurityManagerEventType.GENERATE_SECURITY_MATERIAL);
            app.handler.handle((Event)genSecurityMaterialEvent);
        }
    }

    private static final class RMAppNewlySavingTransition
    extends RMAppTransition {
        private RMAppNewlySavingTransition() {
        }

        @Override
        public void transition(RMAppImpl app, RMAppEvent event) {
            LOG.info((Object)("Storing application with id " + app.applicationId));
            app.rmContext.getStateStore().storeNewApplication(app);
        }
    }

    private static class AttemptFailedFinalStateSavedTransition
    extends RMAppTransition {
        private AttemptFailedFinalStateSavedTransition() {
        }

        @Override
        public void transition(RMAppImpl app, RMAppEvent event) {
            String msg = null;
            if (event instanceof RMAppFailedAttemptEvent) {
                msg = app.getAppAttemptFailedDiagnostics(event);
            }
            LOG.info(msg);
            app.diagnostics.append(msg);
            new FinalTransition(RMAppState.FAILED).transition(app, event);
        }
    }

    private static final class FinalStateSavedTransition
    implements MultipleArcTransition<RMAppImpl, RMAppEvent, RMAppState> {
        private FinalStateSavedTransition() {
        }

        public RMAppState transition(RMAppImpl app, RMAppEvent event) {
            if (app.transitionTodo instanceof SingleArcTransition) {
                ((SingleArcTransition)app.transitionTodo).transition((Object)app, (Object)app.eventCausingFinalSaving);
            } else if (app.transitionTodo instanceof MultipleArcTransition) {
                ((MultipleArcTransition)app.transitionTodo).transition((Object)app, (Object)app.eventCausingFinalSaving);
            }
            return app.targetedFinalState;
        }
    }

    private static final class StartAppAttemptTransition
    extends RMAppTransition {
        private StartAppAttemptTransition() {
        }

        @Override
        public void transition(RMAppImpl app, RMAppEvent event) {
            app.createAndStartNewAttempt(false);
        }
    }

    private static final class RMAppSecurityMaterialRenewedTransition
    extends RMAppTransition {
        private RMAppSecurityMaterialRenewedTransition() {
        }

        @Override
        public void transition(RMAppImpl app, RMAppEvent event) {
            RMAppSecurityMaterialRenewedEvent securityEvent = (RMAppSecurityMaterialRenewedEvent)event;
            if (securityEvent.getSecurityMaterial() instanceof X509SecurityHandler.X509SecurityManagerMaterial) {
                X509SecurityHandler.X509SecurityManagerMaterial x509Material = (X509SecurityHandler.X509SecurityManagerMaterial)securityEvent.getSecurityMaterial();
                this.handleX509RenewEvent(app, x509Material);
            } else if (securityEvent.getSecurityMaterial() instanceof JWTSecurityHandler.JWTSecurityManagerMaterial) {
                JWTSecurityHandler.JWTSecurityManagerMaterial jwtMaterial = (JWTSecurityHandler.JWTSecurityManagerMaterial)securityEvent.getSecurityMaterial();
                this.handleJWTRenewEvent(app, jwtMaterial);
            }
        }

        private void handleX509RenewEvent(RMAppImpl app, X509SecurityHandler.X509SecurityManagerMaterial x509Material) {
            app.updateApplicationWithX509(x509Material);
            RMAppImpl rMAppImpl = app;
            Integer n = rMAppImpl.cryptoMaterialVersion;
            Integer n2 = rMAppImpl.cryptoMaterialVersion = rMAppImpl.cryptoMaterialVersion + 1;
            app.isAppRotatingCryptoMaterial.compareAndSet(false, true);
            app.materialRotationStartTime.set(app.systemClock.getTime());
            ApplicationStateData appNewState = ApplicationStateData.newInstance(app.submitTime, app.startTime, app.submissionContext, app.user, app.callerContext, app.keyStore, app.keyStorePassword, app.trustStore, app.trustStorePassword, app.cryptoMaterialVersion, app.certificateExpiration, app.isAppRotatingCryptoMaterial.get(), app.materialRotationStartTime.get());
            appNewState.setJWT(app.jwt);
            if (app.jwtExpiration != null) {
                appNewState.setJWTExpiration(app.jwtExpiration.toEpochMilli());
            } else {
                appNewState.setJWTExpiration(-1L);
            }
            app.rmContext.getStateStore().updateApplicationStateNoNotify(appNewState);
            if (app.rmNodesThatUpdatedCryptoMaterial == null) {
                app.rmNodesThatUpdatedCryptoMaterial = new HashSet(app.ranNodes.size());
            }
            x509Material.setCryptoMaterialVersion(app.cryptoMaterialVersion);
            for (NodeId nodeId : app.ranNodes) {
                RMNodeUpdateCryptoMaterialForAppEvent<X509SecurityHandler.X509SecurityManagerMaterial> updateEvent = new RMNodeUpdateCryptoMaterialForAppEvent<X509SecurityHandler.X509SecurityManagerMaterial>(nodeId, x509Material);
                app.handler.handle(updateEvent);
            }
            X509SecurityHandler.X509MaterialParameter param = new X509SecurityHandler.X509MaterialParameter(app.applicationId, app.user, app.cryptoMaterialVersion);
            param.setExpiration(app.certificateExpiration);
            app.rmContext.getRMAppSecurityManager().registerWithMaterialRenewers(param);
        }

        private void handleJWTRenewEvent(RMAppImpl app, JWTSecurityHandler.JWTSecurityManagerMaterial jwtMaterial) {
            app.updateApplicationWithJWT(jwtMaterial);
            ApplicationStateData appNewState = ApplicationStateData.newInstance(app.submitTime, app.startTime, app.submissionContext, app.user, app.callerContext, app.keyStore, app.keyStorePassword, app.trustStore, app.trustStorePassword, app.cryptoMaterialVersion, app.certificateExpiration, app.isAppRotatingCryptoMaterial.get(), app.materialRotationStartTime.get());
            appNewState.setJWT(jwtMaterial.getToken());
            appNewState.setJWTExpiration(jwtMaterial.getExpirationDate().toEpochMilli());
            app.rmContext.getStateStore().updateApplicationStateNoNotify(appNewState);
            for (NodeId nodeId : app.ranNodes) {
                RMNodeUpdateCryptoMaterialForAppEvent<JWTSecurityHandler.JWTSecurityManagerMaterial> updateEvent = new RMNodeUpdateCryptoMaterialForAppEvent<JWTSecurityHandler.JWTSecurityManagerMaterial>(nodeId, jwtMaterial);
                app.handler.handle(updateEvent);
            }
            JWTSecurityHandler.JWTMaterialParameter param = new JWTSecurityHandler.JWTMaterialParameter(app.applicationId, app.user);
            param.setExpirationDate(app.jwtExpiration);
            param.setToken(app.jwt);
            app.rmContext.getRMAppSecurityManager().registerWithMaterialRenewers(param);
        }
    }

    private static final class AddApplicationToSchedulerTransition
    extends RMAppTransition {
        private AddApplicationToSchedulerTransition() {
        }

        @Override
        public void transition(RMAppImpl app, RMAppEvent event) {
            if (event instanceof RMAppSecurityMaterialGeneratedEvent) {
                RMAppSecurityMaterialGeneratedEvent rmAppSecurityEvent = (RMAppSecurityMaterialGeneratedEvent)event;
                X509SecurityHandler.X509SecurityManagerMaterial x509Material = (X509SecurityHandler.X509SecurityManagerMaterial)rmAppSecurityEvent.getMaterial().getMaterial(X509SecurityHandler.X509SecurityManagerMaterial.class);
                app.updateApplicationWithX509(x509Material);
                JWTSecurityHandler.JWTSecurityManagerMaterial jwtMaterial = (JWTSecurityHandler.JWTSecurityManagerMaterial)rmAppSecurityEvent.getMaterial().getMaterial(JWTSecurityHandler.JWTSecurityManagerMaterial.class);
                app.updateApplicationWithJWT(jwtMaterial);
                ApplicationStateData appNewState = ApplicationStateData.newInstance(app.submitTime, app.startTime, app.submissionContext, app.user, app.callerContext);
                if (app.isX509MaterialPresent()) {
                    appNewState.setKeyStore(app.keyStore);
                    appNewState.setKeyStorePassword(app.keyStorePassword);
                    appNewState.setTrustStore(app.trustStore);
                    appNewState.setTrustStorePassword(app.trustStorePassword);
                    appNewState.setCryptoMaterialVersion(app.cryptoMaterialVersion);
                    appNewState.setCertificateExpiration(app.certificateExpiration);
                    appNewState.setIsDuringMaterialRotation(app.isAppRotatingCryptoMaterial.get());
                    appNewState.setMaterialRotationStartTime(app.materialRotationStartTime.get());
                    X509SecurityHandler.X509MaterialParameter x509Param = new X509SecurityHandler.X509MaterialParameter(app.applicationId, app.user, app.cryptoMaterialVersion);
                    x509Param.setExpiration(app.certificateExpiration);
                    app.rmContext.getRMAppSecurityManager().registerWithMaterialRenewers(x509Param);
                }
                if (app.isJWTMaterialPresent()) {
                    appNewState.setJWT(app.jwt);
                    appNewState.setJWTExpiration(app.jwtExpiration.toEpochMilli());
                    JWTSecurityHandler.JWTMaterialParameter jwtParam = new JWTSecurityHandler.JWTMaterialParameter(app.applicationId, app.user);
                    jwtParam.setExpirationDate(app.jwtExpiration);
                    jwtParam.setToken(app.jwt);
                    app.rmContext.getRMAppSecurityManager().registerWithMaterialRenewers(jwtParam);
                }
                app.rmContext.getStateStore().updateApplicationStateNoNotify(appNewState);
            }
            app.handler.handle((Event)new AppAddedSchedulerEvent(app.user, app.submissionContext, false));
            app.sendATSCreateEvent();
        }
    }

    private static final class RMAppRecoveredTransition
    implements MultipleArcTransition<RMAppImpl, RMAppEvent, RMAppState> {
        private RMAppRecoveredTransition() {
        }

        public RMAppState transition(RMAppImpl app, RMAppEvent event) {
            RMAppRecoverEvent recoverEvent = (RMAppRecoverEvent)event;
            app.recover(recoverEvent.getRMState());
            if (app.recoveredFinalState != null) {
                app.recoverAppAttempts();
                new FinalTransition(app.recoveredFinalState).transition(app, event);
                return app.recoveredFinalState;
            }
            if (UserGroupInformation.isSecurityEnabled()) {
                try {
                    app.rmContext.getDelegationTokenRenewer().addApplicationAsyncDuringRecovery(app.getApplicationId(), app.parseCredentials(), app.submissionContext.getCancelTokensWhenComplete(), app.getUser());
                }
                catch (Exception e) {
                    String msg = "Failed to fetch user credentials from application:" + e.getMessage();
                    app.diagnostics.append(msg);
                    LOG.error((Object)msg, (Throwable)e);
                }
            }
            Integer cryptoMaterialVersionToRevoke = app.cryptoMaterialVersion + 1;
            if (app.attempts.isEmpty()) {
                if (app.isX509MaterialPresent() && app.isJWTMaterialPresent()) {
                    X509SecurityHandler.X509MaterialParameter param = new X509SecurityHandler.X509MaterialParameter(app.applicationId, app.user, cryptoMaterialVersionToRevoke);
                    app.rmContext.getRMAppSecurityManager().revokeSecurityMaterialSync(param);
                    param = new X509SecurityHandler.X509MaterialParameter(app.applicationId, app.user, app.cryptoMaterialVersion);
                    param.setExpiration(app.certificateExpiration);
                    app.rmContext.getRMAppSecurityManager().registerWithMaterialRenewers(param);
                    try {
                        app.materializeCertificates();
                    }
                    catch (InterruptedException ex) {
                        LOG.error((Object)("Could not localize certificates for application " + app.applicationId + " during recovery"));
                    }
                    JWTSecurityHandler.JWTMaterialParameter jwtParam = new JWTSecurityHandler.JWTMaterialParameter(app.applicationId, app.user);
                    jwtParam.setExpirationDate(app.jwtExpiration);
                    jwtParam.setToken(app.jwt);
                    app.rmContext.getRMAppSecurityManager().registerWithMaterialRenewers(jwtParam);
                    app.scheduler.handle((Event)new AppAddedSchedulerEvent(app.user, app.submissionContext, false));
                    return RMAppState.SUBMITTED;
                }
                RMAppSecurityMaterial<RMAppSecurityManager.SecurityManagerMaterial> securityMaterial = new RMAppSecurityMaterial<RMAppSecurityManager.SecurityManagerMaterial>();
                X509SecurityHandler.X509MaterialParameter x509Param = new X509SecurityHandler.X509MaterialParameter(app.applicationId, app.user, app.cryptoMaterialVersion);
                securityMaterial.addMaterial(x509Param);
                JWTSecurityHandler.JWTMaterialParameter jwtParam = new JWTSecurityHandler.JWTMaterialParameter(app.applicationId, app.user);
                securityMaterial.addMaterial(jwtParam);
                RMAppSecurityManagerEvent revokeAndGenerateEvent = new RMAppSecurityManagerEvent(app.applicationId, securityMaterial, RMAppSecurityManagerEventType.REVOKE_GENERATE_MATERIAL);
                app.handler.handle((Event)revokeAndGenerateEvent);
                return RMAppState.GENERATING_SECURITY_MATERIAL;
            }
            X509SecurityHandler.X509MaterialParameter x509Param = new X509SecurityHandler.X509MaterialParameter(app.applicationId, app.user, cryptoMaterialVersionToRevoke);
            app.rmContext.getRMAppSecurityManager().revokeSecurityMaterialSync(x509Param);
            x509Param = new X509SecurityHandler.X509MaterialParameter(app.applicationId, app.user, app.cryptoMaterialVersion);
            x509Param.setExpiration(app.certificateExpiration);
            app.rmContext.getRMAppSecurityManager().registerWithMaterialRenewers(x509Param);
            JWTSecurityHandler.JWTMaterialParameter jwtParam = new JWTSecurityHandler.JWTMaterialParameter(app.applicationId, app.user);
            jwtParam.setExpirationDate(app.jwtExpiration);
            jwtParam.setToken(app.jwt);
            app.rmContext.getRMAppSecurityManager().registerWithMaterialRenewers(jwtParam);
            try {
                app.materializeCertificates();
            }
            catch (InterruptedException ex) {
                LOG.error((Object)("Could not localize certificates for application " + app.applicationId + " during recovery"));
            }
            app.scheduler.handle((Event)new AppAddedSchedulerEvent(app.user, app.submissionContext, true));
            app.recoverAppAttempts();
            return RMAppState.ACCEPTED;
        }
    }

    private static final class RMAppMoveTransition
    extends RMAppTransition {
        private RMAppMoveTransition() {
        }

        @Override
        public void transition(RMAppImpl app, RMAppEvent event) {
            RMAppMoveEvent moveEvent = (RMAppMoveEvent)event;
            try {
                app.queue = app.scheduler.moveApplication(app.applicationId, moveEvent.getTargetQueue());
            }
            catch (YarnException ex) {
                moveEvent.getResult().setException((Throwable)ex);
                return;
            }
            app.rmContext.getSystemMetricsPublisher().appUpdated(app, app.systemClock.getTime());
            moveEvent.getResult().set(null);
        }
    }

    private static final class AppRunningOnNodeTransition
    extends RMAppTransition {
        private AppRunningOnNodeTransition() {
        }

        @Override
        public void transition(RMAppImpl app, RMAppEvent event) {
            RMAppRunningOnNodeEvent nodeAddedEvent = (RMAppRunningOnNodeEvent)event;
            if (RMAppImpl.isAppInFinalState(app)) {
                app.handler.handle((Event)new RMNodeCleanAppEvent(nodeAddedEvent.getNodeId(), nodeAddedEvent.getApplicationId()));
                return;
            }
            boolean newNode = app.ranNodes.add(nodeAddedEvent.getNodeId());
            if (newNode && app.isAppRotatingCryptoMaterial.get()) {
                LOG.debug((Object)("Sending UPDATE_CRYPTO_EVENT to new running node: " + nodeAddedEvent.getNodeId()));
                X509SecurityHandler.X509SecurityManagerMaterial x509Material = new X509SecurityHandler.X509SecurityManagerMaterial(app.applicationId, app.keyStore, app.keyStorePassword, app.trustStore, app.trustStorePassword, null);
                x509Material.setCryptoMaterialVersion(app.cryptoMaterialVersion);
                RMNodeUpdateCryptoMaterialForAppEvent<X509SecurityHandler.X509SecurityManagerMaterial> updateEvent = new RMNodeUpdateCryptoMaterialForAppEvent<X509SecurityHandler.X509SecurityManagerMaterial>(nodeAddedEvent.getNodeId(), x509Material);
                app.handler.handle(updateEvent);
            }
            if (!app.logAggregationStatus.containsKey(nodeAddedEvent.getNodeId())) {
                app.logAggregationStatus.put(nodeAddedEvent.getNodeId(), LogAggregationReport.newInstance((ApplicationId)app.applicationId, (LogAggregationStatus)(app.logAggregationEnabled ? LogAggregationStatus.NOT_START : LogAggregationStatus.DISABLED), (String)""));
            }
        }
    }

    private static final class RMAppStateUpdateTransition
    extends RMAppTransition {
        private YarnApplicationState stateToATS;

        public RMAppStateUpdateTransition(YarnApplicationState state) {
            this.stateToATS = state;
        }

        @Override
        public void transition(RMAppImpl app, RMAppEvent event) {
            app.rmContext.getSystemMetricsPublisher().appStateUpdated(app, this.stateToATS, app.systemClock.getTime());
        }
    }

    private static final class RMAppNodeUpdateTransition
    extends RMAppTransition {
        private RMAppNodeUpdateTransition() {
        }

        @Override
        public void transition(RMAppImpl app, RMAppEvent event) {
            RMAppNodeUpdateEvent nodeUpdateEvent = (RMAppNodeUpdateEvent)event;
            app.processNodeUpdate(nodeUpdateEvent.getUpdateType(), nodeUpdateEvent.getNode());
        }
    }

    private static class RMAppTransition
    implements SingleArcTransition<RMAppImpl, RMAppEvent> {
        private RMAppTransition() {
        }

        public void transition(RMAppImpl app, RMAppEvent event) {
        }
    }
}

