/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.net.InetSocketAddress;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.ContainerManagementProtocol;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.security.AMRMTokenIdentifier;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.amlauncher.AMLauncher;
import org.apache.hadoop.yarn.server.resourcemanager.amlauncher.AMLauncherEventType;
import org.apache.hadoop.yarn.server.resourcemanager.amlauncher.ApplicationMasterLauncher;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.security.JWTSecurityHandler;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMAppSecurityHandler;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMAppSecurityManager;
import org.apache.hadoop.yarn.server.resourcemanager.security.X509SecurityHandler;
import org.mockito.Mockito;

public class MockRMWithCustomAMLauncher
extends MockRM {
    private final ContainerManagementProtocol containerManager;
    private final boolean mockRMAppCertificateManager;

    public MockRMWithCustomAMLauncher(ContainerManagementProtocol containerManager) {
        this(new Configuration(), containerManager);
    }

    public MockRMWithCustomAMLauncher(Configuration conf, ContainerManagementProtocol containerManager) {
        this(conf, containerManager, false);
    }

    public MockRMWithCustomAMLauncher(Configuration conf, ContainerManagementProtocol containerManager, boolean mockRMAppCertificateManager) {
        super(conf);
        this.containerManager = containerManager;
        this.mockRMAppCertificateManager = mockRMAppCertificateManager;
    }

    @Override
    protected RMAppSecurityManager createRMAppSecurityManager() throws Exception {
        if (this.mockRMAppCertificateManager) {
            RMAppSecurityManager rmAppSecurityManager = (RMAppSecurityManager)Mockito.spy((Object)new RMAppSecurityManager((RMContext)this.rmContext));
            RMAppSecurityHandler x509SecurityHandler = (RMAppSecurityHandler)Mockito.spy((Object)new X509SecurityHandler((RMContext)this.rmContext, rmAppSecurityManager));
            rmAppSecurityManager.registerRMAppSecurityHandlerWithType(x509SecurityHandler, X509SecurityHandler.class);
            RMAppSecurityHandler jwtSecurityMaterial = (RMAppSecurityHandler)Mockito.spy((Object)new JWTSecurityHandler((RMContext)this.rmContext, rmAppSecurityManager));
            rmAppSecurityManager.registerRMAppSecurityHandlerWithType(jwtSecurityMaterial, JWTSecurityHandler.class);
            return rmAppSecurityManager;
        }
        return super.createRMAppSecurityManager();
    }

    @Override
    protected ApplicationMasterLauncher createAMLauncher() {
        return new ApplicationMasterLauncher(this.getRMContext()){

            protected Runnable createRunnableLauncher(RMAppAttempt application, AMLauncherEventType event) {
                return new AMLauncher(this.context, application, event, this.getConfig()){

                    protected ContainerManagementProtocol getContainerMgrProxy(ContainerId containerId) {
                        return MockRMWithCustomAMLauncher.this.containerManager;
                    }

                    protected Token<AMRMTokenIdentifier> createAndSetAMRMToken() {
                        Token amRmToken = super.createAndSetAMRMToken();
                        InetSocketAddress serviceAddr = this.getConfig().getSocketAddr("yarn.resourcemanager.scheduler.address", "0.0.0.0:8030", 8030);
                        SecurityUtil.setTokenService((Token)amRmToken, (InetSocketAddress)serviceAddr);
                        return amRmToken;
                    }
                };
            }
        };
    }
}

