/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import io.hops.util.DBUtility;
import io.hops.util.RMStorageFactory;
import io.hops.util.YarnAPIStorageFactory;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DataInputByteBuffer;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.yarn.api.ApplicationMasterProtocol;
import org.apache.hadoop.yarn.api.ContainerManagementProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerStatusesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerStatusesResponse;
import org.apache.hadoop.yarn.api.protocolrecords.IncreaseContainersResourceRequest;
import org.apache.hadoop.yarn.api.protocolrecords.IncreaseContainersResourceResponse;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterResponse;
import org.apache.hadoop.yarn.api.protocolrecords.SignalContainerRequest;
import org.apache.hadoop.yarn.api.protocolrecords.SignalContainerResponse;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainerRequest;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainersRequest;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainersResponse;
import org.apache.hadoop.yarn.api.protocolrecords.StopContainersRequest;
import org.apache.hadoop.yarn.api.protocolrecords.StopContainersResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.security.AMRMTokenIdentifier;
import org.apache.hadoop.yarn.server.resourcemanager.ApplicationMasterService;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMWithCustomAMLauncher;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.YarnScheduler;
import org.apache.hadoop.yarn.util.Records;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestAMAuthorization {
    private static final Log LOG = LogFactory.getLog(TestAMAuthorization.class);
    private final Configuration conf;
    private MockRM rm;

    @Parameterized.Parameters
    public static Collection<Object[]> configs() {
        Configuration conf = new Configuration();
        Configuration confWithSecurity = new Configuration();
        confWithSecurity.set("hadoop.security.authentication", UserGroupInformation.AuthenticationMethod.KERBEROS.toString());
        return Arrays.asList({conf}, {confWithSecurity});
    }

    public TestAMAuthorization(Configuration conf) {
        this.conf = conf;
        UserGroupInformation.setConfiguration((Configuration)conf);
    }

    @Before
    public void setUp() throws Exception {
        if (this.conf != null) {
            RMStorageFactory.setConfiguration((Configuration)this.conf);
            YarnAPIStorageFactory.setConfiguration((Configuration)this.conf);
            DBUtility.InitializeDB();
        }
    }

    @After
    public void tearDown() {
        if (this.rm != null) {
            this.rm.stop();
        }
    }

    @Test
    public void testAuthorizedAccess() throws Exception {
        MyContainerManager containerManager = new MyContainerManager();
        this.rm = new MockRMWithAMS(this.conf, containerManager);
        this.rm.start();
        MockNM nm1 = this.rm.registerNode("localhost:1234", 5120);
        HashMap<ApplicationAccessType, String> acls = new HashMap<ApplicationAccessType, String>(2);
        acls.put(ApplicationAccessType.VIEW_APP, "*");
        RMApp app = this.rm.submitApp(1024, "appname", "appuser", acls);
        nm1.nodeHeartbeat(true);
        int waitCount = 0;
        while (containerManager.containerTokens == null && waitCount++ < 20) {
            LOG.info((Object)"Waiting for AM Launch to happen..");
            Thread.sleep(1000L);
        }
        Assert.assertNotNull((Object)containerManager.containerTokens);
        RMAppAttempt attempt = app.getCurrentAppAttempt();
        ApplicationAttemptId applicationAttemptId = attempt.getAppAttemptId();
        this.waitForLaunchedState(attempt);
        final Configuration conf = this.rm.getConfig();
        final YarnRPC rpc = YarnRPC.create((Configuration)conf);
        UserGroupInformation currentUser = UserGroupInformation.createRemoteUser((String)applicationAttemptId.toString());
        Credentials credentials = containerManager.getContainerCredentials();
        InetSocketAddress rmBindAddress = this.rm.getApplicationMasterService().getBindAddress();
        Token<? extends TokenIdentifier> amRMToken = MockRMWithAMS.setupAndReturnAMRMToken(rmBindAddress, credentials.getAllTokens());
        currentUser.addToken(amRMToken);
        ApplicationMasterProtocol client = (ApplicationMasterProtocol)currentUser.doAs((PrivilegedAction)new PrivilegedAction<ApplicationMasterProtocol>(){

            @Override
            public ApplicationMasterProtocol run() {
                return (ApplicationMasterProtocol)rpc.getProxy(ApplicationMasterProtocol.class, TestAMAuthorization.this.rm.getApplicationMasterService().getBindAddress(), conf);
            }
        });
        RegisterApplicationMasterRequest request = (RegisterApplicationMasterRequest)Records.newRecord(RegisterApplicationMasterRequest.class);
        RegisterApplicationMasterResponse response = client.registerApplicationMaster(request);
        Assert.assertNotNull((Object)response.getClientToAMTokenMasterKey());
        if (UserGroupInformation.isSecurityEnabled()) {
            Assert.assertTrue((response.getClientToAMTokenMasterKey().array().length > 0 ? 1 : 0) != 0);
        }
        Assert.assertEquals((String)"Register response has bad ACLs", (Object)"*", response.getApplicationACLs().get(ApplicationAccessType.VIEW_APP));
    }

    @Test
    public void testUnauthorizedAccess() throws Exception {
        MyContainerManager containerManager = new MyContainerManager();
        this.rm = new MockRMWithAMS(this.conf, containerManager);
        this.rm.start();
        MockNM nm1 = this.rm.registerNode("localhost:1234", 5120);
        RMApp app = this.rm.submitApp(1024);
        nm1.nodeHeartbeat(true);
        int waitCount = 0;
        while (containerManager.containerTokens == null && waitCount++ < 40) {
            LOG.info((Object)"Waiting for AM Launch to happen..");
            Thread.sleep(1000L);
        }
        Assert.assertNotNull((Object)containerManager.containerTokens);
        RMAppAttempt attempt = app.getCurrentAppAttempt();
        ApplicationAttemptId applicationAttemptId = attempt.getAppAttemptId();
        this.waitForLaunchedState(attempt);
        final Configuration conf = this.rm.getConfig();
        final YarnRPC rpc = YarnRPC.create((Configuration)conf);
        final InetSocketAddress serviceAddr = conf.getSocketAddr("yarn.resourcemanager.scheduler.address", "0.0.0.0:8030", 8030);
        UserGroupInformation currentUser = UserGroupInformation.createRemoteUser((String)applicationAttemptId.toString());
        ApplicationMasterProtocol client = (ApplicationMasterProtocol)currentUser.doAs((PrivilegedAction)new PrivilegedAction<ApplicationMasterProtocol>(){

            @Override
            public ApplicationMasterProtocol run() {
                return (ApplicationMasterProtocol)rpc.getProxy(ApplicationMasterProtocol.class, serviceAddr, conf);
            }
        });
        RegisterApplicationMasterRequest request = (RegisterApplicationMasterRequest)Records.newRecord(RegisterApplicationMasterRequest.class);
        try {
            client.registerApplicationMaster(request);
            Assert.fail((String)"Should fail with authorization error");
        }
        catch (Exception e) {
            if (TestAMAuthorization.isCause(AccessControlException.class, e)) {
                String expectedMessage = "";
                expectedMessage = UserGroupInformation.isSecurityEnabled() ? "Client cannot authenticate via:[TOKEN]" : "SIMPLE authentication is not enabled.  Available:[TOKEN]";
                Assert.assertTrue((boolean)e.getCause().getMessage().contains(expectedMessage));
            }
            throw e;
        }
    }

    private static boolean isCause(Class<? extends Throwable> expected, Throwable e) {
        return e != null && (expected.isInstance(e) || TestAMAuthorization.isCause(expected, e.getCause()));
    }

    private void waitForLaunchedState(RMAppAttempt attempt) throws InterruptedException {
        int waitCount = 0;
        while (attempt.getAppAttemptState() != RMAppAttemptState.LAUNCHED && waitCount++ < 40) {
            LOG.info((Object)("Waiting for AppAttempt to reach LAUNCHED state. Current state is " + attempt.getAppAttemptState()));
            Thread.sleep(1000L);
        }
        Assert.assertEquals((Object)attempt.getAppAttemptState(), (Object)RMAppAttemptState.LAUNCHED);
    }

    public static class MockRMWithAMS
    extends MockRMWithCustomAMLauncher {
        public MockRMWithAMS(Configuration conf, ContainerManagementProtocol containerManager) {
            super(conf, containerManager);
        }

        protected void doSecureLogin() throws IOException {
        }

        @Override
        protected ApplicationMasterService createApplicationMasterService() {
            return new ApplicationMasterService(this.getRMContext(), (YarnScheduler)this.scheduler);
        }

        public static Token<? extends TokenIdentifier> setupAndReturnAMRMToken(InetSocketAddress rmBindAddress, Collection<Token<? extends TokenIdentifier>> allTokens) {
            for (Token<? extends TokenIdentifier> token : allTokens) {
                if (!token.getKind().equals((Object)AMRMTokenIdentifier.KIND_NAME)) continue;
                SecurityUtil.setTokenService(token, (InetSocketAddress)rmBindAddress);
                return token;
            }
            return null;
        }
    }

    public static final class MyContainerManager
    implements ContainerManagementProtocol {
        public ByteBuffer containerTokens;

        public StartContainersResponse startContainers(StartContainersRequest request) throws YarnException {
            this.containerTokens = ((StartContainerRequest)request.getStartContainerRequests().get(0)).getContainerLaunchContext().getTokens();
            return StartContainersResponse.newInstance(null, null, null);
        }

        public StopContainersResponse stopContainers(StopContainersRequest request) throws YarnException {
            return StopContainersResponse.newInstance(null, null);
        }

        public GetContainerStatusesResponse getContainerStatuses(GetContainerStatusesRequest request) throws YarnException {
            return GetContainerStatusesResponse.newInstance(null, null);
        }

        public IncreaseContainersResourceResponse increaseContainersResource(IncreaseContainersResourceRequest request) throws YarnException {
            return IncreaseContainersResourceResponse.newInstance(null, null);
        }

        public Credentials getContainerCredentials() throws IOException {
            Credentials credentials = new Credentials();
            DataInputByteBuffer buf = new DataInputByteBuffer();
            this.containerTokens.rewind();
            buf.reset(new ByteBuffer[]{this.containerTokens});
            credentials.readTokenStorageStream((DataInputStream)buf);
            return credentials;
        }

        public SignalContainerResponse signalToContainer(SignalContainerRequest request) throws YarnException, IOException {
            return null;
        }
    }
}

