/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import io.hops.util.DBUtility;
import io.hops.util.RMStorageFactory;
import io.hops.util.YarnAPIStorageFactory;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.ApplicationMasterProtocol;
import org.apache.hadoop.yarn.api.ContainerManagementProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerStatusesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerStatusesResponse;
import org.apache.hadoop.yarn.api.protocolrecords.IncreaseContainersResourceRequest;
import org.apache.hadoop.yarn.api.protocolrecords.IncreaseContainersResourceResponse;
import org.apache.hadoop.yarn.api.protocolrecords.SignalContainerRequest;
import org.apache.hadoop.yarn.api.protocolrecords.SignalContainerResponse;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainerRequest;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainersRequest;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainersResponse;
import org.apache.hadoop.yarn.api.protocolrecords.StopContainersRequest;
import org.apache.hadoop.yarn.api.protocolrecords.StopContainersResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.DrainDispatcher;
import org.apache.hadoop.yarn.exceptions.ApplicationAttemptNotFoundException;
import org.apache.hadoop.yarn.exceptions.ApplicationMasterNotRegisteredException;
import org.apache.hadoop.yarn.exceptions.NMNotYetReadyException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.ipc.RPCUtil;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.security.AMRMTokenIdentifier;
import org.apache.hadoop.yarn.security.ContainerTokenIdentifier;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRMWithCustomAMLauncher;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.amlauncher.AMLauncher;
import org.apache.hadoop.yarn.server.resourcemanager.amlauncher.AMLauncherEventType;
import org.apache.hadoop.yarn.server.resourcemanager.amlauncher.ApplicationMasterLauncher;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.security.JWTSecurityHandler;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMAppSecurityHandler;
import org.apache.hadoop.yarn.server.resourcemanager.security.X509SecurityHandler;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class TestApplicationMasterLauncher {
    private static final Log LOG = LogFactory.getLog(TestApplicationMasterLauncher.class);
    private Configuration conf;

    @Test(timeout=10000L)
    public void testAMLaunchWithCryptoMaterial() throws Exception {
        this.conf.setBoolean("ipc.server.ssl.enabled", true);
        this.conf.setBoolean(YarnConfiguration.RM_JWT_ENABLED, false);
        AtomicBoolean testPass = new AtomicBoolean(true);
        TestCryptoMockRM rm = new TestCryptoMockRM(this.conf, testPass);
        rm.start();
        MockNM nm = rm.registerNode("127.0.0.1:1337", 15360);
        RMApp app = rm.submitApp(1024);
        nm.nodeHeartbeat(true);
        RMAppAttempt appAttempt = app.getCurrentAppAttempt();
        MockAM am = rm.sendAMLaunched(appAttempt.getAppAttemptId());
        am.registerAppAttempt(true);
        nm.nodeHeartbeat(true);
        Assert.assertTrue((boolean)testPass.get());
        rm.stop();
    }

    @Test
    public void testAMLaunchAndCleanup() throws Exception {
        Logger rootLogger = LogManager.getRootLogger();
        rootLogger.setLevel(Level.DEBUG);
        MyContainerManagerImpl containerManager = new MyContainerManagerImpl();
        MockRMWithCustomAMLauncher rm = new MockRMWithCustomAMLauncher(new Configuration(), containerManager, true);
        rm.start();
        MockNM nm1 = rm.registerNode("127.0.0.1:1234", 5120);
        RMApp app = rm.submitApp(2000);
        nm1.nodeHeartbeat(true);
        int waitCount = 0;
        while (!containerManager.launched && waitCount++ < 20) {
            LOG.info((Object)"Waiting for AM Launch to happen..");
            Thread.sleep(1000L);
        }
        Assert.assertTrue((boolean)containerManager.launched);
        RMAppAttempt attempt = app.getCurrentAppAttempt();
        ApplicationAttemptId appAttemptId = attempt.getAppAttemptId();
        Assert.assertEquals((Object)appAttemptId.toString(), (Object)containerManager.attemptIdAtContainerManager);
        Assert.assertEquals((long)app.getSubmitTime(), (long)containerManager.submitTimeAtContainerManager);
        Assert.assertEquals((Object)app.getRMAppAttempt(appAttemptId).getMasterContainer().getId().toString(), (Object)containerManager.containerIdAtContainerManager);
        Assert.assertEquals((Object)nm1.getNodeId().toString(), (Object)containerManager.nmHostAtContainerManager);
        Assert.assertEquals((long)2L, (long)containerManager.maxAppAttempts);
        MockAM am = new MockAM(rm.getRMContext(), (ApplicationMasterProtocol)rm.getApplicationMasterService(), appAttemptId);
        am.registerAppAttempt();
        am.unregisterAppAttempt();
        nm1.nodeHeartbeat(attempt.getAppAttemptId(), 1L, ContainerState.COMPLETE);
        am.waitForState(RMAppAttemptState.FINISHED);
        waitCount = 0;
        while (!containerManager.cleanedup && waitCount++ < 20) {
            LOG.info((Object)"Waiting for AM Cleanup to happen..");
            Thread.sleep(1000L);
        }
        Assert.assertTrue((boolean)containerManager.cleanedup);
        am.waitForState(RMAppAttemptState.FINISHED);
        X509SecurityHandler.X509MaterialParameter x509Param = new X509SecurityHandler.X509MaterialParameter(app.getApplicationId(), app.getUser(), app.getCryptoMaterialVersion());
        ((RMAppSecurityHandler)Mockito.verify((Object)rm.rmAppSecurityManager.getSecurityHandler(X509SecurityHandler.class))).revokeMaterial(Mockito.eq((Object)x509Param), Boolean.valueOf(Mockito.eq((boolean)false)));
        JWTSecurityHandler.JWTMaterialParameter jwtParam = new JWTSecurityHandler.JWTMaterialParameter(app.getApplicationId(), app.getUser());
        jwtParam.setExpirationDate(app.getJWTExpiration());
        ((RMAppSecurityHandler)Mockito.verify((Object)rm.rmAppSecurityManager.getSecurityHandler(JWTSecurityHandler.class))).revokeMaterial(Mockito.eq((Object)jwtParam), Boolean.valueOf(Matchers.anyBoolean()));
        rm.stop();
    }

    @Before
    public void setUp() throws Exception {
        this.conf = new Configuration();
        RMStorageFactory.setConfiguration((Configuration)this.conf);
        YarnAPIStorageFactory.setConfiguration((Configuration)this.conf);
        DBUtility.InitializeDB();
    }

    @Test
    public void testRetriesOnFailures() throws Exception {
        final ContainerManagementProtocol mockProxy = (ContainerManagementProtocol)Mockito.mock(ContainerManagementProtocol.class);
        StartContainersResponse mockResponse = (StartContainersResponse)Mockito.mock(StartContainersResponse.class);
        Mockito.when((Object)mockProxy.startContainers((StartContainersRequest)Matchers.any(StartContainersRequest.class))).thenThrow(new Throwable[]{new NMNotYetReadyException("foo")}).thenReturn((Object)mockResponse);
        this.conf.setInt("yarn.resourcemanager.am.max-attempts", 1);
        this.conf.setInt("yarn.client.nodemanager-connect.retry-interval-ms", 1);
        MockRMWithCustomAMLauncher rm = new MockRMWithCustomAMLauncher(this.conf, null){

            @Override
            protected ApplicationMasterLauncher createAMLauncher() {
                return new ApplicationMasterLauncher(this.getRMContext()){

                    protected Runnable createRunnableLauncher(RMAppAttempt application, AMLauncherEventType event) {
                        return new AMLauncher(this.context, application, event, this.getConfig()){

                            protected YarnRPC getYarnRPC() {
                                YarnRPC mockRpc = (YarnRPC)Mockito.mock(YarnRPC.class);
                                Mockito.when((Object)mockRpc.getProxy((Class)Matchers.any(Class.class), (InetSocketAddress)Matchers.any(InetSocketAddress.class), (Configuration)Matchers.any(Configuration.class))).thenReturn((Object)mockProxy);
                                return mockRpc;
                            }
                        };
                    }
                };
            }
        };
        rm.start();
        MockNM nm1 = rm.registerNode("127.0.0.1:1234", 5120);
        RMApp app = rm.submitApp(2000);
        ApplicationAttemptId appAttemptId = app.getCurrentAppAttempt().getAppAttemptId();
        nm1.nodeHeartbeat(true);
        ((DrainDispatcher)rm.getRmDispatcher()).await();
        rm.waitForState(appAttemptId, RMAppAttemptState.LAUNCHED, 500);
    }

    @Test(timeout=100000L)
    public void testallocateBeforeAMRegistration() throws Exception {
        Logger rootLogger = LogManager.getRootLogger();
        boolean thrown = false;
        rootLogger.setLevel(Level.DEBUG);
        MockRM rm = new MockRM();
        rm.start();
        MockNM nm1 = rm.registerNode("h1:1234", 5000);
        RMApp app = rm.submitApp(2000);
        nm1.nodeHeartbeat(true);
        RMAppAttempt attempt = app.getCurrentAppAttempt();
        MockAM am = rm.sendAMLaunched(attempt.getAppAttemptId());
        int request = 2;
        AllocateResponse ar = null;
        try {
            ar = am.allocate("h1", 1000, request, new ArrayList<ContainerId>());
            Assert.fail();
        }
        catch (ApplicationMasterNotRegisteredException applicationMasterNotRegisteredException) {
            // empty catch block
        }
        nm1.nodeHeartbeat(true);
        AllocateResponse amrs = null;
        try {
            amrs = am.allocate(new ArrayList<ResourceRequest>(), new ArrayList<ContainerId>());
            Assert.fail();
        }
        catch (ApplicationMasterNotRegisteredException applicationMasterNotRegisteredException) {
            // empty catch block
        }
        am.registerAppAttempt();
        try {
            am.registerAppAttempt(false);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals((Object)("Application Master is already registered : " + attempt.getAppAttemptId().getApplicationId()), (Object)e.getMessage());
        }
        am.unregisterAppAttempt();
        nm1.nodeHeartbeat(attempt.getAppAttemptId(), 1L, ContainerState.COMPLETE);
        am.waitForState(RMAppAttemptState.FINISHED);
        try {
            amrs = am.allocate(new ArrayList<ResourceRequest>(), new ArrayList<ContainerId>());
            Assert.fail();
        }
        catch (ApplicationAttemptNotFoundException applicationAttemptNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testSetupTokens() throws Exception {
        MockRM rm = new MockRM();
        rm.start();
        MockNM nm1 = rm.registerNode("h1:1234", 5000);
        RMApp app = rm.submitApp(2000);
        nm1.nodeHeartbeat(true);
        RMAppAttempt attempt = app.getCurrentAppAttempt();
        MyAMLauncher launcher = new MyAMLauncher(rm.getRMContext(), attempt, AMLauncherEventType.LAUNCH, rm.getConfig());
        DataOutputBuffer dob = new DataOutputBuffer();
        Credentials ts = new Credentials();
        ts.writeTokenStorageToStream((DataOutputStream)dob);
        ByteBuffer securityTokens = ByteBuffer.wrap(dob.getData(), 0, dob.getLength());
        ContainerLaunchContext amContainer = ContainerLaunchContext.newInstance(null, null, null, null, (ByteBuffer)securityTokens, null);
        ContainerId containerId = ContainerId.newContainerId((ApplicationAttemptId)attempt.getAppAttemptId(), (long)0L);
        try {
            launcher.setupTokens(amContainer, containerId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            launcher.setupTokens(amContainer, containerId);
        }
        catch (EOFException e) {
            Assert.fail((String)"EOFException should not happen.");
        }
    }

    private class TestCryptoAMLauncher
    extends AMLauncher {
        private final AtomicBoolean testPass;

        public TestCryptoAMLauncher(RMContext rmContext, RMAppAttempt application, AMLauncherEventType eventType, Configuration conf, AtomicBoolean testPass) {
            super(rmContext, application, eventType, conf);
            this.testPass = testPass;
        }

        protected void setupX509Material(StartContainersRequest request, RMApp application) {
            super.setupX509Material(request, application);
            if (request.getKeyStore() == null || request.getKeyStore().limit() == 0 || request.getKeyStorePassword() == null || request.getTrustStore() == null || request.getTrustStore().limit() == 0 || request.getTrustStorePassword() == null) {
                this.testPass.set(false);
            }
        }

        protected void setupJWTMaterial(StartContainersRequest request, RMApp application) {
            super.setupJWTMaterial(request, application);
            if (request.getJWT() == null || request.getJWT().isEmpty()) {
                this.testPass.set(false);
            }
        }
    }

    private class TestCryptoMockRM
    extends MockRM {
        private final AtomicBoolean testPass;

        private TestCryptoMockRM(Configuration conf, AtomicBoolean testPass) {
            super(conf);
            this.testPass = testPass;
        }

        @Override
        protected ApplicationMasterLauncher createAMLauncher() {
            return new ApplicationMasterLauncher((RMContext)this.rmContext){

                protected Runnable createRunnableLauncher(RMAppAttempt application, AMLauncherEventType event) {
                    return new TestCryptoAMLauncher((RMContext)TestCryptoMockRM.this.rmContext, application, event, TestApplicationMasterLauncher.this.conf, TestCryptoMockRM.this.testPass);
                }
            };
        }
    }

    static class MyAMLauncher
    extends AMLauncher {
        int count = 0;

        public MyAMLauncher(RMContext rmContext, RMAppAttempt application, AMLauncherEventType eventType, Configuration conf) {
            super(rmContext, application, eventType, conf);
        }

        protected Token<AMRMTokenIdentifier> createAndSetAMRMToken() {
            ++this.count;
            if (this.count == 1) {
                throw new RuntimeException("createAndSetAMRMToken failure");
            }
            return null;
        }

        protected void setupTokens(ContainerLaunchContext container, ContainerId containerID) throws IOException {
            super.setupTokens(container, containerID);
        }
    }

    private static final class MyContainerManagerImpl
    implements ContainerManagementProtocol {
        boolean launched = false;
        boolean cleanedup = false;
        String attemptIdAtContainerManager = null;
        String containerIdAtContainerManager = null;
        String nmHostAtContainerManager = null;
        long submitTimeAtContainerManager;
        int maxAppAttempts;

        private MyContainerManagerImpl() {
        }

        public StartContainersResponse startContainers(StartContainersRequest requests) throws YarnException {
            StartContainerRequest request = (StartContainerRequest)requests.getStartContainerRequests().get(0);
            LOG.info((Object)("Container started by MyContainerManager: " + request));
            this.launched = true;
            Map env = request.getContainerLaunchContext().getEnvironment();
            org.apache.hadoop.yarn.api.records.Token containerToken = request.getContainerToken();
            ContainerTokenIdentifier tokenId = null;
            try {
                tokenId = BuilderUtils.newContainerTokenIdentifier((org.apache.hadoop.yarn.api.records.Token)containerToken);
            }
            catch (IOException e) {
                throw RPCUtil.getRemoteException((Throwable)e);
            }
            ContainerId containerId = tokenId.getContainerID();
            this.containerIdAtContainerManager = containerId.toString();
            this.attemptIdAtContainerManager = containerId.getApplicationAttemptId().toString();
            this.nmHostAtContainerManager = tokenId.getNmHostAddress();
            this.submitTimeAtContainerManager = Long.parseLong((String)env.get("APP_SUBMIT_TIME_ENV"));
            this.maxAppAttempts = Integer.parseInt((String)env.get("MAX_APP_ATTEMPTS"));
            return StartContainersResponse.newInstance(new HashMap(), new ArrayList(), new HashMap());
        }

        public StopContainersResponse stopContainers(StopContainersRequest request) throws YarnException {
            LOG.info((Object)"Container cleaned up by MyContainerManager");
            this.cleanedup = true;
            return null;
        }

        public GetContainerStatusesResponse getContainerStatuses(GetContainerStatusesRequest request) throws YarnException {
            return null;
        }

        public IncreaseContainersResourceResponse increaseContainersResource(IncreaseContainersResourceRequest request) throws YarnException {
            return null;
        }

        public SignalContainerResponse signalToContainer(SignalContainerRequest request) throws YarnException, IOException {
            return null;
        }
    }
}

