/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import io.hops.util.DBUtility;
import io.hops.util.RMStorageFactory;
import io.hops.util.YarnAPIStorageFactory;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.DrainDispatcher;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.applicationsmanager.TestAMRestart;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.MemoryRMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestNodeBlacklistingOnAMFailures {
    @Before
    public void setup() throws IOException {
        YarnConfiguration conf = new YarnConfiguration();
        RMStorageFactory.setConfiguration((Configuration)conf);
        YarnAPIStorageFactory.setConfiguration((Configuration)conf);
        DBUtility.InitializeDB();
    }

    @Test(timeout=100000L)
    public void testNodeBlacklistingOnAMFailure() throws Exception {
        MockNM otherNode;
        MockNM currentNode;
        YarnConfiguration conf = new YarnConfiguration();
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        conf.setBoolean("yarn.resourcemanager.am-scheduling.node-blacklisting-enabled", true);
        MockRM rm = this.startRM(conf);
        CapacityScheduler scheduler = (CapacityScheduler)rm.getResourceScheduler();
        MockNM nm1 = new MockNM("127.0.0.1:1234", 8000, rm.getResourceTrackerService());
        nm1.registerNode();
        MockNM nm2 = new MockNM("127.0.0.2:2345", 8000, rm.getResourceTrackerService());
        nm2.registerNode();
        RMApp app = rm.submitApp(200);
        MockAM am1 = MockRM.launchAndRegisterAM(app, rm, nm1);
        ContainerId amContainerId = ContainerId.newContainerId((ApplicationAttemptId)am1.getApplicationAttemptId(), (long)1L);
        RMContainer rmContainer = scheduler.getRMContainer(amContainerId);
        NodeId nodeWhereAMRan = rmContainer.getAllocatedNode();
        if (nodeWhereAMRan.equals((Object)nm1.getNodeId())) {
            currentNode = nm1;
            otherNode = nm2;
        } else {
            currentNode = nm2;
            otherNode = nm1;
        }
        MockNM nm3 = new MockNM("127.0.0.3:2345", 8000, rm.getResourceTrackerService());
        nm3.registerNode();
        MockNM nm4 = new MockNM("127.0.0.4:2345", 8000, rm.getResourceTrackerService());
        nm4.registerNode();
        MockNM nm5 = new MockNM("127.0.0.5:2345", 8000, rm.getResourceTrackerService());
        nm5.registerNode();
        this.makeAMContainerExit(rm, amContainerId, currentNode, -1000);
        RMAppAttempt attempt = MockRM.waitForAttemptScheduled(app, rm);
        System.out.println("New AppAttempt launched " + attempt.getAppAttemptId());
        for (int i = 0; i <= 2; ++i) {
            currentNode.nodeHeartbeat(true);
            ((DrainDispatcher)rm.getRMContext().getDispatcher()).await();
            Assert.assertEquals((String)"AppAttemptState should still be SCHEDULED if currentNode is blacklisted correctly", (Object)RMAppAttemptState.SCHEDULED, (Object)attempt.getAppAttemptState());
        }
        otherNode.nodeHeartbeat(true);
        ((DrainDispatcher)rm.getRMContext().getDispatcher()).await();
        rm.waitForState(attempt.getAppAttemptId(), RMAppAttemptState.ALLOCATED, 20000);
        MockAM am2 = rm.sendAMLaunched(attempt.getAppAttemptId());
        rm.waitForState(attempt.getAppAttemptId(), RMAppAttemptState.LAUNCHED);
        amContainerId = ContainerId.newContainerId((ApplicationAttemptId)am2.getApplicationAttemptId(), (long)1L);
        rmContainer = scheduler.getRMContainer(amContainerId);
        nodeWhereAMRan = rmContainer.getAllocatedNode();
        Assert.assertEquals((String)"After blacklisting, AM should have run on the other node", (Object)otherNode.getNodeId(), (Object)nodeWhereAMRan);
        am2.registerAppAttempt();
        rm.waitForState(app.getApplicationId(), RMAppState.RUNNING);
        List<Container> allocatedContainers = TestAMRestart.allocateContainers(currentNode, am2, 1);
        Assert.assertEquals((String)"Even though AM is blacklisted from the node, application can still allocate non-AM containers there", (Object)currentNode.getNodeId(), (Object)allocatedContainers.get(0).getNodeId());
    }

    @Test(timeout=100000L)
    public void testNoBlacklistingForNonSystemErrors() throws Exception {
        YarnConfiguration conf = new YarnConfiguration();
        conf.setBoolean("yarn.resourcemanager.am-scheduling.node-blacklisting-enabled", true);
        conf.setFloat("yarn.resourcemanager.am-scheduling.node-blacklisting-disable-threshold", 1.5f);
        conf.setInt("yarn.resourcemanager.am.max-attempts", 100);
        MockRM rm = this.startRM(conf);
        MockNM node = new MockNM("127.0.0.1:1234", 8000, rm.getResourceTrackerService());
        node.registerNode();
        RMApp app = rm.submitApp(200);
        ApplicationId appId = app.getApplicationId();
        int numAppAttempts = 1;
        RMAppAttempt attempt = MockRM.waitForAttemptScheduled(app, rm);
        node.nodeHeartbeat(true);
        ((DrainDispatcher)rm.getRMContext().getDispatcher()).await();
        rm.waitForState(attempt.getAppAttemptId(), RMAppAttemptState.ALLOCATED, 20000);
        rm.sendAMLaunched(attempt.getAppAttemptId());
        rm.waitForState(attempt.getAppAttemptId(), RMAppAttemptState.LAUNCHED);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)numAppAttempts);
        ContainerId amContainerId = ContainerId.newContainerId((ApplicationAttemptId)appAttemptId, (long)1L);
        for (int containerExitStatus : new int[]{-102, -106, -107, -100, -101, -103, -104}) {
            this.makeAMContainerExit(rm, amContainerId, node, containerExitStatus);
            attempt = MockRM.waitForAttemptScheduled(app, rm);
            System.out.println("New AppAttempt launched " + attempt.getAppAttemptId());
            node.nodeHeartbeat(true);
            ((DrainDispatcher)rm.getRMContext().getDispatcher()).await();
            rm.waitForState(attempt.getAppAttemptId(), RMAppAttemptState.ALLOCATED, 20000);
            rm.sendAMLaunched(attempt.getAppAttemptId());
            rm.waitForState(attempt.getAppAttemptId(), RMAppAttemptState.LAUNCHED);
            appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)(++numAppAttempts));
            amContainerId = ContainerId.newContainerId((ApplicationAttemptId)appAttemptId, (long)1L);
            rm.waitForState(node, amContainerId, RMContainerState.ACQUIRED);
        }
    }

    private void makeAMContainerExit(MockRM rm, ContainerId amContainer, MockNM node, int exitStatus) throws Exception, InterruptedException {
        ContainerStatus containerStatus = BuilderUtils.newContainerStatus((ContainerId)amContainer, (ContainerState)ContainerState.COMPLETE, (String)"", (int)exitStatus, (Resource)Resources.createResource((int)200));
        node.containerStatus(containerStatus);
        ApplicationAttemptId amAttemptID = amContainer.getApplicationAttemptId();
        rm.waitForState(amAttemptID, RMAppAttemptState.FAILED);
        rm.waitForState(amAttemptID.getApplicationId(), RMAppState.ACCEPTED);
    }

    private MockRM startRM(YarnConfiguration conf) {
        MemoryRMStateStore memStore = new MemoryRMStateStore();
        memStore.init((Configuration)conf);
        MockRM rm1 = new MockRM((Configuration)conf, (RMStateStore)memStore){

            protected EventHandler<SchedulerEvent> createSchedulerEventDispatcher() {
                return new ResourceManager.SchedulerEventDispatcher(this.scheduler){

                    public void handle(SchedulerEvent event) {
                        super.handle(event);
                    }
                };
            }

            @Override
            protected Dispatcher createDispatcher() {
                return new DrainDispatcher();
            }
        };
        rm1.start();
        return rm1;
    }
}

