/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import io.hops.util.DBUtility;
import io.hops.util.RMStorageFactory;
import io.hops.util.YarnAPIStorageFactory;
import java.util.Arrays;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AuthorizationException;
import org.apache.hadoop.security.authorize.ProxyUsers;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestRMProxyUsersConf {
    private static final UserGroupInformation FOO_USER = UserGroupInformation.createUserForTesting((String)"foo", (String[])new String[]{"foo_group"});
    private static final UserGroupInformation BAR_USER = UserGroupInformation.createUserForTesting((String)"bar", (String[])new String[]{"bar_group"});
    private final String ipAddress = "127.0.0.1";
    private Configuration conf = new YarnConfiguration();

    @Parameterized.Parameters
    public static Collection<Object[]> headers() {
        return Arrays.asList({0}, {1}, {2});
    }

    public TestRMProxyUsersConf(int round) {
        switch (round) {
            case 0: {
                this.conf.set("hadoop.proxyuser.foo.hosts", "127.0.0.1");
                this.conf.set("hadoop.proxyuser.foo.users", "bar");
                this.conf.set("hadoop.proxyuser.foo.groups", "bar_group");
                break;
            }
            case 1: {
                this.conf.set("yarn.resourcemanager.proxyuser.foo.hosts", "127.0.0.1");
                this.conf.set("yarn.resourcemanager.proxyuser.foo.users", "bar");
                this.conf.set("yarn.resourcemanager.proxyuser.foo.groups", "bar_group");
                break;
            }
            case 2: {
                this.conf.set("hadoop.proxyuser.foo.hosts", "xyz");
                this.conf.set("hadoop.proxyuser.foo.users", "xyz");
                this.conf.set("hadoop.proxyuser.foo.groups", "xyz");
                this.conf.set("yarn.resourcemanager.proxyuser.foo.hosts", "127.0.0.1");
                this.conf.set("yarn.resourcemanager.proxyuser.foo.users", "bar");
                this.conf.set("yarn.resourcemanager.proxyuser.foo.groups", "bar_group");
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProxyUserConfiguration() throws Exception {
        RMStorageFactory.setConfiguration((Configuration)this.conf);
        YarnAPIStorageFactory.setConfiguration((Configuration)this.conf);
        DBUtility.InitializeDB();
        MockRM rm = null;
        try {
            rm = new MockRM(this.conf);
            rm.start();
            Thread.sleep(10000L);
            UserGroupInformation proxyUser = UserGroupInformation.createProxyUser((String)BAR_USER.getShortUserName(), (UserGroupInformation)FOO_USER);
            try {
                ProxyUsers.getDefaultImpersonationProvider().authorize(proxyUser, "127.0.0.1");
            }
            catch (AuthorizationException e) {
                Assert.fail();
            }
        }
        finally {
            if (rm != null) {
                rm.stop();
                rm.close();
            }
        }
    }
}

