/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.logaggregationstatus;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.LogAggregationStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.event.InlineDispatcher;
import org.apache.hadoop.yarn.server.api.protocolrecords.LogAggregationReport;
import org.apache.hadoop.yarn.server.api.records.NodeHealthStatus;
import org.apache.hadoop.yarn.server.api.records.NodeStatus;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.RMContextImpl;
import org.apache.hadoop.yarn.server.resourcemanager.ahs.RMApplicationHistoryWriter;
import org.apache.hadoop.yarn.server.resourcemanager.metrics.SystemMetricsPublisher;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppRunningOnNodeEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeImplNotDist;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeStartedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeStatusEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.YarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEventType;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class TestRMAppLogAggregationStatus {
    private RMContext rmContext;
    private YarnScheduler scheduler;
    private SchedulerEventType eventType;
    private ApplicationId appId;

    @Before
    public void setUp() throws Exception {
        InlineDispatcher rmDispatcher = new InlineDispatcher();
        this.rmContext = new RMContextImpl((Dispatcher)rmDispatcher, null, null, null, null, null, null, null, null);
        this.rmContext.setSystemMetricsPublisher(new SystemMetricsPublisher());
        this.rmContext.setRMApplicationHistoryWriter((RMApplicationHistoryWriter)Mockito.mock(RMApplicationHistoryWriter.class));
        this.scheduler = (YarnScheduler)Mockito.mock(YarnScheduler.class);
        ((YarnScheduler)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                SchedulerEvent event = (SchedulerEvent)invocation.getArguments()[0];
                TestRMAppLogAggregationStatus.this.eventType = (SchedulerEventType)event.getType();
                if (TestRMAppLogAggregationStatus.this.eventType == SchedulerEventType.NODE_UPDATE) {
                    // empty if block
                }
                return null;
            }
        }).when((Object)this.scheduler)).handle((Event)Matchers.any(SchedulerEvent.class));
        rmDispatcher.register(SchedulerEventType.class, (EventHandler)new TestSchedulerEventDispatcher());
        this.appId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1);
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testLogAggregationStatus() throws Exception {
        YarnConfiguration conf = new YarnConfiguration();
        conf.setBoolean("yarn.log-aggregation-enable", true);
        conf.setLong("yarn.log-aggregation-status.time-out.ms", 1500L);
        RMApp rmApp = this.createRMApp((Configuration)conf);
        this.rmContext.getRMApps().put(this.appId, rmApp);
        rmApp.handle((Event)new RMAppEvent(this.appId, RMAppEventType.START));
        rmApp.handle((Event)new RMAppEvent(this.appId, RMAppEventType.APP_NEW_SAVED));
        rmApp.handle((Event)new RMAppEvent(this.appId, RMAppEventType.SECURITY_MATERIAL_GENERATED));
        rmApp.handle((Event)new RMAppEvent(this.appId, RMAppEventType.APP_ACCEPTED));
        NodeId nodeId1 = NodeId.newInstance((String)"localhost", (int)1234);
        Resource capability = Resource.newInstance((int)4096, (int)4);
        RMNodeImplNotDist node1 = new RMNodeImplNotDist(nodeId1, this.rmContext, null, 0, 0, null, capability, null);
        node1.handle((Event)new RMNodeStartedEvent(nodeId1, null, null));
        rmApp.handle((Event)new RMAppRunningOnNodeEvent(this.appId, nodeId1));
        NodeId nodeId2 = NodeId.newInstance((String)"localhost", (int)2345);
        RMNodeImplNotDist node2 = new RMNodeImplNotDist(nodeId2, this.rmContext, null, 0, 0, null, capability, null);
        node2.handle((Event)new RMNodeStartedEvent(node2.getNodeID(), null, null));
        rmApp.handle((Event)new RMAppRunningOnNodeEvent(this.appId, nodeId2));
        Map logAggregationStatus = rmApp.getLogAggregationReportsForApp();
        Assert.assertEquals((long)2L, (long)logAggregationStatus.size());
        Assert.assertTrue((boolean)logAggregationStatus.containsKey(nodeId1));
        Assert.assertTrue((boolean)logAggregationStatus.containsKey(nodeId2));
        for (Map.Entry report : logAggregationStatus.entrySet()) {
            Assert.assertEquals((Object)LogAggregationStatus.NOT_START, (Object)((LogAggregationReport)report.getValue()).getLogAggregationStatus());
        }
        ArrayList<LogAggregationReport> node1ReportForApp = new ArrayList<LogAggregationReport>();
        String messageForNode1_1 = "node1 logAggregation status updated at " + System.currentTimeMillis();
        LogAggregationReport report1 = LogAggregationReport.newInstance((ApplicationId)this.appId, (LogAggregationStatus)LogAggregationStatus.RUNNING, (String)messageForNode1_1);
        node1ReportForApp.add(report1);
        NodeStatus nodeStatus1 = NodeStatus.newInstance((NodeId)node1.getNodeID(), (int)0, new ArrayList(), null, (NodeHealthStatus)NodeHealthStatus.newInstance((boolean)true, null, (long)0L), null, null, null);
        node1.handle((Event)new RMNodeStatusEvent(node1.getNodeID(), nodeStatus1, null, node1ReportForApp));
        ArrayList<LogAggregationReport> node2ReportForApp = new ArrayList<LogAggregationReport>();
        String messageForNode2_1 = "node2 logAggregation status updated at " + System.currentTimeMillis();
        LogAggregationReport report2 = LogAggregationReport.newInstance((ApplicationId)this.appId, (LogAggregationStatus)LogAggregationStatus.RUNNING, (String)messageForNode2_1);
        node2ReportForApp.add(report2);
        NodeStatus nodeStatus2 = NodeStatus.newInstance((NodeId)node2.getNodeID(), (int)0, new ArrayList(), null, (NodeHealthStatus)NodeHealthStatus.newInstance((boolean)true, null, (long)0L), null, null, null);
        node2.handle((Event)new RMNodeStatusEvent(node2.getNodeID(), nodeStatus2, null, node2ReportForApp));
        logAggregationStatus = rmApp.getLogAggregationReportsForApp();
        Assert.assertEquals((long)2L, (long)logAggregationStatus.size());
        Assert.assertTrue((boolean)logAggregationStatus.containsKey(nodeId1));
        Assert.assertTrue((boolean)logAggregationStatus.containsKey(nodeId2));
        for (Map.Entry report : logAggregationStatus.entrySet()) {
            if (((NodeId)report.getKey()).equals((Object)node1.getNodeID())) {
                Assert.assertEquals((Object)LogAggregationStatus.RUNNING, (Object)((LogAggregationReport)report.getValue()).getLogAggregationStatus());
                Assert.assertEquals((Object)messageForNode1_1, (Object)((LogAggregationReport)report.getValue()).getDiagnosticMessage());
                continue;
            }
            if (((NodeId)report.getKey()).equals((Object)node2.getNodeID())) {
                Assert.assertEquals((Object)LogAggregationStatus.RUNNING, (Object)((LogAggregationReport)report.getValue()).getLogAggregationStatus());
                Assert.assertEquals((Object)messageForNode2_1, (Object)((LogAggregationReport)report.getValue()).getDiagnosticMessage());
                continue;
            }
            Assert.fail((String)"should not contain log aggregation report for other nodes");
        }
        ArrayList<LogAggregationReport> node1ReportForApp2 = new ArrayList<LogAggregationReport>();
        String messageForNode1_2 = "node1 logAggregation status updated at " + System.currentTimeMillis();
        LogAggregationReport report1_2 = LogAggregationReport.newInstance((ApplicationId)this.appId, (LogAggregationStatus)LogAggregationStatus.RUNNING, (String)messageForNode1_2);
        node1ReportForApp2.add(report1_2);
        node1.handle((Event)new RMNodeStatusEvent(node1.getNodeID(), nodeStatus1, null, node1ReportForApp2));
        logAggregationStatus = rmApp.getLogAggregationReportsForApp();
        Assert.assertEquals((long)2L, (long)logAggregationStatus.size());
        Assert.assertTrue((boolean)logAggregationStatus.containsKey(nodeId1));
        Assert.assertTrue((boolean)logAggregationStatus.containsKey(nodeId2));
        for (Map.Entry report : logAggregationStatus.entrySet()) {
            if (((NodeId)report.getKey()).equals((Object)node1.getNodeID())) {
                Assert.assertEquals((Object)LogAggregationStatus.RUNNING, (Object)((LogAggregationReport)report.getValue()).getLogAggregationStatus());
                Assert.assertEquals((Object)(messageForNode1_1 + "\n" + messageForNode1_2), (Object)((LogAggregationReport)report.getValue()).getDiagnosticMessage());
                continue;
            }
            if (((NodeId)report.getKey()).equals((Object)node2.getNodeID())) {
                Assert.assertEquals((Object)LogAggregationStatus.RUNNING, (Object)((LogAggregationReport)report.getValue()).getLogAggregationStatus());
                Assert.assertEquals((Object)messageForNode2_1, (Object)((LogAggregationReport)report.getValue()).getDiagnosticMessage());
                continue;
            }
            Assert.fail((String)"should not contain log aggregation report for other nodes");
        }
        rmApp.handle((Event)new RMAppEvent(this.appId, RMAppEventType.KILL));
        rmApp.handle((Event)new RMAppEvent(this.appId, RMAppEventType.ATTEMPT_KILLED));
        rmApp.handle((Event)new RMAppEvent(this.appId, RMAppEventType.APP_UPDATE_SAVED));
        Assert.assertEquals((Object)RMAppState.KILLED, (Object)rmApp.getState());
        Thread.sleep(1500L);
        logAggregationStatus = rmApp.getLogAggregationReportsForApp();
        Assert.assertEquals((long)2L, (long)logAggregationStatus.size());
        Assert.assertTrue((boolean)logAggregationStatus.containsKey(nodeId1));
        Assert.assertTrue((boolean)logAggregationStatus.containsKey(nodeId2));
        for (Map.Entry report : logAggregationStatus.entrySet()) {
            Assert.assertEquals((Object)LogAggregationStatus.TIME_OUT, (Object)((LogAggregationReport)report.getValue()).getLogAggregationStatus());
        }
        ArrayList<LogAggregationReport> node1ReportForApp3 = new ArrayList<LogAggregationReport>();
        for (int i = 0; i < 10; ++i) {
            LogAggregationReport report1_3 = LogAggregationReport.newInstance((ApplicationId)this.appId, (LogAggregationStatus)LogAggregationStatus.RUNNING, (String)("test_message_" + i));
            node1ReportForApp3.add(report1_3);
        }
        node1ReportForApp3.add(LogAggregationReport.newInstance((ApplicationId)this.appId, (LogAggregationStatus)LogAggregationStatus.SUCCEEDED, (String)""));
        node1.handle((Event)new RMNodeStatusEvent(node1.getNodeID(), nodeStatus1, null, node1ReportForApp3));
        logAggregationStatus = rmApp.getLogAggregationReportsForApp();
        Assert.assertEquals((long)2L, (long)logAggregationStatus.size());
        Assert.assertTrue((boolean)logAggregationStatus.containsKey(nodeId1));
        Assert.assertTrue((boolean)logAggregationStatus.containsKey(nodeId2));
        for (Map.Entry report : logAggregationStatus.entrySet()) {
            if (((NodeId)report.getKey()).equals((Object)node1.getNodeID())) {
                Assert.assertEquals((Object)LogAggregationStatus.SUCCEEDED, (Object)((LogAggregationReport)report.getValue()).getLogAggregationStatus());
                StringBuilder builder = new StringBuilder();
                for (int i = 0; i < 9; ++i) {
                    builder.append("test_message_" + i);
                    builder.append("\n");
                }
                builder.append("test_message_9");
                Assert.assertEquals((Object)builder.toString(), (Object)((LogAggregationReport)report.getValue()).getDiagnosticMessage());
                continue;
            }
            if (((NodeId)report.getKey()).equals((Object)node2.getNodeID())) {
                Assert.assertEquals((Object)LogAggregationStatus.TIME_OUT, (Object)((LogAggregationReport)report.getValue()).getLogAggregationStatus());
                continue;
            }
            Assert.fail((String)"should not contain log aggregation report for other nodes");
        }
        ArrayList<LogAggregationReport> node2ReportForApp2 = new ArrayList<LogAggregationReport>();
        LogAggregationReport report2_2 = LogAggregationReport.newInstance((ApplicationId)this.appId, (LogAggregationStatus)LogAggregationStatus.RUNNING_WITH_FAILURE, (String)"Fail_Message");
        LogAggregationReport report2_3 = LogAggregationReport.newInstance((ApplicationId)this.appId, (LogAggregationStatus)LogAggregationStatus.FAILED, (String)"");
        node2ReportForApp2.add(report2_2);
        node2ReportForApp2.add(report2_3);
        node2.handle((Event)new RMNodeStatusEvent(node2.getNodeID(), nodeStatus2, null, node2ReportForApp2));
        Assert.assertEquals((Object)LogAggregationStatus.FAILED, (Object)rmApp.getLogAggregationStatusForAppReport());
        logAggregationStatus = rmApp.getLogAggregationReportsForApp();
        Assert.assertTrue((logAggregationStatus.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)logAggregationStatus.containsKey(node2.getNodeID()));
        Assert.assertTrue((!logAggregationStatus.containsKey(node1.getNodeID()) ? 1 : 0) != 0);
        Assert.assertEquals((Object)"Fail_Message", (Object)((RMAppImpl)rmApp).getLogAggregationFailureMessagesForNM(nodeId2));
    }

    @Test(timeout=10000L)
    public void testGetLogAggregationStatusForAppReport() throws IOException {
        YarnConfiguration conf = new YarnConfiguration();
        conf.setBoolean("yarn.log-aggregation-enable", false);
        RMAppImpl rmApp = (RMAppImpl)this.createRMApp((Configuration)conf);
        Assert.assertEquals((Object)LogAggregationStatus.DISABLED, (Object)rmApp.getLogAggregationStatusForAppReport());
        conf.setBoolean("yarn.log-aggregation-enable", true);
        rmApp = (RMAppImpl)this.createRMApp((Configuration)conf);
        Assert.assertEquals((Object)LogAggregationStatus.NOT_START, (Object)rmApp.getLogAggregationStatusForAppReport());
        NodeId nodeId1 = NodeId.newInstance((String)"localhost", (int)1111);
        NodeId nodeId2 = NodeId.newInstance((String)"localhost", (int)2222);
        NodeId nodeId3 = NodeId.newInstance((String)"localhost", (int)3333);
        NodeId nodeId4 = NodeId.newInstance((String)"localhost", (int)4444);
        rmApp.aggregateLogReport(nodeId1, LogAggregationReport.newInstance((ApplicationId)rmApp.getApplicationId(), (LogAggregationStatus)LogAggregationStatus.NOT_START, (String)""));
        rmApp.aggregateLogReport(nodeId2, LogAggregationReport.newInstance((ApplicationId)rmApp.getApplicationId(), (LogAggregationStatus)LogAggregationStatus.NOT_START, (String)""));
        rmApp.aggregateLogReport(nodeId3, LogAggregationReport.newInstance((ApplicationId)rmApp.getApplicationId(), (LogAggregationStatus)LogAggregationStatus.NOT_START, (String)""));
        rmApp.aggregateLogReport(nodeId4, LogAggregationReport.newInstance((ApplicationId)rmApp.getApplicationId(), (LogAggregationStatus)LogAggregationStatus.NOT_START, (String)""));
        Assert.assertEquals((Object)LogAggregationStatus.NOT_START, (Object)rmApp.getLogAggregationStatusForAppReport());
        rmApp.aggregateLogReport(nodeId1, LogAggregationReport.newInstance((ApplicationId)rmApp.getApplicationId(), (LogAggregationStatus)LogAggregationStatus.NOT_START, (String)""));
        rmApp.aggregateLogReport(nodeId2, LogAggregationReport.newInstance((ApplicationId)rmApp.getApplicationId(), (LogAggregationStatus)LogAggregationStatus.RUNNING, (String)""));
        rmApp.aggregateLogReport(nodeId3, LogAggregationReport.newInstance((ApplicationId)rmApp.getApplicationId(), (LogAggregationStatus)LogAggregationStatus.SUCCEEDED, (String)""));
        rmApp.aggregateLogReport(nodeId4, LogAggregationReport.newInstance((ApplicationId)rmApp.getApplicationId(), (LogAggregationStatus)LogAggregationStatus.SUCCEEDED, (String)""));
        Assert.assertEquals((Object)LogAggregationStatus.RUNNING, (Object)rmApp.getLogAggregationStatusForAppReport());
        rmApp.handle(new RMAppEvent(rmApp.getApplicationId(), RMAppEventType.KILL));
        Assert.assertTrue((boolean)RMAppImpl.isAppInFinalState((RMApp)rmApp));
        rmApp.aggregateLogReport(nodeId1, LogAggregationReport.newInstance((ApplicationId)rmApp.getApplicationId(), (LogAggregationStatus)LogAggregationStatus.SUCCEEDED, (String)""));
        rmApp.aggregateLogReport(nodeId2, LogAggregationReport.newInstance((ApplicationId)rmApp.getApplicationId(), (LogAggregationStatus)LogAggregationStatus.TIME_OUT, (String)""));
        rmApp.aggregateLogReport(nodeId3, LogAggregationReport.newInstance((ApplicationId)rmApp.getApplicationId(), (LogAggregationStatus)LogAggregationStatus.SUCCEEDED, (String)""));
        rmApp.aggregateLogReport(nodeId4, LogAggregationReport.newInstance((ApplicationId)rmApp.getApplicationId(), (LogAggregationStatus)LogAggregationStatus.SUCCEEDED, (String)""));
        Assert.assertEquals((Object)LogAggregationStatus.TIME_OUT, (Object)rmApp.getLogAggregationStatusForAppReport());
        rmApp = (RMAppImpl)this.createRMApp((Configuration)conf);
        rmApp.handle(new RMAppEvent(rmApp.getApplicationId(), RMAppEventType.KILL));
        rmApp.aggregateLogReport(nodeId1, LogAggregationReport.newInstance((ApplicationId)rmApp.getApplicationId(), (LogAggregationStatus)LogAggregationStatus.SUCCEEDED, (String)""));
        rmApp.aggregateLogReport(nodeId2, LogAggregationReport.newInstance((ApplicationId)rmApp.getApplicationId(), (LogAggregationStatus)LogAggregationStatus.SUCCEEDED, (String)""));
        rmApp.aggregateLogReport(nodeId3, LogAggregationReport.newInstance((ApplicationId)rmApp.getApplicationId(), (LogAggregationStatus)LogAggregationStatus.SUCCEEDED, (String)""));
        rmApp.aggregateLogReport(nodeId4, LogAggregationReport.newInstance((ApplicationId)rmApp.getApplicationId(), (LogAggregationStatus)LogAggregationStatus.SUCCEEDED, (String)""));
        Assert.assertEquals((Object)LogAggregationStatus.SUCCEEDED, (Object)rmApp.getLogAggregationStatusForAppReport());
        rmApp = (RMAppImpl)this.createRMApp((Configuration)conf);
        rmApp.aggregateLogReport(nodeId1, LogAggregationReport.newInstance((ApplicationId)rmApp.getApplicationId(), (LogAggregationStatus)LogAggregationStatus.NOT_START, (String)""));
        rmApp.aggregateLogReport(nodeId2, LogAggregationReport.newInstance((ApplicationId)rmApp.getApplicationId(), (LogAggregationStatus)LogAggregationStatus.RUNNING, (String)""));
        rmApp.aggregateLogReport(nodeId3, LogAggregationReport.newInstance((ApplicationId)rmApp.getApplicationId(), (LogAggregationStatus)LogAggregationStatus.NOT_START, (String)""));
        rmApp.aggregateLogReport(nodeId4, LogAggregationReport.newInstance((ApplicationId)rmApp.getApplicationId(), (LogAggregationStatus)LogAggregationStatus.NOT_START, (String)""));
        Assert.assertEquals((Object)LogAggregationStatus.RUNNING, (Object)rmApp.getLogAggregationStatusForAppReport());
        rmApp.aggregateLogReport(nodeId1, LogAggregationReport.newInstance((ApplicationId)rmApp.getApplicationId(), (LogAggregationStatus)LogAggregationStatus.NOT_START, (String)""));
        rmApp.aggregateLogReport(nodeId2, LogAggregationReport.newInstance((ApplicationId)rmApp.getApplicationId(), (LogAggregationStatus)LogAggregationStatus.RUNNING, (String)""));
        rmApp.aggregateLogReport(nodeId3, LogAggregationReport.newInstance((ApplicationId)rmApp.getApplicationId(), (LogAggregationStatus)LogAggregationStatus.NOT_START, (String)""));
        rmApp.aggregateLogReport(nodeId4, LogAggregationReport.newInstance((ApplicationId)rmApp.getApplicationId(), (LogAggregationStatus)LogAggregationStatus.RUNNING_WITH_FAILURE, (String)""));
        Assert.assertEquals((Object)LogAggregationStatus.RUNNING_WITH_FAILURE, (Object)rmApp.getLogAggregationStatusForAppReport());
        rmApp.aggregateLogReport(nodeId1, LogAggregationReport.newInstance((ApplicationId)rmApp.getApplicationId(), (LogAggregationStatus)LogAggregationStatus.NOT_START, (String)""));
        rmApp.aggregateLogReport(nodeId2, LogAggregationReport.newInstance((ApplicationId)rmApp.getApplicationId(), (LogAggregationStatus)LogAggregationStatus.RUNNING, (String)""));
        rmApp.aggregateLogReport(nodeId3, LogAggregationReport.newInstance((ApplicationId)rmApp.getApplicationId(), (LogAggregationStatus)LogAggregationStatus.NOT_START, (String)""));
        rmApp.aggregateLogReport(nodeId4, LogAggregationReport.newInstance((ApplicationId)rmApp.getApplicationId(), (LogAggregationStatus)LogAggregationStatus.RUNNING, (String)""));
        Assert.assertEquals((Object)LogAggregationStatus.RUNNING_WITH_FAILURE, (Object)rmApp.getLogAggregationStatusForAppReport());
        rmApp.handle(new RMAppEvent(rmApp.getApplicationId(), RMAppEventType.KILL));
        Assert.assertTrue((boolean)RMAppImpl.isAppInFinalState((RMApp)rmApp));
        rmApp.aggregateLogReport(nodeId1, LogAggregationReport.newInstance((ApplicationId)rmApp.getApplicationId(), (LogAggregationStatus)LogAggregationStatus.SUCCEEDED, (String)""));
        rmApp.aggregateLogReport(nodeId2, LogAggregationReport.newInstance((ApplicationId)rmApp.getApplicationId(), (LogAggregationStatus)LogAggregationStatus.TIME_OUT, (String)""));
        rmApp.aggregateLogReport(nodeId3, LogAggregationReport.newInstance((ApplicationId)rmApp.getApplicationId(), (LogAggregationStatus)LogAggregationStatus.FAILED, (String)""));
        rmApp.aggregateLogReport(nodeId4, LogAggregationReport.newInstance((ApplicationId)rmApp.getApplicationId(), (LogAggregationStatus)LogAggregationStatus.FAILED, (String)""));
        Assert.assertEquals((Object)LogAggregationStatus.FAILED, (Object)rmApp.getLogAggregationStatusForAppReport());
    }

    private RMApp createRMApp(Configuration conf) throws IOException {
        ApplicationSubmissionContext submissionContext = ApplicationSubmissionContext.newInstance((ApplicationId)this.appId, (String)"test", (String)"default", (Priority)Priority.newInstance((int)0), null, (boolean)false, (boolean)true, (int)2, (Resource)Resource.newInstance((int)10, (int)2), (String)"test");
        return new RMAppImpl(this.appId, this.rmContext, conf, "test", "test", "default", submissionContext, this.scheduler, this.rmContext.getApplicationMasterService(), System.currentTimeMillis(), "test", null, null);
    }

    private final class TestSchedulerEventDispatcher
    implements EventHandler<SchedulerEvent> {
        private TestSchedulerEventDispatcher() {
        }

        public void handle(SchedulerEvent event) {
            TestRMAppLogAggregationStatus.this.scheduler.handle((Event)event);
        }
    }
}

