/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.quota;

import io.hops.StorageConnector;
import io.hops.exception.StorageException;
import io.hops.exception.StorageInitializtionException;
import io.hops.metadata.yarn.dal.RMNodeDataAccess;
import io.hops.metadata.yarn.dal.quota.ContainersLogsDataAccess;
import io.hops.metadata.yarn.dal.quota.ProjectQuotaDataAccess;
import io.hops.metadata.yarn.dal.quota.ProjectsDailyCostDataAccess;
import io.hops.metadata.yarn.dal.rmstatestore.ApplicationStateDataAccess;
import io.hops.metadata.yarn.dal.util.YARNOperationType;
import io.hops.metadata.yarn.entity.RMNode;
import io.hops.metadata.yarn.entity.quota.ContainerLog;
import io.hops.metadata.yarn.entity.quota.ProjectDailyCost;
import io.hops.metadata.yarn.entity.quota.ProjectQuota;
import io.hops.metadata.yarn.entity.rmstatestore.ApplicationState;
import io.hops.transaction.handler.LightWeightRequestHandler;
import io.hops.transaction.handler.RequestHandler;
import io.hops.util.DBUtility;
import io.hops.util.RMStorageFactory;
import io.hops.util.YarnAPIStorageFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.quota.QuotaService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestQuotaService {
    private static final Log LOG = LogFactory.getLog(TestQuotaService.class);
    private StorageConnector connector = null;

    @Before
    public void setup() throws IOException {
        YarnConfiguration conf = new YarnConfiguration();
        YarnAPIStorageFactory.setConfiguration((Configuration)conf);
        RMStorageFactory.setConfiguration((Configuration)conf);
        DBUtility.InitializeDB();
    }

    public void PrepareScenario() throws StorageException, IOException {
        LOG.info((Object)"--- START: TestContainerUsage ---");
        LOG.info((Object)"--- Checking ContainerStatus ---");
        try {
            final ArrayList<RMNode> hopRMNode = new ArrayList<RMNode>();
            hopRMNode.add(new RMNode("Andromeda3:51028"));
            final ApplicationState hopApplicationState = new ApplicationState("application_1450009406746_0001", new byte[0], "Project07__rizvi", "DistributedShell", "FINISHING");
            final ArrayList<ContainerLog> hopContainerLog = new ArrayList<ContainerLog>();
            hopContainerLog.add(new ContainerLog("container_1450009406746_0001_01_000001", 10L, 11L, 0, 0.1f, 1, 1024L, 0));
            hopContainerLog.add(new ContainerLog("container_1450009406746_0001_02_000001", 10L, 11L, -100, 0.1f, 1, 1024L, 0));
            hopContainerLog.add(new ContainerLog("container_1450009406746_0001_03_000001", 10L, 110L, -201, 0.1f, 1, 1024L, 0));
            final ArrayList<ProjectQuota> hopProjectQuota = new ArrayList<ProjectQuota>();
            hopProjectQuota.add(new ProjectQuota("Project07", 50.0f, 0.0f));
            LightWeightRequestHandler bomb = new LightWeightRequestHandler((RequestHandler.OperationType)YARNOperationType.TEST){

                public Object performTask() throws IOException {
                    connector.beginTransaction();
                    connector.writeLock();
                    RMNodeDataAccess _rmDA = (RMNodeDataAccess)RMStorageFactory.getDataAccess(RMNodeDataAccess.class);
                    _rmDA.addAll(hopRMNode);
                    ApplicationStateDataAccess _appState = (ApplicationStateDataAccess)RMStorageFactory.getDataAccess(ApplicationStateDataAccess.class);
                    _appState.add((Object)hopApplicationState);
                    ContainersLogsDataAccess _clDA = (ContainersLogsDataAccess)RMStorageFactory.getDataAccess(ContainersLogsDataAccess.class);
                    _clDA.addAll((Collection)hopContainerLog);
                    ProjectQuotaDataAccess _pqDA = (ProjectQuotaDataAccess)RMStorageFactory.getDataAccess(ProjectQuotaDataAccess.class);
                    _pqDA.addAll((Collection)hopProjectQuota);
                    connector.commit();
                    return null;
                }
            };
            bomb.handle();
        }
        catch (StorageException | StorageInitializtionException throwable) {
            // empty catch block
        }
    }

    public void CheckProject(float credits, float used) throws IOException {
        LightWeightRequestHandler bomb = new LightWeightRequestHandler((RequestHandler.OperationType)YARNOperationType.TEST){

            public Object performTask() throws IOException {
                connector.beginTransaction();
                connector.writeLock();
                ProjectQuotaDataAccess _pqDA = (ProjectQuotaDataAccess)RMStorageFactory.getDataAccess(ProjectQuotaDataAccess.class);
                Map _hopProjectQuotaList = _pqDA.getAll();
                connector.commit();
                return _hopProjectQuotaList;
            }
        };
        Map hopProjectQuotaList = (Map)bomb.handle();
        for (Map.Entry _ycl : hopProjectQuotaList.entrySet()) {
            Assert.assertTrue((boolean)((ProjectQuota)_ycl.getValue()).getProjectid().equalsIgnoreCase("Project07"));
            Assert.assertEquals((float)credits, (float)((ProjectQuota)_ycl.getValue()).getRemainingQuota(), (float)0.0f);
            Assert.assertEquals((float)used, (float)((ProjectQuota)_ycl.getValue()).getTotalUsedQuota(), (float)0.0f);
        }
    }

    public void CheckProjectDailyCost(float used) throws IOException {
        LightWeightRequestHandler bomb = new LightWeightRequestHandler((RequestHandler.OperationType)YARNOperationType.TEST){

            public Object performTask() throws IOException {
                connector.beginTransaction();
                connector.writeLock();
                ProjectsDailyCostDataAccess _pdcDA = (ProjectsDailyCostDataAccess)RMStorageFactory.getDataAccess(ProjectsDailyCostDataAccess.class);
                Map hopYarnProjectsDailyCostList = _pdcDA.getAll();
                connector.commit();
                return hopYarnProjectsDailyCostList;
            }
        };
        Map hopYarnProjectsDailyCostList = (Map)bomb.handle();
        long _miliSec = System.currentTimeMillis();
        long _day = TimeUnit.DAYS.convert(_miliSec, TimeUnit.MILLISECONDS);
        for (Map.Entry _ypdc : hopYarnProjectsDailyCostList.entrySet()) {
            Assert.assertTrue((boolean)((ProjectDailyCost)_ypdc.getValue()).getProjectName().equalsIgnoreCase("Project07"));
            Assert.assertTrue((boolean)((ProjectDailyCost)_ypdc.getValue()).getProjectUser().equalsIgnoreCase("rizvi"));
            Assert.assertEquals((long)_day, (long)((ProjectDailyCost)_ypdc.getValue()).getDay());
            Assert.assertEquals((float)used, (float)((ProjectDailyCost)_ypdc.getValue()).getCreditsUsed(), (float)0.0f);
        }
    }

    @Test(timeout=6000L)
    public void TestRecover() throws IOException, Exception {
        this.PrepareScenario();
        QuotaService qs = new QuotaService();
        YarnConfiguration conf = new YarnConfiguration();
        conf.setInt("yarn.resourcemanager.quota.minTicksCharge", 100);
        qs.init((Configuration)conf);
        qs.serviceStart();
        Thread.currentThread();
        Thread.sleep(1000L);
        qs.serviceStop();
        this.CheckProject(20.0f, 30.0f);
        this.CheckProjectDailyCost(30.0f);
    }

    @Test(timeout=120000L)
    public void TestStream() throws Exception {
        int j;
        ArrayList<ContainerLog> logs;
        int i;
        int initialCredits = 50;
        int totalCost = 0;
        final ApplicationState hopApplicationState = new ApplicationState("application_1450009406746_0001", new byte[0], "Project07__rizvi", "DistributedShell", "FINISHING");
        final ArrayList<ProjectQuota> hopProjectQuota = new ArrayList<ProjectQuota>();
        hopProjectQuota.add(new ProjectQuota("Project07", (float)initialCredits, 0.0f));
        LightWeightRequestHandler prepareHandler = new LightWeightRequestHandler((RequestHandler.OperationType)YARNOperationType.TEST){

            public Object performTask() throws IOException {
                connector.beginTransaction();
                connector.writeLock();
                ApplicationStateDataAccess _appState = (ApplicationStateDataAccess)RMStorageFactory.getDataAccess(ApplicationStateDataAccess.class);
                _appState.add((Object)hopApplicationState);
                ProjectQuotaDataAccess _pqDA = (ProjectQuotaDataAccess)RMStorageFactory.getDataAccess(ProjectQuotaDataAccess.class);
                _pqDA.addAll((Collection)hopProjectQuota);
                connector.commit();
                return null;
            }
        };
        prepareHandler.handle();
        QuotaService qs = new QuotaService();
        YarnConfiguration conf = new YarnConfiguration();
        conf.setInt("yarn.resourcemanager.quota.minTicksCharge", 10);
        qs.init((Configuration)conf);
        qs.serviceStart();
        for (i = 0; i < 10; ++i) {
            logs = new ArrayList<ContainerLog>();
            for (j = 0; j < i; ++j) {
                logs.add(new ContainerLog("container_1450009406746_0001_0" + i + "_00000" + j, (long)i, (long)i, -201, 0.1f, 1, 1024L, 0));
            }
            qs.insertEvents(logs);
        }
        Thread.sleep(1000L);
        for (i = 0; i < 3; ++i) {
            logs = new ArrayList();
            for (j = 0; j < i; ++j) {
                logs.add(new ContainerLog("container_1450009406746_0001_0" + i + "_00000" + j, (long)i, (long)(i + 5), 0, 0.1f, 1, 1024L, 0));
                ++totalCost;
            }
            qs.insertEvents(logs);
        }
        Thread.sleep(1000L);
        for (i = 3; i < 10; ++i) {
            logs = new ArrayList();
            for (j = 0; j < i; ++j) {
                logs.add(new ContainerLog("container_1450009406746_0001_0" + i + "_00000" + j, (long)i, (long)(i + 10), -201, 0.1f, 1, 1024L, 0));
                ++totalCost;
            }
            qs.insertEvents(logs);
        }
        Thread.sleep(1000L);
        for (i = 3; i < 6; ++i) {
            logs = new ArrayList();
            for (j = 0; j < i; ++j) {
                logs.add(new ContainerLog("container_1450009406746_0001_0" + i + "_00000" + j, (long)i, (long)(i + 15), 0, 0.1f, 1, 1024L, 0));
                ++totalCost;
            }
            qs.insertEvents(logs);
        }
        Thread.sleep(1000L);
        for (i = 6; i < 9; ++i) {
            logs = new ArrayList();
            for (j = 0; j < i; ++j) {
                logs.add(new ContainerLog("container_1450009406746_0001_0" + i + "_00000" + j, (long)i, (long)(i + 16), -102, 0.1f, 1, 1024L, 0));
                ++totalCost;
            }
            qs.insertEvents(logs);
        }
        Thread.sleep(2000L);
        this.CheckProject(initialCredits - totalCost, totalCost);
        this.CheckProjectDailyCost(totalCost);
    }
}

