/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.reservation;

import java.io.IOException;
import java.util.TreeMap;
import org.apache.hadoop.yarn.api.records.ReservationDefinition;
import org.apache.hadoop.yarn.api.records.ReservationRequest;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.CapacityOverTimePolicy;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.InMemoryPlan;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.InMemoryReservationAllocation;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationAllocation;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationInterval;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationSchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationSystemTestUtil;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationSystemUtil;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.SharingPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.exceptions.PlanningException;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.exceptions.PlanningQuotaException;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.exceptions.ResourceOverCommitException;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.planning.ReservationAgent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.util.resource.DefaultResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestCapacityOverTimePolicy {
    long timeWindow;
    long step;
    float avgConstraint;
    float instConstraint;
    long initTime;
    InMemoryPlan plan;
    ReservationAgent mAgent;
    Resource minAlloc;
    ResourceCalculator res;
    Resource maxAlloc;
    int totCont = 1000000;

    @Before
    public void setup() throws Exception {
        this.timeWindow = 86400000L;
        this.step = 1000L;
        this.avgConstraint = 25.0f;
        this.instConstraint = 70.0f;
        this.initTime = System.currentTimeMillis();
        this.minAlloc = Resource.newInstance((int)1024, (int)1);
        this.res = new DefaultResourceCalculator();
        this.maxAlloc = Resource.newInstance((int)8192, (int)8);
        this.mAgent = (ReservationAgent)Mockito.mock(ReservationAgent.class);
        QueueMetrics rootQueueMetrics = (QueueMetrics)Mockito.mock(QueueMetrics.class);
        String reservationQ = ReservationSystemTestUtil.getFullReservationQueueName();
        Resource clusterResource = ReservationSystemTestUtil.calculateClusterResource(this.totCont);
        ReservationSchedulerConfiguration conf = ReservationSystemTestUtil.createConf(reservationQ, this.timeWindow, this.instConstraint, this.avgConstraint);
        CapacityOverTimePolicy policy = new CapacityOverTimePolicy();
        policy.init(reservationQ, conf);
        RMContext context = ReservationSystemTestUtil.createMockRMContext();
        this.plan = new InMemoryPlan(rootQueueMetrics, (SharingPolicy)policy, this.mAgent, clusterResource, this.step, this.res, this.minAlloc, this.maxAlloc, "dedicated", null, true, context);
    }

    public int[] generateData(int length, int val) {
        int[] data = new int[length];
        for (int i = 0; i < length; ++i) {
            data[i] = val;
        }
        return data;
    }

    @Test
    public void testSimplePass() throws IOException, PlanningException {
        int[] f = this.generateData(3600, (int)Math.ceil(0.2 * (double)this.totCont));
        ReservationDefinition rDef = ReservationSystemTestUtil.createSimpleReservationDefinition(this.initTime, this.initTime + (long)f.length + 1L, f.length);
        Assert.assertTrue((String)this.plan.toString(), (boolean)this.plan.addReservation((ReservationAllocation)new InMemoryReservationAllocation(ReservationSystemTestUtil.getNewReservationId(), rDef, "u1", "dedicated", this.initTime, this.initTime + (long)f.length, ReservationSystemTestUtil.generateAllocation(this.initTime, this.step, f), this.res, this.minAlloc), false));
    }

    @Test
    public void testSimplePass2() throws IOException, PlanningException {
        int[] f = this.generateData(3600, (int)Math.ceil(0.69 * (double)this.totCont));
        ReservationDefinition rDef = ReservationSystemTestUtil.createSimpleReservationDefinition(this.initTime, this.initTime + (long)f.length + 1L, f.length);
        Assert.assertTrue((String)this.plan.toString(), (boolean)this.plan.addReservation((ReservationAllocation)new InMemoryReservationAllocation(ReservationSystemTestUtil.getNewReservationId(), rDef, "u1", "dedicated", this.initTime, this.initTime + (long)f.length, ReservationSystemTestUtil.generateAllocation(this.initTime, this.step, f), this.res, this.minAlloc), false));
    }

    @Test
    public void testMultiTenantPass() throws IOException, PlanningException {
        int[] f = this.generateData(3600, (int)Math.ceil(0.25 * (double)this.totCont));
        ReservationDefinition rDef = ReservationSystemTestUtil.createSimpleReservationDefinition(this.initTime, this.initTime + (long)f.length + 1L, f.length);
        for (int i = 0; i < 4; ++i) {
            Assert.assertTrue((String)this.plan.toString(), (boolean)this.plan.addReservation((ReservationAllocation)new InMemoryReservationAllocation(ReservationSystemTestUtil.getNewReservationId(), rDef, "u" + i, "dedicated", this.initTime, this.initTime + (long)f.length, ReservationSystemTestUtil.generateAllocation(this.initTime, this.step, f), this.res, this.minAlloc), false));
        }
    }

    @Test(expected=ResourceOverCommitException.class)
    public void testMultiTenantFail() throws IOException, PlanningException {
        int[] f = this.generateData(3600, (int)Math.ceil(0.25 * (double)this.totCont));
        ReservationDefinition rDef = ReservationSystemTestUtil.createSimpleReservationDefinition(this.initTime, this.initTime + (long)f.length + 1L, f.length);
        for (int i = 0; i < 5; ++i) {
            Assert.assertTrue((String)this.plan.toString(), (boolean)this.plan.addReservation((ReservationAllocation)new InMemoryReservationAllocation(ReservationSystemTestUtil.getNewReservationId(), rDef, "u" + i, "dedicated", this.initTime, this.initTime + (long)f.length, ReservationSystemTestUtil.generateAllocation(this.initTime, this.step, f), this.res, this.minAlloc), false));
        }
    }

    @Test(expected=PlanningQuotaException.class)
    public void testInstFail() throws IOException, PlanningException {
        int[] f = this.generateData(3600, (int)Math.ceil(0.71 * (double)this.totCont));
        ReservationDefinition rDef = ReservationSystemTestUtil.createSimpleReservationDefinition(this.initTime, this.initTime + (long)f.length + 1L, f.length);
        Assert.assertTrue((String)this.plan.toString(), (boolean)this.plan.addReservation((ReservationAllocation)new InMemoryReservationAllocation(ReservationSystemTestUtil.getNewReservationId(), rDef, "u1", "dedicated", this.initTime, this.initTime + (long)f.length, ReservationSystemTestUtil.generateAllocation(this.initTime, this.step, f), this.res, this.minAlloc), false));
        Assert.fail((String)"should not have accepted this");
    }

    @Test
    public void testInstFailBySum() throws IOException, PlanningException {
        int[] f = this.generateData(3600, (int)Math.ceil(0.3 * (double)this.totCont));
        ReservationDefinition rDef = ReservationSystemTestUtil.createSimpleReservationDefinition(this.initTime, this.initTime + (long)f.length + 1L, f.length);
        Assert.assertTrue((String)this.plan.toString(), (boolean)this.plan.addReservation((ReservationAllocation)new InMemoryReservationAllocation(ReservationSystemTestUtil.getNewReservationId(), rDef, "u1", "dedicated", this.initTime, this.initTime + (long)f.length, ReservationSystemTestUtil.generateAllocation(this.initTime, this.step, f), this.res, this.minAlloc), false));
        Assert.assertTrue((String)this.plan.toString(), (boolean)this.plan.addReservation((ReservationAllocation)new InMemoryReservationAllocation(ReservationSystemTestUtil.getNewReservationId(), rDef, "u1", "dedicated", this.initTime, this.initTime + (long)f.length, ReservationSystemTestUtil.generateAllocation(this.initTime, this.step, f), this.res, this.minAlloc), false));
        try {
            Assert.assertTrue((String)this.plan.toString(), (boolean)this.plan.addReservation((ReservationAllocation)new InMemoryReservationAllocation(ReservationSystemTestUtil.getNewReservationId(), rDef, "u1", "dedicated", this.initTime, this.initTime + (long)f.length, ReservationSystemTestUtil.generateAllocation(this.initTime, this.step, f), this.res, this.minAlloc), false));
            Assert.fail();
        }
        catch (PlanningQuotaException planningQuotaException) {
            // empty catch block
        }
    }

    @Test(expected=PlanningQuotaException.class)
    public void testFailAvg() throws IOException, PlanningException {
        TreeMap<ReservationInterval, Resource> req = new TreeMap<ReservationInterval, Resource>();
        long win = this.timeWindow / 2L + 100L;
        int cont = (int)Math.ceil(0.5 * (double)this.totCont);
        req.put(new ReservationInterval(this.initTime, this.initTime + win), ReservationSystemUtil.toResource((ReservationRequest)ReservationRequest.newInstance((Resource)Resource.newInstance((int)1024, (int)1), (int)cont)));
        ReservationDefinition rDef = ReservationSystemTestUtil.createSimpleReservationDefinition(this.initTime, this.initTime + win, win);
        Assert.assertTrue((String)this.plan.toString(), (boolean)this.plan.addReservation((ReservationAllocation)new InMemoryReservationAllocation(ReservationSystemTestUtil.getNewReservationId(), rDef, "u1", "dedicated", this.initTime, this.initTime + win, req, this.res, this.minAlloc), false));
    }

    @Test
    public void testFailAvgBySum() throws IOException, PlanningException {
        TreeMap<ReservationInterval, Resource> req = new TreeMap<ReservationInterval, Resource>();
        long win = 21600001L;
        int cont = (int)Math.ceil(0.5 * (double)this.totCont);
        req.put(new ReservationInterval(this.initTime, this.initTime + win), ReservationSystemUtil.toResource((ReservationRequest)ReservationRequest.newInstance((Resource)Resource.newInstance((int)1024, (int)1), (int)cont)));
        ReservationDefinition rDef = ReservationSystemTestUtil.createSimpleReservationDefinition(this.initTime, this.initTime + win, win);
        Assert.assertTrue((String)this.plan.toString(), (boolean)this.plan.addReservation((ReservationAllocation)new InMemoryReservationAllocation(ReservationSystemTestUtil.getNewReservationId(), rDef, "u1", "dedicated", this.initTime, this.initTime + win, req, this.res, this.minAlloc), false));
        try {
            Assert.assertTrue((String)this.plan.toString(), (boolean)this.plan.addReservation((ReservationAllocation)new InMemoryReservationAllocation(ReservationSystemTestUtil.getNewReservationId(), null, "u1", "dedicated", this.initTime, this.initTime + win, req, this.res, this.minAlloc), false));
            Assert.fail((String)"should not have accepted this");
        }
        catch (PlanningQuotaException planningQuotaException) {
            // empty catch block
        }
    }
}

