/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.reservation;

import java.io.File;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ReservationId;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.AbstractSchedulerPlanFollower;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.FairSchedulerPlanFollower;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationSchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationSystemTestUtil;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.TestSchedulerPlanFollowerBase;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.exceptions.PlanningException;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.planning.ReservationAgent;
import org.apache.hadoop.yarn.server.resourcemanager.resource.ResourceType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Queue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.TestUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AllocationConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSLeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairSchedulerTestBase;
import org.apache.hadoop.yarn.server.security.ApplicationACLsManager;
import org.apache.hadoop.yarn.util.Clock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class TestFairSchedulerPlanFollower
extends TestSchedulerPlanFollowerBase {
    private static final String ALLOC_FILE = new File(FairSchedulerTestBase.TEST_DIR, TestSchedulerPlanFollowerBase.class.getName() + ".xml").getAbsolutePath();
    private RMContext rmContext;
    private RMContext spyRMContext;
    private FairScheduler fs;
    private Configuration conf;
    private FairSchedulerTestBase testHelper = new FairSchedulerTestBase();
    @Rule
    public TestName name = new TestName();

    protected Configuration createConfiguration() {
        Configuration conf = this.testHelper.createConfiguration();
        conf.setClass("yarn.resourcemanager.scheduler.class", FairScheduler.class, ResourceScheduler.class);
        conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        return conf;
    }

    @Before
    public void setUp() throws Exception {
        this.conf = this.createConfiguration();
        ReservationSystemTestUtil.setupFSAllocationFile(ALLOC_FILE);
        this.rmContext = TestUtils.getMockRMContext();
        this.spyRMContext = (RMContext)Mockito.spy((Object)this.rmContext);
        this.fs = ReservationSystemTestUtil.setupFairScheduler(this.spyRMContext, this.conf, 125);
        this.scheduler = this.fs;
        ConcurrentMap spyApps = (ConcurrentMap)Mockito.spy(new ConcurrentHashMap());
        RMApp rmApp = (RMApp)Mockito.mock(RMApp.class);
        Mockito.when((Object)rmApp.getRMAppAttempt((ApplicationAttemptId)Matchers.any())).thenReturn(null);
        ((ConcurrentMap)Mockito.doReturn((Object)rmApp).when((Object)spyApps)).get((ApplicationId)Matchers.any());
        Mockito.when((Object)this.spyRMContext.getRMApps()).thenReturn((Object)spyApps);
        ReservationSystemTestUtil.setupFSAllocationFile(ALLOC_FILE);
        this.setupPlanFollower();
    }

    private void setupPlanFollower() throws Exception {
        this.mClock = (Clock)Mockito.mock(Clock.class);
        this.mAgent = (ReservationAgent)Mockito.mock(ReservationAgent.class);
        String reservationQ = ReservationSystemTestUtil.getFullReservationQueueName();
        AllocationConfiguration allocConf = this.fs.getAllocationConfiguration();
        allocConf.setReservationWindow(20L);
        allocConf.setAverageCapacity(20);
        this.policy.init(reservationQ, (ReservationSchedulerConfiguration)allocConf);
    }

    @Ignore
    @Test
    public void testWithMoveOnExpiry() throws PlanningException, InterruptedException, AccessControlException {
        this.testPlanFollower(true);
    }

    @Ignore
    @Test
    public void testWithKillOnExpiry() throws PlanningException, InterruptedException, AccessControlException {
        this.testPlanFollower(false);
    }

    @Override
    protected void verifyCapacity(Queue defQ) {
        Assert.assertTrue(((double)((FSQueue)defQ).getWeights().getWeight(ResourceType.MEMORY) > 0.9 ? 1 : 0) != 0);
    }

    @Override
    protected Queue getDefaultQueue() {
        return this.getReservationQueue("dedicated-default");
    }

    @Override
    protected int getNumberOfApplications(Queue queue) {
        int numberOfApplications = this.fs.getAppsInQueue(queue.getQueueName()).size();
        return numberOfApplications;
    }

    @Override
    protected AbstractSchedulerPlanFollower createPlanFollower() {
        FairSchedulerPlanFollower planFollower = new FairSchedulerPlanFollower();
        planFollower.init(this.mClock, this.scheduler, Collections.singletonList(this.plan));
        return planFollower;
    }

    @Override
    protected void assertReservationQueueExists(ReservationId r) {
        Queue q = this.getReservationQueue(r.toString());
        Assert.assertNotNull((Object)q);
    }

    @Override
    protected void assertReservationQueueExists(ReservationId r, double expectedCapacity, double expectedMaxCapacity) {
        FSLeafQueue q = this.fs.getQueueManager().getLeafQueue(this.plan.getQueueName() + "." + r, false);
        Assert.assertNotNull((Object)q);
        Assert.assertEquals((double)expectedCapacity, (double)q.getWeights().getWeight(ResourceType.MEMORY), (double)0.01);
    }

    @Override
    protected void assertReservationQueueDoesNotExist(ReservationId r) {
        Queue q = this.getReservationQueue(r.toString());
        Assert.assertNull((Object)q);
    }

    @Override
    protected Queue getReservationQueue(String r) {
        return this.fs.getQueueManager().getLeafQueue(this.plan.getQueueName() + "." + r, false);
    }

    public static ApplicationACLsManager mockAppACLsManager() {
        Configuration conf = new Configuration();
        return new ApplicationACLsManager(conf);
    }

    @After
    public void tearDown() throws Exception {
        if (this.scheduler != null) {
            this.fs.stop();
        }
    }
}

