/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler;

import java.util.ArrayList;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.RMContextImpl;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ActiveUsersManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AppSchedulingInfo;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.NodeType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Queue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceUsage;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSLeafQueue;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestAppSchedulingInfo {
    @Test
    public void testBacklistChanged() {
        ApplicationId appIdImpl = ApplicationId.newInstance((long)0L, (int)1);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appIdImpl, (int)1);
        FSLeafQueue queue = (FSLeafQueue)Mockito.mock(FSLeafQueue.class);
        ((FSLeafQueue)Mockito.doReturn((Object)"test").when((Object)queue)).getQueueName();
        AppSchedulingInfo appSchedulingInfo = new AppSchedulingInfo(appAttemptId, "test", (Queue)queue, null, 0L, new ResourceUsage(), (RMContext)new RMContextImpl());
        appSchedulingInfo.updatePlacesBlacklistedByApp(new ArrayList(), new ArrayList());
        Assert.assertFalse((boolean)appSchedulingInfo.getAndResetBlacklistChanged());
        ArrayList<String> blacklistAdditions = new ArrayList<String>();
        blacklistAdditions.add("node1");
        blacklistAdditions.add("node2");
        appSchedulingInfo.updatePlacesBlacklistedByApp(blacklistAdditions, new ArrayList());
        Assert.assertTrue((boolean)appSchedulingInfo.getAndResetBlacklistChanged());
        blacklistAdditions.clear();
        blacklistAdditions.add("node1");
        appSchedulingInfo.updatePlacesBlacklistedByApp(blacklistAdditions, new ArrayList());
        Assert.assertFalse((boolean)appSchedulingInfo.getAndResetBlacklistChanged());
        ArrayList<String> blacklistRemovals = new ArrayList<String>();
        blacklistRemovals.add("node1");
        appSchedulingInfo.updatePlacesBlacklistedByApp(new ArrayList(), blacklistRemovals);
        appSchedulingInfo.updatePlacesBlacklistedByApp(new ArrayList(), blacklistRemovals);
        Assert.assertTrue((boolean)appSchedulingInfo.getAndResetBlacklistChanged());
        appSchedulingInfo.updatePlacesBlacklistedByApp(new ArrayList(), blacklistRemovals);
        Assert.assertFalse((boolean)appSchedulingInfo.getAndResetBlacklistChanged());
    }

    @Test
    public void testPriorityAccounting() {
        ApplicationId appIdImpl = ApplicationId.newInstance((long)0L, (int)1);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appIdImpl, (int)1);
        Queue queue = (Queue)Mockito.mock(Queue.class);
        ((Queue)Mockito.doReturn((Object)Mockito.mock(QueueMetrics.class)).when((Object)queue)).getMetrics();
        AppSchedulingInfo info = new AppSchedulingInfo(appAttemptId, "test", queue, (ActiveUsersManager)Mockito.mock(ActiveUsersManager.class), 0L, new ResourceUsage(), (RMContext)new RMContextImpl());
        Assert.assertEquals((long)0L, (long)info.getPriorities().size());
        Priority pri1 = Priority.newInstance((int)1);
        ResourceRequest req1 = ResourceRequest.newInstance((Priority)pri1, (String)"*", (Resource)Resource.newInstance((int)1024, (int)1), (int)1);
        Priority pri2 = Priority.newInstance((int)2);
        ResourceRequest req2 = ResourceRequest.newInstance((Priority)pri2, (String)"*", (Resource)Resource.newInstance((int)1024, (int)1), (int)2);
        ArrayList<ResourceRequest> reqs = new ArrayList<ResourceRequest>();
        reqs.add(req1);
        reqs.add(req2);
        info.updateResourceRequests(reqs, false);
        ArrayList priorities = new ArrayList(info.getPriorities());
        Assert.assertEquals((long)2L, (long)priorities.size());
        Assert.assertEquals((Object)req1.getPriority(), priorities.get(0));
        Assert.assertEquals((Object)req2.getPriority(), priorities.get(1));
        for (Priority priority2 : info.getPriorities()) {
            info.allocate(NodeType.OFF_SWITCH, null, priority2, req1, null);
        }
        Assert.assertEquals((long)1L, (long)info.getPriorities().size());
        Assert.assertEquals((Object)req2.getPriority(), info.getPriorities().iterator().next());
        req2 = ResourceRequest.newInstance((Priority)pri2, (String)"*", (Resource)Resource.newInstance((int)1024, (int)1), (int)1);
        reqs.clear();
        reqs.add(req2);
        info.updateResourceRequests(reqs, false);
        info.allocate(NodeType.OFF_SWITCH, null, req2.getPriority(), req2, null);
        Assert.assertEquals((long)0L, (long)info.getPriorities().size());
        req1 = ResourceRequest.newInstance((Priority)pri1, (String)"*", (Resource)Resource.newInstance((int)1024, (int)1), (int)5);
        reqs.clear();
        reqs.add(req1);
        info.updateResourceRequests(reqs, false);
        Assert.assertEquals((long)1L, (long)info.getPriorities().size());
        Assert.assertEquals((Object)req1.getPriority(), info.getPriorities().iterator().next());
        req1 = ResourceRequest.newInstance((Priority)pri1, (String)"*", (Resource)Resource.newInstance((int)1024, (int)1), (int)0);
        reqs.clear();
        reqs.add(req1);
        info.updateResourceRequests(reqs, false);
        Assert.assertEquals((long)0L, (long)info.getPriorities().size());
    }
}

