/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import io.hops.util.DBUtility;
import io.hops.util.RMStorageFactory;
import io.hops.util.YarnAPIStorageFactory;
import java.io.File;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.AsyncDispatcher;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairSchedulerEventLog;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestFairSchedulerEventLog {
    private File logFile;
    private FairScheduler scheduler;
    private ResourceManager resourceManager;

    @Before
    public void setUp() throws IOException {
        this.scheduler = new FairScheduler();
        YarnConfiguration conf = new YarnConfiguration();
        conf.setClass("yarn.resourcemanager.scheduler.class", FairScheduler.class, ResourceScheduler.class);
        conf.set("yarn.scheduler.fair.event-log-enabled", "true");
        conf.set("yarn.scheduler.fair.assignmultiple", "false");
        RMStorageFactory.setConfiguration((Configuration)conf);
        YarnAPIStorageFactory.setConfiguration((Configuration)conf);
        DBUtility.InitializeDB();
        this.resourceManager = new MockRM((Configuration)conf);
        ((AsyncDispatcher)this.resourceManager.getRMContext().getDispatcher()).start();
        this.scheduler.init((Configuration)conf);
        this.scheduler.start();
        this.scheduler.reinitialize((Configuration)conf, this.resourceManager.getRMContext());
    }

    @Test
    public void testCreateEventLog() throws IOException {
        FairSchedulerEventLog eventLog = this.scheduler.getEventLog();
        this.logFile = new File(eventLog.getLogFile());
        Assert.assertTrue((boolean)this.logFile.exists());
    }

    @After
    public void tearDown() {
        this.logFile.delete();
        this.logFile.getParentFile().delete();
        if (this.scheduler != null) {
            this.scheduler.stop();
            this.scheduler = null;
        }
        if (this.resourceManager != null) {
            this.resourceManager.stop();
            this.resourceManager = null;
        }
    }
}

