/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import io.hops.util.DBUtility;
import io.hops.util.RMStorageFactory;
import io.hops.util.YarnAPIStorageFactory;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.MockNodes;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeUpdateSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairSchedulerTestBase;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.ControlledClock;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestFairSchedulerPreemption
extends FairSchedulerTestBase {
    private final int GB = 1024;
    private static final String ALLOC_FILE = new File(TEST_DIR, TestFairSchedulerPreemption.class.getName() + ".xml").getAbsolutePath();
    private ControlledClock clock;

    @Override
    public Configuration createConfiguration() {
        Configuration conf = super.createConfiguration();
        conf.setClass("yarn.resourcemanager.scheduler.class", StubbedFairScheduler.class, ResourceScheduler.class);
        conf.setBoolean("yarn.scheduler.fair.preemption", true);
        conf.set("yarn.scheduler.fair.allocation.file", ALLOC_FILE);
        return conf;
    }

    @Before
    public void setup() throws IOException {
        this.conf = this.createConfiguration();
        this.clock = new ControlledClock();
        RMStorageFactory.setConfiguration((Configuration)this.conf);
        YarnAPIStorageFactory.setConfiguration((Configuration)this.conf);
        DBUtility.InitializeDB();
    }

    @After
    public void teardown() {
        if (this.resourceManager != null) {
            this.resourceManager.stop();
            this.resourceManager = null;
        }
        this.conf = null;
    }

    private void startResourceManager(float utilizationThreshold) {
        this.conf.setFloat("yarn.scheduler.fair.preemption.cluster-utilization-threshold", utilizationThreshold);
        this.resourceManager = new MockRM(this.conf);
        this.resourceManager.start();
        this.scheduler = (FairScheduler)this.resourceManager.getResourceScheduler();
        this.scheduler.setClock((Clock)this.clock);
        this.scheduler.updateInterval = 60000L;
    }

    private void registerNodeAndSubmitApp(int memory, int vcores, int appContainers, int appMemory) {
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)memory, (int)vcores), 1, "node1");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        Assert.assertEquals((String)"Incorrect amount of resources in the cluster", (long)memory, (long)this.scheduler.rootMetrics.getAvailableMB());
        Assert.assertEquals((String)"Incorrect amount of resources in the cluster", (long)vcores, (long)this.scheduler.rootMetrics.getAvailableVirtualCores());
        this.createSchedulingRequest(appMemory, "queueA", "user1", appContainers);
        this.scheduler.update();
        for (int i = 0; i < 3; ++i) {
            NodeUpdateSchedulerEvent nodeUpdate1 = new NodeUpdateSchedulerEvent(node1);
            this.scheduler.handle((SchedulerEvent)nodeUpdate1);
        }
        Assert.assertEquals((String)"app1's request is not met", (long)(memory - appContainers * appMemory), (long)this.scheduler.rootMetrics.getAvailableMB());
    }

    @Test
    public void testPreemptionWithFreeResources() throws Exception {
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"default\">");
        out.println("<maxResources>0mb,0vcores</maxResources>");
        out.println("</queue>");
        out.println("<queue name=\"queueA\">");
        out.println("<weight>1</weight>");
        out.println("<minResources>1024mb,0vcores</minResources>");
        out.println("</queue>");
        out.println("<queue name=\"queueB\">");
        out.println("<weight>1</weight>");
        out.println("<minResources>1024mb,0vcores</minResources>");
        out.println("</queue>");
        out.print("<defaultMinSharePreemptionTimeout>5</defaultMinSharePreemptionTimeout>");
        out.print("<fairSharePreemptionTimeout>10</fairSharePreemptionTimeout>");
        out.println("</allocations>");
        out.close();
        this.startResourceManager(0.0f);
        this.registerNodeAndSubmitApp(4096, 4, 2, 1024);
        this.createSchedulingRequest(1024, "queueB", "user1", 1, 1);
        this.scheduler.update();
        this.clock.tickSec(6);
        ((StubbedFairScheduler)this.scheduler).resetLastPreemptResources();
        this.scheduler.preemptTasksIfNecessary();
        Assert.assertEquals((String)"preemptResources() should have been called", (long)1024L, (long)((StubbedFairScheduler)this.scheduler).lastPreemptMemory);
        this.resourceManager.stop();
        this.startResourceManager(0.8f);
        this.registerNodeAndSubmitApp(4096, 4, 3, 1024);
        this.createSchedulingRequest(1024, "queueB", "user1", 1, 1);
        this.scheduler.update();
        this.clock.tickSec(6);
        ((StubbedFairScheduler)this.scheduler).resetLastPreemptResources();
        this.scheduler.preemptTasksIfNecessary();
        Assert.assertEquals((String)"preemptResources() should not have been called", (long)-1L, (long)((StubbedFairScheduler)this.scheduler).lastPreemptMemory);
        this.resourceManager.stop();
        this.startResourceManager(0.7f);
        this.registerNodeAndSubmitApp(4096, 4, 3, 1024);
        this.createSchedulingRequest(1024, "queueB", "user1", 1, 1);
        this.scheduler.update();
        this.clock.tickSec(6);
        ((StubbedFairScheduler)this.scheduler).resetLastPreemptResources();
        this.scheduler.preemptTasksIfNecessary();
        Assert.assertEquals((String)"preemptResources() should have been called", (long)1024L, (long)((StubbedFairScheduler)this.scheduler).lastPreemptMemory);
    }

    @Test
    public void testPreemptionFilterOutNonPreemptableQueues() throws Exception {
        PrintWriter out = new PrintWriter(new FileWriter(ALLOC_FILE));
        out.println("<?xml version=\"1.0\"?>");
        out.println("<allocations>");
        out.println("<queue name=\"queueA\">");
        out.println("  <queue name=\"queueA1\" />");
        out.println("  <queue name=\"queueA2\" />");
        out.println("</queue>");
        out.println("<queue name=\"queueB\">");
        out.println("</queue>");
        out.println("<defaultFairSharePreemptionTimeout>5</defaultFairSharePreemptionTimeout>");
        out.println("</allocations>");
        out.close();
        this.conf.setClass("yarn.resourcemanager.scheduler.class", FairScheduler.class, ResourceScheduler.class);
        this.startResourceManager(0.8f);
        RMNode node1 = MockNodes.newNodeInfo(1, Resources.createResource((int)8192, (int)8), 1, "127.0.0.1");
        NodeAddedSchedulerEvent nodeEvent1 = new NodeAddedSchedulerEvent(node1);
        this.scheduler.handle((SchedulerEvent)nodeEvent1);
        ApplicationAttemptId app1 = this.createSchedulingRequest(1024, 1, "queueA.queueA1", "user1", 4, 1);
        ApplicationAttemptId app2 = this.createSchedulingRequest(1024, 1, "queueB", "user2", 4, 1);
        this.scheduler.update();
        NodeUpdateSchedulerEvent nodeUpdate1 = new NodeUpdateSchedulerEvent(node1);
        for (int i = 0; i < 8; ++i) {
            this.scheduler.handle((SchedulerEvent)nodeUpdate1);
        }
        Assert.assertEquals((long)4L, (long)this.scheduler.getSchedulerApp(app1).getLiveContainers().size());
        Assert.assertEquals((long)4L, (long)this.scheduler.getSchedulerApp(app2).getLiveContainers().size());
        this.createSchedulingRequest(1024, 1, "queueA.queueA2", "user3", 2, 1);
        this.scheduler.update();
        this.clock.tickSec(6);
        this.scheduler.update();
        Resource toPreempt = this.scheduler.resourceDeficit(this.scheduler.getQueueManager().getLeafQueue("queueA.queueA2", false), this.clock.getTime());
        Assert.assertEquals((long)2048L, (long)toPreempt.getMemorySize());
        this.scheduler.preemptResources(toPreempt);
        Assert.assertEquals((long)2L, (long)this.scheduler.getSchedulerApp(app1).getPreemptionContainers().size());
        Assert.assertEquals((long)0L, (long)this.scheduler.getSchedulerApp(app2).getPreemptionContainers().size());
    }

    private static class StubbedFairScheduler
    extends FairScheduler {
        public long lastPreemptMemory = -1L;

        private StubbedFairScheduler() {
        }

        protected void preemptResources(Resource toPreempt) {
            this.lastPreemptMemory = toPreempt.getMemorySize();
        }

        public void resetLastPreemptResources() {
            this.lastPreemptMemory = -1L;
        }
    }
}

