/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AllocationConfigurationException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.SchedulingPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.policies.FairSharePolicy;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestSchedulingPolicy {
    public void testParseSchedulingPolicy() throws AllocationConfigurationException {
        SchedulingPolicy sm = SchedulingPolicy.parse((String)FairSharePolicy.class.getName());
        Assert.assertTrue((String)"Invalid scheduler name", (boolean)sm.getName().equals("fair"));
        sm = SchedulingPolicy.parse((String)FairSharePolicy.class.getCanonicalName());
        Assert.assertTrue((String)"Invalid scheduler name", (boolean)sm.getName().equals("fair"));
        sm = SchedulingPolicy.getInstance(FairSharePolicy.class);
        Assert.assertTrue((String)"Invalid scheduler name", (boolean)sm.getName().equals("fair"));
        sm = SchedulingPolicy.parse((String)"drf");
        Assert.assertTrue((String)"Invalid scheduler name", (boolean)sm.getName().equals("DRF"));
        sm = SchedulingPolicy.parse((String)"fair");
        Assert.assertTrue((String)"Invalid scheduler name", (boolean)sm.getName().equals("fair"));
        sm = SchedulingPolicy.parse((String)"fifo");
        Assert.assertTrue((String)"Invalid scheduler name", (boolean)sm.getName().equals("FIFO"));
    }

    @Test(timeout=1000L)
    public void testIsApplicableTo() throws AllocationConfigurationException {
        String ERR = "Broken SchedulingPolicy#isApplicableTo";
        SchedulingPolicy policy = SchedulingPolicy.parse((String)"fifo");
        Assert.assertTrue((String)"Broken SchedulingPolicy#isApplicableTo", (boolean)SchedulingPolicy.isApplicableTo((SchedulingPolicy)policy, (byte)1));
        Assert.assertFalse((String)"Broken SchedulingPolicy#isApplicableTo", (boolean)SchedulingPolicy.isApplicableTo((SchedulingPolicy)SchedulingPolicy.parse((String)"fifo"), (byte)2));
        Assert.assertFalse((String)"Broken SchedulingPolicy#isApplicableTo", (boolean)SchedulingPolicy.isApplicableTo((SchedulingPolicy)SchedulingPolicy.parse((String)"fifo"), (byte)4));
        policy = SchedulingPolicy.parse((String)"fair");
        Assert.assertTrue((String)"Broken SchedulingPolicy#isApplicableTo", (boolean)SchedulingPolicy.isApplicableTo((SchedulingPolicy)policy, (byte)1));
        Assert.assertTrue((String)"Broken SchedulingPolicy#isApplicableTo", (boolean)SchedulingPolicy.isApplicableTo((SchedulingPolicy)policy, (byte)2));
        Assert.assertTrue((String)"Broken SchedulingPolicy#isApplicableTo", (boolean)SchedulingPolicy.isApplicableTo((SchedulingPolicy)policy, (byte)4));
        Assert.assertTrue((String)"Broken SchedulingPolicy#isApplicableTo", (boolean)SchedulingPolicy.isApplicableTo((SchedulingPolicy)policy, (byte)6));
        Assert.assertTrue((String)"Broken SchedulingPolicy#isApplicableTo", (boolean)SchedulingPolicy.isApplicableTo((SchedulingPolicy)policy, (byte)7));
        policy = SchedulingPolicy.parse((String)"drf");
        Assert.assertTrue((String)"Broken SchedulingPolicy#isApplicableTo", (boolean)SchedulingPolicy.isApplicableTo((SchedulingPolicy)policy, (byte)1));
        Assert.assertTrue((String)"Broken SchedulingPolicy#isApplicableTo", (boolean)SchedulingPolicy.isApplicableTo((SchedulingPolicy)policy, (byte)2));
        Assert.assertTrue((String)"Broken SchedulingPolicy#isApplicableTo", (boolean)SchedulingPolicy.isApplicableTo((SchedulingPolicy)policy, (byte)4));
        Assert.assertTrue((String)"Broken SchedulingPolicy#isApplicableTo", (boolean)SchedulingPolicy.isApplicableTo((SchedulingPolicy)policy, (byte)6));
        Assert.assertTrue((String)"Broken SchedulingPolicy#isApplicableTo", (boolean)SchedulingPolicy.isApplicableTo((SchedulingPolicy)policy, (byte)7));
        policy = (SchedulingPolicy)Mockito.mock(SchedulingPolicy.class);
        Mockito.when((Object)policy.getApplicableDepth()).thenReturn((Object)6);
        Assert.assertTrue((String)"Broken SchedulingPolicy#isApplicableTo", (boolean)SchedulingPolicy.isApplicableTo((SchedulingPolicy)policy, (byte)2));
        Assert.assertTrue((String)"Broken SchedulingPolicy#isApplicableTo", (boolean)SchedulingPolicy.isApplicableTo((SchedulingPolicy)policy, (byte)4));
        Assert.assertTrue((String)"Broken SchedulingPolicy#isApplicableTo", (boolean)SchedulingPolicy.isApplicableTo((SchedulingPolicy)policy, (byte)6));
        Assert.assertFalse((String)"Broken SchedulingPolicy#isApplicableTo", (boolean)SchedulingPolicy.isApplicableTo((SchedulingPolicy)policy, (byte)7));
    }
}

