/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.security;

import java.time.Instant;
import java.time.temporal.TemporalUnit;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.math3.util.Pair;
import org.apache.hadoop.util.BackOff;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.security.JWTSecurityHandler;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMAppSecurityManager;
import org.junit.Assert;

public class MockJWTSecurityHandler
extends JWTSecurityHandler {
    protected final Log LOG = LogFactory.getLog(MockJWTSecurityHandler.class);
    private Instant now;
    private final Map<ApplicationId, String> app2jwt = new HashMap<ApplicationId, String>();
    private AtomicReference<MockJWTRenewer> mockRenewer;

    public MockJWTSecurityHandler(RMContext rmContext, RMAppSecurityManager rmAppSecurityManager) {
        super(rmContext, rmAppSecurityManager);
    }

    public JWTSecurityHandler.JWTSecurityManagerMaterial generateMaterial(JWTSecurityHandler.JWTMaterialParameter parameter) throws Exception {
        if (!this.isJWTEnabled()) {
            return null;
        }
        ApplicationId appId = parameter.getApplicationId();
        this.now = Instant.now();
        this.prepareJWTGenerationParameters(parameter);
        Assert.assertTrue((boolean)this.now.isBefore(parameter.getExpirationDate()));
        Pair<Long, TemporalUnit> validity = this.getValidityPeriod();
        Instant expTime = this.now.plus((long)((Long)validity.getFirst()), (TemporalUnit)validity.getSecond());
        Assert.assertEquals((Object)parameter.getExpirationDate(), (Object)expTime);
        Assert.assertFalse((boolean)parameter.isRenewable());
        String jwt = this.generateInternal(parameter);
        Assert.assertNotNull((Object)jwt);
        Assert.assertFalse((boolean)jwt.isEmpty());
        this.app2jwt.put(appId, jwt);
        return new JWTSecurityHandler.JWTSecurityManagerMaterial((JWTSecurityHandler)this, appId, jwt, parameter.getExpirationDate());
    }

    protected Instant getNow() {
        return this.now;
    }

    protected Pair<Long, TemporalUnit> getValidityPeriod() {
        return this.getRmAppSecurityManager().parseInterval(this.getConfig().get(YarnConfiguration.RM_JWT_VALIDITY_PERIOD, YarnConfiguration.DEFAULT_RM_JWT_VALIDITY_PERIOD), YarnConfiguration.RM_JWT_VALIDITY_PERIOD);
    }

    protected Runnable createJWTRenewalTask(ApplicationId appId, String appUser, String token) {
        MockJWTRenewer renewer = new MockJWTRenewer(appId, appUser, token);
        this.mockRenewer = new AtomicReference<MockJWTRenewer>(renewer);
        return renewer;
    }

    public MockJWTRenewer getRenewer() {
        return this.mockRenewer.get();
    }

    public static class BlockingInvalidator
    extends MockJWTSecurityHandler {
        private final Semaphore semaphore = new Semaphore(1);

        public BlockingInvalidator(RMContext rmContext, RMAppSecurityManager rmAppSecurityManager) {
            super(rmContext, rmAppSecurityManager);
        }

        public Semaphore getSemaphore() {
            return this.semaphore;
        }

        protected Thread createInvalidationEventsHandler() {
            return new BlockingInvalidationEventHandler();
        }

        protected class BlockingInvalidationEventHandler
        extends JWTSecurityHandler.InvalidationEventsHandler {
            protected BlockingInvalidationEventHandler() {
                super((JWTSecurityHandler)BlockingInvalidator.this);
            }

            public void run() {
                try {
                    BlockingInvalidator.this.semaphore.acquire();
                    JWTSecurityHandler.JWTInvalidationEvent event = (JWTSecurityHandler.JWTInvalidationEvent)BlockingInvalidator.this.getInvalidationEvents().take();
                    BlockingInvalidator.this.revokeInternal(event.getSigningKeyName());
                    BlockingInvalidator.this.semaphore.release();
                }
                catch (InterruptedException ex) {
                    BlockingInvalidator.this.LOG.error((Object)"It should not have blocked here", (Throwable)ex);
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    protected class MockJWTRenewer
    implements Runnable {
        private final ApplicationId appId;
        private final String appUser;
        private final String token;
        private final BackOff backOff;
        private long backOffTime = 0L;
        private boolean exceptionRaised = true;
        private boolean hasRun = false;

        private MockJWTRenewer(ApplicationId appId, String appUser, String token) {
            this.appId = appId;
            this.appUser = appUser;
            this.token = token;
            this.backOff = MockJWTSecurityHandler.this.getRmAppSecurityManager().createBackOffPolicy();
        }

        @Override
        public void run() {
            try {
                MockJWTSecurityHandler.this.LOG.info((Object)("Renewing JWT for " + this.appId));
                JWTSecurityHandler.JWTMaterialParameter jwtParam = new JWTSecurityHandler.JWTMaterialParameter(this.appId, this.appUser);
                jwtParam.setToken(this.token);
                MockJWTSecurityHandler.this.prepareJWTGenerationParameters(jwtParam);
                String jwt = MockJWTSecurityHandler.this.renewInternal(jwtParam);
                MockJWTSecurityHandler.this.getRenewalTasks().remove(this.appId);
                JWTSecurityHandler.JWTSecurityManagerMaterial jwtMaterial = new JWTSecurityHandler.JWTSecurityManagerMaterial((JWTSecurityHandler)MockJWTSecurityHandler.this, this.appId, jwt, jwtParam.getExpirationDate());
                String oldJWT = (String)MockJWTSecurityHandler.this.app2jwt.get(this.appId);
                Assert.assertNotNull((String)("You should generate JWT first for app " + this.appId), (Object)oldJWT);
                Assert.assertNotEquals((Object)oldJWT, (Object)jwtMaterial.getToken());
                MockJWTSecurityHandler.this.LOG.info((Object)("Renewed JWT for " + this.appId));
                this.exceptionRaised = false;
                this.hasRun = true;
            }
            catch (Exception ex) {
                MockJWTSecurityHandler.this.LOG.error((Object)"Exception should not have happened here!");
                MockJWTSecurityHandler.this.LOG.error((Object)ex, (Throwable)ex);
                MockJWTSecurityHandler.this.getRenewalTasks().remove(this.appId);
                this.backOffTime = this.backOff.getBackOffInMillis();
                if (this.backOffTime != -1L) {
                    MockJWTSecurityHandler.this.LOG.warn((Object)("Failed to renew JWT for application " + this.appId + ". Retrying in " + this.backOffTime + " ms"));
                    ScheduledFuture<?> task = MockJWTSecurityHandler.this.getRmAppSecurityManager().getRenewalExecutorService().schedule(this, this.backOffTime, TimeUnit.MILLISECONDS);
                    MockJWTSecurityHandler.this.getRenewalTasks().put(this.appId, task);
                }
                MockJWTSecurityHandler.this.LOG.error((Object)("Failed to renew JWT for application " + this.appId + ". Failed more than 4 times, giving up"));
            }
        }

        public boolean isExceptionRaised() {
            return this.exceptionRaised;
        }

        public boolean hasRun() {
            return this.hasRun;
        }
    }
}

