/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.security;

import com.google.common.base.Supplier;
import io.hops.util.DBUtility;
import io.hops.util.RMStorageFactory;
import io.hops.util.YarnAPIStorageFactory;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenSecretManager;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.io.DataInputByteBuffer;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.security.token.TokenRenewer;
import org.apache.hadoop.security.token.delegation.DelegationKey;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.protocolrecords.SubmitApplicationRequest;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.AsyncDispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.api.protocolrecords.NodeHeartbeatResponse;
import org.apache.hadoop.yarn.server.resourcemanager.ClientRMService;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.TestRMRestart;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.FileSystemRMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.TestUtils;
import org.apache.hadoop.yarn.server.resourcemanager.security.DelegationTokenRenewer;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.Records;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class TestDelegationTokenRenewer {
    private static final Log LOG = LogFactory.getLog(TestDelegationTokenRenewer.class);
    private static final Text KIND = DelegationTokenRenewer.HDFS_DELEGATION_KIND;
    private static BlockingQueue<Event> eventQueue;
    private static volatile AtomicInteger counter;
    private static AsyncDispatcher dispatcher;
    private static Configuration conf;
    DelegationTokenRenewer delegationTokenRenewer;

    @BeforeClass
    public static void setUpClass() throws Exception {
        conf = new Configuration();
        URI uri = new URI("hdfs://localhost:0");
        System.out.println("scheme is : " + uri.getScheme());
        conf.setClass("fs." + uri.getScheme() + ".impl", MyFS.class, DistributedFileSystem.class);
        FileSystem.setDefaultUri((Configuration)conf, (URI)uri);
        LOG.info((Object)("filesystem uri = " + FileSystem.getDefaultUri((Configuration)conf).toString()));
    }

    @Before
    public void setUp() throws Exception {
        counter = new AtomicInteger(0);
        YarnAPIStorageFactory.setConfiguration((Configuration)conf);
        RMStorageFactory.setConfiguration((Configuration)conf);
        DBUtility.InitializeDB();
        conf.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration((Configuration)conf);
        eventQueue = new LinkedBlockingQueue<Event>();
        dispatcher = new AsyncDispatcher(eventQueue);
        Renewer.reset();
        this.delegationTokenRenewer = this.createNewDelegationTokenRenewer(conf, counter);
        RMContext mockContext = (RMContext)Mockito.mock(RMContext.class);
        ClientRMService mockClientRMService = (ClientRMService)Mockito.mock(ClientRMService.class);
        Mockito.when((Object)mockContext.getSystemCredentialsForApps()).thenReturn(new ConcurrentHashMap());
        Mockito.when((Object)mockContext.getDelegationTokenRenewer()).thenReturn((Object)this.delegationTokenRenewer);
        Mockito.when((Object)mockContext.getDispatcher()).thenReturn((Object)dispatcher);
        Mockito.when((Object)mockContext.getClientRMService()).thenReturn((Object)mockClientRMService);
        InetSocketAddress sockAddr = InetSocketAddress.createUnresolved("localhost", 1234);
        Mockito.when((Object)mockClientRMService.getBindAddress()).thenReturn((Object)sockAddr);
        this.delegationTokenRenewer.setRMContext(mockContext);
        this.delegationTokenRenewer.init(conf);
        this.delegationTokenRenewer.start();
    }

    @After
    public void tearDown() {
        this.delegationTokenRenewer.stop();
    }

    static MyToken createTokens(Text renewer) throws IOException {
        Text user1 = new Text("user1");
        MyDelegationTokenSecretManager sm = new MyDelegationTokenSecretManager(86400000L, 604800000L, 86400000L, 3600000L, null);
        sm.startThreads();
        DelegationTokenIdentifier dtId1 = new DelegationTokenIdentifier(user1, renewer, user1);
        MyToken token1 = new MyToken(dtId1, sm);
        token1.setService(new Text("localhost:0"));
        return token1;
    }

    @Test(timeout=60000L)
    public void testDTRenewal() throws Exception {
        MyFS dfs = (MyFS)FileSystem.get((Configuration)conf);
        LOG.info((Object)("dfs=" + Integer.valueOf(((Object)((Object)dfs)).hashCode()) + ";conf=" + conf.hashCode()));
        MyToken token1 = dfs.getDelegationToken("user1");
        MyToken token2 = dfs.getDelegationToken("user2");
        MyToken token3 = dfs.getDelegationToken("user3");
        Renewer.tokenToRenewIn2Sec = token1;
        LOG.info((Object)("token=" + (Object)((Object)token1) + " should be renewed for 2 secs"));
        String nn1 = "hdfs://host1:0";
        String nn2 = "hdfs://host2:0";
        String nn3 = "hdfs://host3:0";
        Credentials ts = new Credentials();
        ts.addToken(new Text(nn1), (Token)token1);
        ts.addToken(new Text(nn2), (Token)token2);
        ts.addToken(new Text(nn3), (Token)token3);
        ApplicationId applicationId_0 = BuilderUtils.newApplicationId((long)0L, (int)0);
        this.delegationTokenRenewer.addApplicationAsync(applicationId_0, ts, true, "user");
        this.waitForEventsToGetProcessed(this.delegationTokenRenewer);
        int numberOfExpectedRenewals = 4;
        int attempts = 10;
        while (attempts-- > 0) {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (Renewer.counter != numberOfExpectedRenewals) continue;
        }
        LOG.info((Object)("dfs=" + ((Object)((Object)dfs)).hashCode() + ";Counter = " + Renewer.counter + ";t=" + Renewer.lastRenewed));
        Assert.assertEquals((String)"renew wasn't called as many times as expected(4):", (long)numberOfExpectedRenewals, (long)Renewer.counter);
        Assert.assertEquals((String)"most recently renewed token mismatch", (Object)Renewer.lastRenewed, (Object)((Object)token1));
        ts = new Credentials();
        MyToken token4 = dfs.getDelegationToken("user4");
        Renewer.tokenToRenewIn2Sec = token4;
        LOG.info((Object)("token=" + (Object)((Object)token4) + " should be renewed for 2 secs"));
        String nn4 = "hdfs://host4:0";
        ts.addToken(new Text(nn4), (Token)token4);
        ApplicationId applicationId_1 = BuilderUtils.newApplicationId((long)0L, (int)1);
        this.delegationTokenRenewer.addApplicationAsync(applicationId_1, ts, true, "user");
        this.waitForEventsToGetProcessed(this.delegationTokenRenewer);
        this.delegationTokenRenewer.applicationFinished(applicationId_1);
        this.waitForEventsToGetProcessed(this.delegationTokenRenewer);
        numberOfExpectedRenewals = Renewer.counter;
        try {
            Thread.sleep(6000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        LOG.info((Object)("Counter = " + Renewer.counter + ";t=" + Renewer.lastRenewed));
        Assert.assertEquals((String)"renew wasn't called as many times as expected", (long)numberOfExpectedRenewals, (long)Renewer.counter);
        try {
            token4.renew(conf);
            Assert.fail((String)"Renewal of cancelled token should have failed");
        }
        catch (SecretManager.InvalidToken invalidToken) {
            // empty catch block
        }
    }

    @Test(timeout=60000L)
    public void testAppRejectionWithCancelledDelegationToken() throws Exception {
        MyFS dfs = (MyFS)FileSystem.get((Configuration)conf);
        LOG.info((Object)("dfs=" + Integer.valueOf(((Object)((Object)dfs)).hashCode()) + ";conf=" + conf.hashCode()));
        MyToken token = dfs.getDelegationToken("user1");
        token.cancelToken();
        Credentials ts = new Credentials();
        ts.addToken(token.getKind(), (Token)token);
        ApplicationId appId = BuilderUtils.newApplicationId((long)0L, (int)0);
        this.delegationTokenRenewer.addApplicationAsync(appId, ts, true, "user");
        int waitCnt = 20;
        while (waitCnt-- > 0) {
            if (!eventQueue.isEmpty()) {
                Event evt = eventQueue.take();
                if (evt.getType() != RMAppEventType.APP_REJECTED) continue;
                Assert.assertTrue((boolean)((RMAppEvent)evt).getApplicationId().equals((Object)appId));
                return;
            }
            Thread.sleep(500L);
        }
        Assert.fail((String)"App submission with a cancelled token should have failed");
    }

    @Test(timeout=60000L)
    public void testAppTokenWithNonRenewer() throws Exception {
        MyFS dfs = (MyFS)FileSystem.get((Configuration)conf);
        LOG.info((Object)("dfs=" + Integer.valueOf(((Object)((Object)dfs)).hashCode()) + ";conf=" + conf.hashCode()));
        MyToken token = dfs.getDelegationToken("");
        token.cancelToken();
        Credentials ts = new Credentials();
        ts.addToken(token.getKind(), (Token)token);
        ApplicationId appId = BuilderUtils.newApplicationId((long)0L, (int)0);
        this.delegationTokenRenewer.addApplicationSync(appId, ts, true, "user");
    }

    @Test(timeout=60000L)
    public void testDTRenewalWithNoCancel() throws Exception {
        MyFS dfs = (MyFS)FileSystem.get((Configuration)conf);
        LOG.info((Object)("dfs=" + Integer.valueOf(((Object)((Object)dfs)).hashCode()) + ";conf=" + conf.hashCode()));
        Credentials ts = new Credentials();
        MyToken token1 = dfs.getDelegationToken("user1");
        Renewer.tokenToRenewIn2Sec = token1;
        LOG.info((Object)("token=" + (Object)((Object)token1) + " should be renewed for 2 secs"));
        String nn1 = "hdfs://host1:0";
        ts.addToken(new Text(nn1), (Token)token1);
        ApplicationId applicationId_1 = BuilderUtils.newApplicationId((long)0L, (int)1);
        this.delegationTokenRenewer.addApplicationAsync(applicationId_1, ts, false, "user");
        this.waitForEventsToGetProcessed(this.delegationTokenRenewer);
        this.delegationTokenRenewer.applicationFinished(applicationId_1);
        this.waitForEventsToGetProcessed(this.delegationTokenRenewer);
        int numberOfExpectedRenewals = Renewer.counter;
        try {
            Thread.sleep(6000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        LOG.info((Object)("Counter = " + Renewer.counter + ";t=" + Renewer.lastRenewed));
        Assert.assertEquals((String)"renew wasn't called as many times as expected", (long)numberOfExpectedRenewals, (long)Renewer.counter);
        token1.renew(conf);
    }

    @Test(timeout=60000L)
    public void testDTKeepAlive1() throws Exception {
        Configuration lconf = new Configuration(conf);
        lconf.setBoolean("yarn.log-aggregation-enable", true);
        lconf.setLong("yarn.nm.liveness-monitor.expiry-interval-ms", 6000L);
        lconf.setLong("yarn.resourcemanager.delayed.delegation-token.removal-interval-ms", 1000L);
        DelegationTokenRenewer localDtr = this.createNewDelegationTokenRenewer(lconf, counter);
        RMContext mockContext = (RMContext)Mockito.mock(RMContext.class);
        Mockito.when((Object)mockContext.getSystemCredentialsForApps()).thenReturn(new ConcurrentHashMap());
        ClientRMService mockClientRMService = (ClientRMService)Mockito.mock(ClientRMService.class);
        Mockito.when((Object)mockContext.getClientRMService()).thenReturn((Object)mockClientRMService);
        Mockito.when((Object)mockContext.getDelegationTokenRenewer()).thenReturn((Object)localDtr);
        Mockito.when((Object)mockContext.getDispatcher()).thenReturn((Object)dispatcher);
        InetSocketAddress sockAddr = InetSocketAddress.createUnresolved("localhost", 1234);
        Mockito.when((Object)mockClientRMService.getBindAddress()).thenReturn((Object)sockAddr);
        localDtr.setRMContext(mockContext);
        localDtr.init(lconf);
        localDtr.start();
        MyFS dfs = (MyFS)FileSystem.get((Configuration)lconf);
        LOG.info((Object)("dfs=" + Integer.valueOf(((Object)((Object)dfs)).hashCode()) + ";conf=" + lconf.hashCode()));
        Credentials ts = new Credentials();
        MyToken token1 = dfs.getDelegationToken("user1");
        String nn1 = "hdfs://host1:0";
        ts.addToken(new Text(nn1), (Token)token1);
        ApplicationId applicationId_0 = BuilderUtils.newApplicationId((long)0L, (int)0);
        localDtr.addApplicationAsync(applicationId_0, ts, true, "user");
        this.waitForEventsToGetProcessed(localDtr);
        if (!eventQueue.isEmpty()) {
            Event evt = eventQueue.take();
            if (evt instanceof RMAppEvent) {
                Assert.assertEquals((Object)((RMAppEvent)evt).getType(), (Object)RMAppEventType.START);
            } else {
                Assert.fail((String)"RMAppEvent.START was expected!!");
            }
        }
        localDtr.applicationFinished(applicationId_0);
        this.waitForEventsToGetProcessed(localDtr);
        token1.renew(lconf);
        Thread.sleep(10000L);
        try {
            token1.renew(lconf);
            Assert.fail((String)"Renewal of cancelled token should have failed");
        }
        catch (SecretManager.InvalidToken invalidToken) {
            // empty catch block
        }
    }

    @Test(timeout=60000L)
    public void testDTKeepAlive2() throws Exception {
        Configuration lconf = new Configuration(conf);
        lconf.setBoolean("yarn.log-aggregation-enable", true);
        lconf.setLong("yarn.nm.liveness-monitor.expiry-interval-ms", 6000L);
        lconf.setLong("yarn.resourcemanager.delayed.delegation-token.removal-interval-ms", 1000L);
        DelegationTokenRenewer localDtr = this.createNewDelegationTokenRenewer(conf, counter);
        RMContext mockContext = (RMContext)Mockito.mock(RMContext.class);
        Mockito.when((Object)mockContext.getSystemCredentialsForApps()).thenReturn(new ConcurrentHashMap());
        ClientRMService mockClientRMService = (ClientRMService)Mockito.mock(ClientRMService.class);
        Mockito.when((Object)mockContext.getClientRMService()).thenReturn((Object)mockClientRMService);
        Mockito.when((Object)mockContext.getDelegationTokenRenewer()).thenReturn((Object)localDtr);
        Mockito.when((Object)mockContext.getDispatcher()).thenReturn((Object)dispatcher);
        InetSocketAddress sockAddr = InetSocketAddress.createUnresolved("localhost", 1234);
        Mockito.when((Object)mockClientRMService.getBindAddress()).thenReturn((Object)sockAddr);
        localDtr.setRMContext(mockContext);
        localDtr.init(lconf);
        localDtr.start();
        MyFS dfs = (MyFS)FileSystem.get((Configuration)lconf);
        LOG.info((Object)("dfs=" + Integer.valueOf(((Object)((Object)dfs)).hashCode()) + ";conf=" + lconf.hashCode()));
        Credentials ts = new Credentials();
        MyToken token1 = dfs.getDelegationToken("user1");
        String nn1 = "hdfs://host1:0";
        ts.addToken(new Text(nn1), (Token)token1);
        ApplicationId applicationId_0 = BuilderUtils.newApplicationId((long)0L, (int)0);
        localDtr.addApplicationAsync(applicationId_0, ts, true, "user");
        localDtr.applicationFinished(applicationId_0);
        this.waitForEventsToGetProcessed(this.delegationTokenRenewer);
        localDtr.updateKeepAliveApplications(Collections.singletonList(applicationId_0));
        token1.renew(lconf);
        Thread.sleep(4500L);
        token1.renew(lconf);
        Thread.sleep(3000L);
        try {
            token1.renew(lconf);
            Assert.fail((String)"Renewal of cancelled token should have failed");
        }
        catch (SecretManager.InvalidToken invalidToken) {
            // empty catch block
        }
    }

    private DelegationTokenRenewer createNewDelegationTokenRenewer(Configuration conf, final AtomicInteger counter) {
        DelegationTokenRenewer renew = new DelegationTokenRenewer(){

            protected ThreadPoolExecutor createNewThreadPoolService(Configuration conf) {
                ThreadPoolExecutor pool = new ThreadPoolExecutor(5, 5, 3L, TimeUnit.SECONDS, new LinkedBlockingQueue()){

                    @Override
                    protected void afterExecute(Runnable r, Throwable t) {
                        counter.decrementAndGet();
                        super.afterExecute(r, t);
                    }

                    @Override
                    public void execute(Runnable command) {
                        counter.incrementAndGet();
                        super.execute(command);
                    }
                };
                return pool;
            }
        };
        renew.setRMContext(TestUtils.getMockRMContext());
        return renew;
    }

    private void waitForEventsToGetProcessed(DelegationTokenRenewer dtr) throws InterruptedException {
        int wait = 40;
        while (wait-- > 0 && counter.get() > 0) {
            Thread.sleep(200L);
        }
    }

    @Test(timeout=20000L)
    public void testDTRonAppSubmission() throws IOException, InterruptedException, BrokenBarrierException {
        Credentials credsx = new Credentials();
        Token tokenx = (Token)Mockito.mock(Token.class);
        Mockito.when((Object)tokenx.getKind()).thenReturn((Object)KIND);
        DelegationTokenIdentifier dtId1 = new DelegationTokenIdentifier(new Text("user1"), new Text("renewer"), new Text("user1"));
        Mockito.when((Object)tokenx.decodeIdentifier()).thenReturn((Object)dtId1);
        credsx.addToken(new Text("token"), tokenx);
        ((Token)Mockito.doReturn((Object)true).when((Object)tokenx)).isManaged();
        ((Token)Mockito.doThrow((Throwable)new IOException("boom")).when((Object)tokenx)).renew((Configuration)Matchers.any(Configuration.class));
        DelegationTokenRenewer dtr = this.createNewDelegationTokenRenewer(conf, counter);
        RMContext mockContext = (RMContext)Mockito.mock(RMContext.class);
        Mockito.when((Object)mockContext.getSystemCredentialsForApps()).thenReturn(new ConcurrentHashMap());
        ClientRMService mockClientRMService = (ClientRMService)Mockito.mock(ClientRMService.class);
        Mockito.when((Object)mockContext.getClientRMService()).thenReturn((Object)mockClientRMService);
        InetSocketAddress sockAddr = InetSocketAddress.createUnresolved("localhost", 1234);
        Mockito.when((Object)mockClientRMService.getBindAddress()).thenReturn((Object)sockAddr);
        dtr.setRMContext(mockContext);
        Mockito.when((Object)mockContext.getDelegationTokenRenewer()).thenReturn((Object)dtr);
        dtr.init(conf);
        dtr.start();
        try {
            dtr.addApplicationSync((ApplicationId)Mockito.mock(ApplicationId.class), credsx, false, "user");
            Assert.fail((String)"Catch IOException on app submission");
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getMessage().contains(tokenx.toString()));
            Assert.assertTrue((boolean)e.getCause().toString().contains("boom"));
        }
    }

    @Test(timeout=20000L)
    public void testConcurrentAddApplication() throws IOException, InterruptedException, BrokenBarrierException {
        final CyclicBarrier startBarrier = new CyclicBarrier(2);
        final CyclicBarrier endBarrier = new CyclicBarrier(2);
        final Credentials creds1 = new Credentials();
        Token token1 = (Token)Mockito.mock(Token.class);
        Mockito.when((Object)token1.getKind()).thenReturn((Object)KIND);
        DelegationTokenIdentifier dtId1 = new DelegationTokenIdentifier(new Text("user1"), new Text("renewer"), new Text("user1"));
        Mockito.when((Object)token1.decodeIdentifier()).thenReturn((Object)dtId1);
        creds1.addToken(new Text("token"), token1);
        ((Token)Mockito.doReturn((Object)true).when((Object)token1)).isManaged();
        ((Token)Mockito.doAnswer((Answer)new Answer<Long>(){

            public Long answer(InvocationOnMock invocation) throws InterruptedException, BrokenBarrierException {
                startBarrier.await();
                endBarrier.await();
                return Long.MAX_VALUE;
            }
        }).when((Object)token1)).renew((Configuration)Matchers.any(Configuration.class));
        Credentials creds2 = new Credentials();
        Token token2 = (Token)Mockito.mock(Token.class);
        Mockito.when((Object)token2.getKind()).thenReturn((Object)KIND);
        Mockito.when((Object)token2.decodeIdentifier()).thenReturn((Object)dtId1);
        creds2.addToken(new Text("token"), token2);
        ((Token)Mockito.doReturn((Object)true).when((Object)token2)).isManaged();
        ((Token)Mockito.doReturn((Object)Long.MAX_VALUE).when((Object)token2)).renew((Configuration)Matchers.any(Configuration.class));
        final DelegationTokenRenewer dtr = this.createNewDelegationTokenRenewer(conf, counter);
        RMContext mockContext = (RMContext)Mockito.mock(RMContext.class);
        Mockito.when((Object)mockContext.getSystemCredentialsForApps()).thenReturn(new ConcurrentHashMap());
        ClientRMService mockClientRMService = (ClientRMService)Mockito.mock(ClientRMService.class);
        Mockito.when((Object)mockContext.getClientRMService()).thenReturn((Object)mockClientRMService);
        InetSocketAddress sockAddr = InetSocketAddress.createUnresolved("localhost", 1234);
        Mockito.when((Object)mockClientRMService.getBindAddress()).thenReturn((Object)sockAddr);
        dtr.setRMContext(mockContext);
        Mockito.when((Object)mockContext.getDelegationTokenRenewer()).thenReturn((Object)dtr);
        dtr.init(conf);
        dtr.start();
        Thread submitThread = new Thread(){

            @Override
            public void run() {
                dtr.addApplicationAsync((ApplicationId)Mockito.mock(ApplicationId.class), creds1, false, "user");
            }
        };
        submitThread.start();
        startBarrier.await();
        dtr.addApplicationAsync((ApplicationId)Mockito.mock(ApplicationId.class), creds2, false, "user");
        endBarrier.await();
        submitThread.join();
    }

    @Test(timeout=20000L)
    public void testAppSubmissionWithInvalidDelegationToken() throws Exception {
        Configuration conf = new Configuration();
        conf.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration((Configuration)conf);
        MockRM rm = new MockRM(conf){

            protected void doSecureLogin() throws IOException {
            }
        };
        ByteBuffer tokens = ByteBuffer.wrap("BOGUS".getBytes());
        ContainerLaunchContext amContainer = ContainerLaunchContext.newInstance(new HashMap(), new HashMap(), new ArrayList(), new HashMap(), (ByteBuffer)tokens, new HashMap());
        ApplicationSubmissionContext appSubContext = ApplicationSubmissionContext.newInstance((ApplicationId)ApplicationId.newInstance((long)1234121L, (int)0), (String)"BOGUS", (String)"default", (Priority)Priority.UNDEFINED, (ContainerLaunchContext)amContainer, (boolean)false, (boolean)true, (int)1, (Resource)Resource.newInstance((int)1024, (int)1), (String)"BOGUS");
        SubmitApplicationRequest request = SubmitApplicationRequest.newInstance((ApplicationSubmissionContext)appSubContext);
        try {
            rm.getClientRMService().submitApplication(request);
            Assert.fail((String)"Error was excepted.");
        }
        catch (YarnException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Bad header found in token storage"));
        }
    }

    @Test(timeout=20000L)
    public void testReplaceExpiringDelegationToken() throws Exception {
        conf.setBoolean("yarn.resourcemanager.proxy-user-privileges.enabled", true);
        conf.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration((Configuration)conf);
        Text userText1 = new Text("user1");
        DelegationTokenIdentifier dtId1 = new DelegationTokenIdentifier(userText1, new Text("renewer1"), userText1);
        dtId1.setMaxDate(0L);
        final Token token1 = new Token(dtId1.getBytes(), "password1".getBytes(), dtId1.getKind(), new Text("service1"));
        Text userText2 = new Text("user2");
        DelegationTokenIdentifier dtId2 = new DelegationTokenIdentifier(userText1, new Text("renewer2"), userText2);
        final Token expectedToken = new Token(dtId2.getBytes(), "password2".getBytes(), dtId2.getKind(), new Text("service2"));
        final TestRMRestart.TestSecurityMockRM rm = new TestRMRestart.TestSecurityMockRM(conf, null){

            protected DelegationTokenRenewer createDelegationTokenRenewer() {
                return new DelegationTokenRenewer(){

                    protected Token<?>[] obtainSystemTokensForUser(String user, Credentials credentials) throws IOException {
                        credentials.addToken(expectedToken.getService(), expectedToken);
                        return new Token[]{expectedToken};
                    }
                };
            }
        };
        rm.start();
        Credentials credentials = new Credentials();
        credentials.addToken(userText1, token1);
        RMApp app = rm.submitApp(200, "name", "user", new HashMap<ApplicationAccessType, String>(), false, "default", 1, credentials);
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            public Boolean get() {
                return rm.getRMContext().getDelegationTokenRenewer().getAllTokens().get(token1) == null;
            }
        }, (int)1000, (int)20000);
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            public Boolean get() {
                return !rm.getRMContext().getDelegationTokenRenewer().getDelegationTokens().contains(token1);
            }
        }, (int)1000, (int)20000);
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            public Boolean get() {
                return rm.getRMContext().getDelegationTokenRenewer().getDelegationTokens().contains(expectedToken);
            }
        }, (int)1000, (int)20000);
        MockNM nm1 = new MockNM("127.0.0.1:1234", 15120, rm.getResourceTrackerService());
        nm1.registerNode();
        NodeHeartbeatResponse response = nm1.nodeHeartbeat(true);
        ByteBuffer tokenBuffer = (ByteBuffer)response.getSystemCredentialsForApps().get(app.getApplicationId());
        Assert.assertNotNull((Object)tokenBuffer);
        Credentials appCredentials = new Credentials();
        DataInputByteBuffer buf = new DataInputByteBuffer();
        tokenBuffer.rewind();
        buf.reset(new ByteBuffer[]{tokenBuffer});
        appCredentials.readTokenStorageStream((DataInputStream)buf);
        Assert.assertTrue((boolean)appCredentials.getAllTokens().contains(expectedToken));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRMRestartWithExpiredToken() throws Exception {
        YarnConfiguration yarnConf = new YarnConfiguration();
        yarnConf.setBoolean("yarn.resourcemanager.proxy-user-privileges.enabled", true);
        yarnConf.set("hadoop.security.authentication", "kerberos");
        yarnConf.setBoolean("yarn.resourcemanager.recovery.enabled", true);
        FileSystem fs = FileSystem.get((Configuration)new Configuration());
        Path tmpDir = new Path(new File("target", this.getClass().getSimpleName() + "-tmpDir").getAbsolutePath());
        fs.delete(tmpDir, true);
        fs.mkdirs(tmpDir);
        try {
            conf.set("yarn.resourcemanager.fs.state-store.uri", tmpDir.toString());
            conf.set("yarn.resourcemanager.store.class", FileSystemRMStateStore.class.getName());
            UserGroupInformation.setConfiguration((Configuration)yarnConf);
            Text userText1 = new Text("user1");
            DelegationTokenIdentifier dtId1 = new DelegationTokenIdentifier(userText1, new Text("renewer1"), userText1);
            final Token originalToken = new Token(dtId1.getBytes(), "password1".getBytes(), dtId1.getKind(), new Text("service1"));
            Credentials credentials = new Credentials();
            credentials.addToken(userText1, originalToken);
            TestRMRestart.TestSecurityMockRM rm1 = new TestRMRestart.TestSecurityMockRM((Configuration)yarnConf);
            rm1.start();
            RMApp app = rm1.submitApp(200, "name", "user", new HashMap<ApplicationAccessType, String>(), false, "default", 1, credentials);
            Text userText2 = new Text("user1");
            DelegationTokenIdentifier dtId2 = new DelegationTokenIdentifier(userText1, new Text("renewer2"), userText2);
            final Token updatedToken = new Token(dtId2.getBytes(), "password2".getBytes(), dtId2.getKind(), new Text("service2"));
            final AtomicBoolean firstRenewInvoked = new AtomicBoolean(false);
            final AtomicBoolean secondRenewInvoked = new AtomicBoolean(false);
            TestRMRestart.TestSecurityMockRM rm2 = new TestRMRestart.TestSecurityMockRM((Configuration)yarnConf){

                protected DelegationTokenRenewer createDelegationTokenRenewer() {
                    return new DelegationTokenRenewer(){

                        protected void renewToken(DelegationTokenRenewer.DelegationTokenToRenew dttr) throws IOException {
                            if (!dttr.token.equals((Object)updatedToken)) {
                                if (dttr.token.equals((Object)originalToken)) {
                                    firstRenewInvoked.set(true);
                                    throw new SecretManager.InvalidToken("Failed to renew");
                                }
                                throw new IOException("Unexpected");
                            }
                            secondRenewInvoked.set(true);
                            super.renewToken(dttr);
                        }

                        protected Token<?>[] obtainSystemTokensForUser(String user, Credentials credentials) throws IOException {
                            credentials.addToken(updatedToken.getService(), updatedToken);
                            return new Token[]{updatedToken};
                        }
                    };
                }
            };
            rm2.start();
            MockNM nm1 = new MockNM("127.0.0.1:1234", 15120, rm2.getResourceTrackerService());
            nm1.registerNode();
            NodeHeartbeatResponse response = nm1.nodeHeartbeat(true);
            ByteBuffer tokenBuffer = (ByteBuffer)response.getSystemCredentialsForApps().get(app.getApplicationId());
            Assert.assertNotNull((Object)tokenBuffer);
            Credentials appCredentials = new Credentials();
            DataInputByteBuffer buf = new DataInputByteBuffer();
            tokenBuffer.rewind();
            buf.reset(new ByteBuffer[]{tokenBuffer});
            appCredentials.readTokenStorageStream((DataInputStream)buf);
            Assert.assertTrue((firstRenewInvoked.get() && secondRenewInvoked.get() ? 1 : 0) != 0);
            Assert.assertTrue((boolean)appCredentials.getAllTokens().contains(updatedToken));
        }
        finally {
            fs.delete(tmpDir, true);
        }
    }

    @Test
    public void testAppSubmissionWithoutDelegationToken() throws Exception {
        conf.setBoolean("yarn.resourcemanager.proxy-user-privileges.enabled", true);
        Text userText2 = new Text("user2");
        DelegationTokenIdentifier dtId2 = new DelegationTokenIdentifier(new Text("user2"), new Text("renewer2"), userText2);
        final Token token2 = new Token(dtId2.getBytes(), "password2".getBytes(), dtId2.getKind(), new Text("service2"));
        final TestRMRestart.TestSecurityMockRM rm = new TestRMRestart.TestSecurityMockRM(conf, null){

            protected DelegationTokenRenewer createDelegationTokenRenewer() {
                return new DelegationTokenRenewer(){

                    protected Token<?>[] obtainSystemTokensForUser(String user, Credentials credentials) throws IOException {
                        credentials.addToken(token2.getService(), token2);
                        return new Token[]{token2};
                    }
                };
            }
        };
        rm.start();
        RMApp app = rm.submitApp(200);
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            public Boolean get() {
                return rm.getRMContext().getDelegationTokenRenewer().getDelegationTokens().contains(token2);
            }
        }, (int)1000, (int)20000);
        MockNM nm1 = new MockNM("127.0.0.1:1234", 15120, rm.getResourceTrackerService());
        nm1.registerNode();
        NodeHeartbeatResponse response = nm1.nodeHeartbeat(true);
        ByteBuffer tokenBuffer = (ByteBuffer)response.getSystemCredentialsForApps().get(app.getApplicationId());
        Assert.assertNotNull((Object)tokenBuffer);
        Credentials appCredentials = new Credentials();
        DataInputByteBuffer buf = new DataInputByteBuffer();
        tokenBuffer.rewind();
        buf.reset(new ByteBuffer[]{tokenBuffer});
        appCredentials.readTokenStorageStream((DataInputStream)buf);
        Assert.assertTrue((boolean)appCredentials.getAllTokens().contains(token2));
    }

    @Test(timeout=30000L)
    public void testAppSubmissionWithPreviousToken() throws Exception {
        TestRMRestart.TestSecurityMockRM rm = new TestRMRestart.TestSecurityMockRM(conf, null);
        rm.start();
        MockNM nm1 = new MockNM("127.0.0.1:1234", 15120, rm.getResourceTrackerService());
        nm1.registerNode();
        Text userText1 = new Text("user");
        DelegationTokenIdentifier dtId1 = new DelegationTokenIdentifier(userText1, new Text("renewer1"), userText1);
        Token token1 = new Token(dtId1.getBytes(), "password1".getBytes(), dtId1.getKind(), new Text("service1"));
        Credentials credentials = new Credentials();
        credentials.addToken(userText1, token1);
        Resource resource = (Resource)Records.newRecord(Resource.class);
        resource.setMemorySize(200L);
        RMApp app1 = rm.submitApp(resource, "name", "user", null, false, null, 2, credentials, null, true, false, false, null, 0L, null, false, null);
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm, nm1);
        rm.waitForState(app1.getApplicationId(), RMAppState.RUNNING);
        RMApp app2 = rm.submitApp(resource, "name", "user", null, false, null, 2, credentials, null, true, false, false, null, 0L, null, true, null);
        MockAM am2 = MockRM.launchAndRegisterAM(app2, rm, nm1);
        rm.waitForState(app2.getApplicationId(), RMAppState.RUNNING);
        MockRM.finishAMAndVerifyAppState(app2, rm, nm1, am2);
        Assert.assertTrue((boolean)rm.getRMContext().getDelegationTokenRenewer().getAllTokens().containsKey(token1));
        MockRM.finishAMAndVerifyAppState(app1, rm, nm1, am1);
        Assert.assertFalse((boolean)Renewer.cancelled);
    }

    @Test
    public void testFSLeakInObtainSystemTokensForUser() throws Exception {
        Credentials credentials = new Credentials();
        String user = "test";
        int oldCounter = MyFS.getInstanceCounter();
        this.delegationTokenRenewer.obtainSystemTokensForUser(user, credentials);
        this.delegationTokenRenewer.obtainSystemTokensForUser(user, credentials);
        this.delegationTokenRenewer.obtainSystemTokensForUser(user, credentials);
        Assert.assertEquals((long)oldCounter, (long)MyFS.getInstanceCounter());
    }

    @Test(timeout=30000L)
    public void testCancelWithMultipleAppSubmissions() throws Exception {
        TestRMRestart.TestSecurityMockRM rm = new TestRMRestart.TestSecurityMockRM(conf, null);
        rm.start();
        MockNM nm1 = new MockNM("127.0.0.1:1234", 15120, rm.getResourceTrackerService());
        nm1.registerNode();
        Text userText1 = new Text("user");
        DelegationTokenIdentifier dtId1 = new DelegationTokenIdentifier(userText1, new Text("renewer1"), userText1);
        Token token1 = new Token(dtId1.getBytes(), "password1".getBytes(), dtId1.getKind(), new Text("service1"));
        Credentials credentials = new Credentials();
        credentials.addToken(token1.getService(), token1);
        DelegationTokenRenewer renewer = rm.getRMContext().getDelegationTokenRenewer();
        Assert.assertTrue((boolean)renewer.getAllTokens().isEmpty());
        Assert.assertFalse((boolean)Renewer.cancelled);
        Resource resource = (Resource)Records.newRecord(Resource.class);
        resource.setMemorySize(200L);
        RMApp app1 = rm.submitApp(resource, "name", "user", null, false, null, 2, credentials, null, true, false, false, null, 0L, null, true, null);
        MockAM am1 = MockRM.launchAndRegisterAM(app1, rm, nm1);
        rm.waitForState(app1.getApplicationId(), RMAppState.RUNNING);
        DelegationTokenRenewer.DelegationTokenToRenew dttr = (DelegationTokenRenewer.DelegationTokenToRenew)renewer.getAllTokens().get(token1);
        Assert.assertNotNull((Object)dttr);
        Assert.assertTrue((boolean)dttr.referringAppIds.contains(app1.getApplicationId()));
        RMApp app2 = rm.submitApp(resource, "name", "user", null, false, null, 2, credentials, null, true, false, false, null, 0L, null, true, null);
        MockAM am2 = MockRM.launchAndRegisterAM(app2, rm, nm1);
        rm.waitForState(app2.getApplicationId(), RMAppState.RUNNING);
        Assert.assertTrue((boolean)renewer.getAllTokens().containsKey(token1));
        Assert.assertTrue((boolean)dttr.referringAppIds.contains(app2.getApplicationId()));
        Assert.assertTrue((boolean)dttr.referringAppIds.contains(app2.getApplicationId()));
        Assert.assertFalse((boolean)Renewer.cancelled);
        MockRM.finishAMAndVerifyAppState(app2, rm, nm1, am2);
        Assert.assertTrue((boolean)renewer.getAllTokens().containsKey(token1));
        Assert.assertTrue((boolean)dttr.referringAppIds.contains(app1.getApplicationId()));
        Assert.assertFalse((boolean)dttr.referringAppIds.contains(app2.getApplicationId()));
        Assert.assertFalse((boolean)dttr.isTimerCancelled());
        Assert.assertFalse((boolean)Renewer.cancelled);
        RMApp app3 = rm.submitApp(resource, "name", "user", null, false, null, 2, credentials, null, true, false, false, null, 0L, null, true, null);
        MockAM am3 = MockRM.launchAndRegisterAM(app3, rm, nm1);
        rm.waitForState(app3.getApplicationId(), RMAppState.RUNNING);
        Assert.assertTrue((boolean)renewer.getAllTokens().containsKey(token1));
        Assert.assertTrue((boolean)dttr.referringAppIds.contains(app1.getApplicationId()));
        Assert.assertTrue((boolean)dttr.referringAppIds.contains(app3.getApplicationId()));
        Assert.assertFalse((boolean)dttr.isTimerCancelled());
        Assert.assertFalse((boolean)Renewer.cancelled);
        MockRM.finishAMAndVerifyAppState(app1, rm, nm1, am1);
        Assert.assertTrue((boolean)renewer.getAllTokens().containsKey(token1));
        Assert.assertFalse((boolean)dttr.referringAppIds.contains(app1.getApplicationId()));
        Assert.assertTrue((boolean)dttr.referringAppIds.contains(app3.getApplicationId()));
        Assert.assertFalse((boolean)dttr.isTimerCancelled());
        Assert.assertFalse((boolean)Renewer.cancelled);
        MockRM.finishAMAndVerifyAppState(app3, rm, nm1, am3);
        Assert.assertFalse((boolean)renewer.getAllTokens().containsKey(token1));
        Assert.assertTrue((boolean)dttr.referringAppIds.isEmpty());
        Assert.assertTrue((boolean)dttr.isTimerCancelled());
        Assert.assertTrue((boolean)Renewer.cancelled);
        Assert.assertFalse((boolean)renewer.getDelegationTokens().contains(token1));
    }

    static class MyFS
    extends DistributedFileSystem {
        private static AtomicInteger instanceCounter = new AtomicInteger();

        public MyFS() {
            instanceCounter.incrementAndGet();
        }

        public void close() {
            instanceCounter.decrementAndGet();
        }

        public static int getInstanceCounter() {
            return instanceCounter.get();
        }

        public void initialize(URI uri, Configuration conf) throws IOException {
        }

        public MyToken getDelegationToken(String renewer) throws IOException {
            MyToken result = TestDelegationTokenRenewer.createTokens(new Text(renewer));
            LOG.info((Object)("Called MYDFS.getdelegationtoken " + (Object)((Object)result)));
            return result;
        }

        public Token<?>[] addDelegationTokens(String renewer, Credentials credentials) throws IOException {
            return new Token[0];
        }
    }

    private static class MyToken
    extends Token<DelegationTokenIdentifier> {
        public String status = "GOOD";
        public static final String CANCELED = "CANCELED";

        public MyToken(DelegationTokenIdentifier dtId1, MyDelegationTokenSecretManager sm) {
            super((TokenIdentifier)dtId1, (SecretManager)sm);
            this.setKind(KIND);
            this.status = "GOOD";
        }

        public boolean isCanceled() {
            return this.status.equals(CANCELED);
        }

        public void cancelToken() {
            this.status = CANCELED;
        }

        public long renew(Configuration conf) throws IOException, InterruptedException {
            return super.renew(conf);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(1024);
            sb.append("id=");
            String id = StringUtils.byteToHexString((byte[])this.getIdentifier());
            int idLen = id.length();
            sb.append(id.substring(idLen - 6));
            sb.append(";k=");
            sb.append(this.getKind());
            sb.append(";s=");
            sb.append(this.getService());
            return sb.toString();
        }
    }

    private static class MyDelegationTokenSecretManager
    extends DelegationTokenSecretManager {
        public MyDelegationTokenSecretManager(long delegationKeyUpdateInterval, long delegationTokenMaxLifetime, long delegationTokenRenewInterval, long delegationTokenRemoverScanInterval, FSNamesystem namesystem) {
            super(delegationKeyUpdateInterval, delegationTokenMaxLifetime, delegationTokenRenewInterval, delegationTokenRemoverScanInterval, namesystem);
        }

        public void logUpdateMasterKey(DelegationKey key) throws IOException {
        }
    }

    public static class Renewer
    extends TokenRenewer {
        private static int counter = 0;
        private static Token<?> lastRenewed = null;
        private static Token<?> tokenToRenewIn2Sec = null;
        private static boolean cancelled = false;

        private static void reset() {
            counter = 0;
            lastRenewed = null;
            tokenToRenewIn2Sec = null;
            cancelled = false;
        }

        public boolean handleKind(Text kind) {
            return KIND.equals((Object)kind);
        }

        public boolean isManaged(Token<?> token) throws IOException {
            return true;
        }

        public long renew(Token<?> t, Configuration conf) throws IOException {
            if (!(t instanceof MyToken)) {
                return System.currentTimeMillis() + 3000L;
            }
            MyToken token = (MyToken)t;
            if (token.isCanceled()) {
                throw new SecretManager.InvalidToken("token has been canceled");
            }
            lastRenewed = token;
            LOG.info((Object)("Called MYDFS.renewdelegationtoken " + (Object)((Object)token) + ";this dfs=" + ((Object)((Object)this)).hashCode() + ";c=" + ++counter));
            if (tokenToRenewIn2Sec == token) {
                LOG.info((Object)"RENEW in 2 seconds");
                tokenToRenewIn2Sec = null;
                return 2000L + System.currentTimeMillis();
            }
            return 86400000L + System.currentTimeMillis();
        }

        public void cancel(Token<?> t, Configuration conf) {
            cancelled = true;
            if (t instanceof MyToken) {
                MyToken token = (MyToken)t;
                LOG.info((Object)("Cancel token " + (Object)((Object)token)));
                token.cancelToken();
            }
        }
    }
}

