/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.security;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.JWTParser;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.Date;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import javax.net.ssl.HostnameVerifier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.math3.util.Pair;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.ssl.FileBasedKeyStoresFactory;
import org.apache.hadoop.security.ssl.KeyStoreTestUtil;
import org.apache.hadoop.security.ssl.SSLFactory;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.security.HopsworksRMAppSecurityActions;
import org.apache.hadoop.yarn.server.resourcemanager.security.JWTSecurityHandler;
import org.apache.hadoop.yarn.server.resourcemanager.security.MockJWTIssuer;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMAppSecurityActions;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMAppSecurityActionsFactory;
import org.apache.hadoop.yarn.server.resourcemanager.security.X509SecurityHandler;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequestBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

@Ignore
public class TestHopsworksRMAppSecurityActions {
    private static final Log LOG = LogFactory.getLog(TestHopsworksRMAppSecurityActions.class);
    private static final String HOPSWORKS_ENDPOINT = "https://bbc5.sics.se:64845";
    private static final String HOPSWORKS_USER = "agent@hops.io";
    private static final String HOPSWORKS_PASSWORD = "admin";
    private static final String HOPSWORKS_LOGIN_PATH = "/hopsworks-api/api/auth/service";
    private static final String O = "application_id";
    private static final String OU = "1";
    private static final String KEYSTORE_LOCATION = "/path/to/keystore";
    private static final String KEYSTORE_PASS = "12345";
    private static final String JWT_SUBJECT = "ProjectA1__Flock";
    private static String classPath;
    private static MockJWTIssuer jwtIssuer;
    private Path sslServerPath;
    private Configuration conf;
    private Configuration sslServer;
    @Rule
    public final ExpectedException rule = ExpectedException.none();

    @BeforeClass
    public static void beforeClass() throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        classPath = KeyStoreTestUtil.getClasspathDir(TestHopsworksRMAppSecurityActions.class);
        byte[] jwtIssuerSecret = new byte[32];
        Random rand = new Random();
        rand.nextBytes(jwtIssuerSecret);
        jwtIssuer = new MockJWTIssuer(jwtIssuerSecret);
    }

    @Before
    public void beforeTest() throws Exception {
        RMAppSecurityActionsFactory.getInstance().clear();
        this.conf = new Configuration();
        String sslConfFilename = TestHopsworksRMAppSecurityActions.class.getSimpleName() + ".ssl-server.xml";
        this.sslServerPath = Paths.get(classPath, sslConfFilename);
        Pair<String, String[]> jwtResponse = this.loginAndGetJWT();
        this.sslServer = new Configuration(false);
        this.sslServer.set(YarnConfiguration.RM_JWT_MASTER_TOKEN, (String)jwtResponse.getFirst());
        for (int i = 0; i < ((String[])jwtResponse.getSecond()).length; ++i) {
            String renewalConfKey = String.format(YarnConfiguration.RM_JWT_RENEW_TOKEN_PATTERN, i);
            this.sslServer.set(renewalConfKey, ((String[])jwtResponse.getSecond())[i]);
        }
        this.sslServer.set(FileBasedKeyStoresFactory.resolvePropertyName((SSLFactory.Mode)SSLFactory.Mode.SERVER, (String)"ssl.{0}.keystore.location"), KEYSTORE_LOCATION);
        this.sslServer.set(FileBasedKeyStoresFactory.resolvePropertyName((SSLFactory.Mode)SSLFactory.Mode.SERVER, (String)"ssl.{0}.keystore.password"), KEYSTORE_PASS);
        KeyStoreTestUtil.saveConfig((File)this.sslServerPath.toFile(), (Configuration)this.sslServer);
        this.conf.set("hadoop.ssl.server.conf", sslConfFilename);
        this.conf.set(YarnConfiguration.HOPS_HOPSWORKS_HOST_KEY, HOPSWORKS_ENDPOINT);
        this.conf.set(YarnConfiguration.HOPS_RM_SECURITY_ACTOR_KEY, "org.apache.hadoop.yarn.server.resourcemanager.security.DevHopsworksRMAppSecurityActions");
        this.conf.setBoolean("ipc.server.ssl.enabled", true);
        this.conf.setBoolean(YarnConfiguration.RM_JWT_ENABLED, true);
    }

    @After
    public void afterTest() throws Exception {
        RMAppSecurityActionsFactory.getInstance().getActor(this.conf).destroy();
        if (this.sslServerPath != null) {
            this.sslServerPath.toFile().delete();
        }
    }

    @Test
    public void testSign() throws Exception {
        PKCS10CertificationRequest csr = this.generateCSR(UUID.randomUUID().toString());
        RMAppSecurityActions actor = RMAppSecurityActionsFactory.getInstance().getActor(this.conf);
        X509SecurityHandler.CertificateBundle singedBundle = actor.sign(csr);
        Assert.assertNotNull((Object)singedBundle);
    }

    @Test
    public void testRevoke() throws Exception {
        String cn = UUID.randomUUID().toString();
        PKCS10CertificationRequest csr = this.generateCSR(cn);
        RMAppSecurityActions actor = RMAppSecurityActionsFactory.getInstance().getActor(this.conf);
        actor.sign(csr);
        int response = actor.revoke(cn + "__" + O + "__" + OU);
        Assert.assertEquals((long)200L, (long)response);
    }

    private PKCS10CertificationRequest generateCSR(String cn) throws Exception {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA", "BC");
        keyPairGenerator.initialize(1024);
        KeyPair keyPair = keyPairGenerator.genKeyPair();
        X500NameBuilder x500NameBuilder = new X500NameBuilder(BCStyle.INSTANCE);
        x500NameBuilder.addRDN(BCStyle.CN, cn);
        x500NameBuilder.addRDN(BCStyle.O, O);
        x500NameBuilder.addRDN(BCStyle.OU, OU);
        X500Name x500Name = x500NameBuilder.build();
        JcaPKCS10CertificationRequestBuilder csrBuilder = new JcaPKCS10CertificationRequestBuilder(x500Name, keyPair.getPublic());
        return csrBuilder.build(new JcaContentSignerBuilder("SHA256withRSA").setProvider("BC").build(keyPair.getPrivate()));
    }

    @Test
    public void testGenerateJWT() throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1);
        JWTSecurityHandler.JWTMaterialParameter jwtParam = this.createJWTParameter(appId);
        RMAppSecurityActions actor = RMAppSecurityActionsFactory.getInstance().getActor(this.conf);
        String jwt = actor.generateJWT(jwtParam);
        Assert.assertNotNull((Object)jwt);
        String[] tokenizedSubject = JWT_SUBJECT.split("__");
        JWT decoded = JWTParser.parse((String)jwt);
        String subject = decoded.getJWTClaimsSet().getSubject();
        Assert.assertEquals((Object)tokenizedSubject[1], (Object)subject);
        appId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)2);
        jwtParam = new JWTSecurityHandler.JWTMaterialParameter(appId, "dorothy");
        jwtParam.setRenewable(false);
        Instant now = Instant.now();
        Instant expiresAt = now.plus(10L, ChronoUnit.MINUTES);
        jwtParam.setExpirationDate(expiresAt);
        jwtParam.setValidNotBefore(now);
        jwtParam.setAudiences(new String[]{"job"});
        jwt = actor.generateJWT(jwtParam);
        decoded = JWTParser.parse((String)jwt);
        subject = decoded.getJWTClaimsSet().getSubject();
        Assert.assertEquals((Object)"dorothy", (Object)subject);
    }

    @Test
    public void testInvalidateJWT() throws Exception {
        String signingKeyName = "lala";
        RMAppSecurityActions actor = RMAppSecurityActionsFactory.getInstance().getActor(this.conf);
        actor.invalidateJWT(signingKeyName);
    }

    @Test
    public void testGenerateJWTSameSigningKeyShouldFail() throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1);
        JWTSecurityHandler.JWTMaterialParameter jwtParam = this.createJWTParameter(appId);
        RMAppSecurityActions actor = RMAppSecurityActionsFactory.getInstance().getActor(this.conf);
        actor.generateJWT(jwtParam);
        this.rule.expect(IOException.class);
        actor.generateJWT(jwtParam);
    }

    @Test
    public void testGenerateJWTInvalidateGenerate() throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1);
        JWTSecurityHandler.JWTMaterialParameter jwtParam = this.createJWTParameter(appId);
        RMAppSecurityActions actor = RMAppSecurityActionsFactory.getInstance().getActor(this.conf);
        String jwt0 = actor.generateJWT(jwtParam);
        Assert.assertNotNull((Object)jwt0);
        actor.invalidateJWT(appId.toString());
        String jwt1 = actor.generateJWT(jwtParam);
        Assert.assertNotEquals((Object)jwt0, (Object)jwt1);
    }

    @Test
    public void testRenewJWT() throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1);
        JWTSecurityHandler.JWTMaterialParameter jwtParam0 = this.createJWTParameter(appId, 2L, ChronoUnit.SECONDS);
        RMAppSecurityActions actor = RMAppSecurityActionsFactory.getInstance().getActor(this.conf);
        String jwt0 = actor.generateJWT(jwtParam0);
        TimeUnit.SECONDS.sleep(2L);
        JWTSecurityHandler.JWTMaterialParameter jwtParam1 = this.createJWTParameter(appId);
        jwtParam1.setToken(jwt0);
        String jwt1 = actor.renewJWT(jwtParam1);
        Assert.assertNotNull((Object)jwt1);
        Assert.assertNotEquals((Object)jwt0, (Object)jwt1);
        LOG.info((Object)jwt0);
        LOG.info((Object)jwt1);
    }

    private JWTSecurityHandler.JWTMaterialParameter createJWTParameter(ApplicationId appId) {
        return this.createJWTParameter(appId, 10L, ChronoUnit.MINUTES);
    }

    private JWTSecurityHandler.JWTMaterialParameter createJWTParameter(ApplicationId appId, long amountToAdd, TemporalUnit unit) {
        JWTSecurityHandler.JWTMaterialParameter jwtParam = new JWTSecurityHandler.JWTMaterialParameter(appId, JWT_SUBJECT);
        jwtParam.setRenewable(false);
        Instant now = Instant.now();
        Instant expiresAt = now.plus(amountToAdd, unit);
        jwtParam.setExpirationDate(expiresAt);
        jwtParam.setValidNotBefore(now);
        jwtParam.setAudiences(new String[]{"job"});
        return jwtParam;
    }

    @Test
    public void testConfUpdate() throws Exception {
        LocalDateTime now = LocalDateTime.now();
        Date nbf = Date.from(now.atZone(ZoneId.systemDefault()).toInstant());
        LocalDateTime expiration = now.plus(10L, ChronoUnit.MINUTES);
        Date expirationDate = Date.from(expiration.atZone(ZoneId.systemDefault()).toInstant());
        JWTClaimsSet masterClaims = new JWTClaimsSet();
        masterClaims.setSubject("master_token");
        masterClaims.setExpirationTime(expirationDate);
        masterClaims.setNotBeforeTime(nbf);
        String newMasterToken = jwtIssuer.generate(masterClaims);
        Assert.assertNotNull((Object)newMasterToken);
        String[] newRenewalTokens = new String[5];
        JWTClaimsSet renewClaims = new JWTClaimsSet();
        renewClaims.setSubject("renew_token");
        renewClaims.setExpirationTime(expirationDate);
        renewClaims.setNotBeforeTime(nbf);
        for (int i = 0; i < newRenewalTokens.length; ++i) {
            String renewToken = jwtIssuer.generate(renewClaims);
            Assert.assertNotNull((Object)renewToken);
            newRenewalTokens[i] = renewToken;
        }
        TestingHopsworksActions actor = new TestingHopsworksActions(newMasterToken, expirationDate, newRenewalTokens);
        ((Configurable)actor).setConf(this.conf);
        actor.init();
        TimeUnit.MILLISECONDS.sleep(500L);
        Configuration sslConf = new Configuration();
        sslConf.addResource(this.conf.get("hadoop.ssl.server.conf"));
        String newMasterTokenConf = sslConf.get(YarnConfiguration.RM_JWT_MASTER_TOKEN, "");
        Assert.assertEquals((Object)newMasterToken, (Object)newMasterTokenConf);
        for (int i = 0; i < newRenewalTokens.length; ++i) {
            String confKey = String.format(YarnConfiguration.RM_JWT_RENEW_TOKEN_PATTERN, i);
            String newRenewalToken = sslConf.get(confKey, "");
            Assert.assertEquals((Object)newRenewalTokens[i], (Object)newRenewalToken);
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss");
        Assert.assertEquals((Object)expiration.format(formatter), (Object)((HopsworksRMAppSecurityActions)actor).getMasterTokenExpiration().format(formatter));
        actor.destroy();
    }

    @Test
    public void testServiceJWTRenewalRetry() throws Exception {
        LocalDateTime expiration = LocalDateTime.now().plus(10L, ChronoUnit.MINUTES);
        Date expirationDate = Date.from(expiration.atZone(ZoneId.systemDefault()).toInstant());
        JWTClaimsSet claims = new JWTClaimsSet();
        claims.setSubject("test");
        claims.setExpirationTime(expirationDate);
        String newMasterToken = jwtIssuer.generate(claims);
        String[] renewTokens = new String[5];
        for (int i = 0; i < renewTokens.length; ++i) {
            renewTokens[i] = jwtIssuer.generate(claims);
        }
        FailingTestHopsworksActions actor = new FailingTestHopsworksActions(newMasterToken, expirationDate, renewTokens);
        ((Configurable)actor).setConf(this.conf);
        actor.init();
        int secondsWaited = 0;
        while (!actor.succeedRenewing && secondsWaited++ < 10) {
            TimeUnit.SECONDS.sleep(1L);
        }
        Assert.assertTrue((boolean)actor.succeedRenewing);
        Assert.assertTrue((actor.usedOneTimeTokens.size() > 1 ? 1 : 0) != 0);
        actor.destroy();
    }

    private Pair<String, String[]> loginAndGetJWT() throws Exception {
        try (CloseableHttpClient client = null;){
            SSLContextBuilder sslContextBuilder = new SSLContextBuilder();
            sslContextBuilder.loadTrustMaterial(new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                    return true;
                }
            });
            SSLConnectionSocketFactory sslSocketFactory = new SSLConnectionSocketFactory(sslContextBuilder.build(), (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            client = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslSocketFactory).build();
            URL loginURL = new URL(new URL(HOPSWORKS_ENDPOINT), HOPSWORKS_LOGIN_PATH);
            HttpUriRequest login = RequestBuilder.post().setUri(loginURL.toURI()).addParameter("email", HOPSWORKS_USER).addParameter("password", HOPSWORKS_PASSWORD).build();
            CloseableHttpResponse response = client.execute(login);
            Assert.assertNotNull((Object)response);
            Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
            Header[] authHeaders = response.getHeaders("Authorization");
            String masterJWT = null;
            for (Header h : authHeaders) {
                Matcher matcher = HopsworksRMAppSecurityActions.JWT_PATTERN.matcher(h.getValue());
                if (!matcher.matches()) continue;
                masterJWT = matcher.group(1);
            }
            JsonParser jsonParser = new JsonParser();
            JsonObject json = jsonParser.parse(EntityUtils.toString((HttpEntity)response.getEntity())).getAsJsonObject();
            JsonArray array = json.getAsJsonArray("renewTokens");
            String[] renewTokens = new String[array.size()];
            boolean renewalTokensFound = false;
            for (int i = 0; i < renewTokens.length; ++i) {
                renewTokens[i] = array.get(i).getAsString();
                renewalTokensFound = true;
            }
            if (masterJWT != null && renewalTokensFound) {
                Pair pair = new Pair((Object)masterJWT, (Object)renewTokens);
                return pair;
            }
            throw new IOException("Could not get JWT from Hopsworks");
        }
    }

    private class FailingTestHopsworksActions
    extends TestingHopsworksActions {
        private int failures;
        private boolean succeedRenewing;
        private Set<String> usedOneTimeTokens;

        public FailingTestHopsworksActions(String newMasterToken, Date expiresAt, String[] newRenewTokens) throws MalformedURLException, GeneralSecurityException {
            super(newMasterToken, expiresAt, newRenewTokens);
            this.failures = 0;
            this.succeedRenewing = false;
            this.usedOneTimeTokens = new HashSet<String>();
        }

        @Override
        protected HopsworksRMAppSecurityActions.ServiceTokenDTO renewServiceJWT(String token, String oneTimeToken, LocalDateTime expiresAt, LocalDateTime notBefore) throws URISyntaxException, IOException, GeneralSecurityException {
            this.usedOneTimeTokens.add(oneTimeToken);
            if (this.failures++ < 3) {
                throw new IOException("OOoops");
            }
            this.succeedRenewing = true;
            HopsworksRMAppSecurityActions.JWTDTO jwt = new HopsworksRMAppSecurityActions.JWTDTO((HopsworksRMAppSecurityActions)this);
            jwt.setToken(this.newMasterToken);
            jwt.setExpiresAt(this.expiresAt);
            jwt.setNbf(Date.from(notBefore.atZone(ZoneId.systemDefault()).toInstant()));
            HopsworksRMAppSecurityActions.ServiceTokenDTO serviceTokenResponse = new HopsworksRMAppSecurityActions.ServiceTokenDTO((HopsworksRMAppSecurityActions)this);
            serviceTokenResponse.setJwt(jwt);
            serviceTokenResponse.setRenewTokens(this.newRenewalTokens);
            return serviceTokenResponse;
        }
    }

    private class TestingHopsworksActions
    extends HopsworksRMAppSecurityActions {
        final String newMasterToken;
        final Date expiresAt;
        final String[] newRenewalTokens;
        private boolean renewed = false;

        public TestingHopsworksActions(String newMasterToken, Date expiresAt, String[] newRenewalTokens) throws MalformedURLException, GeneralSecurityException {
            this.newMasterToken = newMasterToken;
            this.expiresAt = expiresAt;
            this.newRenewalTokens = newRenewalTokens;
        }

        protected HopsworksRMAppSecurityActions.ServiceTokenDTO renewServiceJWT(String token, String oneTimeToken, LocalDateTime expiresAt, LocalDateTime notBefore) throws URISyntaxException, IOException, GeneralSecurityException {
            HopsworksRMAppSecurityActions.JWTDTO jwt = new HopsworksRMAppSecurityActions.JWTDTO((HopsworksRMAppSecurityActions)this);
            jwt.setToken(this.newMasterToken);
            jwt.setExpiresAt(this.expiresAt);
            jwt.setNbf(Date.from(notBefore.atZone(ZoneId.systemDefault()).toInstant()));
            HopsworksRMAppSecurityActions.ServiceTokenDTO serviceTokenResponse = new HopsworksRMAppSecurityActions.ServiceTokenDTO((HopsworksRMAppSecurityActions)this);
            serviceTokenResponse.setJwt(jwt);
            serviceTokenResponse.setRenewTokens(this.newRenewalTokens);
            return serviceTokenResponse;
        }

        protected void invalidateServiceJWT(String token2invalidate) throws URISyntaxException, IOException, GeneralSecurityException {
        }

        protected boolean isTime2Renew(LocalDateTime now, LocalDateTime expiration) {
            if (!this.renewed) {
                this.renewed = true;
                return true;
            }
            return false;
        }
    }
}

