/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.servlet.GuiceFilter;
import com.google.inject.servlet.GuiceServletContextListener;
import com.google.inject.servlet.ServletModule;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.guice.spi.container.servlet.GuiceContainer;
import com.sun.jersey.test.framework.WebAppDescriptor;
import io.hops.util.DBUtility;
import io.hops.util.RMStorageFactory;
import io.hops.util.YarnAPIStorageFactory;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.MediaType;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.NodeLabel;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.JAXBContextResolver;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RMWebServices;
import org.apache.hadoop.yarn.webapp.GenericExceptionHandler;
import org.apache.hadoop.yarn.webapp.JerseyTestBase;
import org.apache.hadoop.yarn.webapp.WebServicesTestUtils;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class TestRMWebServicesForCSWithPartitions
extends JerseyTestBase {
    private static final String DEFAULT_PARTITION = "";
    private static final String CAPACITIES = "capacities";
    private static final String RESOURCE_USAGES_BY_PARTITION = "resourceUsagesByPartition";
    private static final String QUEUE_CAPACITIES_BY_PARTITION = "queueCapacitiesByPartition";
    private static final String QUEUE_C = "Qc";
    private static final String LEAF_QUEUE_C1 = "Qc1";
    private static final String LEAF_QUEUE_C2 = "Qc2";
    private static final String QUEUE_B = "Qb";
    private static final String QUEUE_A = "Qa";
    private static final String LABEL_LY = "Ly";
    private static final String LABEL_LX = "Lx";
    private static final ImmutableSet<String> CLUSTER_LABELS = ImmutableSet.of((Object)"Lx", (Object)"Ly", (Object)"");
    private static MockRM rm;
    private CapacitySchedulerConfiguration csConf;
    private YarnConfiguration conf;
    private Injector injector = Guice.createInjector((Module[])new Module[]{new ServletModule(){

        protected void configureServlets() {
            try {
                this.bind(JAXBContextResolver.class);
                this.bind(RMWebServices.class);
                this.bind(GenericExceptionHandler.class);
                TestRMWebServicesForCSWithPartitions.this.csConf = new CapacitySchedulerConfiguration();
                TestRMWebServicesForCSWithPartitions.setupQueueConfiguration(TestRMWebServicesForCSWithPartitions.this.csConf, rm);
                TestRMWebServicesForCSWithPartitions.this.conf = new YarnConfiguration((Configuration)TestRMWebServicesForCSWithPartitions.this.csConf);
                TestRMWebServicesForCSWithPartitions.this.conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
                RMStorageFactory.setConfiguration((Configuration)TestRMWebServicesForCSWithPartitions.this.conf);
                YarnAPIStorageFactory.setConfiguration((Configuration)TestRMWebServicesForCSWithPartitions.this.conf);
                DBUtility.InitializeDB();
                rm = new MockRM((Configuration)TestRMWebServicesForCSWithPartitions.this.conf);
                HashSet<NodeLabel> labels = new HashSet<NodeLabel>();
                labels.add(NodeLabel.newInstance((String)TestRMWebServicesForCSWithPartitions.LABEL_LX));
                labels.add(NodeLabel.newInstance((String)TestRMWebServicesForCSWithPartitions.LABEL_LY));
                try {
                    RMNodeLabelsManager nodeLabelManager = rm.getRMContext().getNodeLabelManager();
                    nodeLabelManager.addToCluserNodeLabels(labels);
                }
                catch (Exception e) {
                    Assert.fail();
                }
                this.bind(ResourceManager.class).toInstance((Object)rm);
                this.serve("/*", new String[0]).with(GuiceContainer.class);
            }
            catch (IOException ex) {
                Logger.getLogger(TestRMWebServicesForCSWithPartitions.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }});

    private static void setupQueueConfiguration(CapacitySchedulerConfiguration conf, ResourceManager rm) {
        conf.setQueues("root", new String[]{QUEUE_A, QUEUE_B, QUEUE_C});
        String interMediateQueueC = "root.Qc";
        conf.setQueues(interMediateQueueC, new String[]{LEAF_QUEUE_C1, LEAF_QUEUE_C2});
        conf.setCapacityByLabel("root", LABEL_LX, 100.0f);
        conf.setCapacityByLabel("root", LABEL_LY, 100.0f);
        String leafQueueA = "root.Qa";
        conf.setCapacity(leafQueueA, 30.0f);
        conf.setMaximumCapacity(leafQueueA, 50.0f);
        String leafQueueB = "root.Qb";
        conf.setCapacity(leafQueueB, 30.0f);
        conf.setMaximumCapacity(leafQueueB, 50.0f);
        conf.setCapacity(interMediateQueueC, 40.0f);
        conf.setMaximumCapacity(interMediateQueueC, 50.0f);
        String leafQueueC1 = interMediateQueueC + "." + LEAF_QUEUE_C1;
        conf.setCapacity(leafQueueC1, 50.0f);
        conf.setMaximumCapacity(leafQueueC1, 60.0f);
        String leafQueueC2 = interMediateQueueC + "." + LEAF_QUEUE_C2;
        conf.setCapacity(leafQueueC2, 50.0f);
        conf.setMaximumCapacity(leafQueueC2, 70.0f);
        conf.setAccessibleNodeLabels(leafQueueA, (Set)ImmutableSet.of((Object)DEFAULT_PARTITION));
        conf.setAccessibleNodeLabels(leafQueueB, (Set)ImmutableSet.of((Object)LABEL_LX));
        conf.setAccessibleNodeLabels(interMediateQueueC, (Set)ImmutableSet.of((Object)LABEL_LX, (Object)LABEL_LY));
        conf.setAccessibleNodeLabels(leafQueueC1, (Set)ImmutableSet.of((Object)LABEL_LX, (Object)LABEL_LY));
        conf.setAccessibleNodeLabels(leafQueueC2, (Set)ImmutableSet.of((Object)LABEL_LX, (Object)LABEL_LY));
        conf.setDefaultNodeLabelExpression(leafQueueB, LABEL_LX);
        conf.setDefaultNodeLabelExpression(leafQueueC1, LABEL_LX);
        conf.setDefaultNodeLabelExpression(leafQueueC2, LABEL_LY);
        conf.setCapacityByLabel(leafQueueB, LABEL_LX, 30.0f);
        conf.setCapacityByLabel(interMediateQueueC, LABEL_LX, 70.0f);
        conf.setCapacityByLabel(leafQueueC1, LABEL_LX, 40.0f);
        conf.setCapacityByLabel(leafQueueC2, LABEL_LX, 60.0f);
        conf.setCapacityByLabel(interMediateQueueC, LABEL_LY, 100.0f);
        conf.setCapacityByLabel(leafQueueC1, LABEL_LY, 50.0f);
        conf.setCapacityByLabel(leafQueueC2, LABEL_LY, 50.0f);
        conf.setMaximumCapacityByLabel(leafQueueC1, LABEL_LY, 75.0f);
        conf.setMaximumCapacityByLabel(leafQueueC2, LABEL_LY, 75.0f);
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
    }

    public TestRMWebServicesForCSWithPartitions() {
        super(new WebAppDescriptor.Builder(new String[]{"org.apache.hadoop.yarn.server.resourcemanager.webapp"}).contextListenerClass(GuiceServletConfig.class).filterClass(GuiceFilter.class).contextPath("jersey-guice-filter").servletPath("/").build());
    }

    @Test
    public void testSchedulerPartitions() throws JSONException, Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("scheduler").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        this.verifySchedulerInfoJson(json);
    }

    @Test
    public void testSchedulerPartitionsSlash() throws JSONException, Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("scheduler/").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        this.verifySchedulerInfoJson(json);
    }

    @Test
    public void testSchedulerPartitionsDefault() throws JSONException, Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("scheduler").get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        this.verifySchedulerInfoJson(json);
    }

    @Test
    public void testSchedulerPartitionsXML() throws JSONException, Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("cluster").path("scheduler").accept(new String[]{"application/xml"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_XML_TYPE, (Object)response.getType());
        String xml = (String)response.getEntity(String.class);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        InputSource is = new InputSource();
        is.setCharacterStream(new StringReader(xml));
        Document dom = db.parse(is);
        this.verifySchedulerInfoXML(dom);
    }

    private void verifySchedulerInfoXML(Document dom) throws Exception {
        NodeList scheduler = dom.getElementsByTagName("scheduler");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)scheduler.getLength());
        NodeList schedulerInfo = dom.getElementsByTagName("schedulerInfo");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)schedulerInfo.getLength());
        for (int i = 0; i < schedulerInfo.getLength(); ++i) {
            Element element = (Element)schedulerInfo.item(i);
            NodeList children = element.getChildNodes();
            for (int j = 0; j < children.getLength(); ++j) {
                int k;
                Element schedulerInfoElem = (Element)children.item(j);
                if (schedulerInfoElem.getTagName().equals("queues")) {
                    NodeList qListInfos = schedulerInfoElem.getChildNodes();
                    block12: for (k = 0; k < qListInfos.getLength(); ++k) {
                        String queue;
                        Element qElem2 = (Element)qListInfos.item(k);
                        switch (queue = WebServicesTestUtils.getXmlString((Element)qElem2, (String)"queueName")) {
                            case "Qa": {
                                this.verifyQueueAInfoXML(qElem2);
                                continue block12;
                            }
                            case "Qb": {
                                this.verifyQueueBInfoXML(qElem2);
                                continue block12;
                            }
                            case "Qc": {
                                this.verifyQueueCInfoXML(qElem2);
                                continue block12;
                            }
                            default: {
                                Assert.fail((String)("Unexpected queue" + queue));
                            }
                        }
                    }
                    continue;
                }
                if (!schedulerInfoElem.getTagName().equals(CAPACITIES)) continue;
                NodeList capacitiesListInfos = schedulerInfoElem.getChildNodes();
                Assert.assertEquals((String)"incorrect number of partitions", (long)3L, (long)capacitiesListInfos.getLength());
                for (k = 0; k < capacitiesListInfos.getLength(); ++k) {
                    Element partitionCapacitiesInfo = (Element)capacitiesListInfos.item(k);
                    String partitionName = WebServicesTestUtils.getXmlString((Element)partitionCapacitiesInfo, (String)"partitionName");
                    Assert.assertTrue((String)"invalid PartitionCapacityInfo", (boolean)CLUSTER_LABELS.contains((Object)partitionName));
                    this.verifyPartitionCapacityInfoXML(partitionCapacitiesInfo, 100.0f, 0.0f, 100.0f, 100.0f, 0.0f, 100.0f);
                }
            }
        }
    }

    private void verifyQueueAInfoXML(Element queueElem) {
        NodeList children = queueElem.getChildNodes();
        for (int j = 0; j < children.getLength(); ++j) {
            Element queueChildElem = (Element)children.item(j);
            if (queueChildElem.getTagName().equals(CAPACITIES)) {
                NodeList capacitiesListInfos = queueChildElem.getChildNodes();
                Assert.assertEquals((String)"incorrect number of partitions", (long)1L, (long)capacitiesListInfos.getLength());
                Element partitionCapacitiesInfo = (Element)capacitiesListInfos.item(0);
                String partitionName = WebServicesTestUtils.getXmlString((Element)partitionCapacitiesInfo, (String)"partitionName");
                Assert.assertTrue((String)"invalid PartitionCapacityInfo", (boolean)partitionName.isEmpty());
                this.verifyPartitionCapacityInfoXML(partitionCapacitiesInfo, 30.0f, 0.0f, 50.0f, 30.0f, 0.0f, 50.0f);
                continue;
            }
            if (!queueChildElem.getTagName().equals("resources")) continue;
            this.verifyResourceUsageInfoXML(queueChildElem);
        }
    }

    private void verifyQueueBInfoXML(Element queueElem) {
        Assert.assertEquals((String)"Invalid default Label expression", (Object)LABEL_LX, (Object)WebServicesTestUtils.getXmlString((Element)queueElem, (String)"defaultNodeLabelExpression"));
        NodeList children = queueElem.getChildNodes();
        for (int j = 0; j < children.getLength(); ++j) {
            Element queueChildElem = (Element)children.item(j);
            if (queueChildElem.getTagName().equals(CAPACITIES)) {
                NodeList capacitiesListInfos = queueChildElem.getChildNodes();
                Assert.assertEquals((String)"incorrect number of partitions", (long)2L, (long)capacitiesListInfos.getLength());
                block9: for (int k = 0; k < capacitiesListInfos.getLength(); ++k) {
                    String partitionName;
                    Element partitionCapacitiesInfo = (Element)capacitiesListInfos.item(k);
                    switch (partitionName = WebServicesTestUtils.getXmlString((Element)partitionCapacitiesInfo, (String)"partitionName")) {
                        case "Lx": {
                            this.verifyPartitionCapacityInfoXML(partitionCapacitiesInfo, 30.0f, 0.0f, 100.0f, 30.0f, 0.0f, 100.0f);
                            continue block9;
                        }
                        case "": {
                            this.verifyPartitionCapacityInfoXML(partitionCapacitiesInfo, 30.0f, 0.0f, 50.0f, 30.0f, 0.0f, 50.0f);
                            continue block9;
                        }
                        default: {
                            Assert.fail((String)("Unexpected partition" + partitionName));
                        }
                    }
                }
                continue;
            }
            if (!queueChildElem.getTagName().equals("resources")) continue;
            this.verifyResourceUsageInfoXML(queueChildElem);
        }
        Assert.assertEquals((String)"Node Labels are not matching", (Object)LABEL_LX, (Object)WebServicesTestUtils.getXmlString((Element)queueElem, (String)"nodeLabels"));
    }

    private void verifyQueueCInfoXML(Element queueElem) {
        NodeList children = queueElem.getChildNodes();
        for (int j = 0; j < children.getLength(); ++j) {
            Element queueChildElem = (Element)children.item(j);
            if (queueChildElem.getTagName().equals(CAPACITIES)) {
                this.verifyQcCapacitiesInfoXML(queueChildElem, 70.0f, 100.0f, 70.0f, 100.0f, 100.0f, 100.0f, 100.0f, 100.0f, 40.0f, 50.0f, 40.0f, 50.0f);
                continue;
            }
            if (queueChildElem.getTagName().equals("resources")) {
                this.verifyResourceUsageInfoXML(queueChildElem);
                continue;
            }
            if (!queueChildElem.getTagName().equals("queues")) continue;
            NodeList qListInfos = queueChildElem.getChildNodes();
            block9: for (int k = 0; k < qListInfos.getLength(); ++k) {
                String queue;
                Element qElem2 = (Element)qListInfos.item(k);
                switch (queue = WebServicesTestUtils.getXmlString((Element)qElem2, (String)"queueName")) {
                    case "Qc1": {
                        Assert.assertEquals((String)"Invalid default Label expression", (Object)LABEL_LX, (Object)WebServicesTestUtils.getXmlString((Element)qElem2, (String)"defaultNodeLabelExpression"));
                        NodeList queuec1Children = qElem2.getChildNodes();
                        for (int l = 0; l < queuec1Children.getLength(); ++l) {
                            Element queueC1ChildElem = (Element)queuec1Children.item(l);
                            if (!queueC1ChildElem.getTagName().equals(CAPACITIES)) continue;
                            this.verifyQcCapacitiesInfoXML(queueC1ChildElem, 40.0f, 100.0f, 28.0f, 100.0f, 50.0f, 75.0f, 50.0f, 75.0f, 50.0f, 60.0f, 20.0f, 30.0f);
                        }
                        continue block9;
                    }
                    case "Qc2": {
                        Assert.assertEquals((String)"Invalid default Label expression", (Object)LABEL_LY, (Object)WebServicesTestUtils.getXmlString((Element)qElem2, (String)"defaultNodeLabelExpression"));
                        NodeList queuec2Children = qElem2.getChildNodes();
                        for (int l = 0; l < queuec2Children.getLength(); ++l) {
                            Element queueC2ChildElem = (Element)queuec2Children.item(l);
                            if (!queueC2ChildElem.getTagName().equals(CAPACITIES)) continue;
                            this.verifyQcCapacitiesInfoXML(queueC2ChildElem, 60.0f, 100.0f, 42.0f, 100.0f, 50.0f, 75.0f, 50.0f, 75.0f, 50.0f, 70.0f, 20.0f, 35.0f);
                        }
                        continue block9;
                    }
                    default: {
                        Assert.fail((String)("Unexpected queue" + queue));
                    }
                }
            }
        }
    }

    private void verifyQcCapacitiesInfoXML(Element partitionCapacitiesElem, float lxCaps, float lxMaxCaps, float lxAbsCaps, float lxAbsMaxCaps, float lyCaps, float lyMaxCaps, float lyAbsCaps, float lyAbsMaxCaps, float defCaps, float defMaxCaps, float defAbsCaps, float defAbsMaxCaps) {
        NodeList capacitiesListInfos = partitionCapacitiesElem.getChildNodes();
        Assert.assertEquals((String)"incorrect number of partitions", (long)3L, (long)capacitiesListInfos.getLength());
        block10: for (int k = 0; k < capacitiesListInfos.getLength(); ++k) {
            String partitionName;
            Element partitionCapacitiesInfo = (Element)capacitiesListInfos.item(k);
            switch (partitionName = WebServicesTestUtils.getXmlString((Element)partitionCapacitiesInfo, (String)"partitionName")) {
                case "Lx": {
                    this.verifyPartitionCapacityInfoXML(partitionCapacitiesInfo, lxCaps, 0.0f, lxMaxCaps, lxAbsCaps, 0.0f, lxAbsMaxCaps);
                    continue block10;
                }
                case "Ly": {
                    this.verifyPartitionCapacityInfoXML(partitionCapacitiesInfo, lyCaps, 0.0f, lyMaxCaps, lyAbsCaps, 0.0f, lyAbsMaxCaps);
                    continue block10;
                }
                case "": {
                    this.verifyPartitionCapacityInfoXML(partitionCapacitiesInfo, defCaps, 0.0f, defMaxCaps, defAbsCaps, 0.0f, defAbsMaxCaps);
                    continue block10;
                }
                default: {
                    Assert.fail((String)("Unexpected partition" + partitionName));
                }
            }
        }
    }

    private void verifyResourceUsageInfoXML(Element queueChildElem) {
        NodeList resourceUsageInfo = queueChildElem.getChildNodes();
        Assert.assertEquals((String)"incorrect number of partitions", (long)1L, (long)resourceUsageInfo.getLength());
        Element partitionResourceUsageInfo = (Element)resourceUsageInfo.item(0);
        String partitionName = WebServicesTestUtils.getXmlString((Element)partitionResourceUsageInfo, (String)"partitionName");
        Assert.assertTrue((String)"invalid PartitionCapacityInfo", (boolean)DEFAULT_PARTITION.equals(partitionName));
    }

    private void verifyPartitionCapacityInfoXML(Element partitionInfo, float capacity, float usedCapacity, float maxCapacity, float absoluteCapacity, float absoluteUsedCapacity, float absoluteMaxCapacity) {
        Assert.assertEquals((String)"capacity doesn't match", (float)capacity, (float)WebServicesTestUtils.getXmlFloat((Element)partitionInfo, (String)"capacity"), (float)0.001f);
        Assert.assertEquals((String)"capacity doesn't match", (float)usedCapacity, (float)WebServicesTestUtils.getXmlFloat((Element)partitionInfo, (String)"usedCapacity"), (float)0.001f);
        Assert.assertEquals((String)"capacity doesn't match", (float)maxCapacity, (float)WebServicesTestUtils.getXmlFloat((Element)partitionInfo, (String)"maxCapacity"), (float)0.001f);
        Assert.assertEquals((String)"capacity doesn't match", (float)absoluteCapacity, (float)WebServicesTestUtils.getXmlFloat((Element)partitionInfo, (String)"absoluteCapacity"), (float)0.001f);
        Assert.assertEquals((String)"capacity doesn't match", (float)absoluteUsedCapacity, (float)WebServicesTestUtils.getXmlFloat((Element)partitionInfo, (String)"absoluteUsedCapacity"), (float)0.001f);
        Assert.assertEquals((String)"capacity doesn't match", (float)absoluteMaxCapacity, (float)WebServicesTestUtils.getXmlFloat((Element)partitionInfo, (String)"absoluteMaxCapacity"), (float)0.001f);
    }

    private void verifySchedulerInfoJson(JSONObject json) throws JSONException, Exception {
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        JSONObject info = json.getJSONObject("scheduler");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)info.length());
        info = info.getJSONObject("schedulerInfo");
        Assert.assertEquals((String)"incorrect number of elements", (long)8L, (long)info.length());
        JSONObject capacitiesJsonObject = info.getJSONObject(CAPACITIES);
        JSONArray partitionsCapsArray = capacitiesJsonObject.getJSONArray(QUEUE_CAPACITIES_BY_PARTITION);
        Assert.assertEquals((String)"incorrect number of elements", (long)CLUSTER_LABELS.size(), (long)partitionsCapsArray.length());
        for (int i = 0; i < partitionsCapsArray.length(); ++i) {
            JSONObject partitionInfo = partitionsCapsArray.getJSONObject(i);
            String partitionName = partitionInfo.getString("partitionName");
            Assert.assertTrue((String)"Unknown partition received", (boolean)CLUSTER_LABELS.contains((Object)partitionName));
            this.verifyPartitionCapacityInfoJson(partitionInfo, 100.0f, 0.0f, 100.0f, 100.0f, 0.0f, 100.0f);
        }
        JSONObject jsonQueuesObject = info.getJSONObject("queues");
        JSONArray queuesArray = jsonQueuesObject.getJSONArray("queue");
        block19: for (int i = 0; i < queuesArray.length(); ++i) {
            JSONObject queueJson = queuesArray.getJSONObject(i);
            String queue = queueJson.getString("queueName");
            Assert.assertEquals((String)"Partition resourceInfo is wrong", (long)1L, (long)queueJson.getJSONObject("resources").getJSONArray(RESOURCE_USAGES_BY_PARTITION).length());
            JSONObject resourcesJsonObject = queueJson.getJSONObject("resources");
            JSONArray partitionsResourcesArray = resourcesJsonObject.getJSONArray(RESOURCE_USAGES_BY_PARTITION);
            Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)partitionsResourcesArray.length());
            capacitiesJsonObject = queueJson.getJSONObject(CAPACITIES);
            partitionsCapsArray = capacitiesJsonObject.getJSONArray(QUEUE_CAPACITIES_BY_PARTITION);
            JSONObject partitionInfo = null;
            String partitionName = null;
            switch (queue) {
                case "Qa": {
                    Assert.assertEquals((String)"incorrect number of partitions", (long)1L, (long)partitionsCapsArray.length());
                    partitionInfo = partitionsCapsArray.getJSONObject(0);
                    partitionName = partitionInfo.getString("partitionName");
                    this.verifyPartitionCapacityInfoJson(partitionInfo, 30.0f, 0.0f, 50.0f, 30.0f, 0.0f, 50.0f);
                    Assert.assertEquals((String)"incorrect number of elements", (long)6L, (long)partitionsResourcesArray.getJSONObject(0).length());
                    continue block19;
                }
                case "Qb": {
                    Assert.assertEquals((String)"Invalid default Label expression", (Object)LABEL_LX, (Object)queueJson.getString("defaultNodeLabelExpression"));
                    Assert.assertEquals((String)"incorrect number of elements", (long)6L, (long)partitionsResourcesArray.getJSONObject(0).length());
                    this.verifyAccesibleNodeLabels(queueJson, (Set<String>)ImmutableSet.of((Object)LABEL_LX));
                    Assert.assertEquals((String)"incorrect number of partitions", (long)2L, (long)partitionsCapsArray.length());
                    block20: for (int j = 0; j < partitionsCapsArray.length(); ++j) {
                        partitionInfo = partitionsCapsArray.getJSONObject(j);
                        switch (partitionName = partitionInfo.getString("partitionName")) {
                            case "Lx": {
                                this.verifyPartitionCapacityInfoJson(partitionInfo, 30.0f, 0.0f, 100.0f, 30.0f, 0.0f, 100.0f);
                                continue block20;
                            }
                            case "": {
                                this.verifyPartitionCapacityInfoJson(partitionInfo, 30.0f, 0.0f, 50.0f, 30.0f, 0.0f, 50.0f);
                                continue block20;
                            }
                            default: {
                                Assert.fail((String)("Unexpected partition" + partitionName));
                            }
                        }
                    }
                    continue block19;
                }
                case "Qc": {
                    this.verifyAccesibleNodeLabels(queueJson, (Set<String>)ImmutableSet.of((Object)LABEL_LX, (Object)LABEL_LY));
                    Assert.assertEquals((String)"incorrect number of elements", (long)4L, (long)partitionsResourcesArray.getJSONObject(0).length());
                    this.verifyQcPartitionsCapacityInfoJson(partitionsCapsArray, 70.0f, 100.0f, 70.0f, 100.0f, 100.0f, 100.0f, 100.0f, 100.0f, 40.0f, 50.0f, 40.0f, 50.0f);
                    this.verifySubQueuesOfQc(queueJson);
                    continue block19;
                }
                default: {
                    Assert.fail((String)("Unexpected queue" + queue));
                }
            }
        }
    }

    private void verifyAccesibleNodeLabels(JSONObject queueJson, Set<String> accesibleNodeLabels) throws JSONException {
        JSONArray nodeLabels = queueJson.getJSONArray("nodeLabels");
        Assert.assertEquals((String)"number of accessible Node Labels not matching", (long)accesibleNodeLabels.size(), (long)nodeLabels.length());
        for (int i = 0; i < nodeLabels.length(); ++i) {
            Assert.assertTrue((String)("Invalid accessible node label : " + nodeLabels.getString(i)), (boolean)accesibleNodeLabels.contains(nodeLabels.getString(i)));
        }
    }

    private void verifySubQueuesOfQc(JSONObject queueCJson) throws JSONException {
        JSONObject jsonQueuesObject = queueCJson.getJSONObject("queues");
        JSONArray queuesArray = jsonQueuesObject.getJSONArray("queue");
        block8: for (int i = 0; i < queuesArray.length(); ++i) {
            JSONObject queueJson = queuesArray.getJSONObject(i);
            String queue = queueJson.getString("queueName");
            JSONObject capacitiesJsonObject = queueJson.getJSONObject(CAPACITIES);
            JSONArray partitionsCapsArray = capacitiesJsonObject.getJSONArray(QUEUE_CAPACITIES_BY_PARTITION);
            switch (queue) {
                case "Qc1": {
                    this.verifyAccesibleNodeLabels(queueJson, (Set<String>)ImmutableSet.of((Object)LABEL_LX, (Object)LABEL_LY));
                    Assert.assertEquals((String)"Invalid default Label expression", (Object)LABEL_LX, (Object)queueJson.getString("defaultNodeLabelExpression"));
                    this.verifyQcPartitionsCapacityInfoJson(partitionsCapsArray, 40.0f, 100.0f, 28.0f, 100.0f, 50.0f, 75.0f, 50.0f, 75.0f, 50.0f, 60.0f, 20.0f, 30.0f);
                    continue block8;
                }
                case "Qc2": {
                    this.verifyAccesibleNodeLabels(queueJson, (Set<String>)ImmutableSet.of((Object)LABEL_LX, (Object)LABEL_LY));
                    Assert.assertEquals((String)"Invalid default Label expression", (Object)LABEL_LY, (Object)queueJson.getString("defaultNodeLabelExpression"));
                    this.verifyQcPartitionsCapacityInfoJson(partitionsCapsArray, 60.0f, 100.0f, 42.0f, 100.0f, 50.0f, 75.0f, 50.0f, 75.0f, 50.0f, 70.0f, 20.0f, 35.0f);
                    continue block8;
                }
                default: {
                    Assert.fail((String)("Unexpected queue" + queue));
                }
            }
        }
    }

    private void verifyQcPartitionsCapacityInfoJson(JSONArray partitionsCapsArray, float lxCaps, float lxMaxCaps, float lxAbsCaps, float lxAbsMaxCaps, float lyCaps, float lyMaxCaps, float lyAbsCaps, float lyAbsMaxCaps, float defCaps, float defMaxCaps, float defAbsCaps, float defAbsMaxCaps) throws JSONException {
        Assert.assertEquals((String)"incorrect number of partitions", (long)CLUSTER_LABELS.size(), (long)partitionsCapsArray.length());
        block10: for (int j = 0; j < partitionsCapsArray.length(); ++j) {
            String partitionName;
            JSONObject partitionInfo = partitionsCapsArray.getJSONObject(j);
            switch (partitionName = partitionInfo.getString("partitionName")) {
                case "Lx": {
                    this.verifyPartitionCapacityInfoJson(partitionInfo, lxCaps, 0.0f, lxMaxCaps, lxAbsCaps, 0.0f, lxAbsMaxCaps);
                    continue block10;
                }
                case "Ly": {
                    this.verifyPartitionCapacityInfoJson(partitionInfo, lyCaps, 0.0f, lyMaxCaps, lyAbsCaps, 0.0f, lyAbsMaxCaps);
                    continue block10;
                }
                case "": {
                    this.verifyPartitionCapacityInfoJson(partitionInfo, defCaps, 0.0f, defMaxCaps, defAbsCaps, 0.0f, defAbsMaxCaps);
                    continue block10;
                }
                default: {
                    Assert.fail((String)("Unexpected partition" + partitionName));
                }
            }
        }
    }

    private void verifyPartitionCapacityInfoJson(JSONObject partitionCapacityInfoJson, float capacity, float usedCapacity, float maxCapacity, float absoluteCapacity, float absoluteUsedCapacity, float absoluteMaxCapacity) throws JSONException {
        Assert.assertEquals((String)"capacity doesn't match", (float)capacity, (float)((float)partitionCapacityInfoJson.getDouble("capacity")), (float)0.001f);
        Assert.assertEquals((String)"capacity doesn't match", (float)usedCapacity, (float)((float)partitionCapacityInfoJson.getDouble("usedCapacity")), (float)0.001f);
        Assert.assertEquals((String)"capacity doesn't match", (float)maxCapacity, (float)((float)partitionCapacityInfoJson.getDouble("maxCapacity")), (float)0.001f);
        Assert.assertEquals((String)"capacity doesn't match", (float)absoluteCapacity, (float)((float)partitionCapacityInfoJson.getDouble("absoluteCapacity")), (float)0.001f);
        Assert.assertEquals((String)"capacity doesn't match", (float)absoluteUsedCapacity, (float)((float)partitionCapacityInfoJson.getDouble("absoluteUsedCapacity")), (float)0.001f);
        Assert.assertEquals((String)"capacity doesn't match", (float)absoluteMaxCapacity, (float)((float)partitionCapacityInfoJson.getDouble("absoluteMaxCapacity")), (float)0.001f);
    }

    public class GuiceServletConfig
    extends GuiceServletContextListener {
        protected Injector getInjector() {
            return TestRMWebServicesForCSWithPartitions.this.injector;
        }
    }
}

