/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.applicationsmanager;

import com.google.common.collect.Lists;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.ipc.CallerContext;
import org.apache.hadoop.yarn.MockApps;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationResourceUsageReport;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.LogAggregationStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.ReservationId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.server.api.protocolrecords.LogAggregationReport;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.util.Records;

@InterfaceAudience.Private
public abstract class MockAsm
extends MockApps {
    public static RMApp newApplication(int i) {
        final ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)MockAsm.newAppID((int)i), (int)0);
        Container masterContainer = (Container)Records.newRecord(Container.class);
        ContainerId containerId = ContainerId.newContainerId((ApplicationAttemptId)appAttemptId, (long)0L);
        masterContainer.setId(containerId);
        masterContainer.setNodeHttpAddress("node:port");
        final String user = MockAsm.newUserName();
        final String name = MockAsm.newAppName();
        final String queue = MockAsm.newQueue();
        final long start = 123456 + i * 1000;
        final long finish = 234567 + i * 1000;
        String type = "YARN";
        YarnApplicationState[] allStates = YarnApplicationState.values();
        final YarnApplicationState state = allStates[i % allStates.length];
        final int maxAppAttempts = i % 1000;
        return new ApplicationBase(){

            @Override
            public ApplicationId getApplicationId() {
                return appAttemptId.getApplicationId();
            }

            @Override
            public String getUser() {
                return user;
            }

            @Override
            public String getName() {
                return name;
            }

            @Override
            public String getApplicationType() {
                return "YARN";
            }

            @Override
            public String getQueue() {
                return queue;
            }

            @Override
            public long getStartTime() {
                return start;
            }

            @Override
            public long getFinishTime() {
                return finish;
            }

            @Override
            public String getTrackingUrl() {
                return null;
            }

            @Override
            public YarnApplicationState createApplicationState() {
                return state;
            }

            @Override
            public StringBuilder getDiagnostics() {
                return new StringBuilder();
            }

            @Override
            public float getProgress() {
                return (float)Math.random();
            }

            @Override
            public FinalApplicationStatus getFinalApplicationStatus() {
                return FinalApplicationStatus.UNDEFINED;
            }

            @Override
            public RMAppAttempt getCurrentAppAttempt() {
                return null;
            }

            @Override
            public int getMaxAppAttempts() {
                return maxAppAttempts;
            }

            @Override
            public Set<String> getApplicationTags() {
                return null;
            }

            @Override
            public ApplicationReport createAndGetApplicationReport(String clientUserName, boolean allowAccess) {
                ApplicationResourceUsageReport usageReport = ApplicationResourceUsageReport.newInstance((int)0, (int)0, null, null, null, (long)0L, (long)0L, (long)0L, (float)0.0f, (float)0.0f, (long)0L, (long)0L, (long)0L);
                ApplicationReport report = ApplicationReport.newInstance((ApplicationId)this.getApplicationId(), (ApplicationAttemptId)appAttemptId, (String)this.getUser(), (String)this.getQueue(), (String)this.getName(), null, (int)0, null, null, (String)this.getDiagnostics().toString(), (String)this.getTrackingUrl(), (long)this.getStartTime(), (long)this.getFinishTime(), (FinalApplicationStatus)this.getFinalApplicationStatus(), (ApplicationResourceUsageReport)usageReport, null, (float)this.getProgress(), (String)"YARN", null);
                return report;
            }
        };
    }

    public static List<RMApp> newApplications(int n) {
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < n; ++i) {
            list.add(MockAsm.newApplication(i));
        }
        return list;
    }

    public static class ApplicationBase
    implements RMApp {
        ResourceRequest amReq;

        public String getUser() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public ApplicationSubmissionContext getApplicationSubmissionContext() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public String getName() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public String getQueue() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public long getStartTime() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public long getSubmitTime() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public long getFinishTime() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public StringBuilder getDiagnostics() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public ApplicationId getApplicationId() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public RMAppAttempt getCurrentAppAttempt() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Map<ApplicationAttemptId, RMAppAttempt> getAppAttempts() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public float getProgress() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public RMAppAttempt getRMAppAttempt(ApplicationAttemptId appAttemptId) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public RMAppState getState() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public String getTrackingUrl() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public String getOriginalTrackingUrl() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public int getMaxAppAttempts() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public ApplicationReport createAndGetApplicationReport(String clientUserName, boolean allowAccess) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void handle(RMAppEvent event) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public FinalApplicationStatus getFinalApplicationStatus() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public int pullRMNodeUpdates(Collection<RMNode> updatedNodes) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public String getApplicationType() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Set<String> getApplicationTags() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void setQueue(String name) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public boolean isAppFinalStateStored() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public YarnApplicationState createApplicationState() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Set<NodeId> getRanNodes() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public RMAppMetrics getRMAppMetrics() {
            return new RMAppMetrics(Resource.newInstance((int)0, (int)0, (int)0), 0, 0, 0L, 0L, 0L, 0L, 0L, 0L);
        }

        public ReservationId getReservationId() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public ResourceRequest getAMResourceRequest() {
            return this.amReq;
        }

        public Map<NodeId, LogAggregationReport> getLogAggregationReportsForApp() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public LogAggregationStatus getLogAggregationStatusForAppReport() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public String getAmNodeLabelExpression() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public String getAppNodeLabelExpression() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public CallerContext getCallerContext() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public byte[] getKeyStore() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public char[] getKeyStorePassword() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public byte[] getTrustStore() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public char[] getTrustStorePassword() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public String getJWT() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Instant getJWTExpiration() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Integer getCryptoMaterialVersion() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public long getCertificateExpiration() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public boolean isAppRotatingCryptoMaterial() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public long getMaterialRotationStartTime() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void rmNodeHasUpdatedCryptoMaterial(NodeId nodeId) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

