/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.ProportionalCapacityPreemptionPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.TestProportionalCapacityPreemptionPolicyForNodePartitions;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerImpl;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceUsage;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueueCapacities;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.preemption.PreemptionManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.ContainerPreemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.policy.OrderingPolicy;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.resource.DefaultResourceCalculator;
import org.apache.hadoop.yarn.util.resource.DominantResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.junit.Assert;
import org.junit.Before;
import org.mockito.ArgumentMatcher;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class ProportionalCapacityPreemptionPolicyMockFramework {
    static final Log LOG = LogFactory.getLog(TestProportionalCapacityPreemptionPolicyForNodePartitions.class);
    final String ROOT = "root";
    Map<String, CSQueue> nameToCSQueues = null;
    Map<String, Resource> partitionToResource = null;
    Map<NodeId, FiCaSchedulerNode> nodeIdToSchedulerNodes = null;
    RMNodeLabelsManager nlm = null;
    RMContext rmContext = null;
    ResourceCalculator rc = new DefaultResourceCalculator();
    Clock mClock = null;
    CapacitySchedulerConfiguration conf = null;
    CapacityScheduler cs = null;
    EventHandler<SchedulerEvent> mDisp = null;
    ProportionalCapacityPreemptionPolicy policy = null;
    Resource clusterResource = null;

    @Before
    public void setup() {
        Logger.getRootLogger().setLevel(Level.DEBUG);
        this.conf = new CapacitySchedulerConfiguration(new Configuration(false));
        this.conf.setLong("yarn.resourcemanager.monitor.capacity.preemption.max_wait_before_kill", 10000L);
        this.conf.setLong("yarn.resourcemanager.monitor.capacity.preemption.monitoring_interval", 3000L);
        this.conf.setFloat("yarn.resourcemanager.monitor.capacity.preemption.total_preemption_per_round", 1.0f);
        this.conf.setFloat("yarn.resourcemanager.monitor.capacity.preemption.natural_termination_factor", 1.0f);
        this.mClock = (Clock)Mockito.mock(Clock.class);
        this.cs = (CapacityScheduler)Mockito.mock(CapacityScheduler.class);
        Mockito.when((Object)this.cs.getResourceCalculator()).thenReturn((Object)this.rc);
        Mockito.when((Object)this.cs.getPreemptionManager()).thenReturn((Object)new PreemptionManager());
        Mockito.when((Object)this.cs.getConfiguration()).thenReturn((Object)this.conf);
        this.nlm = (RMNodeLabelsManager)Mockito.mock(RMNodeLabelsManager.class);
        this.mDisp = (EventHandler)Mockito.mock(EventHandler.class);
        this.rmContext = (RMContext)Mockito.mock(RMContext.class);
        Mockito.when((Object)this.rmContext.getNodeLabelManager()).thenReturn((Object)this.nlm);
        Dispatcher disp = (Dispatcher)Mockito.mock(Dispatcher.class);
        Mockito.when((Object)this.rmContext.getDispatcher()).thenReturn((Object)disp);
        Mockito.when((Object)disp.getEventHandler()).thenReturn(this.mDisp);
        Mockito.when((Object)this.cs.getRMContext()).thenReturn((Object)this.rmContext);
        this.partitionToResource = new HashMap<String, Resource>();
        this.nodeIdToSchedulerNodes = new HashMap<NodeId, FiCaSchedulerNode>();
        this.nameToCSQueues = new HashMap<String, CSQueue>();
    }

    public void buildEnv(String labelsConfig, String nodesConfig, String queuesConfig, String appsConfig) throws IOException {
        this.buildEnv(labelsConfig, nodesConfig, queuesConfig, appsConfig, false);
    }

    public void buildEnv(String labelsConfig, String nodesConfig, String queuesConfig, String appsConfig, boolean useDominantResourceCalculator) throws IOException {
        if (useDominantResourceCalculator) {
            Mockito.when((Object)this.cs.getResourceCalculator()).thenReturn((Object)new DominantResourceCalculator());
        }
        this.mockNodeLabelsManager(labelsConfig);
        this.mockSchedulerNodes(nodesConfig);
        for (NodeId nodeId : this.nodeIdToSchedulerNodes.keySet()) {
            Mockito.when((Object)this.cs.getSchedulerNode(nodeId)).thenReturn((Object)this.nodeIdToSchedulerNodes.get(nodeId));
        }
        Mockito.when((Object)this.cs.getAllNodes()).thenReturn(this.nodeIdToSchedulerNodes);
        ParentQueue root = this.mockQueueHierarchy(queuesConfig);
        Mockito.when((Object)this.cs.getRootQueue()).thenReturn((Object)root);
        Mockito.when((Object)this.cs.getClusterResource()).thenReturn((Object)this.clusterResource);
        this.mockApplications(appsConfig);
        this.policy = new ProportionalCapacityPreemptionPolicy(this.rmContext, this.cs, this.mClock);
    }

    private void mockContainers(String containersConfig, FiCaSchedulerApp app, ApplicationAttemptId attemptId, String queueName, List<RMContainer> reservedContainers, List<RMContainer> liveContainers) {
        int containerId = 1;
        int start = containersConfig.indexOf("=") + 1;
        int end = -1;
        Resource used = Resource.newInstance((int)0, (int)0);
        Resource pending = Resource.newInstance((int)0, (int)0);
        Priority pri = Priority.newInstance((int)0);
        while (start < containersConfig.length()) {
            while (start < containersConfig.length() && containersConfig.charAt(start) != '(') {
                ++start;
            }
            if (start >= containersConfig.length()) {
                throw new IllegalArgumentException("Error containers specification, line=" + containersConfig);
            }
            for (end = start + 1; end < containersConfig.length() && containersConfig.charAt(end) != ')'; ++end) {
            }
            if (end >= containersConfig.length()) {
                throw new IllegalArgumentException("Error containers specification, line=" + containersConfig);
            }
            String[] values = containersConfig.substring(start + 1, end).split(",");
            if (values.length < 6 || values.length > 8) {
                throw new IllegalArgumentException("Format to define container is:(priority,resource,host,expression,repeat,reserved, pending)");
            }
            pri.setPriority(Integer.valueOf(values[0]).intValue());
            Resource res = this.parseResourceFromString(values[1]);
            NodeId host = NodeId.newInstance((String)values[2], (int)1);
            String label = values[3];
            String userName = "user";
            int repeat = Integer.valueOf(values[4]);
            boolean reserved = Boolean.valueOf(values[5]);
            if (values.length >= 7) {
                Resources.addTo((Resource)pending, (Resource)this.parseResourceFromString(values[6]));
            }
            if (values.length == 8) {
                userName = values[7];
            }
            for (int i = 0; i < repeat; ++i) {
                Container c = (Container)Mockito.mock(Container.class);
                Resources.addTo((Resource)used, (Resource)res);
                Mockito.when((Object)c.getResource()).thenReturn((Object)res);
                Mockito.when((Object)c.getPriority()).thenReturn((Object)pri);
                RMContainerImpl rmc = (RMContainerImpl)Mockito.mock(RMContainerImpl.class);
                Mockito.when((Object)rmc.getAllocatedNode()).thenReturn((Object)host);
                Mockito.when((Object)rmc.getNodeLabelExpression()).thenReturn((Object)label);
                Mockito.when((Object)rmc.getAllocatedResource()).thenReturn((Object)res);
                Mockito.when((Object)rmc.getContainer()).thenReturn((Object)c);
                Mockito.when((Object)rmc.getApplicationAttemptId()).thenReturn((Object)attemptId);
                Mockito.when((Object)rmc.getQueueName()).thenReturn((Object)queueName);
                final ContainerId cId = ContainerId.newContainerId((ApplicationAttemptId)attemptId, (long)containerId);
                Mockito.when((Object)rmc.getContainerId()).thenReturn((Object)cId);
                ((RMContainerImpl)Mockito.doAnswer((Answer)new Answer<Integer>(){

                    public Integer answer(InvocationOnMock invocation) throws Throwable {
                        return cId.compareTo(((RMContainer)invocation.getArguments()[0]).getContainerId());
                    }
                }).when((Object)rmc)).compareTo((RMContainer)Matchers.any(RMContainer.class));
                if (containerId == 1) {
                    Mockito.when((Object)rmc.isAMContainer()).thenReturn((Object)true);
                    Mockito.when((Object)app.getAMResource(label)).thenReturn((Object)res);
                }
                if (reserved) {
                    reservedContainers.add((RMContainer)rmc);
                    Mockito.when((Object)rmc.getReservedResource()).thenReturn((Object)res);
                } else {
                    liveContainers.add((RMContainer)rmc);
                }
                this.addContainerToSchedulerNode(host, (RMContainer)rmc, reserved);
                String partition = null;
                if (label.isEmpty() && !(partition = this.nodeIdToSchedulerNodes.get(host).getPartition()).isEmpty()) {
                    LeafQueue queue = (LeafQueue)this.nameToCSQueues.get(queueName);
                    Map ignoreExclusivityContainers = queue.getIgnoreExclusivityRMContainers();
                    if (!ignoreExclusivityContainers.containsKey(partition)) {
                        ignoreExclusivityContainers.put(partition, new TreeSet());
                    }
                    ((TreeSet)ignoreExclusivityContainers.get(partition)).add(rmc);
                }
                LOG.debug((Object)("add container to app=" + attemptId + " res=" + res + " node=" + host + " nodeLabelExpression=" + label + " partition=" + partition));
                ++containerId;
            }
            Mockito.when((Object)app.getPriority()).thenReturn((Object)pri);
            Mockito.when((Object)app.getUser()).thenReturn((Object)userName);
            Mockito.when((Object)app.getCurrentConsumption()).thenReturn((Object)used);
            Mockito.when((Object)app.getCurrentReservation()).thenReturn((Object)Resources.createResource((int)0, (int)0));
            HashMap<String, Resource> pendingForDefaultPartition = new HashMap<String, Resource>();
            pendingForDefaultPartition.put(label, pending);
            Mockito.when((Object)app.getTotalPendingRequestsPerPartition()).thenReturn(pendingForDefaultPartition);
            ResourceUsage ru = new ResourceUsage();
            ru.setUsed(label, used);
            Mockito.when((Object)app.getAppAttemptResourceUsage()).thenReturn((Object)ru);
            start = end + 1;
        }
    }

    private void mockApplications(String appsConfig) {
        int id = 1;
        HashMap<String, HashSet<String>> userMap = new HashMap<String, HashSet<String>>();
        LeafQueue queue = null;
        for (String a : appsConfig.split(";")) {
            String[] strs = a.split("\t");
            String queueName = strs[0];
            ArrayList<RMContainer> liveContainers = new ArrayList<RMContainer>();
            ArrayList<RMContainer> reservedContainers = new ArrayList<RMContainer>();
            ApplicationId appId = ApplicationId.newInstance((long)0L, (int)id);
            ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
            FiCaSchedulerApp app = (FiCaSchedulerApp)Mockito.mock(FiCaSchedulerApp.class);
            Mockito.when((Object)app.getAMResource(Matchers.anyString())).thenReturn((Object)Resources.createResource((int)0, (int)0));
            this.mockContainers(strs[1], app, appAttemptId, queueName, reservedContainers, liveContainers);
            LOG.debug((Object)("Application mock: queue: " + queueName + ", appId:" + appId));
            Mockito.when((Object)app.getLiveContainers()).thenReturn(liveContainers);
            Mockito.when((Object)app.getReservedContainers()).thenReturn(reservedContainers);
            Mockito.when((Object)app.getApplicationAttemptId()).thenReturn((Object)appAttemptId);
            Mockito.when((Object)app.getApplicationId()).thenReturn((Object)appId);
            queue = (LeafQueue)this.nameToCSQueues.get(queueName);
            queue.getApplications().add(app);
            queue.getAllApplications().add(app);
            HashSet<String> users = (HashSet<String>)userMap.get(queueName);
            if (null == users) {
                users = new HashSet<String>();
                userMap.put(queueName, users);
            }
            users.add(app.getUser());
            ++id;
        }
        for (String queueName : userMap.keySet()) {
            queue = (LeafQueue)this.nameToCSQueues.get(queueName);
            Resource totResoucePerPartition = this.partitionToResource.get("");
            Resource capacity = Resources.multiply((Resource)totResoucePerPartition, (double)queue.getQueueCapacities().getAbsoluteCapacity());
            HashSet users = (HashSet)userMap.get(queue.getQueueName());
            Resource userLimit = Resources.divideAndCeil((ResourceCalculator)this.rc, (Resource)capacity, (int)users.size());
            for (String user : users) {
                Mockito.when((Object)queue.getUserLimitPerUser((String)Matchers.eq((Object)user), (Resource)Matchers.any(Resource.class), Matchers.anyString())).thenReturn((Object)userLimit);
            }
        }
    }

    private void addContainerToSchedulerNode(NodeId nodeId, RMContainer container, boolean isReserved) {
        SchedulerNode node = (SchedulerNode)this.nodeIdToSchedulerNodes.get(nodeId);
        assert (node != null);
        if (isReserved) {
            Mockito.when((Object)node.getReservedContainer()).thenReturn((Object)container);
        } else {
            node.getCopiedListOfRunningContainers().add(container);
            Resources.subtractFrom((Resource)node.getAvailableResource(), (Resource)container.getAllocatedResource());
        }
    }

    private void mockSchedulerNodes(String schedulerNodesConfigStr) throws IOException {
        String[] nodesConfigStrArray;
        for (String p : nodesConfigStrArray = schedulerNodesConfigStr.split(";")) {
            String res;
            String[] arr = p.split(" ");
            NodeId nodeId = NodeId.newInstance((String)arr[0].substring(0, arr[0].indexOf("=")), (int)1);
            String partition = arr[0].substring(arr[0].indexOf("=") + 1, arr[0].length());
            FiCaSchedulerNode sn = (FiCaSchedulerNode)Mockito.mock(FiCaSchedulerNode.class);
            Mockito.when((Object)sn.getNodeID()).thenReturn((Object)nodeId);
            Mockito.when((Object)sn.getPartition()).thenReturn((Object)partition);
            Resource totalRes = Resources.createResource((int)0);
            if (arr.length > 1 && (res = arr[1]).contains("res=")) {
                String resSring = res.substring(res.indexOf("res=") + "res=".length());
                totalRes = this.parseResourceFromString(resSring);
            }
            Mockito.when((Object)sn.getTotalResource()).thenReturn((Object)totalRes);
            Mockito.when((Object)sn.getAvailableResource()).thenReturn((Object)Resources.clone((Resource)totalRes));
            Mockito.when((Object)sn.getTotalKillableResources()).thenReturn((Object)Resources.none());
            ArrayList liveContainers = new ArrayList();
            Mockito.when((Object)sn.getCopiedListOfRunningContainers()).thenReturn(liveContainers);
            this.nodeIdToSchedulerNodes.put(nodeId, sn);
            LOG.debug((Object)("add scheduler node, id=" + nodeId + ", partition=" + partition));
        }
    }

    private void mockNodeLabelsManager(String nodeLabelsConfigStr) throws IOException {
        String[] partitionConfigArr = nodeLabelsConfigStr.split(";");
        this.clusterResource = Resources.createResource((int)0);
        for (String p : partitionConfigArr) {
            String partitionName = p.substring(0, p.indexOf("="));
            Resource res = this.parseResourceFromString(p.substring(p.indexOf("=") + 1, p.indexOf(",")));
            boolean exclusivity = Boolean.valueOf(p.substring(p.indexOf(",") + 1, p.length()));
            Mockito.when((Object)this.nlm.getResourceByLabel((String)Matchers.eq((Object)partitionName), (Resource)Matchers.any(Resource.class))).thenReturn((Object)res);
            Mockito.when((Object)this.nlm.isExclusiveNodeLabel((String)Matchers.eq((Object)partitionName))).thenReturn((Object)exclusivity);
            this.partitionToResource.put(partitionName, res);
            LOG.debug((Object)("add partition=" + partitionName + " totalRes=" + res + " exclusivity=" + exclusivity));
            Resources.addTo((Resource)this.clusterResource, (Resource)res);
        }
        Mockito.when((Object)this.nlm.getClusterNodeLabelNames()).thenReturn(this.partitionToResource.keySet());
    }

    private Resource parseResourceFromString(String p) {
        String[] resource = p.split(":");
        Resource res = resource.length == 1 ? Resources.createResource((int)Integer.valueOf(resource[0])) : Resources.createResource((int)Integer.valueOf(resource[0]), (int)Integer.valueOf(resource[1]));
        return res;
    }

    private ParentQueue mockQueueHierarchy(String queueExprs) {
        String[] queueExprArray = queueExprs.split(";");
        ParentQueue rootQueue = null;
        for (int idx = 0; idx < queueExprArray.length; ++idx) {
            ParentQueue queue;
            String q = queueExprArray[idx];
            if (this.isParent(queueExprArray, idx)) {
                ParentQueue parentQueue;
                queue = parentQueue = (ParentQueue)Mockito.mock(ParentQueue.class);
                ArrayList children = new ArrayList();
                Mockito.when((Object)parentQueue.getChildQueues()).thenReturn(children);
            } else {
                LeafQueue leafQueue = (LeafQueue)Mockito.mock(LeafQueue.class);
                final TreeSet<FiCaSchedulerApp> apps = new TreeSet<FiCaSchedulerApp>(new Comparator<FiCaSchedulerApp>(){

                    @Override
                    public int compare(FiCaSchedulerApp a1, FiCaSchedulerApp a2) {
                        if (a1.getPriority() != null && !a1.getPriority().equals((Object)a2.getPriority())) {
                            return a1.getPriority().compareTo(a2.getPriority());
                        }
                        int res = a1.getApplicationId().compareTo(a2.getApplicationId());
                        return res;
                    }
                });
                Mockito.when((Object)leafQueue.getApplications()).thenReturn(apps);
                Mockito.when((Object)leafQueue.getAllApplications()).thenReturn(apps);
                OrderingPolicy so = (OrderingPolicy)Mockito.mock(OrderingPolicy.class);
                Mockito.when((Object)so.getPreemptionIterator()).thenAnswer(new Answer(){

                    public Object answer(InvocationOnMock invocation) {
                        return apps.descendingIterator();
                    }
                });
                Mockito.when((Object)leafQueue.getOrderingPolicy()).thenReturn((Object)so);
                HashMap ignorePartitionContainers = new HashMap();
                Mockito.when((Object)leafQueue.getIgnoreExclusivityRMContainers()).thenReturn(ignorePartitionContainers);
                queue = leafQueue;
            }
            this.setupQueue((CSQueue)queue, q, queueExprArray, idx);
            if (!queue.getQueueName().equals("root")) continue;
            rootQueue = queue;
        }
        return rootQueue;
    }

    private void setupQueue(CSQueue queue, String q, String[] queueExprArray, int idx) {
        LOG.debug((Object)("*** Setup queue, source=" + q));
        String queuePath = null;
        int myLevel = this.getLevel(q);
        if (0 == myLevel) {
            Mockito.when((Object)queue.getQueueName()).thenReturn((Object)"root");
            queuePath = "root";
        }
        String queueName = this.getQueueName(q);
        Mockito.when((Object)queue.getQueueName()).thenReturn((Object)queueName);
        ParentQueue parentQueue = this.getParentQueue(queueExprArray, idx, myLevel);
        if (null != parentQueue) {
            Mockito.when((Object)queue.getParent()).thenReturn((Object)parentQueue);
            parentQueue.getChildQueues().add(queue);
            queuePath = parentQueue.getQueuePath() + "." + queueName;
        }
        Mockito.when((Object)queue.getQueuePath()).thenReturn((Object)queuePath);
        QueueCapacities qc = new QueueCapacities(0 == myLevel);
        ResourceUsage ru = new ResourceUsage();
        Mockito.when((Object)queue.getQueueCapacities()).thenReturn((Object)qc);
        Mockito.when((Object)queue.getQueueResourceUsage()).thenReturn((Object)ru);
        LOG.debug((Object)("Setup queue, name=" + queue.getQueueName() + " path=" + queue.getQueuePath()));
        LOG.debug((Object)("Parent=" + (parentQueue == null ? "null" : parentQueue.getQueueName())));
        String capacitySettingStr = q.substring(q.indexOf("(") + 1, q.indexOf(")"));
        for (String s : capacitySettingStr.split(",")) {
            String partitionName = s.substring(0, s.indexOf("="));
            String[] values = s.substring(s.indexOf("[") + 1, s.indexOf("]")).split(" ");
            float epsilon = 1.0E-6f;
            Resource totResoucePerPartition = this.partitionToResource.get(partitionName);
            float absGuaranteed = Resources.divide((ResourceCalculator)this.rc, (Resource)totResoucePerPartition, (Resource)this.parseResourceFromString(values[0].trim()), (Resource)totResoucePerPartition) + epsilon;
            float absMax = Resources.divide((ResourceCalculator)this.rc, (Resource)totResoucePerPartition, (Resource)this.parseResourceFromString(values[1].trim()), (Resource)totResoucePerPartition) + epsilon;
            float absUsed = Resources.divide((ResourceCalculator)this.rc, (Resource)totResoucePerPartition, (Resource)this.parseResourceFromString(values[2].trim()), (Resource)totResoucePerPartition) + epsilon;
            float used = Resources.divide((ResourceCalculator)this.rc, (Resource)totResoucePerPartition, (Resource)this.parseResourceFromString(values[2].trim()), (Resource)this.parseResourceFromString(values[0].trim())) + epsilon;
            Resource pending = this.parseResourceFromString(values[3].trim());
            qc.setAbsoluteCapacity(partitionName, absGuaranteed);
            qc.setAbsoluteMaximumCapacity(partitionName, absMax);
            qc.setAbsoluteUsedCapacity(partitionName, absUsed);
            qc.setUsedCapacity(partitionName, used);
            Mockito.when((Object)Float.valueOf(queue.getUsedCapacity())).thenReturn((Object)Float.valueOf(used));
            ru.setPending(partitionName, pending);
            if (!this.isParent(queueExprArray, idx)) {
                LeafQueue lq = (LeafQueue)queue;
                Mockito.when((Object)lq.getTotalPendingResourcesConsideringUserLimit((Resource)Matchers.isA(Resource.class), (String)Matchers.isA(String.class))).thenReturn((Object)pending);
            }
            ru.setUsed(partitionName, this.parseResourceFromString(values[2].trim()));
            Resource reserved = Resources.none();
            if (values.length == 5) {
                reserved = this.parseResourceFromString(values[4].trim());
                ru.setReserved(partitionName, reserved);
            }
            LOG.debug((Object)("Setup queue=" + queueName + " partition=" + partitionName + " [abs_guaranteed=" + absGuaranteed + ",abs_max=" + absMax + ",abs_used" + absUsed + ",pending_resource=" + pending + ", reserved_resource=" + reserved + "]"));
        }
        Mockito.when((Object)queue.getPreemptionDisabled()).thenReturn((Object)this.conf.getPreemptionDisabled(queuePath, false));
        this.nameToCSQueues.put(queueName, queue);
        Mockito.when((Object)this.cs.getQueue((String)Matchers.eq((Object)queueName))).thenReturn((Object)queue);
    }

    private int getLevel(String q) {
        int level;
        for (level = 0; level < q.length() && q.charAt(level) == '-'; ++level) {
        }
        return level;
    }

    private String getQueueName(String q) {
        int idx;
        for (idx = 0; idx < q.length() && q.charAt(idx) == '-'; ++idx) {
        }
        if (idx == q.length()) {
            throw new IllegalArgumentException("illegal input:" + q);
        }
        String name = q.substring(idx, q.indexOf(40));
        if (name.isEmpty()) {
            throw new IllegalArgumentException("queue name shouldn't be empty:" + q);
        }
        if (name.contains(".")) {
            throw new IllegalArgumentException("queue name shouldn't contain '.':" + name);
        }
        return name;
    }

    private ParentQueue getParentQueue(String[] queueExprArray, int idx, int myLevel) {
        --idx;
        while (idx >= 0) {
            int level = this.getLevel(queueExprArray[idx]);
            if (level < myLevel) {
                String parentQueuName = this.getQueueName(queueExprArray[idx]);
                return (ParentQueue)this.nameToCSQueues.get(parentQueuName);
            }
            --idx;
        }
        return null;
    }

    private boolean isParent(String[] queues, int idx) {
        int myLevel = this.getLevel(queues[idx]);
        ++idx;
        while (idx < queues.length && this.getLevel(queues[idx]) == myLevel) {
            ++idx;
        }
        return idx < queues.length && this.getLevel(queues[idx]) >= myLevel;
    }

    public ApplicationAttemptId getAppAttemptId(int id) {
        ApplicationId appId = ApplicationId.newInstance((long)0L, (int)id);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
        return appAttemptId;
    }

    public void checkContainerNodesInApp(FiCaSchedulerApp app, int expectedContainersNumber, String host) {
        NodeId nodeId = NodeId.newInstance((String)host, (int)1);
        int num = 0;
        for (RMContainer c : app.getLiveContainers()) {
            if (!c.getAllocatedNode().equals((Object)nodeId)) continue;
            ++num;
        }
        for (RMContainer c : app.getReservedContainers()) {
            if (!c.getAllocatedNode().equals((Object)nodeId)) continue;
            ++num;
        }
        Assert.assertEquals((long)expectedContainersNumber, (long)num);
    }

    public FiCaSchedulerApp getApp(String queueName, int appId) {
        for (FiCaSchedulerApp app : ((LeafQueue)this.cs.getQueue(queueName)).getApplications()) {
            if (app.getApplicationId().getId() != appId) continue;
            return app;
        }
        return null;
    }

    public void checkAbsCapacities(CSQueue queue, String partition, float guaranteed, float max, float used) {
        QueueCapacities qc = queue.getQueueCapacities();
        Assert.assertEquals((double)guaranteed, (double)qc.getAbsoluteCapacity(partition), (double)0.001);
        Assert.assertEquals((double)max, (double)qc.getAbsoluteMaximumCapacity(partition), (double)0.001);
        Assert.assertEquals((double)used, (double)qc.getAbsoluteUsedCapacity(partition), (double)0.001);
    }

    public void checkPendingResource(CSQueue queue, String partition, int pending) {
        ResourceUsage ru = queue.getQueueResourceUsage();
        Assert.assertEquals((long)pending, (long)ru.getPending(partition).getMemorySize());
    }

    public void checkReservedResource(CSQueue queue, String partition, int reserved) {
        ResourceUsage ru = queue.getQueueResourceUsage();
        Assert.assertEquals((long)reserved, (long)ru.getReserved(partition).getMemorySize());
    }

    static class IsPreemptionRequestForQueueAndNode
    extends ArgumentMatcher<ContainerPreemptEvent> {
        private final ApplicationAttemptId appAttId;
        private final String queueName;
        private final NodeId nodeId;

        IsPreemptionRequestForQueueAndNode(ApplicationAttemptId appAttId, String queueName, NodeId nodeId) {
            this.appAttId = appAttId;
            this.queueName = queueName;
            this.nodeId = nodeId;
        }

        public boolean matches(Object o) {
            ContainerPreemptEvent cpe = (ContainerPreemptEvent)o;
            return this.appAttId.equals((Object)cpe.getAppId()) && this.queueName.equals(cpe.getContainer().getQueueName()) && this.nodeId.equals((Object)cpe.getContainer().getAllocatedNode());
        }

        public String toString() {
            return this.appAttId.toString();
        }
    }
}

