/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.recovery;

import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.crypto.SecretKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.curator.test.TestingServer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.security.AMRMTokenIdentifier;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStoreTestBase;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.TestZKRMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.ZKRMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.ApplicationStateData;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.security.AMRMTokenSecretManager;
import org.apache.hadoop.yarn.server.resourcemanager.security.ClientToAMTokenSecretManagerInRM;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestZKRMStateStorePerf
extends RMStateStoreTestBase
implements Tool {
    public static final Log LOG = LogFactory.getLog(TestZKRMStateStore.class);
    final String version = "0.1";
    private int ZK_PERF_NUM_APP_DEFAULT = 1000;
    private int ZK_PERF_NUM_APPATTEMPT_PER_APP = 10;
    private final long clusterTimeStamp = 1352994193343L;
    private static final String USAGE = "Usage: " + TestZKRMStateStorePerf.class.getSimpleName() + " -appSize numberOfApplications -appAttemptSize numberOfApplicationAttempts [-hostPort Host:Port] [-workingZnode rootZnodeForTesting]\n";
    private YarnConfiguration conf = null;
    private String workingZnode = "/Test";
    private ZKRMStateStore store;
    private AMRMTokenSecretManager appTokenMgr;
    private ClientToAMTokenSecretManagerInRM clientToAMTokenMgr;
    private TestingServer curatorTestingServer;

    @Before
    public void setUpZKServer() throws Exception {
        this.curatorTestingServer = new TestingServer();
    }

    @After
    public void tearDown() throws Exception {
        if (this.store != null) {
            this.store.stop();
        }
        if (this.appTokenMgr != null) {
            this.appTokenMgr.stop();
        }
        this.curatorTestingServer.stop();
    }

    private void initStore(String hostPort) {
        Optional optHostPort = Optional.fromNullable((Object)hostPort);
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        this.conf = new YarnConfiguration();
        this.conf.set("yarn.resourcemanager.zk-address", (String)optHostPort.or((Object)this.curatorTestingServer.getConnectString()));
        this.conf.set("yarn.resourcemanager.zk-state-store.parent-path", this.workingZnode);
        this.store = new ZKRMStateStore();
        this.store.setResourceManager(new ResourceManager());
        this.store.init((Configuration)this.conf);
        this.store.start();
        Mockito.when((Object)rmContext.getStateStore()).thenReturn((Object)this.store);
        this.appTokenMgr = new AMRMTokenSecretManager((Configuration)this.conf, rmContext);
        this.appTokenMgr.start();
        this.clientToAMTokenMgr = new ClientToAMTokenSecretManagerInRM();
    }

    public int run(String[] args) {
        LOG.info((Object)"Starting ZKRMStateStorePerf ver.0.1");
        int numApp = this.ZK_PERF_NUM_APP_DEFAULT;
        int numAppAttemptPerApp = this.ZK_PERF_NUM_APPATTEMPT_PER_APP;
        String hostPort = null;
        boolean launchLocalZK = true;
        if (args.length == 0) {
            System.err.println("Missing arguments.");
            return -1;
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-appsize")) {
                numApp = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-appattemptsize")) {
                numAppAttemptPerApp = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-hostPort")) {
                hostPort = args[++i];
                launchLocalZK = false;
                continue;
            }
            if (args[i].equalsIgnoreCase("-workingZnode")) {
                this.workingZnode = args[++i];
                continue;
            }
            System.err.println("Illegal argument: " + args[i]);
            return -1;
        }
        if (launchLocalZK) {
            try {
                this.setUpZKServer();
            }
            catch (Exception e) {
                System.err.println("failed to setup. : " + e.getMessage());
                return -1;
            }
        }
        this.initStore(hostPort);
        long submitTime = System.currentTimeMillis();
        long startTime = System.currentTimeMillis() + 1234L;
        ArrayList<ApplicationId> applicationIds = new ArrayList<ApplicationId>();
        ArrayList<RMApp> rmApps = new ArrayList<RMApp>();
        ArrayList attemptIds = new ArrayList();
        HashMap appIdsToAttemptId = new HashMap();
        RMStateStoreTestBase.TestDispatcher dispatcher = new RMStateStoreTestBase.TestDispatcher();
        this.store.setRMDispatcher((Dispatcher)dispatcher);
        for (int i = 0; i < numApp; ++i) {
            ApplicationId appId = ApplicationId.newInstance((long)1352994193343L, (int)i);
            applicationIds.add(appId);
            ArrayList<ApplicationAttemptId> attemptIdsForThisApp = new ArrayList<ApplicationAttemptId>();
            for (int j = 0; j < numAppAttemptPerApp; ++j) {
                ApplicationAttemptId attemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)j);
                attemptIdsForThisApp.add(attemptId);
            }
            appIdsToAttemptId.put(appId, new LinkedHashSet(attemptIdsForThisApp));
            attemptIds.addAll(attemptIdsForThisApp);
        }
        for (ApplicationId appId : applicationIds) {
            RMApp app = null;
            try {
                app = this.storeApp((RMStateStore)this.store, appId, submitTime, startTime);
            }
            catch (Exception e) {
                System.err.println("failed to create Application Znode. : " + e.getMessage());
                return -1;
            }
            this.waitNotify(dispatcher);
            rmApps.add(app);
        }
        for (ApplicationAttemptId attemptId : attemptIds) {
            Token<AMRMTokenIdentifier> tokenId = this.generateAMRMToken(attemptId, this.appTokenMgr);
            SecretKey clientTokenKey = this.clientToAMTokenMgr.createMasterKey(attemptId);
            try {
                this.storeAttempt((RMStateStore)this.store, attemptId, ContainerId.newContainerId((ApplicationAttemptId)attemptId, (long)0L).toString(), tokenId, clientTokenKey, dispatcher);
            }
            catch (Exception e) {
                System.err.println("failed to create AppAttempt Znode. : " + e.getMessage());
                return -1;
            }
        }
        long storeStart = System.currentTimeMillis();
        try {
            this.store.loadState();
        }
        catch (Exception e) {
            System.err.println("failed to locaState from ZKRMStateStore. : " + e.getMessage());
            return -1;
        }
        long storeEnd = System.currentTimeMillis();
        long loadTime = storeEnd - storeStart;
        String resultMsg = "ZKRMStateStore takes " + loadTime + " msec to loadState.";
        LOG.info((Object)resultMsg);
        System.out.println(resultMsg);
        try {
            for (RMApp app : rmApps) {
                ApplicationStateData appState = ApplicationStateData.newInstance((long)app.getSubmitTime(), (long)app.getStartTime(), (ApplicationSubmissionContext)app.getApplicationSubmissionContext(), (String)app.getUser());
                ApplicationId appId = app.getApplicationId();
                Map m = (Map)Mockito.mock(Map.class);
                Mockito.when(m.keySet()).thenReturn(appIdsToAttemptId.get(appId));
                appState.attempts = m;
                this.store.removeApplicationStateInternal(appState);
            }
        }
        catch (Exception e) {
            System.err.println("failed to cleanup. : " + e.getMessage());
            return -1;
        }
        return 0;
    }

    public void setConf(Configuration conf) {
    }

    public Configuration getConf() {
        return this.conf;
    }

    @Test
    public void perfZKRMStateStore() throws Exception {
        String[] args = new String[]{"-appSize", String.valueOf(this.ZK_PERF_NUM_APP_DEFAULT), "-appAttemptSize", String.valueOf(this.ZK_PERF_NUM_APPATTEMPT_PER_APP)};
        this.run(args);
    }

    public static void main(String[] args) throws Exception {
        TestZKRMStateStorePerf perf = new TestZKRMStateStorePerf();
        int res = -1;
        try {
            res = ToolRunner.run((Tool)perf, (String[])args);
        }
        catch (Exception e) {
            System.err.print(StringUtils.stringifyException((Throwable)e));
            res = -2;
        }
        if (res == -1) {
            System.err.print(USAGE);
        }
        System.exit(res);
    }
}

