/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.reservation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.yarn.api.records.ReservationDefinition;
import org.apache.hadoop.yarn.api.records.ReservationId;
import org.apache.hadoop.yarn.api.records.ReservationRequest;
import org.apache.hadoop.yarn.api.records.ReservationRequestInterpreter;
import org.apache.hadoop.yarn.api.records.ReservationRequests;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.impl.pb.ReservationDefinitionPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ReservationRequestsPBImpl;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.InMemoryPlan;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.InMemoryReservationAllocation;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.Plan;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.RLESparseResourceAllocation;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationAllocation;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationInterval;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationSystemTestUtil;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationSystemUtil;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.SharingPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.exceptions.PlanningException;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.planning.Planner;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.planning.ReservationAgent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.resource.DefaultResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestInMemoryPlan {
    private String user = "yarn";
    private String planName = "test-reservation";
    private ResourceCalculator resCalc;
    private Resource minAlloc;
    private Resource maxAlloc;
    private Resource totalCapacity;
    private Clock clock;
    private QueueMetrics queueMetrics;
    private SharingPolicy policy;
    private ReservationAgent agent;
    private Planner replanner;
    private RMContext context;

    @Before
    public void setUp() throws PlanningException {
        this.resCalc = new DefaultResourceCalculator();
        this.minAlloc = Resource.newInstance((int)1024, (int)1);
        this.maxAlloc = Resource.newInstance((int)65536, (int)20);
        this.totalCapacity = Resource.newInstance((int)102400, (int)100);
        this.clock = (Clock)Mockito.mock(Clock.class);
        this.queueMetrics = (QueueMetrics)Mockito.mock(QueueMetrics.class);
        this.policy = (SharingPolicy)Mockito.mock(SharingPolicy.class);
        this.replanner = (Planner)Mockito.mock(Planner.class);
        Mockito.when((Object)this.clock.getTime()).thenReturn((Object)1L);
        this.context = ReservationSystemTestUtil.createMockRMContext();
    }

    @After
    public void tearDown() {
        this.resCalc = null;
        this.minAlloc = null;
        this.maxAlloc = null;
        this.totalCapacity = null;
        this.clock = null;
        this.queueMetrics = null;
        this.policy = null;
        this.replanner = null;
    }

    @Test
    public void testAddReservation() {
        InMemoryPlan plan = new InMemoryPlan(this.queueMetrics, this.policy, this.agent, this.totalCapacity, 1L, this.resCalc, this.minAlloc, this.maxAlloc, this.planName, this.replanner, true, this.context);
        ReservationId reservationID = ReservationSystemTestUtil.getNewReservationId();
        int[] alloc = new int[]{10, 10, 10, 10, 10, 10};
        int start = 100;
        ReservationAllocation rAllocation = this.createReservationAllocation(reservationID, start, alloc);
        Assert.assertNull((Object)plan.getReservationById(reservationID));
        try {
            plan.addReservation(rAllocation, false);
        }
        catch (PlanningException e) {
            Assert.fail((String)e.getMessage());
        }
        this.doAssertions((Plan)plan, rAllocation);
        this.checkAllocation((Plan)plan, alloc, start);
    }

    private void checkAllocation(Plan plan, int[] alloc, int start) {
        RLESparseResourceAllocation userCons = plan.getConsumptionForUserOverTime(this.user, (long)start, (long)(start + alloc.length));
        for (int i = 0; i < alloc.length; ++i) {
            Assert.assertEquals((Object)Resource.newInstance((int)(1024 * alloc[i]), (int)alloc[i]), (Object)plan.getTotalCommittedResources((long)(start + i)));
            Assert.assertEquals((Object)Resource.newInstance((int)(1024 * alloc[i]), (int)alloc[i]), (Object)userCons.getCapacityAtTime((long)(start + i)));
        }
    }

    @Test
    public void testAddEmptyReservation() {
        InMemoryPlan plan = new InMemoryPlan(this.queueMetrics, this.policy, this.agent, this.totalCapacity, 1L, this.resCalc, this.minAlloc, this.maxAlloc, this.planName, this.replanner, true, this.context);
        ReservationId reservationID = ReservationSystemTestUtil.getNewReservationId();
        int[] alloc = new int[]{};
        int start = 100;
        ReservationAllocation rAllocation = this.createReservationAllocation(reservationID, start, alloc);
        Assert.assertNull((Object)plan.getReservationById(reservationID));
        try {
            plan.addReservation(rAllocation, false);
        }
        catch (PlanningException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testAddReservationAlreadyExists() {
        InMemoryPlan plan = new InMemoryPlan(this.queueMetrics, this.policy, this.agent, this.totalCapacity, 1L, this.resCalc, this.minAlloc, this.maxAlloc, this.planName, this.replanner, true, this.context);
        ReservationId reservationID = ReservationSystemTestUtil.getNewReservationId();
        int[] alloc = new int[]{10, 10, 10, 10, 10, 10};
        int start = 100;
        ReservationAllocation rAllocation = this.createReservationAllocation(reservationID, start, alloc);
        Assert.assertNull((Object)plan.getReservationById(reservationID));
        try {
            plan.addReservation(rAllocation, false);
        }
        catch (PlanningException e) {
            Assert.fail((String)e.getMessage());
        }
        this.doAssertions((Plan)plan, rAllocation);
        this.checkAllocation((Plan)plan, alloc, start);
        try {
            plan.addReservation(rAllocation, false);
            Assert.fail((String)"Add should fail as it already exists");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().endsWith("already exists"));
        }
        catch (PlanningException e) {
            Assert.fail((String)e.getMessage());
        }
        this.doAssertions((Plan)plan, rAllocation);
    }

    @Test
    public void testUpdateReservation() {
        InMemoryPlan plan = new InMemoryPlan(this.queueMetrics, this.policy, this.agent, this.totalCapacity, 1L, this.resCalc, this.minAlloc, this.maxAlloc, this.planName, this.replanner, true, this.context);
        ReservationId reservationID = ReservationSystemTestUtil.getNewReservationId();
        int[] alloc = new int[]{10, 10, 10, 10, 10, 10};
        int start = 100;
        ReservationAllocation rAllocation = this.createReservationAllocation(reservationID, start, alloc);
        Assert.assertNull((Object)plan.getReservationById(reservationID));
        try {
            plan.addReservation(rAllocation, false);
        }
        catch (PlanningException e) {
            Assert.fail((String)e.getMessage());
        }
        this.doAssertions((Plan)plan, rAllocation);
        RLESparseResourceAllocation userCons = plan.getConsumptionForUserOverTime(this.user, (long)start, (long)(start + alloc.length));
        for (int i = 0; i < alloc.length; ++i) {
            Assert.assertEquals((Object)Resource.newInstance((int)(1024 * alloc[i]), (int)alloc[i]), (Object)plan.getTotalCommittedResources((long)(start + i)));
            Assert.assertEquals((Object)Resource.newInstance((int)(1024 * alloc[i]), (int)alloc[i]), (Object)userCons.getCapacityAtTime((long)(start + i)));
        }
        start = 110;
        int[] updatedAlloc = new int[]{0, 5, 10, 10, 5, 0};
        rAllocation = this.createReservationAllocation(reservationID, start, updatedAlloc, true);
        try {
            plan.updateReservation(rAllocation);
        }
        catch (PlanningException e) {
            Assert.fail((String)e.getMessage());
        }
        this.doAssertions((Plan)plan, rAllocation);
        userCons = plan.getConsumptionForUserOverTime(this.user, (long)start, (long)(start + updatedAlloc.length));
        for (int i = 0; i < updatedAlloc.length; ++i) {
            Assert.assertEquals((Object)Resource.newInstance((int)(1024 * (updatedAlloc[i] + i)), (int)(updatedAlloc[i] + i)), (Object)plan.getTotalCommittedResources((long)(start + i)));
            Assert.assertEquals((Object)Resource.newInstance((int)(1024 * (updatedAlloc[i] + i)), (int)(updatedAlloc[i] + i)), (Object)userCons.getCapacityAtTime((long)(start + i)));
        }
    }

    @Test
    public void testUpdateNonExistingReservation() {
        InMemoryPlan plan = new InMemoryPlan(this.queueMetrics, this.policy, this.agent, this.totalCapacity, 1L, this.resCalc, this.minAlloc, this.maxAlloc, this.planName, this.replanner, true, this.context);
        ReservationId reservationID = ReservationSystemTestUtil.getNewReservationId();
        int[] alloc = new int[]{10, 10, 10, 10, 10, 10};
        int start = 100;
        ReservationAllocation rAllocation = this.createReservationAllocation(reservationID, start, alloc);
        Assert.assertNull((Object)plan.getReservationById(reservationID));
        try {
            plan.updateReservation(rAllocation);
            Assert.fail((String)"Update should fail as it does not exist in the plan");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().endsWith("does not exist in the plan"));
        }
        catch (PlanningException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNull((Object)plan.getReservationById(reservationID));
    }

    @Test
    public void testDeleteReservation() {
        InMemoryPlan plan = new InMemoryPlan(this.queueMetrics, this.policy, this.agent, this.totalCapacity, 1L, this.resCalc, this.minAlloc, this.maxAlloc, this.planName, this.replanner, true, this.context);
        ReservationId reservationID = ReservationSystemTestUtil.getNewReservationId();
        int[] alloc = new int[]{10, 10, 10, 10, 10, 10};
        int start = 100;
        ReservationAllocation rAllocation = this.createReservationAllocation(reservationID, start, alloc, true);
        Assert.assertNull((Object)plan.getReservationById(reservationID));
        try {
            plan.addReservation(rAllocation, false);
        }
        catch (PlanningException e) {
            Assert.fail((String)e.getMessage());
        }
        this.doAssertions((Plan)plan, rAllocation);
        RLESparseResourceAllocation userCons = plan.getConsumptionForUserOverTime(this.user, (long)start, (long)(start + alloc.length));
        for (int i = 0; i < alloc.length; ++i) {
            Assert.assertEquals((Object)Resource.newInstance((int)(1024 * (alloc[i] + i)), (int)(alloc[i] + i)), (Object)plan.getTotalCommittedResources((long)(start + i)));
            Assert.assertEquals((Object)Resource.newInstance((int)(1024 * (alloc[i] + i)), (int)(alloc[i] + i)), (Object)userCons.getCapacityAtTime((long)(start + i)));
        }
        try {
            plan.deleteReservation(reservationID);
        }
        catch (PlanningException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNull((Object)plan.getReservationById(reservationID));
        userCons = plan.getConsumptionForUserOverTime(this.user, (long)start, (long)(start + alloc.length));
        for (int i = 0; i < alloc.length; ++i) {
            Assert.assertEquals((Object)Resource.newInstance((int)0, (int)0), (Object)plan.getTotalCommittedResources((long)(start + i)));
            Assert.assertEquals((Object)Resource.newInstance((int)0, (int)0), (Object)userCons.getCapacityAtTime((long)(start + i)));
        }
    }

    @Test
    public void testDeleteNonExistingReservation() {
        InMemoryPlan plan = new InMemoryPlan(this.queueMetrics, this.policy, this.agent, this.totalCapacity, 1L, this.resCalc, this.minAlloc, this.maxAlloc, this.planName, this.replanner, true, this.context);
        ReservationId reservationID = ReservationSystemTestUtil.getNewReservationId();
        Assert.assertNull((Object)plan.getReservationById(reservationID));
        try {
            plan.deleteReservation(reservationID);
            Assert.fail((String)"Delete should fail as it does not exist in the plan");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().endsWith("does not exist in the plan"));
        }
        catch (PlanningException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNull((Object)plan.getReservationById(reservationID));
    }

    @Test
    public void testArchiveCompletedReservations() {
        InMemoryPlan plan = new InMemoryPlan(this.queueMetrics, this.policy, this.agent, this.totalCapacity, 1L, this.resCalc, this.minAlloc, this.maxAlloc, this.planName, this.replanner, true, this.context);
        ReservationId reservationID1 = ReservationSystemTestUtil.getNewReservationId();
        int[] alloc1 = new int[]{10, 10, 10, 10, 10, 10};
        int start = 100;
        ReservationAllocation rAllocation = this.createReservationAllocation(reservationID1, start, alloc1);
        Assert.assertNull((Object)plan.getReservationById(reservationID1));
        try {
            plan.addReservation(rAllocation, false);
        }
        catch (PlanningException e) {
            Assert.fail((String)e.getMessage());
        }
        this.doAssertions((Plan)plan, rAllocation);
        this.checkAllocation((Plan)plan, alloc1, start);
        ReservationId reservationID2 = ReservationSystemTestUtil.getNewReservationId();
        int[] alloc2 = new int[]{0, 5, 10, 5, 0};
        rAllocation = this.createReservationAllocation(reservationID2, start, alloc2, true);
        Assert.assertNull((Object)plan.getReservationById(reservationID2));
        try {
            plan.addReservation(rAllocation, false);
        }
        catch (PlanningException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)plan.getReservationById(reservationID2));
        RLESparseResourceAllocation userCons = plan.getConsumptionForUserOverTime(this.user, (long)start, (long)(start + alloc2.length));
        for (int i = 0; i < alloc2.length; ++i) {
            Assert.assertEquals((Object)Resource.newInstance((int)(1024 * (alloc1[i] + alloc2[i] + i)), (int)(alloc1[i] + alloc2[i] + i)), (Object)plan.getTotalCommittedResources((long)(start + i)));
            Assert.assertEquals((Object)Resource.newInstance((int)(1024 * (alloc1[i] + alloc2[i] + i)), (int)(alloc1[i] + alloc2[i] + i)), (Object)userCons.getCapacityAtTime((long)(start + i)));
        }
        Mockito.when((Object)this.clock.getTime()).thenReturn((Object)106L);
        Mockito.when((Object)this.policy.getValidWindow()).thenReturn((Object)1L);
        try {
            plan.archiveCompletedReservations(this.clock.getTime());
        }
        catch (PlanningException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((Object)plan.getReservationById(reservationID1));
        Assert.assertNull((Object)plan.getReservationById(reservationID2));
        this.checkAllocation((Plan)plan, alloc1, start);
        Mockito.when((Object)this.clock.getTime()).thenReturn((Object)107L);
        try {
            plan.archiveCompletedReservations(this.clock.getTime());
        }
        catch (PlanningException e) {
            Assert.fail((String)e.getMessage());
        }
        userCons = plan.getConsumptionForUserOverTime(this.user, (long)start, (long)(start + alloc1.length));
        Assert.assertNull((Object)plan.getReservationById(reservationID1));
        for (int i = 0; i < alloc1.length; ++i) {
            Assert.assertEquals((Object)Resource.newInstance((int)0, (int)0), (Object)plan.getTotalCommittedResources((long)(start + i)));
            Assert.assertEquals((Object)Resource.newInstance((int)0, (int)0), (Object)userCons.getCapacityAtTime((long)(start + i)));
        }
    }

    @Test
    public void testGetReservationsById() {
        InMemoryPlan plan = new InMemoryPlan(this.queueMetrics, this.policy, this.agent, this.totalCapacity, 1L, this.resCalc, this.minAlloc, this.maxAlloc, this.planName, this.replanner, true, this.context);
        ReservationId reservationID = ReservationSystemTestUtil.getNewReservationId();
        int[] alloc = new int[]{10, 10, 10, 10, 10, 10};
        int start = 100;
        ReservationAllocation rAllocation = this.createReservationAllocation(reservationID, start, alloc);
        Assert.assertNull((Object)plan.getReservationById(reservationID));
        try {
            plan.addReservation(rAllocation, false);
        }
        catch (PlanningException e) {
            Assert.fail((String)e.getMessage());
        }
        Set rAllocations = plan.getReservations(reservationID, null, "");
        Assert.assertTrue((rAllocations.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((rAllocation.compareTo((Object)((ReservationAllocation)rAllocations.toArray()[0])) == 0 ? 1 : 0) != 0);
        ReservationInterval interval = new ReservationInterval(0L, 0L);
        rAllocations = plan.getReservations(reservationID, interval, "invalid");
        Assert.assertTrue((rAllocations.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((rAllocation.compareTo((Object)((ReservationAllocation)rAllocations.toArray()[0])) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGetReservationsByInvalidId() {
        InMemoryPlan plan = new InMemoryPlan(this.queueMetrics, this.policy, this.agent, this.totalCapacity, 1L, this.resCalc, this.minAlloc, this.maxAlloc, this.planName, this.replanner, true, this.context);
        ReservationId reservationID = ReservationSystemTestUtil.getNewReservationId();
        int[] alloc = new int[]{10, 10, 10, 10, 10, 10};
        int start = 100;
        ReservationAllocation rAllocation = this.createReservationAllocation(reservationID, start, alloc);
        Assert.assertNull((Object)plan.getReservationById(reservationID));
        try {
            plan.addReservation(rAllocation, false);
        }
        catch (PlanningException e) {
            Assert.fail((String)e.getMessage());
        }
        ReservationId invalidReservationID = ReservationSystemTestUtil.getNewReservationId();
        Set rAllocations = plan.getReservations(invalidReservationID, null, "");
        Assert.assertTrue((rAllocations.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGetReservationsByTimeInterval() {
        InMemoryPlan plan = new InMemoryPlan(this.queueMetrics, this.policy, this.agent, this.totalCapacity, 1L, this.resCalc, this.minAlloc, this.maxAlloc, this.planName, this.replanner, true, this.context);
        ReservationId reservationID = ReservationSystemTestUtil.getNewReservationId();
        int[] alloc = new int[]{10, 10, 10, 10, 10, 10};
        int start = 100;
        ReservationAllocation rAllocation = this.createReservationAllocation(reservationID, start, alloc);
        Assert.assertNull((Object)plan.getReservationById(reservationID));
        try {
            plan.addReservation(rAllocation, false);
        }
        catch (PlanningException e) {
            Assert.fail((String)e.getMessage());
        }
        ReservationInterval interval = new ReservationInterval(rAllocation.getStartTime(), rAllocation.getEndTime());
        Set rAllocations = plan.getReservations(null, interval, "");
        Assert.assertTrue((rAllocations.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((rAllocation.compareTo((Object)((ReservationAllocation)rAllocations.toArray()[0])) == 0 ? 1 : 0) != 0);
        long duration = rAllocation.getEndTime() - rAllocation.getStartTime();
        interval = new ReservationInterval(rAllocation.getStartTime() + duration * 0L, rAllocation.getEndTime() - duration * 0L);
        rAllocations = plan.getReservations(null, interval, "");
        Assert.assertTrue((rAllocations.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((rAllocation.compareTo((Object)((ReservationAllocation)rAllocations.toArray()[0])) == 0 ? 1 : 0) != 0);
        interval = new ReservationInterval(0L, rAllocation.getStartTime());
        rAllocations = plan.getReservations(null, interval, "");
        Assert.assertTrue((rAllocations.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((rAllocation.compareTo((Object)((ReservationAllocation)rAllocations.toArray()[0])) == 0 ? 1 : 0) != 0);
        interval = new ReservationInterval(rAllocation.getEndTime(), Long.MAX_VALUE);
        rAllocations = plan.getReservations(null, interval, "");
        Assert.assertTrue((rAllocations.size() == 0 ? 1 : 0) != 0);
        interval = new ReservationInterval(0L, rAllocation.getStartTime() / 2L);
        rAllocations = plan.getReservations(null, interval, "");
        Assert.assertTrue((rAllocations.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGetReservationsAtTime() {
        InMemoryPlan plan = new InMemoryPlan(this.queueMetrics, this.policy, this.agent, this.totalCapacity, 1L, this.resCalc, this.minAlloc, this.maxAlloc, this.planName, this.replanner, true, this.context);
        ReservationId reservationID = ReservationSystemTestUtil.getNewReservationId();
        int[] alloc = new int[]{10, 10, 10, 10, 10, 10};
        int start = 100;
        ReservationAllocation rAllocation = this.createReservationAllocation(reservationID, start, alloc);
        Assert.assertNull((Object)plan.getReservationById(reservationID));
        try {
            plan.addReservation(rAllocation, false);
        }
        catch (PlanningException e) {
            Assert.fail((String)e.getMessage());
        }
        Set rAllocations = plan.getReservationsAtTime(rAllocation.getStartTime());
        Assert.assertTrue((rAllocations.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((rAllocation.compareTo((Object)((ReservationAllocation)rAllocations.toArray()[0])) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGetReservationsWithNoInput() {
        InMemoryPlan plan = new InMemoryPlan(this.queueMetrics, this.policy, this.agent, this.totalCapacity, 1L, this.resCalc, this.minAlloc, this.maxAlloc, this.planName, this.replanner, true, this.context);
        ReservationId reservationID = ReservationSystemTestUtil.getNewReservationId();
        int[] alloc = new int[]{10, 10, 10, 10, 10, 10};
        int start = 100;
        ReservationAllocation rAllocation = this.createReservationAllocation(reservationID, start, alloc);
        Assert.assertNull((Object)plan.getReservationById(reservationID));
        try {
            plan.addReservation(rAllocation, false);
        }
        catch (PlanningException e) {
            Assert.fail((String)e.getMessage());
        }
        Set rAllocations = plan.getReservations(null, null, "");
        Assert.assertTrue((rAllocations.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((rAllocation.compareTo((Object)((ReservationAllocation)rAllocations.toArray()[0])) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGetReservationsWithNoReservation() {
        InMemoryPlan plan = new InMemoryPlan(this.queueMetrics, this.policy, this.agent, this.totalCapacity, 1L, this.resCalc, this.minAlloc, this.maxAlloc, this.planName, this.replanner, true, this.context);
        ReservationInterval interval = new ReservationInterval(0L, Long.MAX_VALUE);
        Set rAllocations = plan.getReservations(null, interval, "");
        Assert.assertTrue((rAllocations.size() == 0 ? 1 : 0) != 0);
    }

    private void doAssertions(Plan plan, ReservationAllocation rAllocation) {
        ReservationId reservationID = rAllocation.getReservationId();
        Assert.assertNotNull((Object)plan.getReservationById(reservationID));
        Assert.assertEquals((Object)rAllocation, (Object)plan.getReservationById(reservationID));
        Assert.assertTrue((((InMemoryPlan)plan).getAllReservations().size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((long)rAllocation.getEndTime(), (long)plan.getLastEndTime());
        Assert.assertEquals((Object)this.totalCapacity, (Object)plan.getTotalCapacity());
        Assert.assertEquals((Object)this.minAlloc, (Object)plan.getMinimumAllocation());
        Assert.assertEquals((Object)this.maxAlloc, (Object)plan.getMaximumAllocation());
        Assert.assertEquals((Object)this.resCalc, (Object)plan.getResourceCalculator());
        Assert.assertEquals((Object)this.planName, (Object)plan.getQueueName());
        Assert.assertTrue((boolean)plan.getMoveOnExpiry());
    }

    private ReservationDefinition createSimpleReservationDefinition(long arrival, long deadline, long duration, Collection<ReservationRequest> resources) {
        ReservationDefinitionPBImpl rDef = new ReservationDefinitionPBImpl();
        ReservationRequestsPBImpl reqs = new ReservationRequestsPBImpl();
        reqs.setReservationResources(new ArrayList<ReservationRequest>(resources));
        reqs.setInterpreter(ReservationRequestInterpreter.R_ALL);
        rDef.setReservationRequests((ReservationRequests)reqs);
        rDef.setArrival(arrival);
        rDef.setDeadline(deadline);
        return rDef;
    }

    private Map<ReservationInterval, ReservationRequest> generateAllocation(int startTime, int[] alloc, boolean isStep) {
        HashMap<ReservationInterval, ReservationRequest> req = new HashMap<ReservationInterval, ReservationRequest>();
        int numContainers = 0;
        for (int i = 0; i < alloc.length; ++i) {
            numContainers = isStep ? alloc[i] + i : alloc[i];
            ReservationRequest rr = ReservationRequest.newInstance((Resource)Resource.newInstance((int)1024, (int)1), (int)numContainers);
            req.put(new ReservationInterval((long)(startTime + i), (long)(startTime + i + 1)), rr);
        }
        return req;
    }

    private ReservationAllocation createReservationAllocation(ReservationId reservationID, int start, int[] alloc) {
        return this.createReservationAllocation(reservationID, start, alloc, false);
    }

    private ReservationAllocation createReservationAllocation(ReservationId reservationID, int start, int[] alloc, boolean isStep) {
        Map<ReservationInterval, ReservationRequest> allocations = this.generateAllocation(start, alloc, isStep);
        ReservationDefinition rDef = this.createSimpleReservationDefinition(start, start + alloc.length, alloc.length, allocations.values());
        Map allocs = ReservationSystemUtil.toResources(allocations);
        return new InMemoryReservationAllocation(reservationID, rDef, this.user, this.planName, (long)start, (long)(start + alloc.length), allocs, this.resCalc, this.minAlloc);
    }
}

